/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model;

import java.lang.reflect.Constructor;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.resource.beans.spi.BeanInstanceProducer;
import org.hibernate.type.spi.TypeBootstrapContext;
import org.hibernate.type.spi.TypeConfiguration;

public class TypeBeanInstanceProducer
implements BeanInstanceProducer,
TypeBootstrapContext {
    private final TypeConfiguration typeConfiguration;

    public TypeBeanInstanceProducer(TypeConfiguration typeConfiguration) {
        this.typeConfiguration = typeConfiguration;
    }

    @Override
    public <B> B produceBeanInstance(Class<B> beanType) {
        try {
            Constructor<B> bootstrapContextAwareTypeConstructor = ReflectHelper.getConstructor(beanType, TypeBootstrapContext.class);
            B type = bootstrapContextAwareTypeConstructor != null ? bootstrapContextAwareTypeConstructor.newInstance(this) : beanType.newInstance();
            return type;
        }
        catch (Exception e) {
            throw new MappingException("Could not instantiate Type: " + beanType.getName(), e);
        }
    }

    @Override
    public <B> B produceBeanInstance(String name, Class<B> beanType) {
        return this.produceBeanInstance(beanType);
    }

    @Override
    public Map<String, Object> getConfigurationSettings() {
        return this.typeConfiguration.getServiceRegistry().getService(ConfigurationService.class).getSettings();
    }
}

