/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.descriptor.java.JavaType;
import org.jboss.logging.Logger;

public final class Versioning {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)Versioning.class.getName());

    private Versioning() {
    }

    private static Object seed(EntityVersionMapping versionMapping, SharedSessionContractImplementor session) {
        Object seed = versionMapping.getJavaType().seed(versionMapping.getLength(), versionMapping.getPrecision(), versionMapping.getScale(), session);
        LOG.tracef("Seeding: %s", seed);
        return seed;
    }

    public static boolean seedVersion(Object[] fields, int versionProperty, EntityVersionMapping versionMapping, SharedSessionContractImplementor session) {
        Object initialVersion = fields[versionProperty];
        if (initialVersion == null || initialVersion instanceof Number && ((Number)initialVersion).longValue() < 0L) {
            fields[versionProperty] = Versioning.seed(versionMapping, session);
            return true;
        }
        LOG.tracev("Using initial version: {0}", initialVersion);
        return false;
    }

    public static Object increment(Object version, EntityVersionMapping versionMapping, SharedSessionContractImplementor session) {
        JavaType versionType = versionMapping.getJavaType();
        Object next = versionType.next(version, versionMapping.getLength(), versionMapping.getPrecision(), versionMapping.getScale(), session);
        if (LOG.isTraceEnabled()) {
            LOG.tracef("Incrementing: %s to %s", versionType.toString(version), versionType.toString(next));
        }
        return next;
    }

    public static void setVersion(Object[] fields, Object version, EntityPersister persister) {
        if (!persister.isVersioned()) {
            return;
        }
        fields[persister.getVersionProperty()] = version;
    }

    public static Object getVersion(Object[] fields, EntityPersister persister) {
        if (!persister.isVersioned()) {
            return null;
        }
        return fields[persister.getVersionProperty()];
    }

    public static boolean isVersionIncrementRequired(int[] dirtyProperties, boolean hasDirtyCollections, boolean[] propertyVersionability) {
        if (hasDirtyCollections) {
            return true;
        }
        for (int dirtyProperty : dirtyProperties) {
            if (!propertyVersionability[dirtyProperty]) continue;
            return true;
        }
        return false;
    }
}

