/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal;

import java.util.Map;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.jpa.internal.JpaComplianceImpl;
import org.hibernate.jpa.spi.JpaCompliance;
import org.hibernate.jpa.spi.MutableJpaCompliance;

public class MutableJpaComplianceImpl
implements MutableJpaCompliance {
    private boolean listCompliance;
    private boolean orderByMappingCompliance;
    private boolean proxyCompliance;
    private boolean generatorNameScopeCompliance;
    private boolean queryCompliance;
    private boolean transactionCompliance;
    private boolean closedCompliance;
    private boolean cachingCompliance;
    private boolean loadByIdCompliance;

    public MutableJpaComplianceImpl(Map configurationSettings) {
        this(configurationSettings, ConfigurationHelper.getBoolean("hibernate.jpa.compliance", configurationSettings, false));
    }

    public MutableJpaComplianceImpl(Map configurationSettings, boolean jpaByDefault) {
        Object legacyQueryCompliance = configurationSettings.get("hibernate.query.jpaql_strict_compliance");
        this.listCompliance = ConfigurationHelper.getBoolean("hibernate.jpa.compliance.list", configurationSettings, jpaByDefault);
        this.proxyCompliance = ConfigurationHelper.getBoolean("hibernate.jpa.compliance.proxy", configurationSettings, jpaByDefault);
        this.generatorNameScopeCompliance = ConfigurationHelper.getBoolean("hibernate.jpa.compliance.global_id_generators", configurationSettings, jpaByDefault);
        this.orderByMappingCompliance = ConfigurationHelper.getBoolean("hibernate.jpa.compliance.orderby", configurationSettings, jpaByDefault);
        this.queryCompliance = ConfigurationHelper.getBoolean("hibernate.jpa.compliance.query", configurationSettings, ConfigurationHelper.toBoolean(legacyQueryCompliance, jpaByDefault));
        this.transactionCompliance = ConfigurationHelper.getBoolean("hibernate.jpa.compliance.transaction", configurationSettings, jpaByDefault);
        this.closedCompliance = ConfigurationHelper.getBoolean("hibernate.jpa.compliance.closed", configurationSettings, jpaByDefault);
        this.cachingCompliance = ConfigurationHelper.getBoolean("hibernate.jpa.compliance.caching", configurationSettings, jpaByDefault);
        this.loadByIdCompliance = ConfigurationHelper.getBoolean("hibernate.jpa.compliance.load_by_id", configurationSettings, jpaByDefault);
    }

    @Override
    public boolean isJpaQueryComplianceEnabled() {
        return this.queryCompliance;
    }

    @Override
    public boolean isJpaTransactionComplianceEnabled() {
        return this.transactionCompliance;
    }

    @Override
    public boolean isJpaListComplianceEnabled() {
        return this.listCompliance;
    }

    @Override
    public boolean isJpaClosedComplianceEnabled() {
        return this.closedCompliance;
    }

    @Override
    public boolean isJpaProxyComplianceEnabled() {
        return this.proxyCompliance;
    }

    @Override
    public boolean isJpaCacheComplianceEnabled() {
        return this.cachingCompliance;
    }

    @Override
    public boolean isGlobalGeneratorScopeEnabled() {
        return this.generatorNameScopeCompliance;
    }

    @Override
    public boolean isJpaOrderByMappingComplianceEnabled() {
        return this.orderByMappingCompliance;
    }

    @Override
    public boolean isLoadByIdComplianceEnabled() {
        return this.loadByIdCompliance;
    }

    @Override
    public void setListCompliance(boolean listCompliance) {
        this.listCompliance = listCompliance;
    }

    @Override
    public void setOrderByMappingCompliance(boolean orderByMappingCompliance) {
        this.orderByMappingCompliance = orderByMappingCompliance;
    }

    @Override
    public void setProxyCompliance(boolean proxyCompliance) {
        this.proxyCompliance = proxyCompliance;
    }

    @Override
    public void setGeneratorNameScopeCompliance(boolean enabled) {
        this.generatorNameScopeCompliance = enabled;
    }

    @Override
    public void setQueryCompliance(boolean queryCompliance) {
        this.queryCompliance = queryCompliance;
    }

    @Override
    public void setTransactionCompliance(boolean transactionCompliance) {
        this.transactionCompliance = transactionCompliance;
    }

    @Override
    public void setClosedCompliance(boolean closedCompliance) {
        this.closedCompliance = closedCompliance;
    }

    @Override
    public void setCachingCompliance(boolean cachingCompliance) {
        this.cachingCompliance = cachingCompliance;
    }

    @Override
    public void setLoadByIdCompliance(boolean enabled) {
        this.loadByIdCompliance = enabled;
    }

    @Override
    public JpaCompliance immutableCopy() {
        JpaComplianceImpl.JpaComplianceBuilder builder = new JpaComplianceImpl.JpaComplianceBuilder();
        builder = builder.setListCompliance(this.listCompliance).setProxyCompliance(this.proxyCompliance).setOrderByMappingCompliance(this.orderByMappingCompliance).setGlobalGeneratorNameCompliance(this.generatorNameScopeCompliance).setQueryCompliance(this.queryCompliance).setTransactionCompliance(this.transactionCompliance).setClosedCompliance(this.closedCompliance).setCachingCompliance(this.cachingCompliance).setLoadByIdCompliance(this.loadByIdCompliance);
        return builder.createJpaCompliance();
    }
}

