/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.convert.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.convert.spi.EnumValueConverter;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.EnumJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class OrdinalEnumValueConverter<E extends Enum<E>>
implements EnumValueConverter<E, Number>,
Serializable {
    private final EnumJavaType<E> enumJavaType;
    private final JdbcType jdbcType;
    private final JavaType<Number> relationalJavaType;
    private transient ValueExtractor<Number> valueExtractor;
    private transient ValueBinder<Number> valueBinder;

    public OrdinalEnumValueConverter(EnumJavaType<E> enumJavaType, JdbcType jdbcType, JavaType<Number> relationalJavaType) {
        this.enumJavaType = enumJavaType;
        this.jdbcType = jdbcType;
        this.relationalJavaType = relationalJavaType;
        this.valueExtractor = jdbcType.getExtractor(relationalJavaType);
        this.valueBinder = jdbcType.getBinder(relationalJavaType);
    }

    @Override
    public E toDomainValue(Number relationalForm) {
        return this.enumJavaType.fromOrdinal(relationalForm == null ? null : Integer.valueOf(relationalForm.intValue()));
    }

    @Override
    public Number toRelationalValue(E domainForm) {
        return this.enumJavaType.toOrdinal(domainForm);
    }

    @Override
    public int getJdbcTypeCode() {
        return this.jdbcType.getJdbcTypeCode();
    }

    @Override
    public EnumJavaType<E> getDomainJavaType() {
        return this.enumJavaType;
    }

    @Override
    public JavaType<Number> getRelationalJavaType() {
        return this.relationalJavaType;
    }

    @Override
    public String toSqlLiteral(Object value) {
        return Integer.toString(((Enum)value).ordinal());
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        stream.defaultReadObject();
        this.valueExtractor = this.jdbcType.getExtractor(this.relationalJavaType);
        this.valueBinder = this.jdbcType.getBinder(this.relationalJavaType);
    }

    @Override
    public void writeValue(PreparedStatement statement, E value, int position, SharedSessionContractImplementor session) throws SQLException {
        this.valueBinder.bind(statement, this.toRelationalValue(value), position, (WrapperOptions)session);
    }
}

