/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.select.QueryPart;

public class ModifiedSubQueryExpression
implements Expression {
    private final QueryPart subQuery;
    private final Modifier modifier;

    public ModifiedSubQueryExpression(QueryPart subQuery, Modifier modifier) {
        this.subQuery = subQuery;
        this.modifier = modifier;
    }

    public QueryPart getSubQuery() {
        return this.subQuery;
    }

    public Modifier getModifier() {
        return this.modifier;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitModifiedSubQueryExpression(this);
    }

    @Override
    public JdbcMappingContainer getExpressionType() {
        return this.subQuery.getExpressionType();
    }

    public static enum Modifier {
        ALL("all"),
        ANY("any"),
        SOME("some");

        private final String sqlName;

        private Modifier(String sqlName) {
            this.sqlName = sqlName;
        }

        public String getSqlName() {
            return this.sqlName;
        }
    }
}

