/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import jakarta.persistence.TemporalType;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.hibernate.HibernateException;
import org.hibernate.cache.internal.CacheKeyValueDescriptor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTemporalJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;
import org.hibernate.type.descriptor.java.TemporalJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class JdbcDateJavaType
extends AbstractTemporalJavaType<java.util.Date> {
    public static final JdbcDateJavaType INSTANCE = new JdbcDateJavaType();
    public static final String DATE_FORMAT = "dd MMMM yyyy";
    public static final DateTimeFormatter LITERAL_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE;
    private static final CacheKeyValueDescriptor CACHE_KEY_VALUE_DESCRIPTOR = new CacheKeyValueDescriptor(){

        @Override
        public int getHashCode(Object key) {
            return INSTANCE.extractHashCode((java.util.Date)key);
        }

        @Override
        public boolean isEqual(Object key1, Object key2) {
            return INSTANCE.areEqual((java.util.Date)key1, (java.util.Date)key2);
        }
    };

    public JdbcDateJavaType() {
        super(Date.class, DateMutabilityPlan.INSTANCE);
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.DATE;
    }

    @Override
    public boolean isInstance(Object value) {
        return value instanceof java.util.Date && !(value instanceof Time);
    }

    @Override
    public boolean areEqual(java.util.Date one, java.util.Date another) {
        if (one == another) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        if (one.getTime() == another.getTime()) {
            return true;
        }
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar1.setTime(one);
        calendar2.setTime(another);
        return calendar1.get(2) == calendar2.get(2) && calendar1.get(5) == calendar2.get(5) && calendar1.get(1) == calendar2.get(1);
    }

    @Override
    public int extractHashCode(java.util.Date value) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(value);
        int hashCode = 1;
        hashCode = 31 * hashCode + calendar.get(2);
        hashCode = 31 * hashCode + calendar.get(5);
        hashCode = 31 * hashCode + calendar.get(1);
        return hashCode;
    }

    @Override
    public CacheKeyValueDescriptor toCacheKeyDescriptor(SessionFactoryImplementor sessionFactory) {
        return CACHE_KEY_VALUE_DESCRIPTOR;
    }

    @Override
    public java.util.Date coerce(Object value, JavaType.CoercionContext coercionContext) {
        return this.wrap(value, (WrapperOptions)null);
    }

    @Override
    public Object unwrap(java.util.Date value, Class type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (LocalDate.class.isAssignableFrom(type)) {
            return this.unwrapLocalDate(value);
        }
        if (Date.class.isAssignableFrom(type)) {
            return this.unwrapSqlDate(value);
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return value;
        }
        if (Long.class.isAssignableFrom(type)) {
            return JdbcDateJavaType.unwrapDateEpoch(value);
        }
        if (String.class.isAssignableFrom(type)) {
            return this.toString(value);
        }
        if (Calendar.class.isAssignableFrom(type)) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTimeInMillis(JdbcDateJavaType.unwrapDateEpoch(value));
            return cal;
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            return new Timestamp(value.getTime());
        }
        if (Time.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Illegal attempt to treat `java.sql.Date` as `java.sql.Time`");
        }
        throw this.unknownUnwrap(type);
    }

    private LocalDate unwrapLocalDate(java.util.Date value) {
        return value instanceof Date ? ((Date)value).toLocalDate() : new Date(value.getTime()).toLocalDate();
    }

    private Date unwrapSqlDate(java.util.Date value) {
        return value instanceof Date ? (Date)value : new Date(value.getTime());
    }

    private static long unwrapDateEpoch(java.util.Date value) {
        return value.getTime();
    }

    @Override
    public java.util.Date wrap(Object value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        if (value instanceof Calendar) {
            return new Date(((Calendar)value).getTimeInMillis());
        }
        if (value instanceof java.util.Date) {
            return new Date(((java.util.Date)value).getTime());
        }
        if (value instanceof LocalDate) {
            return Date.valueOf((LocalDate)value);
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public String toString(java.util.Date value) {
        return new SimpleDateFormat(DATE_FORMAT).format(value);
    }

    @Override
    public java.util.Date fromString(CharSequence string) {
        try {
            return new Date(new SimpleDateFormat(DATE_FORMAT).parse(string.toString()).getTime());
        }
        catch (ParseException pe) {
            throw new HibernateException("could not parse date string" + string, pe);
        }
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators context) {
        return context.getTypeConfiguration().getJdbcTypeRegistry().getDescriptor(91);
    }

    @Override
    protected <X> TemporalJavaType<X> forDatePrecision(TypeConfiguration typeConfiguration) {
        return this;
    }

    public static class DateMutabilityPlan
    extends MutableMutabilityPlan<java.util.Date> {
        public static final DateMutabilityPlan INSTANCE = new DateMutabilityPlan();

        @Override
        public java.util.Date deepCopyNotNull(java.util.Date value) {
            if (value instanceof Date) {
                return value;
            }
            return new Date(value.getTime());
        }
    }
}

