/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.io.Serializable;
import org.hibernate.Incubating;
import org.hibernate.query.sqm.CastType;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcTypeJavaClassMappings;
import org.hibernate.type.spi.TypeConfiguration;

public interface JdbcType
extends Serializable {
    default public String getFriendlyName() {
        return Integer.toString(this.getDefaultSqlTypeCode());
    }

    public int getJdbcTypeCode();

    default public int getDefaultSqlTypeCode() {
        return this.getJdbcTypeCode();
    }

    default public <T> BasicJavaType<T> getJdbcRecommendedJavaTypeMapping(Integer precision, Integer scale, TypeConfiguration typeConfiguration) {
        return (BasicJavaType)typeConfiguration.getJavaTypeRegistry().getDescriptor(JdbcTypeJavaClassMappings.INSTANCE.determineJavaClassForJdbcTypeCode(this.getDefaultSqlTypeCode()));
    }

    default public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        return (appender, value, dialect, wrapperOptions) -> appender.appendSql(value.toString());
    }

    public <X> ValueBinder<X> getBinder(JavaType<X> var1);

    public <X> ValueExtractor<X> getExtractor(JavaType<X> var1);

    @Incubating
    default public Class<?> getPreferredJavaTypeClass(WrapperOptions options) {
        return null;
    }

    default public boolean isInteger() {
        return JdbcType.isInteger(this.getJdbcTypeCode());
    }

    public static boolean isInteger(int typeCode) {
        switch (typeCode) {
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    default public boolean isFloat() {
        return JdbcType.isFloat(this.getJdbcTypeCode());
    }

    public static boolean isFloat(int typeCode) {
        switch (typeCode) {
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    default public boolean isDecimal() {
        return JdbcType.isDecimal(this.getJdbcTypeCode());
    }

    public static boolean isDecimal(int typeCode) {
        switch (typeCode) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    default public boolean isNumber() {
        return JdbcType.isNumber(this.getJdbcTypeCode());
    }

    public static boolean isNumber(int typeCode) {
        switch (typeCode) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    default public boolean isBinary() {
        return JdbcType.isBinary(this.getJdbcTypeCode());
    }

    public static boolean isBinary(int typeCode) {
        switch (typeCode) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return true;
            }
        }
        return false;
    }

    default public boolean isString() {
        return JdbcType.isString(this.getJdbcTypeCode());
    }

    public static boolean isString(int typeCode) {
        switch (typeCode) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: 
            case 2011: {
                return true;
            }
        }
        return false;
    }

    default public boolean isTemporal() {
        return JdbcType.isTemporal(this.getDefaultSqlTypeCode());
    }

    public static boolean isTemporal(int typeCode) {
        switch (typeCode) {
            case 91: 
            case 92: 
            case 93: 
            case 2014: {
                return true;
            }
        }
        return false;
    }

    default public boolean isInterval() {
        return JdbcType.isInterval(this.getDefaultSqlTypeCode());
    }

    public static boolean isInterval(int typeCode) {
        switch (typeCode) {
            case 3100: {
                return true;
            }
        }
        return false;
    }

    default public CastType getCastType() {
        return JdbcType.getCastType(this.getJdbcTypeCode());
    }

    public static CastType getCastType(int typeCode) {
        switch (typeCode) {
            case -6: 
            case 4: 
            case 5: {
                return CastType.INTEGER;
            }
            case -5: {
                return CastType.LONG;
            }
            case 6: 
            case 7: {
                return CastType.FLOAT;
            }
            case 8: {
                return CastType.DOUBLE;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return CastType.STRING;
            }
            case 16: {
                return CastType.BOOLEAN;
            }
            case 2: 
            case 3: {
                return CastType.FIXED;
            }
            case 91: {
                return CastType.DATE;
            }
            case 92: {
                return CastType.TIME;
            }
            case 93: {
                return CastType.TIMESTAMP;
            }
            case 2014: {
                return CastType.OFFSET_TIMESTAMP;
            }
            case 0: {
                return CastType.NULL;
            }
        }
        return CastType.OTHER;
    }
}

