/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.allarmi.utils.serializer;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import javax.xml.bind.JAXBElement;
import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.allarmi.AllarmeFiltro;
import org.openspcoop2.core.allarmi.AllarmeHistory;
import org.openspcoop2.core.allarmi.AllarmeMail;
import org.openspcoop2.core.allarmi.AllarmeNotifica;
import org.openspcoop2.core.allarmi.AllarmeParametro;
import org.openspcoop2.core.allarmi.AllarmeRaggruppamento;
import org.openspcoop2.core.allarmi.AllarmeScript;
import org.openspcoop2.core.allarmi.ElencoAllarmi;
import org.openspcoop2.core.allarmi.ElencoIdAllarmi;
import org.openspcoop2.core.allarmi.IdAllarme;
import org.openspcoop2.generic_project.exception.SerializerException;
import org.openspcoop2.utils.beans.WriteToSerializerType;
import org.openspcoop2.utils.xml.JaxbUtils;

public abstract class AbstractSerializer {
    protected abstract WriteToSerializerType getType();

    protected void _objToXml(OutputStream out, Class<?> c, Object object, boolean prettyPrint) throws Exception {
        if (object instanceof JAXBElement) {
            JaxbUtils.objToXml((OutputStream)out, c, (Object)object, (boolean)prettyPrint);
        } else {
            Method m = c.getMethod("writeTo", OutputStream.class, WriteToSerializerType.class);
            m.invoke(object, out, this.getType());
        }
    }

    protected void objToXml(OutputStream out, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        try {
            this._objToXml(out, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                out.flush();
            }
            catch (Exception exception) {}
        }
    }

    protected void objToXml(String fileName, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        try {
            this.objToXml(new File(fileName), c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
    }

    protected void objToXml(File file, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            this._objToXml(fout, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.flush();
                }
            }
            catch (Exception exception) {}
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected ByteArrayOutputStream objToXml(Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        ByteArrayOutputStream bout = null;
        try {
            bout = new ByteArrayOutputStream();
            this._objToXml(bout, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (bout != null) {
                    bout.flush();
                }
            }
            catch (Exception exception) {}
            try {
                if (bout != null) {
                    bout.close();
                }
            }
            catch (Exception exception) {}
        }
        return bout;
    }

    public void write(String fileName, IdAllarme idAllarme) throws SerializerException {
        this.objToXml(fileName, IdAllarme.class, (Object)idAllarme, false);
    }

    public void write(String fileName, IdAllarme idAllarme, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, IdAllarme.class, (Object)idAllarme, prettyPrint);
    }

    public void write(File file, IdAllarme idAllarme) throws SerializerException {
        this.objToXml(file, IdAllarme.class, (Object)idAllarme, false);
    }

    public void write(File file, IdAllarme idAllarme, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, IdAllarme.class, (Object)idAllarme, prettyPrint);
    }

    public void write(OutputStream out, IdAllarme idAllarme) throws SerializerException {
        this.objToXml(out, IdAllarme.class, (Object)idAllarme, false);
    }

    public void write(OutputStream out, IdAllarme idAllarme, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, IdAllarme.class, (Object)idAllarme, prettyPrint);
    }

    public byte[] toByteArray(IdAllarme idAllarme) throws SerializerException {
        return this.objToXml(IdAllarme.class, idAllarme, false).toByteArray();
    }

    public byte[] toByteArray(IdAllarme idAllarme, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IdAllarme.class, idAllarme, prettyPrint).toByteArray();
    }

    public String toString(IdAllarme idAllarme) throws SerializerException {
        return this.objToXml(IdAllarme.class, idAllarme, false).toString();
    }

    public String toString(IdAllarme idAllarme, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IdAllarme.class, idAllarme, prettyPrint).toString();
    }

    public void write(String fileName, AllarmeHistory allarmeHistory) throws SerializerException {
        this.objToXml(fileName, AllarmeHistory.class, (Object)allarmeHistory, false);
    }

    public void write(String fileName, AllarmeHistory allarmeHistory, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, AllarmeHistory.class, (Object)allarmeHistory, prettyPrint);
    }

    public void write(File file, AllarmeHistory allarmeHistory) throws SerializerException {
        this.objToXml(file, AllarmeHistory.class, (Object)allarmeHistory, false);
    }

    public void write(File file, AllarmeHistory allarmeHistory, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, AllarmeHistory.class, (Object)allarmeHistory, prettyPrint);
    }

    public void write(OutputStream out, AllarmeHistory allarmeHistory) throws SerializerException {
        this.objToXml(out, AllarmeHistory.class, (Object)allarmeHistory, false);
    }

    public void write(OutputStream out, AllarmeHistory allarmeHistory, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, AllarmeHistory.class, (Object)allarmeHistory, prettyPrint);
    }

    public byte[] toByteArray(AllarmeHistory allarmeHistory) throws SerializerException {
        return this.objToXml(AllarmeHistory.class, allarmeHistory, false).toByteArray();
    }

    public byte[] toByteArray(AllarmeHistory allarmeHistory, boolean prettyPrint) throws SerializerException {
        return this.objToXml(AllarmeHistory.class, allarmeHistory, prettyPrint).toByteArray();
    }

    public String toString(AllarmeHistory allarmeHistory) throws SerializerException {
        return this.objToXml(AllarmeHistory.class, allarmeHistory, false).toString();
    }

    public String toString(AllarmeHistory allarmeHistory, boolean prettyPrint) throws SerializerException {
        return this.objToXml(AllarmeHistory.class, allarmeHistory, prettyPrint).toString();
    }

    public void write(String fileName, AllarmeMail allarmeMail) throws SerializerException {
        this.objToXml(fileName, AllarmeMail.class, (Object)allarmeMail, false);
    }

    public void write(String fileName, AllarmeMail allarmeMail, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, AllarmeMail.class, (Object)allarmeMail, prettyPrint);
    }

    public void write(File file, AllarmeMail allarmeMail) throws SerializerException {
        this.objToXml(file, AllarmeMail.class, (Object)allarmeMail, false);
    }

    public void write(File file, AllarmeMail allarmeMail, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, AllarmeMail.class, (Object)allarmeMail, prettyPrint);
    }

    public void write(OutputStream out, AllarmeMail allarmeMail) throws SerializerException {
        this.objToXml(out, AllarmeMail.class, (Object)allarmeMail, false);
    }

    public void write(OutputStream out, AllarmeMail allarmeMail, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, AllarmeMail.class, (Object)allarmeMail, prettyPrint);
    }

    public byte[] toByteArray(AllarmeMail allarmeMail) throws SerializerException {
        return this.objToXml(AllarmeMail.class, allarmeMail, false).toByteArray();
    }

    public byte[] toByteArray(AllarmeMail allarmeMail, boolean prettyPrint) throws SerializerException {
        return this.objToXml(AllarmeMail.class, allarmeMail, prettyPrint).toByteArray();
    }

    public String toString(AllarmeMail allarmeMail) throws SerializerException {
        return this.objToXml(AllarmeMail.class, allarmeMail, false).toString();
    }

    public String toString(AllarmeMail allarmeMail, boolean prettyPrint) throws SerializerException {
        return this.objToXml(AllarmeMail.class, allarmeMail, prettyPrint).toString();
    }

    public void write(String fileName, Allarme allarme) throws SerializerException {
        this.objToXml(fileName, Allarme.class, (Object)allarme, false);
    }

    public void write(String fileName, Allarme allarme, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Allarme.class, (Object)allarme, prettyPrint);
    }

    public void write(File file, Allarme allarme) throws SerializerException {
        this.objToXml(file, Allarme.class, (Object)allarme, false);
    }

    public void write(File file, Allarme allarme, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Allarme.class, (Object)allarme, prettyPrint);
    }

    public void write(OutputStream out, Allarme allarme) throws SerializerException {
        this.objToXml(out, Allarme.class, (Object)allarme, false);
    }

    public void write(OutputStream out, Allarme allarme, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Allarme.class, (Object)allarme, prettyPrint);
    }

    public byte[] toByteArray(Allarme allarme) throws SerializerException {
        return this.objToXml(Allarme.class, allarme, false).toByteArray();
    }

    public byte[] toByteArray(Allarme allarme, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Allarme.class, allarme, prettyPrint).toByteArray();
    }

    public String toString(Allarme allarme) throws SerializerException {
        return this.objToXml(Allarme.class, allarme, false).toString();
    }

    public String toString(Allarme allarme, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Allarme.class, allarme, prettyPrint).toString();
    }

    public void write(String fileName, AllarmeScript allarmeScript) throws SerializerException {
        this.objToXml(fileName, AllarmeScript.class, (Object)allarmeScript, false);
    }

    public void write(String fileName, AllarmeScript allarmeScript, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, AllarmeScript.class, (Object)allarmeScript, prettyPrint);
    }

    public void write(File file, AllarmeScript allarmeScript) throws SerializerException {
        this.objToXml(file, AllarmeScript.class, (Object)allarmeScript, false);
    }

    public void write(File file, AllarmeScript allarmeScript, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, AllarmeScript.class, (Object)allarmeScript, prettyPrint);
    }

    public void write(OutputStream out, AllarmeScript allarmeScript) throws SerializerException {
        this.objToXml(out, AllarmeScript.class, (Object)allarmeScript, false);
    }

    public void write(OutputStream out, AllarmeScript allarmeScript, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, AllarmeScript.class, (Object)allarmeScript, prettyPrint);
    }

    public byte[] toByteArray(AllarmeScript allarmeScript) throws SerializerException {
        return this.objToXml(AllarmeScript.class, allarmeScript, false).toByteArray();
    }

    public byte[] toByteArray(AllarmeScript allarmeScript, boolean prettyPrint) throws SerializerException {
        return this.objToXml(AllarmeScript.class, allarmeScript, prettyPrint).toByteArray();
    }

    public String toString(AllarmeScript allarmeScript) throws SerializerException {
        return this.objToXml(AllarmeScript.class, allarmeScript, false).toString();
    }

    public String toString(AllarmeScript allarmeScript, boolean prettyPrint) throws SerializerException {
        return this.objToXml(AllarmeScript.class, allarmeScript, prettyPrint).toString();
    }

    public void write(String fileName, AllarmeFiltro allarmeFiltro) throws SerializerException {
        this.objToXml(fileName, AllarmeFiltro.class, (Object)allarmeFiltro, false);
    }

    public void write(String fileName, AllarmeFiltro allarmeFiltro, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, AllarmeFiltro.class, (Object)allarmeFiltro, prettyPrint);
    }

    public void write(File file, AllarmeFiltro allarmeFiltro) throws SerializerException {
        this.objToXml(file, AllarmeFiltro.class, (Object)allarmeFiltro, false);
    }

    public void write(File file, AllarmeFiltro allarmeFiltro, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, AllarmeFiltro.class, (Object)allarmeFiltro, prettyPrint);
    }

    public void write(OutputStream out, AllarmeFiltro allarmeFiltro) throws SerializerException {
        this.objToXml(out, AllarmeFiltro.class, (Object)allarmeFiltro, false);
    }

    public void write(OutputStream out, AllarmeFiltro allarmeFiltro, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, AllarmeFiltro.class, (Object)allarmeFiltro, prettyPrint);
    }

    public byte[] toByteArray(AllarmeFiltro allarmeFiltro) throws SerializerException {
        return this.objToXml(AllarmeFiltro.class, allarmeFiltro, false).toByteArray();
    }

    public byte[] toByteArray(AllarmeFiltro allarmeFiltro, boolean prettyPrint) throws SerializerException {
        return this.objToXml(AllarmeFiltro.class, allarmeFiltro, prettyPrint).toByteArray();
    }

    public String toString(AllarmeFiltro allarmeFiltro) throws SerializerException {
        return this.objToXml(AllarmeFiltro.class, allarmeFiltro, false).toString();
    }

    public String toString(AllarmeFiltro allarmeFiltro, boolean prettyPrint) throws SerializerException {
        return this.objToXml(AllarmeFiltro.class, allarmeFiltro, prettyPrint).toString();
    }

    public void write(String fileName, AllarmeRaggruppamento allarmeRaggruppamento) throws SerializerException {
        this.objToXml(fileName, AllarmeRaggruppamento.class, (Object)allarmeRaggruppamento, false);
    }

    public void write(String fileName, AllarmeRaggruppamento allarmeRaggruppamento, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, AllarmeRaggruppamento.class, (Object)allarmeRaggruppamento, prettyPrint);
    }

    public void write(File file, AllarmeRaggruppamento allarmeRaggruppamento) throws SerializerException {
        this.objToXml(file, AllarmeRaggruppamento.class, (Object)allarmeRaggruppamento, false);
    }

    public void write(File file, AllarmeRaggruppamento allarmeRaggruppamento, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, AllarmeRaggruppamento.class, (Object)allarmeRaggruppamento, prettyPrint);
    }

    public void write(OutputStream out, AllarmeRaggruppamento allarmeRaggruppamento) throws SerializerException {
        this.objToXml(out, AllarmeRaggruppamento.class, (Object)allarmeRaggruppamento, false);
    }

    public void write(OutputStream out, AllarmeRaggruppamento allarmeRaggruppamento, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, AllarmeRaggruppamento.class, (Object)allarmeRaggruppamento, prettyPrint);
    }

    public byte[] toByteArray(AllarmeRaggruppamento allarmeRaggruppamento) throws SerializerException {
        return this.objToXml(AllarmeRaggruppamento.class, allarmeRaggruppamento, false).toByteArray();
    }

    public byte[] toByteArray(AllarmeRaggruppamento allarmeRaggruppamento, boolean prettyPrint) throws SerializerException {
        return this.objToXml(AllarmeRaggruppamento.class, allarmeRaggruppamento, prettyPrint).toByteArray();
    }

    public String toString(AllarmeRaggruppamento allarmeRaggruppamento) throws SerializerException {
        return this.objToXml(AllarmeRaggruppamento.class, allarmeRaggruppamento, false).toString();
    }

    public String toString(AllarmeRaggruppamento allarmeRaggruppamento, boolean prettyPrint) throws SerializerException {
        return this.objToXml(AllarmeRaggruppamento.class, allarmeRaggruppamento, prettyPrint).toString();
    }

    public void write(String fileName, AllarmeParametro allarmeParametro) throws SerializerException {
        this.objToXml(fileName, AllarmeParametro.class, (Object)allarmeParametro, false);
    }

    public void write(String fileName, AllarmeParametro allarmeParametro, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, AllarmeParametro.class, (Object)allarmeParametro, prettyPrint);
    }

    public void write(File file, AllarmeParametro allarmeParametro) throws SerializerException {
        this.objToXml(file, AllarmeParametro.class, (Object)allarmeParametro, false);
    }

    public void write(File file, AllarmeParametro allarmeParametro, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, AllarmeParametro.class, (Object)allarmeParametro, prettyPrint);
    }

    public void write(OutputStream out, AllarmeParametro allarmeParametro) throws SerializerException {
        this.objToXml(out, AllarmeParametro.class, (Object)allarmeParametro, false);
    }

    public void write(OutputStream out, AllarmeParametro allarmeParametro, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, AllarmeParametro.class, (Object)allarmeParametro, prettyPrint);
    }

    public byte[] toByteArray(AllarmeParametro allarmeParametro) throws SerializerException {
        return this.objToXml(AllarmeParametro.class, allarmeParametro, false).toByteArray();
    }

    public byte[] toByteArray(AllarmeParametro allarmeParametro, boolean prettyPrint) throws SerializerException {
        return this.objToXml(AllarmeParametro.class, allarmeParametro, prettyPrint).toByteArray();
    }

    public String toString(AllarmeParametro allarmeParametro) throws SerializerException {
        return this.objToXml(AllarmeParametro.class, allarmeParametro, false).toString();
    }

    public String toString(AllarmeParametro allarmeParametro, boolean prettyPrint) throws SerializerException {
        return this.objToXml(AllarmeParametro.class, allarmeParametro, prettyPrint).toString();
    }

    public void write(String fileName, AllarmeNotifica allarmeNotifica) throws SerializerException {
        this.objToXml(fileName, AllarmeNotifica.class, (Object)allarmeNotifica, false);
    }

    public void write(String fileName, AllarmeNotifica allarmeNotifica, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, AllarmeNotifica.class, (Object)allarmeNotifica, prettyPrint);
    }

    public void write(File file, AllarmeNotifica allarmeNotifica) throws SerializerException {
        this.objToXml(file, AllarmeNotifica.class, (Object)allarmeNotifica, false);
    }

    public void write(File file, AllarmeNotifica allarmeNotifica, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, AllarmeNotifica.class, (Object)allarmeNotifica, prettyPrint);
    }

    public void write(OutputStream out, AllarmeNotifica allarmeNotifica) throws SerializerException {
        this.objToXml(out, AllarmeNotifica.class, (Object)allarmeNotifica, false);
    }

    public void write(OutputStream out, AllarmeNotifica allarmeNotifica, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, AllarmeNotifica.class, (Object)allarmeNotifica, prettyPrint);
    }

    public byte[] toByteArray(AllarmeNotifica allarmeNotifica) throws SerializerException {
        return this.objToXml(AllarmeNotifica.class, allarmeNotifica, false).toByteArray();
    }

    public byte[] toByteArray(AllarmeNotifica allarmeNotifica, boolean prettyPrint) throws SerializerException {
        return this.objToXml(AllarmeNotifica.class, allarmeNotifica, prettyPrint).toByteArray();
    }

    public String toString(AllarmeNotifica allarmeNotifica) throws SerializerException {
        return this.objToXml(AllarmeNotifica.class, allarmeNotifica, false).toString();
    }

    public String toString(AllarmeNotifica allarmeNotifica, boolean prettyPrint) throws SerializerException {
        return this.objToXml(AllarmeNotifica.class, allarmeNotifica, prettyPrint).toString();
    }

    public void write(String fileName, ElencoAllarmi elencoAllarmi) throws SerializerException {
        this.objToXml(fileName, ElencoAllarmi.class, (Object)elencoAllarmi, false);
    }

    public void write(String fileName, ElencoAllarmi elencoAllarmi, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, ElencoAllarmi.class, (Object)elencoAllarmi, prettyPrint);
    }

    public void write(File file, ElencoAllarmi elencoAllarmi) throws SerializerException {
        this.objToXml(file, ElencoAllarmi.class, (Object)elencoAllarmi, false);
    }

    public void write(File file, ElencoAllarmi elencoAllarmi, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, ElencoAllarmi.class, (Object)elencoAllarmi, prettyPrint);
    }

    public void write(OutputStream out, ElencoAllarmi elencoAllarmi) throws SerializerException {
        this.objToXml(out, ElencoAllarmi.class, (Object)elencoAllarmi, false);
    }

    public void write(OutputStream out, ElencoAllarmi elencoAllarmi, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, ElencoAllarmi.class, (Object)elencoAllarmi, prettyPrint);
    }

    public byte[] toByteArray(ElencoAllarmi elencoAllarmi) throws SerializerException {
        return this.objToXml(ElencoAllarmi.class, elencoAllarmi, false).toByteArray();
    }

    public byte[] toByteArray(ElencoAllarmi elencoAllarmi, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ElencoAllarmi.class, elencoAllarmi, prettyPrint).toByteArray();
    }

    public String toString(ElencoAllarmi elencoAllarmi) throws SerializerException {
        return this.objToXml(ElencoAllarmi.class, elencoAllarmi, false).toString();
    }

    public String toString(ElencoAllarmi elencoAllarmi, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ElencoAllarmi.class, elencoAllarmi, prettyPrint).toString();
    }

    public void write(String fileName, ElencoIdAllarmi elencoIdAllarmi) throws SerializerException {
        this.objToXml(fileName, ElencoIdAllarmi.class, (Object)elencoIdAllarmi, false);
    }

    public void write(String fileName, ElencoIdAllarmi elencoIdAllarmi, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, ElencoIdAllarmi.class, (Object)elencoIdAllarmi, prettyPrint);
    }

    public void write(File file, ElencoIdAllarmi elencoIdAllarmi) throws SerializerException {
        this.objToXml(file, ElencoIdAllarmi.class, (Object)elencoIdAllarmi, false);
    }

    public void write(File file, ElencoIdAllarmi elencoIdAllarmi, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, ElencoIdAllarmi.class, (Object)elencoIdAllarmi, prettyPrint);
    }

    public void write(OutputStream out, ElencoIdAllarmi elencoIdAllarmi) throws SerializerException {
        this.objToXml(out, ElencoIdAllarmi.class, (Object)elencoIdAllarmi, false);
    }

    public void write(OutputStream out, ElencoIdAllarmi elencoIdAllarmi, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, ElencoIdAllarmi.class, (Object)elencoIdAllarmi, prettyPrint);
    }

    public byte[] toByteArray(ElencoIdAllarmi elencoIdAllarmi) throws SerializerException {
        return this.objToXml(ElencoIdAllarmi.class, elencoIdAllarmi, false).toByteArray();
    }

    public byte[] toByteArray(ElencoIdAllarmi elencoIdAllarmi, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ElencoIdAllarmi.class, elencoIdAllarmi, prettyPrint).toByteArray();
    }

    public String toString(ElencoIdAllarmi elencoIdAllarmi) throws SerializerException {
        return this.objToXml(ElencoIdAllarmi.class, elencoIdAllarmi, false).toString();
    }

    public String toString(ElencoIdAllarmi elencoIdAllarmi, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ElencoIdAllarmi.class, elencoIdAllarmi, prettyPrint).toString();
    }
}

