/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.commons;

import java.util.Properties;
import org.openspcoop2.core.commons.CoreException;
import org.slf4j.Logger;

public class PropertiesEnvUtils {
    public static final String ENV_GOVWAY_CONF = "GOVWAY_CONF";
    public static final String ENV_GOVWAY_LOG = "GOVWAY_LOG";
    public static final String ENV_GOVWAY_DB_TYPE = "GOVWAY_DB_TYPE";
    public static final String ENV_GOVWAY_DEFAULT_ENTITY_NAME = "GOVWAY_DEFAULT_ENTITY_NAME";
    public static final String PROP_CONF_REQUIRED = "conf.required";
    public static final String PROP_LOG_REQUIRED = "log.required";
    public static final String PROP_DB_TYPE_REQUIRED = "dbType.required";
    public static final String PROP_DEFAULT_ENTITY_NAME_REQUIRED = "defaultEntityName.required";
    private static final String SOURCE_SYSTEM = "system";
    private static final String SOURCE_JAVA = "java";

    private PropertiesEnvUtils() {
    }

    public static void checkRequiredEnvProperties(Properties props, Logger log, String archiveName) throws CoreException {
        if (props == null) {
            throw new CoreException("Properties is null");
        }
        PropertiesEnvUtils.checkEnvVariable(props, PROP_CONF_REQUIRED, ENV_GOVWAY_CONF, log, archiveName);
        PropertiesEnvUtils.checkEnvVariable(props, PROP_LOG_REQUIRED, ENV_GOVWAY_LOG, log, archiveName);
        PropertiesEnvUtils.checkEnvVariable(props, PROP_DB_TYPE_REQUIRED, ENV_GOVWAY_DB_TYPE, log, archiveName);
        PropertiesEnvUtils.checkEnvVariable(props, PROP_DEFAULT_ENTITY_NAME_REQUIRED, ENV_GOVWAY_DEFAULT_ENTITY_NAME, log, archiveName);
    }

    private static void checkEnvVariable(Properties props, String propertyName, String envVarName, Logger log, String archiveName) throws CoreException {
        String checkEnabled = props.getProperty(propertyName);
        if (checkEnabled != null && "true".equalsIgnoreCase(checkEnabled.trim())) {
            String value = System.getenv(envVarName);
            if (value != null && !value.trim().isEmpty()) {
                PropertiesEnvUtils.logEnvVariableFound(log, envVarName, SOURCE_SYSTEM);
                return;
            }
            value = System.getProperty(envVarName);
            if (value != null && !value.trim().isEmpty()) {
                PropertiesEnvUtils.logEnvVariableFound(log, envVarName, SOURCE_JAVA);
                return;
            }
            PropertiesEnvUtils.logEnvVariableNotFound(log, envVarName, archiveName);
            throw new CoreException("Required environment variable '" + envVarName + "' not found (neither as system environment variable nor as Java system property)");
        }
    }

    private static void logEnvVariableFound(Logger log, String envVarName, String source) {
        if (log != null) {
            log.info("Environment variable '{}' found as {} variable", (Object)envVarName, (Object)source);
        }
    }

    private static void logEnvVariableNotFound(Logger log, String envVarName, String archiveName) {
        String errorMsg = "[" + archiveName + "] Environment variable '" + envVarName + "' not found (neither as system environment variable nor as Java system property)";
        System.err.println(errorMsg);
        System.err.flush();
        if (log != null) {
            log.error(errorMsg);
        }
    }

    public static String getEnvValue(String envVarName) {
        String value = System.getenv(envVarName);
        if (value != null && !value.trim().isEmpty()) {
            return value;
        }
        value = System.getProperty(envVarName);
        if (value != null && !value.trim().isEmpty()) {
            return value;
        }
        return null;
    }

    public static boolean existsEnvValue(String envVarName) {
        return PropertiesEnvUtils.getEnvValue(envVarName) != null;
    }

    public static void resolveGovWayEnvVariables(Properties props) {
        if (props == null) {
            return;
        }
        for (String key : props.stringPropertyNames()) {
            String value = props.getProperty(key);
            String resolved = PropertiesEnvUtils.resolveGovWayEnvVariables(value);
            if (value == null || value.equals(resolved)) continue;
            props.setProperty(key, resolved);
        }
    }

    public static String resolveGovWayEnvVariables(String value) {
        if (value == null) {
            return null;
        }
        String result = value;
        result = PropertiesEnvUtils.resolveEnvVariable(result, ENV_GOVWAY_CONF);
        result = PropertiesEnvUtils.resolveEnvVariable(result, ENV_GOVWAY_LOG);
        result = PropertiesEnvUtils.resolveEnvVariable(result, ENV_GOVWAY_DB_TYPE);
        result = PropertiesEnvUtils.resolveEnvVariable(result, ENV_GOVWAY_DEFAULT_ENTITY_NAME);
        return result;
    }

    private static String resolveEnvVariable(String value, String envVarName) {
        String envValue;
        String placeholder = "${" + envVarName + "}";
        if (value.contains(placeholder) && (envValue = PropertiesEnvUtils.getEnvValue(envVarName)) != null) {
            return value.replace(placeholder, envValue);
        }
        return value;
    }
}

