/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.commons;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.openspcoop2.utils.resources.FileSystemUtilities;

public class PropertiesScriptBuilder {
    public static void main(String[] args) throws Exception {
        String sourceDir = args[0];
        String destDir = args[1];
        String distDir = args[2];
        String versionePrecedente = null;
        String versioneAttuale = null;
        if (args.length > 3) {
            versionePrecedente = args[3];
            versioneAttuale = args[4];
        }
        PropertiesScriptBuilder.build_Aggiornamento(new File(sourceDir), new File(destDir), new File(distDir), versionePrecedente, versioneAttuale);
    }

    private static void build_Aggiornamento(File sourceDir, File destDir, File distDir, String precedenteVersione, String versioneAttuale) throws Exception {
        String fileName;
        if (!sourceDir.exists()) {
            throw new Exception("Source dir [" + sourceDir.getAbsolutePath() + "] not exists");
        }
        if (!sourceDir.canRead()) {
            throw new Exception("Source dir [" + sourceDir.getAbsolutePath() + "] cannot read");
        }
        if (!destDir.exists()) {
            throw new Exception("Dest dir [" + destDir.getAbsolutePath() + "] not exists");
        }
        if (!destDir.canWrite()) {
            throw new Exception("Dest dir [" + destDir.getAbsolutePath() + "] cannot write");
        }
        if (!distDir.exists()) {
            throw new Exception("Dest dir [" + destDir.getAbsolutePath() + "] not exists");
        }
        if (!distDir.canWrite()) {
            throw new Exception("Dest dir [" + destDir.getAbsolutePath() + "] cannot write");
        }
        if (precedenteVersione == null) {
            throw new Exception("Precedente versione non fornita");
        }
        if (!precedenteVersione.contains(".")) {
            throw new Exception("Precedente versione in un formato non corretto [" + precedenteVersione + "] ('.' not found)");
        }
        int indexOfFirstPoint = precedenteVersione.indexOf(".");
        if (indexOfFirstPoint <= 0) {
            throw new Exception("Precedente versione in un formato non corretto [" + precedenteVersione + "] ('.' not found with index)");
        }
        String productVersionString = precedenteVersione.substring(0, indexOfFirstPoint);
        int productVersion = -1;
        try {
            productVersion = Integer.parseInt(productVersionString);
        }
        catch (Exception e) {
            throw new Exception("Precedente versione in un formato non corretto [" + precedenteVersione + "] (productVersion:" + productVersionString + "): " + e.getMessage(), e);
        }
        int indexOfSecondPoint = precedenteVersione.indexOf(".", indexOfFirstPoint + 1);
        if (indexOfSecondPoint <= 0 || indexOfSecondPoint <= indexOfFirstPoint) {
            throw new Exception("Precedente versione in un formato non corretto [" + precedenteVersione + "] (second '.' not found)");
        }
        String majorVersionString = precedenteVersione.substring(indexOfFirstPoint + 1, indexOfSecondPoint);
        int majorVersion = -1;
        try {
            majorVersion = Integer.parseInt(majorVersionString);
        }
        catch (Exception e) {
            throw new Exception("Precedente versione in un formato non corretto [" + precedenteVersione + "] (majorVersion:" + majorVersionString + "): " + e.getMessage(), e);
        }
        if (precedenteVersione.length() <= indexOfSecondPoint) {
            throw new Exception("Precedente versione in un formato non corretto [" + precedenteVersione + "] (length)");
        }
        String minorVersionString = precedenteVersione.substring(indexOfSecondPoint + 1, precedenteVersione.length());
        int minorVersion = -1;
        try {
            minorVersion = Integer.parseInt(minorVersionString);
        }
        catch (Exception e) {
            if (minorVersionString.contains("_")) {
                String newMinor = minorVersionString.split("_")[0];
                try {
                    minorVersion = Integer.parseInt(newMinor);
                }
                catch (Exception eInternal) {
                    throw new Exception("Precedente versione in un formato non corretto [" + precedenteVersione + "] (minorVersion:" + minorVersionString + " minorVersionBuildNumber:" + newMinor + "): " + eInternal.getMessage(), eInternal);
                }
            }
            throw new Exception("Precedente versione in un formato non corretto [" + precedenteVersione + "] (minorVersion:" + minorVersionString + "): " + e.getMessage(), e);
        }
        int tmpMajorVersion = majorVersion;
        int tmpMinorVersion = minorVersion;
        HashMap<String, Boolean> configCreateFileFromDist = new HashMap<String, Boolean>();
        HashMap<String, ByteArrayOutputStream> configCreateFileDiff = new HashMap<String, ByteArrayOutputStream>();
        while (true) {
            String nextVersion;
            String actualVersion;
            File version;
            if ((version = new File(sourceDir, "upgrade_" + (actualVersion = productVersion + "." + tmpMajorVersion + "." + tmpMinorVersion) + "_to_" + (nextVersion = productVersion + "." + tmpMajorVersion + "." + (tmpMinorVersion + 1)))).exists()) {
                if (!version.canRead()) {
                    throw new Exception("Source version dir [" + version.getAbsolutePath() + "] cannot read");
                }
                PropertiesScriptBuilder._create_Aggiornamento(version, destDir, configCreateFileFromDist, configCreateFileDiff, nextVersion);
                ++tmpMinorVersion;
                continue;
            }
            actualVersion = productVersion + "." + tmpMajorVersion + ".x";
            version = new File(sourceDir, "upgrade_" + actualVersion + "_to_" + (nextVersion = productVersion + "." + (tmpMajorVersion + 1) + ".0"));
            if (!version.exists()) break;
            if (!version.canRead()) {
                throw new Exception("Source version dir [" + version.getAbsolutePath() + "] cannot read");
            }
            PropertiesScriptBuilder._create_Aggiornamento(version, destDir, configCreateFileFromDist, configCreateFileDiff, nextVersion);
            ++tmpMajorVersion;
            tmpMinorVersion = 0;
        }
        if (configCreateFileFromDist.size() > 0) {
            block9: for (String id : configCreateFileFromDist.keySet()) {
                fileName = id + ".properties";
                File[] files = distDir.listFiles();
                if (files == null || files.length <= 0) continue;
                for (File distFile : files) {
                    if (!distFile.getName().equals(fileName)) continue;
                    File fOut = new File(destDir, fileName);
                    FileSystemUtilities.copy((File)distFile, (File)fOut);
                    continue block9;
                }
            }
        }
        if (configCreateFileDiff.size() > 0) {
            for (String id : configCreateFileDiff.keySet()) {
                fileName = id + ".diff";
                File fOut = new File(destDir, fileName);
                ByteArrayOutputStream bout = (ByteArrayOutputStream)configCreateFileDiff.get(id);
                bout.flush();
                bout.close();
                FileSystemUtilities.writeFile((File)fOut, (byte[])bout.toByteArray());
            }
        }
    }

    private static void _create_Aggiornamento(File sourceDir, File destDir, Map<String, Boolean> configCreateFileFromDist, Map<String, ByteArrayOutputStream> configCreateFileDiff, String nextVersion) throws Exception {
        Object[] files = sourceDir.listFiles();
        if (files != null && files.length > 0) {
            Object[] fileChilds;
            for (Object upgradeDir : files) {
                if (!((File)upgradeDir).isDirectory() || !((File)upgradeDir).getName().equals("core") && !((File)upgradeDir).getName().equals("protocolli") || (fileChilds = ((File)upgradeDir).listFiles()) == null || fileChilds.length <= 0) continue;
                Arrays.sort(fileChilds);
                for (Object upgradeFile : fileChilds) {
                    String key;
                    if (!((File)upgradeFile).getName().endsWith(".properties") || configCreateFileFromDist.containsKey(key = ((File)upgradeFile).getName().substring(0, ((File)upgradeFile).getName().indexOf(".properties")))) continue;
                    configCreateFileFromDist.put(key, true);
                }
            }
            Arrays.sort(files);
            for (Object upgradeDir : files) {
                if (!((File)upgradeDir).isDirectory() || !((File)upgradeDir).getName().equals("core") && !((File)upgradeDir).getName().equals("protocolli") || (fileChilds = ((File)upgradeDir).listFiles()) == null || fileChilds.length <= 0) continue;
                Arrays.sort(fileChilds);
                for (Object diffFile : fileChilds) {
                    if (!((File)diffFile).getName().endsWith(".diff")) continue;
                    String data = ".YYYY-MM-DD.diff";
                    String key = ((File)diffFile).getName().substring(0, ((File)diffFile).getName().length() - data.length());
                    if (configCreateFileFromDist.containsKey(key)) continue;
                    ByteArrayOutputStream bout = null;
                    if (configCreateFileDiff.containsKey(key)) {
                        bout = configCreateFileDiff.get(key);
                    } else {
                        bout = new ByteArrayOutputStream();
                        configCreateFileDiff.put(key, bout);
                    }
                    PropertiesScriptBuilder._createAggiornamento((File)diffFile, bout);
                }
            }
        }
    }

    private static void _createAggiornamento(File diffFile, ByteArrayOutputStream bout) throws Exception {
        byte[] b = FileSystemUtilities.readBytesFromFile((File)diffFile);
        if (bout.size() > 0) {
            bout.write("\n\n".getBytes());
        }
        bout.write(b);
    }
}

