/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.commons.search.dao.jdbc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.openspcoop2.core.commons.search.AccordoServizioParteSpecifica;
import org.openspcoop2.core.commons.search.Fruitore;
import org.openspcoop2.core.commons.search.IdAccordoServizioParteSpecifica;
import org.openspcoop2.core.commons.search.IdFruitore;
import org.openspcoop2.core.commons.search.IdSoggetto;
import org.openspcoop2.core.commons.search.Soggetto;
import org.openspcoop2.core.commons.search.dao.IDBAccordoServizioParteSpecificaServiceSearch;
import org.openspcoop2.core.commons.search.dao.IDBSoggettoServiceSearch;
import org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.commons.search.dao.jdbc.converter.FruitoreFieldConverter;
import org.openspcoop2.core.commons.search.dao.jdbc.fetch.FruitoreFetch;
import org.openspcoop2.generic_project.beans.AliasField;
import org.openspcoop2.generic_project.beans.CustomField;
import org.openspcoop2.generic_project.beans.FunctionField;
import org.openspcoop2.generic_project.beans.IDMappingBehaviour;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.IModel;
import org.openspcoop2.generic_project.beans.InUse;
import org.openspcoop2.generic_project.beans.NonNegativeNumber;
import org.openspcoop2.generic_project.beans.Union;
import org.openspcoop2.generic_project.beans.UnionExpression;
import org.openspcoop2.generic_project.dao.jdbc.IJDBCServiceSearchWithId;
import org.openspcoop2.generic_project.dao.jdbc.JDBCExpression;
import org.openspcoop2.generic_project.dao.jdbc.JDBCPaginatedExpression;
import org.openspcoop2.generic_project.dao.jdbc.JDBCServiceManagerProperties;
import org.openspcoop2.generic_project.dao.jdbc.utils.GenericJDBCUtilities;
import org.openspcoop2.generic_project.dao.jdbc.utils.IJDBCFetch;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCObject;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCPreparedStatementUtilities;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;
import org.openspcoop2.generic_project.utils.UtilsTemplate;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.slf4j.Logger;

public class JDBCFruitoreServiceSearchImpl
implements IJDBCServiceSearchWithId<Fruitore, IdFruitore, JDBCServiceManager> {
    private FruitoreFieldConverter _fruitoreFieldConverter = null;
    private FruitoreFetch fruitoreFetch = new FruitoreFetch();
    private JDBCServiceManager jdbcServiceManager = null;
    private static boolean efficiente = true;

    public FruitoreFieldConverter getFruitoreFieldConverter() {
        if (this._fruitoreFieldConverter == null) {
            this._fruitoreFieldConverter = new FruitoreFieldConverter(this.jdbcServiceManager.getJdbcProperties().getDatabaseType());
        }
        return this._fruitoreFieldConverter;
    }

    public ISQLFieldConverter getFieldConverter() {
        return this.getFruitoreFieldConverter();
    }

    public FruitoreFetch getFruitoreFetch() {
        return this.fruitoreFetch;
    }

    public IJDBCFetch getFetch() {
        return this.getFruitoreFetch();
    }

    public void setServiceManager(JDBCServiceManager serviceManager) throws ServiceException {
        this.jdbcServiceManager = serviceManager;
    }

    public JDBCServiceManager getServiceManager() throws ServiceException {
        return this.jdbcServiceManager;
    }

    public JDBCServiceManager getServiceManager(Connection connection, JDBCServiceManagerProperties jdbcProperties, Logger log) throws ServiceException {
        return new JDBCServiceManager(connection, jdbcProperties, log);
    }

    public IdFruitore convertToId(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Fruitore fruitore) throws NotImplementedException, ServiceException, Exception {
        IdFruitore idFruitore = new IdFruitore();
        idFruitore.setIdAccordoServizioParteSpecifica(fruitore.getIdAccordoServizioParteSpecifica());
        idFruitore.setIdFruitore(fruitore.getIdFruitore());
        return idFruitore;
    }

    public Fruitore get(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdFruitore id, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, MultipleResultException, NotImplementedException, ServiceException, Exception {
        Long id_fruitore = id != null && id.getId() != null && id.getId() > 0L ? id.getId() : this.findIdFruitore(jdbcProperties, log, connection, sqlQueryObject, id, true);
        return this.getEngine(jdbcProperties, log, connection, sqlQueryObject, id_fruitore, idMappingResolutionBehaviour);
    }

    public boolean exists(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdFruitore id) throws MultipleResultException, NotImplementedException, ServiceException, Exception {
        Long id_fruitore = this.findIdFruitore(jdbcProperties, log, connection, sqlQueryObject, id, false);
        return id_fruitore != null && id_fruitore > 0L;
    }

    public List<IdFruitore> findAllIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression expression, IDMappingBehaviour idMappingResolutionBehaviour) throws NotImplementedException, ServiceException, Exception {
        ArrayList<IdFruitore> list = new ArrayList<IdFruitore>();
        List<Long> ids = this.findAllTableIds(jdbcProperties, log, connection, sqlQueryObject, expression);
        for (Long id : ids) {
            Fruitore fruitore = this.get(jdbcProperties, log, connection, sqlQueryObject, id, idMappingResolutionBehaviour);
            IdFruitore idFruitore = this.convertToId(jdbcProperties, log, connection, sqlQueryObject, fruitore);
            list.add(idFruitore);
        }
        return list;
    }

    public List<Fruitore> findAll(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression expression, IDMappingBehaviour idMappingResolutionBehaviour) throws NotImplementedException, ServiceException, Exception {
        ArrayList<Fruitore> list = new ArrayList<Fruitore>();
        if (efficiente) {
            ArrayList<AliasField> fields = new ArrayList<AliasField>();
            String aliasAccordoTipo = "accordoTipo";
            fields.add(new AliasField(Fruitore.model().ID_ACCORDO_SERVIZIO_PARTE_SPECIFICA.TIPO, aliasAccordoTipo));
            String aliasAccordoNome = "accordoNome";
            fields.add(new AliasField(Fruitore.model().ID_ACCORDO_SERVIZIO_PARTE_SPECIFICA.NOME, aliasAccordoNome));
            String aliasAccordoVersione = "accordoVersione";
            fields.add(new AliasField(Fruitore.model().ID_ACCORDO_SERVIZIO_PARTE_SPECIFICA.VERSIONE, aliasAccordoVersione));
            String aliasAccordoSoggettoErogatoreTipo = "accordoSoggettoReferenteTipo";
            fields.add(new AliasField(Fruitore.model().ID_ACCORDO_SERVIZIO_PARTE_SPECIFICA.ID_EROGATORE.TIPO, aliasAccordoSoggettoErogatoreTipo));
            String aliasAccordoSoggettoErogatoreNome = "accordoSoggettoReferenteNome";
            fields.add(new AliasField(Fruitore.model().ID_ACCORDO_SERVIZIO_PARTE_SPECIFICA.ID_EROGATORE.NOME, aliasAccordoSoggettoErogatoreNome));
            String aliasSoggettoFruitoreTipo = "accordoSoggettoErogatoreTipo";
            fields.add(new AliasField(Fruitore.model().ID_FRUITORE.TIPO, aliasSoggettoFruitoreTipo));
            String aliasSoggettoFruitoreNome = "accordoSoggettoErogatoreNome";
            fields.add(new AliasField(Fruitore.model().ID_FRUITORE.NOME, aliasSoggettoFruitoreNome));
            List<Map<String, Object>> returnMap = null;
            try {
                boolean distinct = false;
                returnMap = this.select(jdbcProperties, log, connection, sqlQueryObject, expression, distinct, fields.toArray(new IField[1]));
                for (Map<String, Object> map : returnMap) {
                    Fruitore fruitore = (Fruitore)this.getFruitoreFetch().fetch(jdbcProperties.getDatabase(), (IModel<?>)Fruitore.model(), map);
                    Object apcTipo = this.getObjectFromMap(map, aliasAccordoTipo);
                    Object apcNome = this.getObjectFromMap(map, aliasAccordoNome);
                    Object apcVersione = this.getObjectFromMap(map, aliasAccordoVersione);
                    Object apcSoggettoErogatoreTipo = this.getObjectFromMap(map, aliasAccordoSoggettoErogatoreTipo);
                    Object apcSoggettoErogatoreNome = this.getObjectFromMap(map, aliasAccordoSoggettoErogatoreNome);
                    Object soggettoFruitoreTipo = this.getObjectFromMap(map, aliasSoggettoFruitoreTipo);
                    Object soggettoFruitoreNome = this.getObjectFromMap(map, aliasSoggettoFruitoreNome);
                    if (apcTipo != null && apcNome != null && apcVersione != null) {
                        IdAccordoServizioParteSpecifica idAccordoServizioParteSpecifica = new IdAccordoServizioParteSpecifica();
                        if (apcTipo != null && apcTipo instanceof String) {
                            idAccordoServizioParteSpecifica.setTipo((String)apcTipo);
                        }
                        if (apcNome != null && apcNome instanceof String) {
                            idAccordoServizioParteSpecifica.setNome((String)apcNome);
                        }
                        if (apcVersione != null && apcVersione instanceof Integer) {
                            idAccordoServizioParteSpecifica.setVersione((Integer)apcVersione);
                        }
                        if (apcSoggettoErogatoreTipo != null && apcSoggettoErogatoreNome != null) {
                            IdSoggetto idSoggetto = new IdSoggetto();
                            if (apcSoggettoErogatoreTipo != null && apcSoggettoErogatoreTipo instanceof String) {
                                idSoggetto.setTipo((String)apcSoggettoErogatoreTipo);
                            }
                            if (apcSoggettoErogatoreNome != null && apcSoggettoErogatoreNome instanceof String) {
                                idSoggetto.setNome((String)apcSoggettoErogatoreNome);
                            }
                            idAccordoServizioParteSpecifica.setIdErogatore(idSoggetto);
                        }
                        fruitore.setIdAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica);
                    }
                    if (soggettoFruitoreTipo != null && soggettoFruitoreNome != null) {
                        IdSoggetto idSoggetto = new IdSoggetto();
                        if (soggettoFruitoreTipo != null && soggettoFruitoreTipo instanceof String) {
                            idSoggetto.setTipo((String)soggettoFruitoreTipo);
                        }
                        if (soggettoFruitoreNome != null && soggettoFruitoreNome instanceof String) {
                            idSoggetto.setNome((String)soggettoFruitoreNome);
                        }
                        fruitore.setIdFruitore(idSoggetto);
                    }
                    list.add(fruitore);
                }
            }
            catch (NotFoundException notFoundException) {}
        } else {
            List<Long> ids = this.findAllTableIds(jdbcProperties, log, connection, sqlQueryObject, expression);
            for (Long id : ids) {
                list.add(this.get(jdbcProperties, log, connection, sqlQueryObject, id, idMappingResolutionBehaviour));
            }
        }
        return list;
    }

    private Object getObjectFromMap(Map<String, Object> map, String name) {
        if (map == null) {
            return null;
        }
        if (map.containsKey(name)) {
            Object o = map.get(name);
            if (o instanceof ObjectUtils.Null) {
                return null;
            }
            return o;
        }
        return null;
    }

    public Fruitore find(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, MultipleResultException, NotImplementedException, ServiceException, Exception {
        long id = this.findTableId(jdbcProperties, log, connection, sqlQueryObject, expression);
        if (id > 0L) {
            return this.get(jdbcProperties, log, connection, sqlQueryObject, id, idMappingResolutionBehaviour);
        }
        throw new NotFoundException("Entry with id[" + id + "] not found");
    }

    public NonNegativeNumber count(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression) throws NotImplementedException, ServiceException, Exception {
        List listaQuery = GenericJDBCUtilities.prepareCount((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getFruitoreFieldConverter(), (IModel)Fruitore.model());
        sqlQueryObject.addSelectCountField(this.getFruitoreFieldConverter().toTable((IModel)Fruitore.model()) + ".id", "tot", true);
        this.joinEngine((IExpression)expression, sqlQueryObject);
        return GenericJDBCUtilities.count((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getFruitoreFieldConverter(), (IModel)Fruitore.model(), (List)listaQuery);
    }

    public InUse inUse(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdFruitore id) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        Long id_fruitore = this.findIdFruitore(jdbcProperties, log, connection, sqlQueryObject, id, true);
        return this.inUseEngine(jdbcProperties, log, connection, sqlQueryObject, id_fruitore);
    }

    public List<Object> select(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, IField field) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return this.select(jdbcProperties, log, connection, sqlQueryObject, paginatedExpression, false, field);
    }

    public List<Object> select(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, boolean distinct, IField field) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        List<Map<String, Object>> map = this.select(jdbcProperties, log, connection, sqlQueryObject, paginatedExpression, distinct, new IField[]{field});
        return GenericJDBCUtilities.selectSingleObject(map);
    }

    public List<Map<String, Object>> select(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, IField ... field) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return this.select(jdbcProperties, log, connection, sqlQueryObject, paginatedExpression, false, field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> select(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, boolean distinct, IField ... field) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        GenericJDBCUtilities.setFields((ISQLQueryObject)sqlQueryObject, (JDBCPaginatedExpression)paginatedExpression, (IField[])field);
        try {
            ISQLQueryObject sqlQueryObjectDistinct = GenericJDBCUtilities.prepareSqlQueryObjectForSelectDistinct((boolean)distinct, (ISQLQueryObject)sqlQueryObject, (IExpression)paginatedExpression, (Logger)log, (ISQLFieldConverter)this.getFruitoreFieldConverter(), (IField[])field);
            List<Map<String, Object>> list = this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, (IExpression)paginatedExpression, sqlQueryObjectDistinct);
            return list;
        }
        finally {
            GenericJDBCUtilities.removeFields((ISQLQueryObject)sqlQueryObject, (JDBCPaginatedExpression)paginatedExpression, (IField[])field);
        }
    }

    public Object aggregate(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression, FunctionField functionField) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        Map<String, Object> map = this.aggregate(jdbcProperties, log, connection, sqlQueryObject, expression, new FunctionField[]{functionField});
        return GenericJDBCUtilities.selectAggregateObject(map, (FunctionField)functionField);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> aggregate(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression, FunctionField ... functionField) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        GenericJDBCUtilities.setFields((ISQLQueryObject)sqlQueryObject, (JDBCExpression)expression, (FunctionField[])functionField);
        try {
            List<Map<String, Object>> list = this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, (IExpression)expression);
            Map<String, Object> map = list.get(0);
            return map;
        }
        finally {
            GenericJDBCUtilities.removeFields((ISQLQueryObject)sqlQueryObject, (JDBCExpression)expression, (FunctionField[])functionField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> groupBy(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression, FunctionField ... functionField) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        if (expression.getGroupByFields().isEmpty()) {
            throw new ServiceException("GroupBy conditions not found in expression");
        }
        GenericJDBCUtilities.setFields((ISQLQueryObject)sqlQueryObject, (JDBCExpression)expression, (FunctionField[])functionField);
        try {
            List<Map<String, Object>> list = this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, (IExpression)expression);
            return list;
        }
        finally {
            GenericJDBCUtilities.removeFields((ISQLQueryObject)sqlQueryObject, (JDBCExpression)expression, (FunctionField[])functionField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> groupBy(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, FunctionField ... functionField) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        if (paginatedExpression.getGroupByFields().isEmpty()) {
            throw new ServiceException("GroupBy conditions not found in expression");
        }
        GenericJDBCUtilities.setFields((ISQLQueryObject)sqlQueryObject, (JDBCPaginatedExpression)paginatedExpression, (FunctionField[])functionField);
        try {
            List<Map<String, Object>> list = this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, (IExpression)paginatedExpression);
            return list;
        }
        finally {
            GenericJDBCUtilities.removeFields((ISQLQueryObject)sqlQueryObject, (JDBCPaginatedExpression)paginatedExpression, (FunctionField[])functionField);
        }
    }

    protected List<Map<String, Object>> selectEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IExpression expression) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, expression, null);
    }

    protected List<Map<String, Object>> selectEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IExpression expression, ISQLQueryObject sqlQueryObjectDistinct) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        ArrayList listaQuery = new ArrayList();
        ArrayList listaParams = new ArrayList();
        List returnField = GenericJDBCUtilities.prepareSelect((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getFruitoreFieldConverter(), (IModel)Fruitore.model(), listaQuery, listaParams);
        this.joinEngine(expression, sqlQueryObject);
        List list = GenericJDBCUtilities.select((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)GenericJDBCUtilities.prepareSqlQueryObjectForSelectDistinct((ISQLQueryObject)sqlQueryObject, (ISQLQueryObject)sqlQueryObjectDistinct), (IExpression)expression, (ISQLFieldConverter)this.getFruitoreFieldConverter(), (IModel)Fruitore.model(), listaQuery, listaParams, (List)returnField);
        if (list != null && !list.isEmpty()) {
            return list;
        }
        throw GenericJDBCUtilities.newNotFoundException();
    }

    public List<Map<String, Object>> union(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Union union, UnionExpression ... unionExpression) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        List list;
        ArrayList sqlQueryObjectInnerList = new ArrayList();
        ArrayList jdbcObjects = new ArrayList();
        List returnClassTypes = GenericJDBCUtilities.prepareUnion((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (ISQLFieldConverter)this.getFruitoreFieldConverter(), (IModel)Fruitore.model(), sqlQueryObjectInnerList, jdbcObjects, (Union)union, (UnionExpression[])unionExpression);
        if (unionExpression != null) {
            for (int i = 0; i < unionExpression.length; ++i) {
                UnionExpression ue = unionExpression[i];
                IExpression expression = ue.getExpression();
                this.joinEngine(expression, (ISQLQueryObject)sqlQueryObjectInnerList.get(i));
            }
        }
        if ((list = GenericJDBCUtilities.union((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (ISQLFieldConverter)this.getFruitoreFieldConverter(), (IModel)Fruitore.model(), sqlQueryObjectInnerList, jdbcObjects, (List)returnClassTypes, (Union)union, (UnionExpression[])unionExpression)) != null && !list.isEmpty()) {
            return list;
        }
        throw GenericJDBCUtilities.newNotFoundException();
    }

    public NonNegativeNumber unionCount(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Union union, UnionExpression ... unionExpression) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        NonNegativeNumber number;
        ArrayList sqlQueryObjectInnerList = new ArrayList();
        ArrayList jdbcObjects = new ArrayList();
        List returnClassTypes = GenericJDBCUtilities.prepareUnionCount((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (ISQLFieldConverter)this.getFruitoreFieldConverter(), (IModel)Fruitore.model(), sqlQueryObjectInnerList, jdbcObjects, (Union)union, (UnionExpression[])unionExpression);
        if (unionExpression != null) {
            for (int i = 0; i < unionExpression.length; ++i) {
                UnionExpression ue = unionExpression[i];
                IExpression expression = ue.getExpression();
                this.joinEngine(expression, (ISQLQueryObject)sqlQueryObjectInnerList.get(i));
            }
        }
        if ((number = GenericJDBCUtilities.unionCount((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (ISQLFieldConverter)this.getFruitoreFieldConverter(), (IModel)Fruitore.model(), sqlQueryObjectInnerList, jdbcObjects, (List)returnClassTypes, (Union)union, (UnionExpression[])unionExpression)) != null && number.longValue() >= 0L) {
            return number;
        }
        throw GenericJDBCUtilities.newNotFoundException();
    }

    public JDBCExpression newExpression(Logger log) throws NotImplementedException, ServiceException {
        try {
            return new JDBCExpression((ISQLFieldConverter)this.getFruitoreFieldConverter());
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public JDBCPaginatedExpression newPaginatedExpression(Logger log) throws NotImplementedException, ServiceException {
        try {
            return new JDBCPaginatedExpression((ISQLFieldConverter)this.getFruitoreFieldConverter());
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public JDBCExpression toExpression(JDBCPaginatedExpression paginatedExpression, Logger log) throws NotImplementedException, ServiceException {
        try {
            return new JDBCExpression(paginatedExpression);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public JDBCPaginatedExpression toPaginatedExpression(JDBCExpression expression, Logger log) throws NotImplementedException, ServiceException {
        try {
            return new JDBCPaginatedExpression(expression);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void mappingTableIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdFruitore id, Fruitore obj) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        this._mappingTableIds(jdbcProperties, log, connection, sqlQueryObject, obj, this.get(jdbcProperties, log, connection, sqlQueryObject, id, null));
    }

    public void mappingTableIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, Fruitore obj) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        this._mappingTableIds(jdbcProperties, log, connection, sqlQueryObject, obj, this.get(jdbcProperties, log, connection, sqlQueryObject, tableId, (IDMappingBehaviour)null));
    }

    private void _mappingTableIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Fruitore obj, Fruitore imgSaved) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        if (imgSaved == null) {
            return;
        }
        obj.setId(imgSaved.getId());
        if (obj.getIdFruitore() != null && imgSaved.getIdFruitore() != null) {
            obj.getIdFruitore().setId(imgSaved.getIdFruitore().getId());
        }
        if (obj.getIdAccordoServizioParteSpecifica() != null && imgSaved.getIdAccordoServizioParteSpecifica() != null) {
            obj.getIdAccordoServizioParteSpecifica().setId(imgSaved.getIdAccordoServizioParteSpecifica().getId());
            if (obj.getIdAccordoServizioParteSpecifica().getIdErogatore() != null && imgSaved.getIdAccordoServizioParteSpecifica().getIdErogatore() != null) {
                obj.getIdAccordoServizioParteSpecifica().getIdErogatore().setId(imgSaved.getIdAccordoServizioParteSpecifica().getIdErogatore().getId());
            }
        }
    }

    public Fruitore get(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, MultipleResultException, NotImplementedException, ServiceException, Exception {
        return this.getEngine(jdbcProperties, log, connection, sqlQueryObject, tableId, idMappingResolutionBehaviour);
    }

    private Fruitore getEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Long tableId, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, MultipleResultException, NotImplementedException, ServiceException, Exception {
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        ISQLQueryObject sqlQueryObjectGet = sqlQueryObject.newSQLQueryObject();
        Fruitore fruitore = new Fruitore();
        ISQLQueryObject sqlQueryObjectGet_fruitore = sqlQueryObjectGet.newSQLQueryObject();
        sqlQueryObjectGet_fruitore.setANDLogicOperator(true);
        sqlQueryObjectGet_fruitore.addFromTable(this.getFruitoreFieldConverter().toTable((IModel)Fruitore.model()));
        sqlQueryObjectGet_fruitore.addSelectField("id");
        sqlQueryObjectGet_fruitore.addSelectField(this.getFruitoreFieldConverter().toColumn(Fruitore.model().ORA_REGISTRAZIONE, true));
        sqlQueryObjectGet_fruitore.addWhereCondition("id=?");
        fruitore = (Fruitore)jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet_fruitore.createSQLQuery(), jdbcProperties.isShowSql(), (IModel)Fruitore.model(), (IJDBCFetch)this.getFruitoreFetch(), new JDBCObject[]{new JDBCObject((Object)tableId, Long.class)});
        ISQLQueryObject sqlQueryObjectGet_fruitore_soggetto_readFkId = sqlQueryObjectGet.newSQLQueryObject();
        sqlQueryObjectGet_fruitore_soggetto_readFkId.addFromTable("servizi_fruitori");
        sqlQueryObjectGet_fruitore_soggetto_readFkId.addSelectField("id_soggetto");
        sqlQueryObjectGet_fruitore_soggetto_readFkId.addWhereCondition("id=?");
        sqlQueryObjectGet_fruitore_soggetto_readFkId.setANDLogicOperator(true);
        Long idFK_fruitore_soggetto = (Long)jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet_fruitore_soggetto_readFkId.createSQLQuery(), jdbcProperties.isShowSql(), Long.class, new JDBCObject[]{new JDBCObject((Object)fruitore.getId(), Long.class)});
        ISQLQueryObject sqlQueryObjectGet_fruitore_soggetto = sqlQueryObjectGet.newSQLQueryObject();
        sqlQueryObjectGet_fruitore_soggetto.addFromTable("soggetti");
        sqlQueryObjectGet_fruitore_soggetto.addSelectField("tipo_soggetto");
        sqlQueryObjectGet_fruitore_soggetto.addSelectField("nome_soggetto");
        sqlQueryObjectGet_fruitore_soggetto.setANDLogicOperator(true);
        sqlQueryObjectGet_fruitore_soggetto.addWhereCondition("id=?");
        JDBCObject[] searchParams_fruitore_soggetto = new JDBCObject[]{new JDBCObject((Object)idFK_fruitore_soggetto, Long.class)};
        ArrayList<Class<String>> listaFieldIdReturnType_fruitore_soggetto = new ArrayList<Class<String>>();
        listaFieldIdReturnType_fruitore_soggetto.add(String.class);
        listaFieldIdReturnType_fruitore_soggetto.add(String.class);
        List listaFieldId_fruitore_soggetto = jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet_fruitore_soggetto.createSQLQuery(), jdbcProperties.isShowSql(), listaFieldIdReturnType_fruitore_soggetto, searchParams_fruitore_soggetto);
        IdSoggetto id_fruitore_soggetto = new IdSoggetto();
        id_fruitore_soggetto.setTipo((String)listaFieldId_fruitore_soggetto.get(0));
        id_fruitore_soggetto.setNome((String)listaFieldId_fruitore_soggetto.get(1));
        fruitore.setIdFruitore(id_fruitore_soggetto);
        ISQLQueryObject sqlQueryObjectGet_fruitore_accordoServizioParteSpecifica_readFkId = sqlQueryObjectGet.newSQLQueryObject();
        sqlQueryObjectGet_fruitore_accordoServizioParteSpecifica_readFkId.addFromTable("servizi_fruitori");
        sqlQueryObjectGet_fruitore_accordoServizioParteSpecifica_readFkId.addSelectField("id_servizio");
        sqlQueryObjectGet_fruitore_accordoServizioParteSpecifica_readFkId.addWhereCondition("id=?");
        sqlQueryObjectGet_fruitore_accordoServizioParteSpecifica_readFkId.setANDLogicOperator(true);
        Long idFK_fruitore_accordoServizioParteSpecifica = (Long)jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet_fruitore_accordoServizioParteSpecifica_readFkId.createSQLQuery(), jdbcProperties.isShowSql(), Long.class, new JDBCObject[]{new JDBCObject((Object)fruitore.getId(), Long.class)});
        ISQLQueryObject sqlQueryObjectGet_fruitore_accordoServizioParteSpecifica = sqlQueryObjectGet.newSQLQueryObject();
        sqlQueryObjectGet_fruitore_accordoServizioParteSpecifica.addFromTable("servizi");
        sqlQueryObjectGet_fruitore_accordoServizioParteSpecifica.addSelectField("tipo_servizio");
        sqlQueryObjectGet_fruitore_accordoServizioParteSpecifica.addSelectField("nome_servizio");
        sqlQueryObjectGet_fruitore_accordoServizioParteSpecifica.addSelectField("id_soggetto");
        sqlQueryObjectGet_fruitore_accordoServizioParteSpecifica.setANDLogicOperator(true);
        sqlQueryObjectGet_fruitore_accordoServizioParteSpecifica.addWhereCondition("id=?");
        JDBCObject[] searchParams_fruitore_accordoServizioParteSpecifica = new JDBCObject[]{new JDBCObject((Object)idFK_fruitore_accordoServizioParteSpecifica, Long.class)};
        ArrayList<Class> listaFieldIdReturnType_fruitore_accordoServizioParteSpecifica = new ArrayList<Class>();
        listaFieldIdReturnType_fruitore_accordoServizioParteSpecifica.add(String.class);
        listaFieldIdReturnType_fruitore_accordoServizioParteSpecifica.add(String.class);
        listaFieldIdReturnType_fruitore_accordoServizioParteSpecifica.add(Long.class);
        List listaFieldId_fruitore_accordoServizioParteSpecifica = jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet_fruitore_accordoServizioParteSpecifica.createSQLQuery(), jdbcProperties.isShowSql(), listaFieldIdReturnType_fruitore_accordoServizioParteSpecifica, searchParams_fruitore_accordoServizioParteSpecifica);
        IdAccordoServizioParteSpecifica id_fruitore_accordoServizioParteSpecifica = new IdAccordoServizioParteSpecifica();
        id_fruitore_accordoServizioParteSpecifica.setTipo((String)listaFieldId_fruitore_accordoServizioParteSpecifica.get(0));
        id_fruitore_accordoServizioParteSpecifica.setNome((String)listaFieldId_fruitore_accordoServizioParteSpecifica.get(1));
        long idSoggettoAccordoParteSpecifica = (Long)listaFieldId_fruitore_accordoServizioParteSpecifica.get(2);
        ISQLQueryObject sqlQueryObjectGet_erogatore_soggetto = sqlQueryObjectGet.newSQLQueryObject();
        sqlQueryObjectGet_erogatore_soggetto.addFromTable("soggetti");
        sqlQueryObjectGet_erogatore_soggetto.addSelectField("tipo_soggetto");
        sqlQueryObjectGet_erogatore_soggetto.addSelectField("nome_soggetto");
        sqlQueryObjectGet_erogatore_soggetto.setANDLogicOperator(true);
        sqlQueryObjectGet_erogatore_soggetto.addWhereCondition("id=?");
        JDBCObject[] searchParams_erogatore_soggetto = new JDBCObject[]{new JDBCObject((Object)idSoggettoAccordoParteSpecifica, Long.class)};
        ArrayList<Class<String>> listaFieldIdReturnType_erogatore_soggetto = new ArrayList<Class<String>>();
        listaFieldIdReturnType_erogatore_soggetto.add(String.class);
        listaFieldIdReturnType_erogatore_soggetto.add(String.class);
        List listaFieldId_erogatore_soggetto = jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet_fruitore_soggetto.createSQLQuery(), jdbcProperties.isShowSql(), listaFieldIdReturnType_erogatore_soggetto, searchParams_erogatore_soggetto);
        IdSoggetto id_erogatore_soggetto = new IdSoggetto();
        id_erogatore_soggetto.setTipo((String)listaFieldId_erogatore_soggetto.get(0));
        id_erogatore_soggetto.setNome((String)listaFieldId_erogatore_soggetto.get(1));
        id_fruitore_accordoServizioParteSpecifica.setIdErogatore(id_erogatore_soggetto);
        fruitore.setIdAccordoServizioParteSpecifica(id_fruitore_accordoServizioParteSpecifica);
        return fruitore;
    }

    public boolean exists(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId) throws MultipleResultException, NotImplementedException, ServiceException, Exception {
        return this._exists(jdbcProperties, log, connection, sqlQueryObject, tableId);
    }

    private boolean _exists(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Long tableId) throws MultipleResultException, NotImplementedException, ServiceException, Exception {
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        boolean existsFruitore = false;
        sqlQueryObject = sqlQueryObject.newSQLQueryObject();
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addFromTable(this.getFruitoreFieldConverter().toTable((IModel)Fruitore.model()));
        sqlQueryObject.addSelectField(this.getFruitoreFieldConverter().toColumn(Fruitore.model().ORA_REGISTRAZIONE, true));
        sqlQueryObject.addWhereCondition("id=?");
        existsFruitore = jdbcUtilities.exists(sqlQueryObject.createSQLQuery(), jdbcProperties.isShowSql(), new JDBCObject[]{new JDBCObject((Object)tableId, Long.class)});
        return existsFruitore;
    }

    private void joinEngine(IExpression expression, ISQLQueryObject sqlQueryObject) throws NotImplementedException, ServiceException, Exception {
        String tableName2;
        String tableName1;
        if (expression.inUseModel((IModel)Fruitore.model().ID_FRUITORE, false)) {
            tableName1 = this.getFruitoreFieldConverter().toTable((IModel)Fruitore.model());
            tableName2 = this.getFruitoreFieldConverter().toAliasTable((IModel)Fruitore.model().ID_FRUITORE);
            sqlQueryObject.addWhereCondition(tableName1 + ".id_soggetto=" + tableName2 + ".id");
        }
        if (expression.inUseModel((IModel)Fruitore.model().ID_ACCORDO_SERVIZIO_PARTE_SPECIFICA, false)) {
            tableName1 = this.getFruitoreFieldConverter().toTable((IModel)Fruitore.model());
            tableName2 = this.getFruitoreFieldConverter().toTable((IModel)Fruitore.model().ID_ACCORDO_SERVIZIO_PARTE_SPECIFICA);
            sqlQueryObject.addWhereCondition(tableName1 + ".id_servizio=" + tableName2 + ".id");
        }
        if (expression.inUseModel((IModel)Fruitore.model().ID_ACCORDO_SERVIZIO_PARTE_SPECIFICA.ID_EROGATORE, false)) {
            tableName1 = this.getFruitoreFieldConverter().toTable((IModel)Fruitore.model().ID_ACCORDO_SERVIZIO_PARTE_SPECIFICA);
            tableName2 = this.getFruitoreFieldConverter().toAliasTable((IModel)Fruitore.model().ID_ACCORDO_SERVIZIO_PARTE_SPECIFICA.ID_EROGATORE);
            sqlQueryObject.addWhereCondition(tableName1 + ".id_soggetto=" + tableName2 + ".id");
        }
        if (expression.inUseModel((IModel)Fruitore.model().ID_ACCORDO_SERVIZIO_PARTE_SPECIFICA.ID_EROGATORE, false) && !expression.inUseModel((IModel)Fruitore.model().ID_ACCORDO_SERVIZIO_PARTE_SPECIFICA, false)) {
            sqlQueryObject.addFromTable(this.getFruitoreFieldConverter().toTable((IModel)Fruitore.model().ID_ACCORDO_SERVIZIO_PARTE_SPECIFICA));
        }
    }

    protected List<Object> getRootTablePrimaryKeyValuesEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdFruitore id) throws NotFoundException, ServiceException, NotImplementedException, Exception {
        ArrayList<Object> rootTableIdValues = new ArrayList<Object>();
        Long longId = this.findIdFruitore(jdbcProperties, log, connection, sqlQueryObject.newSQLQueryObject(), id, true);
        rootTableIdValues.add(longId);
        return rootTableIdValues;
    }

    protected Map<String, List<IField>> getMapTableToPKColumnEngine() throws NotImplementedException, Exception {
        FruitoreFieldConverter converter = this.getFruitoreFieldConverter();
        HashMap<String, List<IField>> mapTableToPKColumn = new HashMap<String, List<IField>>();
        UtilsTemplate utilities = new UtilsTemplate();
        mapTableToPKColumn.put(converter.toTable((IModel)Fruitore.model()), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)Fruitore.model()))}));
        mapTableToPKColumn.put(converter.toTable((IModel)Fruitore.model().ID_FRUITORE), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)Fruitore.model().ID_FRUITORE))}));
        mapTableToPKColumn.put(converter.toTable((IModel)Fruitore.model().ID_ACCORDO_SERVIZIO_PARTE_SPECIFICA), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)Fruitore.model().ID_ACCORDO_SERVIZIO_PARTE_SPECIFICA))}));
        mapTableToPKColumn.put(converter.toTable((IModel)Fruitore.model().ID_ACCORDO_SERVIZIO_PARTE_SPECIFICA.ID_EROGATORE), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)Fruitore.model().ID_ACCORDO_SERVIZIO_PARTE_SPECIFICA.ID_EROGATORE))}));
        return mapTableToPKColumn;
    }

    public List<Long> findAllTableIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression) throws ServiceException, NotImplementedException, Exception {
        ArrayList<Long> list = new ArrayList<Long>();
        sqlQueryObject.setSelectDistinct(true);
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addSelectField(this.getFruitoreFieldConverter().toTable((IModel)Fruitore.model()) + ".id");
        Class<Long> objectIdClass = Long.class;
        List listaQuery = GenericJDBCUtilities.prepareFindAll((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)paginatedExpression, (ISQLFieldConverter)this.getFruitoreFieldConverter(), (IModel)Fruitore.model());
        this.joinEngine((IExpression)paginatedExpression, sqlQueryObject);
        List listObjects = GenericJDBCUtilities.findAll((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)paginatedExpression, (ISQLFieldConverter)this.getFruitoreFieldConverter(), (IModel)Fruitore.model(), objectIdClass, (List)listaQuery);
        for (Object object : listObjects) {
            list.add((Long)object);
        }
        return list;
    }

    public long findTableId(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression) throws ServiceException, NotFoundException, MultipleResultException, NotImplementedException, Exception {
        sqlQueryObject.setSelectDistinct(true);
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addSelectField(this.getFruitoreFieldConverter().toTable((IModel)Fruitore.model()) + ".id");
        Class<Long> objectIdClass = Long.class;
        List listaQuery = GenericJDBCUtilities.prepareFind((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getFruitoreFieldConverter(), (IModel)Fruitore.model());
        this.joinEngine((IExpression)expression, sqlQueryObject);
        Object res = GenericJDBCUtilities.find((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getFruitoreFieldConverter(), (IModel)Fruitore.model(), objectIdClass, (List)listaQuery);
        if (res != null && (Long)res > 0L) {
            return (Long)res;
        }
        throw GenericJDBCUtilities.newNotFoundException();
    }

    public InUse inUse(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return this.inUseEngine(jdbcProperties, log, connection, sqlQueryObject, tableId);
    }

    private InUse inUseEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Long tableId) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        InUse inUse = new InUse();
        inUse.setInUse(false);
        boolean throwNotImplemented = true;
        if (throwNotImplemented) {
            throw new NotImplementedException("NotImplemented");
        }
        return inUse;
    }

    public IdFruitore findId(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, boolean throwNotFound) throws NotFoundException, ServiceException, NotImplementedException, Exception {
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        ISQLQueryObject sqlQueryObjectGet = sqlQueryObject.newSQLQueryObject();
        sqlQueryObjectGet.addFromTable(this.getFruitoreFieldConverter().toTable((IModel)Fruitore.model()));
        sqlQueryObjectGet.addSelectField("id_soggetto");
        sqlQueryObjectGet.addSelectField("id_servizio");
        sqlQueryObjectGet.setANDLogicOperator(true);
        sqlQueryObjectGet.addWhereCondition("id=?");
        JDBCObject[] searchParams_fruitore = new JDBCObject[]{new JDBCObject((Object)tableId, Long.class)};
        ArrayList<Class<Long>> listaFieldIdReturnType_fruitore = new ArrayList<Class<Long>>();
        listaFieldIdReturnType_fruitore.add(Long.class);
        listaFieldIdReturnType_fruitore.add(Long.class);
        IdFruitore id_fruitore = null;
        List listaFieldId_fruitore = jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet.createSQLQuery(), jdbcProperties.isShowSql(), listaFieldIdReturnType_fruitore, searchParams_fruitore);
        if (listaFieldId_fruitore == null || listaFieldId_fruitore.size() <= 0) {
            if (throwNotFound) {
                throw GenericJDBCUtilities.newNotFoundException();
            }
        } else {
            id_fruitore = new IdFruitore();
            Long idSoggettoFK = (Long)listaFieldId_fruitore.get(0);
            id_fruitore.setIdFruitore((IdSoggetto)((IDBSoggettoServiceSearch)this.getServiceManager(connection, jdbcProperties, log).getSoggettoServiceSearch()).findId(idSoggettoFK, true));
            Long idParteSpecificaFK = (Long)listaFieldId_fruitore.get(1);
            id_fruitore.setIdAccordoServizioParteSpecifica((IdAccordoServizioParteSpecifica)((IDBAccordoServizioParteSpecificaServiceSearch)this.getServiceManager(connection, jdbcProperties, log).getAccordoServizioParteSpecificaServiceSearch()).findId(idParteSpecificaFK, true));
        }
        return id_fruitore;
    }

    public Long findTableId(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdFruitore id, boolean throwNotFound) throws NotFoundException, ServiceException, NotImplementedException, Exception {
        return this.findIdFruitore(jdbcProperties, log, connection, sqlQueryObject, id, throwNotFound);
    }

    public List<List<Object>> nativeQuery(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, String sql, List<Class<?>> returnClassTypes, Object ... param) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return GenericJDBCUtilities.nativeQuery((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)sql, returnClassTypes, (Object[])param);
    }

    protected Long findIdFruitore(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdFruitore id, boolean throwNotFound) throws NotFoundException, ServiceException, NotImplementedException, Exception {
        Long id_fruitore;
        block6: {
            if (jdbcProperties == null) {
                throw new ServiceException("Param jdbcProperties is null");
            }
            if (sqlQueryObject == null) {
                throw new ServiceException("Param sqlQueryObject is null");
            }
            if (id == null) {
                throw new ServiceException("Param id is null");
            }
            JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
            ISQLQueryObject sqlQueryObjectGet = sqlQueryObject.newSQLQueryObject();
            IDBSoggettoServiceSearch soggettoServiceSearch = (IDBSoggettoServiceSearch)this.getServiceManager(connection, jdbcProperties, log).getSoggettoServiceSearch();
            Long idSoggettoFruitore = ((Soggetto)soggettoServiceSearch.get(id.getIdFruitore())).getId();
            IDBAccordoServizioParteSpecificaServiceSearch accordoServizioParteSpecificaServiceSearch = (IDBAccordoServizioParteSpecificaServiceSearch)this.getServiceManager(connection, jdbcProperties, log).getAccordoServizioParteSpecificaServiceSearch();
            Long idAccordoServizioParteSpecifica = ((AccordoServizioParteSpecifica)accordoServizioParteSpecificaServiceSearch.get(id.getIdAccordoServizioParteSpecifica())).getId();
            sqlQueryObjectGet.addFromTable(this.getFruitoreFieldConverter().toTable((IModel)Fruitore.model()));
            sqlQueryObjectGet.addSelectField("id");
            sqlQueryObjectGet.setANDLogicOperator(true);
            sqlQueryObjectGet.setSelectDistinct(true);
            sqlQueryObjectGet.addWhereCondition("id_soggetto=?");
            sqlQueryObjectGet.addWhereCondition("id_servizio=?");
            JDBCObject[] searchParams_fruitore = new JDBCObject[]{new JDBCObject((Object)idSoggettoFruitore, Long.class), new JDBCObject((Object)idAccordoServizioParteSpecifica, Long.class)};
            id_fruitore = null;
            try {
                id_fruitore = (Long)jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet.createSQLQuery(), jdbcProperties.isShowSql(), Long.class, searchParams_fruitore);
            }
            catch (NotFoundException notFound) {
                if (!throwNotFound) break block6;
                throw new NotFoundException((Throwable)notFound);
            }
        }
        if ((id_fruitore == null || id_fruitore <= 0L) && throwNotFound) {
            throw GenericJDBCUtilities.newNotFoundException();
        }
        return id_fruitore;
    }
}

