/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.byok.BYOKUtilities;
import org.openspcoop2.core.byok.IDriverBYOK;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.IExtendedInfo;
import org.openspcoop2.core.config.AccessoConfigurazione;
import org.openspcoop2.core.config.AccessoDatiAttributeAuthority;
import org.openspcoop2.core.config.AccessoDatiAutenticazione;
import org.openspcoop2.core.config.AccessoDatiAutorizzazione;
import org.openspcoop2.core.config.AccessoDatiConsegnaApplicativi;
import org.openspcoop2.core.config.AccessoDatiGestioneToken;
import org.openspcoop2.core.config.AccessoDatiKeystore;
import org.openspcoop2.core.config.AccessoDatiRichieste;
import org.openspcoop2.core.config.AccessoRegistro;
import org.openspcoop2.core.config.AccessoRegistroRegistro;
import org.openspcoop2.core.config.Attachments;
import org.openspcoop2.core.config.Cache;
import org.openspcoop2.core.config.CanaliConfigurazione;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.ConfigurazioneGeneraleHandler;
import org.openspcoop2.core.config.ConfigurazioneGestioneErrore;
import org.openspcoop2.core.config.ConfigurazioneMessageHandlers;
import org.openspcoop2.core.config.ConfigurazioneMultitenant;
import org.openspcoop2.core.config.ConfigurazioneServiceHandlers;
import org.openspcoop2.core.config.ConfigurazioneTracciamentoPorta;
import org.openspcoop2.core.config.ConfigurazioneUrlInvocazione;
import org.openspcoop2.core.config.ConfigurazioneUrlInvocazioneRegola;
import org.openspcoop2.core.config.CorsConfigurazione;
import org.openspcoop2.core.config.Dump;
import org.openspcoop2.core.config.DumpConfigurazione;
import org.openspcoop2.core.config.GestioneErrore;
import org.openspcoop2.core.config.IdSoggetto;
import org.openspcoop2.core.config.IndirizzoRisposta;
import org.openspcoop2.core.config.InoltroBusteNonRiscontrate;
import org.openspcoop2.core.config.IntegrationManager;
import org.openspcoop2.core.config.MessaggiDiagnostici;
import org.openspcoop2.core.config.OpenspcoopAppender;
import org.openspcoop2.core.config.OpenspcoopSorgenteDati;
import org.openspcoop2.core.config.Property;
import org.openspcoop2.core.config.ResponseCachingConfigurazione;
import org.openspcoop2.core.config.ResponseCachingConfigurazioneGenerale;
import org.openspcoop2.core.config.Risposte;
import org.openspcoop2.core.config.RoutingTable;
import org.openspcoop2.core.config.StatoServiziPdd;
import org.openspcoop2.core.config.StatoServiziPddIntegrationManager;
import org.openspcoop2.core.config.StatoServiziPddPortaApplicativa;
import org.openspcoop2.core.config.StatoServiziPddPortaDelegata;
import org.openspcoop2.core.config.SystemProperties;
import org.openspcoop2.core.config.TipoFiltroAbilitazioneServizi;
import org.openspcoop2.core.config.Tracciamento;
import org.openspcoop2.core.config.TracciamentoConfigurazione;
import org.openspcoop2.core.config.TracciamentoConfigurazioneFiletrace;
import org.openspcoop2.core.config.Transazioni;
import org.openspcoop2.core.config.ValidazioneBuste;
import org.openspcoop2.core.config.ValidazioneContenutiApplicativi;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.RegistroTipo;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.ExtendedInfoManager;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBLib;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBTracciamentoLIB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_canaliLIB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_configLIB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_dumpLIB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_genericPropertiesDriver;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_gestioneErroreDriver;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_handlerLIB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_porteDriver;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_routingTableDriver;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverConfigurazioneDB_configDriver {
    private DriverConfigurazioneDB driver = null;
    private DriverConfigurazioneDB_porteDriver porteDriver = null;
    private DriverConfigurazioneDB_gestioneErroreDriver gestioneErroreDriver = null;
    private DriverConfigurazioneDB_routingTableDriver routingTableDriver = null;
    private DriverConfigurazioneDB_genericPropertiesDriver genericPropertiesDriver = null;

    protected DriverConfigurazioneDB_configDriver(DriverConfigurazioneDB driver) {
        this.driver = driver;
        this.porteDriver = new DriverConfigurazioneDB_porteDriver(driver);
        this.gestioneErroreDriver = new DriverConfigurazioneDB_gestioneErroreDriver(driver);
        this.routingTableDriver = new DriverConfigurazioneDB_routingTableDriver(driver);
        this.genericPropertiesDriver = new DriverConfigurazioneDB_genericPropertiesDriver(driver);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AccessoRegistro getAccessoRegistro() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        AccessoRegistro accessoRegistro;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getAccessoRegistro");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoRegistro] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            AccessoRegistro car = new AccessoRegistro();
            Cache cache = null;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("registri");
            sqlQueryObject.addSelectField("*");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            rs = stm.executeQuery();
            AccessoRegistroRegistro itemcar = null;
            while (rs.next()) {
                itemcar = new AccessoRegistroRegistro();
                RegistroTipo tipoReg = CostantiConfigurazione.REGISTRO_XML;
                String tmpTipo = rs.getString("tipo");
                if (tmpTipo.equals("uddi")) {
                    tipoReg = CostantiConfigurazione.REGISTRO_UDDI;
                } else if (tmpTipo.equals("web")) {
                    tipoReg = CostantiConfigurazione.REGISTRO_WEB;
                } else if (tmpTipo.equals("db")) {
                    tipoReg = CostantiConfigurazione.REGISTRO_DB;
                } else if (tmpTipo.equals("ws")) {
                    tipoReg = CostantiConfigurazione.REGISTRO_WS;
                }
                itemcar.setTipo(tipoReg);
                itemcar.setNome(rs.getString("nome"));
                itemcar.setLocation(rs.getString("location"));
                String tmpUser = rs.getString("utente");
                String tmpPw = rs.getString("password");
                if (tmpUser != null && tmpPw != null && !tmpUser.equals("") && !tmpPw.equals("")) {
                    itemcar.setUser(tmpUser);
                    itemcar.setPassword(tmpPw);
                }
                car.addRegistro(itemcar);
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("configurazione");
            sqlQueryObject.addSelectField("*");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            this.driver.logDebug("eseguo query : " + sqlQuery);
            rs = stm.executeQuery();
            if (rs.next()) {
                String tmpCache = rs.getString("statocache");
                if (CostantiConfigurazione.ABILITATO.equals(tmpCache)) {
                    String tmpAlg;
                    cache = new Cache();
                    String tmpDim = rs.getString("dimensionecache");
                    if (tmpDim != null && !tmpDim.equals("")) {
                        cache.setDimensione(tmpDim);
                    }
                    if ((tmpAlg = rs.getString("algoritmocache")).equalsIgnoreCase("LRU")) {
                        cache.setAlgoritmo(CostantiConfigurazione.CACHE_LRU);
                    } else {
                        cache.setAlgoritmo(CostantiConfigurazione.CACHE_MRU);
                    }
                    String tmpIdle = rs.getString("idlecache");
                    String tmpLife = rs.getString("lifecache");
                    if (tmpIdle != null && !tmpIdle.equals("")) {
                        cache.setItemIdleTime(tmpIdle);
                    }
                    if (tmpLife != null && !tmpLife.equals("")) {
                        cache.setItemLifeSecond(tmpLife);
                    }
                    car.setCache(cache);
                }
                rs.close();
                stm.close();
            }
            accessoRegistro = car;
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoRegistro] SqlException: " + se.getMessage(), se);
                catch (Exception se2) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoRegistro] Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return accessoRegistro;
    }

    protected void createAccessoRegistro(AccessoRegistroRegistro registro) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("createAccessoRegistro");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createAccessoRegistro] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDAccessoRegistro type = 1");
            DriverConfigurazioneDB_configLIB.CRUDAccessoRegistro(1, registro, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createAccessoRegistro] Errore durante la createAccessoRegistro : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void updateAccessoRegistro(AccessoRegistroRegistro registro) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("updateAccessoRegistro");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateAccessoRegistro] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDAccessoRegistro type = 2");
            DriverConfigurazioneDB_configLIB.CRUDAccessoRegistro(2, registro, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateAccessoRegistro] Errore durante la updateAccessoRegistro : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void deleteAccessoRegistro(AccessoRegistroRegistro registro) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("deleteAccessoRegistro");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteAccessoRegistro] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDAccessoRegistro type = 3");
            DriverConfigurazioneDB_configLIB.CRUDAccessoRegistro(3, registro, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteAccessoRegistro] Errore durante la deleteAccessoRegistro : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AccessoConfigurazione getAccessoConfigurazione() throws DriverConfigurazioneException {
        AccessoConfigurazione accessoConfigurazione;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getAccessoConfigurazione");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoConfigurazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            AccessoConfigurazione accessoConfigurazione2 = new AccessoConfigurazione();
            Cache cache = null;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("configurazione");
            sqlQueryObject.addSelectField("*");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            this.driver.logDebug("eseguo query : " + sqlQuery);
            rs = stm.executeQuery();
            if (rs.next()) {
                String tmpCache = rs.getString("config_statocache");
                if (CostantiConfigurazione.ABILITATO.equals(tmpCache)) {
                    String tmpAlg;
                    cache = new Cache();
                    String tmpDim = rs.getString("config_dimensionecache");
                    if (tmpDim != null && !tmpDim.equals("")) {
                        cache.setDimensione(tmpDim);
                    }
                    if ((tmpAlg = rs.getString("config_algoritmocache")).equalsIgnoreCase("LRU")) {
                        cache.setAlgoritmo(CostantiConfigurazione.CACHE_LRU);
                    } else {
                        cache.setAlgoritmo(CostantiConfigurazione.CACHE_MRU);
                    }
                    String tmpIdle = rs.getString("config_idlecache");
                    String tmpLife = rs.getString("config_lifecache");
                    if (tmpIdle != null && !tmpIdle.equals("")) {
                        cache.setItemIdleTime(tmpIdle);
                    }
                    if (tmpLife != null && !tmpLife.equals("")) {
                        cache.setItemLifeSecond(tmpLife);
                    }
                    accessoConfigurazione2.setCache(cache);
                }
                rs.close();
                stm.close();
            }
            accessoConfigurazione = accessoConfigurazione2;
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoConfigurazione] SqlException: " + se.getMessage(), se);
                catch (Exception se2) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoConfigurazione] Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return accessoConfigurazione;
    }

    protected void createAccessoConfigurazione(AccessoConfigurazione accessoConfigurazione) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("createAccessoConfigurazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createAccessoConfigurazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDAccessoConfigurazione type = 1");
            DriverConfigurazioneDB_configLIB.CRUDAccessoConfigurazione(1, accessoConfigurazione, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createAccessoConfigurazione] Errore durante la createAccessoConfigurazione : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void updateAccessoConfigurazione(AccessoConfigurazione accessoConfigurazione) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("updateAccessoConfigurazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateAccessoConfigurazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDAccessoConfigurazione type = 2");
            DriverConfigurazioneDB_configLIB.CRUDAccessoConfigurazione(2, accessoConfigurazione, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateAccessoConfigurazione] Errore durante la updateAccessoConfigurazione : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void deleteAccessoConfigurazione(AccessoConfigurazione accessoConfigurazione) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("deleteAccessoConfigurazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteAccessoConfigurazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDAccessoConfigurazione type = 3");
            DriverConfigurazioneDB_configLIB.CRUDAccessoConfigurazione(3, accessoConfigurazione, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteAccessoConfigurazione] Errore durante la deleteAccessoConfigurazione : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AccessoDatiAutorizzazione getAccessoDatiAutorizzazione() throws DriverConfigurazioneException {
        AccessoDatiAutorizzazione accessoDatiAutorizzazione;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getAccessoDatiAutorizzazione");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoDatiAutorizzazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            AccessoDatiAutorizzazione accessoDatiAutorizzazione2 = new AccessoDatiAutorizzazione();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("configurazione");
            sqlQueryObject.addSelectField("*");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            this.driver.logDebug("eseguo query : " + sqlQuery);
            rs = stm.executeQuery();
            if (rs.next()) {
                this.readAccessoDatiAutorizzazione(rs, accessoDatiAutorizzazione2);
                rs.close();
                stm.close();
            }
            accessoDatiAutorizzazione = accessoDatiAutorizzazione2;
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoDatiAutorizzazione] SqlException: " + se.getMessage(), se);
                catch (Exception se2) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoDatiAutorizzazione] Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return accessoDatiAutorizzazione;
    }

    private void readAccessoDatiAutorizzazione(ResultSet rs, AccessoDatiAutorizzazione accessoDatiAutorizzazione) throws SQLException {
        String tmpCache = rs.getString("auth_statocache");
        if (CostantiConfigurazione.ABILITATO.equals(tmpCache)) {
            String tmpAlg;
            Cache cache = new Cache();
            String tmpDim = rs.getString("auth_dimensionecache");
            if (tmpDim != null && !tmpDim.equals("")) {
                cache.setDimensione(tmpDim);
            }
            if ((tmpAlg = rs.getString("auth_algoritmocache")).equalsIgnoreCase("LRU")) {
                cache.setAlgoritmo(CostantiConfigurazione.CACHE_LRU);
            } else {
                cache.setAlgoritmo(CostantiConfigurazione.CACHE_MRU);
            }
            String tmpIdle = rs.getString("auth_idlecache");
            String tmpLife = rs.getString("auth_lifecache");
            if (tmpIdle != null && !tmpIdle.equals("")) {
                cache.setItemIdleTime(tmpIdle);
            }
            if (tmpLife != null && !tmpLife.equals("")) {
                cache.setItemLifeSecond(tmpLife);
            }
            accessoDatiAutorizzazione.setCache(cache);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AccessoDatiAutenticazione getAccessoDatiAutenticazione() throws DriverConfigurazioneException {
        AccessoDatiAutenticazione accessoDatiAutenticazione;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getAccessoDatiAutenticazione");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoDatiAutenticazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            AccessoDatiAutenticazione accessoDatiAutenticazione2 = new AccessoDatiAutenticazione();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("configurazione");
            sqlQueryObject.addSelectField("*");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            this.driver.logDebug("eseguo query : " + sqlQuery);
            rs = stm.executeQuery();
            if (rs.next()) {
                this.readAccessoDatiAutenticazione(rs, accessoDatiAutenticazione2);
                rs.close();
                stm.close();
            }
            accessoDatiAutenticazione = accessoDatiAutenticazione2;
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoDatiAutenticazione] SqlException: " + se.getMessage(), se);
                catch (Exception se2) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoDatiAutenticazione] Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return accessoDatiAutenticazione;
    }

    private void readAccessoDatiAutenticazione(ResultSet rs, AccessoDatiAutenticazione accessoDatiAutenticazione) throws SQLException {
        String tmpCache = rs.getString("authn_statocache");
        if (CostantiConfigurazione.ABILITATO.equals(tmpCache)) {
            String tmpAlg;
            Cache cache = new Cache();
            String tmpDim = rs.getString("authn_dimensionecache");
            if (tmpDim != null && !tmpDim.equals("")) {
                cache.setDimensione(tmpDim);
            }
            if ((tmpAlg = rs.getString("authn_algoritmocache")).equalsIgnoreCase("LRU")) {
                cache.setAlgoritmo(CostantiConfigurazione.CACHE_LRU);
            } else {
                cache.setAlgoritmo(CostantiConfigurazione.CACHE_MRU);
            }
            String tmpIdle = rs.getString("authn_idlecache");
            String tmpLife = rs.getString("authn_lifecache");
            if (tmpIdle != null && !tmpIdle.equals("")) {
                cache.setItemIdleTime(tmpIdle);
            }
            if (tmpLife != null && !tmpLife.equals("")) {
                cache.setItemLifeSecond(tmpLife);
            }
            accessoDatiAutenticazione.setCache(cache);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AccessoDatiGestioneToken getAccessoDatiGestioneToken() throws DriverConfigurazioneException {
        AccessoDatiGestioneToken accessoDatiGestioneToken;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getAccessoDatiGestioneToken");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoDatiGestioneToken] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            AccessoDatiGestioneToken accessoDatiGestioneToken2 = new AccessoDatiGestioneToken();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("configurazione");
            sqlQueryObject.addSelectField("*");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            this.driver.logDebug("eseguo query : " + sqlQuery);
            rs = stm.executeQuery();
            if (rs.next()) {
                this.readAccessoDatiGestioneToken(rs, accessoDatiGestioneToken2);
                rs.close();
                stm.close();
            }
            accessoDatiGestioneToken = accessoDatiGestioneToken2;
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoDatiGestioneToken] SqlException: " + se.getMessage(), se);
                catch (Exception se2) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoDatiGestioneToken] Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return accessoDatiGestioneToken;
    }

    private void readAccessoDatiGestioneToken(ResultSet rs, AccessoDatiGestioneToken accessoDatiGestioneToken) throws SQLException {
        String tmpCache = rs.getString("token_statocache");
        if (CostantiConfigurazione.ABILITATO.equals(tmpCache)) {
            String tmpAlg;
            Cache cache = new Cache();
            String tmpDim = rs.getString("token_dimensionecache");
            if (tmpDim != null && !tmpDim.equals("")) {
                cache.setDimensione(tmpDim);
            }
            if ((tmpAlg = rs.getString("token_algoritmocache")).equalsIgnoreCase("LRU")) {
                cache.setAlgoritmo(CostantiConfigurazione.CACHE_LRU);
            } else {
                cache.setAlgoritmo(CostantiConfigurazione.CACHE_MRU);
            }
            String tmpIdle = rs.getString("token_idlecache");
            String tmpLife = rs.getString("token_lifecache");
            if (tmpIdle != null && !tmpIdle.equals("")) {
                cache.setItemIdleTime(tmpIdle);
            }
            if (tmpLife != null && !tmpLife.equals("")) {
                cache.setItemLifeSecond(tmpLife);
            }
            accessoDatiGestioneToken.setCache(cache);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AccessoDatiAttributeAuthority getAccessoDatiAttributeAuthority() throws DriverConfigurazioneException {
        AccessoDatiAttributeAuthority accessoDatiAttributeAuthority;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getAccessoDatiAttributeAuthority");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoDatiAttributeAuthority] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            AccessoDatiAttributeAuthority accessoDatiAttributeAuthority2 = new AccessoDatiAttributeAuthority();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("configurazione");
            sqlQueryObject.addSelectField("*");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            this.driver.logDebug("eseguo query : " + sqlQuery);
            rs = stm.executeQuery();
            if (rs.next()) {
                this.readAccessoDatiAttributeAuthority(rs, accessoDatiAttributeAuthority2);
                rs.close();
                stm.close();
            }
            accessoDatiAttributeAuthority = accessoDatiAttributeAuthority2;
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoDatiAttributeAuthority] SqlException: " + se.getMessage(), se);
                catch (Exception se2) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoDatiAttributeAuthority] Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return accessoDatiAttributeAuthority;
    }

    private void readAccessoDatiAttributeAuthority(ResultSet rs, AccessoDatiAttributeAuthority accessoDatiAttributeAuthority) throws SQLException {
        String tmpCache = rs.getString("aa_statocache");
        if (CostantiConfigurazione.ABILITATO.equals(tmpCache)) {
            String tmpAlg;
            Cache cache = new Cache();
            String tmpDim = rs.getString("aa_dimensionecache");
            if (tmpDim != null && !tmpDim.equals("")) {
                cache.setDimensione(tmpDim);
            }
            if ((tmpAlg = rs.getString("aa_algoritmocache")).equalsIgnoreCase("LRU")) {
                cache.setAlgoritmo(CostantiConfigurazione.CACHE_LRU);
            } else {
                cache.setAlgoritmo(CostantiConfigurazione.CACHE_MRU);
            }
            String tmpIdle = rs.getString("aa_idlecache");
            String tmpLife = rs.getString("aa_lifecache");
            if (tmpIdle != null && !tmpIdle.equals("")) {
                cache.setItemIdleTime(tmpIdle);
            }
            if (tmpLife != null && !tmpLife.equals("")) {
                cache.setItemLifeSecond(tmpLife);
            }
            accessoDatiAttributeAuthority.setCache(cache);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AccessoDatiKeystore getAccessoDatiKeystore() throws DriverConfigurazioneException {
        AccessoDatiKeystore accessoDatiKeystore;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getAccessoDatiKeystore");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoDatiKeystore] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            AccessoDatiKeystore accessoDatiKeystore2 = new AccessoDatiKeystore();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("configurazione");
            sqlQueryObject.addSelectField("*");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            this.driver.logDebug("eseguo query : " + sqlQuery);
            rs = stm.executeQuery();
            if (rs.next()) {
                this.readAccessoDatiKeystore(rs, accessoDatiKeystore2);
                rs.close();
                stm.close();
            }
            accessoDatiKeystore = accessoDatiKeystore2;
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoDatiKeystore] SqlException: " + se.getMessage(), se);
                catch (Exception se2) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoDatiKeystore] Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return accessoDatiKeystore;
    }

    private void readAccessoDatiKeystore(ResultSet rs, AccessoDatiKeystore accessoDatiKeystore) throws SQLException {
        String tmpCache = rs.getString("keystore_statocache");
        if (CostantiConfigurazione.ABILITATO.equals(tmpCache)) {
            String tmpAlg;
            Cache cache = new Cache();
            String tmpDim = rs.getString("keystore_dimensionecache");
            if (tmpDim != null && !tmpDim.equals("")) {
                cache.setDimensione(tmpDim);
            }
            if ((tmpAlg = rs.getString("keystore_algoritmocache")).equalsIgnoreCase("LRU")) {
                cache.setAlgoritmo(CostantiConfigurazione.CACHE_LRU);
            } else {
                cache.setAlgoritmo(CostantiConfigurazione.CACHE_MRU);
            }
            String tmpIdle = rs.getString("keystore_idlecache");
            String tmpLife = rs.getString("keystore_lifecache");
            if (tmpIdle != null && !tmpIdle.equals("")) {
                cache.setItemIdleTime(tmpIdle);
            }
            if (tmpLife != null && !tmpLife.equals("")) {
                cache.setItemLifeSecond(tmpLife);
            }
            accessoDatiKeystore.setCache(cache);
            this.readAccessoDatiKeystoreCrlLife(rs, accessoDatiKeystore);
        }
    }

    private void readAccessoDatiKeystoreCrlLife(ResultSet rs, AccessoDatiKeystore accessoDatiKeystore) throws SQLException {
        String tmpCrlLife = rs.getString("keystore_crl_lifecache");
        if (tmpCrlLife != null && !tmpCrlLife.equals("")) {
            accessoDatiKeystore.setCrlItemLifeSecond(tmpCrlLife);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AccessoDatiConsegnaApplicativi getAccessoDatiConsegnaApplicativi() throws DriverConfigurazioneException {
        AccessoDatiConsegnaApplicativi accessoDatiConsegnaApplicativi;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getAccessoDatiConsegnaApplicativi");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoDatiConsegnaApplicativi] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            AccessoDatiConsegnaApplicativi accessoDatiConsegnaApplicativi2 = new AccessoDatiConsegnaApplicativi();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("configurazione");
            sqlQueryObject.addSelectField("*");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            this.driver.logDebug("eseguo query : " + sqlQuery);
            rs = stm.executeQuery();
            if (rs.next()) {
                this.readAccessoDatiConsegnaApplicativi(rs, accessoDatiConsegnaApplicativi2);
                rs.close();
                stm.close();
            }
            accessoDatiConsegnaApplicativi = accessoDatiConsegnaApplicativi2;
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoDatiConsegnaApplicativi] SqlException: " + se.getMessage(), se);
                catch (Exception se2) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoDatiConsegnaApplicativi] Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return accessoDatiConsegnaApplicativi;
    }

    private void readAccessoDatiConsegnaApplicativi(ResultSet rs, AccessoDatiConsegnaApplicativi accessoDatiConsegnaApplicativi) throws SQLException {
        String tmpCache = rs.getString("consegna_statocache");
        if (CostantiConfigurazione.ABILITATO.equals(tmpCache)) {
            String tmpAlg;
            Cache cache = new Cache();
            String tmpDim = rs.getString("consegna_dimensionecache");
            if (tmpDim != null && !tmpDim.equals("")) {
                cache.setDimensione(tmpDim);
            }
            if ((tmpAlg = rs.getString("consegna_algoritmocache")).equalsIgnoreCase("LRU")) {
                cache.setAlgoritmo(CostantiConfigurazione.CACHE_LRU);
            } else {
                cache.setAlgoritmo(CostantiConfigurazione.CACHE_MRU);
            }
            String tmpIdle = rs.getString("consegna_idlecache");
            String tmpLife = rs.getString("consegna_lifecache");
            if (tmpIdle != null && !tmpIdle.equals("")) {
                cache.setItemIdleTime(tmpIdle);
            }
            if (tmpLife != null && !tmpLife.equals("")) {
                cache.setItemLifeSecond(tmpLife);
            }
            accessoDatiConsegnaApplicativi.setCache(cache);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AccessoDatiRichieste getAccessoDatiRichieste() throws DriverConfigurazioneException {
        AccessoDatiRichieste accessoDatiRichieste;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getAccessoDatiRichieste");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoDatiRichieste] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            AccessoDatiRichieste accessoDatiRichieste2 = new AccessoDatiRichieste();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("configurazione");
            sqlQueryObject.addSelectField("*");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            this.driver.logDebug("eseguo query : " + sqlQuery);
            rs = stm.executeQuery();
            if (rs.next()) {
                this.readAccessoDatiRichieste(rs, accessoDatiRichieste2);
                rs.close();
                stm.close();
            }
            accessoDatiRichieste = accessoDatiRichieste2;
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoDatiRichieste] SqlException: " + se.getMessage(), se);
                catch (Exception se2) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoDatiRichieste] Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return accessoDatiRichieste;
    }

    private void readAccessoDatiRichieste(ResultSet rs, AccessoDatiRichieste accessoDatiRichieste) throws SQLException {
        String tmpCache = rs.getString("dati_richieste_statocache");
        if (CostantiConfigurazione.ABILITATO.equals(tmpCache)) {
            String tmpAlg;
            Cache cache = new Cache();
            String tmpDim = rs.getString("dati_richieste_dimensionecache");
            if (tmpDim != null && !tmpDim.equals("")) {
                cache.setDimensione(tmpDim);
            }
            if ((tmpAlg = rs.getString("dati_richieste_algoritmocache")).equalsIgnoreCase("LRU")) {
                cache.setAlgoritmo(CostantiConfigurazione.CACHE_LRU);
            } else {
                cache.setAlgoritmo(CostantiConfigurazione.CACHE_MRU);
            }
            String tmpIdle = rs.getString("dati_richieste_idlecache");
            String tmpLife = rs.getString("dati_richieste_lifecache");
            if (tmpIdle != null && !tmpIdle.equals("")) {
                cache.setItemIdleTime(tmpIdle);
            }
            if (tmpLife != null && !tmpLife.equals("")) {
                cache.setItemLifeSecond(tmpLife);
            }
            accessoDatiRichieste.setCache(cache);
        }
    }

    protected void createAccessoDatiAutorizzazione(AccessoDatiAutorizzazione accessoDatiAutorizzazione) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("createAccessoDatiAutorizzazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createAccessoDatiAutorizzazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDAccessoDatiAutorizzazione type = 1");
            DriverConfigurazioneDB_configLIB.CRUDAccessoDatiAutorizzazione(1, accessoDatiAutorizzazione, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createAccessoDatiAutorizzazione] Errore durante la createAccessoDatiAutorizzazione : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void updateAccessoDatiAutorizzazione(AccessoDatiAutorizzazione accessoDatiAutorizzazione) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("updateAccessoDatiAutorizzazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateAccessoDatiAutorizzazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDAccessoDatiAutorizzazione type = 2");
            DriverConfigurazioneDB_configLIB.CRUDAccessoDatiAutorizzazione(2, accessoDatiAutorizzazione, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateAccessoDatiAutorizzazione] Errore durante la updateAccessoDatiAutorizzazione : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void deleteAccessoDatiAutorizzazione(AccessoDatiAutorizzazione accessoDatiAutorizzazione) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("deleteAccessoDatiAutorizzazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteAccessoDatiAutorizzazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDAccessoDatiAutorizzazione type = 3");
            DriverConfigurazioneDB_configLIB.CRUDAccessoDatiAutorizzazione(3, accessoDatiAutorizzazione, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteAccessoDatiAutorizzazione] Errore durante la deleteAccessoDatiAutorizzazione : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected StatoServiziPdd getStatoServiziPdD() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        StatoServiziPdd statoServiziPdd;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        PreparedStatement stmFiltri = null;
        ResultSet rsFiltri = null;
        String sqlQuery = "";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getStatoServiziPdD");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[getServiziAttiviPdD] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            StatoServiziPdd servizi = null;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi_pdd");
            sqlQuery = sqlQueryObject.createSQLQuery();
            ISQLQueryObject sqlQueryObjectFiltri = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObjectFiltri.addFromTable("servizi_pdd_filtri");
            sqlQueryObjectFiltri.addWhereCondition("id_servizio_pdd=?");
            String sqlQueryFiltro = sqlQueryObjectFiltri.createSQLQuery();
            this.driver.logDebug("eseguo query: " + DBUtils.formatSQLString(sqlQuery, new Object[0]));
            stm = con.prepareStatement(sqlQuery);
            rs = stm.executeQuery();
            while (rs.next()) {
                if (servizi == null) {
                    servizi = new StatoServiziPdd();
                }
                long id = rs.getLong("id");
                String tipo = rs.getString("componente");
                int servizio = rs.getInt("stato");
                StatoFunzionalita stato = null;
                stato = servizio == 0 ? CostantiConfigurazione.DISABILITATO : (servizio == 1 ? CostantiConfigurazione.ABILITATO : CostantiConfigurazione.ABILITATO);
                if ("pd".equals(tipo)) {
                    StatoServiziPddPortaDelegata sPD = new StatoServiziPddPortaDelegata();
                    sPD.setStato(stato);
                    this.driver.logDebug("eseguo query filtro: " + DBUtils.formatSQLString(sqlQueryFiltro, id));
                    stmFiltri = con.prepareStatement(sqlQueryFiltro);
                    stmFiltri.setLong(1, id);
                    rsFiltri = stmFiltri.executeQuery();
                    this.riempiFiltriServiziPdD(rsFiltri, sPD.getFiltroAbilitazioneList(), sPD.getFiltroDisabilitazioneList());
                    rsFiltri.close();
                    stmFiltri.close();
                    servizi.setPortaDelegata(sPD);
                    continue;
                }
                if ("pa".equals(tipo)) {
                    StatoServiziPddPortaApplicativa sPA = new StatoServiziPddPortaApplicativa();
                    sPA.setStato(stato);
                    this.driver.logDebug("eseguo query filtro: " + DBUtils.formatSQLString(sqlQueryFiltro, id));
                    stmFiltri = con.prepareStatement(sqlQueryFiltro);
                    stmFiltri.setLong(1, id);
                    rsFiltri = stmFiltri.executeQuery();
                    this.riempiFiltriServiziPdD(rsFiltri, sPA.getFiltroAbilitazioneList(), sPA.getFiltroDisabilitazioneList());
                    rsFiltri.close();
                    stmFiltri.close();
                    servizi.setPortaApplicativa(sPA);
                    continue;
                }
                if (!"im".equals(tipo)) continue;
                StatoServiziPddIntegrationManager sIM = new StatoServiziPddIntegrationManager();
                sIM.setStato(stato);
                servizi.setIntegrationManager(sIM);
            }
            if (servizi == null) {
                throw new DriverConfigurazioneNotFound("Configurazione servizi attivi sulla PdD non presente");
            }
            rs.close();
            stm.close();
            statoServiziPdd = servizi;
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[getServiziAttiviPdD]  SqlException: " + se.getMessage(), se);
                catch (DriverConfigurazioneNotFound e) {
                    throw new DriverConfigurazioneNotFound(e);
                }
                catch (Exception se2) {
                    throw new DriverConfigurazioneException("[getServiziAttiviPdD]  Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rsFiltri, stmFiltri);
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources(rsFiltri, stmFiltri);
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return statoServiziPdd;
    }

    private void riempiFiltriServiziPdD(ResultSet rsFiltri, List<TipoFiltroAbilitazioneServizi> listaAbilitazioni, List<TipoFiltroAbilitazioneServizi> listaDisabilitazioni) throws SQLException {
        while (rsFiltri.next()) {
            String tipo = rsFiltri.getString("tipo_filtro");
            TipoFiltroAbilitazioneServizi tipoFiltro = new TipoFiltroAbilitazioneServizi();
            String tipoSoggettoFruitore = rsFiltri.getString("tipo_soggetto_fruitore");
            tipoFiltro.setTipoSoggettoFruitore(tipoSoggettoFruitore);
            String soggettoFruitore = rsFiltri.getString("soggetto_fruitore");
            tipoFiltro.setSoggettoFruitore(soggettoFruitore);
            String identificativoPortaFruitore = rsFiltri.getString("identificativo_porta_fruitore");
            tipoFiltro.setIdentificativoPortaFruitore(identificativoPortaFruitore);
            String tipoSoggettoErogatore = rsFiltri.getString("tipo_soggetto_erogatore");
            tipoFiltro.setTipoSoggettoErogatore(tipoSoggettoErogatore);
            String soggettoErogatore = rsFiltri.getString("soggetto_erogatore");
            tipoFiltro.setSoggettoErogatore(soggettoErogatore);
            String identificativoPortaErogatore = rsFiltri.getString("identificativo_porta_erogatore");
            tipoFiltro.setIdentificativoPortaErogatore(identificativoPortaErogatore);
            String tipoServizio = rsFiltri.getString("tipo_servizio");
            tipoFiltro.setTipoServizio(tipoServizio);
            String servizio = rsFiltri.getString("servizio");
            tipoFiltro.setServizio(servizio);
            Integer versioneServizio = rsFiltri.getInt("versione_servizio");
            if (!rsFiltri.wasNull()) {
                tipoFiltro.setVersioneServizio(versioneServizio);
            }
            String azione = rsFiltri.getString("azione");
            tipoFiltro.setAzione(azione);
            if ("abilitazione".equals(tipo)) {
                listaAbilitazioni.add(tipoFiltro);
                continue;
            }
            listaDisabilitazioni.add(tipoFiltro);
        }
    }

    protected void createStatoServiziPdD(StatoServiziPdd servizi) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("createStatoServiziPdD");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createServiziAttiviPdD] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("createServiziAttiviPdD type = 1");
            DriverConfigurazioneDB_configLIB.CRUDServiziPdD(1, servizi, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createServiziAttiviPdD] Errore durante la createServiziAttiviPdD : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void updateStatoServiziPdD(StatoServiziPdd servizi) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("updateStatoServiziPdD");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateServiziAttiviPdD] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("createServiziAttiviPdD type = 2");
            DriverConfigurazioneDB_configLIB.CRUDServiziPdD(2, servizi, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateServiziAttiviPdD] Errore durante la updateServiziAttiviPdD : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void deleteStatoServiziPdD(StatoServiziPdd servizi) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("deleteStatoServiziPdD");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteServiziAttiviPdD] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("createServiziAttiviPdD type = 3");
            DriverConfigurazioneDB_configLIB.CRUDServiziPdD(3, servizi, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteServiziAttiviPdD] Errore durante la deleteServiziAttiviPdD : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected SystemProperties getSystemPropertiesPdD() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        IDriverBYOK driverBYOK = this.driver.getDriverUnwrapBYOK();
        return this.getSystemPropertiesPdDEngine(driverBYOK);
    }

    protected SystemProperties getSystemPropertiesPdDWithoutBIOK() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getSystemPropertiesPdDEngine(null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SystemProperties getSystemPropertiesPdDEngine(IDriverBYOK driverBYOK) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        SystemProperties systemProperties;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getSystemPropertiesPdD");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[getSystemPropertiesPdD] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            SystemProperties systemProperties2 = null;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("pdd_sys_props");
            sqlQuery = sqlQueryObject.createSQLQuery();
            this.driver.logDebug("eseguo query: " + DBUtils.formatSQLString(sqlQuery, new Object[0]));
            stm = con.prepareStatement(sqlQuery);
            rs = stm.executeQuery();
            while (rs.next()) {
                if (systemProperties2 == null) {
                    systemProperties2 = new SystemProperties();
                }
                long id = rs.getLong("id");
                String nome = rs.getString("nome");
                Property sp = new Property();
                sp.setNome(nome);
                String plainValue = rs.getString("valore");
                String encValue = rs.getString("enc_value");
                if (encValue != null && StringUtils.isNotEmpty((String)encValue)) {
                    if (driverBYOK != null) {
                        sp.setValore(driverBYOK.unwrapAsString(encValue));
                    } else {
                        sp.setValore(encValue);
                    }
                } else {
                    sp.setValore(plainValue);
                }
                sp.setId(id);
                systemProperties2.addSystemProperty(sp);
            }
            if (systemProperties2 == null) {
                throw new DriverConfigurazioneNotFound("System Properties non presenti");
            }
            rs.close();
            stm.close();
            systemProperties = systemProperties2;
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[getSystemPropertiesPdD]  SqlException: " + se.getMessage(), se);
                catch (DriverConfigurazioneNotFound e) {
                    throw new DriverConfigurazioneNotFound(e);
                }
                catch (Exception se2) {
                    throw new DriverConfigurazioneException("[getSystemPropertiesPdD]  Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return systemProperties;
    }

    protected List<String> getEncryptedSystemPropertiesPdD() throws DriverConfigurazioneException {
        ArrayList<String> l = new ArrayList<String>();
        try {
            SystemProperties s = this.getSystemPropertiesPdDEngine(null);
            if (s != null && s.sizeSystemPropertyList() > 0) {
                for (Property p : s.getSystemPropertyList()) {
                    if (p.getValore() == null || !StringUtils.isNotEmpty((String)p.getValore()) || !BYOKUtilities.isWrappedValue(p.getValore())) continue;
                    l.add(p.getNome());
                }
            }
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            // empty catch block
        }
        return l;
    }

    protected void createSystemPropertiesPdD(SystemProperties systemProperties) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("createSystemPropertiesPdD");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createSystemPropertiesPdD] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("createSystemPropertiesPdD type = 1");
            DriverConfigurazioneDB_configLIB.CRUDSystemPropertiesPdD(1, systemProperties, con, this.driver.getDriverWrapBYOK());
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createSystemPropertiesPdD] Errore durante la createSystemPropertiesPdD : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void updateSystemPropertiesPdD(SystemProperties systemProperties) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("updateSystemPropertiesPdD");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateSystemPropertiesPdD] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("updateSystemPropertiesPdD type = 2");
            DriverConfigurazioneDB_configLIB.CRUDSystemPropertiesPdD(2, systemProperties, con, this.driver.getDriverWrapBYOK());
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateSystemPropertiesPdD] Errore durante la updateSystemPropertiesPdD : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void deleteSystemPropertiesPdD(SystemProperties systemProperties) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("deleteSystemPropertiesPdD");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteSystemPropertiesPdD] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("deleteSystemPropertiesPdD type = 3");
            DriverConfigurazioneDB_configLIB.CRUDSystemPropertiesPdD(3, systemProperties, con, this.driver.getDriverWrapBYOK());
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteSystemPropertiesPdD] Errore durante la deleteSystemPropertiesPdD : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ConfigurazioneUrlInvocazioneRegola getUrlInvocazioneRegola(String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getUrlInvocazioneRegola");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[getUrlInvocazioneRegola] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        ConfigurazioneUrlInvocazioneRegola regola = null;
        try {
            if (nome == null) {
                throw new DriverConfigurazioneException("Nome regola non indicato");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("config_url_regole");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome=?");
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, nome);
            rs = stm.executeQuery();
            while (rs.next()) {
                regola = new ConfigurazioneUrlInvocazioneRegola();
                this.readRegola(regola, rs);
            }
            rs.close();
            stm.close();
        }
        catch (DriverConfigurazioneNotFound notFound) {
            try {
                throw notFound;
                catch (SQLException se) {
                    throw new DriverConfigurazioneException("[getUrlInvocazioneRegola]  SqlException: " + se.getMessage(), se);
                }
                catch (Exception se) {
                    throw new DriverConfigurazioneException("[getUrlInvocazioneRegolas]  Exception: " + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        if (regola == null) {
            throw new DriverConfigurazioneNotFound("Regola '" + nome + "' non esistente");
        }
        return regola;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean existsUrlInvocazioneRegola(String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        ResultSet rs;
        PreparedStatement stm;
        Connection con;
        block11: {
            con = null;
            stm = null;
            rs = null;
            String sqlQuery = "";
            if (this.driver.atomica) {
                try {
                    con = this.driver.getConnectionFromDatasource("existsUrlInvocazioneRegola");
                }
                catch (Exception e) {
                    throw new DriverConfigurazioneException("[existsUrlInvocazioneRegola] Exception accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.driver.globalConnection;
            }
            this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
            if (nome == null) {
                throw new DriverConfigurazioneException("Nome regola non indicato");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("config_url_regole");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome=?");
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, nome);
            rs = stm.executeQuery();
            if (!rs.next()) break block11;
            boolean bl = true;
            JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
            this.driver.closeConnection(con);
            return bl;
        }
        try {
            rs.close();
            stm.close();
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[existsUrlInvocazioneRegola]  SqlException: " + se.getMessage(), se);
                catch (Exception se2) {
                    throw new DriverConfigurazioneException("[existsUrlInvocazioneRegola]  Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return false;
    }

    private void readRegola(ConfigurazioneUrlInvocazioneRegola regola, ResultSet rs) throws Exception {
        regola.setId(rs.getLong("id"));
        regola.setNome(rs.getString("nome"));
        regola.setPosizione(rs.getInt("posizione"));
        regola.setStato(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs.getString("stato")));
        regola.setDescrizione(rs.getString("descrizione"));
        if (rs.getInt("regexpr") == 1) {
            regola.setRegexpr(true);
        } else {
            regola.setRegexpr(false);
        }
        regola.setRegola(rs.getString("regola"));
        String s = rs.getString("contesto_esterno");
        if ("_____@@EMPTY@@____".equals(s)) {
            s = "";
        }
        regola.setContestoEsterno(s);
        regola.setBaseUrl(rs.getString("base_url"));
        regola.setProtocollo(rs.getString("protocollo"));
        regola.setRuolo(DriverConfigurazioneDBLib.getEnumRuoloContesto(rs.getString("ruolo")));
        regola.setServiceBinding(DriverConfigurazioneDBLib.getEnumServiceBinding(rs.getString("service_binding")));
        String tipoSoggetto = rs.getString("tipo_soggetto");
        String nomeSoggetto = rs.getString("nome_soggetto");
        if (tipoSoggetto != null && !"".equals(tipoSoggetto) && nomeSoggetto != null && !"".equals(nomeSoggetto)) {
            regola.setSoggetto(new IdSoggetto(new IDSoggetto(tipoSoggetto, nomeSoggetto)));
        }
    }

    protected void createUrlInvocazioneRegola(ConfigurazioneUrlInvocazioneRegola regola) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("createUrlInvocazioneRegola");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createUrlInvocazioneRegola] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDUrlInvocazioneRegola type = 1");
            DriverConfigurazioneDB_configLIB.CRUDUrlInvocazioneRegola(1, regola, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createUrlInvocazioneRegola] Errore durante la create : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void updateUrlInvocazioneRegola(ConfigurazioneUrlInvocazioneRegola regola) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("updateUrlInvocazioneRegola");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateUrlInvocazioneRegola] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDUrlInvocazioneRegola type = 2");
            DriverConfigurazioneDB_configLIB.CRUDUrlInvocazioneRegola(2, regola, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateUrlInvocazioneRegola] Errore durante l'aggiornamento : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void deleteUrlInvocazioneRegola(ConfigurazioneUrlInvocazioneRegola regola) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("deleteUrlInvocazioneRegola");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteUrlInvocazioneRegola] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDUrlInvocazioneRegola type = 3");
            DriverConfigurazioneDB_configLIB.CRUDUrlInvocazioneRegola(3, regola, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteUrlInvocazioneRegola] Errore durante l'eliminazione : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Configurazione getConfigurazioneGenerale() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        GestioneErrore ge2;
        ConfigurazioneGestioneErrore cge;
        Configurazione config;
        block79: {
            ResultSet rs2;
            PreparedStatement stm2;
            ResultSet rs1;
            PreparedStatement stm1;
            ResultSet rs;
            PreparedStatement stm;
            Connection con;
            block78: {
                List<Object> list;
                ExtendedInfoManager extInfoManager;
                IExtendedInfo extInfoConfigurazioneDriver;
                con = null;
                stm = null;
                rs = null;
                stm1 = null;
                rs1 = null;
                stm2 = null;
                rs2 = null;
                String sqlQuery = "";
                if (this.driver.atomica) {
                    try {
                        con = this.driver.getConnectionFromDatasource("getConfigurazioneGenerale");
                    }
                    catch (Exception e) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getConfigurazioneGenerale] Exception accedendo al datasource :" + e.getMessage(), e);
                    }
                } else {
                    con = this.driver.globalConnection;
                }
                this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
                config = new Configurazione();
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("configurazione");
                sqlQueryObject.addSelectField("*");
                sqlQuery = sqlQueryObject.createSQLQuery();
                this.driver.logDebug("eseguo query: " + DBUtils.formatSQLString(sqlQuery, new Object[0]));
                stm = con.prepareStatement(sqlQuery);
                rs = stm.executeQuery();
                if (!rs.next()) throw new DriverConfigurazioneNotFound("[DriverConfigurazioneDB::getConfigurazioneGenerale] Configurazione non presente.");
                Attachments attachments = new Attachments();
                attachments.setGestioneManifest(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs.getString("gestione_manifest")));
                config.setAttachments(attachments);
                IndirizzoRisposta indirizzoRisposta = new IndirizzoRisposta();
                indirizzoRisposta.setUtilizzo(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs.getString("indirizzo_telematico")));
                config.setIndirizzoRisposta(indirizzoRisposta);
                String cadenza_inoltro = rs.getString("cadenza_inoltro");
                InoltroBusteNonRiscontrate inoltroBusteNonRiscontrate = new InoltroBusteNonRiscontrate();
                inoltroBusteNonRiscontrate.setCadenza(cadenza_inoltro);
                config.setInoltroBusteNonRiscontrate(inoltroBusteNonRiscontrate);
                String autenticazione = rs.getString("auth_integration_manager");
                IntegrationManager integrationManager = new IntegrationManager();
                integrationManager.setAutenticazione(autenticazione);
                config.setIntegrationManager(integrationManager);
                boolean routingEnabled = false;
                if (CostantiConfigurazione.ABILITATO.equals(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs.getString("routing_enabled")))) {
                    routingEnabled = true;
                }
                RoutingTable rt = new RoutingTable();
                rt.setAbilitata(routingEnabled);
                config.setRoutingTable(rt);
                String validazioneContenuti_stato = rs.getString("validazione_contenuti_stato");
                String validazioneContenuti_tipo = rs.getString("validazione_contenuti_tipo");
                String validazioneContenuti_acceptMtomMessage = rs.getString("validazione_contenuti_mtom");
                if (validazioneContenuti_stato != null && !validazioneContenuti_stato.equals("") || validazioneContenuti_tipo != null && !validazioneContenuti_tipo.equals("") || validazioneContenuti_acceptMtomMessage != null && !validazioneContenuti_acceptMtomMessage.equals("")) {
                    ValidazioneContenutiApplicativi val = new ValidazioneContenutiApplicativi();
                    if (validazioneContenuti_stato != null && !validazioneContenuti_stato.equals("")) {
                        val.setStato(DriverConfigurazioneDBLib.getEnumStatoFunzionalitaConWarning(validazioneContenuti_stato));
                    }
                    if (validazioneContenuti_tipo != null && !validazioneContenuti_tipo.equals("")) {
                        val.setTipo(DriverConfigurazioneDBLib.getEnumValidazioneContenutiApplicativiTipo(validazioneContenuti_tipo));
                    }
                    if (validazioneContenuti_acceptMtomMessage != null && !validazioneContenuti_acceptMtomMessage.equals("")) {
                        val.setAcceptMtomMessage(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(validazioneContenuti_acceptMtomMessage));
                    }
                    config.setValidazioneContenutiApplicativi(val);
                }
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("config_url_invocazione");
                sqlQueryObject.addSelectField("*");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm1 = con.prepareStatement(sqlQuery);
                rs1 = stm1.executeQuery();
                if (rs1.next()) {
                    ConfigurazioneUrlInvocazione configurazioneUrlInvocazione = new ConfigurazioneUrlInvocazione();
                    configurazioneUrlInvocazione.setBaseUrl(rs1.getString("base_url"));
                    configurazioneUrlInvocazione.setBaseUrlFruizione(rs1.getString("base_url_fruizione"));
                    config.setUrlInvocazione(configurazioneUrlInvocazione);
                }
                rs1.close();
                stm1.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("config_url_regole");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addOrderBy("posizione");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm1 = con.prepareStatement(sqlQuery);
                rs1 = stm1.executeQuery();
                while (rs1.next()) {
                    if (config.getUrlInvocazione() == null) {
                        config.setUrlInvocazione(new ConfigurazioneUrlInvocazione());
                    }
                    ConfigurazioneUrlInvocazioneRegola regola = new ConfigurazioneUrlInvocazioneRegola();
                    this.readRegola(regola, rs1);
                    config.getUrlInvocazione().addRegola(regola);
                }
                rs1.close();
                stm1.close();
                String multitenantStato = rs.getString("multitenant_stato");
                String multitenantStatoSoggettiFruitori = rs.getString("multitenant_fruizioni");
                String multitenantStatoSoggettiErogatori = rs.getString("multitenant_erogazioni");
                config.setMultitenant(new ConfigurazioneMultitenant());
                config.getMultitenant().setStato(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(multitenantStato));
                config.getMultitenant().setFruizioneSceltaSoggettiErogatori(DriverConfigurazioneDBLib.getEnumPortaDelegataSoggettiErogatori(multitenantStatoSoggettiFruitori));
                config.getMultitenant().setErogazioneSceltaSoggettiFruitori(DriverConfigurazioneDBLib.getEnumPortaApplicativaSoggettiFruitori(multitenantStatoSoggettiErogatori));
                String msg_diag_severita = rs.getString("msg_diag_severita");
                String msg_diag_severita_log4j = rs.getString("msg_diag_severita_log4j");
                MessaggiDiagnostici messaggiDiagnostici = new MessaggiDiagnostici();
                messaggiDiagnostici.setSeveritaLog4j(DriverConfigurazioneDBLib.getEnumSeverita(msg_diag_severita_log4j));
                messaggiDiagnostici.setSeverita(DriverConfigurazioneDBLib.getEnumSeverita(msg_diag_severita));
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("msgdiag_appender");
                sqlQueryObject.addSelectField("*");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm1 = con.prepareStatement(sqlQuery);
                rs1 = stm1.executeQuery();
                while (rs1.next()) {
                    OpenspcoopAppender appender = new OpenspcoopAppender();
                    appender.setTipo(rs1.getString("tipo"));
                    long idAppender = rs1.getLong("id");
                    appender.setId(idAppender);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObject.addFromTable("msgdiag_appender_prop");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("id_appender = ?");
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm2 = con.prepareStatement(sqlQuery);
                    stm2.setLong(1, idAppender);
                    rs2 = stm2.executeQuery();
                    Property appender_prop = null;
                    while (rs2.next()) {
                        appender_prop = new Property();
                        appender_prop.setId(rs2.getLong("id"));
                        appender_prop.setNome(rs2.getString("nome"));
                        appender_prop.setValore(rs2.getString("valore"));
                        appender.addProperty(appender_prop);
                    }
                    rs2.close();
                    stm2.close();
                    messaggiDiagnostici.addOpenspcoopAppender(appender);
                }
                rs1.close();
                stm1.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("msgdiag_ds");
                sqlQueryObject.addSelectField("*");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm1 = con.prepareStatement(sqlQuery);
                rs1 = stm1.executeQuery();
                while (rs1.next()) {
                    OpenspcoopSorgenteDati openspcoopDS = new OpenspcoopSorgenteDati();
                    openspcoopDS.setNome(rs1.getString("nome"));
                    openspcoopDS.setNomeJndi(rs1.getString("nome_jndi"));
                    openspcoopDS.setTipoDatabase(rs1.getString("tipo_database"));
                    long idDS = rs1.getLong("id");
                    openspcoopDS.setId(idDS);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObject.addFromTable("msgdiag_ds_prop");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("id_prop = ?");
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm2 = con.prepareStatement(sqlQuery);
                    stm2.setLong(1, idDS);
                    rs2 = stm2.executeQuery();
                    Property ds_prop = null;
                    while (rs2.next()) {
                        ds_prop = new Property();
                        ds_prop.setId(rs2.getLong("id"));
                        ds_prop.setNome(rs2.getString("nome"));
                        ds_prop.setValore(rs2.getString("valore"));
                        openspcoopDS.addProperty(ds_prop);
                    }
                    rs2.close();
                    stm2.close();
                    messaggiDiagnostici.addOpenspcoopSorgenteDati(openspcoopDS);
                }
                rs1.close();
                stm1.close();
                config.setMessaggiDiagnostici(messaggiDiagnostici);
                Tracciamento tracciamento = new Tracciamento();
                String traccBuste = rs.getString("tracciamento_buste");
                tracciamento.setStato(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(traccBuste));
                String traccEsitiPA = rs.getString("tracciamento_esiti");
                String transazioniTempiElaborazionePA = rs.getString("transazioni_tempi");
                String transazioniTokenPA = rs.getString("transazioni_token");
                TracciamentoConfigurazione tracciamentoDatabasePA = DriverConfigurazioneDBTracciamentoLIB.readTracciamentoConfigurazione(con, null, "configpa", "db");
                TracciamentoConfigurazione tracciamentoFiletracePA = DriverConfigurazioneDBTracciamentoLIB.readTracciamentoConfigurazione(con, null, "configpa", "filetrace");
                TracciamentoConfigurazioneFiletrace tracciamentoFiletraceDetailsPA = DriverConfigurazioneDBTracciamentoLIB.readTracciamentoConfigurazioneFiletrace(con, null, "configpa");
                if (traccEsitiPA != null && StringUtils.isNotEmpty((String)traccEsitiPA) || transazioniTempiElaborazionePA != null && StringUtils.isNotEmpty((String)transazioniTempiElaborazionePA) || transazioniTokenPA != null && StringUtils.isNotEmpty((String)transazioniTokenPA) || tracciamentoDatabasePA != null || tracciamentoFiletracePA != null || tracciamentoFiletraceDetailsPA != null) {
                    tracciamento.setPortaApplicativa(new ConfigurazioneTracciamentoPorta());
                    tracciamento.getPortaApplicativa().setEsiti(traccEsitiPA);
                    if (transazioniTempiElaborazionePA != null && StringUtils.isNotEmpty((String)transazioniTempiElaborazionePA) || transazioniTokenPA != null && StringUtils.isNotEmpty((String)transazioniTokenPA)) {
                        tracciamento.getPortaApplicativa().setTransazioni(new Transazioni());
                        tracciamento.getPortaApplicativa().getTransazioni().setTempiElaborazione(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(transazioniTempiElaborazionePA));
                        tracciamento.getPortaApplicativa().getTransazioni().setToken(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(transazioniTokenPA));
                    }
                    tracciamento.getPortaApplicativa().setDatabase(tracciamentoDatabasePA);
                    tracciamento.getPortaApplicativa().setFiletrace(tracciamentoFiletracePA);
                    tracciamento.getPortaApplicativa().setFiletraceConfig(tracciamentoFiletraceDetailsPA);
                }
                String traccEsitiPD = rs.getString("tracciamento_esiti_pd");
                String transazioniTempiElaborazionePD = rs.getString("transazioni_tempi_pd");
                String transazioniTokenPD = rs.getString("transazioni_token_pd");
                TracciamentoConfigurazione tracciamentoDatabasePD = DriverConfigurazioneDBTracciamentoLIB.readTracciamentoConfigurazione(con, null, "configpd", "db");
                TracciamentoConfigurazione tracciamentoFiletracePD = DriverConfigurazioneDBTracciamentoLIB.readTracciamentoConfigurazione(con, null, "configpd", "filetrace");
                TracciamentoConfigurazioneFiletrace tracciamentoFiletraceDetailsPD = DriverConfigurazioneDBTracciamentoLIB.readTracciamentoConfigurazioneFiletrace(con, null, "configpd");
                if (traccEsitiPD != null && StringUtils.isNotEmpty((String)traccEsitiPD) || transazioniTempiElaborazionePD != null && StringUtils.isNotEmpty((String)transazioniTempiElaborazionePD) || transazioniTokenPD != null && StringUtils.isNotEmpty((String)transazioniTokenPD) || tracciamentoDatabasePD != null || tracciamentoFiletracePD != null || tracciamentoFiletraceDetailsPD != null) {
                    tracciamento.setPortaDelegata(new ConfigurazioneTracciamentoPorta());
                    tracciamento.getPortaDelegata().setEsiti(traccEsitiPD);
                    if (transazioniTempiElaborazionePD != null && StringUtils.isNotEmpty((String)transazioniTempiElaborazionePD) || transazioniTokenPD != null && StringUtils.isNotEmpty((String)transazioniTokenPD)) {
                        tracciamento.getPortaDelegata().setTransazioni(new Transazioni());
                        tracciamento.getPortaDelegata().getTransazioni().setTempiElaborazione(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(transazioniTempiElaborazionePD));
                        tracciamento.getPortaDelegata().getTransazioni().setToken(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(transazioniTokenPD));
                    }
                    tracciamento.getPortaDelegata().setDatabase(tracciamentoDatabasePD);
                    tracciamento.getPortaDelegata().setFiletrace(tracciamentoFiletracePD);
                    tracciamento.getPortaDelegata().setFiletraceConfig(tracciamentoFiletraceDetailsPD);
                }
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("tracce_appender");
                sqlQueryObject.addSelectField("*");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm1 = con.prepareStatement(sqlQuery);
                rs1 = stm1.executeQuery();
                while (rs1.next()) {
                    OpenspcoopAppender trac_appender = new OpenspcoopAppender();
                    trac_appender.setTipo(rs1.getString("tipo"));
                    long idAppenderTrac = rs1.getLong("id");
                    trac_appender.setId(idAppenderTrac);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObject.addFromTable("tracce_appender_prop");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("id_appender = ?");
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm2 = con.prepareStatement(sqlQuery);
                    stm2.setLong(1, idAppenderTrac);
                    rs2 = stm2.executeQuery();
                    Property trac_appender_prop = null;
                    while (rs2.next()) {
                        trac_appender_prop = new Property();
                        trac_appender_prop.setId(rs2.getLong("id"));
                        trac_appender_prop.setNome(rs2.getString("nome"));
                        trac_appender_prop.setValore(rs2.getString("valore"));
                        trac_appender.addProperty(trac_appender_prop);
                    }
                    rs2.close();
                    stm2.close();
                    tracciamento.addOpenspcoopAppender(trac_appender);
                }
                rs1.close();
                stm1.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("tracce_ds");
                sqlQueryObject.addSelectField("*");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm1 = con.prepareStatement(sqlQuery);
                rs1 = stm1.executeQuery();
                while (rs1.next()) {
                    OpenspcoopSorgenteDati trac_ds = new OpenspcoopSorgenteDati();
                    trac_ds.setNome(rs1.getString("nome"));
                    trac_ds.setNomeJndi(rs1.getString("nome_jndi"));
                    trac_ds.setTipoDatabase(rs1.getString("tipo_database"));
                    long idDsTrac = rs1.getLong("id");
                    trac_ds.setId(idDsTrac);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObject.addFromTable("tracce_ds_prop");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("id_prop = ?");
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm2 = con.prepareStatement(sqlQuery);
                    stm2.setLong(1, idDsTrac);
                    rs2 = stm2.executeQuery();
                    Property trac_ds_prop = null;
                    while (rs2.next()) {
                        trac_ds_prop = new Property();
                        trac_ds_prop.setId(rs2.getLong("id"));
                        trac_ds_prop.setNome(rs2.getString("nome"));
                        trac_ds_prop.setValore(rs2.getString("valore"));
                        trac_ds.addProperty(trac_ds_prop);
                    }
                    rs2.close();
                    stm2.close();
                    tracciamento.addOpenspcoopSorgenteDati(trac_ds);
                }
                rs1.close();
                stm1.close();
                config.setTracciamento(tracciamento);
                String dump_stato = rs.getString("dump");
                String dump_pd = rs.getString("dump_bin_pd");
                String dump_pa = rs.getString("dump_bin_pa");
                Dump dump = new Dump();
                dump.setStato(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(dump_stato));
                dump.setDumpBinarioPortaDelegata(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(dump_pd));
                if (dump.getDumpBinarioPortaDelegata() == null) {
                    dump.setDumpBinarioPortaDelegata(StatoFunzionalita.DISABILITATO);
                }
                dump.setDumpBinarioPortaApplicativa(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(dump_pa));
                if (dump.getDumpBinarioPortaApplicativa() == null) {
                    dump.setDumpBinarioPortaApplicativa(StatoFunzionalita.DISABILITATO);
                }
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("dump_appender");
                sqlQueryObject.addSelectField("*");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm1 = con.prepareStatement(sqlQuery);
                rs1 = stm1.executeQuery();
                while (rs1.next()) {
                    OpenspcoopAppender dump_appender = new OpenspcoopAppender();
                    dump_appender.setTipo(rs1.getString("tipo"));
                    long idAppenderDump = rs1.getLong("id");
                    dump_appender.setId(idAppenderDump);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObject.addFromTable("dump_appender_prop");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("id_appender = ?");
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm2 = con.prepareStatement(sqlQuery);
                    stm2.setLong(1, idAppenderDump);
                    rs2 = stm2.executeQuery();
                    Property dump_appender_prop = null;
                    while (rs2.next()) {
                        dump_appender_prop = new Property();
                        dump_appender_prop.setId(rs2.getLong("id"));
                        dump_appender_prop.setNome(rs2.getString("nome"));
                        dump_appender_prop.setValore(rs2.getString("valore"));
                        dump_appender.addProperty(dump_appender_prop);
                    }
                    rs2.close();
                    stm2.close();
                    dump.addOpenspcoopAppender(dump_appender);
                }
                rs1.close();
                stm1.close();
                DumpConfigurazione dumpConfig = DriverConfigurazioneDB_dumpLIB.readDumpConfigurazione(con, null, "config");
                if (dumpConfig != null) {
                    dump.setConfigurazionePortaApplicativa(dumpConfig);
                    dump.setConfigurazionePortaDelegata(dumpConfig);
                } else {
                    DumpConfigurazione dumpConfigPA = DriverConfigurazioneDB_dumpLIB.readDumpConfigurazione(con, null, "configpa");
                    dump.setConfigurazionePortaApplicativa(dumpConfigPA);
                    DumpConfigurazione dumpConfigPD = DriverConfigurazioneDB_dumpLIB.readDumpConfigurazione(con, null, "configpd");
                    dump.setConfigurazionePortaDelegata(dumpConfigPD);
                }
                config.setDump(dump);
                Risposte risposte = new Risposte();
                risposte.setConnessione(DriverConfigurazioneDBLib.getEnumTipoConnessioneRisposte(rs.getString("mod_risposta")));
                config.setRisposte(risposte);
                String val_controllo = rs.getString("validazione_controllo");
                String val_stato = rs.getString("validazione_stato");
                String val_manifest = rs.getString("validazione_manifest");
                String val_profilo = rs.getString("validazione_profilo");
                ValidazioneBuste validazioneBuste = new ValidazioneBuste();
                validazioneBuste.setControllo(DriverConfigurazioneDBLib.getEnumValidazioneBusteTipoControllo(val_controllo));
                validazioneBuste.setManifestAttachments(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(val_manifest));
                validazioneBuste.setProfiloCollaborazione(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(val_profilo));
                validazioneBuste.setStato(DriverConfigurazioneDBLib.getEnumStatoFunzionalitaConWarning(val_stato));
                config.setValidazioneBuste(validazioneBuste);
                config.setGestioneCors(new CorsConfigurazione());
                this.porteDriver.readConfigurazioneCors(config.getGestioneCors(), rs);
                config.setResponseCaching(new ResponseCachingConfigurazioneGenerale());
                config.getResponseCaching().setConfigurazione(new ResponseCachingConfigurazione());
                this.porteDriver.readResponseCaching(null, true, false, config.getResponseCaching().getConfigurazione(), rs, con);
                String tmpCache = rs.getString("response_cache_statocache");
                if (CostantiConfigurazione.ABILITATO.equals(tmpCache)) {
                    String tmpAlg;
                    Cache cache = new Cache();
                    String tmpDim = rs.getString("response_cache_dimensionecache");
                    if (tmpDim != null && !tmpDim.equals("")) {
                        cache.setDimensione(tmpDim);
                    }
                    if ((tmpAlg = rs.getString("response_cache_algoritmocache")).equalsIgnoreCase("LRU")) {
                        cache.setAlgoritmo(CostantiConfigurazione.CACHE_LRU);
                    } else {
                        cache.setAlgoritmo(CostantiConfigurazione.CACHE_MRU);
                    }
                    String tmpIdle = rs.getString("response_cache_idlecache");
                    String tmpLife = rs.getString("response_cache_lifecache");
                    if (tmpIdle != null && !tmpIdle.equals("")) {
                        cache.setItemIdleTime(tmpIdle);
                    }
                    if (tmpLife != null && !tmpLife.equals("")) {
                        cache.setItemLifeSecond(tmpLife);
                    }
                    config.getResponseCaching().setCache(cache);
                }
                String canali_stato = rs.getString("canali_stato");
                config.setGestioneCanali(new CanaliConfigurazione());
                config.getGestioneCanali().setStato(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(canali_stato));
                if (StatoFunzionalita.ABILITATO.equals(config.getGestioneCanali().getStato())) {
                    DriverConfigurazioneDB_canaliLIB.readCanaliConfigurazione(con, config.getGestioneCanali(), true);
                }
                ConfigurazioneMessageHandlers requestHandlers = DriverConfigurazioneDB_handlerLIB.readConfigurazioneMessageHandlers(con, null, null, true);
                ConfigurazioneMessageHandlers responseHandlers = DriverConfigurazioneDB_handlerLIB.readConfigurazioneMessageHandlers(con, null, null, false);
                ConfigurazioneServiceHandlers serviceHandlers = DriverConfigurazioneDB_handlerLIB.readConfigurazioneServiceHandlers(con, null, null, false);
                if (requestHandlers != null || responseHandlers != null || serviceHandlers != null) {
                    config.setConfigurazioneHandler(new ConfigurazioneGeneraleHandler());
                    config.getConfigurazioneHandler().setRequest(requestHandlers);
                    config.getConfigurazioneHandler().setResponse(responseHandlers);
                    config.getConfigurazioneHandler().setService(serviceHandlers);
                }
                if ((extInfoConfigurazioneDriver = (extInfoManager = ExtendedInfoManager.getInstance()).newInstanceExtendedInfoConfigurazione()) == null || (list = extInfoConfigurazioneDriver.getAllExtendedInfo(con, this.driver.log, config)) == null || list.isEmpty()) break block78;
                config.setExtendedInfoList(list);
            }
            JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
            JDBCUtilities.closeResources((ResultSet)rs1, (PreparedStatement)stm1);
            JDBCUtilities.closeResources((ResultSet)rs2, (PreparedStatement)stm2);
            this.driver.closeConnection(con);
            cge = null;
            try {
                ge2 = this.gestioneErroreDriver.getGestioneErroreComponenteIntegrazione();
                if (ge2 != null) {
                    if (cge == null) {
                        cge = new ConfigurazioneGestioneErrore();
                    }
                    cge.setComponenteIntegrazione(ge2);
                }
                break block79;
            }
            catch (Exception ge2) {
                // empty catch block
            }
            break block79;
            catch (DriverConfigurazioneNotFound e) {
                try {
                    throw e;
                    catch (Exception se) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getConfigurazioneGenerale] Exception: " + se.getMessage(), se);
                    }
                }
                catch (Throwable throwable) {
                    JDBCUtilities.closeResources(rs, stm);
                    JDBCUtilities.closeResources(rs1, stm1);
                    JDBCUtilities.closeResources(rs2, stm2);
                    this.driver.closeConnection(con);
                    throw throwable;
                }
            }
        }
        try {
            ge2 = this.gestioneErroreDriver.getGestioneErroreComponenteCooperazione();
            if (ge2 != null) {
                if (cge == null) {
                    cge = new ConfigurazioneGestioneErrore();
                }
                cge.setComponenteCooperazione(ge2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cge != null) {
            config.setGestioneErrore(cge);
        }
        try {
            config.setAccessoRegistro(this.getAccessoRegistro());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            config.setAccessoConfigurazione(this.getAccessoConfigurazione());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            config.setAccessoDatiAutorizzazione(this.getAccessoDatiAutorizzazione());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            config.setAccessoDatiAutenticazione(this.getAccessoDatiAutenticazione());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            config.setAccessoDatiGestioneToken(this.getAccessoDatiGestioneToken());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            config.setAccessoDatiAttributeAuthority(this.getAccessoDatiAttributeAuthority());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            config.setAccessoDatiKeystore(this.getAccessoDatiKeystore());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            config.setAccessoDatiConsegnaApplicativi(this.getAccessoDatiConsegnaApplicativi());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            config.setAccessoDatiRichieste(this.getAccessoDatiRichieste());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            config.setRoutingTable(this.routingTableDriver.getRoutingTable());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            config.setStatoServiziPdd(this.getStatoServiziPdD());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            config.setSystemProperties(this.getSystemPropertiesPdD());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            config.getGenericPropertiesList().addAll(this.genericPropertiesDriver.getGenericProperties());
            return config;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return config;
    }

    protected Object getConfigurazioneExtended(Configurazione config, String idExtendedConfiguration) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Connection con = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getConfigurazioneExtended");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getConfigurazioneExtended] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        try {
            this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
            this.driver.logDebug("getConfigurazioneExtended(" + idExtendedConfiguration + ")");
            ExtendedInfoManager extInfoManager = ExtendedInfoManager.getInstance();
            IExtendedInfo extInfoConfigurazioneDriver = extInfoManager.newInstanceExtendedInfoConfigurazione();
            if (extInfoConfigurazioneDriver != null) {
                Object o = extInfoConfigurazioneDriver.getExtendedInfo(con, this.driver.log, config, idExtendedConfiguration);
                if (o == null) {
                    throw new DriverConfigurazioneNotFound("Oggetto non esistente");
                }
                Object object = o;
                return object;
            }
            try {
                throw new DriverConfigurazioneException("Driver non inizializzato");
            }
            catch (DriverConfigurazioneNotFound dNot) {
                throw dNot;
            }
            catch (Exception qe) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getConfigurazioneExtended] Errore: " + qe.getMessage(), qe);
            }
        }
        finally {
            this.driver.closeConnection(con);
        }
    }

    protected void createConfigurazione(Configurazione configurazione) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("createConfigurazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createConfigurazioneGenerale] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDConfigurazioneGenerale type = 1");
            DriverConfigurazioneDB_configLIB.CRUDConfigurazioneGenerale(1, configurazione, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createConfigurazioneGenerale] Errore durante la create ConfigurazioneGenerale : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void updateConfigurazione(Configurazione configurazione) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("updateConfigurazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateConfigurazioneGenerale] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDConfigurazioneGenerale type = 2");
            DriverConfigurazioneDB_configLIB.CRUDConfigurazioneGenerale(2, configurazione, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateConfigurazioneGenerale] Errore durante la update ConfigurazioneGenerale : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void deleteConfigurazione(Configurazione configurazione) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("deleteConfigurazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteConfigurazioneGenerale] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDConfigurazioneGenerale type = 3");
            DriverConfigurazioneDB_configLIB.CRUDConfigurazioneGenerale(3, configurazione, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteConfigurazioneGenerale] Errore durante la delete ConfigurazioneGenerale : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void createAccessoRegistro(AccessoRegistro registro) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("createAccessoRegistro");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createAccessoRegistro] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDAccessoRegistro type = 1");
            DriverConfigurazioneDB_configLIB.CRUDAccessoRegistro(1, registro, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createAccessoRegistro] Errore durante la updateAccessoRegistro : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void updateAccessoRegistro(AccessoRegistro registro) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("updateAccessoRegistro");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateAccessoRegistro] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDAccessoRegistro type = 2");
            DriverConfigurazioneDB_configLIB.CRUDAccessoRegistro(2, registro, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateAccessoRegistro] Errore durante la updateAccessoRegistro : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void deleteAccessoRegistro(AccessoRegistro registro) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("deleteAccessoRegistro");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteAccessoRegistro] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDAccessoRegistro type = 3");
            DriverConfigurazioneDB_configLIB.CRUDAccessoRegistro(3, registro, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteAccessoRegistro] Errore durante la updateAccessoRegistro : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected boolean existsResponseCachingConfigurazioneRegola(Integer statusMin, Integer statusMax, boolean fault) throws DriverConfigurazioneException {
        boolean bl;
        String nomeMetodo = "existsResponseCachingConfigurazioneRegola";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("existsResponseCachingConfigurazioneRegola");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            int count = 0;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("config_cache_regole");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.setANDLogicOperator(true);
            if (statusMin != null) {
                sqlQueryObject.addWhereCondition("status_min = ?");
            } else {
                sqlQueryObject.addWhereIsNullCondition("status_min");
            }
            if (statusMax != null) {
                sqlQueryObject.addWhereCondition("status_max = ?");
            } else {
                sqlQueryObject.addWhereIsNullCondition("status_max");
            }
            sqlQueryObject.addWhereCondition("fault = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int parameterIndex = 1;
            if (statusMin != null) {
                stmt.setInt(parameterIndex++, statusMin);
            }
            if (statusMax != null) {
                stmt.setInt(parameterIndex++, statusMax);
            }
            if (fault) {
                stmt.setInt(parameterIndex++, 1);
            } else {
                stmt.setInt(parameterIndex++, 0);
            }
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                count = risultato.getInt(1);
            }
            risultato.close();
            stmt.close();
            bl = count > 0;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return bl;
    }

    protected boolean existsProxyPassConfigurazioneRegola(String nome) throws DriverConfigurazioneException {
        boolean bl;
        String nomeMetodo = "existsResponseCachingConfigurazioneRegola";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("existsResponseCachingConfigurazioneRegola");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            int count = 0;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("config_url_regole");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("nome = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int parameterIndex = 1;
            stmt.setString(parameterIndex++, nome);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                count = risultato.getInt(1);
            }
            risultato.close();
            stmt.close();
            bl = count > 0;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return bl;
    }

    protected boolean existsCanale(String nome) throws DriverConfigurazioneException {
        boolean bl;
        String nomeMetodo = "existsCanale";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            int count = 0;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("canali_configurazione");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("nome = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int parameterIndex = 1;
            stmt.setString(parameterIndex++, nome);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                count = risultato.getInt(1);
            }
            risultato.close();
            stmt.close();
            bl = count > 0;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return bl;
    }

    protected boolean existsCanaleNodo(String nome) throws DriverConfigurazioneException {
        boolean bl;
        String nomeMetodo = "existsCanaleNodo";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            int count = 0;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("canali_nodi");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("nome = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int parameterIndex = 1;
            stmt.setString(parameterIndex++, nome);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                count = risultato.getInt(1);
            }
            risultato.close();
            stmt.close();
            bl = count > 0;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return bl;
    }

    protected CanaliConfigurazione getCanaliConfigurazione() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getCanaliConfigurazione(true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CanaliConfigurazione getCanaliConfigurazione(boolean readNodi) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        PreparedStatement stm1 = null;
        ResultSet rs1 = null;
        PreparedStatement stm2 = null;
        ResultSet rs2 = null;
        String sqlQuery = "";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getCanaliConfigurazione");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getCanaliConfigurazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        CanaliConfigurazione config = new CanaliConfigurazione();
        config.setStato(StatoFunzionalita.DISABILITATO);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("configurazione");
            sqlQueryObject.addSelectField("configurazione.canali_stato");
            sqlQuery = sqlQueryObject.createSQLQuery();
            this.driver.logDebug("eseguo query: " + DBUtils.formatSQLString(sqlQuery, new Object[0]));
            stm = con.prepareStatement(sqlQuery);
            rs = stm.executeQuery();
            if (!rs.next()) throw new DriverConfigurazioneNotFound("[DriverConfigurazioneDB::getCanaliConfigurazione] Configurazione non presente.");
            String canali_stato = rs.getString("canali_stato");
            config.setStato(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(canali_stato));
            if (config.getStato() == null) {
                config.setStato(StatoFunzionalita.DISABILITATO);
            }
            if (StatoFunzionalita.ABILITATO.equals(config.getStato())) {
                DriverConfigurazioneDB_canaliLIB.readCanaliConfigurazione(con, config, false);
            }
        }
        catch (DriverConfigurazioneNotFound e) {
            try {
                throw e;
                catch (Exception se) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getCanaliConfigurazione] Exception: " + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                JDBCUtilities.closeResources(rs1, stm1);
                JDBCUtilities.closeResources(rs2, stm2);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        JDBCUtilities.closeResources(rs1, stm1);
        JDBCUtilities.closeResources(rs2, stm2);
        this.driver.closeConnection(con);
        return config;
    }
}

