/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.AccessoRegistroRegistro;
import org.openspcoop2.core.config.CanaleConfigurazione;
import org.openspcoop2.core.config.CanaleConfigurazioneNodo;
import org.openspcoop2.core.config.ConfigurazioneUrlInvocazioneRegola;
import org.openspcoop2.core.config.IdSoggetto;
import org.openspcoop2.core.config.Property;
import org.openspcoop2.core.config.ResponseCachingConfigurazioneRegola;
import org.openspcoop2.core.config.constants.RegistroTipo;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.StatoFunzionalitaConPersonalizzazione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBLib;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverConfigurazioneDB_configSearchDriver {
    private DriverConfigurazioneDB driver = null;

    protected DriverConfigurazioneDB_configSearchDriver(DriverConfigurazioneDB driver) {
        this.driver = driver;
    }

    protected List<Property> systemPropertyList(ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<Property> arrayList;
        String nomeMetodo = "systemPropertyList";
        int idLista = Liste.SYSTEM_PROPERTIES;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<Property> lista = new ArrayList<Property>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("systemPropertyList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pdd_sys_props");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pdd_sys_props");
                sqlQueryObject.addSelectCountField("*", "cont");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pdd_sys_props");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addSelectField("enc_value");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pdd_sys_props");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addSelectField("enc_value");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Property sp = new Property();
                sp.setId(risultato.getLong("id"));
                sp.setNome(risultato.getString("nome"));
                String plainValue = risultato.getString("valore");
                String encValue = risultato.getString("enc_value");
                if (encValue != null && StringUtils.isNotEmpty((String)encValue)) {
                    sp.setValore(encValue);
                } else {
                    sp.setValore(plainValue);
                }
                lista.add(sp);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<AccessoRegistroRegistro> registriList(ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<AccessoRegistroRegistro> arrayList;
        String nomeMetodo = "registriList";
        int idLista = Liste.REGISTRI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccessoRegistroRegistro> lista = new ArrayList<AccessoRegistroRegistro>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("registriList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("registri");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("registri");
                sqlQueryObject.addSelectCountField("*", "cont");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("registri");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("tipo");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("registri");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("tipo");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                AccessoRegistroRegistro arr = new AccessoRegistroRegistro();
                arr.setId(risultato.getLong("id"));
                arr.setNome(risultato.getString("nome"));
                arr.setTipo(RegistroTipo.toEnumConstant(risultato.getString("tipo")));
                lista.add(arr);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<ResponseCachingConfigurazioneRegola> responseCachingConfigurazioneRegolaList(ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<ResponseCachingConfigurazioneRegola> arrayList;
        String nomeMetodo = "responseCachingConfigurazioneRegolaList";
        int idLista = Liste.CONFIGURAZIONE_RESPONSE_CACHING_CONFIGURAZIONE_REGOLA;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<ResponseCachingConfigurazioneRegola> lista = new ArrayList<ResponseCachingConfigurazioneRegola>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("responseCachingConfigurazioneRegolaList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("config_cache_regole");
            sqlQueryObject.addSelectCountField("id", "cont");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("config_cache_regole");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addOrderBy("id");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            ArrayList<Long> idLong = new ArrayList<Long>();
            while (risultato.next()) {
                idLong.add(risultato.getLong("id"));
            }
            risultato.close();
            stmt.close();
            if (!idLong.isEmpty()) {
                for (Long idLongRegola : idLong) {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObject.addFromTable("config_cache_regole");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addSelectField("status_min");
                    sqlQueryObject.addSelectField("status_max");
                    sqlQueryObject.addSelectField("fault");
                    sqlQueryObject.addSelectField("cache_seconds");
                    sqlQueryObject.addWhereCondition("id=?");
                    queryString = sqlQueryObject.createSQLQuery();
                    stmt = con.prepareStatement(queryString);
                    stmt.setLong(1, idLongRegola);
                    risultato = stmt.executeQuery();
                    if (risultato.next()) {
                        int fault;
                        ResponseCachingConfigurazioneRegola regola = new ResponseCachingConfigurazioneRegola();
                        regola.setId(risultato.getLong("id"));
                        int status_min = risultato.getInt("status_min");
                        int status_max = risultato.getInt("status_max");
                        if (status_min > 0) {
                            regola.setReturnCodeMin(status_min);
                        }
                        if (status_max > 0) {
                            regola.setReturnCodeMax(status_max);
                        }
                        if (1 == (fault = risultato.getInt("fault"))) {
                            regola.setFault(true);
                        } else if (0 == fault) {
                            regola.setFault(false);
                        }
                        int cacheSeconds = risultato.getInt("cache_seconds");
                        if (cacheSeconds > 0) {
                            regola.setCacheTimeoutSeconds(cacheSeconds);
                        }
                        lista.add(regola);
                    }
                    risultato.close();
                    stmt.close();
                }
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<ConfigurazioneUrlInvocazioneRegola> proxyPassConfigurazioneRegolaList(ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<ConfigurazioneUrlInvocazioneRegola> arrayList;
        String nomeMetodo = "proxyPassConfigurazioneRegolaList";
        int idLista = Liste.CONFIGURAZIONE_PROXY_PASS_REGOLA;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<ConfigurazioneUrlInvocazioneRegola> lista = new ArrayList<ConfigurazioneUrlInvocazioneRegola>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("responseCachingConfigurazioneRegolaList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("config_url_regole");
            sqlQueryObject.addSelectCountField("id", "cont");
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            if ((risultato = (stmt = con.prepareStatement(queryString = sqlQueryObject.createSQLQuery())).executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("config_url_regole");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("posizione");
            sqlQueryObject.addSelectField("stato");
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("regexpr");
            sqlQueryObject.addSelectField("regola");
            sqlQueryObject.addSelectField("contesto_esterno");
            sqlQueryObject.addSelectField("base_url");
            sqlQueryObject.addSelectField("protocollo");
            sqlQueryObject.addSelectField("ruolo");
            sqlQueryObject.addSelectField("service_binding");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            sqlQueryObject.addOrderBy("posizione");
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                ConfigurazioneUrlInvocazioneRegola regola = new ConfigurazioneUrlInvocazioneRegola();
                regola.setId(risultato.getLong("id"));
                regola.setNome(risultato.getString("nome"));
                regola.setPosizione(risultato.getInt("posizione"));
                regola.setStato(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(risultato.getString("stato")));
                regola.setDescrizione(risultato.getString("descrizione"));
                if (risultato.getInt("regexpr") == 1) {
                    regola.setRegexpr(true);
                } else {
                    regola.setRegexpr(false);
                }
                regola.setRegola(risultato.getString("regola"));
                String s = risultato.getString("contesto_esterno");
                if ("_____@@EMPTY@@____".equals(s)) {
                    s = "";
                }
                regola.setContestoEsterno(s);
                regola.setBaseUrl(risultato.getString("base_url"));
                regola.setProtocollo(risultato.getString("protocollo"));
                regola.setRuolo(DriverConfigurazioneDBLib.getEnumRuoloContesto(risultato.getString("ruolo")));
                regola.setServiceBinding(DriverConfigurazioneDBLib.getEnumServiceBinding(risultato.getString("service_binding")));
                String tipoSoggetto = risultato.getString("tipo_soggetto");
                String nomeSoggetto = risultato.getString("nome_soggetto");
                if (tipoSoggetto != null && !"".equals(tipoSoggetto) && nomeSoggetto != null && !"".equals(nomeSoggetto)) {
                    regola.setSoggetto(new IdSoggetto(new IDSoggetto(tipoSoggetto, nomeSoggetto)));
                }
                lista.add(regola);
            }
            risultato.close();
            stmt.close();
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<CanaleConfigurazione> canaleConfigurazioneList(ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<CanaleConfigurazione> arrayList;
        String nomeMetodo = "canaleConfigurazioneList";
        int idLista = Liste.CONFIGURAZIONE_CANALI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<CanaleConfigurazione> lista = new ArrayList<CanaleConfigurazione>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("canali_configurazione");
            sqlQueryObject.addSelectCountField("id", "cont");
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            if ((risultato = (stmt = con.prepareStatement(queryString = sqlQueryObject.createSQLQuery())).executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("canali_configurazione");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("canale_default");
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                CanaleConfigurazione canale = new CanaleConfigurazione();
                canale.setId(risultato.getLong("id"));
                canale.setNome(risultato.getString("nome"));
                canale.setDescrizione(risultato.getString("descrizione"));
                int v = risultato.getInt("canale_default");
                if (v == 1) {
                    canale.setCanaleDefault(true);
                } else {
                    canale.setCanaleDefault(false);
                }
                lista.add(canale);
            }
            risultato.close();
            stmt.close();
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<CanaleConfigurazioneNodo> canaleNodoConfigurazioneList(ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<CanaleConfigurazioneNodo> arrayList;
        String nomeMetodo = "canaleNodoConfigurazioneList";
        int idLista = Liste.CONFIGURAZIONE_CANALI_NODI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<CanaleConfigurazioneNodo> lista = new ArrayList<CanaleConfigurazioneNodo>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("canali_nodi");
            sqlQueryObject.addSelectCountField("id", "cont");
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            if ((risultato = (stmt = con.prepareStatement(queryString = sqlQueryObject.createSQLQuery())).executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("canali_nodi");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("canali");
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                CanaleConfigurazioneNodo canaleNodo = new CanaleConfigurazioneNodo();
                canaleNodo.setId(risultato.getLong("id"));
                canaleNodo.setNome(risultato.getString("nome"));
                canaleNodo.setDescrizione(risultato.getString("descrizione"));
                List<String> l = DBUtils.convertToList(risultato.getString("canali"));
                canaleNodo.setCanaleList(l);
                lista.add(canaleNodo);
            }
            risultato.close();
            stmt.close();
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected boolean existsFaseTracciamentoDBRequestIn(boolean erogazioni, boolean fruizioni) throws DriverConfigurazioneException {
        return this.existsFaseTracciamentoDB("existsFaseTracciamentoDBRequestIn", erogazioni, fruizioni, true, false, false);
    }

    protected boolean existsFaseTracciamentoDBRequestOut(boolean erogazioni, boolean fruizioni) throws DriverConfigurazioneException {
        return this.existsFaseTracciamentoDB("existsFaseTracciamentoDBRequestOut", erogazioni, fruizioni, false, true, false);
    }

    protected boolean existsFaseTracciamentoDBResponseOut(boolean erogazioni, boolean fruizioni) throws DriverConfigurazioneException {
        return this.existsFaseTracciamentoDB("existsFaseTracciamentoDBResponseOut", erogazioni, fruizioni, false, false, true);
    }

    private boolean existsFaseTracciamentoDB(String nomeMetodo, boolean erogazioni, boolean fruizioni, boolean inRequest, boolean outRequest, boolean outResponse) throws DriverConfigurazioneException {
        boolean bl;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("tracce_config");
            sqlQueryObject.addSelectCountField("id", "cont");
            sqlQueryObject.addWhereLikeCondition("stato", StatoFunzionalitaConPersonalizzazione.PERSONALIZZATO.getValue(), false, false);
            sqlQueryObject.addWhereLikeCondition("tipo", "db", false, false);
            ArrayList<String> valori = new ArrayList<String>();
            if (erogazioni) {
                valori.add("configpa");
                valori.add("pa");
            }
            if (fruizioni) {
                valori.add("configpd");
                valori.add("pd");
            }
            sqlQueryObject.addWhereINCondition("proprietario", true, valori.toArray(new String[1]));
            if (inRequest) {
                sqlQueryObject.addWhereLikeCondition("request_in", StatoFunzionalita.ABILITATO.getValue(), false, false);
            }
            if (outRequest) {
                sqlQueryObject.addWhereLikeCondition("request_out", StatoFunzionalita.ABILITATO.getValue(), false, false);
            }
            if (outResponse) {
                sqlQueryObject.addWhereLikeCondition("response_out", StatoFunzionalita.ABILITATO.getValue(), false, false);
            }
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            boolean result = false;
            if (risultato.next()) {
                int c = risultato.getInt(1);
                result = c > 0;
            }
            risultato.close();
            stmt.close();
            bl = result;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return bl;
    }
}

