/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.byok.IDriverBYOK;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.IExtendedInfo;
import org.openspcoop2.core.config.AttributeAuthority;
import org.openspcoop2.core.config.AutorizzazioneRuoli;
import org.openspcoop2.core.config.AutorizzazioneScope;
import org.openspcoop2.core.config.ConfigurazioneMessageHandlers;
import org.openspcoop2.core.config.ConfigurazionePortaHandler;
import org.openspcoop2.core.config.CorrelazioneApplicativa;
import org.openspcoop2.core.config.CorrelazioneApplicativaElemento;
import org.openspcoop2.core.config.CorrelazioneApplicativaRisposta;
import org.openspcoop2.core.config.CorrelazioneApplicativaRispostaElemento;
import org.openspcoop2.core.config.CorsConfigurazione;
import org.openspcoop2.core.config.DumpConfigurazione;
import org.openspcoop2.core.config.GestioneToken;
import org.openspcoop2.core.config.GestioneTokenAutenticazione;
import org.openspcoop2.core.config.MessageSecurity;
import org.openspcoop2.core.config.MessageSecurityFlow;
import org.openspcoop2.core.config.MessageSecurityFlowParameter;
import org.openspcoop2.core.config.MtomProcessor;
import org.openspcoop2.core.config.MtomProcessorFlow;
import org.openspcoop2.core.config.MtomProcessorFlowParameter;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.PortaDelegataAutorizzazioneServiziApplicativi;
import org.openspcoop2.core.config.PortaDelegataAutorizzazioneToken;
import org.openspcoop2.core.config.PortaDelegataAzione;
import org.openspcoop2.core.config.PortaDelegataLocalForward;
import org.openspcoop2.core.config.PortaDelegataServizio;
import org.openspcoop2.core.config.PortaDelegataServizioApplicativo;
import org.openspcoop2.core.config.PortaDelegataSoggettoErogatore;
import org.openspcoop2.core.config.PortaTracciamento;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.ProprietaOggetto;
import org.openspcoop2.core.config.ResponseCachingConfigurazione;
import org.openspcoop2.core.config.Ruolo;
import org.openspcoop2.core.config.Scope;
import org.openspcoop2.core.config.TracciamentoConfigurazione;
import org.openspcoop2.core.config.TracciamentoConfigurazioneFiletrace;
import org.openspcoop2.core.config.Transazioni;
import org.openspcoop2.core.config.Trasformazioni;
import org.openspcoop2.core.config.ValidazioneContenutiApplicativi;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.PortaDelegataAzioneIdentificazione;
import org.openspcoop2.core.config.constants.RuoloTipoMatch;
import org.openspcoop2.core.config.constants.RuoloTipologia;
import org.openspcoop2.core.config.constants.ScopeTipoMatch;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.ExtendedInfoManager;
import org.openspcoop2.core.config.driver.FiltroRicercaPorteDelegate;
import org.openspcoop2.core.config.driver.IDServizioUtils;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBLib;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBSoggetti;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBTracciamentoLIB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBTrasformazioniLib;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBUtils;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_dumpLIB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_handlerLIB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_porteDelegateLIB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_porteDriver;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.id.IdentificativiFruizione;
import org.openspcoop2.core.mapping.DBMappingUtils;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverConfigurazioneDB_porteDelegateDriver {
    private DriverConfigurazioneDB driver = null;
    private DriverConfigurazioneDB_porteDriver porteDriver = null;
    private DriverConfigurazioneDBSoggetti soggettiDriver = null;
    private DriverConfigurazioneDBUtils utilsDriver = null;

    protected DriverConfigurazioneDB_porteDelegateDriver(DriverConfigurazioneDB driver) {
        this.driver = driver;
        this.porteDriver = new DriverConfigurazioneDB_porteDriver(driver);
        this.soggettiDriver = new DriverConfigurazioneDBSoggetti(driver);
        this.utilsDriver = new DriverConfigurazioneDBUtils(driver);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IDPortaDelegata getIDPortaDelegata(String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        IDPortaDelegata iDPortaDelegata;
        String nomeMetodo = "getIDPortaDelegata";
        if (nome == null) {
            throw new DriverConfigurazioneException("[" + nomeMetodo + "] Parametro Non Valido");
        }
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String azione;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome_porta = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, nome);
            this.driver.logDebug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, nome));
            rs = stm.executeQuery();
            IDPortaDelegata idPD = null;
            if (!rs.next()) {
                throw new DriverConfigurazioneNotFound("PortaDelegata [" + nome + "] non esistente");
            }
            idPD = new IDPortaDelegata();
            idPD.setNome(rs.getString("nome_porta"));
            IdentificativiFruizione idFruizione = new IdentificativiFruizione();
            try {
                long idSoggProprietario = rs.getLong("id_soggetto");
                IDSoggetto idSoggettoProprietario = this.soggettiDriver.getIdSoggetto(idSoggProprietario, con);
                idFruizione.setSoggettoFruitore(idSoggettoProprietario);
            }
            catch (Exception se) {
                throw new Exception(se.getMessage());
            }
            String nomeSoggettoErogatore = rs.getString("nome_soggetto_erogatore");
            String tipoSoggettoErogatore = rs.getString("tipo_soggetto_erogatore");
            long idSoggettoErogatoreDB = rs.getLong("id_soggetto_erogatore");
            long idSoggErogatore = -1L;
            if (idSoggettoErogatoreDB == -2L || idSoggettoErogatoreDB > 0L) {
                idSoggErogatore = idSoggettoErogatoreDB;
            } else {
                try {
                    idSoggErogatore = DBUtils.getIdSoggetto(nomeSoggettoErogatore, tipoSoggettoErogatore, con, this.driver.tipoDB, this.driver.tabellaSoggetti);
                }
                catch (CoreException e) {
                    this.driver.logDebug(e.getMessage(), e);
                }
            }
            IDSoggetto idSoggettoErogatore = null;
            if (idSoggErogatore <= 0L) {
                throw new DriverConfigurazioneException("Soggetto Erogatore della Porta Delegata [" + nome + "] non presente.");
            }
            idSoggettoErogatore = new IDSoggetto();
            idSoggettoErogatore.setTipo(tipoSoggettoErogatore);
            idSoggettoErogatore.setNome(nomeSoggettoErogatore);
            String tipoServizio = rs.getString("tipo_servizio");
            String nomeServizio = rs.getString("nome_servizio");
            Integer versioneServizio = rs.getInt("versione_servizio");
            long idServizioDB = rs.getLong("id_servizio");
            long idServizio = -1L;
            if (idServizioDB == -2L || idServizioDB > 0L) {
                idServizio = idServizioDB;
            } else {
                try {
                    idServizio = DBUtils.getIdServizio(nomeServizio, tipoServizio, versioneServizio, nomeSoggettoErogatore, tipoSoggettoErogatore, con, this.driver.tipoDB, this.driver.tabellaSoggetti);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            IDServizio idServizioObject = null;
            if (idServizio > 0L) {
                idServizioObject = IDServizioUtils.buildIDServizio(tipoServizio, nomeServizio, idSoggettoErogatore, versioneServizio);
            }
            if ((azione = rs.getString("nome_azione")) != null && !"".equals(azione) && idServizioObject != null) {
                idServizioObject.setAzione(azione);
            }
            idFruizione.setIdServizio(idServizioObject);
            idPD.setIdentificativiFruizione(idFruizione);
            iDPortaDelegata = idPD;
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] SqlException: " + se.getMessage(), se);
                catch (DriverConfigurazioneException se2) {
                    throw se2;
                }
                catch (DriverConfigurazioneNotFound se3) {
                    throw se3;
                }
                catch (Exception se4) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception: " + se4.getMessage(), se4);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return iDPortaDelegata;
    }

    protected PortaDelegata getPortaDelegata(IDPortaDelegata idPD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (idPD == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPortaDelegata] Parametro idPD Non Valido");
        }
        String nome = idPD.getNome();
        if (nome == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPortaDelegata] Parametri non Validi");
        }
        Connection con = null;
        PortaDelegata pd = null;
        long idPortaDelegata = 0L;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getPortaDelegata(idPortaDelegata)");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPortaDelegata] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        boolean trovato = false;
        try {
            try {
                idPortaDelegata = DBUtils.getIdPortaDelegata(nome, con, this.driver.tipoDB);
            }
            catch (Exception se) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPortaDelegata] Exception: " + se.getMessage(), se);
            }
            if (idPortaDelegata > 0L) {
                trovato = true;
            }
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPortaDelegata] Exception: " + se.getMessage(), se);
        }
        finally {
            this.driver.closeConnection(con);
        }
        if (!trovato) {
            throw new DriverConfigurazioneNotFound("PortaDelegata [" + nome + "] non esistente");
        }
        pd = this.driver.getPortaDelegata(idPortaDelegata);
        return pd;
    }

    protected void createPortaDelegata(PortaDelegata aPD) throws DriverConfigurazioneException {
        if (aPD == null) {
            throw new DriverConfigurazioneException("Porta Delegata non valida");
        }
        if (aPD.getNome() == null || aPD.getNome().equals("")) {
            throw new DriverConfigurazioneException("Nome Porta Delegata non valido");
        }
        if (aPD.getNomeSoggettoProprietario() == null || aPD.getNomeSoggettoProprietario().equals("")) {
            throw new DriverConfigurazioneException("Nome Soggetto Proprietario Porta Delegata non valido");
        }
        if (aPD.getTipoSoggettoProprietario() == null || aPD.getTipoSoggettoProprietario().equals("")) {
            throw new DriverConfigurazioneException("Tipo Soggetto Proprietario Porta Delegata non valido");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("createPortaDelegata");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createPortaDelegata] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDPortaDelegata type = 1");
            DriverConfigurazioneDB_porteDelegateLIB.CRUDPortaDelegata(1, aPD, con, this.driver.getDriverWrapBYOK());
            this.driver.logDebug("Creazione PortaDelegata [" + aPD.getId() + "] completato.");
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createPortaDelegata] Errore durante la creazione della PortaDelegata : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void updatePortaDelegata(PortaDelegata aPD) throws DriverConfigurazioneException {
        if (aPD == null) {
            throw new DriverConfigurazioneException("Porta Delegata non valida");
        }
        if (aPD.getNome() == null || aPD.getNome().equals("")) {
            throw new DriverConfigurazioneException("Nome Porta Delegata non valido");
        }
        if (aPD.getNomeSoggettoProprietario() == null || aPD.getNomeSoggettoProprietario().equals("")) {
            throw new DriverConfigurazioneException("Nome Soggetto Proprietario Porta Delegata non valido");
        }
        if (aPD.getTipoSoggettoProprietario() == null || aPD.getTipoSoggettoProprietario().equals("")) {
            throw new DriverConfigurazioneException("Tipo Soggetto Proprietario Porta Delegata non valido");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("updatePortaDelegata");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updatePortaDelegata] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDPortaDelegata type = 2");
            DriverConfigurazioneDB_porteDelegateLIB.CRUDPortaDelegata(2, aPD, con, this.driver.getDriverWrapBYOK());
            this.driver.logDebug("Aggiornamento PortaDelegata [" + aPD.getId() + "] completato.");
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updatePortaDelegata] Errore durante l'aggiornamento della PortaDelegata : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void deletePortaDelegata(PortaDelegata aPD) throws DriverConfigurazioneException {
        if (aPD == null) {
            throw new DriverConfigurazioneException("Porta Delegata non valida");
        }
        if (aPD.getNome() == null || aPD.getNome().equals("")) {
            throw new DriverConfigurazioneException("Nome Porta Delegata non valido");
        }
        if (aPD.getNomeSoggettoProprietario() == null || aPD.getNomeSoggettoProprietario().equals("")) {
            throw new DriverConfigurazioneException("Nome Soggetto Proprietario Porta Delegata non valido");
        }
        if (aPD.getTipoSoggettoProprietario() == null || aPD.getTipoSoggettoProprietario().equals("")) {
            throw new DriverConfigurazioneException("Tipo Soggetto Proprietario Porta Delegata non valido");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("deletePortaDelegata");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deletePortaDelegata] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDPortaDelegata type = 3");
            long id = DriverConfigurazioneDB_porteDelegateLIB.CRUDPortaDelegata(3, aPD, con, this.driver.getDriverWrapBYOK());
            this.driver.logDebug("Cancellazione PortaDelegata [" + id + "] completato.");
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deletePortaDelegata] Errore durante la cancellazione della PortaDelegata : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected PortaDelegata getPortaDelegata(long id) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getPortaDelegata(id, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PortaDelegata getPortaDelegata(long id, Connection conParam) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        PortaDelegata portaDelegata;
        if (id <= 0L) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPortaDelegata] L'id della Porta Delegata deve essere > 0.");
        }
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        PreparedStatement stm1 = null;
        ResultSet rs1 = null;
        PortaDelegata pd = null;
        long idPortaDelegata = id;
        if (conParam != null) {
            con = conParam;
        } else if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getPortaDelegata(longId)");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPortaDelegata] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            List<Object> listExtInfo;
            Ruolo ruolo;
            IDriverBYOK driverBYOK;
            String encValue;
            String plainValue;
            String responseCacheStato;
            String corsStato;
            String tokenSaStato;
            String ruoliMatch;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addFromTable(this.driver.tabellaSoggetti);
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addSelectField("autenticazione");
            sqlQueryObject.addSelectField("autenticazione_opzionale");
            sqlQueryObject.addSelectField("token_policy");
            sqlQueryObject.addSelectField("token_opzionale");
            sqlQueryObject.addSelectField("token_validazione");
            sqlQueryObject.addSelectField("token_introspection");
            sqlQueryObject.addSelectField("token_user_info");
            sqlQueryObject.addSelectField("token_forward");
            sqlQueryObject.addSelectField("token_options");
            sqlQueryObject.addSelectField("token_authn_issuer");
            sqlQueryObject.addSelectField("token_authn_client_id");
            sqlQueryObject.addSelectField("token_authn_subject");
            sqlQueryObject.addSelectField("token_authn_username");
            sqlQueryObject.addSelectField("token_authn_email");
            sqlQueryObject.addSelectField("autorizzazione");
            sqlQueryObject.addSelectField("autorizzazione_xacml");
            sqlQueryObject.addSelectField("autorizzazione_contenuto");
            sqlQueryObject.addSelectField("id_soggetto");
            sqlQueryObject.addSelectField("nome_porta");
            sqlQueryObject.addSelectField("id_soggetto_erogatore");
            sqlQueryObject.addSelectField("tipo_soggetto_erogatore");
            sqlQueryObject.addSelectField("nome_soggetto_erogatore");
            sqlQueryObject.addSelectField("id_servizio");
            sqlQueryObject.addSelectField("tipo_servizio");
            sqlQueryObject.addSelectField("nome_servizio");
            sqlQueryObject.addSelectField("versione_servizio");
            sqlQueryObject.addSelectField("id_azione");
            sqlQueryObject.addSelectField("nome_azione");
            sqlQueryObject.addSelectField("mode_azione");
            sqlQueryObject.addSelectField("pattern_azione");
            sqlQueryObject.addSelectField("nome_porta_delegante_azione");
            sqlQueryObject.addSelectField("force_interface_based_azione");
            sqlQueryObject.addSelectField("ricevuta_asincrona_asim");
            sqlQueryObject.addSelectField("ricevuta_asincrona_sim");
            sqlQueryObject.addSelectField("integrazione");
            sqlQueryObject.addSelectField("scadenza_correlazione_appl");
            sqlQueryObject.addSelectField("validazione_contenuti_stato");
            sqlQueryObject.addSelectField("validazione_contenuti_tipo");
            sqlQueryObject.addSelectField("validazione_contenuti_mtom");
            sqlQueryObject.addSelectField("mtom_request_mode");
            sqlQueryObject.addSelectField("mtom_response_mode");
            sqlQueryObject.addSelectField("security");
            sqlQueryObject.addSelectField("security_mtom_req");
            sqlQueryObject.addSelectField("security_mtom_res");
            sqlQueryObject.addSelectField("security_request_mode");
            sqlQueryObject.addSelectField("security_response_mode");
            sqlQueryObject.addSelectField("allega_body");
            sqlQueryObject.addSelectField("scarta_body");
            sqlQueryObject.addSelectField("gestione_manifest");
            sqlQueryObject.addSelectAliasField("porte_delegate.descrizione", "descrizionePD");
            sqlQueryObject.addSelectField("stateless");
            sqlQueryObject.addSelectField("local_forward");
            sqlQueryObject.addSelectField("local_forward_pa");
            sqlQueryObject.addSelectField("ruoli_match");
            sqlQueryObject.addSelectField("token_sa_stato");
            sqlQueryObject.addSelectField("token_ruoli_stato");
            sqlQueryObject.addSelectField("token_ruoli_match");
            sqlQueryObject.addSelectField("token_ruoli_tipologia");
            sqlQueryObject.addSelectField("scope_stato");
            sqlQueryObject.addSelectField("scope_match");
            sqlQueryObject.addSelectField("ricerca_porta_azione_delegata");
            sqlQueryObject.addSelectField("msg_diag_severita");
            sqlQueryObject.addSelectField("tracciamento_stato");
            sqlQueryObject.addSelectField("tracciamento_esiti");
            sqlQueryObject.addSelectField("transazioni_tempi");
            sqlQueryObject.addSelectField("transazioni_token");
            sqlQueryObject.addSelectField("stato");
            sqlQueryObject.addSelectField("cors_stato");
            sqlQueryObject.addSelectField("cors_tipo");
            sqlQueryObject.addSelectField("cors_all_allow_origins");
            sqlQueryObject.addSelectField("cors_all_allow_methods");
            sqlQueryObject.addSelectField("cors_all_allow_headers");
            sqlQueryObject.addSelectField("cors_allow_credentials");
            sqlQueryObject.addSelectField("cors_allow_max_age");
            sqlQueryObject.addSelectField("cors_allow_max_age_seconds");
            sqlQueryObject.addSelectField("cors_allow_origins");
            sqlQueryObject.addSelectField("cors_allow_headers");
            sqlQueryObject.addSelectField("cors_allow_methods");
            sqlQueryObject.addSelectField("cors_allow_expose_headers");
            sqlQueryObject.addSelectField("response_cache_stato");
            sqlQueryObject.addSelectField("response_cache_seconds");
            sqlQueryObject.addSelectField("response_cache_max_msg_size");
            sqlQueryObject.addSelectField("response_cache_hash_url");
            sqlQueryObject.addSelectField("response_cache_hash_query");
            sqlQueryObject.addSelectField("response_cache_hash_query_list");
            sqlQueryObject.addSelectField("response_cache_hash_headers");
            sqlQueryObject.addSelectField("response_cache_hash_hdr_list");
            sqlQueryObject.addSelectField("response_cache_hash_payload");
            sqlQueryObject.addSelectField("response_cache_control_nocache");
            sqlQueryObject.addSelectField("response_cache_control_maxage");
            sqlQueryObject.addSelectField("response_cache_control_nostore");
            sqlQueryObject.addSelectField("id_accordo");
            sqlQueryObject.addSelectField("id_port_type");
            sqlQueryObject.addSelectField("options");
            sqlQueryObject.addSelectField("canale");
            sqlQueryObject.addSelectAliasField("porte_delegate", "utente_richiedente", "prop_obj_ur");
            sqlQueryObject.addSelectAliasField("porte_delegate", "data_creazione", "prop_obj_dc");
            sqlQueryObject.addSelectAliasField("porte_delegate", "utente_ultima_modifica", "prop_obj_um");
            sqlQueryObject.addSelectAliasField("porte_delegate", "data_ultima_modifica", "prop_obj_dm");
            sqlQueryObject.addWhereCondition("porte_delegate.id_soggetto = " + this.driver.tabellaSoggetti + ".id");
            sqlQueryObject.addWhereCondition("porte_delegate.id = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idPortaDelegata);
            rs = stm.executeQuery();
            if (!rs.next()) {
                throw new DriverConfigurazioneNotFound("[DriverConfigurazioneDB::getPortaDelegata] Nessuna PortaDelegata trovata.");
            }
            pd = new PortaDelegata();
            pd.setOptions(rs.getString("options"));
            pd.setTipoSoggettoProprietario(rs.getString("tipo_soggetto"));
            pd.setNomeSoggettoProprietario(rs.getString("nome_soggetto"));
            pd.setId(idPortaDelegata);
            pd.setAutenticazione(rs.getString("autenticazione"));
            pd.setAutenticazioneOpzionale(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs.getString("autenticazione_opzionale")));
            String tokenPolicy = rs.getString("token_policy");
            if (tokenPolicy != null && !"".equals(tokenPolicy)) {
                GestioneToken gestioneToken = new GestioneToken();
                gestioneToken.setPolicy(tokenPolicy);
                gestioneToken.setTokenOpzionale(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs.getString("token_opzionale")));
                gestioneToken.setValidazione(DriverConfigurazioneDBLib.getEnumStatoFunzionalitaConWarning(rs.getString("token_validazione")));
                gestioneToken.setIntrospection(DriverConfigurazioneDBLib.getEnumStatoFunzionalitaConWarning(rs.getString("token_introspection")));
                gestioneToken.setUserInfo(DriverConfigurazioneDBLib.getEnumStatoFunzionalitaConWarning(rs.getString("token_user_info")));
                gestioneToken.setForward(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs.getString("token_forward")));
                gestioneToken.setOptions(rs.getString("token_options"));
                String tokenAuthnIssuer = rs.getString("token_authn_issuer");
                String tokenAuthnClientId = rs.getString("token_authn_client_id");
                String tokenAuthnSubject = rs.getString("token_authn_subject");
                String tokenAuthnUsername = rs.getString("token_authn_username");
                String tokenAuthnEmail = rs.getString("token_authn_email");
                if (tokenAuthnIssuer != null || tokenAuthnClientId != null || tokenAuthnSubject != null || tokenAuthnUsername != null || tokenAuthnEmail != null) {
                    gestioneToken.setAutenticazione(new GestioneTokenAutenticazione());
                    gestioneToken.getAutenticazione().setIssuer(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(tokenAuthnIssuer));
                    gestioneToken.getAutenticazione().setClientId(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(tokenAuthnClientId));
                    gestioneToken.getAutenticazione().setSubject(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(tokenAuthnSubject));
                    gestioneToken.getAutenticazione().setUsername(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(tokenAuthnUsername));
                    gestioneToken.getAutenticazione().setEmail(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(tokenAuthnEmail));
                }
                pd.setGestioneToken(gestioneToken);
            }
            pd.setAutorizzazione(rs.getString("autorizzazione"));
            pd.setXacmlPolicy(rs.getString("autorizzazione_xacml"));
            pd.setAutorizzazioneContenuto(rs.getString("autorizzazione_contenuto"));
            pd.setDescrizione(rs.getString("descrizionePD"));
            pd.setIdSoggetto(rs.getLong("id_soggetto"));
            pd.setNome(rs.getString("nome_porta"));
            pd.setIdAccordo(rs.getLong("id_accordo"));
            pd.setIdPortType(rs.getLong("id_port_type"));
            String nomeSoggettoErogatore = rs.getString("nome_soggetto_erogatore");
            String tipoSoggettoErogatore = rs.getString("tipo_soggetto_erogatore");
            long idSoggettoErogatoreDB = rs.getLong("id_soggetto_erogatore");
            long idSoggErogatore = -1L;
            if (idSoggettoErogatoreDB == -2L || idSoggettoErogatoreDB > 0L) {
                idSoggErogatore = idSoggettoErogatoreDB;
            } else {
                try {
                    idSoggErogatore = DBUtils.getIdSoggetto(nomeSoggettoErogatore, tipoSoggettoErogatore, con, this.driver.tipoDB, this.driver.tabellaSoggetti);
                }
                catch (CoreException e) {
                    this.driver.logDebug(e.getMessage(), e);
                }
            }
            PortaDelegataSoggettoErogatore soggettoErogatorePD = null;
            if (idSoggErogatore <= 0L) {
                throw new DriverConfigurazioneException("Soggetto Erogatore della Porta Delegata [" + pd.getNome() + "] non presente.");
            }
            soggettoErogatorePD = new PortaDelegataSoggettoErogatore();
            soggettoErogatorePD.setId(idSoggErogatore);
            soggettoErogatorePD.setNome(nomeSoggettoErogatore);
            soggettoErogatorePD.setTipo(tipoSoggettoErogatore);
            pd.setSoggettoErogatore(soggettoErogatorePD);
            String tipoServizio = rs.getString("tipo_servizio");
            String nomeServizio = rs.getString("nome_servizio");
            Integer versioneServizio = rs.getInt("versione_servizio");
            long idServizioDB = rs.getLong("id_servizio");
            long idServizio = -1L;
            if (idServizioDB == -2L || idServizioDB > 0L) {
                idServizio = idServizioDB;
            } else {
                try {
                    idServizio = DBUtils.getIdServizio(nomeServizio, tipoServizio, versioneServizio, nomeSoggettoErogatore, tipoSoggettoErogatore, con, this.driver.tipoDB, this.driver.tabellaSoggetti);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            PortaDelegataServizio pdServizio = null;
            if (idServizio > 0L) {
                pdServizio = new PortaDelegataServizio();
                pdServizio.setId(idServizio);
                pdServizio.setNome(nomeServizio);
                pdServizio.setTipo(tipoServizio);
                pdServizio.setVersione(versioneServizio);
            } else {
                pdServizio = new PortaDelegataServizio();
                pdServizio.setNome(nomeServizio);
                pdServizio.setTipo(tipoServizio);
                pdServizio.setVersione(versioneServizio);
            }
            pd.setServizio(pdServizio);
            PortaDelegataAzione pdAzione = null;
            String modeAzione = rs.getString("mode_azione");
            long idAzione = rs.getLong("id_azione");
            if (idAzione > 0L || modeAzione != null && !"".equals(modeAzione)) {
                pdAzione = new PortaDelegataAzione();
                pdAzione.setId(rs.getLong("id_azione"));
                pdAzione.setNome(rs.getString("nome_azione"));
                pdAzione.setIdentificazione(PortaDelegataAzioneIdentificazione.toEnumConstant(modeAzione));
                pdAzione.setPattern(rs.getString("pattern_azione"));
                pdAzione.setNomePortaDelegante(rs.getString("nome_porta_delegante_azione"));
                pdAzione.setForceInterfaceBased(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs.getString("force_interface_based_azione")));
            }
            pd.setAzione(pdAzione);
            pd.setRicevutaAsincronaAsimmetrica(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs.getString("ricevuta_asincrona_asim")));
            pd.setRicevutaAsincronaSimmetrica(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs.getString("ricevuta_asincrona_sim")));
            pd.setIntegrazione(rs.getString("integrazione"));
            String scadenzaCorrelazione = rs.getString("scadenza_correlazione_appl");
            CorrelazioneApplicativa corr = null;
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("pd_correlazione");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_porta=?");
            sqlQueryObject.addOrderBy("id");
            sqlQueryObject.setSortType(true);
            String queryCorrApp = sqlQueryObject.createSQLQuery();
            PreparedStatement stmCorrApp = con.prepareStatement(queryCorrApp);
            stmCorrApp.setLong(1, idPortaDelegata);
            ResultSet rsCorrApp = stmCorrApp.executeQuery();
            while (rsCorrApp.next()) {
                if (corr == null) {
                    corr = new CorrelazioneApplicativa();
                }
                CorrelazioneApplicativaElemento cae = new CorrelazioneApplicativaElemento();
                cae.setId(rsCorrApp.getLong("id"));
                cae.setNome(rsCorrApp.getString("nome_elemento"));
                String modeCA = rsCorrApp.getString("mode_correlazione");
                cae.setIdentificazione(DriverConfigurazioneDBLib.getEnumCorrelazioneApplicativaRichiestaIdentificazione(modeCA));
                cae.setPattern(rsCorrApp.getString("pattern"));
                cae.setIdentificazioneFallita(DriverConfigurazioneDBLib.getEnumCorrelazioneApplicativaGestioneIdentificazioneFallita(rsCorrApp.getString("identificazione_fallita")));
                cae.setRiusoIdentificativo(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rsCorrApp.getString("riuso_id")));
                corr.addElemento(cae);
            }
            rsCorrApp.close();
            stmCorrApp.close();
            if (corr != null && scadenzaCorrelazione != null && !scadenzaCorrelazione.equals("")) {
                corr.setScadenza(scadenzaCorrelazione);
            }
            pd.setCorrelazioneApplicativa(corr);
            CorrelazioneApplicativaRisposta corrApplRisposta = null;
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("pd_correlazione_risposta");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_porta=?");
            sqlQueryObject.addOrderBy("id");
            sqlQueryObject.setSortType(true);
            queryCorrApp = sqlQueryObject.createSQLQuery();
            stmCorrApp = con.prepareStatement(queryCorrApp);
            stmCorrApp.setLong(1, idPortaDelegata);
            rsCorrApp = stmCorrApp.executeQuery();
            while (rsCorrApp.next()) {
                if (corrApplRisposta == null) {
                    corrApplRisposta = new CorrelazioneApplicativaRisposta();
                }
                CorrelazioneApplicativaRispostaElemento cae = new CorrelazioneApplicativaRispostaElemento();
                cae.setId(rsCorrApp.getLong("id"));
                cae.setNome(rsCorrApp.getString("nome_elemento"));
                String modeCA = rsCorrApp.getString("mode_correlazione");
                cae.setIdentificazione(DriverConfigurazioneDBLib.getEnumCorrelazioneApplicativaRispostaIdentificazione(modeCA));
                cae.setPattern(rsCorrApp.getString("pattern"));
                cae.setIdentificazioneFallita(DriverConfigurazioneDBLib.getEnumCorrelazioneApplicativaGestioneIdentificazioneFallita(rsCorrApp.getString("identificazione_fallita")));
                corrApplRisposta.addElemento(cae);
            }
            rsCorrApp.close();
            stmCorrApp.close();
            pd.setCorrelazioneApplicativaRisposta(corrApplRisposta);
            MtomProcessor mtomProcessor = null;
            String mtomRequest = rs.getString("mtom_request_mode");
            String mtomResponse = rs.getString("mtom_response_mode");
            if (mtomRequest != null && !mtomRequest.equals("") || mtomResponse != null && !mtomResponse.equals("")) {
                mtomProcessor = new MtomProcessor();
                if (mtomRequest != null && !mtomRequest.equals("")) {
                    mtomProcessor.setRequestFlow(new MtomProcessorFlow());
                    mtomProcessor.getRequestFlow().setMode(DriverConfigurazioneDBLib.getEnumMTOMProcessorType(mtomRequest));
                }
                if (mtomResponse != null && !mtomResponse.equals("")) {
                    mtomProcessor.setResponseFlow(new MtomProcessorFlow());
                    mtomProcessor.getResponseFlow().setMode(DriverConfigurazioneDBLib.getEnumMTOMProcessorType(mtomResponse));
                }
            }
            String validazioneContenutiStato = rs.getString("validazione_contenuti_stato");
            String validazioneContenutiTipo = rs.getString("validazione_contenuti_tipo");
            String validazioneContenutiMtom = rs.getString("validazione_contenuti_mtom");
            if (validazioneContenutiStato != null && !validazioneContenutiStato.equals("") || validazioneContenutiTipo != null && !validazioneContenutiTipo.equals("")) {
                ValidazioneContenutiApplicativi val = new ValidazioneContenutiApplicativi();
                if (validazioneContenutiStato != null && !validazioneContenutiStato.equals("")) {
                    val.setStato(DriverConfigurazioneDBLib.getEnumStatoFunzionalitaConWarning(validazioneContenutiStato));
                }
                if (validazioneContenutiTipo != null && !validazioneContenutiTipo.equals("")) {
                    val.setTipo(DriverConfigurazioneDBLib.getEnumValidazioneContenutiApplicativiTipo(validazioneContenutiTipo));
                }
                if (validazioneContenutiMtom != null && !validazioneContenutiMtom.equals("")) {
                    val.setAcceptMtomMessage(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(validazioneContenutiMtom));
                }
                pd.setValidazioneContenutiApplicativi(val);
            }
            pd.setAllegaBody(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs.getString("allega_body")));
            pd.setScartaBody(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs.getString("scarta_body")));
            pd.setGestioneManifest(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs.getString("gestione_manifest")));
            pd.setStateless(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs.getString("stateless")));
            String statoLocalForward = rs.getString("local_forward");
            PortaDelegataLocalForward pdLocalForward = new PortaDelegataLocalForward();
            pdLocalForward.setStato(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(statoLocalForward));
            pdLocalForward.setPortaApplicativa(rs.getString("local_forward_pa"));
            if (pdLocalForward.getStato() != null) {
                pd.setLocalForward(pdLocalForward);
            } else {
                pd.setLocalForward(null);
            }
            if (rs.getString("ricerca_porta_azione_delegata") != null) {
                pd.setRicercaPortaAzioneDelegata(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs.getString("ricerca_porta_azione_delegata")));
            }
            String msgDiagSeverita = rs.getString("msg_diag_severita");
            String tracciamentoStato = rs.getString("tracciamento_stato");
            String tracciamentoEsiti = rs.getString("tracciamento_esiti");
            String transazioniTempiElaborazione = rs.getString("transazioni_tempi");
            String transazioniToken = rs.getString("transazioni_token");
            TracciamentoConfigurazione tracciamentoDatabase = DriverConfigurazioneDBTracciamentoLIB.readTracciamentoConfigurazione(con, pd.getId(), "pd", "db");
            TracciamentoConfigurazione tracciamentoFiletrace = DriverConfigurazioneDBTracciamentoLIB.readTracciamentoConfigurazione(con, pd.getId(), "pd", "filetrace");
            TracciamentoConfigurazioneFiletrace tracciamentoFiletraceDetails = DriverConfigurazioneDBTracciamentoLIB.readTracciamentoConfigurazioneFiletrace(con, pd.getId(), "pd");
            if (msgDiagSeverita != null && StringUtils.isNotEmpty((String)msgDiagSeverita) || tracciamentoStato != null && StringUtils.isNotEmpty((String)tracciamentoStato) || tracciamentoEsiti != null && StringUtils.isNotEmpty((String)tracciamentoEsiti) || transazioniTempiElaborazione != null && StringUtils.isNotEmpty((String)transazioniTempiElaborazione) || transazioniToken != null && StringUtils.isNotEmpty((String)transazioniToken) || tracciamentoDatabase != null || tracciamentoFiletrace != null || tracciamentoFiletraceDetails != null) {
                PortaTracciamento tracciamento = new PortaTracciamento();
                tracciamento.setSeverita(DriverConfigurazioneDBLib.getEnumSeverita(msgDiagSeverita));
                tracciamento.setStato(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(tracciamentoStato));
                tracciamento.setEsiti(tracciamentoEsiti);
                if (transazioniTempiElaborazione != null && StringUtils.isNotEmpty((String)transazioniTempiElaborazione) || transazioniToken != null && StringUtils.isNotEmpty((String)transazioniToken)) {
                    tracciamento.setTransazioni(new Transazioni());
                    tracciamento.getTransazioni().setTempiElaborazione(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(transazioniTempiElaborazione));
                    tracciamento.getTransazioni().setToken(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(transazioniToken));
                }
                tracciamento.setDatabase(tracciamentoDatabase);
                tracciamento.setFiletrace(tracciamentoFiletrace);
                tracciamento.setFiletraceConfig(tracciamentoFiletraceDetails);
                pd.setTracciamento(tracciamento);
            }
            if (rs.getString("stato") != null) {
                pd.setStato(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs.getString("stato")));
            }
            String security = rs.getString("security");
            String securityMtomReq = rs.getString("security_mtom_req");
            String securityMtomRes = rs.getString("security_mtom_res");
            String securityRequestMode = rs.getString("security_request_mode");
            String securityResponseMode = rs.getString("security_response_mode");
            MessageSecurity messageSecurity = null;
            if (securityMtomReq != null && !securityMtomReq.equals("") || securityRequestMode != null && !securityRequestMode.equals("") || securityMtomRes != null && !securityMtomRes.equals("") || securityResponseMode != null && !securityResponseMode.equals("")) {
                messageSecurity = new MessageSecurity();
                if (securityMtomReq != null && !securityMtomReq.equals("")) {
                    if (messageSecurity.getRequestFlow() == null) {
                        messageSecurity.setRequestFlow(new MessageSecurityFlow());
                    }
                    messageSecurity.getRequestFlow().setApplyToMtom(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(securityMtomReq));
                }
                if (securityMtomRes != null && !securityMtomRes.equals("")) {
                    if (messageSecurity.getResponseFlow() == null) {
                        messageSecurity.setResponseFlow(new MessageSecurityFlow());
                    }
                    messageSecurity.getResponseFlow().setApplyToMtom(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(securityMtomRes));
                }
                if (securityRequestMode != null && !securityRequestMode.equals("")) {
                    if (messageSecurity.getRequestFlow() == null) {
                        messageSecurity.setRequestFlow(new MessageSecurityFlow());
                    }
                    messageSecurity.getRequestFlow().setMode(securityRequestMode);
                }
                if (securityResponseMode != null && !securityResponseMode.equals("")) {
                    if (messageSecurity.getResponseFlow() == null) {
                        messageSecurity.setResponseFlow(new MessageSecurityFlow());
                    }
                    messageSecurity.getResponseFlow().setMode(securityResponseMode);
                }
            }
            if ((ruoliMatch = rs.getString("ruoli_match")) != null && !"".equals(ruoliMatch)) {
                if (pd.getRuoli() == null) {
                    pd.setRuoli(new AutorizzazioneRuoli());
                }
                pd.getRuoli().setMatch(RuoloTipoMatch.toEnumConstant(ruoliMatch));
            }
            if ((tokenSaStato = rs.getString("token_sa_stato")) != null && !"".equals(tokenSaStato)) {
                if (pd.getAutorizzazioneToken() == null) {
                    pd.setAutorizzazioneToken(new PortaDelegataAutorizzazioneToken());
                }
                pd.getAutorizzazioneToken().setAutorizzazioneApplicativi(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(tokenSaStato));
            }
            String tokenRuoliStato = rs.getString("token_ruoli_stato");
            String tokenRuoliMatch = rs.getString("token_ruoli_match");
            String tokenRuoliTipologia = rs.getString("token_ruoli_tipologia");
            if (tokenRuoliStato != null && !"".equals(tokenRuoliStato) || tokenRuoliMatch != null && !"".equals(tokenRuoliMatch) || tokenRuoliTipologia != null && !"".equals(tokenRuoliTipologia)) {
                if (pd.getAutorizzazioneToken() == null) {
                    pd.setAutorizzazioneToken(new PortaDelegataAutorizzazioneToken());
                }
                pd.getAutorizzazioneToken().setAutorizzazioneRuoli(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(tokenRuoliStato));
                if (tokenRuoliMatch != null && !"".equals(tokenRuoliMatch)) {
                    if (pd.getAutorizzazioneToken().getRuoli() == null) {
                        pd.getAutorizzazioneToken().setRuoli(new AutorizzazioneRuoli());
                    }
                    pd.getAutorizzazioneToken().getRuoli().setMatch(RuoloTipoMatch.toEnumConstant(tokenRuoliMatch));
                }
                if (tokenRuoliTipologia != null && !"".equals(tokenRuoliTipologia)) {
                    pd.getAutorizzazioneToken().setTipologiaRuoli(RuoloTipologia.toEnumConstant(tokenRuoliTipologia));
                }
            }
            String scopeStato = rs.getString("scope_stato");
            String scopeMatch = rs.getString("scope_match");
            if (scopeStato != null && !"".equals(scopeStato) || scopeMatch != null && !"".equals(scopeMatch)) {
                if (pd.getScope() == null) {
                    pd.setScope(new AutorizzazioneScope());
                }
                pd.getScope().setStato(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(scopeStato));
                pd.getScope().setMatch(ScopeTipoMatch.toEnumConstant(scopeMatch));
            }
            if ((corsStato = rs.getString("cors_stato")) != null && !"".equals(corsStato)) {
                pd.setGestioneCors(new CorsConfigurazione());
                this.porteDriver.readConfigurazioneCors(pd.getGestioneCors(), rs);
            }
            if ((responseCacheStato = rs.getString("response_cache_stato")) != null && !"".equals(responseCacheStato)) {
                pd.setResponseCaching(new ResponseCachingConfigurazione());
                this.porteDriver.readResponseCaching(idPortaDelegata, false, true, pd.getResponseCaching(), rs, con);
            }
            String canale = rs.getString("canale");
            pd.setCanale(canale);
            pd.setProprietaOggetto(this.utilsDriver.readProprietaOggetto(rs, true));
            rs.close();
            stm.close();
            Trasformazioni trasformazioni = DriverConfigurazioneDBTrasformazioniLib.readTrasformazioni(idPortaDelegata, true, con);
            if (trasformazioni != null) {
                pd.setTrasformazioni(trasformazioni);
            }
            if (pdAzione != null) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_azioni");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_porta=?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, idPortaDelegata);
                this.driver.logDebug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idPortaDelegata));
                rs = stm.executeQuery();
                while (rs.next()) {
                    pdAzione.addAzioneDelegata(rs.getString("azione"));
                }
                rs.close();
                stm.close();
            }
            if (CostantiConfigurazione.ABILITATO.toString().equalsIgnoreCase(security)) {
                pd.setStatoMessageSecurity(CostantiConfigurazione.ABILITATO.toString());
            } else {
                pd.setStatoMessageSecurity(CostantiConfigurazione.DISABILITATO.toString());
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("pd_security_request");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_porta=?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idPortaDelegata);
            this.driver.logDebug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idPortaDelegata));
            rs = stm.executeQuery();
            while (rs.next()) {
                MessageSecurityFlowParameter secRfp = new MessageSecurityFlowParameter();
                secRfp.setNome(rs.getString("nome"));
                String plainValue2 = rs.getString("valore");
                String encValue2 = rs.getString("enc_value");
                if (encValue2 != null && StringUtils.isNotEmpty((String)encValue2)) {
                    IDriverBYOK driverBYOK2 = this.driver.getDriverUnwrapBYOK();
                    if (driverBYOK2 != null) {
                        secRfp.setValore(driverBYOK2.unwrapAsString(encValue2));
                    } else {
                        secRfp.setValore(encValue2);
                    }
                } else {
                    secRfp.setValore(plainValue2);
                }
                if (messageSecurity == null) {
                    messageSecurity = new MessageSecurity();
                }
                if (messageSecurity.getRequestFlow() == null) {
                    messageSecurity.setRequestFlow(new MessageSecurityFlow());
                }
                messageSecurity.getRequestFlow().addParameter(secRfp);
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("pd_security_response");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_porta=?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idPortaDelegata);
            this.driver.logDebug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idPortaDelegata));
            rs = stm.executeQuery();
            while (rs.next()) {
                MessageSecurityFlowParameter secResfp = new MessageSecurityFlowParameter();
                secResfp.setNome(rs.getString("nome"));
                String plainValue3 = rs.getString("valore");
                String encValue3 = rs.getString("enc_value");
                if (encValue3 != null && StringUtils.isNotEmpty((String)encValue3)) {
                    IDriverBYOK driverBYOK3 = this.driver.getDriverUnwrapBYOK();
                    if (driverBYOK3 != null) {
                        secResfp.setValore(driverBYOK3.unwrapAsString(encValue3));
                    } else {
                        secResfp.setValore(encValue3);
                    }
                } else {
                    secResfp.setValore(plainValue3);
                }
                if (messageSecurity == null) {
                    messageSecurity = new MessageSecurity();
                }
                if (messageSecurity.getResponseFlow() == null) {
                    messageSecurity.setResponseFlow(new MessageSecurityFlow());
                }
                messageSecurity.getResponseFlow().addParameter(secResfp);
            }
            rs.close();
            stm.close();
            pd.setMessageSecurity(messageSecurity);
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("pd_mtom_request");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_porta=?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm1 = con.prepareStatement(sqlQuery);
            stm1.setLong(1, idPortaDelegata);
            this.driver.logDebug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idPortaDelegata));
            rs1 = stm1.executeQuery();
            while (rs1.next()) {
                MtomProcessorFlowParameter rfp = new MtomProcessorFlowParameter();
                rfp.setNome(rs1.getString("nome"));
                rfp.setPattern(rs1.getString("pattern"));
                rfp.setContentType(rs1.getString("content_type"));
                int required = rs1.getInt("required");
                boolean isrequired = false;
                if (required == 1) {
                    isrequired = true;
                }
                rfp.setRequired(isrequired);
                if (mtomProcessor.getRequestFlow() == null) {
                    mtomProcessor.setRequestFlow(new MtomProcessorFlow());
                }
                mtomProcessor.getRequestFlow().addParameter(rfp);
            }
            rs1.close();
            stm1.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("pd_mtom_response");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_porta=?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm1 = con.prepareStatement(sqlQuery);
            stm1.setLong(1, idPortaDelegata);
            this.driver.logDebug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idPortaDelegata));
            rs1 = stm1.executeQuery();
            while (rs1.next()) {
                MtomProcessorFlowParameter rsfp = new MtomProcessorFlowParameter();
                rsfp.setNome(rs1.getString("nome"));
                rsfp.setPattern(rs1.getString("pattern"));
                rsfp.setContentType(rs1.getString("content_type"));
                int required = rs1.getInt("required");
                boolean isrequired = false;
                if (required == 1) {
                    isrequired = true;
                }
                rsfp.setRequired(isrequired);
                if (mtomProcessor.getResponseFlow() == null) {
                    mtomProcessor.setResponseFlow(new MtomProcessorFlow());
                }
                mtomProcessor.getResponseFlow().addParameter(rsfp);
            }
            rs1.close();
            stm1.close();
            pd.setMtomProcessor(mtomProcessor);
            long idSA = 0L;
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate_sa");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_porta=?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idPortaDelegata);
            rs = stm.executeQuery();
            while (rs.next()) {
                idSA = rs.getLong("id_servizio_applicativo");
                if (idSA == 0L) continue;
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addWhereCondition("id=?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm1 = con.prepareStatement(sqlQuery);
                stm1.setLong(1, idSA);
                this.driver.logDebug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idSA));
                rs1 = stm1.executeQuery();
                PortaDelegataServizioApplicativo servizioApplicativo = null;
                if (rs1.next()) {
                    servizioApplicativo = new PortaDelegataServizioApplicativo();
                    servizioApplicativo.setId(idSA);
                    servizioApplicativo.setNome(rs1.getString("nome"));
                    pd.addServizioApplicativo(servizioApplicativo);
                }
                rs1.close();
                stm1.close();
            }
            rs.close();
            stm.close();
            Proprieta prop = null;
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("pd_auth_properties");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_porta=?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idPortaDelegata);
            rs = stm.executeQuery();
            while (rs.next()) {
                prop = new Proprieta();
                prop.setId(rs.getLong("id"));
                prop.setNome(rs.getString("nome"));
                plainValue = rs.getString("valore");
                encValue = rs.getString("enc_value");
                if (encValue != null && StringUtils.isNotEmpty((String)encValue)) {
                    driverBYOK = this.driver.getDriverUnwrapBYOK();
                    if (driverBYOK != null) {
                        prop.setValore(driverBYOK.unwrapAsString(encValue));
                    } else {
                        prop.setValore(encValue);
                    }
                } else {
                    prop.setValore(plainValue);
                }
                pd.addProprietaAutenticazione(prop);
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("pd_authz_properties");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_porta=?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idPortaDelegata);
            rs = stm.executeQuery();
            while (rs.next()) {
                prop = new Proprieta();
                prop.setId(rs.getLong("id"));
                prop.setNome(rs.getString("nome"));
                plainValue = rs.getString("valore");
                encValue = rs.getString("enc_value");
                if (encValue != null && StringUtils.isNotEmpty((String)encValue)) {
                    driverBYOK = this.driver.getDriverUnwrapBYOK();
                    if (driverBYOK != null) {
                        prop.setValore(driverBYOK.unwrapAsString(encValue));
                    } else {
                        prop.setValore(encValue);
                    }
                } else {
                    prop.setValore(plainValue);
                }
                pd.addProprietaAutorizzazione(prop);
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("pd_authzc_properties");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_porta=?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idPortaDelegata);
            rs = stm.executeQuery();
            while (rs.next()) {
                prop = new Proprieta();
                prop.setId(rs.getLong("id"));
                prop.setNome(rs.getString("nome"));
                plainValue = rs.getString("valore");
                encValue = rs.getString("enc_value");
                if (encValue != null && StringUtils.isNotEmpty((String)encValue)) {
                    driverBYOK = this.driver.getDriverUnwrapBYOK();
                    if (driverBYOK != null) {
                        prop.setValore(driverBYOK.unwrapAsString(encValue));
                    } else {
                        prop.setValore(encValue);
                    }
                } else {
                    prop.setValore(plainValue);
                }
                pd.addProprietaAutorizzazioneContenuto(prop);
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("pd_ct_properties");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_porta=?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idPortaDelegata);
            rs = stm.executeQuery();
            while (rs.next()) {
                prop = new Proprieta();
                prop.setId(rs.getLong("id"));
                prop.setNome(rs.getString("nome"));
                prop.setValore(rs.getString("valore"));
                pd.addProprietaRateLimiting(prop);
            }
            rs.close();
            stm.close();
            prop = null;
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("pd_properties");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_porta=?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idPortaDelegata);
            rs = stm.executeQuery();
            while (rs.next()) {
                prop = new Proprieta();
                prop.setId(rs.getLong("id"));
                prop.setNome(rs.getString("nome"));
                plainValue = rs.getString("valore");
                encValue = rs.getString("enc_value");
                if (encValue != null && StringUtils.isNotEmpty((String)encValue)) {
                    driverBYOK = this.driver.getDriverUnwrapBYOK();
                    if (driverBYOK != null) {
                        prop.setValore(driverBYOK.unwrapAsString(encValue));
                    } else {
                        prop.setValore(encValue);
                    }
                } else {
                    prop.setValore(plainValue);
                }
                pd.addProprieta(prop);
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("pd_ruoli");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_porta=?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idPortaDelegata);
            rs = stm.executeQuery();
            while (rs.next()) {
                if (pd.getRuoli() == null) {
                    pd.setRuoli(new AutorizzazioneRuoli());
                }
                ruolo = new Ruolo();
                ruolo.setNome(rs.getString("ruolo"));
                pd.getRuoli().addRuolo(ruolo);
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("pd_scope");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_porta=?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idPortaDelegata);
            rs = stm.executeQuery();
            while (rs.next()) {
                if (pd.getScope() == null) {
                    pd.setScope(new AutorizzazioneScope());
                }
                Scope scope = new Scope();
                scope.setNome(rs.getString("scope"));
                pd.getScope().addScope(scope);
            }
            rs.close();
            stm.close();
            idSA = 0L;
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("pd_token_sa");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_porta=?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idPortaDelegata);
            rs = stm.executeQuery();
            while (rs.next()) {
                idSA = rs.getLong("id_servizio_applicativo");
                if (idSA == 0L) continue;
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addWhereCondition("id=?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm1 = con.prepareStatement(sqlQuery);
                stm1.setLong(1, idSA);
                this.driver.logDebug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idSA));
                rs1 = stm1.executeQuery();
                PortaDelegataServizioApplicativo servizioApplicativo = null;
                if (rs1.next()) {
                    servizioApplicativo = new PortaDelegataServizioApplicativo();
                    servizioApplicativo.setId(idSA);
                    servizioApplicativo.setNome(rs1.getString("nome"));
                    if (pd.getAutorizzazioneToken() == null) {
                        pd.setAutorizzazioneToken(new PortaDelegataAutorizzazioneToken());
                    }
                    if (pd.getAutorizzazioneToken().getServiziApplicativi() == null) {
                        pd.getAutorizzazioneToken().setServiziApplicativi(new PortaDelegataAutorizzazioneServiziApplicativi());
                    }
                    pd.getAutorizzazioneToken().getServiziApplicativi().addServizioApplicativo(servizioApplicativo);
                }
                rs1.close();
                stm1.close();
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("pd_token_ruoli");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_porta=?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idPortaDelegata);
            rs = stm.executeQuery();
            while (rs.next()) {
                if (pd.getAutorizzazioneToken() == null) {
                    pd.setAutorizzazioneToken(new PortaDelegataAutorizzazioneToken());
                }
                if (pd.getAutorizzazioneToken().getRuoli() == null) {
                    pd.getAutorizzazioneToken().setRuoli(new AutorizzazioneRuoli());
                }
                ruolo = new Ruolo();
                ruolo.setNome(rs.getString("ruolo"));
                pd.getAutorizzazioneToken().getRuoli().addRuolo(ruolo);
            }
            rs.close();
            stm.close();
            DumpConfigurazione dumpConfig = DriverConfigurazioneDB_dumpLIB.readDumpConfigurazione(con, pd.getId(), "pd");
            pd.setDump(dumpConfig);
            ConfigurazioneMessageHandlers requestHandlers = DriverConfigurazioneDB_handlerLIB.readConfigurazioneMessageHandlers(con, pd.getId(), null, true);
            ConfigurazioneMessageHandlers responseHandlers = DriverConfigurazioneDB_handlerLIB.readConfigurazioneMessageHandlers(con, pd.getId(), null, false);
            if (requestHandlers != null || responseHandlers != null) {
                pd.setConfigurazioneHandler(new ConfigurazionePortaHandler());
                pd.getConfigurazioneHandler().setRequest(requestHandlers);
                pd.getConfigurazioneHandler().setResponse(responseHandlers);
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("pd_aa");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_porta=?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idPortaDelegata);
            rs = stm.executeQuery();
            while (rs.next()) {
                String nome = rs.getString("nome");
                String attributi = rs.getString("attributi");
                AttributeAuthority aa = new AttributeAuthority();
                aa.setNome(nome);
                aa.setAttributoList(DBUtils.convertToList(attributi));
                pd.addAttributeAuthority(aa);
            }
            rs.close();
            stm.close();
            this.driver.logDebug("ExtendedInfo ...");
            ExtendedInfoManager extInfoManager = ExtendedInfoManager.getInstance();
            IExtendedInfo extInfoConfigurazioneDriver = extInfoManager.newInstanceExtendedInfoPortaDelegata();
            if (extInfoConfigurazioneDriver != null && (listExtInfo = extInfoConfigurazioneDriver.getAllExtendedInfo(con, this.driver.log, pd)) != null && !listExtInfo.isEmpty()) {
                for (Object object : listExtInfo) {
                    pd.addExtendedInfo(object);
                }
            }
            portaDelegata = pd;
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPortaDelegata] SqlException: " + se.getMessage(), se);
                catch (DriverConfigurazioneNotFound de) {
                    throw de;
                }
                catch (Exception se2) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPortaDelegata] Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                JDBCUtilities.closeResources(rs1, stm1);
                this.driver.closeConnection(conParam, con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        JDBCUtilities.closeResources((ResultSet)rs1, (PreparedStatement)stm1);
        this.driver.closeConnection(conParam, con);
        return portaDelegata;
    }

    protected List<String> porteDelegateRateLimitingValoriUnivoci(String pName) throws DriverConfigurazioneException {
        ArrayList<String> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<String> lista = new ArrayList<String>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("porteDelegateRateLimitingValoriUnivoci");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteDelegateRateLimitingValoriUnivoci] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("pd_ct_properties");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addSelectField("valore");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, pName);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                lista.add(risultato.getString("valore"));
            }
            risultato.close();
            stmt.close();
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteDelegateRateLimitingValoriUnivoci] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<String> nomiProprietaPD(String filterSoggettoTipo, String filterSoggettoNome, List<String> tipoServiziProtocollo) throws DriverConfigurazioneException {
        ArrayList<String> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<String> lista = new ArrayList<String>();
        String aliasSoggettiFruitori = "soggettoFruitore";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("nomiProprietaPD");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::nomiProprietaPD] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("pd_properties");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addSelectField("pd_properties.nome");
            sqlQueryObject.addOrderBy("pd_properties.nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setANDLogicOperator(true);
            if (filterSoggettoNome != null && !"".equals(filterSoggettoNome) || tipoServiziProtocollo != null && tipoServiziProtocollo.size() > 0) {
                sqlQueryObject.addFromTable("mapping_fruizione_pd");
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addWhereCondition("pd_properties.id_porta=porte_delegate.id");
                sqlQueryObject.addWhereCondition("mapping_fruizione_pd.id_porta=porte_delegate.id");
                sqlQueryObject.addWhereCondition("mapping_fruizione_pd.id_fruizione=servizi_fruitori.id");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio=servizi.id");
            }
            if (filterSoggettoNome != null && !"".equals(filterSoggettoNome)) {
                sqlQueryObject.addFromTable("soggetti", aliasSoggettiFruitori);
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto=" + aliasSoggettiFruitori + ".id");
                sqlQueryObject.addWhereCondition(aliasSoggettiFruitori + ".tipo_soggetto=?");
                sqlQueryObject.addWhereCondition(aliasSoggettiFruitori + ".nome_soggetto=?");
            }
            if (tipoServiziProtocollo != null && tipoServiziProtocollo.size() > 0) {
                String[] tipiServiziProtocolloS = tipoServiziProtocollo.toArray(new String[tipoServiziProtocollo.size()]);
                sqlQueryObject.addWhereINCondition("servizi.tipo_servizio", true, tipiServiziProtocolloS);
            }
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            if (filterSoggettoNome != null && !"".equals(filterSoggettoNome)) {
                stmt.setString(1, filterSoggettoTipo);
                stmt.setString(2, filterSoggettoNome);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                lista.add(risultato.getString("nome"));
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::nomiProprietaPD] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<PortaDelegata> porteDelegateWithSoggettoErogatoreList(long idSoggettoErogatore) throws DriverConfigurazioneException {
        ArrayList<PortaDelegata> arrayList;
        String nomeMetodo = "porteDelegateWithSoggettoErogatoreList";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortaDelegata> lista = new ArrayList<PortaDelegata>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("porteDelegateWithSoggettoErogatoreList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_soggetto_erogatore = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggettoErogatore);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                PortaDelegata pd = this.getPortaDelegata(risultato.getLong("id"), con);
                lista.add(pd);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<PortaDelegata> porteDelegateWithTipoNomeErogatoreList(String tipoSoggettoErogatore, String nomeSoggettoErogatore) throws DriverConfigurazioneException {
        ArrayList<PortaDelegata> arrayList;
        String nomeMetodo = "porteDelegateWithTipoNomeErogatoreList";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortaDelegata> lista = new ArrayList<PortaDelegata>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("porteDelegateWithTipoNomeErogatoreList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("tipo_soggetto_erogatore = ?");
            sqlQueryObject.addWhereCondition("nome_soggetto_erogatore = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, tipoSoggettoErogatore);
            stmt.setString(2, nomeSoggettoErogatore);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                PortaDelegata pd = this.getPortaDelegata(risultato.getLong("id"), con);
                lista.add(pd);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected boolean existsPortaDelegata(IDPortaDelegata idPD) throws DriverConfigurazioneException {
        try {
            return this.getPortaDelegata(idPD) != null;
        }
        catch (DriverConfigurazioneNotFound e) {
            return false;
        }
    }

    protected List<PortaDelegata> getPorteDelegateWithServizio(Long idServizio, String tiposervizio, String nomeservizio, Integer versioneServizio, Long idSoggetto, String tiposoggetto, String nomesoggetto) throws DriverConfigurazioneException {
        ArrayList<PortaDelegata> arrayList;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        ArrayList<PortaDelegata> lista = new ArrayList<PortaDelegata>();
        try {
            if (this.driver.atomica) {
                try {
                    con = this.driver.getConnectionFromDatasource("getPorteDelegateWithServizio");
                }
                catch (Exception e) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPorteDelegateWithServizio] Exception accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.driver.globalConnection;
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition(false, new String[]{"id_servizio = ?", "tipo_servizio = ? AND nome_servizio = ? AND versione_servizio = ?"});
            sqlQueryObject.addWhereCondition(false, new String[]{"id_soggetto_erogatore = ?", "tipo_soggetto_erogatore = ? AND nome_soggetto_erogatore = ?"});
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            int index = 1;
            stm.setLong(index++, idServizio);
            stm.setString(index++, tiposervizio);
            stm.setString(index++, nomeservizio);
            stm.setInt(index++, versioneServizio);
            stm.setLong(index++, idSoggetto);
            stm.setString(index++, tiposoggetto);
            stm.setString(index++, nomesoggetto);
            this.driver.logDebug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idServizio, tiposervizio, nomeservizio, versioneServizio, idSoggetto, tiposoggetto, nomesoggetto));
            rs = stm.executeQuery();
            while (rs.next()) {
                lista.add(this.getPortaDelegata(rs.getLong("id")));
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException(qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<PortaDelegata> getPorteDelegateWithServizio(Long idServizio) throws DriverConfigurazioneException {
        ArrayList<PortaDelegata> arrayList;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        ArrayList<PortaDelegata> lista = new ArrayList<PortaDelegata>();
        try {
            if (this.driver.atomica) {
                try {
                    con = this.driver.getConnectionFromDatasource("getPorteDelegateWithServizio");
                }
                catch (Exception e) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPorteDelegateWithServizio] Exception accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.driver.globalConnection;
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_servizio = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idServizio);
            this.driver.logDebug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idServizio));
            rs = stm.executeQuery();
            while (rs.next()) {
                PortaDelegata pde = this.getPortaDelegata(rs.getLong("id"));
                lista.add(pde);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException(qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<IDPortaDelegata> getPortaDelegataAzione(String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        ArrayList<IDPortaDelegata> id = new ArrayList<IDPortaDelegata>();
        try {
            if (this.driver.atomica) {
                try {
                    con = this.driver.getConnectionFromDatasource("getPortaDelegataAzione");
                }
                catch (Exception e) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::existsPortaApplicativaAzione] Exception accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.driver.globalConnection;
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("nome_azione=?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, nome);
            this.driver.logDebug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, nome));
            rs = stm.executeQuery();
            while (rs.next()) {
                IDPortaDelegata idPD = new IDPortaDelegata();
                idPD.setNome(rs.getString("nome_porta"));
                id.add(idPD);
            }
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException(qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        if (id.size() > 0) {
            return id;
        }
        throw new DriverConfigurazioneNotFound("Porte Delegate che possiedono l'azione [" + nome + "] non esistenti");
    }

    protected boolean existsPortaDelegataAzione(String nome) throws DriverConfigurazioneException {
        boolean bl;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        try {
            if (this.driver.atomica) {
                try {
                    con = this.driver.getConnectionFromDatasource("existsPortaDelegataAzione");
                }
                catch (Exception e) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::existsPortaDelegataAzione] Exception accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.driver.globalConnection;
            }
            boolean esiste = false;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome_azione=?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, nome);
            this.driver.logDebug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, nome));
            rs = stm.executeQuery();
            if (rs.next()) {
                esiste = true;
            }
            bl = esiste;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException(qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return bl;
    }

    protected List<PortaDelegata> getPorteDelegateBySoggetto(long idSoggetto) throws DriverConfigurazioneException {
        ArrayList<PortaDelegata> arrayList;
        String nomeMetodo = "getPorteDelegateBySoggetto";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortaDelegata> lista = new ArrayList<PortaDelegata>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_soggetto=?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggetto);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Long id = risultato.getLong("id");
                lista.add(this.getPortaDelegata(id));
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<IDPortaDelegata> getAllIdPorteDelegate(FiltroRicercaPorteDelegate filtroRicerca) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        ArrayList<String> nomiPD = null;
        this.driver.logDebug("getAllIdPorteDelegate...");
        try {
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = this.driver.atomica ? this.driver.getConnectionFromDatasource("getAllIdPorteDelegate") : this.driver.globalConnection;
            String alias_SERVIZI_APPLICATIVI_autorizzati = "saauthz";
            String alias_SERVIZI_APPLICATIVI_token_autorizzati = "satokenauthz";
            String alias_SERVIZI_APPLICATIVI_traformazioni = "satrasf";
            String alias_SERVIZI_APPLICATIVI_TOKEN_traformazioni = "satokentrasf";
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            if (filtroRicerca != null && (filtroRicerca.getTipoSoggetto() != null || filtroRicerca.getNomeSoggetto() != null)) {
                sqlQueryObject.addFromTable("soggetti");
            }
            sqlQueryObject.addSelectField("porte_delegate.nome_porta");
            if (filtroRicerca != null && (filtroRicerca.getTipoSoggetto() != null || filtroRicerca.getNomeSoggetto() != null)) {
                sqlQueryObject.addWhereCondition("porte_delegate.id_soggetto = soggetti.id");
            }
            if (filtroRicerca != null && filtroRicerca.getIdRuolo() != null) {
                sqlQueryObject.addFromTable("pd_ruoli");
                sqlQueryObject.addWhereCondition("pd_ruoli.id_porta = porte_delegate.id");
            }
            if (filtroRicerca != null && filtroRicerca.getIdScope() != null) {
                sqlQueryObject.addFromTable("pd_scope");
                sqlQueryObject.addWhereCondition("pd_scope.id_porta = porte_delegate.id");
            }
            if (filtroRicerca != null && filtroRicerca.getNomeServizioApplicativo() != null) {
                sqlQueryObject.addFromTable("porte_delegate_sa");
                sqlQueryObject.addFromTable("servizi_applicativi", alias_SERVIZI_APPLICATIVI_autorizzati);
                sqlQueryObject.addWhereCondition("porte_delegate_sa.id_porta = porte_delegate.id");
                sqlQueryObject.addWhereCondition("porte_delegate_sa.id_servizio_applicativo = " + alias_SERVIZI_APPLICATIVI_autorizzati + ".id");
            }
            if (filtroRicerca != null && filtroRicerca.getNomeServizioApplicativoToken() != null) {
                sqlQueryObject.addFromTable("pd_token_sa");
                sqlQueryObject.addFromTable("servizi_applicativi", alias_SERVIZI_APPLICATIVI_token_autorizzati);
                sqlQueryObject.addWhereCondition("pd_token_sa.id_porta = porte_delegate.id");
                sqlQueryObject.addWhereCondition("pd_token_sa.id_servizio_applicativo = " + alias_SERVIZI_APPLICATIVI_token_autorizzati + ".id");
            }
            if (filtroRicerca != null && filtroRicerca.getIdRuoloToken() != null) {
                sqlQueryObject.addFromTable("pd_token_ruoli");
                sqlQueryObject.addWhereCondition("pd_token_ruoli.id_porta = porte_delegate.id");
            }
            if (filtroRicerca != null && filtroRicerca.getNomeServizioApplicativoRiferitoApplicabilitaTrasformazione() != null) {
                sqlQueryObject.addFromTable("porte_delegate_sa");
                sqlQueryObject.addFromTable("servizi_applicativi", alias_SERVIZI_APPLICATIVI_traformazioni);
                sqlQueryObject.addFromTable("pd_transform");
                sqlQueryObject.addFromTable("pd_transform_sa");
                sqlQueryObject.addWhereCondition("pd_transform.id_porta = porte_delegate.id");
                sqlQueryObject.addWhereCondition("pd_transform_sa.id_trasformazione = pd_transform.id");
                sqlQueryObject.addWhereCondition("pd_transform_sa.id_servizio_applicativo = " + alias_SERVIZI_APPLICATIVI_traformazioni + ".id");
            }
            if (filtroRicerca != null && filtroRicerca.getNomeServizioApplicativoTokenRiferitoApplicabilitaTrasformazione() != null) {
                sqlQueryObject.addFromTable("pd_token_sa");
                sqlQueryObject.addFromTable("servizi_applicativi", alias_SERVIZI_APPLICATIVI_TOKEN_traformazioni);
                sqlQueryObject.addFromTable("pd_transform");
                sqlQueryObject.addFromTable("pd_transform_sa");
                sqlQueryObject.addWhereCondition("pd_transform.id_porta = porte_delegate.id");
                sqlQueryObject.addWhereCondition("pd_transform_sa.id_trasformazione = pd_transform.id");
                sqlQueryObject.addWhereCondition("pd_transform_sa.id_servizio_applicativo = " + alias_SERVIZI_APPLICATIVI_traformazioni + ".id");
            }
            boolean porteDelegatePerAzioni = false;
            if (filtroRicerca != null && filtroRicerca.getNomePortaDelegante() != null) {
                porteDelegatePerAzioni = true;
                if (filtroRicerca.getAzione() != null) {
                    sqlQueryObject.addFromTable("pd_azioni");
                    sqlQueryObject.addWhereCondition("pd_azioni.id_porta = porte_delegate.id");
                }
            }
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    sqlQueryObject.addWhereCondition("porte_delegate.ora_registrazione > ?");
                }
                if (filtroRicerca.getMaxDate() != null) {
                    sqlQueryObject.addWhereCondition("porte_delegate.ora_registrazione < ?");
                }
                if (filtroRicerca.getTipoSoggetto() != null) {
                    sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto = ?");
                }
                if (filtroRicerca.getNomeSoggetto() != null) {
                    sqlQueryObject.addWhereCondition("soggetti.nome_soggetto = ?");
                }
                if (filtroRicerca.getTipoSoggettoErogatore() != null) {
                    sqlQueryObject.addWhereCondition("porte_delegate.tipo_soggetto_erogatore = ?");
                }
                if (filtroRicerca.getNomeSoggettoErogatore() != null) {
                    sqlQueryObject.addWhereCondition("porte_delegate.nome_soggetto_erogatore = ?");
                }
                if (filtroRicerca.getTipoServizio() != null) {
                    sqlQueryObject.addWhereCondition("porte_delegate.tipo_servizio = ?");
                }
                if (filtroRicerca.getNomeServizio() != null) {
                    sqlQueryObject.addWhereCondition("porte_delegate.nome_servizio = ?");
                }
                if (filtroRicerca.getVersioneServizio() != null) {
                    sqlQueryObject.addWhereCondition("porte_delegate.versione_servizio = ?");
                }
                if (!porteDelegatePerAzioni && filtroRicerca.getAzione() != null) {
                    sqlQueryObject.addWhereCondition("porte_delegate.nome_azione = ?");
                }
                if (filtroRicerca.getNome() != null) {
                    sqlQueryObject.addWhereCondition("porte_delegate.nome_porta = ?");
                }
                if (filtroRicerca.getIdRuolo() != null) {
                    sqlQueryObject.addWhereCondition("pd_ruoli.ruolo = ?");
                }
                if (filtroRicerca.getIdScope() != null) {
                    sqlQueryObject.addWhereCondition("pd_scope.scope = ?");
                }
                if (filtroRicerca.getNomeServizioApplicativo() != null) {
                    sqlQueryObject.addWhereCondition(alias_SERVIZI_APPLICATIVI_autorizzati + ".nome = ?");
                }
                if (filtroRicerca.getNomeServizioApplicativoToken() != null) {
                    sqlQueryObject.addWhereCondition(alias_SERVIZI_APPLICATIVI_token_autorizzati + ".nome = ?");
                }
                if (filtroRicerca.getIdRuoloToken() != null) {
                    sqlQueryObject.addWhereCondition("pd_token_ruoli.ruolo = ?");
                }
                if (filtroRicerca.getNomeServizioApplicativoRiferitoApplicabilitaTrasformazione() != null) {
                    sqlQueryObject.addWhereCondition(alias_SERVIZI_APPLICATIVI_traformazioni + ".nome = ?");
                }
                if (filtroRicerca.getNomeServizioApplicativoTokenRiferitoApplicabilitaTrasformazione() != null) {
                    sqlQueryObject.addWhereCondition(alias_SERVIZI_APPLICATIVI_TOKEN_traformazioni + ".nome = ?");
                }
                if (filtroRicerca.getStato() != null) {
                    sqlQueryObject.addWhereCondition("porte_delegate.stato = ?");
                }
                if (porteDelegatePerAzioni) {
                    sqlQueryObject.addWhereCondition("porte_delegate.nome_porta_delegante_azione = ?");
                    if (filtroRicerca.getAzione() != null) {
                        sqlQueryObject.addWhereCondition("pd_azioni.azione = ?");
                    }
                }
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.driver.logDebug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    this.driver.logDebug("minDate stmt.setTimestamp(" + filtroRicerca.getMinDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMinDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    this.driver.logDebug("maxDate stmt.setTimestamp(" + filtroRicerca.getMaxDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMaxDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getTipoSoggetto() != null) {
                    this.driver.logDebug("tipoSoggetto stmt.setString(" + filtroRicerca.getTipoSoggetto() + ")");
                    stm.setString(indexStmt, filtroRicerca.getTipoSoggetto());
                    ++indexStmt;
                }
                if (filtroRicerca.getNomeSoggetto() != null) {
                    this.driver.logDebug("nomeSoggetto stmt.setString(" + filtroRicerca.getNomeSoggetto() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNomeSoggetto());
                    ++indexStmt;
                }
                if (filtroRicerca.getTipoSoggettoErogatore() != null) {
                    this.driver.logDebug("tipoSoggettoErogatore stmt.setString(" + filtroRicerca.getTipoSoggettoErogatore() + ")");
                    stm.setString(indexStmt, filtroRicerca.getTipoSoggettoErogatore());
                    ++indexStmt;
                }
                if (filtroRicerca.getNomeSoggettoErogatore() != null) {
                    this.driver.logDebug("nomeSoggettoErogatore stmt.setString(" + filtroRicerca.getNomeSoggettoErogatore() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNomeSoggettoErogatore());
                    ++indexStmt;
                }
                if (filtroRicerca.getTipoServizio() != null) {
                    this.driver.logDebug("tipoServizio stmt.setString(" + filtroRicerca.getTipoServizio() + ")");
                    stm.setString(indexStmt, filtroRicerca.getTipoServizio());
                    ++indexStmt;
                }
                if (filtroRicerca.getNomeServizio() != null) {
                    this.driver.logDebug("nomeServizio stmt.setString(" + filtroRicerca.getNomeServizio() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNomeServizio());
                    ++indexStmt;
                }
                if (filtroRicerca.getVersioneServizio() != null) {
                    this.driver.logDebug("versioneServizio stmt.setInt(" + filtroRicerca.getVersioneServizio() + ")");
                    stm.setInt(indexStmt, filtroRicerca.getVersioneServizio());
                    ++indexStmt;
                }
                if (!porteDelegatePerAzioni && filtroRicerca.getAzione() != null) {
                    this.driver.logDebug("azione stmt.setString(" + filtroRicerca.getAzione() + ")");
                    stm.setString(indexStmt, filtroRicerca.getAzione());
                    ++indexStmt;
                }
                if (filtroRicerca.getNome() != null) {
                    this.driver.logDebug("nome stmt.setString(" + filtroRicerca.getNome() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNome());
                    ++indexStmt;
                }
                if (filtroRicerca.getIdRuolo() != null) {
                    this.driver.logDebug("ruolo stmt.setString(" + filtroRicerca.getIdRuolo().getNome() + ")");
                    stm.setString(indexStmt, filtroRicerca.getIdRuolo().getNome());
                    ++indexStmt;
                }
                if (filtroRicerca.getIdScope() != null) {
                    this.driver.logDebug("scope stmt.setString(" + filtroRicerca.getIdScope().getNome() + ")");
                    stm.setString(indexStmt, filtroRicerca.getIdScope().getNome());
                    ++indexStmt;
                }
                if (filtroRicerca.getNomeServizioApplicativo() != null) {
                    this.driver.logDebug("servizioApplicativoAuthz stmt.setString(" + filtroRicerca.getNomeServizioApplicativo() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNomeServizioApplicativo());
                    ++indexStmt;
                }
                if (filtroRicerca.getNomeServizioApplicativoToken() != null) {
                    this.driver.logDebug("servizioApplicativoTokenAuthz stmt.setString(" + filtroRicerca.getNomeServizioApplicativoToken() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNomeServizioApplicativoToken());
                    ++indexStmt;
                }
                if (filtroRicerca.getIdRuoloToken() != null) {
                    this.driver.logDebug("ruoloToken stmt.setString(" + filtroRicerca.getIdRuoloToken().getNome() + ")");
                    stm.setString(indexStmt, filtroRicerca.getIdRuoloToken().getNome());
                    ++indexStmt;
                }
                if (filtroRicerca.getNomeServizioApplicativoRiferitoApplicabilitaTrasformazione() != null) {
                    this.driver.logDebug("servizioApplicativoTrasformazioni stmt.setString(" + filtroRicerca.getNomeServizioApplicativoRiferitoApplicabilitaTrasformazione() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNomeServizioApplicativoRiferitoApplicabilitaTrasformazione());
                    ++indexStmt;
                }
                if (filtroRicerca.getNomeServizioApplicativoTokenRiferitoApplicabilitaTrasformazione() != null) {
                    this.driver.logDebug("servizioApplicativoTokenTrasformazioni stmt.setString(" + filtroRicerca.getNomeServizioApplicativoTokenRiferitoApplicabilitaTrasformazione() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNomeServizioApplicativoTokenRiferitoApplicabilitaTrasformazione());
                    ++indexStmt;
                }
                if (filtroRicerca.getStato() != null) {
                    this.driver.logDebug("stato stmt.setString(" + filtroRicerca.getStato().getValue() + ")");
                    stm.setString(indexStmt, filtroRicerca.getStato().getValue());
                    ++indexStmt;
                }
                if (porteDelegatePerAzioni) {
                    this.driver.logDebug("nomePortaDelegata stmt.setString(" + filtroRicerca.getNomePortaDelegante() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNomePortaDelegante());
                    ++indexStmt;
                    if (filtroRicerca.getAzione() != null) {
                        this.driver.logDebug("azione stmt.setString(" + filtroRicerca.getAzione() + ")");
                        stm.setString(indexStmt, filtroRicerca.getAzione());
                        ++indexStmt;
                    }
                }
            }
            rs = stm.executeQuery();
            nomiPD = new ArrayList<String>();
            while (rs.next()) {
                nomiPD.add(rs.getString("nome_porta"));
            }
        }
        catch (Exception e) {
            try {
                throw new DriverConfigurazioneException("getAllIdPorteDelegate error", e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        if (nomiPD == null || nomiPD.size() <= 0) {
            if (filtroRicerca != null) {
                throw new DriverConfigurazioneNotFound("PorteDelegate non trovate che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            throw new DriverConfigurazioneNotFound("PorteDelegate non trovate");
        }
        ArrayList<IDPortaDelegata> idsPD = new ArrayList<IDPortaDelegata>();
        for (String nomePortaDelegata : nomiPD) {
            idsPD.add(this.getIDPortaDelegata(nomePortaDelegata));
        }
        return idsPD;
    }

    protected List<PortaDelegata> getPorteDelegateByPolicyGestioneToken(String nome) throws DriverConfigurazioneException {
        ArrayList<PortaDelegata> arrayList;
        String nomeMetodo = "getPorteDelegateByPolicyGestioneToken";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortaDelegata> lista = new ArrayList<PortaDelegata>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("token_policy=?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, nome);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Long id = risultato.getLong("id");
                lista.add(this.getPortaDelegata(id));
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected MappingFruizionePortaDelegata getMappingFruizione(IDServizio idServizio, IDSoggetto idSoggetto, IDPortaDelegata idPortaDelegata) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Connection con = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getMappingFruizione");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getMappingFruizione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        try {
            MappingFruizionePortaDelegata e = DBMappingUtils.getMappingFruizione(idServizio, idSoggetto, idPortaDelegata, con, this.driver.tipoDB);
            return e;
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getMappingFruizione] Exception: " + se.getMessage(), se);
        }
        finally {
            this.driver.closeConnection(con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ProprietaOggetto getProprietaOggetto(IDPortaDelegata idPD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        ProprietaOggetto proprietaOggetto;
        String nomeMetodo = "getProprietaOggetto";
        if (idPD == null || idPD.getNome() == null) {
            throw new DriverConfigurazioneException("[" + nomeMetodo + "] Parametro Non Valido");
        }
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("utente_richiedente");
            sqlQueryObject.addSelectField("data_creazione");
            sqlQueryObject.addSelectField("utente_ultima_modifica");
            sqlQueryObject.addSelectField("data_ultima_modifica");
            sqlQueryObject.addWhereCondition("nome_porta = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, idPD.getNome());
            this.driver.logDebug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idPD.getNome()));
            rs = stm.executeQuery();
            ProprietaOggetto proprieta = null;
            if (!rs.next()) {
                throw new DriverConfigurazioneNotFound("PortaDelegata [" + idPD.getNome() + "] non esistente");
            }
            proprieta = this.utilsDriver.readProprietaOggetto(rs, false);
            proprietaOggetto = proprieta;
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] SqlException: " + se.getMessage(), se);
                catch (Exception se2) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return proprietaOggetto;
    }

    protected void updateProprietaOggetto(IDPortaDelegata idPD, String user) throws DriverConfigurazioneException {
        if (idPD == null || idPD.getNome() == null) {
            throw new DriverConfigurazioneException("Identificativo non fornito");
        }
        this.porteDriver.updateProprietaOggetto(idPD.getNome(), user, "porte_delegate");
    }
}

