/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.ProtocolFactoryReflectionUtils;
import org.openspcoop2.core.config.AccessoConfigurazionePdD;
import org.openspcoop2.core.config.Connettore;
import org.openspcoop2.core.config.Credenziali;
import org.openspcoop2.core.config.InvocazionePorta;
import org.openspcoop2.core.config.InvocazionePortaGestioneErrore;
import org.openspcoop2.core.config.InvocazioneServizio;
import org.openspcoop2.core.config.Openspcoop2;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.Property;
import org.openspcoop2.core.config.RispostaAsincrona;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.Soggetto;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.CredenzialeTipo;
import org.openspcoop2.core.config.constants.InvocazioneServizioTipoAutenticazione;
import org.openspcoop2.core.config.constants.PortaApplicativaAzioneIdentificazione;
import org.openspcoop2.core.config.constants.PortaDelegataAzioneIdentificazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.TipologiaErogazione;
import org.openspcoop2.core.config.constants.TipologiaFruizione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.IDriverConfigurazioneCRUD;
import org.openspcoop2.core.config.driver.IDriverConfigurazioneGet;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.config.driver.xml.DriverConfigurazioneXML;
import org.openspcoop2.core.config.utils.serializer.JaxbDeserializer;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.DBMappingUtils;
import org.openspcoop2.core.mapping.Implementation;
import org.openspcoop2.core.mapping.ImplementationUtils;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.mapping.Subscription;
import org.openspcoop2.core.mapping.SubscriptionUtils;
import org.openspcoop2.core.registry.utils.RegistroServiziUtils;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.message.xml.ValidatoreXSD;
import org.openspcoop2.utils.CopyStream;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.slf4j.Logger;
import org.w3c.dom.Document;

public class XMLDataConverter {
    private IDriverConfigurazioneCRUD gestoreCRUD = null;
    private Openspcoop2 sorgenteConfigurazione;
    private Logger log = null;
    private Logger logDriver = null;
    private String superUser = null;
    private boolean gestioneConfigurazione;
    private String tipoBEDestinazione;
    private AbstractXMLUtils xmlUtils = null;

    public XMLDataConverter(String sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(String sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(String sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(byte[] sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(byte[] sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(byte[] sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(InputStream sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(InputStream sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(InputStream sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(File sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(File sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(File sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(Openspcoop2 sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(Openspcoop2 sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(Openspcoop2 sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, logDriver);
    }

    private void XMLDataConverterSetup(Object sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverConfigurazioneException {
        this.log = log == null ? LoggerWrapperFactory.getLogger(XMLDataConverter.class) : log;
        this.logDriver = logDriver;
        this.gestioneConfigurazione = configurazione;
        if (destinazione == null) {
            throw new DriverConfigurazioneException("GestoreCRUD non definito");
        }
        this.tipoBEDestinazione = destinazione.getTipo();
        this.superUser = superUser;
        try {
            if (sorgente instanceof Openspcoop2) {
                this.sorgenteConfigurazione = (Openspcoop2)sorgente;
            } else if (sorgente instanceof String) {
                this.createSorgente((String)sorgente);
            } else if (sorgente instanceof byte[]) {
                this.createSorgente((byte[])sorgente);
            } else if (sorgente instanceof InputStream) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                InputStream is = (InputStream)sorgente;
                CopyStream.copy((InputStream)is, (OutputStream)bout);
                bout.flush();
                bout.close();
                this.createSorgente(bout.toByteArray());
            } else if (sorgente instanceof File) {
                this.createSorgente(((File)sorgente).getAbsolutePath());
            }
        }
        catch (DriverConfigurazioneException d) {
            throw d;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Creazione sorgente [" + sorgente.getClass().getName() + "] non riuscita: " + e.getMessage(), e);
        }
        try {
            if (CostantiConfigurazione.REGISTRO_DB.equals(destinazione.getTipo())) {
                if (destinazione.getLocation() == null) {
                    throw new Exception("Location (DataSource) non definita");
                }
                if (destinazione.getContext() == null) {
                    throw new Exception("Contesto di localizzazione del datasource non definito in GenericProperties");
                }
                if (destinazione.getTipoDatabase() == null) {
                    throw new Exception("TipoDatabase (DataSource) non definita");
                }
                this.gestoreCRUD = new DriverConfigurazioneDB(destinazione.getLocation(), destinazione.getContext(), this.logDriver, destinazione.getTipoDatabase(), tabellaSoggettiCondivisaPddRegserv);
                if (!((DriverConfigurazioneDB)this.gestoreCRUD).create) {
                    throw new Exception("Configurazione DB non inizializzato");
                }
            } else {
                throw new Exception("Tipo di configurazione CRUD non gestita: " + destinazione.getTipo());
            }
            this.log.info("Inizializzato Configurazione DB");
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Errore durante l'istanziazione del driver di CRUD: " + e.getMessage(), e);
        }
        this.xmlUtils = MessageXMLUtils.DEFAULT;
        try {
            ProtocolFactoryReflectionUtils.initializeProtocolManager(protocolloDefault, this.log);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Errore durante l'istanziazione del driver di CRUD: " + e.getMessage(), e);
        }
    }

    public XMLDataConverter(String sorgente, IDriverConfigurazioneCRUD gestoreCRUD, String tipoDestinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup((Object)sorgente, gestoreCRUD, tipoDestinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(String sorgente, IDriverConfigurazioneCRUD gestoreCRUD, String tipoDestinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup((Object)sorgente, gestoreCRUD, tipoDestinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(String sorgente, IDriverConfigurazioneCRUD gestoreCRUD, String tipoDestinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup((Object)sorgente, gestoreCRUD, tipoDestinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(byte[] sorgente, IDriverConfigurazioneCRUD gestoreCRUD, String tipoDestinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup((Object)sorgente, gestoreCRUD, tipoDestinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(byte[] sorgente, IDriverConfigurazioneCRUD gestoreCRUD, String tipoDestinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup((Object)sorgente, gestoreCRUD, tipoDestinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(byte[] sorgente, IDriverConfigurazioneCRUD gestoreCRUD, String tipoDestinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup((Object)sorgente, gestoreCRUD, tipoDestinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(InputStream sorgente, IDriverConfigurazioneCRUD gestoreCRUD, String tipoDestinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup((Object)sorgente, gestoreCRUD, tipoDestinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(InputStream sorgente, IDriverConfigurazioneCRUD gestoreCRUD, String tipoDestinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup((Object)sorgente, gestoreCRUD, tipoDestinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(InputStream sorgente, IDriverConfigurazioneCRUD gestoreCRUD, String tipoDestinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup((Object)sorgente, gestoreCRUD, tipoDestinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(File sorgente, IDriverConfigurazioneCRUD gestoreCRUD, String tipoDestinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup((Object)sorgente, gestoreCRUD, tipoDestinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(File sorgente, IDriverConfigurazioneCRUD gestoreCRUD, String tipoDestinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup((Object)sorgente, gestoreCRUD, tipoDestinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(File sorgente, IDriverConfigurazioneCRUD gestoreCRUD, String tipoDestinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup((Object)sorgente, gestoreCRUD, tipoDestinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(Openspcoop2 sorgente, IDriverConfigurazioneCRUD gestoreCRUD, String tipoDestinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup((Object)sorgente, gestoreCRUD, tipoDestinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(Openspcoop2 sorgente, IDriverConfigurazioneCRUD gestoreCRUD, String tipoDestinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup((Object)sorgente, gestoreCRUD, tipoDestinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(Openspcoop2 sorgente, IDriverConfigurazioneCRUD gestoreCRUD, String tipoDestinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup((Object)sorgente, gestoreCRUD, tipoDestinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, logDriver);
    }

    private void XMLDataConverterSetup(Object sorgente, IDriverConfigurazioneCRUD gestoreCRUD, String tipoDestinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverConfigurazioneException {
        this.log = log == null ? LoggerWrapperFactory.getLogger(XMLDataConverter.class) : log;
        this.logDriver = logDriver;
        this.gestioneConfigurazione = configurazione;
        if (gestoreCRUD == null) {
            throw new DriverConfigurazioneException("GestoreCRUD non definito");
        }
        this.tipoBEDestinazione = tipoDestinazione;
        this.superUser = superUser;
        try {
            if (sorgente instanceof Openspcoop2) {
                this.sorgenteConfigurazione = (Openspcoop2)sorgente;
            } else if (sorgente instanceof String) {
                this.createSorgente((String)sorgente);
            } else if (sorgente instanceof byte[]) {
                this.createSorgente((byte[])sorgente);
            } else if (sorgente instanceof InputStream) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                InputStream is = (InputStream)sorgente;
                CopyStream.copy((InputStream)is, (OutputStream)bout);
                bout.flush();
                bout.close();
                this.createSorgente(bout.toByteArray());
            } else if (sorgente instanceof File) {
                this.createSorgente(((File)sorgente).getAbsolutePath());
            }
        }
        catch (DriverConfigurazioneException d) {
            throw d;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Creazione sorgente [" + sorgente.getClass().getName() + "] non riuscita: " + e.getMessage(), e);
        }
        this.gestoreCRUD = gestoreCRUD;
        this.xmlUtils = MessageXMLUtils.DEFAULT;
        try {
            ProtocolFactoryReflectionUtils.initializeProtocolManager(protocolloDefault, this.log);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Errore durante l'istanziazione del driver di CRUD: " + e.getMessage(), e);
        }
    }

    public XMLDataConverter(String sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup((Object)sorgente, connection, tipoDatabase, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(String sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup((Object)sorgente, connection, tipoDatabase, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(String sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup((Object)sorgente, connection, tipoDatabase, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(byte[] sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup((Object)sorgente, connection, tipoDatabase, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(byte[] sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup((Object)sorgente, connection, tipoDatabase, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(byte[] sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup((Object)sorgente, connection, tipoDatabase, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(InputStream sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup((Object)sorgente, connection, tipoDatabase, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(InputStream sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup((Object)sorgente, connection, tipoDatabase, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(InputStream sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup((Object)sorgente, connection, tipoDatabase, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(File sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup((Object)sorgente, connection, tipoDatabase, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(File sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup((Object)sorgente, connection, tipoDatabase, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(File sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup((Object)sorgente, connection, tipoDatabase, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(Openspcoop2 sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup((Object)sorgente, connection, tipoDatabase, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(Openspcoop2 sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup((Object)sorgente, connection, tipoDatabase, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(Openspcoop2 sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup((Object)sorgente, connection, tipoDatabase, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, logDriver);
    }

    private void XMLDataConverterSetup(Object sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverConfigurazioneException {
        this.log = log == null ? LoggerWrapperFactory.getLogger(XMLDataConverter.class) : log;
        this.logDriver = logDriver;
        this.gestioneConfigurazione = configurazione;
        this.tipoBEDestinazione = CostantiConfigurazione.REGISTRO_DB.toString();
        this.superUser = superUser;
        try {
            if (sorgente instanceof Openspcoop2) {
                this.sorgenteConfigurazione = (Openspcoop2)sorgente;
            } else if (sorgente instanceof String) {
                this.createSorgente((String)sorgente);
            } else if (sorgente instanceof byte[]) {
                this.createSorgente((byte[])sorgente);
            } else if (sorgente instanceof InputStream) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                InputStream is = (InputStream)sorgente;
                CopyStream.copy((InputStream)is, (OutputStream)bout);
                bout.flush();
                bout.close();
                this.createSorgente(bout.toByteArray());
            } else if (sorgente instanceof File) {
                this.createSorgente(((File)sorgente).getAbsolutePath());
            }
        }
        catch (DriverConfigurazioneException d) {
            throw d;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Creazione sorgente [" + sorgente.getClass().getName() + "] non riuscita: " + e.getMessage(), e);
        }
        try {
            this.gestoreCRUD = new DriverConfigurazioneDB(connection, this.logDriver, tipoDatabase, tabellaSoggettiCondivisaPddRegserv);
            if (!((DriverConfigurazioneDB)this.gestoreCRUD).create) {
                throw new Exception("Configurazione DB non inizializzato");
            }
            this.log.info("Inizializzato Configurazione DB");
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Errore durante l'istanziazione del driver di CRUD: " + e.getMessage(), e);
        }
        this.xmlUtils = MessageXMLUtils.DEFAULT;
        try {
            ProtocolFactoryReflectionUtils.initializeProtocolManager(protocolloDefault, this.log);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Errore durante l'istanziazione del driver di CRUD: " + e.getMessage(), e);
        }
    }

    private static Implementation getImplementationDefault(org.openspcoop2.core.registry.constants.ServiceBinding serviceBinding, IDServizio idServizio) throws DriverConfigurazioneException {
        try {
            Class<?> cProtocolFactoryManager = Class.forName("org.openspcoop2.protocol.engine.ProtocolFactoryManager");
            Object protocolFactoryManager = cProtocolFactoryManager.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            String protocollo = (String)cProtocolFactoryManager.getMethod("getProtocolByOrganizationType", String.class).invoke(protocolFactoryManager, idServizio.getSoggettoErogatore().getTipo());
            Class<?> cProtocolFactory = Class.forName("org.openspcoop2.protocol.sdk.IProtocolFactory");
            Object protocolFactory = cProtocolFactoryManager.getMethod("getProtocolFactoryByName", String.class).invoke(protocolFactoryManager, protocollo);
            Class<?> cProtocolIntegrationConfiguration = Class.forName("org.openspcoop2.protocol.sdk.config.IProtocolIntegrationConfiguration");
            Object protocolIntegrationConfiguration = cProtocolFactory.getMethod("createProtocolIntegrationConfiguration", new Class[0]).invoke(protocolFactory, new Object[0]);
            ServiceBinding serviceBindingMessage = RegistroServiziUtils.convertToMessage(serviceBinding);
            return (Implementation)cProtocolIntegrationConfiguration.getMethod("createDefaultImplementation", ServiceBinding.class, IDServizio.class).invoke(protocolIntegrationConfiguration, serviceBindingMessage, idServizio);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Errore durante l'utilizzo della protocolFactory (getImplementationDefault): " + e.getMessage(), e);
        }
    }

    private static Subscription getSubscriptionDefault(org.openspcoop2.core.registry.constants.ServiceBinding serviceBinding, IDSoggetto idFruitore, IDServizio idServizio) throws DriverConfigurazioneException {
        try {
            Class<?> cProtocolFactoryManager = Class.forName("org.openspcoop2.protocol.engine.ProtocolFactoryManager");
            Object protocolFactoryManager = cProtocolFactoryManager.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            String protocollo = (String)cProtocolFactoryManager.getMethod("getProtocolByOrganizationType", String.class).invoke(protocolFactoryManager, idServizio.getSoggettoErogatore().getTipo());
            Class<?> cProtocolFactory = Class.forName("org.openspcoop2.protocol.sdk.IProtocolFactory");
            Object protocolFactory = cProtocolFactoryManager.getMethod("getProtocolFactoryByName", String.class).invoke(protocolFactoryManager, protocollo);
            Class<?> cProtocolIntegrationConfiguration = Class.forName("org.openspcoop2.protocol.sdk.config.IProtocolIntegrationConfiguration");
            Object protocolIntegrationConfiguration = cProtocolFactory.getMethod("createProtocolIntegrationConfiguration", new Class[0]).invoke(protocolFactory, new Object[0]);
            ServiceBinding serviceBindingMessage = RegistroServiziUtils.convertToMessage(serviceBinding);
            return (Subscription)cProtocolIntegrationConfiguration.getMethod("createDefaultSubscription", ServiceBinding.class, IDSoggetto.class, IDServizio.class).invoke(protocolIntegrationConfiguration, serviceBindingMessage, idFruitore, idServizio);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Errore durante l'utilizzo della protocolFactory (getSubscriptionDefault): " + e.getMessage(), e);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createSorgente(String sorgente) throws DriverConfigurazioneException {
        if (sorgente == null) {
            throw new DriverConfigurazioneException("Sorgente non definita");
        }
        validatoreRegistro = null;
        try {
            validatoreRegistro = new ValidatoreXSD(OpenSPCoop2MessageFactory.getDefaultMessageFactory(), this.log, DriverConfigurazioneXML.class.getResourceAsStream("/config.xsd"));
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Riscontrato errore durante l'inizializzazione dello schema della Configurazione XML di OpenSPCoop: " + e.getMessage());
        }
        fXML = null;
        try {
            if (sorgente.startsWith("http://") || sorgente.startsWith("file://")) {
                validatoreRegistro.valida(sorgente);
            } else {
                fXML = new FileInputStream(sorgente);
                validatoreRegistro.valida((InputStream)fXML);
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Riscontrato errore durante la validazione XSD del Configurazione XML di OpenSPCoop: " + e.getMessage());
        }
        finally {
            if (fXML != null) {
                try {
                    fXML.close();
                }
                catch (Exception var6_11) {}
            }
        }
        try {
            iStream = null;
            httpConn = null;
            if (sorgente.startsWith("http://") || sorgente.startsWith("file://")) {
                try {
                    url = new URL(sorgente);
                    connection = url.openConnection();
                    httpConn = (HttpURLConnection)connection;
                    httpConn.setRequestMethod("GET");
                    httpConn.setDoOutput(true);
                    httpConn.setDoInput(true);
                    iStream = httpConn.getInputStream();
                    if (sorgente.startsWith("http://")) ** GOTO lbl56
                }
                catch (Exception e) {
                    try {
                        if (iStream != null) {
                            iStream.close();
                        }
                        if (httpConn == null) throw new DriverConfigurazioneException("Riscontrato errore durante la creazione dell'inputStream del Configurazione (HTTP) : \n\n" + e.getMessage());
                        httpConn.disconnect();
                        throw new DriverConfigurazioneException("Riscontrato errore durante la creazione dell'inputStream del Configurazione (HTTP) : \n\n" + e.getMessage());
                    }
                    catch (Exception var7_18) {
                        // empty catch block
                    }
                    throw new DriverConfigurazioneException("Riscontrato errore durante la creazione dell'inputStream del Configurazione (HTTP) : \n\n" + e.getMessage());
                }
            } else {
                try {
                    iStream = new FileInputStream(sorgente);
                }
                catch (FileNotFoundException e) {
                    throw new DriverConfigurazioneException("Riscontrato errore durante la creazione dell'inputStream del Configurazione (FILE) : \n\n" + e.getMessage());
                }
            }
lbl56:
            // 3 sources

            try {
                deserializer = new JaxbDeserializer();
                this.sorgenteConfigurazione = deserializer.readOpenspcoop2(this.readBytes(iStream));
            }
            catch (Exception e) {
                try {
                    if (iStream != null) {
                        iStream.close();
                    }
                    if (httpConn == null) throw new DriverConfigurazioneException("Riscontrato errore durante l'unmarshall del file di configurazione: " + e.getMessage());
                    httpConn.disconnect();
                    throw new DriverConfigurazioneException("Riscontrato errore durante l'unmarshall del file di configurazione: " + e.getMessage());
                }
                catch (Exception var7_19) {
                    // empty catch block
                }
                throw new DriverConfigurazioneException("Riscontrato errore durante l'unmarshall del file di configurazione: " + e.getMessage());
            }
            try {
                if (iStream != null) {
                    iStream.close();
                }
                if (httpConn == null) return;
                httpConn.disconnect();
                return;
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("Riscontrato errore durante la chiusura dell'Input Stream: " + e.getMessage());
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Riscontrato errore durante l'istanziazione del registro: " + e.getMessage(), e);
        }
    }

    private InputStream readBytes(InputStream is) throws Exception {
        this.xmlUtils = MessageXMLUtils.DEFAULT;
        byte[] b = new byte[]{};
        try {
            Document d = this.xmlUtils.newDocument(is);
            String xml = this.xmlUtils.toString(d, true);
            xml = Utilities.eraserXmlAttribute((String)xml, (String)"xml:base=");
            b = xml.getBytes();
            return new ByteArrayInputStream(b);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    private void createSorgente(byte[] sorgente) throws DriverConfigurazioneException {
        if (sorgente == null) {
            throw new DriverConfigurazioneException("Sorgente non definita");
        }
        ValidatoreXSD validatoreRegistro = null;
        try {
            validatoreRegistro = new ValidatoreXSD(OpenSPCoop2MessageFactory.getDefaultMessageFactory(), this.log, DriverConfigurazioneXML.class.getResourceAsStream("/config.xsd"));
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Riscontrato errore durante l'inizializzazione dello schema della Configurazione XML di OpenSPCoop: " + e.getMessage());
        }
        try {
            validatoreRegistro.valida((InputStream)new ByteArrayInputStream(sorgente));
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Riscontrato errore durante la validazione XSD del Configurazione XML di OpenSPCoop: " + e.getMessage());
        }
        ByteArrayInputStream iStream = null;
        try {
            try {
                iStream = new ByteArrayInputStream(sorgente);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("Riscontrato errore durante la creazione dell'inputStreamReader della Configurazione : \n\n" + e.getMessage());
            }
            try {
                JaxbDeserializer deserializer = new JaxbDeserializer();
                this.sorgenteConfigurazione = deserializer.readOpenspcoop2(this.readBytes(iStream));
            }
            catch (Exception e) {
                try {
                    if (iStream != null) {
                        ((InputStream)iStream).close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new DriverConfigurazioneException("Riscontrato errore durante l'unmarshall del file di configurazione: " + e.getMessage());
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Riscontrato errore durante l'istanziazione del registro: " + e.getMessage(), e);
        }
        finally {
            try {
                if (iStream != null) {
                    ((InputStream)iStream).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private IDServizio toIdServizio(PortaDelegata pd) {
        IDServizio idServizio = new IDServizio();
        idServizio.setTipo(pd.getServizio().getTipo());
        idServizio.setNome(pd.getServizio().getNome());
        idServizio.setVersione(pd.getServizio().getVersione());
        idServizio.setSoggettoErogatore(new IDSoggetto(pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome()));
        return idServizio;
    }

    private IDServizio toIdServizio(PortaApplicativa pa) {
        IDServizio idServizio = new IDServizio();
        idServizio.setTipo(pa.getServizio().getTipo());
        idServizio.setNome(pa.getServizio().getNome());
        idServizio.setVersione(pa.getServizio().getVersione());
        idServizio.setSoggettoErogatore(new IDSoggetto(pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario()));
        return idServizio;
    }

    public void convertXML(boolean reset, boolean aggiornamentoSoggetti, boolean createMappingErogazioneFruizione) throws DriverConfigurazioneException {
        this.convertXML(reset, aggiornamentoSoggetti, createMappingErogazioneFruizione, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertXML(boolean reset, boolean aggiornamentoSoggetti, boolean createMappingErogazioneFruizione, boolean updateEnabled) throws DriverConfigurazioneException {
        Connection con;
        Connection con2;
        DriverConfigurazioneDB driver;
        Soggetto soggetto;
        int i;
        if (reset) {
            try {
                this.log.info("Configurazione, reset in corso (Reset configurazione:" + this.gestioneConfigurazione + ")...");
                this.gestoreCRUD.reset(this.gestioneConfigurazione);
                this.log.info("Configurazione, reset effettuato.");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new DriverConfigurazioneException("Reset del Configurazione non riuscita: " + e.getMessage(), e);
            }
        }
        try {
            for (i = 0; i < this.sorgenteConfigurazione.sizeSoggettoList(); ++i) {
                soggetto = this.sorgenteConfigurazione.getSoggetto(i);
                soggetto.setSuperUser(this.superUser);
                IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
                if (!reset && this.gestoreCRUD.existsSoggetto(idSoggetto)) {
                    if (!aggiornamentoSoggetti) continue;
                    if (updateEnabled) {
                        this.log.info("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornamento in corso...");
                        this.gestoreCRUD.updateSoggetto(soggetto);
                        this.log.info("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornato.");
                        continue;
                    }
                    this.log.info("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " non aggiornato (aggiornamento disabilitato).");
                    continue;
                }
                this.log.info("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " creazione in corso...");
                this.gestoreCRUD.createSoggetto(soggetto);
                this.log.info("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " creato.");
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new DriverConfigurazioneException("Errore durante la conversione XML dei soggetti: " + e.getMessage(), e);
        }
        try {
            for (i = 0; i < this.sorgenteConfigurazione.sizeSoggettoList(); ++i) {
                soggetto = this.sorgenteConfigurazione.getSoggetto(i);
                for (int j = 0; j < soggetto.sizeServizioApplicativoList(); ++j) {
                    ServizioApplicativo servizioApplicativo = soggetto.getServizioApplicativo(j);
                    this.addServizioApplicativo(servizioApplicativo, soggetto, null, reset, updateEnabled);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new DriverConfigurazioneException("Errore durante la conversione XML dei servizi applicativi: " + e.getMessage(), e);
        }
        try {
            for (i = 0; i < this.sorgenteConfigurazione.sizeSoggettoList(); ++i) {
                IDServizio idServizio;
                IDSoggetto idFruitore;
                soggetto = this.sorgenteConfigurazione.getSoggetto(i);
                HashMap<Object, PortaDelegata> listPDModificare = new HashMap<Object, PortaDelegata>();
                for (int j = 0; j < soggetto.sizePortaDelegataList(); ++j) {
                    PortaDelegata pd = soggetto.getPortaDelegata(j);
                    pd.setTipoSoggettoProprietario(soggetto.getTipo());
                    pd.setNomeSoggettoProprietario(soggetto.getNome());
                    XMLDataConverter.impostaInformazioniConfigurazione_PortaDelegata(pd);
                    IDPortaDelegata idPD = new IDPortaDelegata();
                    idPD.setNome(pd.getNome());
                    if (!reset && this.gestoreCRUD.existsPortaDelegata(idPD)) {
                        if (updateEnabled) {
                            this.log.info("Porta delegata [" + pd.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornamento in corso...");
                            this.gestoreCRUD.updatePortaDelegata(pd);
                            this.log.info("Porta delegata [" + pd.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornato.");
                        } else {
                            this.log.info("Porta delegata [" + pd.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " non aggiornato (aggiornamento disabilitato).");
                        }
                    } else {
                        this.log.info("Porta delegata [" + pd.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " creazione in corso...");
                        this.gestoreCRUD.createPortaDelegata(pd);
                        this.log.info("Porta delegata [" + pd.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " creato.");
                    }
                    if (!createMappingErogazioneFruizione || !(this.gestoreCRUD instanceof DriverConfigurazioneDB)) continue;
                    driver = (DriverConfigurazioneDB)this.gestoreCRUD;
                    con2 = null;
                    try {
                        con2 = driver.getConnection("XMLDataConverter.mappingFruizione");
                        idFruitore = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
                        idServizio = this.toIdServizio(pd);
                        boolean existsMapping = DBMappingUtils.existsMappingFruizione(idServizio, idFruitore, idPD, con2, driver.getTipoDB());
                        if (existsMapping) continue;
                        boolean isDefault = false;
                        String nomeMapping = null;
                        boolean create = false;
                        if (SubscriptionUtils.isPortaDelegataUtilizzabileComeDefault(pd)) {
                            nomeMapping = SubscriptionUtils.getDefaultMappingName();
                            isDefault = true;
                            if (!DBMappingUtils.existsIDPortaDelegataAssociataDefault(idServizio, idFruitore, con2, driver.getTipoDB())) {
                                create = true;
                            }
                        } else if (PortaDelegataAzioneIdentificazione.DELEGATED_BY.equals(pd.getAzione().getIdentificazione())) {
                            if (pd.getAzione().sizeAzioneDelegataList() <= 0) {
                                this.log.error("Trovata porta delegata " + pd.getNome() + "] con un'identificazione dell'azione delegata senza pero' possedere azioni delegate");
                                create = false;
                            } else {
                                String nomeAzione;
                                nomeMapping = nomeAzione = pd.getAzione().getAzioneDelegata(0);
                                idServizio.setAzione(nomeAzione);
                                if (!DBMappingUtils.existsIDPortaDelegataAssociataAzione(idServizio, idFruitore, con2, driver.getTipoDB())) {
                                    create = true;
                                }
                            }
                        } else {
                            nomeMapping = pd.getAzione().getNome();
                            if (nomeMapping != null && !"".equals(nomeMapping)) {
                                idServizio.setAzione(pd.getAzione().getNome());
                                if (!DBMappingUtils.existsIDPortaDelegataAssociataAzione(idServizio, idFruitore, con2, driver.getTipoDB())) {
                                    create = true;
                                    SubscriptionUtils.setAzioneDelegate(pd, null, pd.getAzione().getNome());
                                    listPDModificare.put(idPD, pd);
                                }
                            }
                        }
                        if (!create) continue;
                        this.log.info("Creazione mapping di fruizione (nome:" + nomeMapping + " default:" + isDefault + ") tra Porta delegata [" + pd.getNome() + "], fruitore [" + idFruitore + "] e servizio [" + idServizio + "] creazione in corso...");
                        DBMappingUtils.createMappingFruizione(nomeMapping, isDefault ? "Predefinito" : nomeMapping, isDefault, idServizio, idFruitore, idPD, con2, driver.getTipoDB());
                        this.log.info("Creazione mapping di fruizione (nome:" + nomeMapping + " default:" + isDefault + ") tra Porta delegata [" + pd.getNome() + "], fruitore [" + idFruitore + "] e servizio [" + idServizio + "] creato.");
                        continue;
                    }
                    finally {
                        driver.releaseConnection(con2);
                    }
                }
                if (listPDModificare == null || listPDModificare.size() <= 0) continue;
                DriverConfigurazioneDB driver2 = (DriverConfigurazioneDB)this.gestoreCRUD;
                con = null;
                try {
                    con = driver2.getConnection("XMLDataConverter.mappingFruizione");
                    for (IDPortaDelegata idPD : listPDModificare.keySet()) {
                        PortaDelegata pd = (PortaDelegata)listPDModificare.get(idPD);
                        idFruitore = new IDSoggetto(pd.getTipoSoggettoProprietario(), pd.getNomeSoggettoProprietario());
                        idServizio = this.toIdServizio(pd);
                        IDPortaDelegata idPDDefault = DBMappingUtils.getIDPortaDelegataAssociataDefault(idServizio, idFruitore, con, driver2.getTipoDB());
                        if (idPDDefault == null) {
                            org.openspcoop2.core.registry.constants.ServiceBinding serviceBinding = this.readServiceBinding(idServizio, con);
                            Subscription subcription = XMLDataConverter.getSubscriptionDefault(serviceBinding, idFruitore, idServizio);
                            PortaDelegata pdDefault = subcription.getPortaDelegata();
                            MappingFruizionePortaDelegata mapping = subcription.getMapping();
                            idPDDefault = mapping.getIdPortaDelegata();
                            if (!this.gestoreCRUD.existsPortaDelegata(idPDDefault)) {
                                this.log.info("Porta delegata [" + pd.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " creazione delegante [" + pdDefault.getNome() + "] in corso...");
                                this.gestoreCRUD.createPortaDelegata(pdDefault);
                                this.log.info("Porta delegata [" + pd.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " creazione delegante [" + pdDefault.getNome() + "].");
                            }
                            this.log.info("Creazione mapping di fruizione di default (nome:" + mapping.getNome() + " default:" + mapping.isDefault() + ") tra Porta delegata [" + pdDefault.getNome() + "], fruitore [" + idFruitore + "] e servizio [" + idServizio + "] creazione delegante in corso...");
                            DBMappingUtils.createMappingFruizione(mapping.getNome(), mapping.getDescrizione(), mapping.isDefault(), idServizio, idFruitore, idPDDefault, con, driver2.getTipoDB());
                            this.log.info("Creazione mapping di fruizione di default (nome:" + mapping.getNome() + " default:" + mapping.isDefault() + ") tra Porta delegata [" + pdDefault.getNome() + "], fruitore [" + idFruitore + "] e servizio [" + idServizio + "] creato delegante.");
                        }
                        pd.getAzione().setNomePortaDelegante(idPDDefault.getNome());
                        this.log.info("Porta delegata [" + pd.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornamento per nomeDelegante in corso...");
                        this.gestoreCRUD.updatePortaDelegata(pd);
                        this.log.info("Porta delegata [" + pd.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornato per nomeDelegante.");
                    }
                    continue;
                }
                finally {
                    driver2.releaseConnection(con);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new DriverConfigurazioneException("Errore durante la conversione XML delle porte delegate: " + e.getMessage(), e);
        }
        try {
            for (i = 0; i < this.sorgenteConfigurazione.sizeSoggettoList(); ++i) {
                Object nomeAzione;
                IDServizio idServizio;
                soggetto = this.sorgenteConfigurazione.getSoggetto(i);
                HashMap<IDPortaApplicativa, PortaApplicativa> listPAModificare = new HashMap<IDPortaApplicativa, PortaApplicativa>();
                for (int j = 0; j < soggetto.sizePortaApplicativaList(); ++j) {
                    PortaApplicativa pa = soggetto.getPortaApplicativa(j);
                    pa.setTipoSoggettoProprietario(soggetto.getTipo());
                    pa.setNomeSoggettoProprietario(soggetto.getNome());
                    XMLDataConverter.impostaInformazioniConfigurazione_PortaApplicativa(pa);
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    idPA.setNome(pa.getNome());
                    if (!reset && this.gestoreCRUD.existsPortaApplicativa(idPA)) {
                        if (updateEnabled) {
                            this.log.info("Porta applicativa [" + pa.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornamento in corso...");
                            this.gestoreCRUD.updatePortaApplicativa(pa);
                            this.log.info("Porta applicativa [" + pa.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornato.");
                        } else {
                            this.log.info("Porta applicativa [" + pa.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " non aggiornato (aggiornamento disabilitato).");
                        }
                    } else {
                        this.log.info("Porta applicativa [" + pa.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " creazione in corso...");
                        this.gestoreCRUD.createPortaApplicativa(pa);
                        this.log.info("Porta applicativa [" + pa.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " creato.");
                    }
                    if (!createMappingErogazioneFruizione || !(this.gestoreCRUD instanceof DriverConfigurazioneDB)) continue;
                    driver = (DriverConfigurazioneDB)this.gestoreCRUD;
                    con2 = null;
                    try {
                        con2 = driver.getConnection("XMLDataConverter.mappingErogazione");
                        idServizio = this.toIdServizio(pa);
                        boolean existsMapping = DBMappingUtils.existsMappingErogazione(idServizio, idPA, con2, driver.getTipoDB());
                        if (existsMapping) continue;
                        boolean isDefault = false;
                        Object nomeMapping = null;
                        boolean create = false;
                        if (ImplementationUtils.isPortaApplicativaUtilizzabileComeDefault(pa)) {
                            nomeMapping = ImplementationUtils.getDefaultMappingName();
                            isDefault = true;
                            if (!DBMappingUtils.existsIDPortaApplicativaAssociataDefault(idServizio, con2, driver.getTipoDB())) {
                                create = true;
                            }
                        } else if (PortaApplicativaAzioneIdentificazione.DELEGATED_BY.equals(pa.getAzione().getIdentificazione())) {
                            if (pa.getAzione().sizeAzioneDelegataList() <= 0) {
                                this.log.error("Trovata porta applicativa " + pa.getNome() + "] con un'identificazione dell'azione delegata senza pero' possedere azioni delegate");
                                create = false;
                            } else {
                                nomeMapping = nomeAzione = pa.getAzione().getAzioneDelegata(0);
                                idServizio.setAzione((String)nomeAzione);
                                if (!DBMappingUtils.existsIDPortaApplicativaAssociataAzione(idServizio, con2, driver.getTipoDB())) {
                                    create = true;
                                }
                            }
                        } else {
                            nomeMapping = pa.getAzione().getNome();
                            if (nomeMapping != null && !"".equals(nomeMapping)) {
                                idServizio.setAzione(pa.getAzione().getNome());
                                if (!DBMappingUtils.existsIDPortaApplicativaAssociataAzione(idServizio, con2, driver.getTipoDB())) {
                                    create = true;
                                    ImplementationUtils.setAzioneDelegate(pa, null, pa.getAzione().getNome());
                                    listPAModificare.put(idPA, pa);
                                }
                            }
                        }
                        if (!create) continue;
                        this.log.info("Creazione mapping di erogazione (nome:" + (String)nomeMapping + " default:" + isDefault + ") tra Porta Applicativa [" + pa.getNome() + "] e servizio [" + idServizio + "] creazione in corso...");
                        DBMappingUtils.createMappingErogazione((String)nomeMapping, (String)(isDefault ? "Predefinito" : nomeMapping), isDefault, idServizio, idPA, con2, driver.getTipoDB());
                        this.log.info("Creazione mapping di erogazione (nome:" + (String)nomeMapping + " default:" + isDefault + ") tra Porta Applicativa [" + pa.getNome() + "] e servizio [" + idServizio + "] creato.");
                        continue;
                    }
                    finally {
                        driver.releaseConnection(con2);
                    }
                }
                if (listPAModificare == null || listPAModificare.size() <= 0) continue;
                DriverConfigurazioneDB driver3 = (DriverConfigurazioneDB)this.gestoreCRUD;
                con = null;
                try {
                    con = driver3.getConnection("XMLDataConverter.mappingErogazione");
                    for (IDPortaApplicativa idPA : listPAModificare.keySet()) {
                        PortaApplicativa pa = (PortaApplicativa)listPAModificare.get(idPA);
                        idServizio = this.toIdServizio(pa);
                        IDPortaApplicativa idPADefault = DBMappingUtils.getIDPortaApplicativaAssociataDefault(idServizio, con, driver3.getTipoDB());
                        if (idPADefault == null) {
                            MappingErogazionePortaApplicativa mapping;
                            org.openspcoop2.core.registry.constants.ServiceBinding serviceBinding = this.readServiceBinding(idServizio, con);
                            Implementation implementation = XMLDataConverter.getImplementationDefault(serviceBinding, idServizio);
                            PortaApplicativa paDefault = implementation.getPortaApplicativa();
                            if (pa.sizeServizioApplicativoList() > 0) {
                                nomeAzione = pa.getServizioApplicativoList().iterator();
                                while (nomeAzione.hasNext()) {
                                    PortaApplicativaServizioApplicativo paSA = nomeAzione.next();
                                    paDefault.addServizioApplicativo(paSA);
                                }
                            }
                            if (!this.gestoreCRUD.existsPortaApplicativa(idPADefault = (mapping = implementation.getMapping()).getIdPortaApplicativa())) {
                                this.log.info("Porta applicativa [" + pa.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " creazione delegante [" + paDefault.getNome() + "] in corso...");
                                this.gestoreCRUD.createPortaApplicativa(paDefault);
                                this.log.info("Porta applicativa [" + pa.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " creazione delegante [" + paDefault.getNome() + "].");
                            }
                            this.log.info("Creazione mapping di erogazione di default (nome:" + mapping.getNome() + " default:" + mapping.isDefault() + ") tra Porta Applicativa [" + paDefault.getNome() + "] e servizio [" + idServizio + "] creazione delegante in corso...");
                            DBMappingUtils.createMappingErogazione(mapping.getNome(), mapping.getDescrizione(), mapping.isDefault(), idServizio, idPADefault, con, driver3.getTipoDB());
                            this.log.info("Creazione mapping di erogazione di default (nome:" + mapping.getNome() + " default:" + mapping.isDefault() + ") tra Porta Applicativa [" + paDefault.getNome() + "] e servizio [" + idServizio + "] creato delegante.");
                        }
                        pa.getAzione().setNomePortaDelegante(idPADefault.getNome());
                        this.log.info("Porta applicativa [" + pa.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornamento per nomeDelegante in corso...");
                        this.gestoreCRUD.updatePortaApplicativa(pa);
                        this.log.info("Porta applicativa [" + pa.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornato per nomeDelegante.");
                    }
                    continue;
                }
                finally {
                    driver3.releaseConnection(con);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new DriverConfigurazioneException("Errore durante la conversione XML delle porte applicative: " + e.getMessage(), e);
        }
        if (this.gestioneConfigurazione) {
            try {
                this.log.info("Routing Table, creazione/aggiornamento in corso...");
                if (this.sorgenteConfigurazione.getConfigurazione() != null && this.sorgenteConfigurazione.getConfigurazione().getRoutingTable() != null) {
                    if (reset) {
                        this.gestoreCRUD.createRoutingTable(this.sorgenteConfigurazione.getConfigurazione().getRoutingTable());
                        this.log.info("Routing Table, creazione effettuata.");
                    } else if (updateEnabled) {
                        this.gestoreCRUD.updateRoutingTable(this.sorgenteConfigurazione.getConfigurazione().getRoutingTable());
                        this.log.info("Routing Table, aggiornamento effettuato.");
                    } else {
                        this.log.info("Routing Table, non aggiornato (aggiornamento disabilitato).");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new DriverConfigurazioneException("Errore durante la conversione XML della routing table: " + e.getMessage(), e);
            }
            try {
                this.log.info("Accesso registro, creazione in corso...");
                if (this.sorgenteConfigurazione.getConfigurazione() != null && this.sorgenteConfigurazione.getConfigurazione().getAccessoRegistro() != null) {
                    if (reset) {
                        this.gestoreCRUD.createAccessoRegistro(this.sorgenteConfigurazione.getConfigurazione().getAccessoRegistro());
                        this.log.info("Accesso registro, creazione effettuata.");
                    } else if (updateEnabled) {
                        this.gestoreCRUD.updateAccessoRegistro(this.sorgenteConfigurazione.getConfigurazione().getAccessoRegistro());
                        this.log.info("Accesso registro, aggiornamento effettuato.");
                    } else {
                        this.log.info("Accesso registro, non aggiornato (aggiornamento disabilitato).");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new DriverConfigurazioneException("Errore durante la conversione XML dei dati di accesso al registro: " + e.getMessage(), e);
            }
            try {
                this.log.info("GestioneErrore, creazione in corso...");
                if (this.sorgenteConfigurazione.getConfigurazione() != null && this.sorgenteConfigurazione.getConfigurazione().getGestioneErrore() != null && this.sorgenteConfigurazione.getConfigurazione().getGestioneErrore().getComponenteCooperazione() != null) {
                    if (reset) {
                        this.gestoreCRUD.createGestioneErroreComponenteCooperazione(this.sorgenteConfigurazione.getConfigurazione().getGestioneErrore().getComponenteCooperazione());
                        this.log.info("GestioneErrore, creazione effettuata.");
                    } else if (updateEnabled) {
                        this.gestoreCRUD.updateGestioneErroreComponenteCooperazione(this.sorgenteConfigurazione.getConfigurazione().getGestioneErrore().getComponenteCooperazione());
                        this.log.info("GestioneErrore, aggiornamento effettuato.");
                    } else {
                        this.log.info("GestioneErrore, non aggiornato (aggiornamento disabilitato).");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new DriverConfigurazioneException("Errore durante la conversione XML dei dati di gestione dell'errore del connettore per il componente di cooperazione: " + e.getMessage(), e);
            }
            try {
                this.log.info("GestioneErrore, creazione in corso...");
                if (this.sorgenteConfigurazione.getConfigurazione() != null && this.sorgenteConfigurazione.getConfigurazione().getGestioneErrore() != null && this.sorgenteConfigurazione.getConfigurazione().getGestioneErrore().getComponenteIntegrazione() != null) {
                    if (reset) {
                        this.gestoreCRUD.createGestioneErroreComponenteIntegrazione(this.sorgenteConfigurazione.getConfigurazione().getGestioneErrore().getComponenteIntegrazione());
                        this.log.info("GestioneErrore, creazione effettuata.");
                    } else if (updateEnabled) {
                        this.gestoreCRUD.updateGestioneErroreComponenteIntegrazione(this.sorgenteConfigurazione.getConfigurazione().getGestioneErrore().getComponenteIntegrazione());
                        this.log.info("GestioneErrore, aggiornamento effettuato.");
                    } else {
                        this.log.info("GestioneErrore, non aggiornato (aggiornamento disabilitato).");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new DriverConfigurazioneException("Errore durante la conversione XML dei dati di gestione dell'errore del connettore per il componente di integrazione: " + e.getMessage(), e);
            }
            try {
                this.log.info("Configurazione, creazione in corso...");
                if (this.sorgenteConfigurazione.getConfigurazione() != null) {
                    if (reset) {
                        this.gestoreCRUD.createConfigurazione(this.sorgenteConfigurazione.getConfigurazione());
                        this.log.info("Configurazione, creazione effettuata.");
                    } else if (updateEnabled) {
                        this.gestoreCRUD.updateConfigurazione(this.sorgenteConfigurazione.getConfigurazione());
                        this.log.info("Configurazione, aggiornamento effettuato.");
                    } else {
                        this.log.info("Configurazione, non aggiornato (aggiornamento disabilitato).");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new DriverConfigurazioneException("Errore durante la conversione XML della Configurazione: " + e.getMessage(), e);
            }
        }
    }

    private org.openspcoop2.core.registry.constants.ServiceBinding readServiceBinding(IDServizio idServizio, Connection con) throws DriverConfigurazioneException {
        DriverConfigurazioneDB driver = (DriverConfigurazioneDB)this.gestoreCRUD;
        long idServizioAsLong = -1L;
        try {
            idServizioAsLong = DBUtils.getIdAccordoServizioParteSpecifica(idServizio, con, driver.getTipoDB());
            if (idServizioAsLong <= 0L) {
                throw new Exception("Non trovato");
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Accordo Parte Specifica non trovato [" + idServizio + "]");
        }
        Statement stm = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)driver.getTipoDB());
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectField("service_binding");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("servizi.id_accordo = accordi.id");
            sqlQueryObject.addWhereCondition("servizi.id = ?");
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setLong(1, idServizioAsLong);
            rs = stm.executeQuery();
            if (rs.next()) {
                org.openspcoop2.core.registry.constants.ServiceBinding serviceBinding = org.openspcoop2.core.registry.constants.ServiceBinding.toEnumConstant(rs.getString("service_binding"), true);
                return serviceBinding;
            }
            try {
                throw new DriverConfigurazioneException("Accordo Parte Specifica non trovato [" + idServizio + "] (Lettura ServiceBinding)");
            }
            catch (SQLException e) {
                throw new DriverConfigurazioneException(e);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(boolean deleteSoggetti, boolean deleteMappingErogazioneFruizione) throws DriverConfigurazioneException {
        Connection con;
        DriverConfigurazioneDB driver;
        int j;
        Soggetto soggetto;
        int i;
        try {
            for (i = 0; i < this.sorgenteConfigurazione.sizeSoggettoList(); ++i) {
                soggetto = this.sorgenteConfigurazione.getSoggetto(i);
                for (j = 0; j < soggetto.sizePortaDelegataList(); ++j) {
                    PortaDelegata pd = soggetto.getPortaDelegata(j);
                    pd.setTipoSoggettoProprietario(soggetto.getTipo());
                    pd.setNomeSoggettoProprietario(soggetto.getNome());
                    IDPortaDelegata idPD = new IDPortaDelegata();
                    idPD.setNome(pd.getNome());
                    if (deleteMappingErogazioneFruizione && this.gestoreCRUD instanceof DriverConfigurazioneDB) {
                        driver = (DriverConfigurazioneDB)this.gestoreCRUD;
                        con = null;
                        try {
                            con = driver.getConnection("XMLDataConverter.mappingFruizione");
                            IDSoggetto idFruitore = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
                            IDServizio idServizio = this.toIdServizio(pd);
                            boolean existsMapping = DBMappingUtils.existsMappingFruizione(idServizio, idFruitore, idPD, con, driver.getTipoDB());
                            if (existsMapping) {
                                this.log.info("Eliminazione mapping di fruizione tra Porta delegata [" + pd.getNome() + "], fruitore [" + idFruitore + "] e servizio [" + idServizio + "] eliminazione in corso...");
                                DBMappingUtils.deleteMappingFruizione(idServizio, idFruitore, idPD, con, driver.getTipoDB());
                                this.log.info("Eliminazione mapping di fruizione tra Porta delegata [" + pd.getNome() + "], fruitore [" + idFruitore + "] e servizio [" + idServizio + "] eliminato.");
                            }
                        }
                        finally {
                            driver.releaseConnection(con);
                        }
                    }
                    this.log.info("Porta delegata [" + pd.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " eliminazione in corso...");
                    if (this.gestoreCRUD.existsPortaDelegata(idPD)) {
                        this.gestoreCRUD.deletePortaDelegata(((IDriverConfigurazioneGet)((Object)this.gestoreCRUD)).getPortaDelegata(idPD));
                    }
                    this.log.info("Porta delegata [" + pd.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " eliminata.");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new DriverConfigurazioneException("Errore durante l'eliminazione delle porte delegate: " + e.getMessage(), e);
        }
        try {
            for (i = 0; i < this.sorgenteConfigurazione.sizeSoggettoList(); ++i) {
                soggetto = this.sorgenteConfigurazione.getSoggetto(i);
                for (j = 0; j < soggetto.sizePortaApplicativaList(); ++j) {
                    PortaApplicativa pa = soggetto.getPortaApplicativa(j);
                    pa.setTipoSoggettoProprietario(soggetto.getTipo());
                    pa.setNomeSoggettoProprietario(soggetto.getNome());
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    idPA.setNome(pa.getNome());
                    if (deleteMappingErogazioneFruizione && this.gestoreCRUD instanceof DriverConfigurazioneDB) {
                        driver = (DriverConfigurazioneDB)this.gestoreCRUD;
                        con = null;
                        try {
                            con = driver.getConnection("XMLDataConverter.mappingErogazione");
                            IDServizio idServizio = this.toIdServizio(pa);
                            boolean existsMapping = DBMappingUtils.existsMappingErogazione(idServizio, idPA, con, driver.getTipoDB());
                            if (existsMapping) {
                                this.log.info("Eliminazione mapping di erogazione tra Porta Applicativa [" + pa.getNome() + "] e servizio [" + idServizio + "] eliminazione in corso...");
                                DBMappingUtils.deleteMappingErogazione(idServizio, idPA, con, driver.getTipoDB());
                                this.log.info("Eliminazione mapping di erogazione tra Porta Applicativa [" + pa.getNome() + "] e servizio [" + idServizio + "] eliminato.");
                            }
                        }
                        finally {
                            driver.releaseConnection(con);
                        }
                    }
                    this.log.info("Porta applicativa [" + pa.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " eliminazione in corso...");
                    if (this.gestoreCRUD.existsPortaApplicativa(idPA)) {
                        this.gestoreCRUD.deletePortaApplicativa(((IDriverConfigurazioneGet)((Object)this.gestoreCRUD)).getPortaApplicativa(idPA));
                    }
                    this.log.info("Porta applicativa [" + pa.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " eliminata.");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new DriverConfigurazioneException("Errore durante l'eliminazione delle porte applicative: " + e.getMessage(), e);
        }
        try {
            for (i = 0; i < this.sorgenteConfigurazione.sizeSoggettoList(); ++i) {
                soggetto = this.sorgenteConfigurazione.getSoggetto(i);
                for (j = 0; j < soggetto.sizeServizioApplicativoList(); ++j) {
                    ServizioApplicativo servizioApplicativo = soggetto.getServizioApplicativo(j);
                    IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
                    IDServizioApplicativo idSA = new IDServizioApplicativo();
                    idSA.setIdSoggettoProprietario(idSoggetto);
                    idSA.setNome(servizioApplicativo.getNome());
                    this.log.info("Servizio Applicativo [" + servizioApplicativo.getNome() + "] del Soggetto " + idSoggetto.getTipo() + "/" + idSoggetto.getNome() + " eliminazione in corso...");
                    if (this.gestoreCRUD.existsServizioApplicativo(idSA)) {
                        this.gestoreCRUD.deleteServizioApplicativo(((IDriverConfigurazioneGet)((Object)this.gestoreCRUD)).getServizioApplicativo(idSA));
                    }
                    this.log.info("Servizio Applicativo [" + servizioApplicativo.getNome() + "] del Soggetto " + idSoggetto.getTipo() + "/" + idSoggetto.getNome() + " eliminato.");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new DriverConfigurazioneException("Errore durante l'eliminazione dei servizi applicativi: " + e.getMessage(), e);
        }
        if (deleteSoggetti) {
            try {
                for (i = 0; i < this.sorgenteConfigurazione.sizeSoggettoList(); ++i) {
                    soggetto = this.sorgenteConfigurazione.getSoggetto(i);
                    IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
                    this.log.info("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " eliminazione in corso...");
                    if (this.gestoreCRUD.existsSoggetto(idSoggetto)) {
                        this.gestoreCRUD.deleteSoggetto(((IDriverConfigurazioneGet)((Object)this.gestoreCRUD)).getSoggetto(idSoggetto));
                    }
                    this.log.info("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " eliminato.");
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new DriverConfigurazioneException("Errore durante l'eliminazione dei soggetti: " + e.getMessage(), e);
            }
        }
    }

    private static void gestioneDefaultConnettoreHTTP(Connettore connettore) {
        if (connettore.getProperties() != null) {
            Property cp;
            if (!connettore.getProperties().containsKey("trustStoreType")) {
                cp = new Property();
                cp.setNome("trustStoreType");
                cp.setValore(KeystoreType.JKS.getNome());
                connettore.addProperty(cp);
            }
            if (!connettore.getProperties().containsKey("trustManagementAlgorithm")) {
                cp = new Property();
                cp.setNome("trustManagementAlgorithm");
                cp.setValore(TrustManagerFactory.getDefaultAlgorithm());
                connettore.addProperty(cp);
            }
            if (connettore.getProperties().containsKey("keyStoreLocation")) {
                if (!connettore.getProperties().containsKey("keyStoreType")) {
                    cp = new Property();
                    cp.setNome("keyStoreType");
                    cp.setValore(KeystoreType.JKS.getNome());
                    connettore.addProperty(cp);
                }
                if (!connettore.getProperties().containsKey("keyManagementAlgorithm")) {
                    cp = new Property();
                    cp.setNome("keyManagementAlgorithm");
                    cp.setValore(KeyManagerFactory.getDefaultAlgorithm());
                    connettore.addProperty(cp);
                }
            }
        }
    }

    public static void impostaInformazioniConfigurazione_PortaDelegata(PortaDelegata pd) {
        if (pd.getMessageSecurity() != null && (pd.getMessageSecurity().getRequestFlow() != null && pd.getMessageSecurity().getRequestFlow().sizeParameterList() > 0 || pd.getMessageSecurity().getResponseFlow() != null && pd.getMessageSecurity().getResponseFlow().sizeParameterList() > 0)) {
            pd.setStatoMessageSecurity(CostantiConfigurazione.ABILITATO.toString());
        }
    }

    public static void impostaInformazioniConfigurazione_PortaApplicativa(PortaApplicativa pa) {
        if (pa.getMessageSecurity() != null && (pa.getMessageSecurity().getRequestFlow() != null && pa.getMessageSecurity().getRequestFlow().sizeParameterList() > 0 || pa.getMessageSecurity().getResponseFlow() != null && pa.getMessageSecurity().getResponseFlow().sizeParameterList() > 0)) {
            pa.setStatoMessageSecurity(CostantiConfigurazione.ABILITATO.toString());
        }
    }

    public static void impostaInformazioniConfigurazione_ServizioApplicativo(ServizioApplicativo servizioApplicativo, Soggetto soggettoProprietario, String posizione, Logger log, String tipoBEDestinazione) {
        Credenziali credenziali;
        if (servizioApplicativo.getInvocazionePorta() == null) {
            InvocazionePorta saInv = new InvocazionePorta();
            Credenziali credenziali2 = new Credenziali();
            credenziali2.setTipo(CredenzialeTipo.toEnumConstant("none"));
            saInv.addCredenziali(credenziali2);
            InvocazionePortaGestioneErrore ge = new InvocazionePortaGestioneErrore();
            ge.setFault(CostantiConfigurazione.ERRORE_APPLICATIVO_SOAP);
            saInv.setGestioneErrore(ge);
            servizioApplicativo.setInvocazionePorta(saInv);
        } else {
            if (servizioApplicativo.getInvocazionePorta().getGestioneErrore() == null) {
                InvocazionePortaGestioneErrore ge = new InvocazionePortaGestioneErrore();
                ge.setFault(CostantiConfigurazione.ERRORE_APPLICATIVO_SOAP);
                servizioApplicativo.getInvocazionePorta().setGestioneErrore(ge);
            } else if (servizioApplicativo.getInvocazionePorta().getGestioneErrore().getFault() == null) {
                servizioApplicativo.getInvocazionePorta().getGestioneErrore().setFault(CostantiConfigurazione.ERRORE_APPLICATIVO_SOAP);
            }
            if (servizioApplicativo.getInvocazionePorta().sizeCredenzialiList() == 0) {
                credenziali = new Credenziali();
                credenziali.setTipo(CredenzialeTipo.toEnumConstant("none"));
                servizioApplicativo.getInvocazionePorta().addCredenziali(credenziali);
            }
        }
        if (servizioApplicativo.getInvocazioneServizio() != null && servizioApplicativo.getInvocazioneServizio().getConnettore() != null) {
            if (servizioApplicativo.getInvocazioneServizio().getConnettore().getTipo() == null) {
                for (int con = 0; con < soggettoProprietario.sizeConnettoreList(); ++con) {
                    if (!soggettoProprietario.getConnettore(con).getNome().equals(servizioApplicativo.getInvocazioneServizio().getConnettore().getNome())) continue;
                    servizioApplicativo.getInvocazioneServizio().setConnettore(soggettoProprietario.getConnettore(con));
                    break;
                }
                log.info("Servizio Applicativo [" + servizioApplicativo.getNome() + "]" + posizione + " del Soggetto " + soggettoProprietario.getTipo() + "/" + soggettoProprietario.getNome() + " connettore inv servizio di tipo, dopo ricerca [" + servizioApplicativo.getInvocazioneServizio().getConnettore().getTipo() + "]");
            } else {
                log.info("Servizio Applicativo [" + servizioApplicativo.getNome() + "]" + posizione + " del Soggetto " + soggettoProprietario.getTipo() + "/" + soggettoProprietario.getNome() + " connettore inv servizio di tipo [" + servizioApplicativo.getInvocazioneServizio().getConnettore().getTipo() + "]");
            }
            if ("db".equals(tipoBEDestinazione)) {
                servizioApplicativo.getInvocazioneServizio().getConnettore().setNome(null);
                String tipoConnettore = servizioApplicativo.getInvocazioneServizio().getConnettore().getTipo();
                if (!(TipiConnettore.JMS.getNome().equals(tipoConnettore) || TipiConnettore.HTTP.getNome().equals(tipoConnettore) || TipiConnettore.DISABILITATO.getNome().equals(tipoConnettore) || TipiConnettore.NULL.getNome().equals(tipoConnettore) || TipiConnettore.NULLECHO.getNome().equals(tipoConnettore))) {
                    servizioApplicativo.getInvocazioneServizio().getConnettore().setCustom(true);
                }
                if (TipiConnettore.HTTPS.getNome().equals(tipoConnettore)) {
                    XMLDataConverter.gestioneDefaultConnettoreHTTP(servizioApplicativo.getInvocazioneServizio().getConnettore());
                }
            }
        } else if (servizioApplicativo.getInvocazioneServizio() == null) {
            credenziali = new Credenziali();
            credenziali.setTipo(CredenzialeTipo.toEnumConstant("none"));
            InvocazioneServizio invServizio = new InvocazioneServizio();
            invServizio.setAutenticazione(InvocazioneServizioTipoAutenticazione.toEnumConstant("none"));
            invServizio.setGetMessage(CostantiConfigurazione.DISABILITATO);
            servizioApplicativo.setInvocazioneServizio(invServizio);
        }
        if (servizioApplicativo.getInvocazioneServizio() != null && servizioApplicativo.getInvocazioneServizio().getGetMessage() == null) {
            servizioApplicativo.getInvocazioneServizio().setGetMessage(CostantiConfigurazione.DISABILITATO);
        }
        if (servizioApplicativo.getRispostaAsincrona() != null && servizioApplicativo.getRispostaAsincrona().getConnettore() != null) {
            if (servizioApplicativo.getRispostaAsincrona().getConnettore().getTipo() == null) {
                for (int con = 0; con < soggettoProprietario.sizeConnettoreList(); ++con) {
                    if (!soggettoProprietario.getConnettore(con).getNome().equals(servizioApplicativo.getRispostaAsincrona().getConnettore().getNome())) continue;
                    servizioApplicativo.getRispostaAsincrona().setConnettore(soggettoProprietario.getConnettore(con));
                    break;
                }
                log.info("Servizio Applicativo [" + servizioApplicativo.getNome() + "]" + posizione + " del Soggetto " + soggettoProprietario.getTipo() + "/" + soggettoProprietario.getNome() + " connettore risposta asincrona di tipo, dopo ricerca [" + servizioApplicativo.getRispostaAsincrona().getConnettore().getTipo() + "]");
            } else {
                log.info("Servizio Applicativo [" + servizioApplicativo.getNome() + "]" + posizione + " del Soggetto " + soggettoProprietario.getTipo() + "/" + soggettoProprietario.getNome() + " connettore risposta asincrona di tipo [" + servizioApplicativo.getRispostaAsincrona().getConnettore().getTipo() + "]");
            }
            if ("db".equals(tipoBEDestinazione)) {
                servizioApplicativo.getRispostaAsincrona().getConnettore().setNome(null);
                String tipoConnettore = servizioApplicativo.getRispostaAsincrona().getConnettore().getTipo();
                if (!(TipiConnettore.JMS.getNome().equals(tipoConnettore) || TipiConnettore.HTTP.getNome().equals(tipoConnettore) || TipiConnettore.DISABILITATO.getNome().equals(tipoConnettore) || TipiConnettore.NULL.getNome().equals(tipoConnettore) || TipiConnettore.NULLECHO.getNome().equals(tipoConnettore))) {
                    servizioApplicativo.getRispostaAsincrona().getConnettore().setCustom(true);
                }
                if (TipiConnettore.HTTPS.getNome().equals(tipoConnettore)) {
                    XMLDataConverter.gestioneDefaultConnettoreHTTP(servizioApplicativo.getRispostaAsincrona().getConnettore());
                }
            }
        } else if (servizioApplicativo.getRispostaAsincrona() == null) {
            Credenziali credenziali3 = new Credenziali();
            credenziali3.setTipo(CredenzialeTipo.toEnumConstant("none"));
            RispostaAsincrona rispostaAsinc = new RispostaAsincrona();
            rispostaAsinc.setAutenticazione(InvocazioneServizioTipoAutenticazione.toEnumConstant("none"));
            rispostaAsinc.setGetMessage(CostantiConfigurazione.DISABILITATO);
            servizioApplicativo.setRispostaAsincrona(rispostaAsinc);
        }
        if (servizioApplicativo.getRispostaAsincrona() != null && servizioApplicativo.getRispostaAsincrona().getGetMessage() == null) {
            servizioApplicativo.getRispostaAsincrona().setGetMessage(CostantiConfigurazione.DISABILITATO);
        }
        if (CostantiConfigurazione.REGISTRO_DB.equals(tipoBEDestinazione)) {
            String tipoConnettore;
            boolean isClient = false;
            if (servizioApplicativo.getInvocazioneServizio() != null && servizioApplicativo.getInvocazioneServizio().getConnettore() != null) {
                servizioApplicativo.getInvocazioneServizio().getConnettore().setNome(null);
                tipoConnettore = servizioApplicativo.getInvocazioneServizio().getConnettore().getTipo();
                if (!TipiConnettore.DISABILITATO.getNome().equals(tipoConnettore)) {
                    servizioApplicativo.setTipologiaErogazione(TipologiaErogazione.TRASPARENTE.getValue());
                }
                if (!(TipiConnettore.JMS.getNome().equals(tipoConnettore) || TipiConnettore.HTTP.getNome().equals(tipoConnettore) || TipiConnettore.DISABILITATO.getNome().equals(tipoConnettore) || TipiConnettore.NULL.getNome().equals(tipoConnettore) || TipiConnettore.NULLECHO.getNome().equals(tipoConnettore))) {
                    servizioApplicativo.getInvocazioneServizio().getConnettore().setCustom(true);
                }
                if (TipiConnettore.HTTPS.getNome().equals(tipoConnettore)) {
                    XMLDataConverter.gestioneDefaultConnettoreHTTP(servizioApplicativo.getInvocazioneServizio().getConnettore());
                }
            }
            if (servizioApplicativo.getRispostaAsincrona() != null && servizioApplicativo.getRispostaAsincrona().getConnettore() != null) {
                servizioApplicativo.getRispostaAsincrona().getConnettore().setNome(null);
                tipoConnettore = servizioApplicativo.getRispostaAsincrona().getConnettore().getTipo();
                if (!TipiConnettore.DISABILITATO.getNome().equals(tipoConnettore)) {
                    servizioApplicativo.setTipologiaErogazione(TipologiaErogazione.ASINCRONA_ASIMMETRICA.getValue());
                }
                if (!(TipiConnettore.JMS.getNome().equals(tipoConnettore) || TipiConnettore.HTTP.getNome().equals(tipoConnettore) || TipiConnettore.DISABILITATO.getNome().equals(tipoConnettore) || TipiConnettore.NULL.getNome().equals(tipoConnettore) || TipiConnettore.NULLECHO.getNome().equals(tipoConnettore))) {
                    servizioApplicativo.getRispostaAsincrona().getConnettore().setCustom(true);
                }
                if (TipiConnettore.HTTPS.getNome().equals(tipoConnettore)) {
                    XMLDataConverter.gestioneDefaultConnettoreHTTP(servizioApplicativo.getRispostaAsincrona().getConnettore());
                }
            }
            if (servizioApplicativo.getTipologiaErogazione() == null && servizioApplicativo.getInvocazioneServizio() != null && servizioApplicativo.getInvocazioneServizio().getGetMessage() != null && StatoFunzionalita.ABILITATO.equals(servizioApplicativo.getInvocazioneServizio().getGetMessage())) {
                servizioApplicativo.setTipologiaErogazione(TipologiaErogazione.MESSAGE_BOX.getValue());
            }
            boolean isIMenabled = false;
            if (servizioApplicativo.getInvocazioneServizio() != null && servizioApplicativo.getInvocazioneServizio().getGetMessage() != null && StatoFunzionalita.ABILITATO.equals(servizioApplicativo.getInvocazioneServizio().getGetMessage())) {
                isIMenabled = true;
            } else if (servizioApplicativo.getRispostaAsincrona() != null && servizioApplicativo.getRispostaAsincrona().getGetMessage() != null && StatoFunzionalita.ABILITATO.equals(servizioApplicativo.getRispostaAsincrona().getGetMessage())) {
                isIMenabled = true;
            }
            if (servizioApplicativo.getInvocazionePorta() != null && servizioApplicativo.getInvocazionePorta().sizeCredenzialiList() > 0) {
                boolean found = false;
                for (int i = 0; i < servizioApplicativo.getInvocazionePorta().sizeCredenzialiList(); ++i) {
                    Credenziali c = servizioApplicativo.getInvocazionePorta().getCredenziali(i);
                    if (c == null || c.getTipo() == null || c.getUser() == null && c.getSubject() == null) continue;
                    found = true;
                    break;
                }
                if (found) {
                    servizioApplicativo.setTipologiaFruizione(TipologiaFruizione.NORMALE.getValue());
                    isClient = true;
                }
            }
            if (isClient) {
                if (servizioApplicativo.getTipo() == null) {
                    if (!isIMenabled) {
                        servizioApplicativo.setTipo("client");
                    }
                } else if ("server".equals(servizioApplicativo.getTipo())) {
                    servizioApplicativo.setUseAsClient(true);
                }
            }
        }
    }

    public static void impostaInformazioniConfigurazione_ServizioApplicativo_update(ServizioApplicativo servizioApplicativo, ServizioApplicativo old) {
        servizioApplicativo.setId(old.getId());
        if (servizioApplicativo.getInvocazioneServizio() != null) {
            if (servizioApplicativo.getInvocazioneServizio().getConnettore() == null) {
                if (old.getInvocazioneServizio() != null) {
                    servizioApplicativo.getInvocazioneServizio().setConnettore(old.getInvocazioneServizio().getConnettore());
                }
            } else if (old.getInvocazioneServizio() != null && old.getInvocazioneServizio().getConnettore() != null) {
                servizioApplicativo.getInvocazioneServizio().getConnettore().setId(old.getInvocazioneServizio().getConnettore().getId());
                servizioApplicativo.getInvocazioneServizio().getConnettore().setNome(old.getInvocazioneServizio().getConnettore().getNome());
            }
        }
        if (servizioApplicativo.getRispostaAsincrona() != null) {
            if (servizioApplicativo.getRispostaAsincrona().getConnettore() == null) {
                if (old.getRispostaAsincrona() != null) {
                    servizioApplicativo.getRispostaAsincrona().setConnettore(old.getRispostaAsincrona().getConnettore());
                }
            } else if (old.getRispostaAsincrona() != null && old.getRispostaAsincrona().getConnettore() != null) {
                servizioApplicativo.getRispostaAsincrona().getConnettore().setId(old.getRispostaAsincrona().getConnettore().getId());
                servizioApplicativo.getRispostaAsincrona().getConnettore().setNome(old.getRispostaAsincrona().getConnettore().getNome());
            }
        }
    }

    private void addServizioApplicativo(ServizioApplicativo servizioApplicativo, Soggetto soggettoProprietario, String posizione, boolean reset, boolean updateEnabled) throws Exception {
        servizioApplicativo.setTipoSoggettoProprietario(soggettoProprietario.getTipo());
        servizioApplicativo.setNomeSoggettoProprietario(soggettoProprietario.getNome());
        Object pos = "";
        if (posizione != null) {
            pos = "[" + posizione + "]";
        }
        XMLDataConverter.impostaInformazioniConfigurazione_ServizioApplicativo(servizioApplicativo, soggettoProprietario, (String)pos, this.log, this.tipoBEDestinazione);
        IDSoggetto idSoggetto = new IDSoggetto(soggettoProprietario.getTipo(), soggettoProprietario.getNome());
        IDServizioApplicativo idSA = new IDServizioApplicativo();
        idSA.setIdSoggettoProprietario(idSoggetto);
        idSA.setNome(servizioApplicativo.getNome());
        if (!reset && this.gestoreCRUD.existsServizioApplicativo(idSA)) {
            if (updateEnabled) {
                this.log.info("Servizio Applicativo [" + servizioApplicativo.getNome() + "]" + (String)pos + " del Soggetto " + soggettoProprietario.getTipo() + "/" + soggettoProprietario.getNome() + " aggiornamento in corso...");
                ServizioApplicativo old = ((IDriverConfigurazioneGet)((Object)this.gestoreCRUD)).getServizioApplicativo(idSA);
                XMLDataConverter.impostaInformazioniConfigurazione_ServizioApplicativo_update(servizioApplicativo, old);
                this.gestoreCRUD.updateServizioApplicativo(servizioApplicativo);
                this.log.info("Servizio Applicativo [" + servizioApplicativo.getNome() + "]" + (String)pos + " del Soggetto " + soggettoProprietario.getTipo() + "/" + soggettoProprietario.getNome() + " aggiornato.");
            } else {
                this.log.info("Servizio Applicativo [" + servizioApplicativo.getNome() + "]" + (String)pos + " del Soggetto " + soggettoProprietario.getTipo() + "/" + soggettoProprietario.getNome() + " non aggiornato (aggiornamento disabilitato).");
            }
        } else {
            this.log.info("Servizio Applicativo [" + servizioApplicativo.getNome() + "]" + (String)pos + " del Soggetto " + soggettoProprietario.getTipo() + "/" + soggettoProprietario.getNome() + " creazione in corso...");
            this.gestoreCRUD.createServizioApplicativo(servizioApplicativo);
            this.log.info("Servizio Applicativo [" + servizioApplicativo.getNome() + "]" + (String)pos + " del Soggetto " + soggettoProprietario.getTipo() + "/" + soggettoProprietario.getNome() + " creato.");
        }
    }
}

