/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.controllo_traffico.driver;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openspcoop2.core.controllo_traffico.constants.TipoRisorsaPolicyAttiva;

public enum PolicyGroupByActiveThreadsType {
    LOCAL,
    LOCAL_DIVIDED_BY_NODES,
    DATABASE,
    HAZELCAST_ATOMIC_LONG,
    HAZELCAST_ATOMIC_LONG_ASYNC,
    HAZELCAST_PNCOUNTER,
    HAZELCAST_MAP,
    HAZELCAST_NEAR_CACHE,
    HAZELCAST_NEAR_CACHE_UNSAFE_SYNC_MAP,
    HAZELCAST_NEAR_CACHE_UNSAFE_ASYNC_MAP,
    HAZELCAST_LOCAL_CACHE,
    HAZELCAST_REPLICATED_MAP,
    REDISSON_ATOMIC_LONG,
    REDISSON_LONGADDER,
    REDISSON_MAP;

    private static List<PolicyGroupByActiveThreadsType> hazelcastMapTypes;
    private static List<PolicyGroupByActiveThreadsType> hazelcastCountersTypes;
    private static List<PolicyGroupByActiveThreadsType> hazelcastTypes;
    private static List<PolicyGroupByActiveThreadsType> redisMapTypes;
    private static List<PolicyGroupByActiveThreadsType> redisCountersTypes;
    private static List<PolicyGroupByActiveThreadsType> redisTypes;
    private static Set<PolicyGroupByActiveThreadsType> exactModes;
    private static Set<PolicyGroupByActiveThreadsType> approxModes;
    private static Set<PolicyGroupByActiveThreadsType> inconsistentModes;
    private static Set<PolicyGroupByActiveThreadsType> nearCacheModes;

    public boolean isHazelcast() {
        return hazelcastTypes.contains((Object)this);
    }

    public boolean isHazelcastMap() {
        return hazelcastMapTypes.contains((Object)this);
    }

    public boolean isHazelcastCounters() {
        return hazelcastCountersTypes.contains((Object)this);
    }

    public boolean isRedis() {
        return redisTypes.contains((Object)this);
    }

    public boolean isRedisMap() {
        return redisMapTypes.contains((Object)this);
    }

    public boolean isRedisCounters() {
        return redisCountersTypes.contains((Object)this);
    }

    public boolean isExact() {
        return exactModes.contains((Object)this);
    }

    public boolean isApproximated() {
        return approxModes.contains((Object)this);
    }

    public boolean isInconsistent() {
        return inconsistentModes.contains((Object)this);
    }

    public boolean useNearCache() {
        return nearCacheModes.contains((Object)this);
    }

    public String toLabel() {
        switch (this) {
            case LOCAL: {
                return "Locale";
            }
            case LOCAL_DIVIDED_BY_NODES: {
                return "Locale - Quota divisa sui nodi";
            }
            case DATABASE: {
                return "Distribuita - embedded";
            }
            case HAZELCAST_MAP: {
                return "Distribuita - hazelcast (map)";
            }
            case HAZELCAST_NEAR_CACHE: {
                return "Distribuita - hazelcast (near-cache)";
            }
            case HAZELCAST_LOCAL_CACHE: {
                return "Distribuita - hazelcast (local-cache)";
            }
            case HAZELCAST_NEAR_CACHE_UNSAFE_SYNC_MAP: {
                return "Distribuita - hazelcast (remote-sync)";
            }
            case HAZELCAST_NEAR_CACHE_UNSAFE_ASYNC_MAP: {
                return "Distribuita - hazelcast (remote-async)";
            }
            case HAZELCAST_PNCOUNTER: {
                return "Distribuita - hazelcast (pn-counters)";
            }
            case HAZELCAST_ATOMIC_LONG: {
                return "Distribuita - hazelcast (atomic-long-counters)";
            }
            case HAZELCAST_ATOMIC_LONG_ASYNC: {
                return "Distribuita - hazelcast (atomic-long-async-counters)";
            }
            case HAZELCAST_REPLICATED_MAP: {
                return "Distribuita - hazelcast (replicated-map)";
            }
            case REDISSON_ATOMIC_LONG: {
                return "Distribuita - redis (atomic-long-counters)";
            }
            case REDISSON_LONGADDER: {
                return "Distribuita - redis (longadder-counters)";
            }
            case REDISSON_MAP: {
                return "Distribuita - redis (map)";
            }
        }
        return null;
    }

    public List<TipoRisorsaPolicyAttiva> getSupportedResources() {
        ArrayList<TipoRisorsaPolicyAttiva> list = new ArrayList<TipoRisorsaPolicyAttiva>();
        for (TipoRisorsaPolicyAttiva tipoRisorsaPolicyAttiva : TipoRisorsaPolicyAttiva.values()) {
            list.add(tipoRisorsaPolicyAttiva);
        }
        switch (this) {
            case LOCAL: {
                return list;
            }
            case LOCAL_DIVIDED_BY_NODES: {
                list.remove(TipoRisorsaPolicyAttiva.OCCUPAZIONE_BANDA);
                list.remove(TipoRisorsaPolicyAttiva.TEMPO_COMPLESSIVO_RISPOSTA);
                list.remove(TipoRisorsaPolicyAttiva.TEMPO_MEDIO_RISPOSTA);
                return list;
            }
            case DATABASE: {
                return list;
            }
            case HAZELCAST_MAP: 
            case HAZELCAST_PNCOUNTER: 
            case HAZELCAST_ATOMIC_LONG: 
            case HAZELCAST_ATOMIC_LONG_ASYNC: 
            case REDISSON_ATOMIC_LONG: {
                return list;
            }
            case REDISSON_LONGADDER: {
                list.remove(TipoRisorsaPolicyAttiva.NUMERO_RICHIESTE_SIMULTANEE);
                return list;
            }
            case HAZELCAST_NEAR_CACHE: {
                list.remove(TipoRisorsaPolicyAttiva.NUMERO_RICHIESTE_SIMULTANEE);
                return list;
            }
            case HAZELCAST_LOCAL_CACHE: {
                return list;
            }
            case HAZELCAST_REPLICATED_MAP: {
                list.remove(TipoRisorsaPolicyAttiva.NUMERO_RICHIESTE_SIMULTANEE);
                return list;
            }
            case HAZELCAST_NEAR_CACHE_UNSAFE_SYNC_MAP: 
            case HAZELCAST_NEAR_CACHE_UNSAFE_ASYNC_MAP: {
                list.remove(TipoRisorsaPolicyAttiva.NUMERO_RICHIESTE_SIMULTANEE);
                return list;
            }
            case REDISSON_MAP: {
                return list;
            }
        }
        return null;
    }

    public boolean isSupportedResource(TipoRisorsaPolicyAttiva resource) {
        List<TipoRisorsaPolicyAttiva> l = this.getSupportedResources();
        return l != null && l.contains(resource);
    }

    static {
        hazelcastMapTypes = List.of(HAZELCAST_MAP, HAZELCAST_NEAR_CACHE, HAZELCAST_NEAR_CACHE_UNSAFE_SYNC_MAP, HAZELCAST_NEAR_CACHE_UNSAFE_ASYNC_MAP, HAZELCAST_LOCAL_CACHE, HAZELCAST_REPLICATED_MAP);
        hazelcastCountersTypes = List.of(HAZELCAST_PNCOUNTER, HAZELCAST_ATOMIC_LONG, HAZELCAST_ATOMIC_LONG_ASYNC);
        hazelcastTypes = new ArrayList<PolicyGroupByActiveThreadsType>();
        hazelcastTypes.addAll(hazelcastMapTypes);
        hazelcastTypes.addAll(hazelcastCountersTypes);
        redisMapTypes = List.of(REDISSON_MAP);
        redisCountersTypes = List.of(REDISSON_ATOMIC_LONG, REDISSON_LONGADDER);
        redisTypes = new ArrayList<PolicyGroupByActiveThreadsType>();
        redisTypes.addAll(redisMapTypes);
        redisTypes.addAll(redisCountersTypes);
        exactModes = Set.of(HAZELCAST_ATOMIC_LONG, REDISSON_ATOMIC_LONG, HAZELCAST_MAP, REDISSON_MAP);
        approxModes = Set.of(HAZELCAST_PNCOUNTER, HAZELCAST_ATOMIC_LONG_ASYNC, HAZELCAST_NEAR_CACHE, HAZELCAST_LOCAL_CACHE);
        inconsistentModes = Set.of(HAZELCAST_NEAR_CACHE_UNSAFE_SYNC_MAP, HAZELCAST_NEAR_CACHE_UNSAFE_ASYNC_MAP, HAZELCAST_REPLICATED_MAP, REDISSON_LONGADDER);
        nearCacheModes = Set.of(HAZELCAST_NEAR_CACHE, HAZELCAST_NEAR_CACHE_UNSAFE_SYNC_MAP, HAZELCAST_NEAR_CACHE_UNSAFE_ASYNC_MAP);
    }
}

