/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.controllo_traffico.utils;

import org.openspcoop2.core.controllo_traffico.utils.ProjectInfo;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLUtils {
    private XMLUtils() {
    }

    public static boolean isAttivazionePolicy(byte[] doc) {
        try {
            MessageXMLUtils xmlUtils = MessageXMLUtils.DEFAULT;
            Document docXML = xmlUtils.newDocument(doc);
            Element elemXML = docXML.getDocumentElement();
            return XMLUtils.isAttivazionePolicyEngine(elemXML);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isAttivazionePolicy(Document docXML) {
        try {
            Element elemXML = docXML.getDocumentElement();
            return XMLUtils.isAttivazionePolicyEngine(elemXML);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isAttivazionePolicy(Element elemXML) {
        return XMLUtils.isAttivazionePolicyEngine(elemXML);
    }

    public static boolean isAttivazionePolicy(Node nodeXml) {
        return XMLUtils.isAttivazionePolicyEngine(nodeXml);
    }

    private static boolean isAttivazionePolicyEngine(Node nodeXml) {
        try {
            ProjectInfo pInfo = new ProjectInfo();
            return "attivazione-policy".equals(nodeXml.getLocalName()) && pInfo.getProjectNamespace().equals(nodeXml.getNamespaceURI());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isConfigurazionePolicy(byte[] doc) {
        try {
            MessageXMLUtils xmlUtils = MessageXMLUtils.DEFAULT;
            Document docXML = xmlUtils.newDocument(doc);
            Element elemXML = docXML.getDocumentElement();
            return XMLUtils.isConfigurazionePolicyEngine(elemXML);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isConfigurazionePolicy(Document docXML) {
        try {
            Element elemXML = docXML.getDocumentElement();
            return XMLUtils.isConfigurazionePolicyEngine(elemXML);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isConfigurazionePolicy(Element elemXML) {
        return XMLUtils.isConfigurazionePolicyEngine(elemXML);
    }

    public static boolean isConfigurazionePolicy(Node nodeXml) {
        return XMLUtils.isConfigurazionePolicyEngine(nodeXml);
    }

    private static boolean isConfigurazionePolicyEngine(Node nodeXml) {
        try {
            ProjectInfo pInfo = new ProjectInfo();
            return "configurazione-policy".equals(nodeXml.getLocalName()) && pInfo.getProjectNamespace().equals(nodeXml.getNamespaceURI());
        }
        catch (Exception e) {
            return false;
        }
    }
}

