/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.diagnostica.utils.serializer;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import javax.xml.bind.JAXBElement;
import org.openspcoop2.core.diagnostica.DominioDiagnostico;
import org.openspcoop2.core.diagnostica.DominioSoggetto;
import org.openspcoop2.core.diagnostica.ElencoMessaggiDiagnostici;
import org.openspcoop2.core.diagnostica.MessaggioDiagnostico;
import org.openspcoop2.core.diagnostica.Proprieta;
import org.openspcoop2.core.diagnostica.Protocollo;
import org.openspcoop2.generic_project.exception.SerializerException;
import org.openspcoop2.utils.beans.WriteToSerializerType;
import org.openspcoop2.utils.xml.JaxbUtils;

public abstract class AbstractSerializer {
    protected abstract WriteToSerializerType getType();

    protected void _objToXml(OutputStream out, Class<?> c, Object object, boolean prettyPrint) throws Exception {
        if (object instanceof JAXBElement) {
            JaxbUtils.objToXml((OutputStream)out, c, (Object)object, (boolean)prettyPrint);
        } else {
            Method m = c.getMethod("writeTo", OutputStream.class, WriteToSerializerType.class);
            m.invoke(object, out, this.getType());
        }
    }

    protected void objToXml(OutputStream out, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        try {
            this._objToXml(out, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                out.flush();
            }
            catch (Exception exception) {}
        }
    }

    protected void objToXml(String fileName, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        try {
            this.objToXml(new File(fileName), c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
    }

    protected void objToXml(File file, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            this._objToXml(fout, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.flush();
                }
            }
            catch (Exception exception) {}
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected ByteArrayOutputStream objToXml(Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        ByteArrayOutputStream bout = null;
        try {
            bout = new ByteArrayOutputStream();
            this._objToXml(bout, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (bout != null) {
                    bout.flush();
                }
            }
            catch (Exception exception) {}
            try {
                if (bout != null) {
                    bout.close();
                }
            }
            catch (Exception exception) {}
        }
        return bout;
    }

    public void write(String fileName, DominioSoggetto dominioSoggetto) throws SerializerException {
        this.objToXml(fileName, DominioSoggetto.class, (Object)dominioSoggetto, false);
    }

    public void write(String fileName, DominioSoggetto dominioSoggetto, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, DominioSoggetto.class, (Object)dominioSoggetto, prettyPrint);
    }

    public void write(File file, DominioSoggetto dominioSoggetto) throws SerializerException {
        this.objToXml(file, DominioSoggetto.class, (Object)dominioSoggetto, false);
    }

    public void write(File file, DominioSoggetto dominioSoggetto, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, DominioSoggetto.class, (Object)dominioSoggetto, prettyPrint);
    }

    public void write(OutputStream out, DominioSoggetto dominioSoggetto) throws SerializerException {
        this.objToXml(out, DominioSoggetto.class, (Object)dominioSoggetto, false);
    }

    public void write(OutputStream out, DominioSoggetto dominioSoggetto, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, DominioSoggetto.class, (Object)dominioSoggetto, prettyPrint);
    }

    public byte[] toByteArray(DominioSoggetto dominioSoggetto) throws SerializerException {
        return this.objToXml(DominioSoggetto.class, dominioSoggetto, false).toByteArray();
    }

    public byte[] toByteArray(DominioSoggetto dominioSoggetto, boolean prettyPrint) throws SerializerException {
        return this.objToXml(DominioSoggetto.class, dominioSoggetto, prettyPrint).toByteArray();
    }

    public String toString(DominioSoggetto dominioSoggetto) throws SerializerException {
        return this.objToXml(DominioSoggetto.class, dominioSoggetto, false).toString();
    }

    public String toString(DominioSoggetto dominioSoggetto, boolean prettyPrint) throws SerializerException {
        return this.objToXml(DominioSoggetto.class, dominioSoggetto, prettyPrint).toString();
    }

    public void write(String fileName, MessaggioDiagnostico messaggioDiagnostico) throws SerializerException {
        this.objToXml(fileName, MessaggioDiagnostico.class, (Object)messaggioDiagnostico, false);
    }

    public void write(String fileName, MessaggioDiagnostico messaggioDiagnostico, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, MessaggioDiagnostico.class, (Object)messaggioDiagnostico, prettyPrint);
    }

    public void write(File file, MessaggioDiagnostico messaggioDiagnostico) throws SerializerException {
        this.objToXml(file, MessaggioDiagnostico.class, (Object)messaggioDiagnostico, false);
    }

    public void write(File file, MessaggioDiagnostico messaggioDiagnostico, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, MessaggioDiagnostico.class, (Object)messaggioDiagnostico, prettyPrint);
    }

    public void write(OutputStream out, MessaggioDiagnostico messaggioDiagnostico) throws SerializerException {
        this.objToXml(out, MessaggioDiagnostico.class, (Object)messaggioDiagnostico, false);
    }

    public void write(OutputStream out, MessaggioDiagnostico messaggioDiagnostico, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, MessaggioDiagnostico.class, (Object)messaggioDiagnostico, prettyPrint);
    }

    public byte[] toByteArray(MessaggioDiagnostico messaggioDiagnostico) throws SerializerException {
        return this.objToXml(MessaggioDiagnostico.class, messaggioDiagnostico, false).toByteArray();
    }

    public byte[] toByteArray(MessaggioDiagnostico messaggioDiagnostico, boolean prettyPrint) throws SerializerException {
        return this.objToXml(MessaggioDiagnostico.class, messaggioDiagnostico, prettyPrint).toByteArray();
    }

    public String toString(MessaggioDiagnostico messaggioDiagnostico) throws SerializerException {
        return this.objToXml(MessaggioDiagnostico.class, messaggioDiagnostico, false).toString();
    }

    public String toString(MessaggioDiagnostico messaggioDiagnostico, boolean prettyPrint) throws SerializerException {
        return this.objToXml(MessaggioDiagnostico.class, messaggioDiagnostico, prettyPrint).toString();
    }

    public void write(String fileName, ElencoMessaggiDiagnostici elencoMessaggiDiagnostici) throws SerializerException {
        this.objToXml(fileName, ElencoMessaggiDiagnostici.class, (Object)elencoMessaggiDiagnostici, false);
    }

    public void write(String fileName, ElencoMessaggiDiagnostici elencoMessaggiDiagnostici, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, ElencoMessaggiDiagnostici.class, (Object)elencoMessaggiDiagnostici, prettyPrint);
    }

    public void write(File file, ElencoMessaggiDiagnostici elencoMessaggiDiagnostici) throws SerializerException {
        this.objToXml(file, ElencoMessaggiDiagnostici.class, (Object)elencoMessaggiDiagnostici, false);
    }

    public void write(File file, ElencoMessaggiDiagnostici elencoMessaggiDiagnostici, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, ElencoMessaggiDiagnostici.class, (Object)elencoMessaggiDiagnostici, prettyPrint);
    }

    public void write(OutputStream out, ElencoMessaggiDiagnostici elencoMessaggiDiagnostici) throws SerializerException {
        this.objToXml(out, ElencoMessaggiDiagnostici.class, (Object)elencoMessaggiDiagnostici, false);
    }

    public void write(OutputStream out, ElencoMessaggiDiagnostici elencoMessaggiDiagnostici, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, ElencoMessaggiDiagnostici.class, (Object)elencoMessaggiDiagnostici, prettyPrint);
    }

    public byte[] toByteArray(ElencoMessaggiDiagnostici elencoMessaggiDiagnostici) throws SerializerException {
        return this.objToXml(ElencoMessaggiDiagnostici.class, elencoMessaggiDiagnostici, false).toByteArray();
    }

    public byte[] toByteArray(ElencoMessaggiDiagnostici elencoMessaggiDiagnostici, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ElencoMessaggiDiagnostici.class, elencoMessaggiDiagnostici, prettyPrint).toByteArray();
    }

    public String toString(ElencoMessaggiDiagnostici elencoMessaggiDiagnostici) throws SerializerException {
        return this.objToXml(ElencoMessaggiDiagnostici.class, elencoMessaggiDiagnostici, false).toString();
    }

    public String toString(ElencoMessaggiDiagnostici elencoMessaggiDiagnostici, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ElencoMessaggiDiagnostici.class, elencoMessaggiDiagnostici, prettyPrint).toString();
    }

    public void write(String fileName, DominioDiagnostico dominioDiagnostico) throws SerializerException {
        this.objToXml(fileName, DominioDiagnostico.class, (Object)dominioDiagnostico, false);
    }

    public void write(String fileName, DominioDiagnostico dominioDiagnostico, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, DominioDiagnostico.class, (Object)dominioDiagnostico, prettyPrint);
    }

    public void write(File file, DominioDiagnostico dominioDiagnostico) throws SerializerException {
        this.objToXml(file, DominioDiagnostico.class, (Object)dominioDiagnostico, false);
    }

    public void write(File file, DominioDiagnostico dominioDiagnostico, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, DominioDiagnostico.class, (Object)dominioDiagnostico, prettyPrint);
    }

    public void write(OutputStream out, DominioDiagnostico dominioDiagnostico) throws SerializerException {
        this.objToXml(out, DominioDiagnostico.class, (Object)dominioDiagnostico, false);
    }

    public void write(OutputStream out, DominioDiagnostico dominioDiagnostico, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, DominioDiagnostico.class, (Object)dominioDiagnostico, prettyPrint);
    }

    public byte[] toByteArray(DominioDiagnostico dominioDiagnostico) throws SerializerException {
        return this.objToXml(DominioDiagnostico.class, dominioDiagnostico, false).toByteArray();
    }

    public byte[] toByteArray(DominioDiagnostico dominioDiagnostico, boolean prettyPrint) throws SerializerException {
        return this.objToXml(DominioDiagnostico.class, dominioDiagnostico, prettyPrint).toByteArray();
    }

    public String toString(DominioDiagnostico dominioDiagnostico) throws SerializerException {
        return this.objToXml(DominioDiagnostico.class, dominioDiagnostico, false).toString();
    }

    public String toString(DominioDiagnostico dominioDiagnostico, boolean prettyPrint) throws SerializerException {
        return this.objToXml(DominioDiagnostico.class, dominioDiagnostico, prettyPrint).toString();
    }

    public void write(String fileName, Proprieta proprieta) throws SerializerException {
        this.objToXml(fileName, Proprieta.class, (Object)proprieta, false);
    }

    public void write(String fileName, Proprieta proprieta, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Proprieta.class, (Object)proprieta, prettyPrint);
    }

    public void write(File file, Proprieta proprieta) throws SerializerException {
        this.objToXml(file, Proprieta.class, (Object)proprieta, false);
    }

    public void write(File file, Proprieta proprieta, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Proprieta.class, (Object)proprieta, prettyPrint);
    }

    public void write(OutputStream out, Proprieta proprieta) throws SerializerException {
        this.objToXml(out, Proprieta.class, (Object)proprieta, false);
    }

    public void write(OutputStream out, Proprieta proprieta, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Proprieta.class, (Object)proprieta, prettyPrint);
    }

    public byte[] toByteArray(Proprieta proprieta) throws SerializerException {
        return this.objToXml(Proprieta.class, proprieta, false).toByteArray();
    }

    public byte[] toByteArray(Proprieta proprieta, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Proprieta.class, proprieta, prettyPrint).toByteArray();
    }

    public String toString(Proprieta proprieta) throws SerializerException {
        return this.objToXml(Proprieta.class, proprieta, false).toString();
    }

    public String toString(Proprieta proprieta, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Proprieta.class, proprieta, prettyPrint).toString();
    }

    public void write(String fileName, Protocollo protocollo) throws SerializerException {
        this.objToXml(fileName, Protocollo.class, (Object)protocollo, false);
    }

    public void write(String fileName, Protocollo protocollo, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Protocollo.class, (Object)protocollo, prettyPrint);
    }

    public void write(File file, Protocollo protocollo) throws SerializerException {
        this.objToXml(file, Protocollo.class, (Object)protocollo, false);
    }

    public void write(File file, Protocollo protocollo, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Protocollo.class, (Object)protocollo, prettyPrint);
    }

    public void write(OutputStream out, Protocollo protocollo) throws SerializerException {
        this.objToXml(out, Protocollo.class, (Object)protocollo, false);
    }

    public void write(OutputStream out, Protocollo protocollo, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Protocollo.class, (Object)protocollo, prettyPrint);
    }

    public byte[] toByteArray(Protocollo protocollo) throws SerializerException {
        return this.objToXml(Protocollo.class, protocollo, false).toByteArray();
    }

    public byte[] toByteArray(Protocollo protocollo, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Protocollo.class, protocollo, prettyPrint).toByteArray();
    }

    public String toString(Protocollo protocollo) throws SerializerException {
        return this.objToXml(Protocollo.class, protocollo, false).toString();
    }

    public String toString(Protocollo protocollo, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Protocollo.class, protocollo, prettyPrint).toString();
    }
}

