/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.eventi.dao.jdbc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.eventi.Evento;
import org.openspcoop2.core.eventi.dao.jdbc.JDBCEventoServiceSearchImpl;
import org.openspcoop2.core.eventi.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.generic_project.beans.IDMappingBehaviour;
import org.openspcoop2.generic_project.beans.IModel;
import org.openspcoop2.generic_project.beans.NonNegativeNumber;
import org.openspcoop2.generic_project.beans.UpdateField;
import org.openspcoop2.generic_project.beans.UpdateModel;
import org.openspcoop2.generic_project.dao.jdbc.IJDBCServiceCRUDWithoutId;
import org.openspcoop2.generic_project.dao.jdbc.IJDBCServiceSearchWithoutId;
import org.openspcoop2.generic_project.dao.jdbc.JDBCExpression;
import org.openspcoop2.generic_project.dao.jdbc.JDBCPaginatedExpression;
import org.openspcoop2.generic_project.dao.jdbc.JDBCServiceManagerProperties;
import org.openspcoop2.generic_project.dao.jdbc.utils.GenericJDBCUtilities;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCObject;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCPreparedStatementUtilities;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.jdbc.IKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.NullByteTextColumnSanitizer;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.slf4j.Logger;

public class JDBCEventoServiceImpl
extends JDBCEventoServiceSearchImpl
implements IJDBCServiceCRUDWithoutId<Evento, JDBCServiceManager> {
    private static void sanitizeTextColumns(TipiDatabase dbType, Evento evento) {
        evento.setConfigurazione(NullByteTextColumnSanitizer.sanitize((TipiDatabase)dbType, (String)evento.getConfigurazione()));
    }

    public void create(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Evento evento, IDMappingBehaviour idMappingResolutionBehaviour) throws NotImplementedException, ServiceException, Exception {
        if (NullByteTextColumnSanitizer.needsSanitization((TipiDatabase)jdbcProperties.getDatabase())) {
            JDBCEventoServiceImpl.sanitizeTextColumns(jdbcProperties.getDatabase(), evento);
        }
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        ISQLQueryObject sqlQueryObjectInsert = sqlQueryObject.newSQLQueryObject();
        sqlQueryObjectInsert.addInsertTable(this.getEventoFieldConverter().toTable((IModel)Evento.model()));
        sqlQueryObjectInsert.addInsertField(this.getEventoFieldConverter().toColumn(Evento.model().TIPO, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getEventoFieldConverter().toColumn(Evento.model().CODICE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getEventoFieldConverter().toColumn(Evento.model().SEVERITA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getEventoFieldConverter().toColumn(Evento.model().ORA_REGISTRAZIONE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getEventoFieldConverter().toColumn(Evento.model().DESCRIZIONE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getEventoFieldConverter().toColumn(Evento.model().ID_TRANSAZIONE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getEventoFieldConverter().toColumn(Evento.model().ID_CONFIGURAZIONE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getEventoFieldConverter().toColumn(Evento.model().CONFIGURAZIONE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getEventoFieldConverter().toColumn(Evento.model().CLUSTER_ID, false), "?");
        IKeyGeneratorObject keyGenerator = this.getEventoFetch().getKeyGeneratorObject((IModel<?>)Evento.model());
        long id = jdbcUtilities.insertAndReturnGeneratedKey(sqlQueryObjectInsert, keyGenerator, jdbcProperties.isShowSql(), new JDBCObject[]{new JDBCObject((Object)evento.getTipo(), Evento.model().TIPO.getFieldType()), new JDBCObject((Object)evento.getCodice(), Evento.model().CODICE.getFieldType()), new JDBCObject((Object)evento.getSeverita(), Evento.model().SEVERITA.getFieldType()), new JDBCObject((Object)evento.getOraRegistrazione(), Evento.model().ORA_REGISTRAZIONE.getFieldType()), new JDBCObject((Object)evento.getDescrizione(), Evento.model().DESCRIZIONE.getFieldType()), new JDBCObject((Object)evento.getIdTransazione(), Evento.model().ID_TRANSAZIONE.getFieldType()), new JDBCObject((Object)evento.getIdConfigurazione(), Evento.model().ID_CONFIGURAZIONE.getFieldType()), new JDBCObject((Object)evento.getConfigurazione(), Evento.model().CONFIGURAZIONE.getFieldType()), new JDBCObject((Object)evento.getClusterId(), Evento.model().CLUSTER_ID.getFieldType())});
        evento.setId(id);
    }

    public void update(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Evento evento, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        Long tableId = evento.getId();
        if (tableId == null || tableId <= 0L) {
            throw new Exception("Retrieve tableId failed");
        }
        this.update(jdbcProperties, log, connection, sqlQueryObject, (long)tableId, evento, idMappingResolutionBehaviour);
    }

    public void update(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, Evento evento, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        if (NullByteTextColumnSanitizer.needsSanitization((TipiDatabase)jdbcProperties.getDatabase())) {
            JDBCEventoServiceImpl.sanitizeTextColumns(jdbcProperties.getDatabase(), evento);
        }
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        ISQLQueryObject sqlQueryObjectInsert = sqlQueryObject.newSQLQueryObject();
        ISQLQueryObject sqlQueryObjectDelete = sqlQueryObjectInsert.newSQLQueryObject();
        ISQLQueryObject sqlQueryObjectGet = sqlQueryObjectDelete.newSQLQueryObject();
        ISQLQueryObject sqlQueryObjectUpdate = sqlQueryObjectGet.newSQLQueryObject();
        sqlQueryObjectUpdate.setANDLogicOperator(true);
        sqlQueryObjectUpdate.addUpdateTable(this.getEventoFieldConverter().toTable((IModel)Evento.model()));
        boolean isUpdate_evento = true;
        ArrayList<JDBCObject> lstObjects_evento = new ArrayList<JDBCObject>();
        sqlQueryObjectUpdate.addUpdateField(this.getEventoFieldConverter().toColumn(Evento.model().TIPO, false), "?");
        lstObjects_evento.add(new JDBCObject((Object)evento.getTipo(), Evento.model().TIPO.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getEventoFieldConverter().toColumn(Evento.model().CODICE, false), "?");
        lstObjects_evento.add(new JDBCObject((Object)evento.getCodice(), Evento.model().CODICE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getEventoFieldConverter().toColumn(Evento.model().SEVERITA, false), "?");
        lstObjects_evento.add(new JDBCObject((Object)evento.getSeverita(), Evento.model().SEVERITA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getEventoFieldConverter().toColumn(Evento.model().ORA_REGISTRAZIONE, false), "?");
        lstObjects_evento.add(new JDBCObject((Object)evento.getOraRegistrazione(), Evento.model().ORA_REGISTRAZIONE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getEventoFieldConverter().toColumn(Evento.model().DESCRIZIONE, false), "?");
        lstObjects_evento.add(new JDBCObject((Object)evento.getDescrizione(), Evento.model().DESCRIZIONE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getEventoFieldConverter().toColumn(Evento.model().ID_TRANSAZIONE, false), "?");
        lstObjects_evento.add(new JDBCObject((Object)evento.getIdTransazione(), Evento.model().ID_TRANSAZIONE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getEventoFieldConverter().toColumn(Evento.model().ID_CONFIGURAZIONE, false), "?");
        lstObjects_evento.add(new JDBCObject((Object)evento.getIdConfigurazione(), Evento.model().ID_CONFIGURAZIONE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getEventoFieldConverter().toColumn(Evento.model().CONFIGURAZIONE, false), "?");
        lstObjects_evento.add(new JDBCObject((Object)evento.getConfigurazione(), Evento.model().CONFIGURAZIONE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getEventoFieldConverter().toColumn(Evento.model().CLUSTER_ID, false), "?");
        lstObjects_evento.add(new JDBCObject((Object)evento.getClusterId(), Evento.model().CLUSTER_ID.getFieldType()));
        sqlQueryObjectUpdate.addWhereCondition("id=?");
        lstObjects_evento.add(new JDBCObject((Object)tableId, Long.class));
        if (isUpdate_evento) {
            jdbcUtilities.executeUpdate(sqlQueryObjectUpdate.createSQLUpdate(), jdbcProperties.isShowSql(), lstObjects_evento.toArray(new JDBCObject[0]));
        }
    }

    public void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Evento evento, UpdateField ... updateFields) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        GenericJDBCUtilities.updateFields((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)this.getEventoFieldConverter().toTable((IModel)Evento.model()), this.getMapTableToPKColumnEngine(), this.getRootTablePrimaryKeyValuesEngine(jdbcProperties, log, connection, sqlQueryObject, evento), (ISQLFieldConverter)this.getEventoFieldConverter(), (IJDBCServiceSearchWithoutId)this, null, (UpdateField[])updateFields);
    }

    public void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Evento evento, IExpression condition, UpdateField ... updateFields) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        GenericJDBCUtilities.updateFields((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)this.getEventoFieldConverter().toTable((IModel)Evento.model()), this.getMapTableToPKColumnEngine(), this.getRootTablePrimaryKeyValuesEngine(jdbcProperties, log, connection, sqlQueryObject, evento), (ISQLFieldConverter)this.getEventoFieldConverter(), (IJDBCServiceSearchWithoutId)this, (IExpression)condition, (UpdateField[])updateFields);
    }

    public void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Evento evento, UpdateModel ... updateModels) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        GenericJDBCUtilities.updateFields((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)this.getEventoFieldConverter().toTable((IModel)Evento.model()), this.getMapTableToPKColumnEngine(), this.getRootTablePrimaryKeyValuesEngine(jdbcProperties, log, connection, sqlQueryObject, evento), (ISQLFieldConverter)this.getEventoFieldConverter(), (IJDBCServiceSearchWithoutId)this, (UpdateModel[])updateModels);
    }

    public void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, UpdateField ... updateFields) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(tableId);
        GenericJDBCUtilities.updateFields((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)this.getEventoFieldConverter().toTable((IModel)Evento.model()), this.getMapTableToPKColumnEngine(), ids, (ISQLFieldConverter)this.getEventoFieldConverter(), (IJDBCServiceSearchWithoutId)this, null, (UpdateField[])updateFields);
    }

    public void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, IExpression condition, UpdateField ... updateFields) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(tableId);
        GenericJDBCUtilities.updateFields((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)this.getEventoFieldConverter().toTable((IModel)Evento.model()), this.getMapTableToPKColumnEngine(), ids, (ISQLFieldConverter)this.getEventoFieldConverter(), (IJDBCServiceSearchWithoutId)this, (IExpression)condition, (UpdateField[])updateFields);
    }

    public void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, UpdateModel ... updateModels) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(tableId);
        GenericJDBCUtilities.updateFields((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)this.getEventoFieldConverter().toTable((IModel)Evento.model()), this.getMapTableToPKColumnEngine(), ids, (ISQLFieldConverter)this.getEventoFieldConverter(), (IJDBCServiceSearchWithoutId)this, (UpdateModel[])updateModels);
    }

    public void updateOrCreate(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Evento evento, IDMappingBehaviour idMappingResolutionBehaviour) throws NotImplementedException, ServiceException, Exception {
        Long id = evento.getId();
        if (id != null && this.exists(jdbcProperties, log, connection, sqlQueryObject, id)) {
            this.update(jdbcProperties, log, connection, sqlQueryObject, evento, idMappingResolutionBehaviour);
        } else {
            this.create(jdbcProperties, log, connection, sqlQueryObject, evento, idMappingResolutionBehaviour);
        }
    }

    public void updateOrCreate(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, Evento evento, IDMappingBehaviour idMappingResolutionBehaviour) throws NotImplementedException, ServiceException, Exception {
        if (this.exists(jdbcProperties, log, connection, sqlQueryObject, tableId)) {
            this.update(jdbcProperties, log, connection, sqlQueryObject, tableId, evento, idMappingResolutionBehaviour);
        } else {
            this.create(jdbcProperties, log, connection, sqlQueryObject, evento, idMappingResolutionBehaviour);
        }
    }

    public void delete(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Evento evento) throws NotImplementedException, ServiceException, Exception {
        Long longId = null;
        if (evento.getId() == null) {
            throw new Exception("Parameter " + evento.getClass().getName() + ".id is null");
        }
        if (evento.getId() <= 0L) {
            throw new Exception("Parameter " + evento.getClass().getName() + ".id is less equals 0");
        }
        longId = evento.getId();
        this.deleteEngine(jdbcProperties, log, connection, sqlQueryObject, longId);
    }

    private void deleteEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Long id) throws NotImplementedException, ServiceException, Exception {
        if (id != null && id <= 0L) {
            throw new ServiceException("Id is less equals 0");
        }
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        ISQLQueryObject sqlQueryObjectDelete = sqlQueryObject.newSQLQueryObject();
        sqlQueryObjectDelete.setANDLogicOperator(true);
        sqlQueryObjectDelete.addDeleteTable(this.getEventoFieldConverter().toTable((IModel)Evento.model()));
        if (id != null) {
            sqlQueryObjectDelete.addWhereCondition("id=?");
        }
        jdbcUtilities.execute(sqlQueryObjectDelete.createSQLDelete(), jdbcProperties.isShowSql(), new JDBCObject[]{new JDBCObject((Object)id, Long.class)});
    }

    public NonNegativeNumber deleteAll(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject) throws NotImplementedException, ServiceException, Exception {
        return this.deleteAll(jdbcProperties, log, connection, sqlQueryObject, new JDBCExpression((ISQLFieldConverter)this.getEventoFieldConverter()));
    }

    public NonNegativeNumber deleteAll(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression) throws NotImplementedException, ServiceException, Exception {
        List<Long> lst = this.findAllTableIds(jdbcProperties, log, connection, sqlQueryObject, new JDBCPaginatedExpression(expression));
        for (Long id : lst) {
            this.deleteEngine(jdbcProperties, log, connection, sqlQueryObject, id);
        }
        return new NonNegativeNumber((long)lst.size());
    }

    public void deleteById(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId) throws ServiceException, NotImplementedException, Exception {
        this.deleteEngine(jdbcProperties, log, connection, sqlQueryObject, tableId);
    }

    public int nativeUpdate(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlObject, String sql, Object ... param) throws ServiceException, NotImplementedException, Exception {
        return GenericJDBCUtilities.nativeUpdate((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlObject, (String)sql, (Object[])param);
    }
}

