/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.integrazione.utils.serializer;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import javax.xml.bind.JAXBElement;
import org.openspcoop2.core.integrazione.EsitoRichiesta;
import org.openspcoop2.generic_project.exception.SerializerException;
import org.openspcoop2.utils.beans.WriteToSerializerType;
import org.openspcoop2.utils.xml.JaxbUtils;

public abstract class AbstractSerializer {
    protected abstract WriteToSerializerType getType();

    protected void _objToXml(OutputStream out, Class<?> c, Object object, boolean prettyPrint) throws Exception {
        if (object instanceof JAXBElement) {
            JaxbUtils.objToXml((OutputStream)out, c, (Object)object, (boolean)prettyPrint);
        } else {
            Method m = c.getMethod("writeTo", OutputStream.class, WriteToSerializerType.class);
            m.invoke(object, out, this.getType());
        }
    }

    protected void objToXml(OutputStream out, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        try {
            this._objToXml(out, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                out.flush();
            }
            catch (Exception exception) {}
        }
    }

    protected void objToXml(String fileName, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        try {
            this.objToXml(new File(fileName), c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
    }

    protected void objToXml(File file, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            this._objToXml(fout, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.flush();
                }
            }
            catch (Exception exception) {}
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected ByteArrayOutputStream objToXml(Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        ByteArrayOutputStream bout = null;
        try {
            bout = new ByteArrayOutputStream();
            this._objToXml(bout, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (bout != null) {
                    bout.flush();
                }
            }
            catch (Exception exception) {}
            try {
                if (bout != null) {
                    bout.close();
                }
            }
            catch (Exception exception) {}
        }
        return bout;
    }

    public void write(String fileName, EsitoRichiesta esitoRichiesta) throws SerializerException {
        this.objToXml(fileName, EsitoRichiesta.class, (Object)esitoRichiesta, false);
    }

    public void write(String fileName, EsitoRichiesta esitoRichiesta, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, EsitoRichiesta.class, (Object)esitoRichiesta, prettyPrint);
    }

    public void write(File file, EsitoRichiesta esitoRichiesta) throws SerializerException {
        this.objToXml(file, EsitoRichiesta.class, (Object)esitoRichiesta, false);
    }

    public void write(File file, EsitoRichiesta esitoRichiesta, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, EsitoRichiesta.class, (Object)esitoRichiesta, prettyPrint);
    }

    public void write(OutputStream out, EsitoRichiesta esitoRichiesta) throws SerializerException {
        this.objToXml(out, EsitoRichiesta.class, (Object)esitoRichiesta, false);
    }

    public void write(OutputStream out, EsitoRichiesta esitoRichiesta, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, EsitoRichiesta.class, (Object)esitoRichiesta, prettyPrint);
    }

    public byte[] toByteArray(EsitoRichiesta esitoRichiesta) throws SerializerException {
        return this.objToXml(EsitoRichiesta.class, esitoRichiesta, false).toByteArray();
    }

    public byte[] toByteArray(EsitoRichiesta esitoRichiesta, boolean prettyPrint) throws SerializerException {
        return this.objToXml(EsitoRichiesta.class, esitoRichiesta, prettyPrint).toByteArray();
    }

    public String toString(EsitoRichiesta esitoRichiesta) throws SerializerException {
        return this.objToXml(EsitoRichiesta.class, esitoRichiesta, false).toString();
    }

    public String toString(EsitoRichiesta esitoRichiesta, boolean prettyPrint) throws SerializerException {
        return this.objToXml(EsitoRichiesta.class, esitoRichiesta, prettyPrint).toString();
    }
}

