/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.plugins.utils;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.plugins.IdPlugin;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.core.plugins.dao.IPluginService;
import org.openspcoop2.core.plugins.dao.IPluginServiceSearch;
import org.openspcoop2.core.plugins.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.plugins.dao.jdbc.converter.PluginFieldConverter;
import org.openspcoop2.core.plugins.utils.FilterUtils;
import org.openspcoop2.generic_project.beans.AliasTableComplexField;
import org.openspcoop2.generic_project.beans.ComplexField;
import org.openspcoop2.generic_project.beans.CustomField;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.IModel;
import org.openspcoop2.generic_project.beans.NonNegativeNumber;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.expression.LikeMode;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.slf4j.Logger;

public class PluginsDriverUtils {
    private PluginsDriverUtils() {
    }

    private static void logDebug(Logger log, String msg) {
        if (log != null) {
            log.debug(msg);
        }
    }

    public static int numeroPluginsClassiList(Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "numeroPluginsClassiList";
        int val = 0;
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager jdbcServiceManagerMonitorEngineConfig = new JDBCServiceManager(con, properties, log);
            IPluginServiceSearch pluginServiceSearch = jdbcServiceManagerMonitorEngineConfig.getPluginServiceSearch();
            IExpression expr = pluginServiceSearch.newExpression();
            NonNegativeNumber count = pluginServiceSearch.count(expr);
            if (count != null) {
                val = (int)count.longValue();
            }
            return val;
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] failed : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static List<Plugin> pluginsClassiList(ISearch ricerca, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "pluginsClassiList";
        int idLista = Liste.CONFIGURAZIONE_PLUGINS_CLASSI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        String filterTipoPlugin = SearchUtils.getFilter(ricerca, idLista, "filtroTipoPluginClassi");
        String filterStato = SearchUtils.getFilter(ricerca, idLista, "filtroStato");
        PluginsDriverUtils.logDebug(log, "search : " + search);
        PluginsDriverUtils.logDebug(log, "filterTipoPlugin : " + filterTipoPlugin);
        PluginsDriverUtils.logDebug(log, "filterStato : " + filterStato);
        ArrayList<Plugin> lista = new ArrayList();
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager jdbcServiceManagerMonitorEngineConfig = new JDBCServiceManager(con, properties, log);
            IPluginServiceSearch pluginServiceSearch = jdbcServiceManagerMonitorEngineConfig.getPluginServiceSearch();
            IExpression expr = pluginServiceSearch.newExpression();
            boolean addAnd = false;
            if (!search.equals("")) {
                IExpression exprLabel = pluginServiceSearch.newExpression();
                exprLabel.ilike(Plugin.model().LABEL, search, LikeMode.ANYWHERE);
                IExpression exprTipo = pluginServiceSearch.newExpression();
                exprTipo.ilike(Plugin.model().TIPO, search, LikeMode.ANYWHERE);
                expr.or(exprLabel, exprTipo);
                addAnd = true;
            }
            if (filterStato != null && !filterStato.equals("") && ("Abilitato".equals(filterStato) || "Disabilitato".equals(filterStato))) {
                if (addAnd) {
                    expr.and();
                }
                addAnd = true;
                expr.equals(Plugin.model().STATO, (Object)"Abilitato".equals(filterStato));
            }
            if (!filterTipoPlugin.equals("")) {
                if (addAnd) {
                    expr.and();
                }
                expr.equals(Plugin.model().TIPO_PLUGIN, (Object)filterTipoPlugin);
                TipoPlugin tipoPlugin = TipoPlugin.toEnumConstant(filterTipoPlugin);
                switch (tipoPlugin) {
                    case AUTENTICAZIONE: 
                    case AUTORIZZAZIONE: 
                    case AUTORIZZAZIONE_CONTENUTI: 
                    case INTEGRAZIONE: {
                        String filtroRuolo = SearchUtils.getFilter(ricerca, idLista, "Ruolo");
                        PluginsDriverUtils.logDebug(log, "filtroRuolo : " + filtroRuolo);
                        if (filtroRuolo.equals("")) break;
                        expr.equals(Plugin.model().PLUGIN_PROPRIETA_COMPATIBILITA.NOME, (Object)"Ruolo");
                        expr.and();
                        IExpression exprOr = pluginServiceSearch.newExpression();
                        exprOr.equals(Plugin.model().PLUGIN_PROPRIETA_COMPATIBILITA.VALORE, (Object)filtroRuolo);
                        exprOr.or();
                        exprOr.equals(Plugin.model().PLUGIN_PROPRIETA_COMPATIBILITA.VALORE, (Object)"Qualsiasi");
                        expr.and(new IExpression[]{exprOr});
                        break;
                    }
                    case SERVICE_HANDLER: {
                        String filtroShTipo = SearchUtils.getFilter(ricerca, idLista, "ServiceHandler");
                        PluginsDriverUtils.logDebug(log, "filtroShTipo : " + filtroShTipo);
                        if (filtroShTipo.equals("")) break;
                        expr.equals(Plugin.model().PLUGIN_PROPRIETA_COMPATIBILITA.NOME, (Object)"ServiceHandler").and().equals(Plugin.model().PLUGIN_PROPRIETA_COMPATIBILITA.VALORE, (Object)filtroShTipo);
                        break;
                    }
                    case MESSAGE_HANDLER: {
                        boolean tipoDefined;
                        String filtroMhRuolo = SearchUtils.getFilter(ricerca, idLista, "RuoloMessageHandler");
                        PluginsDriverUtils.logDebug(log, "filtroMhRuolo : " + filtroMhRuolo);
                        boolean ruoloDefined = !filtroMhRuolo.equals("");
                        String filtroMhTipo = SearchUtils.getFilter(ricerca, idLista, "FaseMessageHandler");
                        PluginsDriverUtils.logDebug(log, "filtroMhTipo : " + filtroMhTipo);
                        boolean bl = tipoDefined = !filtroMhTipo.equals("");
                        if (tipoDefined && ruoloDefined) {
                            AliasTableComplexField ruoloName = new AliasTableComplexField((ComplexField)Plugin.model().PLUGIN_PROPRIETA_COMPATIBILITA.NOME, FilterUtils.getNextAliasPluginsTable());
                            AliasTableComplexField ruoloValore = new AliasTableComplexField((ComplexField)Plugin.model().PLUGIN_PROPRIETA_COMPATIBILITA.VALORE, ruoloName.getAliasTable());
                            AliasTableComplexField tipoName = new AliasTableComplexField((ComplexField)Plugin.model().PLUGIN_PROPRIETA_COMPATIBILITA.NOME, FilterUtils.getNextAliasPluginsTable());
                            AliasTableComplexField tipoValore = new AliasTableComplexField((ComplexField)Plugin.model().PLUGIN_PROPRIETA_COMPATIBILITA.VALORE, tipoName.getAliasTable());
                            expr.and().equals((IField)ruoloName, (Object)"RuoloMessageHandler").equals((IField)ruoloValore, (Object)filtroMhRuolo).equals((IField)tipoName, (Object)"FaseMessageHandler").equals((IField)tipoValore, (Object)filtroMhTipo);
                            break;
                        }
                        if (tipoDefined) {
                            expr.equals(Plugin.model().PLUGIN_PROPRIETA_COMPATIBILITA.NOME, (Object)"FaseMessageHandler").and().equals(Plugin.model().PLUGIN_PROPRIETA_COMPATIBILITA.VALORE, (Object)filtroMhTipo);
                            break;
                        }
                        if (!ruoloDefined) break;
                        expr.equals(Plugin.model().PLUGIN_PROPRIETA_COMPATIBILITA.NOME, (Object)"RuoloMessageHandler").and().equals(Plugin.model().PLUGIN_PROPRIETA_COMPATIBILITA.VALORE, (Object)filtroMhRuolo);
                        break;
                    }
                    case ALLARME: {
                        String filtroApplicabilita = SearchUtils.getFilter(ricerca, idLista, "Applicabilita");
                        PluginsDriverUtils.logDebug(log, "filtroApplicabilita : " + filtroApplicabilita);
                        if (filtroApplicabilita.equals("")) break;
                        expr.equals(Plugin.model().PLUGIN_PROPRIETA_COMPATIBILITA.NOME, (Object)"Applicabilita");
                        expr.and();
                        IExpression exprOr = pluginServiceSearch.newExpression();
                        exprOr.equals(Plugin.model().PLUGIN_PROPRIETA_COMPATIBILITA.VALORE, (Object)filtroApplicabilita);
                        exprOr.or();
                        exprOr.equals(Plugin.model().PLUGIN_PROPRIETA_COMPATIBILITA.VALORE, (Object)"Qualsiasi");
                        if ("Erogazione".equals(filtroApplicabilita) || "Fruizione".equals(filtroApplicabilita)) {
                            exprOr.equals(Plugin.model().PLUGIN_PROPRIETA_COMPATIBILITA.VALORE, (Object)"ImplementazioneApi");
                        }
                        expr.and(new IExpression[]{exprOr});
                        break;
                    }
                }
            }
            NonNegativeNumber count = pluginServiceSearch.count(expr);
            ricerca.setNumEntries(idLista, (int)count.longValue());
            if (limit == 0) {
                limit = 1000;
            }
            IPaginatedExpression pagExpr = pluginServiceSearch.toPaginatedExpression(expr);
            pagExpr.limit(limit).offset(offset);
            pagExpr.addOrder(Plugin.model().TIPO_PLUGIN, SortOrder.ASC);
            pagExpr.addOrder(Plugin.model().LABEL, SortOrder.ASC);
            lista = pluginServiceSearch.findAll(pagExpr);
            return lista;
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] list failed : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static void createPluginClassi(Plugin plugin, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "createPluginClassi";
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager jdbcServiceManagerMonitorEngineConfig = new JDBCServiceManager(con, properties, log);
            IPluginService pluginService = jdbcServiceManagerMonitorEngineConfig.getPluginService();
            pluginService.create(plugin);
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] create failed : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static void updatePluginClassi(Plugin plugin, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "updatePluginClassi";
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager jdbcServiceManagerMonitorEngineConfig = new JDBCServiceManager(con, properties, log);
            IPluginService pluginService = jdbcServiceManagerMonitorEngineConfig.getPluginService();
            pluginService.update(plugin.getOldIdPlugin(), plugin);
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] update failed : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static void deletePluginClassi(Plugin plugin, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "deletePluginClassi";
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager jdbcServiceManagerMonitorEngineConfig = new JDBCServiceManager(con, properties, log);
            IPluginService pluginService = jdbcServiceManagerMonitorEngineConfig.getPluginService();
            pluginService.delete(plugin);
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] delete failed : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static boolean existsPlugin(TipoPlugin tipoPlugin, String tipo, String label, String className, Connection con, Logger log, String tipoDB) throws ServiceException {
        return PluginsDriverUtils.existsPluginEngine(tipoPlugin, tipo, label, className, con, log, tipoDB);
    }

    public static boolean existsPluginConTipo(TipoPlugin tipoPlugin, String tipo, Connection con, Logger log, String tipoDB) throws ServiceException {
        return PluginsDriverUtils.existsPluginEngine(tipoPlugin, tipo, null, null, con, log, tipoDB);
    }

    public static boolean existsPluginConLabel(TipoPlugin tipoPlugin, String label, Connection con, Logger log, String tipoDB) throws ServiceException {
        return PluginsDriverUtils.existsPluginEngine(tipoPlugin, null, label, null, con, log, tipoDB);
    }

    public static boolean existsPluginConClassName(TipoPlugin tipoPlugin, String className, Connection con, Logger log, String tipoDB) throws ServiceException {
        return PluginsDriverUtils.existsPluginEngine(tipoPlugin, null, null, className, con, log, tipoDB);
    }

    private static boolean existsPluginEngine(TipoPlugin tipoPlugin, String tipo, String label, String className, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "existsPlugin";
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager jdbcServiceManagerMonitorEngineConfig = new JDBCServiceManager(con, properties, log);
            IPluginServiceSearch pluginServiceSearch = jdbcServiceManagerMonitorEngineConfig.getPluginServiceSearch();
            IExpression expr = pluginServiceSearch.newExpression();
            ArrayList<IExpression> list = new ArrayList<IExpression>();
            if (tipo != null) {
                IExpression tipoExp = pluginServiceSearch.newExpression();
                tipoExp.equals(Plugin.model().TIPO_PLUGIN, (Object)tipoPlugin.toString()).and().equals(Plugin.model().TIPO, (Object)tipo);
                list.add(tipoExp);
            }
            if (label != null) {
                IExpression labelExp = pluginServiceSearch.newExpression();
                labelExp.equals(Plugin.model().TIPO_PLUGIN, (Object)tipoPlugin.toString()).and().equals(Plugin.model().LABEL, (Object)label);
                list.add(labelExp);
            }
            if (className != null) {
                IExpression classExp = pluginServiceSearch.newExpression();
                classExp.equals(Plugin.model().TIPO_PLUGIN, (Object)tipoPlugin.toString()).and().equals(Plugin.model().CLASS_NAME, (Object)className);
                list.add(classExp);
            }
            expr.or(list.toArray(new IExpression[list.size()]));
            NonNegativeNumber count = pluginServiceSearch.count(expr);
            return count.longValue() > 0L;
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] check failed : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static Plugin getPlugin(long idPlugin, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "getPlugin";
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager jdbcServiceManagerMonitorEngineConfig = new JDBCServiceManager(con, properties, log);
            IPluginServiceSearch pluginServiceSearch = jdbcServiceManagerMonitorEngineConfig.getPluginServiceSearch();
            IExpression expr = pluginServiceSearch.newExpression();
            PluginFieldConverter converter = new PluginFieldConverter(tipoDB);
            expr.equals((IField)new CustomField("id", Long.class, "id", converter.toTable((IModel)Plugin.model())), (Object)idPlugin);
            Plugin plugin = (Plugin)pluginServiceSearch.find(expr);
            IdPlugin idPluginObj = (IdPlugin)pluginServiceSearch.convertToId(plugin);
            plugin.setOldIdPlugin(idPluginObj);
            return plugin;
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] getById failed : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static Plugin getPlugin(TipoPlugin tipoPlugin, String tipo, boolean throwNotFound, Connection con, Logger log, String tipoDB) throws ServiceException, NotFoundException {
        return PluginsDriverUtils.getPlugin(tipoPlugin.getValue(), tipo, throwNotFound, con, log, tipoDB);
    }

    public static Plugin getPlugin(String tipoPlugin, String tipo, boolean throwNotFound, Connection con, Logger log, String tipoDB) throws ServiceException, NotFoundException {
        String nomeMetodo = "getPlugin";
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager jdbcServiceManagerMonitorEngineConfig = new JDBCServiceManager(con, properties, log);
            IPluginServiceSearch pluginServiceSearch = jdbcServiceManagerMonitorEngineConfig.getPluginServiceSearch();
            IdPlugin idPlugin = new IdPlugin();
            idPlugin.setTipoPlugin(tipoPlugin);
            idPlugin.setTipo(tipo);
            Plugin plugin = (Plugin)pluginServiceSearch.get(idPlugin);
            if (plugin == null) {
                throw new NotFoundException("NotFound");
            }
            IdPlugin idPluginObj = (IdPlugin)pluginServiceSearch.convertToId(plugin);
            plugin.setOldIdPlugin(idPluginObj);
            return plugin;
        }
        catch (NotFoundException notFound) {
            if (throwNotFound) {
                throw new NotFoundException("[" + nomeMetodo + "] get failed : " + notFound.getMessage(), (Throwable)notFound);
            }
            return null;
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] get failed : " + qe.getMessage(), (Throwable)qe);
        }
    }
}

