/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver;

import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.driver.BeanUtilities;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;

public class IDAccordoCooperazioneFactory {
    private static final String ACCORDO_NON_FORNITO = "Accordo non fornito";
    private static IDAccordoCooperazioneFactory factory = null;
    private IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();

    private static synchronized void init() {
        if (factory == null) {
            factory = new IDAccordoCooperazioneFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IDAccordoCooperazioneFactory getInstance() {
        if (factory != null) return factory;
        Class<IDAccordoCooperazioneFactory> clazz = IDAccordoCooperazioneFactory.class;
        synchronized (IDAccordoCooperazioneFactory.class) {
            IDAccordoCooperazioneFactory.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return factory;
        }
    }

    private IDAccordoCooperazioneFactory() {
    }

    private IDAccordoCooperazione build(IDAccordo idAccordo) {
        IDAccordoCooperazione idAccordoCooperazione = new IDAccordoCooperazione();
        idAccordoCooperazione.setNome(idAccordo.getNome());
        idAccordoCooperazione.setSoggettoReferente(idAccordo.getSoggettoReferente());
        idAccordoCooperazione.setVersione(idAccordo.getVersione());
        return idAccordoCooperazione;
    }

    private IDAccordo build(IDAccordoCooperazione idAccordoCooperazione) {
        IDAccordo idAccordo = new IDAccordo();
        idAccordo.setNome(idAccordoCooperazione.getNome());
        idAccordo.setSoggettoReferente(idAccordoCooperazione.getSoggettoReferente());
        idAccordo.setVersione(idAccordoCooperazione.getVersione());
        return idAccordo;
    }

    private IDAccordo build(String nome, IDSoggetto soggettoReferente, int versione) {
        IDAccordo idAccordo = new IDAccordo();
        idAccordo.setNome(nome);
        idAccordo.setSoggettoReferente(soggettoReferente);
        idAccordo.setVersione(versione);
        return idAccordo;
    }

    public String normalizeUri(String uri) throws DriverRegistroServiziException {
        IDAccordoCooperazione idAccordo = this.getIDAccordoFromUri(uri);
        return this.getUriFromIDAccordo(idAccordo);
    }

    public String getUriFromIDAccordo(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException {
        return this.idAccordoFactory.getUriFromIDAccordo(this.build(idAccordo));
    }

    public String getUriFromAccordo(AccordoCooperazione accordo) throws DriverRegistroServiziException {
        if (accordo == null) {
            throw new DriverRegistroServiziException(ACCORDO_NON_FORNITO);
        }
        IDAccordo idAccordo = this.build(accordo.getNome(), BeanUtilities.getSoggettoReferenteID(accordo.getSoggettoReferente()), accordo.getVersione());
        return this.idAccordoFactory.getUriFromIDAccordo(idAccordo);
    }

    public String getUriFromValues(String nomeAS, String tipoSoggettoReferente, String nomeSoggettoReferente, int ver) throws DriverRegistroServiziException {
        if (nomeAS == null) {
            throw new DriverRegistroServiziException(ACCORDO_NON_FORNITO);
        }
        IDSoggetto soggettoReferente = null;
        if (tipoSoggettoReferente != null && nomeSoggettoReferente != null) {
            soggettoReferente = new IDSoggetto(tipoSoggettoReferente, nomeSoggettoReferente);
        }
        IDAccordo idAccordo = this.build(nomeAS, soggettoReferente, ver);
        return this.idAccordoFactory.getUriFromIDAccordo(idAccordo);
    }

    public String getUriFromValues(String nomeAS, IDSoggetto soggettoReferente, int ver) throws DriverRegistroServiziException {
        if (nomeAS == null) {
            throw new DriverRegistroServiziException(ACCORDO_NON_FORNITO);
        }
        if (soggettoReferente == null) {
            return this.getUriFromValues(nomeAS, null, null, ver);
        }
        return this.getUriFromValues(nomeAS, soggettoReferente.getTipo(), soggettoReferente.getNome(), ver);
    }

    public IDAccordoCooperazione getIDAccordoFromUri(String uriAccordo) throws DriverRegistroServiziException {
        return this.build(this.idAccordoFactory.getIDAccordoFromUri(uriAccordo));
    }

    public IDAccordoCooperazione getIDAccordoFromAccordo(AccordoCooperazione accordo) throws DriverRegistroServiziException {
        if (accordo == null) {
            throw new DriverRegistroServiziException(ACCORDO_NON_FORNITO);
        }
        IDAccordo idAccordo = this.build(accordo.getNome(), BeanUtilities.getSoggettoReferenteID(accordo.getSoggettoReferente()), accordo.getVersione());
        return this.build(idAccordo);
    }

    public IDAccordoCooperazione getIDAccordoFromValues(String nomeAS, String tipoSoggettoReferente, String nomeSoggettoReferente, int ver) throws DriverRegistroServiziException {
        if (nomeAS == null) {
            throw new DriverRegistroServiziException(ACCORDO_NON_FORNITO);
        }
        IDSoggetto soggettoReferente = null;
        if (tipoSoggettoReferente != null && nomeSoggettoReferente != null) {
            soggettoReferente = new IDSoggetto(tipoSoggettoReferente, nomeSoggettoReferente);
        }
        IDAccordo idAccordo = this.build(nomeAS, soggettoReferente, ver);
        return this.build(idAccordo);
    }

    public IDAccordoCooperazione getIDAccordoFromValuesWithoutCheck(String nomeAS, String tipoSoggettoReferente, String nomeSoggettoReferente, int ver) {
        IDSoggetto soggettoReferente = new IDSoggetto(tipoSoggettoReferente, nomeSoggettoReferente);
        IDAccordo idAccordo = this.build(nomeAS, soggettoReferente, ver);
        return this.build(idAccordo);
    }

    public IDAccordoCooperazione getIDAccordoFromValues(String nomeAS, IDSoggetto soggettoReferente, int ver) throws DriverRegistroServiziException {
        if (soggettoReferente == null) {
            return this.getIDAccordoFromValues(nomeAS, null, null, ver);
        }
        return this.getIDAccordoFromValues(nomeAS, soggettoReferente.getTipo(), soggettoReferente.getNome(), ver);
    }
}

