/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver;

import org.openspcoop2.core.constants.TipologiaServizio;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.driver.BeanUtilities;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;

public class IDServizioFactory {
    private static final String TIPO_NON_FORNITO = "Tipo non fornito";
    private static final String NOME_NON_FORNITO = "Nome non fornito";
    private static final String SOGGETTO_EROGATORE_NON_FORNITO = "Soggetto erogatore non fornito";
    private static final String TIPO_SOGGETTO_EROGATORE_NON_FORNITO = "Tipo soggetto erogatore non fornito";
    private static final String NOME_SOGGETTO_EROGATORE_NON_FORNITO = "Nome soggetto erogatore non fornito";
    private static final String SINTASSI_NON_CORRETTA = "sintassi non corretta, atteso tipoSoggetto/nomeSoggetto:tipoServizio/nomeServizio:versione";
    private static IDServizioFactory factory = null;

    private static synchronized void init() {
        if (factory == null) {
            factory = new IDServizioFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IDServizioFactory getInstance() {
        if (factory != null) return factory;
        Class<IDServizioFactory> clazz = IDServizioFactory.class;
        synchronized (IDServizioFactory.class) {
            IDServizioFactory.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return factory;
        }
    }

    private IDServizioFactory() {
    }

    private IDServizio build(String tipo, String nome, IDSoggetto soggettoErogatore, int versione) {
        IDServizio idServizio = new IDServizio();
        idServizio.setTipo(tipo);
        idServizio.setNome(nome);
        idServizio.setSoggettoErogatore(soggettoErogatore);
        idServizio.setVersione(versione);
        return idServizio;
    }

    public String normalizeUri(String uri) throws DriverRegistroServiziException {
        IDServizio idServizio = this.getIDServizioFromUri(uri);
        return this.getUriFromIDServizio(idServizio);
    }

    public String getUriFromIDServizio(IDServizio idServizio) throws DriverRegistroServiziException {
        if (idServizio == null) {
            throw new DriverRegistroServiziException("IDServizio non fornito");
        }
        if (idServizio.getTipo() == null) {
            throw new DriverRegistroServiziException(TIPO_NON_FORNITO);
        }
        if (idServizio.getNome() == null) {
            throw new DriverRegistroServiziException(NOME_NON_FORNITO);
        }
        IDSoggetto soggettoErogatore = idServizio.getSoggettoErogatore();
        if (soggettoErogatore == null) {
            throw new DriverRegistroServiziException(SOGGETTO_EROGATORE_NON_FORNITO);
        }
        if (soggettoErogatore.getTipo() == null) {
            throw new DriverRegistroServiziException(TIPO_SOGGETTO_EROGATORE_NON_FORNITO);
        }
        if (soggettoErogatore.getNome() == null) {
            throw new DriverRegistroServiziException(NOME_SOGGETTO_EROGATORE_NON_FORNITO);
        }
        return soggettoErogatore.toString() + ":" + idServizio.getTipo() + "/" + idServizio.getNome() + ":" + idServizio.getVersione();
    }

    public String getUriFromAccordo(AccordoServizioParteSpecifica accordo) throws DriverRegistroServiziException {
        if (accordo == null) {
            throw new DriverRegistroServiziException("Accordo non fornito");
        }
        IDServizio idServizio = this.build(accordo.getTipo(), accordo.getNome(), BeanUtilities.getSoggettoErogatore(accordo), accordo.getVersione());
        return this.getUriFromIDServizio(idServizio);
    }

    public String getUriFromValues(String tipo, String nome, String tipoSoggettoErogatore, String nomeSoggettoErogatore, int ver) throws DriverRegistroServiziException {
        if (tipo == null) {
            throw new DriverRegistroServiziException(TIPO_NON_FORNITO);
        }
        if (nome == null) {
            throw new DriverRegistroServiziException(NOME_NON_FORNITO);
        }
        if (tipoSoggettoErogatore == null) {
            throw new DriverRegistroServiziException(TIPO_SOGGETTO_EROGATORE_NON_FORNITO);
        }
        if (nomeSoggettoErogatore == null) {
            throw new DriverRegistroServiziException(NOME_SOGGETTO_EROGATORE_NON_FORNITO);
        }
        IDSoggetto soggettoErogatore = new IDSoggetto(tipoSoggettoErogatore, nomeSoggettoErogatore);
        IDServizio idServizio = this.build(tipo, nome, soggettoErogatore, ver);
        return this.getUriFromIDServizio(idServizio);
    }

    public String getUriFromValues(String tipo, String nome, IDSoggetto soggettoErogatore, int ver) throws DriverRegistroServiziException {
        if (soggettoErogatore == null) {
            throw new DriverRegistroServiziException(SOGGETTO_EROGATORE_NON_FORNITO);
        }
        return this.getUriFromValues(tipo, nome, soggettoErogatore.getTipo(), soggettoErogatore.getNome(), ver);
    }

    public IDServizio getIDServizioFromUri(String uriAccordo) throws DriverRegistroServiziException {
        try {
            if (uriAccordo == null) {
                throw new DriverRegistroServiziException("Uri accordo non fornita");
            }
            int primoMarcatore = uriAccordo.indexOf(":");
            int secondoMarcatore = -1;
            if (primoMarcatore >= 0) {
                secondoMarcatore = uriAccordo.indexOf(":", primoMarcatore + 1);
            }
            int terzoMarcatore = -1;
            if (secondoMarcatore > 0 && (terzoMarcatore = uriAccordo.indexOf(":", secondoMarcatore + 1)) > 0) {
                throw new DriverRegistroServiziException(SINTASSI_NON_CORRETTA);
            }
            if (primoMarcatore < 0) {
                throw new DriverRegistroServiziException(SINTASSI_NON_CORRETTA);
            }
            if (secondoMarcatore <= 0) {
                throw new DriverRegistroServiziException(SINTASSI_NON_CORRETTA);
            }
            String tmp1 = null;
            String tmp2 = null;
            String tmp3 = null;
            tmp1 = uriAccordo.substring(0, primoMarcatore);
            tmp2 = uriAccordo.substring(primoMarcatore + 1, secondoMarcatore);
            tmp3 = uriAccordo.substring(secondoMarcatore + 1, uriAccordo.length());
            int divisorioSoggettoErogatore = tmp1.indexOf("/");
            if (divisorioSoggettoErogatore <= 0) {
                throw new DriverRegistroServiziException("sintassi del soggetto erogatore non corretta, l'uri deve essere definita con la seguente forma: tipoSoggetto/nomeSoggetto:tipoServizio/nomeServizio:versione");
            }
            String tipoSoggettoErogatore = tmp1.substring(0, divisorioSoggettoErogatore);
            String nomeSoggettoErogatore = tmp1.substring(divisorioSoggettoErogatore + 1, tmp1.length());
            IDSoggetto soggettoErogatore = new IDSoggetto(tipoSoggettoErogatore, nomeSoggettoErogatore);
            int divisorioServizio = tmp2.indexOf("/");
            if (divisorioServizio <= 0) {
                throw new DriverRegistroServiziException("sintassi del servizio non corretta, l'uri deve essere definita con la seguente forma: tipoSoggetto/nomeSoggetto:tipoServizio/nomeServizio:versione");
            }
            String tipoServizio = tmp2.substring(0, divisorioServizio);
            String nomeServizio = tmp2.substring(divisorioServizio + 1, tmp2.length());
            int versione = 1;
            try {
                versione = Integer.parseInt(tmp3);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("sintassi della versione non corretta: " + e.getMessage(), e);
            }
            return this.build(tipoServizio, nomeServizio, soggettoErogatore, versione);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Parsing uriAccordo[" + uriAccordo + "] non riusciuto: " + e.getMessage());
        }
    }

    public IDServizio getIDServizioFromAccordo(AccordoServizioParteSpecifica accordo) throws DriverRegistroServiziException {
        if (accordo == null) {
            throw new DriverRegistroServiziException("Accordo non fornito");
        }
        IDServizio idServizio = this.build(accordo.getTipo(), accordo.getNome(), new IDSoggetto(accordo.getTipoSoggettoErogatore(), accordo.getNomeSoggettoErogatore()), accordo.getVersione());
        if (org.openspcoop2.core.registry.constants.TipologiaServizio.CORRELATO.equals(accordo.getTipologiaServizio())) {
            idServizio.setTipologia(TipologiaServizio.CORRELATO);
        } else {
            idServizio.setTipologia(TipologiaServizio.NORMALE);
        }
        idServizio.setUriAccordoServizioParteComune(accordo.getAccordoServizioParteComune());
        idServizio.setPortType(accordo.getPortType());
        return idServizio;
    }

    public IDServizio getIDServizioFromValues(String tipo, String nome, String tipoSoggettoErogatore, String nomeSoggettoErogatore, int ver) throws DriverRegistroServiziException {
        if (tipo == null) {
            throw new DriverRegistroServiziException(TIPO_NON_FORNITO);
        }
        if (nome == null) {
            throw new DriverRegistroServiziException(NOME_NON_FORNITO);
        }
        if (tipoSoggettoErogatore == null) {
            throw new DriverRegistroServiziException(TIPO_SOGGETTO_EROGATORE_NON_FORNITO);
        }
        if (nomeSoggettoErogatore == null) {
            throw new DriverRegistroServiziException(NOME_SOGGETTO_EROGATORE_NON_FORNITO);
        }
        IDSoggetto soggettoErogatore = new IDSoggetto(tipoSoggettoErogatore, nomeSoggettoErogatore);
        return this.build(tipo, nome, soggettoErogatore, ver);
    }

    public IDServizio getIDServizioFromValuesWithoutCheck(String tipo, String nome, String tipoSoggettoErogatore, String nomeSoggettoErogatore, int ver) {
        IDSoggetto soggettoErogatore = new IDSoggetto(tipoSoggettoErogatore, nomeSoggettoErogatore);
        return this.build(tipo, nome, soggettoErogatore, ver);
    }

    public IDServizio getIDServizioFromValues(String tipo, String nome, IDSoggetto soggettoErogatore, int ver) throws DriverRegistroServiziException {
        if (soggettoErogatore == null) {
            throw new DriverRegistroServiziException(SOGGETTO_EROGATORE_NON_FORNITO);
        }
        IDServizio idServ = this.getIDServizioFromValues(tipo, nome, soggettoErogatore.getTipo(), soggettoErogatore.getNome(), ver);
        idServ.getSoggettoErogatore().setCodicePorta(soggettoErogatore.getCodicePorta());
        return idServ;
    }
}

