/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.List;
import org.openspcoop2.core.byok.IDriverBYOK;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.id.IDGruppo;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.id.IDScope;
import org.openspcoop2.core.mapping.DBProtocolPropertiesUtils;
import org.openspcoop2.core.registry.Gruppo;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.Ruolo;
import org.openspcoop2.core.registry.Scope;
import org.openspcoop2.core.registry.constants.BindingStyle;
import org.openspcoop2.core.registry.constants.BindingUse;
import org.openspcoop2.core.registry.constants.CredenzialeTipo;
import org.openspcoop2.core.registry.constants.FormatoSpecifica;
import org.openspcoop2.core.registry.constants.HttpMethod;
import org.openspcoop2.core.registry.constants.MessageType;
import org.openspcoop2.core.registry.constants.ParameterType;
import org.openspcoop2.core.registry.constants.ProfiloCollaborazione;
import org.openspcoop2.core.registry.constants.RepresentationType;
import org.openspcoop2.core.registry.constants.RepresentationXmlType;
import org.openspcoop2.core.registry.constants.RuoloContesto;
import org.openspcoop2.core.registry.constants.RuoloTipologia;
import org.openspcoop2.core.registry.constants.ScopeContesto;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.constants.StatoFunzionalita;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.slf4j.Logger;

public class DriverRegistroServiziDB_LIB {
    public static Logger log = LoggerWrapperFactory.getLogger((String)"DRIVER_DB_REGISTRO");
    static String tipoDB = null;
    private static boolean initialize = false;

    static void logDebug(String msg) {
        if (log != null) {
            log.debug(msg);
        }
    }

    static void logDebug(String msg, Exception e) {
        if (log != null) {
            log.debug(msg, (Throwable)e);
        }
    }

    static void logError(String msg) {
        if (log != null) {
            log.error(msg);
        }
    }

    static void logError(String msg, Exception e) {
        if (log != null) {
            log.error(msg, (Throwable)e);
        }
    }

    public static void initStaticLogger(Logger aLog) {
        if (!initialize) {
            if (aLog != null) {
                log = aLog;
            }
            initialize = true;
        }
    }

    public static boolean isStaticLoggerInitialized() {
        return initialize;
    }

    public static void setTipoDB(String tipoDatabase) {
        tipoDB = tipoDatabase;
    }

    public static String getValue(StatoFunzionalita funzionalita) {
        if (funzionalita == null) {
            return null;
        }
        return funzionalita.getValue();
    }

    public static String getValue(ProfiloCollaborazione profilo) {
        if (profilo == null) {
            return null;
        }
        return profilo.getValue();
    }

    public static String getValue(BindingStyle style) {
        if (style == null) {
            return null;
        }
        return style.getValue();
    }

    public static String getValue(BindingUse use) {
        if (use == null) {
            return null;
        }
        return use.getValue();
    }

    public static String getValue(CredenzialeTipo tipo) {
        if (tipo == null) {
            return null;
        }
        return tipo.getValue();
    }

    public static String getValue(ServiceBinding tipo) {
        if (tipo == null) {
            return null;
        }
        return tipo.getValue();
    }

    public static String getValue(MessageType tipo) {
        if (tipo == null) {
            return null;
        }
        return tipo.getValue();
    }

    public static String getValue(HttpMethod tipo) {
        if (tipo == null) {
            return "ALL";
        }
        return tipo.getValue();
    }

    public static String getValue(FormatoSpecifica tipo) {
        if (tipo == null) {
            return null;
        }
        return tipo.getValue();
    }

    public static String getValue(RepresentationType tipo) {
        if (tipo == null) {
            return null;
        }
        return tipo.getValue();
    }

    public static String getValue(RepresentationXmlType tipo) {
        if (tipo == null) {
            return null;
        }
        return tipo.getValue();
    }

    public static String getValue(ParameterType tipo) {
        if (tipo == null) {
            return null;
        }
        return tipo.getValue();
    }

    public static StatoFunzionalita getEnumStatoFunzionalita(String value) {
        if (value == null) {
            return null;
        }
        return StatoFunzionalita.toEnumConstant(value);
    }

    public static ProfiloCollaborazione getEnumProfiloCollaborazione(String value) {
        if (value == null) {
            return null;
        }
        return ProfiloCollaborazione.toEnumConstant(value);
    }

    public static BindingStyle getEnumBindingStyle(String value) {
        if (value == null) {
            return null;
        }
        return BindingStyle.toEnumConstant(value);
    }

    public static BindingUse getEnumBindingUse(String value) {
        if (value == null) {
            return null;
        }
        return BindingUse.toEnumConstant(value);
    }

    public static CredenzialeTipo getEnumCredenzialeTipo(String value) {
        if (value == null) {
            return null;
        }
        return CredenzialeTipo.toEnumConstant(value);
    }

    public static ServiceBinding getEnumServiceBinding(String value) {
        if (value == null) {
            return null;
        }
        return ServiceBinding.toEnumConstant(value);
    }

    public static MessageType getEnumMessageType(String value) {
        if (value == null) {
            return null;
        }
        return MessageType.toEnumConstant(value);
    }

    public static HttpMethod getEnumHttpMethod(String value) {
        if (value == null || "ALL".equalsIgnoreCase(value)) {
            return null;
        }
        return HttpMethod.toEnumConstant(value);
    }

    public static FormatoSpecifica getEnumFormatoSpecifica(String value) {
        if (value == null) {
            return null;
        }
        return FormatoSpecifica.toEnumConstant(value);
    }

    public static RepresentationType getEnumRepresentationType(String value) {
        if (value == null) {
            return null;
        }
        return RepresentationType.toEnumConstant(value);
    }

    public static RepresentationXmlType getEnumRepresentationXmlType(String value) {
        if (value == null) {
            return null;
        }
        return RepresentationXmlType.toEnumConstant(value);
    }

    public static ParameterType getEnumParameterType(String value) {
        if (value == null) {
            return null;
        }
        return ParameterType.toEnumConstant(value);
    }

    public static String formatSQLString(String sql, Object ... params) {
        String res = sql;
        for (int i = 0; i < params.length; ++i) {
            res = res.replaceFirst("\\?", "{" + i + "}");
        }
        return MessageFormat.format(res, params);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void CRUDGruppo(int type, Gruppo gruppo, Connection con) throws DriverRegistroServiziException {
        if (gruppo == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDGruppo] Parametro non valido.");
        }
        String nome = gruppo.getNome();
        String descrizione = gruppo.getDescrizione();
        ServiceBinding serviceBinding = gruppo.getServiceBinding();
        String superuser = gruppo.getSuperUser();
        PreparedStatement updateStmt = null;
        String updateQuery = "";
        PreparedStatement selectStmt = null;
        String selectQuery = "";
        ResultSet selectRS = null;
        int n = 0;
        try {
            switch (type) {
                case 1: {
                    String utenteRichiedente = null;
                    utenteRichiedente = gruppo.getProprietaOggetto() != null && gruppo.getProprietaOggetto().getUtenteRichiedente() != null ? gruppo.getProprietaOggetto().getUtenteRichiedente() : superuser;
                    Timestamp dataCreazione = null;
                    dataCreazione = gruppo.getProprietaOggetto() != null && gruppo.getProprietaOggetto().getDataCreazione() != null ? new Timestamp(gruppo.getProprietaOggetto().getDataCreazione().getTime()) : (gruppo.getOraRegistrazione() != null ? new Timestamp(gruppo.getOraRegistrazione().getTime()) : DateManager.getTimestamp());
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addInsertTable("gruppi");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("descrizione", "?");
                    sqlQueryObject.addInsertField("service_binding", "?");
                    sqlQueryObject.addInsertField("superuser", "?");
                    if (gruppo.getOraRegistrazione() != null) {
                        sqlQueryObject.addInsertField("ora_registrazione", "?");
                    }
                    if (utenteRichiedente != null) {
                        sqlQueryObject.addInsertField("utente_richiedente", "?");
                    }
                    if (dataCreazione != null) {
                        sqlQueryObject.addInsertField("data_creazione", "?");
                    }
                    updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    int index = 1;
                    updateStmt.setString(index++, nome);
                    updateStmt.setString(index++, descrizione);
                    updateStmt.setString(index++, serviceBinding != null ? serviceBinding.getValue() : null);
                    updateStmt.setString(index++, superuser);
                    if (gruppo.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(index++, new Timestamp(gruppo.getOraRegistrazione().getTime()));
                    }
                    if (utenteRichiedente != null) {
                        updateStmt.setString(index++, utenteRichiedente);
                    }
                    if (dataCreazione != null) {
                        updateStmt.setTimestamp(index++, dataCreazione);
                    }
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDGruppo type = " + type + " row affected =" + n);
                    DriverRegistroServiziDB_LIB.logDebug("CRUDGruppo CREATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, nome, descrizione, serviceBinding != null ? serviceBinding.getValue() : null, superuser));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addFromTable("gruppi");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("nome = ?");
                    selectQuery = sqlQueryObject.createSQLQuery();
                    selectStmt = con.prepareStatement(selectQuery);
                    selectStmt.setString(1, nome);
                    selectRS = selectStmt.executeQuery();
                    if (selectRS.next()) {
                        gruppo.setId(selectRS.getLong("id"));
                    }
                    selectRS.close();
                    selectStmt.close();
                    return;
                }
                case 2: {
                    IDGruppo idG;
                    long idGruppo;
                    String nomeGruppo;
                    String string = nomeGruppo = gruppo.getOldIDGruppoForUpdate() != null ? gruppo.getOldIDGruppoForUpdate().getNome() : null;
                    if (nomeGruppo == null || "".equals(nomeGruppo)) {
                        nomeGruppo = gruppo.getNome();
                    }
                    if ((idGruppo = DBUtils.getIdGruppo(idG = new IDGruppo(nomeGruppo), con, tipoDB)) <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDGruppo(UPDATE)] Id Gruppo non valido.");
                    }
                    String utenteUltimaModifica = null;
                    utenteUltimaModifica = gruppo.getProprietaOggetto() != null && gruppo.getProprietaOggetto().getUtenteUltimaModifica() != null ? gruppo.getProprietaOggetto().getUtenteUltimaModifica() : superuser;
                    Timestamp dataUltimaModifica = null;
                    dataUltimaModifica = gruppo.getProprietaOggetto() != null && gruppo.getProprietaOggetto().getDataUltimaModifica() != null ? new Timestamp(gruppo.getProprietaOggetto().getDataUltimaModifica().getTime()) : DateManager.getTimestamp();
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addUpdateTable("gruppi");
                    sqlQueryObject.addUpdateField("nome", "?");
                    sqlQueryObject.addUpdateField("descrizione", "?");
                    sqlQueryObject.addUpdateField("service_binding", "?");
                    sqlQueryObject.addUpdateField("superuser", "?");
                    if (gruppo.getOraRegistrazione() != null) {
                        sqlQueryObject.addUpdateField("ora_registrazione", "?");
                    }
                    if (utenteUltimaModifica != null) {
                        sqlQueryObject.addUpdateField("utente_ultima_modifica", "?");
                    }
                    if (dataUltimaModifica != null) {
                        sqlQueryObject.addUpdateField("data_ultima_modifica", "?");
                    }
                    sqlQueryObject.addWhereCondition("id=?");
                    updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    int index = 1;
                    updateStmt.setString(index++, nome);
                    updateStmt.setString(index++, descrizione);
                    updateStmt.setString(index++, serviceBinding != null ? serviceBinding.getValue() : null);
                    updateStmt.setString(index++, superuser);
                    if (gruppo.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(index++, new Timestamp(gruppo.getOraRegistrazione().getTime()));
                    }
                    if (utenteUltimaModifica != null) {
                        updateStmt.setString(index++, utenteUltimaModifica);
                    }
                    if (dataUltimaModifica != null) {
                        updateStmt.setTimestamp(index++, dataUltimaModifica);
                    }
                    updateStmt.setLong(index++, idGruppo);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDGruppo type = " + type + " row affected =" + n);
                    DriverRegistroServiziDB_LIB.logDebug("CRUDGruppo UPDATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, nome, descrizione, serviceBinding != null ? serviceBinding.getValue() : null, superuser, idGruppo));
                    return;
                }
                case 3: {
                    IDGruppo idG = new IDGruppo(nome);
                    long idGruppo = DBUtils.getIdGruppo(idG, con, tipoDB);
                    if (idGruppo <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDGruppo(DELETE)] Id Gruppo non valido.");
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("gruppi");
                    sqlQueryObject.addWhereCondition("id=?");
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idGruppo);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDGruppo type = " + type + " row affected =" + n);
                    DriverRegistroServiziDB_LIB.logDebug("CRUDGruppo DELETE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, idGruppo));
                    return;
                }
            }
            return;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverControlStationDB_LIB::CRUDGruppo] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverControlStationDB_LIB::CRUDGruppo] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            JDBCUtilities.closeResources(updateStmt);
            JDBCUtilities.closeResources(selectRS, selectStmt);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void CRUDRuolo(int type, Ruolo ruolo, Connection con) throws DriverRegistroServiziException {
        if (ruolo == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDRuolo] Parametro non valido.");
        }
        String nome = ruolo.getNome();
        String descrizione = ruolo.getDescrizione();
        RuoloTipologia ruoloTipologia = ruolo.getTipologia();
        String nomeEsterno = ruolo.getNomeEsterno();
        RuoloContesto ruoloContesto = ruolo.getContestoUtilizzo();
        String superuser = ruolo.getSuperUser();
        PreparedStatement updateStmt = null;
        String updateQuery = "";
        PreparedStatement selectStmt = null;
        String selectQuery = "";
        ResultSet selectRS = null;
        int n = 0;
        try {
            switch (type) {
                case 1: {
                    String utenteRichiedente = null;
                    utenteRichiedente = ruolo.getProprietaOggetto() != null && ruolo.getProprietaOggetto().getUtenteRichiedente() != null ? ruolo.getProprietaOggetto().getUtenteRichiedente() : superuser;
                    Timestamp dataCreazione = null;
                    dataCreazione = ruolo.getProprietaOggetto() != null && ruolo.getProprietaOggetto().getDataCreazione() != null ? new Timestamp(ruolo.getProprietaOggetto().getDataCreazione().getTime()) : (ruolo.getOraRegistrazione() != null ? new Timestamp(ruolo.getOraRegistrazione().getTime()) : DateManager.getTimestamp());
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addInsertTable("ruoli");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("descrizione", "?");
                    sqlQueryObject.addInsertField("tipologia", "?");
                    sqlQueryObject.addInsertField("nome_esterno", "?");
                    sqlQueryObject.addInsertField("contesto_utilizzo", "?");
                    sqlQueryObject.addInsertField("superuser", "?");
                    if (ruolo.getOraRegistrazione() != null) {
                        sqlQueryObject.addInsertField("ora_registrazione", "?");
                    }
                    if (utenteRichiedente != null) {
                        sqlQueryObject.addInsertField("utente_richiedente", "?");
                    }
                    if (dataCreazione != null) {
                        sqlQueryObject.addInsertField("data_creazione", "?");
                    }
                    updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    int index = 1;
                    updateStmt.setString(index++, nome);
                    updateStmt.setString(index++, descrizione);
                    updateStmt.setString(index++, ruoloTipologia != null ? ruoloTipologia.getValue() : null);
                    updateStmt.setString(index++, nomeEsterno);
                    updateStmt.setString(index++, ruoloContesto != null ? ruoloContesto.getValue() : null);
                    updateStmt.setString(index++, superuser);
                    if (ruolo.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(index++, new Timestamp(ruolo.getOraRegistrazione().getTime()));
                    }
                    if (utenteRichiedente != null) {
                        updateStmt.setString(index++, utenteRichiedente);
                    }
                    if (dataCreazione != null) {
                        updateStmt.setTimestamp(index++, dataCreazione);
                    }
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDRuolo type = " + type + " row affected =" + n);
                    DriverRegistroServiziDB_LIB.logDebug("CRUDRuolo CREATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, nome, descrizione, ruoloTipologia != null ? ruoloTipologia.getValue() : null, ruoloContesto != null ? ruoloContesto.getValue() : null, superuser));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addFromTable("ruoli");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("nome = ?");
                    selectQuery = sqlQueryObject.createSQLQuery();
                    selectStmt = con.prepareStatement(selectQuery);
                    selectStmt.setString(1, nome);
                    selectRS = selectStmt.executeQuery();
                    if (selectRS.next()) {
                        ruolo.setId(selectRS.getLong("id"));
                    }
                    selectRS.close();
                    selectStmt.close();
                    return;
                }
                case 2: {
                    IDRuolo idR;
                    long idRuolo;
                    String nomeRuolo;
                    String string = nomeRuolo = ruolo.getOldIDRuoloForUpdate() != null ? ruolo.getOldIDRuoloForUpdate().getNome() : null;
                    if (nomeRuolo == null || "".equals(nomeRuolo)) {
                        nomeRuolo = ruolo.getNome();
                    }
                    if ((idRuolo = DBUtils.getIdRuolo(idR = new IDRuolo(nomeRuolo), con, tipoDB)) <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDRuolo(UPDATE)] Id Ruolo non valido.");
                    }
                    String utenteUltimaModifica = null;
                    utenteUltimaModifica = ruolo.getProprietaOggetto() != null && ruolo.getProprietaOggetto().getUtenteUltimaModifica() != null ? ruolo.getProprietaOggetto().getUtenteUltimaModifica() : superuser;
                    Timestamp dataUltimaModifica = null;
                    dataUltimaModifica = ruolo.getProprietaOggetto() != null && ruolo.getProprietaOggetto().getDataUltimaModifica() != null ? new Timestamp(ruolo.getProprietaOggetto().getDataUltimaModifica().getTime()) : DateManager.getTimestamp();
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addUpdateTable("ruoli");
                    sqlQueryObject.addUpdateField("nome", "?");
                    sqlQueryObject.addUpdateField("descrizione", "?");
                    sqlQueryObject.addUpdateField("tipologia", "?");
                    sqlQueryObject.addUpdateField("nome_esterno", "?");
                    sqlQueryObject.addUpdateField("contesto_utilizzo", "?");
                    sqlQueryObject.addUpdateField("superuser", "?");
                    if (ruolo.getOraRegistrazione() != null) {
                        sqlQueryObject.addUpdateField("ora_registrazione", "?");
                    }
                    if (utenteUltimaModifica != null) {
                        sqlQueryObject.addUpdateField("utente_ultima_modifica", "?");
                    }
                    if (dataUltimaModifica != null) {
                        sqlQueryObject.addUpdateField("data_ultima_modifica", "?");
                    }
                    sqlQueryObject.addWhereCondition("id=?");
                    updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    int index = 1;
                    updateStmt.setString(index++, nome);
                    updateStmt.setString(index++, descrizione);
                    updateStmt.setString(index++, ruoloTipologia != null ? ruoloTipologia.getValue() : null);
                    updateStmt.setString(index++, nomeEsterno);
                    updateStmt.setString(index++, ruoloContesto != null ? ruoloContesto.getValue() : null);
                    updateStmt.setString(index++, superuser);
                    if (ruolo.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(index++, new Timestamp(ruolo.getOraRegistrazione().getTime()));
                    }
                    if (utenteUltimaModifica != null) {
                        updateStmt.setString(index++, utenteUltimaModifica);
                    }
                    if (dataUltimaModifica != null) {
                        updateStmt.setTimestamp(index++, dataUltimaModifica);
                    }
                    updateStmt.setLong(index++, idRuolo);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDRuolo type = " + type + " row affected =" + n);
                    DriverRegistroServiziDB_LIB.logDebug("CRUDRuolo UPDATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, nome, descrizione, ruoloTipologia != null ? ruoloTipologia.getValue() : null, ruoloContesto != null ? ruoloContesto.getValue() : null, superuser, idRuolo));
                    return;
                }
                case 3: {
                    IDRuolo idR = new IDRuolo(nome);
                    long idRuolo = DBUtils.getIdRuolo(idR, con, tipoDB);
                    if (idRuolo <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDRuolo(DELETE)] Id Ruolo non valido.");
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("ruoli");
                    sqlQueryObject.addWhereCondition("id=?");
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idRuolo);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDRuolo type = " + type + " row affected =" + n);
                    DriverRegistroServiziDB_LIB.logDebug("CRUDRuolo DELETE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, idRuolo));
                    return;
                }
            }
            return;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverControlStationDB_LIB::CRUDRuolo] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverControlStationDB_LIB::CRUDRuolo] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            JDBCUtilities.closeResources(updateStmt);
            JDBCUtilities.closeResources(selectRS, selectStmt);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void CRUDScope(int type, Scope scope, Connection con) throws DriverRegistroServiziException {
        if (scope == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDScope] Parametro non valido.");
        }
        String nome = scope.getNome();
        String descrizione = scope.getDescrizione();
        String scopeTipologia = scope.getTipologia();
        String nomeEsterno = scope.getNomeEsterno();
        ScopeContesto scopeContesto = scope.getContestoUtilizzo();
        String superuser = scope.getSuperUser();
        PreparedStatement updateStmt = null;
        String updateQuery = "";
        PreparedStatement selectStmt = null;
        String selectQuery = "";
        ResultSet selectRS = null;
        int n = 0;
        try {
            switch (type) {
                case 1: {
                    String utenteRichiedente = null;
                    utenteRichiedente = scope.getProprietaOggetto() != null && scope.getProprietaOggetto().getUtenteRichiedente() != null ? scope.getProprietaOggetto().getUtenteRichiedente() : superuser;
                    Timestamp dataCreazione = null;
                    dataCreazione = scope.getProprietaOggetto() != null && scope.getProprietaOggetto().getDataCreazione() != null ? new Timestamp(scope.getProprietaOggetto().getDataCreazione().getTime()) : (scope.getOraRegistrazione() != null ? new Timestamp(scope.getOraRegistrazione().getTime()) : DateManager.getTimestamp());
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addInsertTable("scope");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("descrizione", "?");
                    sqlQueryObject.addInsertField("tipologia", "?");
                    sqlQueryObject.addInsertField("nome_esterno", "?");
                    sqlQueryObject.addInsertField("contesto_utilizzo", "?");
                    sqlQueryObject.addInsertField("superuser", "?");
                    if (scope.getOraRegistrazione() != null) {
                        sqlQueryObject.addInsertField("ora_registrazione", "?");
                    }
                    if (utenteRichiedente != null) {
                        sqlQueryObject.addInsertField("utente_richiedente", "?");
                    }
                    if (dataCreazione != null) {
                        sqlQueryObject.addInsertField("data_creazione", "?");
                    }
                    updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    int index = 1;
                    updateStmt.setString(index++, nome);
                    updateStmt.setString(index++, descrizione);
                    updateStmt.setString(index++, scopeTipologia);
                    updateStmt.setString(index++, nomeEsterno);
                    updateStmt.setString(index++, scopeContesto != null ? scopeContesto.getValue() : null);
                    updateStmt.setString(index++, superuser);
                    if (scope.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(index++, new Timestamp(scope.getOraRegistrazione().getTime()));
                    }
                    if (utenteRichiedente != null) {
                        updateStmt.setString(index++, utenteRichiedente);
                    }
                    if (dataCreazione != null) {
                        updateStmt.setTimestamp(index++, dataCreazione);
                    }
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDScope type = " + type + " row affected =" + n);
                    DriverRegistroServiziDB_LIB.logDebug("CRUDScope CREATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, nome, descrizione, scopeTipologia, scopeContesto != null ? scopeContesto.getValue() : null, superuser));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addFromTable("scope");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("nome = ?");
                    selectQuery = sqlQueryObject.createSQLQuery();
                    selectStmt = con.prepareStatement(selectQuery);
                    selectStmt.setString(1, nome);
                    selectRS = selectStmt.executeQuery();
                    if (selectRS.next()) {
                        scope.setId(selectRS.getLong("id"));
                    }
                    selectRS.close();
                    selectStmt.close();
                    return;
                }
                case 2: {
                    IDScope idS;
                    long idScope;
                    String nomeScope;
                    String string = nomeScope = scope.getOldIDScopeForUpdate() != null ? scope.getOldIDScopeForUpdate().getNome() : null;
                    if (nomeScope == null || "".equals(nomeScope)) {
                        nomeScope = scope.getNome();
                    }
                    if ((idScope = DBUtils.getIdScope(idS = new IDScope(nomeScope), con, tipoDB)) <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDScope(UPDATE)] Id Scope non valido.");
                    }
                    String utenteUltimaModifica = null;
                    utenteUltimaModifica = scope.getProprietaOggetto() != null && scope.getProprietaOggetto().getUtenteUltimaModifica() != null ? scope.getProprietaOggetto().getUtenteUltimaModifica() : superuser;
                    Timestamp dataUltimaModifica = null;
                    dataUltimaModifica = scope.getProprietaOggetto() != null && scope.getProprietaOggetto().getDataUltimaModifica() != null ? new Timestamp(scope.getProprietaOggetto().getDataUltimaModifica().getTime()) : DateManager.getTimestamp();
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addUpdateTable("scope");
                    sqlQueryObject.addUpdateField("nome", "?");
                    sqlQueryObject.addUpdateField("descrizione", "?");
                    sqlQueryObject.addUpdateField("tipologia", "?");
                    sqlQueryObject.addUpdateField("nome_esterno", "?");
                    sqlQueryObject.addUpdateField("contesto_utilizzo", "?");
                    sqlQueryObject.addUpdateField("superuser", "?");
                    if (scope.getOraRegistrazione() != null) {
                        sqlQueryObject.addUpdateField("ora_registrazione", "?");
                    }
                    if (utenteUltimaModifica != null) {
                        sqlQueryObject.addUpdateField("utente_ultima_modifica", "?");
                    }
                    if (dataUltimaModifica != null) {
                        sqlQueryObject.addUpdateField("data_ultima_modifica", "?");
                    }
                    sqlQueryObject.addWhereCondition("id=?");
                    updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    int index = 1;
                    updateStmt.setString(index++, nome);
                    updateStmt.setString(index++, descrizione);
                    updateStmt.setString(index++, scopeTipologia);
                    updateStmt.setString(index++, nomeEsterno);
                    updateStmt.setString(index++, scopeContesto != null ? scopeContesto.getValue() : null);
                    updateStmt.setString(index++, superuser);
                    if (scope.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(index++, new Timestamp(scope.getOraRegistrazione().getTime()));
                    }
                    if (utenteUltimaModifica != null) {
                        updateStmt.setString(index++, utenteUltimaModifica);
                    }
                    if (dataUltimaModifica != null) {
                        updateStmt.setTimestamp(index++, dataUltimaModifica);
                    }
                    updateStmt.setLong(index++, idScope);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDScope type = " + type + " row affected =" + n);
                    DriverRegistroServiziDB_LIB.logDebug("CRUDScope UPDATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, nome, descrizione, scopeTipologia, scopeContesto != null ? scopeContesto.getValue() : null, superuser, idScope));
                    return;
                }
                case 3: {
                    IDScope idS = new IDScope(nome);
                    long idScope = DBUtils.getIdScope(idS, con, tipoDB);
                    if (idScope <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDScope(DELETE)] Id Scope non valido.");
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("scope");
                    sqlQueryObject.addWhereCondition("id=?");
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idScope);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDScope type = " + type + " row affected =" + n);
                    DriverRegistroServiziDB_LIB.logDebug("CRUDScope DELETE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, idScope));
                    return;
                }
            }
            return;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverControlStationDB_LIB::CRUDScope] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverControlStationDB_LIB::CRUDScope] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            JDBCUtilities.closeResources(updateStmt);
            JDBCUtilities.closeResources(selectRS, selectStmt);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static long getIdConnettoreSoggetto(String nomeSoggetto, String tipoSoggetto, Connection con) throws DriverRegistroServiziException {
        long l;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idConnettore = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
            sqlQueryObject.addWhereCondition("nome_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, tipoSoggetto);
            stm.setString(2, nomeSoggetto);
            rs = stm.executeQuery();
            if (rs.next()) {
                idConnettore = rs.getLong("id_connettore");
            }
            l = idConnettore;
        }
        catch (SQLException e) {
            try {
                log.error("Errore SQL", (Throwable)e);
                throw new DriverRegistroServiziException(e);
                catch (Exception e2) {
                    log.error("Errore", (Throwable)e2);
                    throw new DriverRegistroServiziException(e2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return l;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static long getIdConnettoreServizio(String nomeServizio, String tipoServizio, Integer versioneServizio, String nomeSoggetto, String tipoSoggetto, Connection con) throws DriverRegistroServiziException {
        long l;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idConnettore = -1L;
        try {
            long idSoggetto = DBUtils.getIdSoggetto(nomeSoggetto, tipoSoggetto, con, tipoDB);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("tipo_servizio = ?");
            sqlQueryObject.addWhereCondition("nome_servizio = ?");
            sqlQueryObject.addWhereCondition("versione_servizio = ?");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            int index = 1;
            stm.setString(index++, tipoServizio);
            stm.setString(index++, nomeServizio);
            stm.setInt(index++, versioneServizio);
            stm.setLong(index++, idSoggetto);
            rs = stm.executeQuery();
            if (rs.next()) {
                idConnettore = rs.getLong("id_connettore");
            }
            l = idConnettore;
        }
        catch (CoreException e) {
            try {
                log.error("Errore Driver.", (Throwable)e);
                throw new DriverRegistroServiziException(e);
                catch (SQLException e2) {
                    log.error("Errore SQL", (Throwable)e2);
                    throw new DriverRegistroServiziException(e2);
                }
                catch (Exception e3) {
                    log.error("Errore", (Throwable)e3);
                    throw new DriverRegistroServiziException(e3);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return l;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static long getIdFruizione(long idServizio, String nomeSoggetto, String tipoSoggetto, Connection con) throws DriverRegistroServiziException {
        long l;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idFruizione = -1L;
        try {
            long idSoggetto = DBUtils.getIdSoggetto(nomeSoggetto, tipoSoggetto, con, tipoDB);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_servizio = ?");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setLong(1, idServizio);
            stm.setLong(2, idSoggetto);
            rs = stm.executeQuery();
            if (rs.next()) {
                idFruizione = rs.getLong("id");
            }
            l = idFruizione;
        }
        catch (CoreException e) {
            try {
                log.error("Errore Core: " + e.getMessage(), (Throwable)e);
                throw new DriverRegistroServiziException(e);
                catch (SQLException e2) {
                    log.error("Errore SQL: " + e2.getMessage(), (Throwable)e2);
                    throw new DriverRegistroServiziException(e2);
                }
                catch (Exception e3) {
                    log.error("Errore Generico: " + e3.getMessage(), (Throwable)e3);
                    throw new DriverRegistroServiziException(e3);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return l;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static long getIdConnettoreServizioFruitore(long idServizio, String nomeSoggetto, String tipoSoggetto, Connection con) throws DriverRegistroServiziException {
        long l;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idConnettore = -1L;
        try {
            long idSoggetto = DBUtils.getIdSoggetto(nomeSoggetto, tipoSoggetto, con, tipoDB);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_servizio = ?");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setLong(1, idServizio);
            stm.setLong(2, idSoggetto);
            rs = stm.executeQuery();
            if (rs.next()) {
                idConnettore = rs.getLong("id_connettore");
            }
            l = idConnettore;
        }
        catch (CoreException e) {
            try {
                log.error("Errore Core: " + e.getMessage(), (Throwable)e);
                throw new DriverRegistroServiziException(e);
                catch (SQLException e2) {
                    log.error("Errore SQL: " + e2.getMessage(), (Throwable)e2);
                    throw new DriverRegistroServiziException(e2);
                }
                catch (Exception e3) {
                    log.error("Errore Generico: " + e3.getMessage(), (Throwable)e3);
                    throw new DriverRegistroServiziException(e3);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return l;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static long getIdConnettoreServizioAzione(long idServizio, String azione, Connection con) throws DriverRegistroServiziException {
        long l;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idConnettore = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("servizi_azioni");
            sqlQueryObject.addFromTable("servizi_azione");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("servizi_azioni.id=servizi_azione.id_servizio_azioni");
            sqlQueryObject.addWhereCondition("servizi_azioni.id_servizio = ?");
            sqlQueryObject.addWhereCondition("servizi_azione.nome_azione = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setLong(1, idServizio);
            stm.setString(2, azione);
            rs = stm.executeQuery();
            if (rs.next()) {
                idConnettore = rs.getLong("id_connettore");
            }
            l = idConnettore;
        }
        catch (SQLException e) {
            try {
                log.error("Errore SQL", (Throwable)e);
                throw new DriverRegistroServiziException(e);
                catch (Exception e2) {
                    log.error("Errore", (Throwable)e2);
                    throw new DriverRegistroServiziException(e2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return l;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static long getIdConnettoreFruizioneServizioAzione(long idFruizione, String azione, Connection con) throws DriverRegistroServiziException {
        long l;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idConnettore = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori_azioni");
            sqlQueryObject.addFromTable("servizi_fruitori_azione");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("servizi_fruitori_azioni.id=servizi_fruitori_azione.id_fruizione_azioni");
            sqlQueryObject.addWhereCondition("servizi_fruitori_azioni.id_fruizione = ?");
            sqlQueryObject.addWhereCondition("servizi_fruitori_azione.nome_azione = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setLong(1, idFruizione);
            stm.setString(2, azione);
            rs = stm.executeQuery();
            if (rs.next()) {
                idConnettore = rs.getLong("id_connettore");
            }
            l = idConnettore;
        }
        catch (SQLException e) {
            try {
                log.error("Errore SQL", (Throwable)e);
                throw new DriverRegistroServiziException(e);
                catch (Exception e2) {
                    log.error("Errore", (Throwable)e2);
                    throw new DriverRegistroServiziException(e2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return l;
    }

    public static void CRUDProtocolProperty(int type, List<ProtocolProperty> listPP, long idProprietario, ProprietariProtocolProperty tipologiaProprietarioProtocolProperty, Connection connection, String tipoDatabase, IDriverBYOK driverBYOK) throws DriverRegistroServiziException {
        try {
            DBProtocolPropertiesUtils.crudRegistryProtocolProperty(log, type, listPP, idProprietario, tipologiaProprietarioProtocolProperty, connection, tipoDatabase, driverBYOK);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
    }

    public static List<ProtocolProperty> getListaProtocolProperty(long idProprietario, ProprietariProtocolProperty tipologiaProprietario, Connection connection, String tipoDatabase, IDriverBYOK driverBYOK) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            return DBProtocolPropertiesUtils.getListaProtocolPropertyRegistry(idProprietario, tipologiaProprietario, connection, tipoDatabase, driverBYOK);
        }
        catch (NotFoundException e) {
            throw new DriverRegistroServiziNotFound(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
    }

    public static ProtocolProperty getProtocolProperty(long id, Connection connection, String tipoDatabase, IDriverBYOK driverBYOK) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            return DBProtocolPropertiesUtils.getProtocolPropertyRegistry(id, connection, tipoDatabase, driverBYOK);
        }
        catch (NotFoundException e) {
            throw new DriverRegistroServiziNotFound(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
    }
}

