/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.db;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.constants.CostantiDB;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.constants.TipologiaServizio;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDFruizione;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.ConfigurazioneServizio;
import org.openspcoop2.core.registry.ConfigurazioneServizioAzione;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.CostantiRegistroServizi;
import org.openspcoop2.core.registry.constants.ProprietariDocumento;
import org.openspcoop2.core.registry.constants.RuoliDocumento;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.constants.StatiAccordo;
import org.openspcoop2.core.registry.constants.StatoFunzionalita;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicercaFruizioniServizio;
import org.openspcoop2.core.registry.driver.FiltroRicercaServizi;
import org.openspcoop2.core.registry.driver.ValidazioneStatoPackageException;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_LIB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_accordiParteSpecificaLIB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_documentiLIB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_protocolPropertiesDriver;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_utilsDriver;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverRegistroServiziDB_accordiParteSpecificaDriver {
    private DriverRegistroServiziDB driver = null;
    private DriverRegistroServiziDB_protocolPropertiesDriver protocolPropertiesDriver = null;

    protected DriverRegistroServiziDB_accordiParteSpecificaDriver(DriverRegistroServiziDB driver) {
        this.driver = driver;
        this.protocolPropertiesDriver = new DriverRegistroServiziDB_protocolPropertiesDriver(driver);
    }

    protected AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDServizio idServizio) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica(idServizio, false, null);
    }

    protected AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDServizio idServizio, Connection con) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica(idServizio, false, con);
    }

    protected AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDServizio idServizio, boolean readContenutoAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica(idServizio, readContenutoAllegati, null);
    }

    protected AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDServizio idServizio, boolean readContenutoAllegati, Connection con) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        AccordoServizioParteSpecifica servizio = this.getAccordoServizioParteSpecifica(idServizio, null, null, readContenutoAllegati, con);
        return servizio;
    }

    protected AccordoServizioParteSpecifica getAccordoServizioParteSpecifica_ServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordoServizioParteComune) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica_ServizioCorrelato(idSoggetto, idAccordoServizioParteComune, false, null);
    }

    protected AccordoServizioParteSpecifica getAccordoServizioParteSpecifica_ServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordoServizioParteComune, Connection con) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica_ServizioCorrelato(idSoggetto, idAccordoServizioParteComune, false, con);
    }

    protected AccordoServizioParteSpecifica getAccordoServizioParteSpecifica_ServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordoServizioParteComune, boolean readContenutoAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica_ServizioCorrelato(idSoggetto, idAccordoServizioParteComune, readContenutoAllegati, null);
    }

    protected AccordoServizioParteSpecifica getAccordoServizioParteSpecifica_ServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordoServizioParteComune, boolean readContenutoAllegati, Connection con) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        AccordoServizioParteSpecifica servizio = this.getAccordoServizioParteSpecifica(null, idSoggetto, idAccordoServizioParteComune, readContenutoAllegati, con);
        return servizio;
    }

    protected List<IDServizio> getAllIdServizi(FiltroRicercaServizi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDServizio> list = new ArrayList<IDServizio>();
        this._fillAllIdServiziEngine("getAllIdServizi", filtroRicerca, list);
        return list;
    }

    protected List<IDFruizione> getAllIdFruizioniServizio(FiltroRicercaFruizioniServizio filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDFruizione> list = new ArrayList<IDFruizione>();
        this._fillAllIdServiziEngine("getAllIdFruizioniServizio", filtroRicerca, list);
        return list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> void _fillAllIdServiziEngine(String nomeMetodo, FiltroRicercaServizi filtroRicerca, List<T> listReturn) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        FiltroRicercaFruizioniServizio filtroFruizioni = null;
        if (filtroRicerca instanceof FiltroRicercaFruizioniServizio) {
            filtroFruizioni = (FiltroRicercaFruizioniServizio)filtroRicerca;
        }
        this.driver.logDebug(nomeMetodo + " ...");
        try {
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = this.driver.atomica ? this.driver.getConnectionFromDatasource(nomeMetodo) : this.driver.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            String aliasFruitore = "fruitore";
            String aliasErogatore = "erogatore";
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti", aliasErogatore);
            sqlQueryObject.addFromTable("accordi");
            boolean setFruitore = false;
            if (filtroFruizioni != null) {
                setFruitore = true;
            }
            if (!(setFruitore || filtroRicerca == null || filtroRicerca.getTipoSoggettoFruitore() == null && filtroRicerca.getNomeSoggettoFruitore() == null)) {
                setFruitore = true;
            }
            if (setFruitore) {
                sqlQueryObject.addFromTable("soggetti", aliasFruitore);
                sqlQueryObject.addFromTable("servizi_fruitori");
            }
            String aliasTipoSoggettoErogatore = "tipo_soggetto_erogatore";
            String aliasNomeSoggettoErogatore = "nome_soggetto_erogatore";
            sqlQueryObject.addSelectAliasField(aliasErogatore, "tipo_soggetto", aliasTipoSoggettoErogatore);
            sqlQueryObject.addSelectAliasField(aliasErogatore, "nome_soggetto", aliasNomeSoggettoErogatore);
            sqlQueryObject.addSelectField("tipo_servizio");
            sqlQueryObject.addSelectField("nome_servizio");
            sqlQueryObject.addSelectField("versione_servizio");
            sqlQueryObject.addSelectField("id_referente");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("versione");
            sqlQueryObject.addSelectField("servizio_correlato");
            String aliasTipoSoggettoFruitore = "tipo_soggetto_fruitore";
            String aliasNomeSoggettoFruitore = "nome_soggetto_fruitore";
            if (setFruitore) {
                sqlQueryObject.addSelectAliasField(aliasFruitore, "tipo_soggetto", aliasTipoSoggettoFruitore);
                sqlQueryObject.addSelectAliasField(aliasFruitore, "nome_soggetto", aliasNomeSoggettoFruitore);
            }
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addWhereCondition("servizi.id_soggetto = " + aliasErogatore + ".id");
            sqlQueryObject.addWhereCondition("servizi.id_accordo = accordi.id");
            if (setFruitore) {
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = servizi.id");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = " + aliasFruitore + ".id");
            }
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    sqlQueryObject.addWhereCondition("servizi.ora_registrazione > ?");
                }
                if (filtroRicerca.getMaxDate() != null) {
                    sqlQueryObject.addWhereCondition("servizi.ora_registrazione < ?");
                }
                if (filtroRicerca.getTipo() != null) {
                    sqlQueryObject.addWhereCondition("servizi.tipo_servizio = ?");
                }
                if (filtroRicerca.getNome() != null) {
                    sqlQueryObject.addWhereCondition("servizi.nome_servizio = ?");
                }
                if (filtroRicerca.getVersione() != null) {
                    sqlQueryObject.addWhereCondition("servizi.versione_servizio = ?");
                }
                if (filtroRicerca.getPortType() != null) {
                    sqlQueryObject.addWhereCondition("servizi.port_type = ?");
                }
                if (filtroRicerca.getTipologia() != null) {
                    sqlQueryObject.addWhereCondition("servizi.servizio_correlato = ?");
                }
                if (filtroRicerca.getTipoSoggettoErogatore() != null) {
                    sqlQueryObject.addWhereCondition(aliasErogatore + ".tipo_soggetto = ?");
                }
                if (filtroRicerca.getNomeSoggettoErogatore() != null) {
                    sqlQueryObject.addWhereCondition(aliasErogatore + ".nome_soggetto = ?");
                }
                if (filtroRicerca.getIdAccordoServizioParteComune() != null) {
                    IDAccordo idAccordo = filtroRicerca.getIdAccordoServizioParteComune();
                    if (idAccordo.getNome() != null) {
                        sqlQueryObject.addWhereCondition("accordi.nome = ?");
                    }
                    if (idAccordo.getSoggettoReferente() != null) {
                        sqlQueryObject.addWhereCondition("accordi.id_referente = ?");
                    }
                    if (idAccordo.getVersione() != null) {
                        sqlQueryObject.addWhereCondition("accordi.versione = ?");
                    }
                }
                if (filtroRicerca.getTipoSoggettoFruitore() != null) {
                    sqlQueryObject.addWhereCondition(aliasFruitore + ".tipo_soggetto = ?");
                }
                if (filtroRicerca.getNomeSoggettoFruitore() != null) {
                    sqlQueryObject.addWhereCondition(aliasFruitore + ".nome_soggetto = ?");
                }
                this.protocolPropertiesDriver.setProtocolPropertiesForSearch(sqlQueryObject, filtroRicerca, "servizi");
            }
            if (filtroFruizioni != null) {
                if (filtroFruizioni.getTipoSoggettoFruitore() != null) {
                    sqlQueryObject.addWhereCondition(aliasFruitore + ".tipo_soggetto = ?");
                }
                if (filtroFruizioni.getNomeSoggettoFruitore() != null) {
                    sqlQueryObject.addWhereCondition(aliasFruitore + ".nome_soggetto = ?");
                }
                this.protocolPropertiesDriver.setProtocolPropertiesForSearch(sqlQueryObject, filtroFruizioni, "servizi_fruitori");
            }
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.driver.logDebug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    this.driver.logDebug("minDate stmt.setTimestamp(" + filtroRicerca.getMinDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMinDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    this.driver.logDebug("maxDate stmt.setTimestamp(" + filtroRicerca.getMaxDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMaxDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getTipo() != null) {
                    this.driver.logDebug("tipoServizio stmt.setString(" + filtroRicerca.getTipo() + ")");
                    stm.setString(indexStmt, filtroRicerca.getTipo());
                    ++indexStmt;
                }
                if (filtroRicerca.getNome() != null) {
                    this.driver.logDebug("nomeServizio stmt.setString(" + filtroRicerca.getNome() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNome());
                    ++indexStmt;
                }
                if (filtroRicerca.getVersione() != null) {
                    this.driver.logDebug("versioneServizio stmt.setString(" + filtroRicerca.getVersione() + ")");
                    stm.setInt(indexStmt, filtroRicerca.getVersione());
                    ++indexStmt;
                }
                if (filtroRicerca.getPortType() != null) {
                    this.driver.logDebug("portType stmt.setString(" + filtroRicerca.getPortType() + ")");
                    stm.setString(indexStmt, filtroRicerca.getPortType());
                    ++indexStmt;
                }
                if (filtroRicerca.getTipologia() != null) {
                    StatoFunzionalita servizioCorrelato = TipologiaServizio.CORRELATO.equals(filtroRicerca.getTipologia()) ? CostantiRegistroServizi.ABILITATO : CostantiRegistroServizi.DISABILITATO;
                    this.driver.logDebug("tipologiaServizio stmt.setString(" + servizioCorrelato.getValue() + ") original:[" + filtroRicerca.getTipologia() + "]");
                    stm.setString(indexStmt, servizioCorrelato.getValue());
                    ++indexStmt;
                }
                if (filtroRicerca.getTipologia() != null) {
                    if (TipologiaServizio.CORRELATO.equals(filtroRicerca.getTipologia())) {
                        this.driver.logDebug("tipologiaServizio stmt.setString(" + CostantiRegistroServizi.ABILITATO.toString() + ")");
                        stm.setString(indexStmt, CostantiRegistroServizi.ABILITATO.toString());
                    } else {
                        this.driver.logDebug("tipologiaServizio stmt.setString(" + CostantiRegistroServizi.DISABILITATO.toString() + ")");
                        stm.setString(indexStmt, CostantiRegistroServizi.DISABILITATO.toString());
                    }
                    ++indexStmt;
                }
                if (filtroRicerca.getTipoSoggettoErogatore() != null) {
                    this.driver.logDebug("tipoSoggettoErogatore stmt.setString(" + filtroRicerca.getTipoSoggettoErogatore() + ")");
                    stm.setString(indexStmt, filtroRicerca.getTipoSoggettoErogatore());
                    ++indexStmt;
                }
                if (filtroRicerca.getNomeSoggettoErogatore() != null) {
                    this.driver.logDebug("nomeSoggettoErogatore stmt.setString(" + filtroRicerca.getNomeSoggettoErogatore() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNomeSoggettoErogatore());
                    ++indexStmt;
                }
                if (filtroRicerca.getIdAccordoServizioParteComune() != null) {
                    IDAccordo idAccordo = filtroRicerca.getIdAccordoServizioParteComune();
                    if (idAccordo.getNome() != null) {
                        this.driver.logDebug("nomeAccordo stmt.setString(" + idAccordo.getNome() + ")");
                        stm.setString(indexStmt, idAccordo.getNome());
                        ++indexStmt;
                    }
                    if (idAccordo.getSoggettoReferente() != null) {
                        long idSoggettoReferente = DBUtils.getIdSoggetto(idAccordo.getSoggettoReferente().getNome(), idAccordo.getSoggettoReferente().getTipo(), con, this.driver.tipoDB, this.driver.tabellaSoggetti);
                        if (idSoggettoReferente <= 0L) {
                            throw new Exception("Soggetto referente [" + idAccordo.getSoggettoReferente().toString() + "] non trovato");
                        }
                        this.driver.logDebug("idReferenteAccordi stmt.setLong(" + idSoggettoReferente + ")");
                        stm.setLong(indexStmt, idSoggettoReferente);
                        ++indexStmt;
                    }
                    if (idAccordo.getVersione() != null) {
                        this.driver.logDebug("versioneAccordo stmt.setString(" + idAccordo.getVersione() + ")");
                        stm.setInt(indexStmt, idAccordo.getVersione());
                        ++indexStmt;
                    }
                }
                if (filtroRicerca.getTipoSoggettoFruitore() != null) {
                    this.driver.logDebug("tipoSoggettoFruitore stmt.setString(" + filtroRicerca.getTipoSoggettoFruitore() + ")");
                    stm.setString(indexStmt, filtroRicerca.getTipoSoggettoFruitore());
                    ++indexStmt;
                }
                if (filtroRicerca.getNomeSoggettoFruitore() != null) {
                    this.driver.logDebug("nomeSoggettoFruitore stmt.setString(" + filtroRicerca.getNomeSoggettoFruitore() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNomeSoggettoFruitore());
                    ++indexStmt;
                }
                this.protocolPropertiesDriver.setProtocolPropertiesForSearch(stm, indexStmt, filtroRicerca, ProprietariProtocolProperty.ACCORDO_SERVIZIO_PARTE_SPECIFICA);
            }
            if (filtroFruizioni != null) {
                if (filtroFruizioni.getTipoSoggettoFruitore() != null) {
                    this.driver.logDebug("tipoSoggettoFruitore stmt.setString(" + filtroFruizioni.getTipoSoggettoFruitore() + ")");
                    stm.setString(indexStmt, filtroFruizioni.getTipoSoggettoFruitore());
                    ++indexStmt;
                }
                if (filtroFruizioni.getNomeSoggettoFruitore() != null) {
                    this.driver.logDebug("nomeSoggettoFruitore stmt.setString(" + filtroFruizioni.getNomeSoggettoFruitore() + ")");
                    stm.setString(indexStmt, filtroFruizioni.getNomeSoggettoFruitore());
                    ++indexStmt;
                }
                this.protocolPropertiesDriver.setProtocolPropertiesForSearch(stm, indexStmt, filtroFruizioni, ProprietariProtocolProperty.FRUITORE);
            }
            rs = stm.executeQuery();
            while (rs.next()) {
                IDSoggetto idSoggettoErogatore = new IDSoggetto(rs.getString(aliasTipoSoggettoErogatore), rs.getString(aliasNomeSoggettoErogatore));
                IDServizio idServ = this.driver.idServizioFactory.getIDServizioFromValues(rs.getString("tipo_servizio"), rs.getString("nome_servizio"), idSoggettoErogatore, rs.getInt("versione_servizio"));
                IDSoggetto soggettoReferente = null;
                long idSoggettoReferente = rs.getLong("id_referente");
                if (idSoggettoReferente > 0L) {
                    try {
                        soggettoReferente = this.driver.getIdSoggetto(idSoggettoReferente, con);
                        if (soggettoReferente == null) {
                            throw new DriverRegistroServiziNotFound("non esiste");
                        }
                    }
                    catch (DriverRegistroServiziNotFound notFound) {
                        try {
                            throw new Exception("Soggetto referente [" + idSoggettoReferente + "] dell'accordo non esiste");
                        }
                        catch (Throwable throwable) {
                            try {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                if (stm == null) throw throwable;
                                stm.close();
                                throw throwable;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                }
                IDAccordo idAccordo = this.driver.idAccordoFactory.getIDAccordoFromValues(rs.getString("nome"), soggettoReferente, rs.getInt("versione"));
                idServ.setUriAccordoServizioParteComune(this.driver.idAccordoFactory.getUriFromIDAccordo(idAccordo));
                String servizioCorrelato = rs.getString("servizio_correlato");
                if (CostantiRegistroServizi.ABILITATO.toString().equals(servizioCorrelato) || org.openspcoop2.core.registry.constants.TipologiaServizio.CORRELATO.toString().equals(servizioCorrelato)) {
                    idServ.setTipologia(TipologiaServizio.CORRELATO);
                } else {
                    idServ.setTipologia(TipologiaServizio.NORMALE);
                }
                if (filtroFruizioni != null) {
                    IDFruizione idFruizione = new IDFruizione();
                    idFruizione.setIdServizio(idServ);
                    idFruizione.setIdFruitore(new IDSoggetto(rs.getString("tipo_soggetto_fruitore"), rs.getString("nome_soggetto_fruitore")));
                    listReturn.add(idFruizione);
                    continue;
                }
                listReturn.add(idServ);
            }
            if (listReturn.isEmpty()) {
                String msgFiltro = "Elementi non trovati che rispettano il filtro di ricerca selezionato: ";
                if (filtroFruizioni != null) {
                    throw new DriverRegistroServiziNotFound(msgFiltro + filtroFruizioni.toString());
                }
                if (filtroRicerca == null) throw new DriverRegistroServiziNotFound("Elementi non trovati");
                throw new DriverRegistroServiziNotFound(msgFiltro + filtroRicerca.toString());
            }
        }
        catch (DriverRegistroServiziNotFound de) {
            try {
                throw de;
                catch (Exception e) {
                    throw new DriverRegistroServiziException(nomeMetodo + " error", e);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IDServizio[] getAllIdServiziWithSoggettoErogatore(Long idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        IDServizio[] iDServizioArray;
        String operazione = "getAllIdServiziWithSoggettoErogatore";
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        this.driver.logDebug(operazione + "...");
        try {
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = this.driver.atomica ? this.driver.getConnectionFromDatasource("getAllIdServiziWithSoggettoErogatore") : this.driver.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
            sqlQueryObject.addWhereCondition("soggetti.id = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.driver.logDebug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            rs = stm.executeQuery();
            ArrayList<IDServizio> idServizi = new ArrayList<IDServizio>();
            while (rs.next()) {
                IDSoggetto idSoggettoErogatore = new IDSoggetto(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"));
                IDServizio idServ = this.driver.idServizioFactory.getIDServizioFromValues(rs.getString("tipo_servizio"), rs.getString("nome_servizio"), idSoggettoErogatore, rs.getInt("versione_servizio"));
                idServizi.add(idServ);
            }
            if (idServizi.isEmpty()) {
                throw new DriverRegistroServiziNotFound("Servizi non trovati per il soggetto con id: " + idSoggetto);
            }
            IDServizio[] res = new IDServizio[1];
            iDServizioArray = idServizi.toArray(res);
        }
        catch (DriverRegistroServiziNotFound de) {
            try {
                throw de;
                catch (Exception e) {
                    throw new DriverRegistroServiziException(operazione + " error", e);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return iDServizioArray;
    }

    protected void createAccordoServizioParteSpecifica(AccordoServizioParteSpecifica accordoServizioParteSpecifica) throws DriverRegistroServiziException {
        if (accordoServizioParteSpecifica == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoServizioParteSpecifica] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("createAccordoServizioParteSpecifica");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoServizioParteSpecifica] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDServizio tupe=1");
            DriverRegistroServiziDB_accordiParteSpecificaLIB.CRUDAccordoServizioParteSpecifica(1, accordoServizioParteSpecifica, con, this.driver.tipoDB, this.driver.getDriverWrapBYOK());
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoServizioParteSpecifica] Errore durante la creazione del servizio : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected boolean existsAccordoServizioParteSpecifica(IDServizio idServizio) throws DriverRegistroServiziException {
        if (idServizio == null) {
            throw new DriverRegistroServiziException("IDServizio non valido.");
        }
        IDSoggetto erogatore = idServizio.getSoggettoErogatore();
        if (erogatore == null) {
            throw new DriverRegistroServiziException("Soggetto Erogatore non valido.");
        }
        String nomeServizio = idServizio.getNome();
        String tipoServizio = idServizio.getTipo();
        Integer versioneServizio = idServizio.getVersione();
        String nomeProprietario = erogatore.getNome();
        String tipoProprietario = erogatore.getTipo();
        Connection con = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("existsAccordoServizioParteSpecifica");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            long idS = DBUtils.getIdServizio(nomeServizio, tipoServizio, versioneServizio, nomeProprietario, tipoProprietario, con, false, this.driver.tipoDB);
            boolean bl = idS > 0L;
            return bl;
        }
        catch (Exception qe) {
            throw new DriverRegistroServiziException("Errore durante existsAccordoServizioParteSpecifica : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean existsAccordoServizioParteSpecifica(long idServizio) throws DriverRegistroServiziException {
        boolean exist = false;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("existsAccordoServizioParteSpecifica(longId)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsAccordoServizioParteSpecifica] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idServizio);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
            JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
            this.driver.closeConnection(con);
        }
        catch (Exception e) {
            exist = false;
            this.driver.log.error("Errore durante verifica esistenza servizio :", (Throwable)e);
        }
        finally {
            JDBCUtilities.closeResources(rs, stm);
            this.driver.closeConnection(con);
        }
        return exist;
    }

    protected long getServizioWithSoggettoAccordoServCorr(long idSoggetto, long idAccordo, String servizioCorrelato) throws DriverRegistroServiziException {
        return this.getEngineServizioWithSoggettoAccordoServCorrPT(idSoggetto, idAccordo, servizioCorrelato, null);
    }

    private long getEngineServizioWithSoggettoAccordoServCorrPT(long idSoggetto, long idAccordo, String servizioCorrelato, String portType) throws DriverRegistroServiziException {
        Connection connection;
        long idServ = 0L;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (this.driver.atomica) {
            try {
                connection = this.driver.getConnectionFromDatasource("getEngineServizioWithSoggettoAccordoServCorrPT");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getServizioWithSoggettoAccordoServCorr] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.addWhereCondition("servizio_correlato = ?");
            if (portType != null) {
                sqlQueryObject.addWhereCondition("port_type = ?");
            } else {
                sqlQueryObject.addWhereCondition("port_type is null");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            stm.setLong(2, idAccordo);
            stm.setString(3, servizioCorrelato);
            if (portType != null) {
                stm.setString(4, portType);
            }
            if ((rs = stm.executeQuery()).next()) {
                idServ = rs.getLong("id");
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            try {
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(connection);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(connection);
        return idServ;
    }

    protected long getServizioWithSoggettoAccordoServCorrPt(long idSoggetto, long idAccordo, String servizioCorrelato, String portType) throws DriverRegistroServiziException {
        return this.getEngineServizioWithSoggettoAccordoServCorrPT(idSoggetto, idAccordo, servizioCorrelato, portType);
    }

    protected void updateAccordoServizioParteSpecifica(AccordoServizioParteSpecifica servizio) throws DriverRegistroServiziException {
        if (servizio == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateAccordoServizioParteSpecifica] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("updateAccordoServizioParteSpecifica");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateAccordoServizioParteSpecifica] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            DriverRegistroServiziDB_accordiParteSpecificaLIB.CRUDAccordoServizioParteSpecifica(2, servizio, con, this.driver.tipoDB, this.driver.getDriverWrapBYOK());
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateAccordoServizioParteSpecifica] Errore durante l'update del servizio : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void deleteAccordoServizioParteSpecifica(AccordoServizioParteSpecifica servizio) throws DriverRegistroServiziException {
        if (servizio == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteAccordoServizioParteSpecifica] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("deleteAccordoServizioParteSpecifica");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteAccordoServizioParteSpecifica] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDServizio type = 3");
            DriverRegistroServiziDB_accordiParteSpecificaLIB.CRUDAccordoServizioParteSpecifica(3, servizio, con, this.driver.tipoDB, this.driver.getDriverWrapBYOK());
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteAccordoServizioParteSpecifica] Errore durante la delete del servizio : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected boolean existsSoggettoServiziWithoutConnettore(long idSoggetto) throws DriverRegistroServiziException {
        boolean bl;
        if (idSoggetto <= 0L) {
            throw new DriverRegistroServiziException("idSoggetto non valido.");
        }
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        boolean trovatoServ = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("existsSoggettoServiziWithoutConnettore");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("connettori");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("servizi.id_connettore = connettori.id");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.addWhereCondition("endpointtype = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            stm.setString(2, DriverRegistroServiziDB_LIB.getValue(CostantiRegistroServizi.DISABILITATO));
            rs = stm.executeQuery();
            if (rs.next()) {
                trovatoServ = true;
            }
            bl = trovatoServ;
        }
        catch (Exception qe) {
            try {
                throw new DriverRegistroServiziException("Errore durante existsSoggettoServiziWithoutConnettore: " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDServizio idServizio, IDSoggetto idSoggetto, IDAccordo idAccordoServizioParteComune, boolean readContenutoAllegati, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String tmp;
        String sqlQuery;
        ISQLQueryObject sqlQueryObject;
        long idConnettore;
        long longIdAccordoServizioParteSpecifica;
        long longIdAccordoServizioParteComune;
        AccordoServizioParteSpecifica accordoServizioParteSpecifica = null;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        PreparedStatement stm1 = null;
        ResultSet rs1 = null;
        if (idServizio != null) {
            this.driver.logDebug("chiamato getAccordoServizioParteSpecifica (IDServizio)");
            if (idServizio == null || idServizio.getNome() == null || idServizio.getNome().trim().equals("") || idServizio.getTipo() == null || idServizio.getTipo().trim().equals("") || idServizio.getVersione() == null || idServizio.getSoggettoErogatore() == null || idServizio.getSoggettoErogatore().getNome() == null || idServizio.getSoggettoErogatore().getNome().trim().equals("") || idServizio.getSoggettoErogatore().getTipo() == null || idServizio.getSoggettoErogatore().getTipo().trim().equals("")) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizioParteSpecifica] : errore nei parametri d'ingresso (IDServizio)");
            }
        } else {
            this.driver.logDebug("chiamato getAccordoServizioParteSpecifica (IDSoggetto e IDAccordo)");
            if (idAccordoServizioParteComune == null || idAccordoServizioParteComune.getNome() == null || idAccordoServizioParteComune.getNome().trim().equals("") || idSoggetto == null || idSoggetto.getNome() == null || idSoggetto.getNome().trim().equals("") || idSoggetto.getTipo() == null || idSoggetto.getTipo().trim().equals("")) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizioParteSpecifica] : errore nei parametri d'ingresso (IDSoggetto e IDAccordo)");
            }
        }
        if (conParam != null) {
            con = conParam;
        } else if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getAccordoServizioParteSpecifica");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizioParteSpecifica] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            String profilo;
            String sqlQuery2;
            ISQLQueryObject sqlQueryObject2;
            accordoServizioParteSpecifica = new AccordoServizioParteSpecifica();
            String nomeSoggEr = null;
            String tipoSoggEr = null;
            longIdAccordoServizioParteComune = 0L;
            String nomeServizio = null;
            String tipoServizio = null;
            Integer versioneServizio = null;
            String superUser = null;
            long idSoggErogatore = 0L;
            longIdAccordoServizioParteSpecifica = 0L;
            if (idServizio != null) {
                nomeServizio = idServizio.getNome();
                tipoServizio = idServizio.getTipo();
                versioneServizio = idServizio.getVersione();
                nomeSoggEr = idServizio.getSoggettoErogatore().getNome();
                tipoSoggEr = idServizio.getSoggettoErogatore().getTipo();
                sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject2.addFromTable("soggetti");
                sqlQueryObject2.addSelectField("*");
                sqlQueryObject2.addWhereCondition("nome_soggetto = ?");
                sqlQueryObject2.addWhereCondition("tipo_soggetto = ?");
                sqlQueryObject2.setANDLogicOperator(true);
                sqlQuery2 = sqlQueryObject2.createSQLQuery();
                stm = con.prepareStatement(sqlQuery2);
                stm.setString(1, nomeSoggEr);
                stm.setString(2, tipoSoggEr);
                this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery2, nomeSoggEr, tipoSoggEr));
                rs = stm.executeQuery();
                if (rs.next()) {
                    idSoggErogatore = rs.getLong("id");
                }
                rs.close();
                stm.close();
            } else {
                nomeSoggEr = idSoggetto.getNome();
                tipoSoggEr = idSoggetto.getTipo();
                longIdAccordoServizioParteComune = DBUtils.getIdAccordoServizioParteComune(idAccordoServizioParteComune, con, this.driver.tipoDB);
                sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject2.addFromTable("soggetti");
                sqlQueryObject2.addSelectField("*");
                sqlQueryObject2.addWhereCondition("nome_soggetto = ?");
                sqlQueryObject2.addWhereCondition("tipo_soggetto = ?");
                sqlQueryObject2.setANDLogicOperator(true);
                sqlQuery2 = sqlQueryObject2.createSQLQuery();
                stm = con.prepareStatement(sqlQuery2);
                stm.setString(1, nomeSoggEr);
                stm.setString(2, tipoSoggEr);
                this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery2, nomeSoggEr, tipoSoggEr));
                rs = stm.executeQuery();
                if (rs.next()) {
                    idSoggErogatore = rs.getLong("id");
                }
                rs.close();
                stm.close();
                sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject2.addFromTable("servizi");
                sqlQueryObject2.addSelectField("*");
                sqlQueryObject2.addWhereCondition("id_soggetto = ?");
                sqlQueryObject2.addWhereCondition("id_accordo = ?");
                sqlQueryObject2.addWhereCondition("servizio_correlato = ?");
                sqlQueryObject2.setANDLogicOperator(true);
                sqlQuery2 = sqlQueryObject2.createSQLQuery();
                stm = con.prepareStatement(sqlQuery2);
                stm.setLong(1, idSoggErogatore);
                stm.setLong(2, longIdAccordoServizioParteComune);
                stm.setString(3, DriverRegistroServiziDB_LIB.getValue(CostantiRegistroServizi.ABILITATO));
                this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery2, idSoggErogatore, longIdAccordoServizioParteComune, CostantiRegistroServizi.ABILITATO));
                rs = stm.executeQuery();
                if (rs.next()) {
                    nomeServizio = rs.getString("nome_servizio");
                    tipoServizio = rs.getString("tipo_servizio");
                    versioneServizio = rs.getInt("versione_servizio");
                    superUser = rs.getString("superuser");
                }
                rs.close();
                stm.close();
            }
            idConnettore = 0L;
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome_servizio = ?");
            sqlQueryObject.addWhereCondition("tipo_servizio = ?");
            sqlQueryObject.addWhereCondition("versione_servizio = ?");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, nomeServizio);
            stm.setString(2, tipoServizio);
            if (versioneServizio != null) {
                stm.setInt(3, versioneServizio);
            } else {
                stm.setInt(3, 1);
            }
            stm.setLong(4, idSoggErogatore);
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, nomeServizio, tipoServizio, versioneServizio, idSoggErogatore));
            rs = stm.executeQuery();
            if (!rs.next()) {
                throw new DriverRegistroServiziNotFound("Servizio [" + tipoServizio + "/" + nomeServizio + ":" + versioneServizio + "] erogato dal soggetto [" + tipoSoggEr + "/" + nomeSoggEr + "] non esiste");
            }
            longIdAccordoServizioParteSpecifica = rs.getLong("id");
            idConnettore = rs.getLong("id_connettore");
            longIdAccordoServizioParteComune = rs.getLong("id_accordo");
            superUser = rs.getString("superuser");
            accordoServizioParteSpecifica.setId(longIdAccordoServizioParteSpecifica);
            accordoServizioParteSpecifica.setIdAccordo(longIdAccordoServizioParteComune);
            accordoServizioParteSpecifica.setNome(rs.getString("nome_servizio"));
            accordoServizioParteSpecifica.setTipo(rs.getString("tipo_servizio"));
            accordoServizioParteSpecifica.setVersione(rs.getInt("versione_servizio"));
            accordoServizioParteSpecifica.setConfigurazioneServizio(new ConfigurazioneServizio());
            accordoServizioParteSpecifica.getConfigurazioneServizio().setConnettore(this.driver.getConnettore(idConnettore, con));
            String wsdlimpler = rs.getString("wsdl_implementativo_erogatore");
            accordoServizioParteSpecifica.setByteWsdlImplementativoErogatore(wsdlimpler != null && !wsdlimpler.trim().equals("") ? wsdlimpler.trim().getBytes() : null);
            String wsdlimplfru = rs.getString("wsdl_implementativo_fruitore");
            accordoServizioParteSpecifica.setByteWsdlImplementativoFruitore(wsdlimplfru != null && !wsdlimplfru.trim().equals("") ? wsdlimplfru.trim().getBytes() : null);
            String servizioCorrelato = rs.getString("servizio_correlato");
            if (CostantiRegistroServizi.ABILITATO.toString().equals(servizioCorrelato) || org.openspcoop2.core.registry.constants.TipologiaServizio.CORRELATO.toString().equals(servizioCorrelato)) {
                accordoServizioParteSpecifica.setTipologiaServizio(org.openspcoop2.core.registry.constants.TipologiaServizio.CORRELATO);
            } else {
                accordoServizioParteSpecifica.setTipologiaServizio(org.openspcoop2.core.registry.constants.TipologiaServizio.NORMALE);
            }
            accordoServizioParteSpecifica.setTipoSoggettoErogatore(tipoSoggEr);
            accordoServizioParteSpecifica.setNomeSoggettoErogatore(nomeSoggEr);
            accordoServizioParteSpecifica.setIdSoggetto(idSoggErogatore);
            if (rs.getInt("privato") == 1) {
                accordoServizioParteSpecifica.setPrivato(true);
            } else {
                accordoServizioParteSpecifica.setPrivato(false);
            }
            if (rs.getTimestamp("ora_registrazione") != null) {
                accordoServizioParteSpecifica.setOraRegistrazione(new Date(rs.getTimestamp("ora_registrazione").getTime()));
            }
            if ((tmp = rs.getString("port_type")) != null && !"".equals(tmp)) {
                accordoServizioParteSpecifica.setPortType(tmp);
            }
            if ((profilo = rs.getString("profilo")) != null) {
                profilo = profilo.trim();
                accordoServizioParteSpecifica.setVersioneProtocollo(profilo);
            }
            accordoServizioParteSpecifica.setSuperUser(superUser);
            accordoServizioParteSpecifica.setDescrizione(rs.getString("descrizione"));
            accordoServizioParteSpecifica.setStatoPackage(rs.getString("stato"));
            tmp = rs.getString("message_type");
            accordoServizioParteSpecifica.setMessageType(DriverRegistroServiziDB_LIB.getEnumMessageType(tmp == null || tmp.equals("") ? null : tmp));
            accordoServizioParteSpecifica.setProprietaOggetto(DriverRegistroServiziDB_utilsDriver.readProprietaOggetto(rs, false));
            rs.close();
            stm.close();
            long idSoggFruitore = 0L;
            Fruitore fruitore = null;
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_servizio = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, longIdAccordoServizioParteSpecifica);
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, longIdAccordoServizioParteSpecifica));
            rs = stm.executeQuery();
            while (rs.next()) {
                fruitore = new Fruitore();
                idSoggFruitore = rs.getLong("id_soggetto");
                idConnettore = rs.getLong("id_connettore");
                fruitore.setConnettore(this.driver.getConnettore(idConnettore, con));
                String wsdlimpler2 = rs.getString("wsdl_implementativo_erogatore");
                fruitore.setByteWsdlImplementativoErogatore(wsdlimpler2 != null && !wsdlimpler2.trim().equals("") ? wsdlimpler2.getBytes() : null);
                String wsdlimplfru2 = rs.getString("wsdl_implementativo_fruitore");
                fruitore.setByteWsdlImplementativoFruitore(wsdlimplfru2 != null && !wsdlimplfru2.trim().equals("") ? wsdlimplfru2.getBytes() : null);
                if (rs.getTimestamp("ora_registrazione") != null) {
                    fruitore.setOraRegistrazione(new Date(rs.getTimestamp("ora_registrazione").getTime()));
                }
                fruitore.setStatoPackage(rs.getString("stato"));
                fruitore.setDescrizione(rs.getString("descrizione"));
                fruitore.setProprietaOggetto(DriverRegistroServiziDB_utilsDriver.readProprietaOggetto(rs, false));
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id = ?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm1 = con.prepareStatement(sqlQuery);
                stm1.setLong(1, idSoggFruitore);
                this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idSoggFruitore));
                rs1 = stm1.executeQuery();
                if (!rs1.next()) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizioParteSpecifica] Non ho trovato i dati del soggetto fruitore necessario eseguendo: \n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idSoggFruitore));
                }
                fruitore.setNome(rs1.getString("nome_soggetto"));
                fruitore.setTipo(rs1.getString("tipo_soggetto"));
                rs1.close();
                stm1.close();
                fruitore.setId(rs.getLong("id"));
                try {
                    List<ProtocolProperty> listPP = DriverRegistroServiziDB_LIB.getListaProtocolProperty(fruitore.getId(), ProprietariProtocolProperty.FRUITORE, con, this.driver.tipoDB, this.driver.getDriverUnwrapBYOK());
                    if (listPP != null && !listPP.isEmpty()) {
                        for (ProtocolProperty protocolProperty : listPP) {
                            fruitore.addProtocolProperty(protocolProperty);
                        }
                    }
                }
                catch (DriverRegistroServiziNotFound listPP) {
                    // empty catch block
                }
                accordoServizioParteSpecifica.addFruitore(fruitore);
            }
            rs.close();
            stm.close();
            if (accordoServizioParteSpecifica.sizeFruitoreList() > 0) {
                for (Fruitore fruitoreLetto : accordoServizioParteSpecifica.getFruitoreList()) {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObject.addFromTable("servizi_fruitori_azioni");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("id_fruizione = ?");
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, fruitoreLetto.getId());
                    this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, fruitoreLetto.getId()));
                    rs = stm.executeQuery();
                    while (rs.next()) {
                        ConfigurazioneServizioAzione conf = new ConfigurazioneServizioAzione();
                        idConnettore = rs.getLong("id_connettore");
                        conf.setConnettore(this.driver.getConnettore(idConnettore, con));
                        conf.setId(rs.getLong("id"));
                        fruitoreLetto.addConfigurazioneAzione(conf);
                    }
                    rs.close();
                    stm.close();
                    if (fruitoreLetto.sizeConfigurazioneAzioneList() <= 0) continue;
                    for (ConfigurazioneServizioAzione conf : fruitoreLetto.getConfigurazioneAzioneList()) {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                        sqlQueryObject.addFromTable("servizi_fruitori_azione");
                        sqlQueryObject.addSelectField("*");
                        sqlQueryObject.addWhereCondition("id_fruizione_azioni = ?");
                        sqlQuery = sqlQueryObject.createSQLQuery();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, conf.getId());
                        this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, conf.getId()));
                        rs = stm.executeQuery();
                        while (rs.next()) {
                            conf.addAzione(rs.getString("nome_azione"));
                        }
                        rs.close();
                        stm.close();
                    }
                }
            }
        }
        catch (DriverRegistroServiziNotFound e) {
            try {
                throw e;
                catch (Exception se) {
                    this.driver.logDebug("[DriverRegistroServiziDB::getAccordoServizioParteSpecifica] Exception:" + se.getMessage(), se);
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizioParteSpecifica] Exception:" + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                JDBCUtilities.closeResources(rs1, stm1);
                this.driver.closeConnection(conParam, con);
                throw throwable;
            }
        }
        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
        sqlQueryObject.addFromTable("servizi_azioni");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("id_servizio = ?");
        sqlQuery = sqlQueryObject.createSQLQuery();
        stm = con.prepareStatement(sqlQuery);
        stm.setLong(1, longIdAccordoServizioParteSpecifica);
        this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, longIdAccordoServizioParteSpecifica));
        rs = stm.executeQuery();
        while (rs.next()) {
            ConfigurazioneServizioAzione conf = new ConfigurazioneServizioAzione();
            idConnettore = rs.getLong("id_connettore");
            conf.setConnettore(this.driver.getConnettore(idConnettore, con));
            conf.setId(rs.getLong("id"));
            accordoServizioParteSpecifica.getConfigurazioneServizio().addConfigurazioneAzione(conf);
        }
        rs.close();
        stm.close();
        if (accordoServizioParteSpecifica.getConfigurazioneServizio().sizeConfigurazioneAzioneList() > 0) {
            for (ConfigurazioneServizioAzione conf : accordoServizioParteSpecifica.getConfigurazioneServizio().getConfigurazioneAzioneList()) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi_azione");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_servizio_azioni = ?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, conf.getId());
                this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, conf.getId()));
                rs = stm.executeQuery();
                while (rs.next()) {
                    conf.addAzione(rs.getString("nome_azione"));
                }
                rs.close();
                stm.close();
            }
        }
        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
        sqlQueryObject.addFromTable("accordi");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("id = ?");
        sqlQuery = sqlQueryObject.createSQLQuery();
        stm = con.prepareStatement(sqlQuery);
        stm.setLong(1, longIdAccordoServizioParteComune);
        this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, longIdAccordoServizioParteComune));
        rs = stm.executeQuery();
        if (rs.next()) {
            accordoServizioParteSpecifica.setIdAccordo(longIdAccordoServizioParteComune);
            tmp = rs.getString("nome");
            int tmpVersione = rs.getInt("versione");
            long id_referente = rs.getLong("id_referente");
            IDSoggetto soggettoReferente = null;
            if (id_referente > 0L) {
                try {
                    soggettoReferente = this.driver.getIdSoggetto(id_referente, con);
                    if (soggettoReferente == null) {
                        throw new DriverRegistroServiziNotFound("non esiste");
                    }
                }
                catch (DriverRegistroServiziNotFound notFound) {
                    throw new Exception("Soggetto referente [" + id_referente + "] dell'accordo non esiste");
                }
            }
            accordoServizioParteSpecifica.setAccordoServizioParteComune(this.driver.idAccordoFactory.getUriFromValues(tmp, soggettoReferente, tmpVersione));
        }
        rs.close();
        stm.close();
        try {
            List<Documento> allegati = DriverRegistroServiziDB_documentiLIB.getListaDocumenti(RuoliDocumento.allegato.toString(), longIdAccordoServizioParteSpecifica, ProprietariDocumento.servizio, readContenutoAllegati, con, this.driver.tipoDB);
            for (int i = 0; i < allegati.size(); ++i) {
                accordoServizioParteSpecifica.addAllegato(allegati.get(i));
            }
        }
        catch (DriverRegistroServiziNotFound allegati) {
            // empty catch block
        }
        try {
            List<Documento> specificheSemiformali = DriverRegistroServiziDB_documentiLIB.getListaDocumenti(RuoliDocumento.specificaSemiformale.toString(), longIdAccordoServizioParteSpecifica, ProprietariDocumento.servizio, readContenutoAllegati, con, this.driver.tipoDB);
            for (int i = 0; i < specificheSemiformali.size(); ++i) {
                accordoServizioParteSpecifica.addSpecificaSemiformale(specificheSemiformali.get(i));
            }
        }
        catch (DriverRegistroServiziNotFound specificheSemiformali) {
            // empty catch block
        }
        try {
            List<Documento> specificheLivelloServizio = DriverRegistroServiziDB_documentiLIB.getListaDocumenti(RuoliDocumento.specificaLivelloServizio.toString(), longIdAccordoServizioParteSpecifica, ProprietariDocumento.servizio, readContenutoAllegati, con, this.driver.tipoDB);
            for (int i = 0; i < specificheLivelloServizio.size(); ++i) {
                accordoServizioParteSpecifica.addSpecificaLivelloServizio(specificheLivelloServizio.get(i));
            }
        }
        catch (DriverRegistroServiziNotFound specificheLivelloServizio) {
            // empty catch block
        }
        try {
            List<Documento> specificheSicurezza = DriverRegistroServiziDB_documentiLIB.getListaDocumenti(RuoliDocumento.specificaSicurezza.toString(), longIdAccordoServizioParteSpecifica, ProprietariDocumento.servizio, readContenutoAllegati, con, this.driver.tipoDB);
            for (int i = 0; i < specificheSicurezza.size(); ++i) {
                accordoServizioParteSpecifica.addSpecificaSicurezza(specificheSicurezza.get(i));
            }
        }
        catch (DriverRegistroServiziNotFound specificheSicurezza) {
            // empty catch block
        }
        try {
            List<ProtocolProperty> listPP = DriverRegistroServiziDB_LIB.getListaProtocolProperty(longIdAccordoServizioParteSpecifica, ProprietariProtocolProperty.ACCORDO_SERVIZIO_PARTE_SPECIFICA, con, this.driver.tipoDB, this.driver.getDriverUnwrapBYOK());
            if (listPP != null && !listPP.isEmpty()) {
                for (ProtocolProperty protocolProperty : listPP) {
                    accordoServizioParteSpecifica.addProtocolProperty(protocolProperty);
                }
            }
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        AccordoServizioParteSpecifica accordoServizioParteSpecifica2 = accordoServizioParteSpecifica;
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        JDBCUtilities.closeResources((ResultSet)rs1, (PreparedStatement)stm1);
        this.driver.closeConnection(conParam, con);
        return accordoServizioParteSpecifica2;
    }

    protected AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(long idServizio) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica(idServizio, null);
    }

    protected AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(long idServizio, boolean readContenutoAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica(idServizio, null, readContenutoAllegati);
    }

    protected AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(long idServizio, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica(idServizio, conParam, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(long idServizio, Connection conParam, boolean readContenutoAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idServizio <= 0L) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getServizio] L'id del servizio deve essere > 0.");
        }
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (conParam != null) {
            con = conParam;
        } else if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getAccordoServizioParteSpecifica(longId)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getServizio] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        IDServizio idServizioObject = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("tipo_servizio");
            sqlQueryObject.addSelectField("nome_servizio");
            sqlQueryObject.addSelectField("versione_servizio");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addSelectField("servizio_correlato");
            sqlQueryObject.addWhereCondition("servizi.id = ?");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto=soggetti.id");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idServizio);
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idServizio));
            rs = stm.executeQuery();
            if (!rs.next()) throw new DriverRegistroServiziNotFound("Nessun Servizio trovato con id=" + idServizio);
            IDSoggetto soggettoErogatore = new IDSoggetto(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"));
            idServizioObject = this.driver.idServizioFactory.getIDServizioFromValues(rs.getString("tipo_servizio"), rs.getString("nome_servizio"), soggettoErogatore, rs.getInt("versione_servizio"));
            if (CostantiRegistroServizi.ABILITATO.toString().equals(rs.getString("servizio_correlato")) || org.openspcoop2.core.registry.constants.TipologiaServizio.CORRELATO.toString().equals(rs.getString("servizio_correlato"))) {
                idServizioObject.setTipologia(TipologiaServizio.CORRELATO);
            } else {
                idServizioObject.setTipologia(TipologiaServizio.NORMALE);
            }
            rs.close();
            stm.close();
        }
        catch (SQLException se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getServizio] SqlException: " + se.getMessage(), se);
                catch (DriverRegistroServiziNotFound nf) {
                    throw nf;
                }
                catch (Exception se2) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getServizio] Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(conParam, con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(conParam, con);
        return this.getAccordoServizioParteSpecifica(idServizioObject, readContenutoAllegati, conParam);
    }

    protected List<AccordoServizioParteSpecifica> serviziWithIdAccordoList(long idAccordo) throws DriverRegistroServiziException {
        ArrayList<AccordoServizioParteSpecifica> arrayList;
        String nomeMetodo = "serviziWithIdAccordoList";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoServizioParteSpecifica> lista = new ArrayList<AccordoServizioParteSpecifica>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("serviziWithIdAccordoList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordo);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                AccordoServizioParteSpecifica serv = this.getAccordoServizioParteSpecifica(risultato.getLong("id"));
                lista.add(serv);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<IDSoggetto> getAllIdSoggettiErogatori(String tipoServizio, String nomeServizio, String uriAccordo, String nomePortType, String tipoSoggetto) throws DriverRegistroServiziException {
        ArrayList<IDSoggetto> arrayList;
        String nomeMetodo = "getAllIdSoggettiErogatori";
        ArrayList<IDSoggetto> lista = new ArrayList<IDSoggetto>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        try {
            if (this.driver.atomica) {
                try {
                    con = this.driver.getConnectionFromDatasource("getAllIdSoggettiErogatori");
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.driver.globalConnection;
            }
            this.driver.logDebug("operazione this.atomica = " + this.driver.atomica);
            IDAccordo idAccordo = this.driver.idAccordoFactory.getIDAccordoFromUri(uriAccordo);
            long idAccordoLong = DBUtils.getIdAccordoServizioParteComune(idAccordo, con, this.driver.tipoDB);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addSelectAliasField("soggetti", "tipo_soggetto", "tipoSoggetto");
            sqlQueryObject.addSelectAliasField("soggetti", "nome_soggetto", "nomeSoggetto");
            sqlQueryObject.addWhereCondition("soggetti.id=servizi.id_soggetto");
            sqlQueryObject.addWhereCondition("servizi.tipo_servizio= ?");
            sqlQueryObject.addWhereCondition("servizi.nome_servizio= ?");
            sqlQueryObject.addWhereCondition("servizi.id_accordo = ?");
            sqlQueryObject.addWhereCondition("servizi.port_type = ?");
            if (tipoSoggetto != null) {
                sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto = ?");
            }
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, tipoServizio);
            stmt.setString(2, nomeServizio);
            stmt.setLong(3, idAccordoLong);
            stmt.setString(4, nomePortType);
            if (tipoSoggetto != null) {
                stmt.setString(5, tipoSoggetto);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                String tipo_soggetto = risultato.getString("tipoSoggetto");
                String nome_soggetto = risultato.getString("nomeSoggetto");
                lista.add(new IDSoggetto(tipo_soggetto, nome_soggetto));
            }
            arrayList = lista;
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected void validaStatoAccordoServizioParteSpecifica(AccordoServizioParteSpecifica servizio, boolean gestioneWsdlImplementativo, boolean checkConnettore) throws ValidazioneStatoPackageException {
        ValidazioneStatoPackageException erroreValidazione;
        block23: {
            erroreValidazione = new ValidazioneStatoPackageException("Servizio", servizio.getStatoPackage(), null);
            try {
                Soggetto soggettoErogatore;
                AccordoServizioParteComune as;
                if (servizio.getPrivato() == null || !servizio.getPrivato().booleanValue()) {
                    IDSoggetto idS = new IDSoggetto(servizio.getTipoSoggettoErogatore(), servizio.getNomeSoggettoErogatore());
                    try {
                        Soggetto s = this.driver.getSoggetto(idS);
                        if (s.getPrivato() != null && s.getPrivato().booleanValue()) {
                            erroreValidazione.addErroreValidazione("soggetto erogatore [" + idS + "] con visibilita' privata, in un servizio con visibilita' pubblica");
                        }
                    }
                    catch (DriverRegistroServiziNotFound s) {
                        // empty catch block
                    }
                    try {
                        AccordoServizioParteComune as2 = this.driver.getAccordoServizioParteComune(this.driver.idAccordoFactory.getIDAccordoFromUri(servizio.getAccordoServizioParteComune()));
                        if (as2.getPrivato() != null && as2.getPrivato().booleanValue()) {
                            erroreValidazione.addErroreValidazione("accordo di servizio [" + servizio.getAccordoServizioParteComune() + "] con visibilita' privata, in un servizio con visibilita' pubblica");
                        }
                    }
                    catch (DriverRegistroServiziNotFound as2) {
                        // empty catch block
                    }
                }
                if (StatiAccordo.bozza.toString().equals(servizio.getStatoPackage())) break block23;
                if (StatiAccordo.operativo.toString().equals(servizio.getStatoPackage())) {
                    try {
                        as = this.driver.getAccordoServizioParteComune(this.driver.idAccordoFactory.getIDAccordoFromUri(servizio.getAccordoServizioParteComune()));
                        if (!StatiAccordo.finale.toString().equals(as.getStatoPackage()) && !StatiAccordo.operativo.toString().equals(as.getStatoPackage())) {
                            erroreValidazione.addErroreValidazione("accordo di servizio riferito [" + this.driver.idAccordoFactory.getUriFromAccordo(as) + "] possiede lo stato [" + as.getStatoPackage() + "]");
                        }
                        break block23;
                    }
                    catch (DriverRegistroServiziNotFound dNot) {
                        erroreValidazione.addErroreValidazione("accordo di servizio non definito");
                    }
                    break block23;
                }
                if (!StatiAccordo.finale.toString().equals(servizio.getStatoPackage())) break block23;
                as = null;
                try {
                    as = this.driver.getAccordoServizioParteComune(this.driver.idAccordoFactory.getIDAccordoFromUri(servizio.getAccordoServizioParteComune()));
                    if (!StatiAccordo.finale.toString().equals(as.getStatoPackage())) {
                        erroreValidazione.addErroreValidazione("accordo di servizio [" + this.driver.idAccordoFactory.getUriFromAccordo(as) + "] in uno stato non finale [" + as.getStatoPackage() + "]");
                    }
                }
                catch (DriverRegistroServiziNotFound dNot) {
                    erroreValidazione.addErroreValidazione("accordo di servizio non definito");
                }
                if (as != null && ServiceBinding.SOAP.equals(as.getServiceBinding()) && gestioneWsdlImplementativo) {
                    if (org.openspcoop2.core.registry.constants.TipologiaServizio.CORRELATO.equals(servizio.getTipologiaServizio())) {
                        String wsdlImplementativoFruitore = servizio.getByteWsdlImplementativoFruitore() != null ? new String(servizio.getByteWsdlImplementativoFruitore()) : null;
                        String string = wsdlImplementativoFruitore = wsdlImplementativoFruitore != null && !"".equals(wsdlImplementativoFruitore.trim().replaceAll("\n", "")) ? wsdlImplementativoFruitore : null;
                        if (wsdlImplementativoFruitore == null) {
                            erroreValidazione.addErroreValidazione("WSDL Implementativo fruitore non definito");
                        }
                    } else {
                        String wsdlImplementativoErogatore = servizio.getByteWsdlImplementativoErogatore() != null ? new String(servizio.getByteWsdlImplementativoErogatore()) : null;
                        String string = wsdlImplementativoErogatore = wsdlImplementativoErogatore != null && !"".equals(wsdlImplementativoErogatore.trim().replaceAll("\n", "")) ? wsdlImplementativoErogatore : null;
                        if (wsdlImplementativoErogatore == null) {
                            erroreValidazione.addErroreValidazione("WSDL Implementativo erogatore non definito");
                        }
                    }
                }
                if (checkConnettore && (servizio.getConfigurazioneServizio().getConnettore() == null || CostantiDB.CONNETTORE_TIPO_DISABILITATO.equals(servizio.getConfigurazioneServizio().getConnettore().getTipo())) && ((soggettoErogatore = this.driver.getSoggetto(new IDSoggetto(servizio.getTipoSoggettoErogatore(), servizio.getNomeSoggettoErogatore()))).getConnettore() == null || CostantiDB.CONNETTORE_TIPO_DISABILITATO.equals(soggettoErogatore.getConnettore().getTipo()))) {
                    erroreValidazione.addErroreValidazione("Sia l'Accordo di servizio parte specifica che il soggetto erogatore non possiedono un connettore");
                }
            }
            catch (Exception e) {
                throw new ValidazioneStatoPackageException(e);
            }
        }
        if (erroreValidazione.sizeErroriValidazione() > 0) {
            throw erroreValidazione;
        }
    }

    protected void updateProprietaOggettoErogazione(IDServizio idServizioObject, String user) throws DriverRegistroServiziException {
        String nomeMetodo = "updateProprietaOggettoErogazione";
        Connection con = null;
        long idServizio = -1L;
        try {
            if (this.driver.atomica) {
                try {
                    con = this.driver.getConnectionFromDatasource(nomeMetodo);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.driver.globalConnection;
            }
            this.driver.logDebug("operazione this.atomica = " + this.driver.atomica);
            idServizio = DBUtils.getIdAccordoServizioParteSpecifica(idServizioObject, con, DriverRegistroServiziDB_LIB.tipoDB);
            if (idServizio <= 0L) {
                throw new DriverRegistroServiziException("Servizio con id '" + idServizioObject + "' non esistente");
            }
            this.driver.closeConnection(con);
        }
        catch (Exception e) {
            try {
                DriverRegistroServiziDB_LIB.logError("Errore", e);
                throw new DriverRegistroServiziException(e);
            }
            catch (Throwable throwable) {
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        this.updateProprietaOggettoEngine(idServizio, user, "servizi");
    }

    protected void updateProprietaOggettoErogazione(long idServizio, String user) throws DriverRegistroServiziException {
        this.updateProprietaOggettoEngine(idServizio, user, "servizi");
    }

    protected void updateProprietaOggettoFruizione(IDServizio idServizioObject, IDSoggetto idFruitore, String user) throws DriverRegistroServiziException {
        String nomeMetodo = "updateProprietaOggettoFruizione";
        Connection con = null;
        long idFruizione = -1L;
        try {
            if (this.driver.atomica) {
                try {
                    con = this.driver.getConnectionFromDatasource(nomeMetodo);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.driver.globalConnection;
            }
            this.driver.logDebug("operazione this.atomica = " + this.driver.atomica);
            idFruizione = DBUtils.getIdFruizioneServizio(idServizioObject, idFruitore, con, DriverRegistroServiziDB_LIB.tipoDB);
            if (idFruizione <= 0L) {
                throw new DriverRegistroServiziException("Servizio con id '" + idServizioObject + "' non esistente");
            }
            this.driver.closeConnection(con);
        }
        catch (Exception e) {
            try {
                DriverRegistroServiziDB_LIB.logError("Errore", e);
                throw new DriverRegistroServiziException(e);
            }
            catch (Throwable throwable) {
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        this.updateProprietaOggettoEngine(idFruizione, user, "servizi_fruitori");
    }

    protected void updateProprietaOggettoFruizione(long idFruizione, String user) throws DriverRegistroServiziException {
        this.updateProprietaOggettoEngine(idFruizione, user, "servizi_fruitori");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateProprietaOggettoEngine(long id, String user, String tabella) throws DriverRegistroServiziException {
        String nomeMetodo = "updateProprietaOggetto_" + tabella;
        Connection con = null;
        PreparedStatement stm = null;
        try {
            if (this.driver.atomica) {
                try {
                    con = this.driver.getConnectionFromDatasource(nomeMetodo);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.driver.globalConnection;
            }
            this.driver.logDebug("operazione this.atomica = " + this.driver.atomica);
            ISQLQueryObject sqlQueryObjectUpdate = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
            sqlQueryObjectUpdate.addUpdateTable(tabella);
            sqlQueryObjectUpdate.addUpdateField("utente_ultima_modifica", "?");
            sqlQueryObjectUpdate.addUpdateField("data_ultima_modifica", "?");
            sqlQueryObjectUpdate.addWhereCondition("id=?");
            String updateString = sqlQueryObjectUpdate.createSQLUpdate();
            stm = con.prepareStatement(updateString);
            int index = 1;
            stm.setString(index++, user);
            stm.setTimestamp(index++, DateManager.getTimestamp());
            stm.setLong(index, id);
            int n = stm.executeUpdate();
            stm.close();
            DriverRegistroServiziDB_LIB.logDebug("Aggiornata " + n + " entry per l'operazione di ultima modifica della tabella '" + tabella + "' con id: " + id);
        }
        catch (SQLException e) {
            try {
                DriverRegistroServiziDB_LIB.logError("Errore SQL", e);
                throw new DriverRegistroServiziException(e);
                catch (Exception e2) {
                    DriverRegistroServiziDB_LIB.logError("Errore", e2);
                    throw new DriverRegistroServiziException(e2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((PreparedStatement)stm);
        this.driver.closeConnection(con);
    }
}

