/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.ResourceParameter;
import org.openspcoop2.core.registry.ResourceRepresentation;
import org.openspcoop2.core.registry.ResourceRepresentationJson;
import org.openspcoop2.core.registry.ResourceRepresentationXml;
import org.openspcoop2.core.registry.ResourceRequest;
import org.openspcoop2.core.registry.ResourceResponse;
import org.openspcoop2.core.registry.constants.HttpMethod;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_LIB;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverRegistroServiziDB_accordiRestDriver {
    private DriverRegistroServiziDB driver = null;

    protected DriverRegistroServiziDB_accordiRestDriver(DriverRegistroServiziDB driver) {
        this.driver = driver;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readResources(AccordoServizioParteComune as, Connection conParam, boolean readDatiRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = null;
        try {
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = conParam != null ? conParam : (this.driver.atomica ? this.driver.getConnectionFromDatasource("readResources") : this.driver.globalConnection);
            if (as.getId() == null) throw new Exception("Accordo id non definito");
            if (as.getId() <= 0L) {
                throw new Exception("Accordo id non definito");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("api_resources");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("path");
            sqlQueryObject.addOrderBy("http_method");
            sqlQueryObject.setSortType(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, as.getId());
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, as.getId()));
            rs = stm.executeQuery();
            while (rs.next()) {
                Resource resource = new Resource();
                String tmp = rs.getString("nome");
                resource.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("descrizione");
                resource.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("http_method");
                resource.setMethod(DriverRegistroServiziDB_LIB.getEnumHttpMethod(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("path");
                if (tmp != null && !"*".equals(tmp.trim())) {
                    resource.setPath(tmp);
                }
                resource.setMessageType(DriverRegistroServiziDB_LIB.getEnumMessageType((tmp = rs.getString("message_type")) == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("message_type_request");
                resource.setRequestMessageType(DriverRegistroServiziDB_LIB.getEnumMessageType(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("message_type_response");
                resource.setResponseMessageType(DriverRegistroServiziDB_LIB.getEnumMessageType(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("conferma_ricezione");
                resource.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("consegna_in_ordine");
                resource.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("filtro_duplicati");
                resource.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("identificativo_collaborazione");
                resource.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("id_riferimento_richiesta");
                resource.setIdRiferimentoRichiesta(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("scadenza");
                resource.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_azione");
                if (tmp == null || tmp.equals("")) {
                    resource.setProfAzione("default");
                } else {
                    resource.setProfAzione(tmp);
                }
                resource.setIdAccordo(as.getId());
                long idResource = rs.getLong("id");
                resource.setId(idResource);
                if (readDatiRegistro) {
                    this.readResourcesDetails(resource, true, con);
                    this.readResourcesDetails(resource, false, con);
                }
                try {
                    List<ProtocolProperty> listPP = DriverRegistroServiziDB_LIB.getListaProtocolProperty(idResource, ProprietariProtocolProperty.RESOURCE, con, this.driver.tipoDB, this.driver.getDriverUnwrapBYOK());
                    if (listPP != null && !listPP.isEmpty()) {
                        for (ProtocolProperty protocolProperty : listPP) {
                            resource.addProtocolProperty(protocolProperty);
                        }
                    }
                }
                catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                    // empty catch block
                }
                as.addResource(resource);
            }
            rs.close();
            stm.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            try {
                throw e;
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readResources] Exception :" + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(conParam, con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(conParam, con);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readResourcesDetails(Resource resource, boolean request, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ResultSet rs;
        PreparedStatement stm;
        Connection con;
        block12: {
            con = null;
            stm = null;
            rs = null;
            String sqlQuery = null;
            try {
                this.driver.logDebug("operazione atomica = " + this.driver.atomica);
                con = conParam != null ? conParam : (this.driver.atomica ? this.driver.getConnectionFromDatasource("readResourcesDetails(request:" + request + ")") : this.driver.globalConnection);
                if (resource.getId() == null) throw new Exception("Resource id non definito");
                if (resource.getId() <= 0L) {
                    throw new Exception("Resource id non definito");
                }
                if (request) {
                    List<ResourceParameter> lp;
                    resource.setRequest(new ResourceRequest());
                    resource.getRequest().setIdResource(resource.getId());
                    List<ResourceRepresentation> l = this.readResourcesMedia(resource.getId(), true, con);
                    if (l != null && l.size() > 0) {
                        resource.getRequest().getRepresentationList().addAll(l);
                    }
                    if ((lp = this.readResourcesParameters(resource.getId(), true, con)) != null && lp.size() > 0) {
                        resource.getRequest().getParameterList().addAll(lp);
                    }
                    break block12;
                }
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("api_resources_response");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_resource = ?");
                sqlQueryObject.addOrderBy("status");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, resource.getId());
                this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, resource.getId()));
                rs = stm.executeQuery();
                while (rs.next()) {
                    List<ResourceParameter> lp;
                    ResourceResponse rr = new ResourceResponse();
                    rr.setIdResource(resource.getId());
                    String tmp = rs.getString("descrizione");
                    rr.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                    int status = rs.getInt("status");
                    rr.setStatus(status);
                    long idRR = rs.getLong("id");
                    rr.setId(idRR);
                    List<ResourceRepresentation> l = this.readResourcesMedia(idRR, false, con);
                    if (l != null && l.size() > 0) {
                        rr.getRepresentationList().addAll(l);
                    }
                    if ((lp = this.readResourcesParameters(idRR, false, con)) != null && lp.size() > 0) {
                        rr.getParameterList().addAll(lp);
                    }
                    resource.addResponse(rr);
                }
                rs.close();
                stm.close();
            }
            catch (DriverRegistroServiziNotFound e) {
                try {
                    throw e;
                    catch (Exception se) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readResourcesDetails] Exception :" + se.getMessage(), se);
                    }
                }
                catch (Throwable throwable) {
                    JDBCUtilities.closeResources(rs, stm);
                    this.driver.closeConnection(conParam, con);
                    throw throwable;
                }
            }
        }
        JDBCUtilities.closeResources(rs, (PreparedStatement)stm);
        this.driver.closeConnection(conParam, con);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<ResourceRepresentation> readResourcesMedia(long idResourceDetail, boolean request, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<ResourceRepresentation> arrayList;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = null;
        try {
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = conParam != null ? conParam : (this.driver.atomica ? this.driver.getConnectionFromDatasource("readResourcesMedia(" + idResourceDetail + ")") : this.driver.globalConnection);
            if (idResourceDetail <= 0L) {
                throw new Exception("ResourceDetail id non definito");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("api_resources_media");
            sqlQueryObject.addSelectField("*");
            if (request) {
                sqlQueryObject.addWhereCondition("id_resource_media = ?");
            } else {
                sqlQueryObject.addWhereCondition("id_resource_response_media = ?");
            }
            sqlQueryObject.addOrderBy("media_type");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idResourceDetail);
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idResourceDetail));
            rs = stm.executeQuery();
            ArrayList<ResourceRepresentation> list = new ArrayList<ResourceRepresentation>();
            while (rs.next()) {
                ResourceRepresentation rr = new ResourceRepresentation();
                String tmp = rs.getString("media_type");
                rr.setMediaType(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("message_type");
                rr.setMessageType(DriverRegistroServiziDB_LIB.getEnumMessageType(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("nome");
                rr.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("descrizione");
                rr.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("tipo");
                rr.setRepresentationType(DriverRegistroServiziDB_LIB.getEnumRepresentationType(tmp == null || tmp.equals("") ? null : tmp));
                if (rr.getRepresentationType() != null) {
                    switch (rr.getRepresentationType()) {
                        case XML: {
                            ResourceRepresentationXml xml = new ResourceRepresentationXml();
                            tmp = rs.getString("xml_tipo");
                            xml.setXmlType(DriverRegistroServiziDB_LIB.getEnumRepresentationXmlType(tmp == null || tmp.equals("") ? null : tmp));
                            tmp = rs.getString("xml_name");
                            xml.setNome(tmp == null || tmp.equals("") ? null : tmp);
                            tmp = rs.getString("xml_namespace");
                            xml.setNamespace(tmp == null || tmp.equals("") ? null : tmp);
                            rr.setXml(xml);
                            break;
                        }
                        case JSON: {
                            ResourceRepresentationJson json = new ResourceRepresentationJson();
                            tmp = rs.getString("json_type");
                            json.setTipo(tmp == null || tmp.equals("") ? null : tmp);
                            rr.setJson(json);
                            break;
                        }
                    }
                }
                long idRR = rs.getLong("id");
                rr.setId(idRR);
                list.add(rr);
            }
            rs.close();
            stm.close();
            arrayList = list;
        }
        catch (DriverRegistroServiziNotFound e) {
            try {
                throw e;
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readResourcesMedia] Exception :" + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(conParam, con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(conParam, con);
        return arrayList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<ResourceParameter> readResourcesParameters(long idResourceDetail, boolean request, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<ResourceParameter> arrayList;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = null;
        try {
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = conParam != null ? conParam : (this.driver.atomica ? this.driver.getConnectionFromDatasource("readResourcesMedia(" + idResourceDetail + ")") : this.driver.globalConnection);
            if (idResourceDetail <= 0L) {
                throw new Exception("ResourceDetail id non definito");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("api_resources_parameter");
            sqlQueryObject.addSelectField("*");
            if (request) {
                sqlQueryObject.addWhereCondition("id_resource_parameter = ?");
            } else {
                sqlQueryObject.addWhereCondition("id_resource_response_par = ?");
            }
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idResourceDetail);
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idResourceDetail));
            rs = stm.executeQuery();
            ArrayList<ResourceParameter> list = new ArrayList<ResourceParameter>();
            while (rs.next()) {
                ResourceParameter rr = new ResourceParameter();
                String tmp = rs.getString("nome");
                rr.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("descrizione");
                rr.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("tipo_parametro");
                rr.setParameterType(DriverRegistroServiziDB_LIB.getEnumParameterType(tmp == null || tmp.equals("") ? null : tmp));
                boolean req = rs.getBoolean("required");
                rr.setRequired(req);
                tmp = rs.getString("tipo");
                rr.setTipo(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("restrizioni");
                rr.setRestrizioni(tmp == null || tmp.equals("") ? null : tmp);
                long idRR = rs.getLong("id");
                rr.setId(idRR);
                list.add(rr);
            }
            rs.close();
            stm.close();
            arrayList = list;
        }
        catch (DriverRegistroServiziNotFound e) {
            try {
                throw e;
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readResourcesParameters] Exception :" + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(conParam, con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(conParam, con);
        return arrayList;
    }

    protected List<Resource> accordiResourceList(long idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        ArrayList<Resource> arrayList;
        String nomeMetodo = "accordiResourceList";
        int idLista = Liste.ACCORDI_API_RESOURCES;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        String filterHttpMethod = SearchUtils.getFilter(ricerca, idLista, "filtroHttpMethod");
        HttpMethod httpMethod = null;
        if (filterHttpMethod != null) {
            httpMethod = HttpMethod.toEnumConstant(filterHttpMethod);
        }
        this.driver.logDebug("search : " + search);
        this.driver.logDebug("filterHttpMethod : " + filterHttpMethod);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<Resource> lista = new ArrayList<Resource>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("accordiResourceList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject;
            String queryString;
            ISQLQueryObject sqlQueryObject2;
            if (!search.equals("")) {
                sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject2.addFromTable("api_resources");
                sqlQueryObject2.addSelectCountField("*", "cont");
                sqlQueryObject2.addWhereCondition("id_accordo = ?");
                sqlQueryObject2.addWhereCondition(false, new String[]{sqlQueryObject2.getWhereLikeCondition("path", search, true, true)});
                if (httpMethod != null) {
                    sqlQueryObject2.addWhereCondition("http_method = ?");
                }
                sqlQueryObject2.setANDLogicOperator(true);
                queryString = sqlQueryObject2.createSQLQuery();
            } else {
                sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject2.addFromTable("api_resources");
                sqlQueryObject2.addSelectCountField("*", "cont");
                sqlQueryObject2.addWhereCondition("id_accordo = ?");
                if (httpMethod != null) {
                    sqlQueryObject2.addWhereCondition("http_method = ?");
                }
                sqlQueryObject2.setANDLogicOperator(true);
                queryString = sqlQueryObject2.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            int index = 1;
            stmt.setLong(index++, idAccordo);
            if (httpMethod != null) {
                stmt.setString(index++, httpMethod.name());
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("api_resources");
                sqlQueryObject.addSelectField("id_accordo");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("http_method");
                sqlQueryObject.addSelectField("path");
                sqlQueryObject.addSelectField("message_type");
                sqlQueryObject.addSelectField("conferma_ricezione");
                sqlQueryObject.addSelectField("consegna_in_ordine");
                sqlQueryObject.addSelectField("filtro_duplicati");
                sqlQueryObject.addSelectField("identificativo_collaborazione");
                sqlQueryObject.addSelectField("id_riferimento_richiesta");
                sqlQueryObject.addSelectField("scadenza");
                sqlQueryObject.addSelectField("profilo_azione");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_accordo = ?");
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("path", search, true, true)});
                if (httpMethod != null) {
                    sqlQueryObject.addWhereCondition("http_method = ?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("path");
                sqlQueryObject.addOrderBy("http_method");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("api_resources");
                sqlQueryObject.addSelectField("id_accordo");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("http_method");
                sqlQueryObject.addSelectField("path");
                sqlQueryObject.addSelectField("message_type");
                sqlQueryObject.addSelectField("conferma_ricezione");
                sqlQueryObject.addSelectField("consegna_in_ordine");
                sqlQueryObject.addSelectField("filtro_duplicati");
                sqlQueryObject.addSelectField("identificativo_collaborazione");
                sqlQueryObject.addSelectField("id_riferimento_richiesta");
                sqlQueryObject.addSelectField("scadenza");
                sqlQueryObject.addSelectField("profilo_azione");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_accordo = ?");
                if (httpMethod != null) {
                    sqlQueryObject.addWhereCondition("http_method = ?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("path");
                sqlQueryObject.addOrderBy("http_method");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            index = 1;
            stmt.setLong(index++, idAccordo);
            if (httpMethod != null) {
                stmt.setString(index++, httpMethod.name());
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Resource resource = new Resource();
                String tmp = risultato.getString("nome");
                resource.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("descrizione");
                resource.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("http_method");
                resource.setMethod(DriverRegistroServiziDB_LIB.getEnumHttpMethod(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("path");
                if (tmp != null && !"*".equals(tmp.trim())) {
                    resource.setPath(tmp);
                }
                resource.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("conferma_ricezione")));
                resource.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("consegna_in_ordine")));
                resource.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("filtro_duplicati")));
                resource.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("identificativo_collaborazione")));
                resource.setIdRiferimentoRichiesta(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("id_riferimento_richiesta")));
                resource.setScadenza(risultato.getString("scadenza"));
                resource.setProfAzione(risultato.getString("profilo_azione"));
                tmp = risultato.getString("message_type");
                resource.setMessageType(DriverRegistroServiziDB_LIB.getEnumMessageType(tmp == null || tmp.equals("") ? null : tmp));
                resource.setIdAccordo(risultato.getLong("id_accordo"));
                long idResource = risultato.getLong("id");
                resource.setId(idResource);
                lista.add(resource);
            }
            arrayList = lista;
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<ResourceResponse> accordiResourceResponseList(long idRisorsa, ISearch ricerca) throws DriverRegistroServiziException {
        Cloneable resource;
        String nomeMetodo = "accordiResourceResponseList";
        int idLista = Liste.ACCORDI_API_RESOURCES_RESPONSE;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<Cloneable> lista = new ArrayList<Cloneable>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("accordiResourceList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("api_resources_response");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_resource = ?");
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("descrizione", search, true, true), "status = ?"});
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("api_resources_response");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_resource = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idRisorsa);
            if (!search.equals("")) {
                try {
                    stmt.setInt(2, Integer.parseInt(search));
                }
                catch (Exception e) {
                    stmt.setInt(2, -1);
                }
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("api_resources_response");
                sqlQueryObject.addSelectField("id_resource");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("status");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_resource = ?");
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("descrizione", search, true, true), "status = ?"});
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("status");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("api_resources_response");
                sqlQueryObject.addSelectField("id_resource");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("status");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_resource = ?");
                sqlQueryObject.addOrderBy("status");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idRisorsa);
            if (!search.equals("")) {
                try {
                    stmt.setInt(2, Integer.parseInt(search));
                }
                catch (Exception e) {
                    stmt.setInt(2, -1);
                }
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                resource = new ResourceResponse();
                ((ResourceResponse)resource).setStatus(risultato.getInt("status"));
                String tmp = risultato.getString("descrizione");
                ((ResourceResponse)resource).setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                ((ResourceResponse)resource).setIdResource(risultato.getLong("id_resource"));
                long idResource = risultato.getLong("id");
                resource.setId(idResource);
                lista.add(resource);
            }
            resource = lista;
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return resource;
    }

    protected List<ResourceRepresentation> accordiResourceRepresentationsList(Long idRisorsa, boolean isRequest, Long idRisposta, ISearch ricerca) throws DriverRegistroServiziException {
        ArrayList<ResourceRepresentation> rr;
        String nomeMetodo = "accordiResourceRepresentationsList";
        int idLista = Liste.ACCORDI_API_RESOURCES_REPRESENTATION_REQUEST;
        if (!isRequest) {
            idLista = Liste.ACCORDI_API_RESOURCES_REPRESENTATION_RESPONSE;
        }
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<ArrayList<ResourceRepresentation>> lista = new ArrayList<ArrayList<ResourceRepresentation>>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("accordiPorttypeOperationMessagePartList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("api_resources_media");
                sqlQueryObject.addSelectCountField("*", "cont");
                if (isRequest) {
                    sqlQueryObject.addWhereCondition("id_resource_media = ?");
                } else {
                    sqlQueryObject.addWhereCondition("id_resource_response_media = ?");
                }
                sqlQueryObject.addWhereLikeCondition("media_type", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("api_resources_media");
                sqlQueryObject.addSelectCountField("*", "cont");
                if (isRequest) {
                    sqlQueryObject.addWhereCondition("id_resource_media = ?");
                } else {
                    sqlQueryObject.addWhereCondition("id_resource_response_media = ?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (isRequest) {
                stmt.setLong(1, idRisorsa);
            } else {
                stmt.setLong(1, idRisposta);
            }
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("api_resources_media");
                sqlQueryObject.addSelectField("id_resource_media");
                sqlQueryObject.addSelectField("id_resource_response_media");
                sqlQueryObject.addSelectField("media_type");
                sqlQueryObject.addSelectField("message_type");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("tipo");
                sqlQueryObject.addSelectField("xml_tipo");
                sqlQueryObject.addSelectField("xml_name");
                sqlQueryObject.addSelectField("xml_namespace");
                sqlQueryObject.addSelectField("json_type");
                sqlQueryObject.addSelectField("id");
                if (isRequest) {
                    sqlQueryObject.addWhereCondition("id_resource_media = ?");
                } else {
                    sqlQueryObject.addWhereCondition("id_resource_response_media = ?");
                }
                sqlQueryObject.addWhereLikeCondition("media_type", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("api_resources_media");
                sqlQueryObject.addSelectField("id_resource_media");
                sqlQueryObject.addSelectField("id_resource_response_media");
                sqlQueryObject.addSelectField("media_type");
                sqlQueryObject.addSelectField("message_type");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("tipo");
                sqlQueryObject.addSelectField("xml_tipo");
                sqlQueryObject.addSelectField("xml_name");
                sqlQueryObject.addSelectField("xml_namespace");
                sqlQueryObject.addSelectField("json_type");
                sqlQueryObject.addSelectField("id");
                if (isRequest) {
                    sqlQueryObject.addWhereCondition("id_resource_media = ?");
                } else {
                    sqlQueryObject.addWhereCondition("id_resource_response_media = ?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (isRequest) {
                stmt.setLong(1, idRisorsa);
            } else {
                stmt.setLong(1, idRisposta);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                rr = new ResourceRepresentation();
                String tmp = risultato.getString("media_type");
                ((ResourceRepresentation)((Object)rr)).setMediaType(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("message_type");
                ((ResourceRepresentation)((Object)rr)).setMessageType(DriverRegistroServiziDB_LIB.getEnumMessageType(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("nome");
                ((ResourceRepresentation)((Object)rr)).setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("descrizione");
                ((ResourceRepresentation)((Object)rr)).setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("tipo");
                ((ResourceRepresentation)((Object)rr)).setRepresentationType(DriverRegistroServiziDB_LIB.getEnumRepresentationType(tmp == null || tmp.equals("") ? null : tmp));
                if (((ResourceRepresentation)((Object)rr)).getRepresentationType() != null) {
                    switch (((ResourceRepresentation)((Object)rr)).getRepresentationType()) {
                        case XML: {
                            ResourceRepresentationXml xml = new ResourceRepresentationXml();
                            tmp = risultato.getString("xml_tipo");
                            xml.setXmlType(DriverRegistroServiziDB_LIB.getEnumRepresentationXmlType(tmp == null || tmp.equals("") ? null : tmp));
                            tmp = risultato.getString("xml_name");
                            xml.setNome(tmp == null || tmp.equals("") ? null : tmp);
                            tmp = risultato.getString("xml_namespace");
                            xml.setNamespace(tmp == null || tmp.equals("") ? null : tmp);
                            ((ResourceRepresentation)((Object)rr)).setXml(xml);
                            break;
                        }
                        case JSON: {
                            ResourceRepresentationJson json = new ResourceRepresentationJson();
                            tmp = risultato.getString("json_type");
                            json.setTipo(tmp == null || tmp.equals("") ? null : tmp);
                            ((ResourceRepresentation)((Object)rr)).setJson(json);
                        }
                    }
                }
                long idRR = risultato.getLong("id");
                rr.setId(idRR);
                lista.add(rr);
            }
            rr = lista;
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return rr;
    }

    protected List<ResourceParameter> accordiResourceParametersList(Long idRisorsa, boolean isRequest, Long idRisposta, ISearch ricerca) throws DriverRegistroServiziException {
        ArrayList<ResourceParameter> rr;
        String nomeMetodo = "accordiResourceParametersList";
        int idLista = Liste.ACCORDI_API_RESOURCES_PARAMETERS_REQUEST;
        if (!isRequest) {
            idLista = Liste.ACCORDI_API_RESOURCES_PARAMETERS_RESPONSE;
        }
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<ArrayList<ResourceParameter>> lista = new ArrayList<ArrayList<ResourceParameter>>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("accordiPorttypeOperationMessagePartList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("api_resources_parameter");
                sqlQueryObject.addSelectCountField("*", "cont");
                if (isRequest) {
                    sqlQueryObject.addWhereCondition("id_resource_parameter = ?");
                } else {
                    sqlQueryObject.addWhereCondition("id_resource_response_par = ?");
                }
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("api_resources_parameter");
                sqlQueryObject.addSelectCountField("*", "cont");
                if (isRequest) {
                    sqlQueryObject.addWhereCondition("id_resource_parameter = ?");
                } else {
                    sqlQueryObject.addWhereCondition("id_resource_response_par = ?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (isRequest) {
                stmt.setLong(1, idRisorsa);
            } else {
                stmt.setLong(1, idRisposta);
            }
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("api_resources_parameter");
                sqlQueryObject.addSelectField("id_resource_parameter");
                sqlQueryObject.addSelectField("id_resource_response_par");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("tipo_parametro");
                sqlQueryObject.addSelectField("required");
                sqlQueryObject.addSelectField("tipo");
                sqlQueryObject.addSelectField("restrizioni");
                sqlQueryObject.addSelectField("id");
                if (isRequest) {
                    sqlQueryObject.addWhereCondition("id_resource_parameter = ?");
                } else {
                    sqlQueryObject.addWhereCondition("id_resource_response_par = ?");
                }
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("tipo_parametro");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("api_resources_parameter");
                sqlQueryObject.addSelectField("id_resource_parameter");
                sqlQueryObject.addSelectField("id_resource_response_par");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("tipo_parametro");
                sqlQueryObject.addSelectField("required");
                sqlQueryObject.addSelectField("tipo");
                sqlQueryObject.addSelectField("restrizioni");
                sqlQueryObject.addSelectField("id");
                if (isRequest) {
                    sqlQueryObject.addWhereCondition("id_resource_parameter = ?");
                } else {
                    sqlQueryObject.addWhereCondition("id_resource_response_par = ?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("tipo_parametro");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (isRequest) {
                stmt.setLong(1, idRisorsa);
            } else {
                stmt.setLong(1, idRisposta);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                rr = new ResourceParameter();
                String tmp = risultato.getString("nome");
                ((ResourceParameter)((Object)rr)).setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("descrizione");
                ((ResourceParameter)((Object)rr)).setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("tipo_parametro");
                ((ResourceParameter)((Object)rr)).setParameterType(DriverRegistroServiziDB_LIB.getEnumParameterType(tmp == null || tmp.equals("") ? null : tmp));
                boolean req = risultato.getBoolean("required");
                ((ResourceParameter)((Object)rr)).setRequired(req);
                tmp = risultato.getString("tipo");
                ((ResourceParameter)((Object)rr)).setTipo(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("restrizioni");
                ((ResourceParameter)((Object)rr)).setRestrizioni(tmp == null || tmp.equals("") ? null : tmp);
                long idRR = risultato.getLong("id");
                rr.setId(idRR);
                lista.add(rr);
            }
            rr = lista;
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return rr;
    }
}

