/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.db;

import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.byok.IDriverBYOK;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.constants.CostantiDB;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.CredenzialiSoggetto;
import org.openspcoop2.core.registry.Proprieta;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.RuoliSoggetto;
import org.openspcoop2.core.registry.Ruolo;
import org.openspcoop2.core.registry.RuoloSoggetto;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.CostantiRegistroServizi;
import org.openspcoop2.core.registry.constants.CredenzialeTipo;
import org.openspcoop2.core.registry.constants.StatiAccordo;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicercaSoggetti;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_LIB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_connettoriLIB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_protocolPropertiesDriver;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_soggettiLIB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_utilsDriver;
import org.openspcoop2.utils.beans.BaseBeanWithId;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.ArchiveType;
import org.openspcoop2.utils.certificate.Certificate;
import org.openspcoop2.utils.certificate.CertificateUtils;
import org.openspcoop2.utils.certificate.PrincipalType;
import org.openspcoop2.utils.crypt.CryptConfig;
import org.openspcoop2.utils.crypt.CryptFactory;
import org.openspcoop2.utils.crypt.ICrypt;
import org.openspcoop2.utils.jdbc.IJDBCAdapter;
import org.openspcoop2.utils.jdbc.JDBCAdapterFactory;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.slf4j.Logger;

public class DriverRegistroServiziDB_soggettiDriver {
    private DriverRegistroServiziDB driver = null;
    private DriverRegistroServiziDB_protocolPropertiesDriver protocolPropertiesDriver = null;

    protected DriverRegistroServiziDB_soggettiDriver(DriverRegistroServiziDB driver) {
        this.driver = driver;
        this.protocolPropertiesDriver = new DriverRegistroServiziDB_protocolPropertiesDriver(driver);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Soggetto getSoggetto(IDSoggetto idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        long idSoggettoLong;
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("[getSoggetto] Parametro idSoggetto is null");
        }
        String nomeSogg = idSoggetto.getNome();
        String tipoSogg = idSoggetto.getTipo();
        if (nomeSogg == null) throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getSoggetto] : soggetto non specificato.");
        if (nomeSogg.trim().equals("")) throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getSoggetto] : soggetto non specificato.");
        if (tipoSogg == null) throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getSoggetto] : soggetto non specificato.");
        if (tipoSogg.trim().equals("")) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getSoggetto] : soggetto non specificato.");
        }
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getSoggetto(idSoggetto)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("nome_soggetto = ?");
            sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, nomeSogg);
            stm.setString(2, tipoSogg);
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, nomeSogg, tipoSogg));
            rs = stm.executeQuery();
            if (!rs.next()) {
                throw new DriverRegistroServiziNotFound("Nessun soggetto trovato eseguendo: " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, nomeSogg, tipoSogg));
            }
            idSoggettoLong = rs.getLong("id");
        }
        catch (DriverRegistroServiziNotFound e) {
            try {
                throw e;
                catch (SQLException se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getSoggetto] SqlException: " + se.getMessage(), se);
                }
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getSoggetto] Exception: " + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return this.getSoggetto(idSoggettoLong);
    }

    protected Soggetto getSoggetto(long idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getSoggetto(idSoggetto, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Soggetto getSoggetto(long idSoggetto, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Soggetto soggetto;
        if (idSoggetto <= 0L) {
            return null;
        }
        Soggetto soggetto2 = null;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (conParam != null) {
            con = conParam;
        } else if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getSoggetto(longId)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            int strict;
            IJDBCAdapter jdbcAdapter;
            CredenzialiSoggetto credenziali;
            String tipoAuth;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idSoggetto));
            rs = stm.executeQuery();
            if (!rs.next()) {
                throw new DriverRegistroServiziNotFound("Nessun risultato trovato eseguendo: " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idSoggetto));
            }
            soggetto2 = new Soggetto();
            soggetto2.setId(rs.getLong("id"));
            String nomeSogg = rs.getString("nome_soggetto");
            soggetto2.setNome(nomeSogg);
            String tipoSogg = rs.getString("tipo_soggetto");
            soggetto2.setTipo(tipoSogg);
            String tmp = rs.getString("descrizione");
            soggetto2.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("identificativo_porta");
            soggetto2.setIdentificativoPorta(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("server");
            soggetto2.setPortaDominio(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("superuser");
            soggetto2.setSuperUser(tmp == null || tmp.equals("") ? null : tmp);
            if (rs.getInt("privato") == 1) {
                soggetto2.setPrivato(true);
            } else {
                soggetto2.setPrivato(false);
            }
            tmp = rs.getString("codice_ipa");
            soggetto2.setCodiceIpa(tmp == null || tmp.equals("") ? null : tmp);
            if (rs.getTimestamp("ora_registrazione") != null) {
                soggetto2.setOraRegistrazione(new Date(rs.getTimestamp("ora_registrazione").getTime()));
            }
            long idConnettore = rs.getLong("id_connettore");
            Connettore connettore = this.driver.getConnettore(idConnettore, con);
            String profilo = rs.getString("profilo");
            if (profilo != null) {
                profilo = profilo.trim();
                soggetto2.setVersioneProtocollo(profilo);
            }
            if ((tipoAuth = rs.getString("tipoauth")) != null && !tipoAuth.equals("")) {
                credenziali = new CredenzialiSoggetto();
                credenziali.setTipo(DriverRegistroServiziDB_LIB.getEnumCredenzialeTipo(tipoAuth));
                credenziali.setUser(rs.getString("utente"));
                credenziali.setPassword(rs.getString("password"));
                if (CredenzialeTipo.APIKEY.equals(credenziali.getTipo())) {
                    credenziali.setAppId(CostantiDB.isAPPID(rs.getString("issuer")));
                } else {
                    credenziali.setIssuer(rs.getString("issuer"));
                }
                credenziali.setSubject(rs.getString("subject"));
                credenziali.setCnSubject(rs.getString("cn_subject"));
                credenziali.setCnIssuer(rs.getString("cn_issuer"));
                jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)this.driver.tipoDB);
                credenziali.setCertificate(jdbcAdapter.getBinaryData(rs, "certificate"));
                strict = rs.getInt("cert_strict_verification");
                if (strict == 1) {
                    credenziali.setCertificateStrictVerification(true);
                } else if (strict == 0) {
                    credenziali.setCertificateStrictVerification(false);
                }
                soggetto2.addCredenziali(credenziali);
            }
            soggetto2.setConnettore(connettore);
            soggetto2.setProprietaOggetto(DriverRegistroServiziDB_utilsDriver.readProprietaOggetto(rs, false));
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("soggetti_ruoli");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, soggetto2.getId());
            this.driver.logDebug("eseguo query ruoli: " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, soggetto2.getId()));
            rs = stm.executeQuery();
            while (rs.next()) {
                if (soggetto2.getRuoli() == null) {
                    soggetto2.setRuoli(new RuoliSoggetto());
                }
                RuoloSoggetto ruolo = new RuoloSoggetto();
                ruolo.setId(rs.getLong("id_ruolo"));
                soggetto2.getRuoli().addRuolo(ruolo);
            }
            rs.close();
            stm.close();
            if (soggetto2.getRuoli() != null && soggetto2.getRuoli().sizeRuoloList() > 0) {
                for (int i = 0; i < soggetto2.getRuoli().sizeRuoloList(); ++i) {
                    Ruolo ruolo = this.driver.getRuolo(con, soggetto2.getRuoli().getRuolo(i).getId());
                    soggetto2.getRuoli().getRuolo(i).setNome(ruolo.getNome());
                }
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("soggetti_credenziali");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("id", true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, soggetto2.getId());
            this.driver.logDebug("eseguo query credenziali: " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, soggetto2.getId()));
            rs = stm.executeQuery();
            while (rs.next()) {
                credenziali = new CredenzialiSoggetto();
                credenziali.setTipo(DriverRegistroServiziDB_LIB.getEnumCredenzialeTipo(tipoAuth));
                credenziali.setIssuer(rs.getString("issuer"));
                credenziali.setSubject(rs.getString("subject"));
                credenziali.setCnSubject(rs.getString("cn_subject"));
                credenziali.setCnIssuer(rs.getString("cn_issuer"));
                jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)this.driver.tipoDB);
                credenziali.setCertificate(jdbcAdapter.getBinaryData(rs, "certificate"));
                strict = rs.getInt("cert_strict_verification");
                if (strict == 1) {
                    credenziali.setCertificateStrictVerification(true);
                } else if (strict == 0) {
                    credenziali.setCertificateStrictVerification(false);
                }
                soggetto2.addCredenziali(credenziali);
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("soggetti_properties");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, soggetto2.getId());
            this.driver.logDebug("eseguo query ruoli: " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, soggetto2.getId()));
            rs = stm.executeQuery();
            while (rs.next()) {
                Proprieta proprieta = new Proprieta();
                proprieta.setNome(rs.getString("nome"));
                String plainValue = rs.getString("valore");
                String encValue = rs.getString("enc_value");
                if (encValue != null && StringUtils.isNotEmpty((String)encValue)) {
                    IDriverBYOK driverBYOK = this.driver.getDriverUnwrapBYOK();
                    if (driverBYOK != null) {
                        proprieta.setValore(driverBYOK.unwrapAsString(encValue));
                    } else {
                        proprieta.setValore(encValue);
                    }
                } else {
                    proprieta.setValore(plainValue);
                }
                soggetto2.addProprieta(proprieta);
            }
            rs.close();
            stm.close();
            try {
                List<ProtocolProperty> listPP = DriverRegistroServiziDB_LIB.getListaProtocolProperty(soggetto2.getId(), ProprietariProtocolProperty.SOGGETTO, con, this.driver.tipoDB, this.driver.getDriverUnwrapBYOK());
                if (listPP != null && !listPP.isEmpty()) {
                    for (ProtocolProperty protocolProperty : listPP) {
                        soggetto2.addProtocolProperty(protocolProperty);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            soggetto = soggetto2;
        }
        catch (SQLException se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getSoggetto] SqlException: " + se.getMessage(), se);
                catch (DriverRegistroServiziNotFound se2) {
                    throw se2;
                }
                catch (Exception se3) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getSoggetto] Exception: " + se3.getMessage(), se3);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(conParam, con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(conParam, con);
        return soggetto;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<IDSoggetto> getAllIdSoggetti(FiltroRicercaSoggetti filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDSoggetto> arrayList;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        this.driver.logDebug("getAllIdSoggettiRegistro...");
        Certificate certificatoFiltro = null;
        try {
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = this.driver.atomica ? this.driver.getConnectionFromDatasource("getAllIdSoggetti") : this.driver.globalConnection;
            boolean testInChiaro = false;
            ICrypt crypt = null;
            if (filtroRicerca != null && filtroRicerca.getCredenzialiSoggetto() != null && filtroRicerca.getCredenzialiSoggetto().getPassword() != null) {
                CryptConfig config;
                CredenzialeTipo cTipo = filtroRicerca.getCredenzialiSoggetto().getTipo();
                if (CredenzialeTipo.BASIC.equals(cTipo)) {
                    config = filtroRicerca.getCryptConfig();
                    if (config == null || config.isBackwardCompatibility()) {
                        testInChiaro = true;
                    }
                    if (config != null) {
                        try {
                            crypt = CryptFactory.getCrypt((Logger)this.driver.log, (CryptConfig)config);
                        }
                        catch (Exception e) {
                            throw new DriverRegistroServiziException(e.getMessage(), e);
                        }
                    }
                } else if (CredenzialeTipo.APIKEY.equals(cTipo)) {
                    config = filtroRicerca.getCryptConfig();
                    if (config != null) {
                        try {
                            crypt = CryptFactory.getCrypt((Logger)this.driver.log, (CryptConfig)config);
                        }
                        catch (Exception e) {
                            throw new DriverRegistroServiziException(e.getMessage(), e);
                        }
                    } else {
                        testInChiaro = true;
                    }
                }
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            if (filtroRicerca != null && filtroRicerca.getIdRuolo() != null) {
                sqlQueryObject.addFromTable("soggetti_ruoli");
                sqlQueryObject.addFromTable("ruoli");
            }
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.setSelectDistinct(true);
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    sqlQueryObject.addWhereCondition("soggetti.ora_registrazione > ?");
                }
                if (filtroRicerca.getMaxDate() != null) {
                    sqlQueryObject.addWhereCondition("soggetti.ora_registrazione < ?");
                }
                if (filtroRicerca.getTipo() != null) {
                    sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto = ?");
                }
                if (filtroRicerca.getNome() != null) {
                    sqlQueryObject.addWhereCondition("soggetti.nome_soggetto = ?");
                }
                if (filtroRicerca.getNomePdd() != null) {
                    sqlQueryObject.addWhereCondition("soggetti.server = ?");
                }
                if (filtroRicerca.getIdRuolo() != null) {
                    sqlQueryObject.addWhereCondition("soggetti_ruoli.id_soggetto=soggetti.id");
                    sqlQueryObject.addWhereCondition("soggetti_ruoli.id_ruolo=ruoli.id");
                    sqlQueryObject.addWhereCondition("ruoli.nome = ?");
                }
                if (filtroRicerca.getCredenzialiSoggetto() != null) {
                    if (filtroRicerca.getCredenzialiSoggetto().getTipo() != null) {
                        sqlQueryObject.addWhereCondition("soggetti.tipoauth = ?");
                        if (CredenzialeTipo.APIKEY.equals(filtroRicerca.getCredenzialiSoggetto().getTipo())) {
                            sqlQueryObject.addWhereCondition("soggetti.cert_strict_verification = ?");
                        }
                    }
                    if (filtroRicerca.getCredenzialiSoggetto().getUser() != null) {
                        sqlQueryObject.addWhereCondition("soggetti.utente = ?");
                    }
                    if (filtroRicerca.getCredenzialiSoggetto().getPassword() != null) {
                        sqlQueryObject.addSelectField("soggetti.password");
                    }
                    if (filtroRicerca.getCredenzialiSoggetto().getSubject() != null) {
                        List listValues;
                        Map hashSubject = CertificateUtils.getPrincipalIntoMap((String)filtroRicerca.getCredenzialiSoggetto().getSubject(), (PrincipalType)PrincipalType.SUBJECT);
                        Map hashIssuer = null;
                        if (filtroRicerca.getCredenzialiSoggetto().getIssuer() != null) {
                            hashIssuer = CertificateUtils.getPrincipalIntoMap((String)filtroRicerca.getCredenzialiSoggetto().getIssuer(), (PrincipalType)PrincipalType.ISSUER);
                        }
                        for (String key : hashSubject.keySet()) {
                            listValues = (List)hashSubject.get(key);
                            for (String value : listValues) {
                                sqlQueryObject.addWhereLikeCondition("soggetti.subject", "/" + CertificateUtils.formatKeyPrincipal((String)key) + "=" + CertificateUtils.formatValuePrincipal((String)value) + "/", true, true, false);
                            }
                            sqlQueryObject.addSelectField("subject");
                        }
                        if (hashIssuer != null) {
                            for (String key : hashIssuer.keySet()) {
                                listValues = (List)hashIssuer.get(key);
                                for (String value : listValues) {
                                    sqlQueryObject.addWhereLikeCondition("soggetti.issuer", "/" + CertificateUtils.formatKeyPrincipal((String)key) + "=" + CertificateUtils.formatValuePrincipal((String)value) + "/", true, true, false);
                                }
                            }
                            sqlQueryObject.addSelectField("issuer");
                        } else {
                            sqlQueryObject.addWhereIsNullCondition("issuer");
                        }
                    }
                    if (filtroRicerca.getCredenzialiSoggetto().getCertificate() != null) {
                        sqlQueryObject.addWhereCondition("soggetti.cn_subject = ?");
                        sqlQueryObject.addWhereCondition("soggetti.cn_issuer = ?");
                        sqlQueryObject.addWhereCondition("soggetti.cert_strict_verification = ?");
                        sqlQueryObject.addSelectField("certificate");
                    }
                }
                DBUtils.setPropertiesForSearch(sqlQueryObject, filtroRicerca.getProprieta(), "soggetti", "soggetti_properties", "nome", "valore", "id_soggetto");
                this.protocolPropertiesDriver.setProtocolPropertiesForSearch(sqlQueryObject, filtroRicerca, "soggetti");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.driver.logDebug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    this.driver.logDebug("minDate stmt.setTimestamp(" + filtroRicerca.getMinDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMinDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    this.driver.logDebug("maxDate stmt.setTimestamp(" + filtroRicerca.getMaxDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMaxDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getTipo() != null) {
                    this.driver.logDebug("tipoSoggetto stmt.setString(" + filtroRicerca.getTipo() + ")");
                    stm.setString(indexStmt, filtroRicerca.getTipo());
                    ++indexStmt;
                }
                if (filtroRicerca.getNome() != null) {
                    this.driver.logDebug("nomeSoggetto stmt.setString(" + filtroRicerca.getNome() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNome());
                    ++indexStmt;
                }
                if (filtroRicerca.getNomePdd() != null) {
                    this.driver.logDebug("nomePdD stmt.setString(" + filtroRicerca.getNomePdd() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNomePdd());
                    ++indexStmt;
                }
                if (filtroRicerca.getIdRuolo() != null) {
                    this.driver.logDebug("ruolo stmt.setString(" + filtroRicerca.getIdRuolo().getNome() + ")");
                    stm.setString(indexStmt, filtroRicerca.getIdRuolo().getNome());
                    ++indexStmt;
                }
                if (filtroRicerca.getCredenzialiSoggetto() != null) {
                    if (filtroRicerca.getCredenzialiSoggetto().getTipo() != null) {
                        this.driver.logDebug("credenziali.tipo stmt.setString(" + filtroRicerca.getCredenzialiSoggetto().getTipo().getValue() + ")");
                        stm.setString(indexStmt, filtroRicerca.getCredenzialiSoggetto().getTipo().getValue());
                        ++indexStmt;
                        if (CredenzialeTipo.APIKEY.equals(filtroRicerca.getCredenzialiSoggetto().getTipo())) {
                            int v = filtroRicerca.getCredenzialiSoggetto().isCertificateStrictVerification() ? 1 : 0;
                            this.driver.logDebug("credenziali.certificateStrictVerification stmt.setInt(" + v + ")");
                            stm.setInt(indexStmt, v);
                            ++indexStmt;
                        }
                    }
                    if (filtroRicerca.getCredenzialiSoggetto().getUser() != null) {
                        this.driver.logDebug("credenziali.user stmt.setString(" + filtroRicerca.getCredenzialiSoggetto().getUser() + ")");
                        stm.setString(indexStmt, filtroRicerca.getCredenzialiSoggetto().getUser());
                        ++indexStmt;
                    }
                    if (filtroRicerca.getCredenzialiSoggetto().getSubject() != null) {
                        // empty if block
                    }
                    if (filtroRicerca.getCredenzialiSoggetto().getCertificate() != null) {
                        certificatoFiltro = ArchiveLoader.load((ArchiveType)ArchiveType.CER, (byte[])filtroRicerca.getCredenzialiSoggetto().getCertificate(), (int)0, null);
                        String cnSubject = certificatoFiltro.getCertificate().getSubject().getCN();
                        String cnIssuer = certificatoFiltro.getCertificate().getIssuer().getCN();
                        stm.setString(indexStmt++, cnSubject);
                        this.driver.logDebug("credenziali.cnSubject stmt.setString(" + cnSubject + ")");
                        stm.setString(indexStmt++, cnIssuer);
                        this.driver.logDebug("credenziali.cnIssuer stmt.setString(" + cnIssuer + ")");
                        if (filtroRicerca.getCredenzialiSoggetto().isCertificateStrictVerification()) {
                            this.driver.logDebug("credenziali.strict stmt.setInt(1)");
                            stm.setInt(indexStmt++, 1);
                        } else {
                            this.driver.logDebug("credenziali.strict stmt.setInt(0)");
                            stm.setInt(indexStmt++, 0);
                        }
                    }
                }
                DBUtils.setPropertiesForSearch(stm, indexStmt, filtroRicerca.getProprieta(), this.driver.tipoDB, this.driver.log);
                this.protocolPropertiesDriver.setProtocolPropertiesForSearch(stm, indexStmt, filtroRicerca, ProprietariProtocolProperty.SOGGETTO);
            }
            rs = stm.executeQuery();
            ArrayList<IDSoggetto> idSoggetti = new ArrayList<IDSoggetto>();
            IJDBCAdapter jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)this.driver.tipoDB);
            while (rs.next()) {
                if (filtroRicerca != null && filtroRicerca.getCredenzialiSoggetto() != null && filtroRicerca.getCredenzialiSoggetto().getPassword() != null) {
                    String passwordDB = rs.getString("password");
                    boolean found = false;
                    if (testInChiaro) {
                        found = filtroRicerca.getCredenzialiSoggetto().getPassword().equals(passwordDB);
                    }
                    if (!found && crypt != null) {
                        found = crypt.check(filtroRicerca.getCredenzialiSoggetto().getPassword(), passwordDB);
                    }
                    if (!found) continue;
                }
                if (filtroRicerca != null && filtroRicerca.getCredenzialiSoggetto() != null && filtroRicerca.getCredenzialiSoggetto().getSubject() != null) {
                    String subjectPotenziale = rs.getString("subject");
                    boolean subjectValid = CertificateUtils.sslVerify((String)subjectPotenziale, (String)filtroRicerca.getCredenzialiSoggetto().getSubject(), (PrincipalType)PrincipalType.SUBJECT, (Logger)this.driver.log);
                    boolean issuerValid = true;
                    if (filtroRicerca.getCredenzialiSoggetto().getIssuer() != null) {
                        String issuerPotenziale = rs.getString("issuer");
                        issuerValid = StringUtils.isNotEmpty((String)issuerPotenziale) ? CertificateUtils.sslVerify((String)issuerPotenziale, (String)filtroRicerca.getCredenzialiSoggetto().getIssuer(), (PrincipalType)PrincipalType.ISSUER, (Logger)this.driver.log) : false;
                    }
                    if (!subjectValid || !issuerValid) continue;
                }
                if (certificatoFiltro != null) {
                    byte[] certificatoBytes = jdbcAdapter.getBinaryData(rs, "certificate");
                    Certificate certificato = ArchiveLoader.load((ArchiveType)ArchiveType.CER, (byte[])certificatoBytes, (int)0, null);
                    if (!certificatoFiltro.getCertificate().equals(certificato.getCertificate(), filtroRicerca.getCredenzialiSoggetto().isCertificateStrictVerification())) continue;
                }
                IDSoggetto idS = new IDSoggetto(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"));
                idSoggetti.add(idS);
            }
            if (idSoggetti.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Soggetti non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Soggetti non trovati");
            }
            arrayList = idSoggetti;
        }
        catch (DriverRegistroServiziNotFound de) {
            try {
                throw de;
                catch (Exception e) {
                    throw new DriverRegistroServiziException("getAllIdSoggettiRegistro error", e);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected void createSoggetto(Soggetto soggetto) throws DriverRegistroServiziException {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createSoggetto] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("createSoggetto");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDSoggetto type = 1");
            DriverRegistroServiziDB_soggettiLIB.CRUDSoggetto(1, soggetto, con, this.driver.tipoDB, this.driver.getDriverWrapBYOK());
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createSoggetto] Errore durante la creazione del soggetto : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean existsSoggetto(IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        boolean exist = false;
        Connection con = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("existsSoggetto(idSoggetto)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        try {
            exist = this.existsSoggetto(con, idSoggetto);
        }
        catch (Exception e) {
            exist = false;
            this.driver.log.error("Errore durante verifica esistenza soggetto :", (Throwable)e);
        }
        finally {
            this.driver.closeConnection(con);
        }
        return exist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean existsSoggetto(Connection conParam, IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        boolean exist = false;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("Parametro non valido");
        }
        String nome_soggetto = idSoggetto.getNome();
        String tipo_soggetto = idSoggetto.getTipo();
        if (nome_soggetto == null || nome_soggetto.equals("")) {
            throw new DriverRegistroServiziException("Parametro Nome non valido");
        }
        if (tipo_soggetto == null || tipo_soggetto.equals("")) {
            throw new DriverRegistroServiziException("Parametro Tipo non valido");
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome_soggetto = ?");
            sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = conParam.prepareStatement(sqlQuery);
            stm.setString(1, nome_soggetto);
            stm.setString(2, tipo_soggetto);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
            JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        }
        catch (Exception e) {
            exist = false;
            this.driver.log.error("Errore durante verifica esistenza soggetto :", (Throwable)e);
        }
        finally {
            JDBCUtilities.closeResources(rs, stm);
        }
        return exist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean existsSoggetto(long idSoggetto) throws DriverRegistroServiziException {
        boolean exist = false;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("existsSoggetto(longId)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
            JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
            this.driver.closeConnection(con);
        }
        catch (Exception e) {
            exist = false;
            this.driver.log.error("Errore durante verifica esistenza soggetto :", (Throwable)e);
        }
        finally {
            JDBCUtilities.closeResources(rs, stm);
            this.driver.closeConnection(con);
        }
        return exist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean existsSoggetto(String codiceIPA) throws DriverRegistroServiziException {
        boolean exist = false;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (codiceIPA == null || codiceIPA.equals("")) {
            throw new DriverRegistroServiziException("Parametro non valido");
        }
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("existsSoggetto(codiceIPA)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("codice_ipa = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, codiceIPA);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
            JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
            this.driver.closeConnection(con);
        }
        catch (Exception e) {
            exist = false;
            this.driver.log.error("Errore durante verifica esistenza soggetto :", (Throwable)e);
        }
        finally {
            JDBCUtilities.closeResources(rs, stm);
            this.driver.closeConnection(con);
        }
        return exist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Soggetto getSoggetto(String codiceIPA) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idSoggetto = -1L;
        if (codiceIPA == null || codiceIPA.equals("")) {
            throw new DriverRegistroServiziException("Parametro non valido");
        }
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getSoggetto(codiceIPA)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("codice_ipa = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, codiceIPA);
            rs = stm.executeQuery();
            if (rs.next()) {
                idSoggetto = rs.getLong("id");
            }
            rs.close();
            stm.close();
            JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
            this.driver.closeConnection(con);
        }
        catch (Exception e) {
            this.driver.log.error("Errore durante verifica esistenza soggetto :", (Throwable)e);
        }
        finally {
            JDBCUtilities.closeResources(rs, stm);
            this.driver.closeConnection(con);
        }
        if (idSoggetto <= 0L) {
            throw new DriverRegistroServiziNotFound("Soggetto con Codice IPA [" + codiceIPA + "] non trovato");
        }
        return this.getSoggetto(idSoggetto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCodiceIPA(IDSoggetto idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String codiceIPA = null;
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("Parametro non valido");
        }
        String nome_soggetto = idSoggetto.getNome();
        String tipo_soggetto = idSoggetto.getTipo();
        if (nome_soggetto == null || nome_soggetto.equals("")) {
            throw new DriverRegistroServiziException("Parametro Nome non valido");
        }
        if (tipo_soggetto == null || tipo_soggetto.equals("")) {
            throw new DriverRegistroServiziException("Parametro Tipo non valido");
        }
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getCodiceIPA(idSoggetto)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
            sqlQueryObject.addWhereCondition("nome_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, tipo_soggetto);
            stm.setString(2, nome_soggetto);
            rs = stm.executeQuery();
            if (rs.next()) {
                codiceIPA = rs.getString("codice_ipa");
            }
            rs.close();
            stm.close();
            JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
            this.driver.closeConnection(con);
        }
        catch (Exception e) {
            this.driver.log.error("Errore durante verifica esistenza soggetto :", (Throwable)e);
        }
        finally {
            JDBCUtilities.closeResources(rs, stm);
            this.driver.closeConnection(con);
        }
        if (codiceIPA == null) {
            throw new DriverRegistroServiziNotFound("Soggetto [" + tipo_soggetto + "/" + nome_soggetto + "] non trovato");
        }
        return codiceIPA;
    }

    protected void updateSoggetto(Soggetto soggetto) throws DriverRegistroServiziException {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateSoggetto] Parametro non valido.");
        }
        PreparedStatement stm = null;
        ResultSet rs = null;
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("updateSoggetto");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            String oldNomeSoggetto = null;
            String oldTipoSoggetto = null;
            if (soggetto.getOldIDSoggettoForUpdate() != null) {
                oldNomeSoggetto = soggetto.getOldIDSoggettoForUpdate().getNome();
                oldTipoSoggetto = soggetto.getOldIDSoggettoForUpdate().getTipo();
            }
            String nomeSoggetto = soggetto.getNome();
            String tipoSoggetto = soggetto.getTipo();
            if (tipoSoggetto == null || tipoSoggetto.equals("")) {
                throw new DriverRegistroServiziException("Parametro Tipo Soggetto non valido.");
            }
            if (nomeSoggetto == null || nomeSoggetto.equals("")) {
                throw new DriverRegistroServiziException("Parametro Nome Soggetto non valido.");
            }
            if (oldNomeSoggetto == null || oldNomeSoggetto.equals("")) {
                oldNomeSoggetto = nomeSoggetto;
            }
            if (oldTipoSoggetto == null || oldTipoSoggetto.equals("")) {
                oldTipoSoggetto = tipoSoggetto;
            }
            if (!tipoSoggetto.equals(oldTipoSoggetto) || !nomeSoggetto.equals(oldNomeSoggetto)) {
                String newNomeConnettore;
                String[] val;
                String oldNomeConnettore;
                Connettore connettore;
                long idConnettore;
                String regex = "CNT_SF_(.*)\\/(.*)_(.*)\\/(.*)_(.*)\\/(.*)";
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                sqlQueryObject.addSelectField("servizi_fruitori.id_connettore");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = servizi.id");
                sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto = ?");
                sqlQueryObject.addWhereCondition("soggetti.nome_soggetto = ?");
                sqlQueryObject.setANDLogicOperator(true);
                String sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setString(1, oldTipoSoggetto);
                stm.setString(2, oldNomeSoggetto);
                rs = stm.executeQuery();
                while (rs.next()) {
                    idConnettore = rs.getLong("id_connettore");
                    connettore = this.driver.getConnettore(idConnettore, con);
                    oldNomeConnettore = connettore.getNome();
                    if (!oldNomeConnettore.matches(regex)) continue;
                    this.driver.logDebug("Tento aggiornamento connettore id: [" + idConnettore + "] oldNome: [" + oldNomeConnettore + "]...");
                    val = oldNomeConnettore.split("_");
                    newNomeConnettore = "CNT_SF_" + val[2] + tipoSoggetto + "/" + nomeSoggetto + val[4];
                    this.driver.logDebug("nuovo nome connettore [" + newNomeConnettore + "]");
                    connettore.setNome(newNomeConnettore);
                    DriverRegistroServiziDB_connettoriLIB.CRUDConnettore(2, connettore, con, this.driver.getDriverWrapBYOK());
                }
                rs.close();
                stm.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                sqlQueryObject.addSelectField("servizi_fruitori.id_connettore");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto = ?");
                sqlQueryObject.addWhereCondition("soggetti.nome_soggetto = ?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setString(1, oldTipoSoggetto);
                stm.setString(2, oldNomeSoggetto);
                rs = stm.executeQuery();
                while (rs.next()) {
                    idConnettore = rs.getLong("id_connettore");
                    connettore = this.driver.getConnettore(idConnettore, con);
                    oldNomeConnettore = connettore.getNome();
                    if (!oldNomeConnettore.matches(regex)) continue;
                    this.driver.logDebug("Tento aggiornamento connettore id: [" + idConnettore + "] oldNome: [" + oldNomeConnettore + "]...");
                    val = oldNomeConnettore.split("_");
                    newNomeConnettore = "CNT_SF_" + tipoSoggetto + "/" + nomeSoggetto + val[3] + val[4];
                    this.driver.logDebug("nuovo nome connettore [" + newNomeConnettore + "]");
                    connettore.setNome(newNomeConnettore);
                    DriverRegistroServiziDB_connettoriLIB.CRUDConnettore(2, connettore, con, this.driver.getDriverWrapBYOK());
                }
                rs.close();
                stm.close();
            }
            DriverRegistroServiziDB_soggettiLIB.CRUDSoggetto(2, soggetto, con, this.driver.tipoDB, this.driver.getDriverWrapBYOK());
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateSoggetto] Errore durante l'aggiornamento del soggetto : " + qe.getMessage(), qe);
        }
        finally {
            JDBCUtilities.closeResources(rs, stm);
            this.driver.closeConnection(error, con);
        }
    }

    protected void deleteSoggetto(Soggetto soggetto) throws DriverRegistroServiziException {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteSoggetto] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("deleteSoggetto");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDSoggetto type = 3");
            DriverRegistroServiziDB_soggettiLIB.CRUDSoggetto(3, soggetto, con, this.driver.tipoDB, this.driver.getDriverWrapBYOK());
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteSoggetto] Errore durante l'eliminazione del soggetto : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IDSoggetto[] getSoggettiWithSuperuser(String user) throws DriverRegistroServiziException {
        IDSoggetto[] idSoggetti = null;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getSoggettiWithSuperuser");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziException::getSoggettiWithSuperuser] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ArrayList<IDSoggetto> idTrovati = new ArrayList<IDSoggetto>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addWhereCondition("superuser = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, user);
            this.driver.logDebug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, CostantiRegistroServizi.ABILITATO));
            rs = stm.executeQuery();
            while (rs.next()) {
                IDSoggetto id = new IDSoggetto();
                id.setTipo(rs.getString("tipo_soggetto"));
                id.setNome(rs.getString("nome_soggetto"));
                idTrovati.add(id);
            }
            if (idTrovati.size() > 0) {
                idSoggetti = new IDSoggetto[1];
                idSoggetti = idTrovati.toArray(idSoggetti);
            }
        }
        catch (SQLException se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziException::getSoggettiWithSuperuser] SqlException: " + se.getMessage(), se);
                catch (Exception se2) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziException::getSoggettiWithSuperuser] Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return idSoggetti;
    }

    protected List<String> nomiProprietaSoggetti(List<String> tipoSoggettiProtocollo) throws DriverConfigurazioneException {
        ArrayList<String> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<String> lista = new ArrayList<String>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("nomiProprietaSoggetti");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverRegistroServiziDB::nomiProprietaSoggetti] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("soggetti_properties");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addSelectField("soggetti_properties.nome");
            if (tipoSoggettiProtocollo != null && tipoSoggettiProtocollo.size() > 0) {
                sqlQueryObject.addWhereCondition("soggetti_properties.id_soggetto = soggetti.id");
                sqlQueryObject.addFromTable("soggetti");
                String[] tipiServiziProtocolloS = tipoSoggettiProtocollo.toArray(new String[tipoSoggettiProtocollo.size()]);
                sqlQueryObject.addWhereINCondition("soggetti.tipo_soggetto", true, tipiServiziProtocolloS);
            }
            sqlQueryObject.addOrderBy("soggetti_properties.nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                lista.add(risultato.getString("nome"));
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverRegistroServiziDB::nomiProprietaSoggetti] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected boolean isSoggettoInUsoInPackageFinali(Soggetto ss, Map<ErrorsHandlerCostant, String> whereIsInUso) throws DriverRegistroServiziException {
        return this.isSoggettoInUso(ss, whereIsInUso, true, false);
    }

    protected boolean isSoggettoInUsoInPackagePubblici(Soggetto ss, Map<ErrorsHandlerCostant, String> whereIsInUso) throws DriverRegistroServiziException {
        return this.isSoggettoInUso(ss, whereIsInUso, false, true);
    }

    protected boolean isSoggettoInUso(Soggetto ss, Map<ErrorsHandlerCostant, String> whereIsInUso) throws DriverRegistroServiziException {
        return this.isSoggettoInUso(ss, whereIsInUso, false, false);
    }

    private boolean isSoggettoInUso(Soggetto ss, Map<ErrorsHandlerCostant, String> whereIsInUso, boolean checkOnlyStatiFinali, boolean checkOnlyStatiPubblici) throws DriverRegistroServiziException {
        boolean bl;
        String nomeMetodo = "isSoggettoInUso";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("isSoggettoInUso");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.atomica = " + this.driver.atomica);
        try {
            BaseBeanWithId accordo;
            boolean isInUso = false;
            ArrayList<CallSite> nomiServizi = new ArrayList<CallSite>();
            ArrayList<String> serviziFruitori = new ArrayList<String>();
            ArrayList<String> accordi = new ArrayList<String>();
            ArrayList<String> accordi_cooperazione = new ArrayList<String>();
            ArrayList<String> partecipanti = new ArrayList<String>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            if (checkOnlyStatiFinali) {
                sqlQueryObject.addWhereCondition("stato = ?");
            }
            if (checkOnlyStatiPubblici) {
                sqlQueryObject.addWhereCondition("privato = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, ss.getId());
            int index = 2;
            if (checkOnlyStatiFinali) {
                stmt.setString(index, StatiAccordo.finale.toString());
                ++index;
            }
            if (checkOnlyStatiPubblici) {
                stmt.setInt(index, 0);
                ++index;
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                isInUso = true;
                String nomeServizio = risultato.getString("tipo_servizio") + "/" + risultato.getString("nome_servizio");
                nomiServizi.add((CallSite)((Object)nomeServizio));
            }
            risultato.close();
            stmt.close();
            if (nomiServizi.size() > 0) {
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_SERVIZI, ((Object)nomiServizi).toString());
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            if (checkOnlyStatiFinali) {
                sqlQueryObject.addWhereCondition("stato = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, ss.getId());
            if (checkOnlyStatiFinali) {
                stmt.setString(2, StatiAccordo.finale.toString());
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                isInUso = true;
                AccordoServizioParteSpecifica servizio = this.driver.getAccordoServizioParteSpecifica(risultato.getLong("id_servizio"));
                String uriServizio = this.driver.idServizioFactory.getUriFromAccordo(servizio);
                if (checkOnlyStatiPubblici) {
                    if (servizio.getPrivato() != null && servizio.getPrivato().booleanValue()) continue;
                    serviziFruitori.add(uriServizio);
                    continue;
                }
                serviziFruitori.add(uriServizio);
            }
            risultato.close();
            stmt.close();
            if (serviziFruitori.size() > 0) {
                whereIsInUso.put(ErrorsHandlerCostant.POSSIEDE_FRUITORI, ((Object)serviziFruitori).toString());
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_referente = ?");
            if (checkOnlyStatiFinali) {
                sqlQueryObject.addWhereCondition("stato = ?");
            }
            if (checkOnlyStatiPubblici) {
                sqlQueryObject.addWhereCondition("privato = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, ss.getId());
            index = 2;
            if (checkOnlyStatiFinali) {
                stmt.setString(index, StatiAccordo.finale.toString());
                ++index;
            }
            if (checkOnlyStatiPubblici) {
                stmt.setInt(index, 0);
                ++index;
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                isInUso = true;
                accordo = this.driver.getAccordoServizioParteComune(risultato.getLong("id"));
                accordi.add(this.driver.idAccordoFactory.getUriFromAccordo((AccordoServizioParteComune)accordo));
            }
            risultato.close();
            stmt.close();
            if (accordi.size() > 0) {
                whereIsInUso.put(ErrorsHandlerCostant.IS_REFERENTE, ((Object)accordi).toString());
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("accordi_cooperazione");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_referente = ?");
            if (checkOnlyStatiFinali) {
                sqlQueryObject.addWhereCondition("stato = ?");
            }
            if (checkOnlyStatiPubblici) {
                sqlQueryObject.addWhereCondition("privato = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, ss.getId());
            index = 2;
            if (checkOnlyStatiFinali) {
                stmt.setString(index, StatiAccordo.finale.toString());
                ++index;
            }
            if (checkOnlyStatiPubblici) {
                stmt.setInt(index, 0);
                ++index;
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                isInUso = true;
                accordo = this.driver.getAccordoCooperazione(risultato.getLong("id"));
                accordi_cooperazione.add(this.driver.idAccordoCooperazioneFactory.getUriFromAccordo((AccordoCooperazione)accordo));
            }
            risultato.close();
            stmt.close();
            if (accordi_cooperazione.size() > 0) {
                whereIsInUso.put(ErrorsHandlerCostant.IS_REFERENTE_COOPERAZIONE, ((Object)accordi_cooperazione).toString());
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("accordi_coop_partecipanti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, ss.getId());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                accordo = this.driver.getAccordoCooperazione(risultato.getLong("id_accordo_cooperazione"));
                if (checkOnlyStatiFinali) {
                    if (!StatiAccordo.finale.toString().equals(accordo.getStatoPackage())) continue;
                    isInUso = true;
                    partecipanti.add(this.driver.idAccordoCooperazioneFactory.getUriFromAccordo((AccordoCooperazione)accordo));
                    continue;
                }
                if (checkOnlyStatiPubblici) {
                    if (accordo.getPrivato() != null && accordo.getPrivato().booleanValue()) continue;
                    isInUso = true;
                    partecipanti.add(this.driver.idAccordoCooperazioneFactory.getUriFromAccordo((AccordoCooperazione)accordo));
                    continue;
                }
                isInUso = true;
                partecipanti.add(this.driver.idAccordoCooperazioneFactory.getUriFromAccordo((AccordoCooperazione)accordo));
            }
            risultato.close();
            stmt.close();
            if (partecipanti.size() > 0) {
                whereIsInUso.put(ErrorsHandlerCostant.IS_PARTECIPANTE_COOPERAZIONE, ((Object)partecipanti).toString());
            }
            bl = isInUso;
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return bl;
    }

    protected IDSoggetto getIdSoggetto(long idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getIdSoggetto(idSoggetto, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IDSoggetto getIdSoggetto(long idSoggetto, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        IDSoggetto iDSoggetto;
        if (idSoggetto <= 0L) {
            return null;
        }
        IDSoggetto idSoggettoObject = null;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (conParam != null) {
            con = conParam;
        } else if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getIdSoggetto(longId)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getIdSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idSoggetto));
            rs = stm.executeQuery();
            if (!rs.next()) {
                throw new DriverRegistroServiziNotFound("Nessun risultato trovato eseguendo: " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idSoggetto));
            }
            idSoggettoObject = new IDSoggetto();
            idSoggettoObject.setNome(rs.getString("nome_soggetto"));
            idSoggettoObject.setTipo(rs.getString("tipo_soggetto"));
            iDSoggetto = idSoggettoObject;
        }
        catch (SQLException se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getIdSoggetto] SqlException: " + se.getMessage(), se);
                catch (DriverRegistroServiziNotFound se2) {
                    throw se2;
                }
                catch (Exception se3) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getIdSoggetto] Exception: " + se3.getMessage(), se3);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(conParam, con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(conParam, con);
        return iDSoggetto;
    }

    protected List<IDSoggetto> getSoggettiDefault() throws DriverRegistroServiziException {
        return this.getSoggettiDefault(null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<IDSoggetto> getSoggettiDefault(Connection conParam) throws DriverRegistroServiziException {
        ArrayList<IDSoggetto> arrayList;
        ArrayList<IDSoggetto> soggettiDefault = new ArrayList<IDSoggetto>();
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (conParam != null) {
            con = conParam;
        } else if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getSoggettiDefault()");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getSoggettiDefault] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addWhereCondition("is_default = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setInt(1, 1);
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, 1));
            rs = stm.executeQuery();
            while (rs.next()) {
                IDSoggetto idSoggetto = new IDSoggetto(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"));
                soggettiDefault.add(idSoggetto);
            }
            if (soggettiDefault.isEmpty()) {
                throw new DriverRegistroServiziNotFound("Nessun risultato trovato eseguendo: " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, 1));
            }
            arrayList = soggettiDefault;
        }
        catch (SQLException se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getSoggettiDefault] SqlException: " + se.getMessage(), se);
                catch (Exception se2) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getSoggettiDefault] Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(conParam, con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(conParam, con);
        return arrayList;
    }
}

