/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.openspcoop2.core.registry.RegistroServizi;
import org.openspcoop2.core.registry.driver.BeanUtilities;
import org.openspcoop2.core.registry.driver.ValidazioneSemantica;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.uddi.DriverRegistroServiziUDDI;
import org.openspcoop2.core.registry.driver.utils.DriverRegistroServiziWSInitUtilities;
import org.openspcoop2.core.registry.driver.web.DriverRegistroServiziWEB;
import org.openspcoop2.core.registry.driver.xml.DriverRegistroServiziXML;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.resources.Loader;
import org.slf4j.Logger;

public class ValidazioneSemanticaMainProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws Exception {
        boolean checkURI;
        RegistroServizi registro;
        Properties commonProperties;
        Logger log;
        block64: {
            BeanUtilities driver;
            String tipoRegistro;
            Properties reader;
            block65: {
                Connection connectionDB;
                block63: {
                    block60: {
                        if (args.length < 4) {
                            String errorMsg = "ERROR, Usage:  java ValidazioneSemanticaMainProcessor commonProperties tipoRegistro proprietaRegistro checkURI";
                            System.err.println(errorMsg);
                            throw new Exception(errorMsg);
                        }
                        try {
                            if (args.length == 5) {
                                LoggerWrapperFactory.setLogConfiguration((String)args[4]);
                                break block60;
                            }
                            URL url = ValidazioneSemanticaMainProcessor.class.getResource("/validator.log4j2.properties");
                            if (url != null) {
                                LoggerWrapperFactory.setLogConfiguration((URL)url);
                            } else {
                                File logFile = FileSystemUtilities.createTempFile((String)"testValidazioneSemanticaRegistro_", (String)".log");
                                System.out.println("LogMessages write in " + logFile.getAbsolutePath());
                                LoggerWrapperFactory.setDefaultLogConfiguration((Level)Level.ALL, (boolean)false, null, (File)logFile, (String)"%p <%d{dd-MM-yyyy HH:mm:ss}> %C.%M(%L): %m %n %n");
                            }
                        }
                        catch (Exception e) {
                            String errorMsg = "Errore durante il caricamento del file di log args4[" + args[4] + "] : " + e.getMessage();
                            System.err.println(errorMsg);
                            System.out.println("Args.length: " + args.length);
                            int i = 0;
                            while (i < args.length) {
                                System.out.println("Arg[" + i + "]=[" + args[i] + "]");
                                ++i;
                            }
                            throw new Exception(errorMsg, e);
                        }
                    }
                    log = LoggerWrapperFactory.getLogger((String)"validatoreDatiRegistro");
                    commonProperties = new Properties();
                    try (FileInputStream fin = new FileInputStream(args[0]);){
                        commonProperties.load(fin);
                    }
                    catch (IOException e) {
                        String errorMsg = "Errore durante il caricamento del file di properties [" + args[0] + "] : " + e.getMessage();
                        log.error(errorMsg, (Throwable)e);
                        throw new Exception(errorMsg, e);
                    }
                    reader = new Properties();
                    try (FileInputStream fin = new FileInputStream(args[2]);){
                        reader.load(fin);
                    }
                    catch (IOException e) {
                        String errorMsg = "Errore durante il caricamento del file di properties [" + args[2] + "] : " + e.getMessage();
                        log.error(errorMsg, (Throwable)e);
                        throw new Exception(errorMsg, e);
                    }
                    registro = null;
                    connectionDB = null;
                    tipoRegistro = args[1];
                    checkURI = Boolean.parseBoolean(args[3]);
                    if (!"xml".equals(tipoRegistro)) break block63;
                    String path = reader.getProperty("openspcoop2.registroServizi.xml");
                    if (path == null) {
                        throw new Exception("Non e' stato definito il path dove localizzare il registro servizi xml");
                    }
                    path = path.trim();
                    DriverRegistroServiziXML driver2 = new DriverRegistroServiziXML(path, log);
                    if (!driver2.create) throw new Exception("RegistroServizi XML non inizializzato");
                    log.info("Inizializzato Registro dei Servizi XML");
                    registro = driver2.getImmagineCompletaRegistroServizi();
                    break block64;
                }
                if (!"db".equals(tipoRegistro)) break block65;
                String tipoDatabase = reader.getProperty("openspcoop2.registroServizi.db.tipo");
                if (tipoDatabase == null) {
                    throw new Exception("Non e' stato definito il tipo di database");
                }
                tipoDatabase = tipoDatabase.trim();
                String dataSource = reader.getProperty("openspcoop2.registroServizi.db.dataSource");
                if (dataSource != null) {
                    dataSource = dataSource.trim();
                    Properties context = Utilities.readProperties((String)"openspcoop2.registroServizi.db.context.", (Properties)reader);
                    driver = new DriverRegistroServiziDB(dataSource, context, log, tipoDatabase);
                    if (!((DriverRegistroServiziDB)driver).create) throw new Exception("RegistroServizi DB non inizializzato");
                    log.info("Inizializzato Registro dei Servizi DB");
                    registro = driver.getImmagineCompletaRegistroServizi();
                    break block64;
                } else {
                    String connection = reader.getProperty("openspcoop2.registroServizi.db.url");
                    if (connection == null) {
                        throw new Exception("Non e' stata definita una destinazione ne attraverso un datasource, ne attraverso una connessione diretta");
                    }
                    connection = connection.trim();
                    String driverJDBC = reader.getProperty("openspcoop2.registroServizi.db.driver");
                    if (driverJDBC == null) {
                        throw new Exception("Connessione diretta: non e' stato definito il Driver");
                    }
                    driverJDBC = driverJDBC.trim();
                    String username = reader.getProperty("openspcoop2.registroServizi.db.user");
                    String password = reader.getProperty("openspcoop2.registroServizi.db.password");
                    if (username != null) {
                        username = username.trim();
                    }
                    if (password != null) {
                        password = password.trim();
                    }
                    Loader.getInstance().newInstance(driverJDBC);
                    try {
                        connectionDB = username != null ? DriverManager.getConnection(connection, username, password) : DriverManager.getConnection(connection);
                        DriverRegistroServiziDB driver3 = new DriverRegistroServiziDB(connectionDB, log, tipoDatabase);
                        if (!driver3.create) throw new Exception("RegistroServizi DB non inizializzato");
                        log.info("Inizializzato Registro dei Servizi DB");
                        registro = driver3.getImmagineCompletaRegistroServizi();
                    }
                    finally {
                        try {
                            JDBCUtilities.closeConnection((Logger)DriverRegistroServiziDB.getCheckLogger(), (Connection)connectionDB, (boolean)DriverRegistroServiziDB.isCheckAutocommit(), (boolean)DriverRegistroServiziDB.isCheckIsClosed());
                        }
                        catch (Exception driver3) {}
                    }
                }
            }
            if ("web".equals(tipoRegistro)) {
                String urlPrefix = reader.getProperty("openspcoop2.registroServizi.web.urlPrefix");
                if (urlPrefix == null) {
                    throw new Exception("Non e' stato definito la url dove localizzare il registro servizi web");
                }
                urlPrefix = urlPrefix.trim();
                String pathPrefix = reader.getProperty("openspcoop2.registroServizi.web.pathPrefix");
                if (pathPrefix == null) {
                    throw new Exception("Non e' stato definito il path dove localizzare il registro servizi web");
                }
                pathPrefix = pathPrefix.trim();
                DriverRegistroServiziWEB driver4 = new DriverRegistroServiziWEB(urlPrefix, pathPrefix, log);
                if (!driver4.create) throw new Exception("RegistroServizi WEB non inizializzato");
                log.info("Inizializzato Registro dei Servizi WEB");
                registro = driver4.getImmagineCompletaRegistroServizi();
            } else if ("uddi".equals(tipoRegistro)) {
                String passwordUDDI;
                String inquiryUrl = reader.getProperty("openspcoop2.registroServizi.uddi.inquiryUrl");
                if (inquiryUrl == null) {
                    throw new Exception("Non e' stato definito la url dove localizzare il registro servizi uddi");
                }
                inquiryUrl = inquiryUrl.trim();
                String urlPrefix = reader.getProperty("openspcoop2.registroServizi.uddi.urlPrefix");
                if (urlPrefix == null) {
                    throw new Exception("Non e' stato definito la url prefix dove localizzare il registro servizi uddi (repository http)");
                }
                urlPrefix = urlPrefix.trim();
                String usernameUDDI = reader.getProperty("openspcoop2.registroServizi.uddi.username");
                if (usernameUDDI != null) {
                    usernameUDDI = usernameUDDI.trim();
                }
                if ((passwordUDDI = reader.getProperty("openspcoop2.registroServizi.uddi.password")) != null) {
                    passwordUDDI = passwordUDDI.trim();
                }
                DriverRegistroServiziUDDI driver5 = new DriverRegistroServiziUDDI(inquiryUrl, null, usernameUDDI, passwordUDDI, urlPrefix, null, log);
                if (!driver5.create) throw new Exception("RegistroServizi UDDI non inizializzato");
                log.info("Inizializzato Registro dei Servizi UDDI");
                registro = driver5.getImmagineCompletaRegistroServizi();
            } else {
                String password;
                if (!"ws".equals(tipoRegistro)) throw new Exception("Tipo di registro servizi [" + tipoRegistro + "] non gestito");
                String url = reader.getProperty("openspcoop2.registroServizi.ws.url");
                if (url == null) {
                    throw new Exception("Non e' stato definito la url dove localizzare il registro servizi ws");
                }
                url = url.trim();
                String username = reader.getProperty("openspcoop2.registroServizi.ws.username");
                if (username != null) {
                    username = username.trim();
                }
                if ((password = reader.getProperty("openspcoop2.registroServizi.ws.password")) != null) {
                    password = password.trim();
                }
                driver = DriverRegistroServiziWSInitUtilities.newInstance(url, username, password, log);
                registro = driver.getImmagineCompletaRegistroServizi();
            }
        }
        try {
            String tipiConnettori = commonProperties.getProperty("openspcoop2.tipiConnettori");
            if (tipiConnettori == null) {
                throw new Exception("Non sono stati definiti i tipi di connettori supportati");
            }
            tipiConnettori = tipiConnettori.trim();
            String[] tipoConnettoriArray = tipiConnettori.split(",");
            for (int i = 0; i < tipoConnettoriArray.length; ++i) {
                tipoConnettoriArray[i] = tipoConnettoriArray[i].trim();
            }
            String tipiSoggetti = commonProperties.getProperty("openspcoop2.tipiSoggetti");
            if (tipiSoggetti == null) {
                throw new Exception("Non sono stati definiti i tipi di soggetti supportati");
            }
            tipiSoggetti = tipiSoggetti.trim();
            String[] tipoSoggettiArray = tipiSoggetti.split(",");
            for (int i = 0; i < tipoSoggettiArray.length; ++i) {
                tipoSoggettiArray[i] = tipoSoggettiArray[i].trim();
            }
            String tipiServiziSoap = commonProperties.getProperty("openspcoop2.tipiServizi.soap");
            if (tipiServiziSoap == null) {
                throw new Exception("Non sono stati definiti i tipi di Servizi supportati");
            }
            tipiServiziSoap = tipiServiziSoap.trim();
            String[] tipoServiziArraySoap = tipiServiziSoap.split(",");
            for (int i = 0; i < tipoServiziArraySoap.length; ++i) {
                tipoServiziArraySoap[i] = tipoServiziArraySoap[i].trim();
            }
            String tipiServiziRest = commonProperties.getProperty("openspcoop2.tipiServizi.rest");
            if (tipiServiziRest == null) {
                throw new Exception("Non sono stati definiti i tipi di Servizi supportati");
            }
            tipiServiziRest = tipiServiziRest.trim();
            String[] tipoServiziArrayRest = tipiServiziRest.split(",");
            int i = 0;
            while (true) {
                if (i >= tipoServiziArrayRest.length) {
                    ValidazioneSemantica validatore = new ValidazioneSemantica(registro, checkURI, tipoConnettoriArray, tipoSoggettiArray, tipoServiziArraySoap, tipoServiziArrayRest, log);
                    validatore.validazioneSemantica(true);
                    return;
                }
                tipoServiziArrayRest[i] = tipoServiziArrayRest[i].trim();
                ++i;
            }
        }
        catch (Exception e) {
            log.error("Errore: " + e.getMessage());
            throw e;
        }
    }
}

