/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.transazioni.dao.jdbc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.transazioni.IdTransazioneApplicativoServer;
import org.openspcoop2.core.transazioni.TransazioneApplicativoServer;
import org.openspcoop2.core.transazioni.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.transazioni.dao.jdbc.JDBCTransazioneApplicativoServerServiceSearchImpl;
import org.openspcoop2.generic_project.beans.IDMappingBehaviour;
import org.openspcoop2.generic_project.beans.IModel;
import org.openspcoop2.generic_project.beans.NonNegativeNumber;
import org.openspcoop2.generic_project.beans.UpdateField;
import org.openspcoop2.generic_project.beans.UpdateModel;
import org.openspcoop2.generic_project.dao.jdbc.IJDBCServiceCRUDWithId;
import org.openspcoop2.generic_project.dao.jdbc.IJDBCServiceSearchWithId;
import org.openspcoop2.generic_project.dao.jdbc.JDBCExpression;
import org.openspcoop2.generic_project.dao.jdbc.JDBCPaginatedExpression;
import org.openspcoop2.generic_project.dao.jdbc.JDBCServiceManagerProperties;
import org.openspcoop2.generic_project.dao.jdbc.utils.GenericJDBCUtilities;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCObject;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCPreparedStatementUtilities;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.jdbc.IKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.NullByteTextColumnSanitizer;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.slf4j.Logger;

public class JDBCTransazioneApplicativoServerServiceImpl
extends JDBCTransazioneApplicativoServerServiceSearchImpl
implements IJDBCServiceCRUDWithId<TransazioneApplicativoServer, IdTransazioneApplicativoServer, JDBCServiceManager> {
    private static void sanitizeTextColumns(TipiDatabase dbType, TransazioneApplicativoServer t) {
        t.setFault(NullByteTextColumnSanitizer.sanitize((TipiDatabase)dbType, (String)t.getFault()));
        t.setLocationConnettore(NullByteTextColumnSanitizer.sanitize((TipiDatabase)dbType, (String)t.getLocationConnettore()));
        t.setUltimoErrore(NullByteTextColumnSanitizer.sanitize((TipiDatabase)dbType, (String)t.getUltimoErrore()));
        t.setLocationUltimoErrore(NullByteTextColumnSanitizer.sanitize((TipiDatabase)dbType, (String)t.getLocationUltimoErrore()));
        t.setFaultUltimoErrore(NullByteTextColumnSanitizer.sanitize((TipiDatabase)dbType, (String)t.getFaultUltimoErrore()));
    }

    public void create(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, TransazioneApplicativoServer transazioneApplicativoServer, IDMappingBehaviour idMappingResolutionBehaviour) throws NotImplementedException, ServiceException, Exception {
        if (NullByteTextColumnSanitizer.needsSanitization((TipiDatabase)jdbcProperties.getDatabase())) {
            JDBCTransazioneApplicativoServerServiceImpl.sanitizeTextColumns(jdbcProperties.getDatabase(), transazioneApplicativoServer);
        }
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        ISQLQueryObject sqlQueryObjectInsert = sqlQueryObject.newSQLQueryObject();
        sqlQueryObjectInsert.addInsertTable(this.getTransazioneApplicativoServerFieldConverter().toTable((IModel)TransazioneApplicativoServer.model()));
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().ID_TRANSAZIONE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().SERVIZIO_APPLICATIVO_EROGATORE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().CONNETTORE_NOME, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().DATA_REGISTRAZIONE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().CONSEGNA_TERMINATA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().DATA_MESSAGGIO_SCADUTO, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().DETTAGLIO_ESITO, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().CONSEGNA_TRASPARENTE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().CONSEGNA_INTEGRATION_MANAGER, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().IDENTIFICATIVO_MESSAGGIO, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().DATA_ACCETTAZIONE_RICHIESTA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().DATA_USCITA_RICHIESTA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().DATA_USCITA_RICHIESTA_STREAM, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().DATA_ACCETTAZIONE_RISPOSTA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().DATA_INGRESSO_RISPOSTA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().DATA_INGRESSO_RISPOSTA_STREAM, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().RICHIESTA_USCITA_BYTES, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().RISPOSTA_INGRESSO_BYTES, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().LOCATION_CONNETTORE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().CODICE_RISPOSTA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().FAULT, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().FORMATO_FAULT, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().DATA_PRIMO_TENTATIVO, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().NUMERO_TENTATIVI, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().CLUSTER_ID_PRESA_IN_CARICO, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().CLUSTER_ID_CONSEGNA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().DATA_ULTIMO_ERRORE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().DETTAGLIO_ESITO_ULTIMO_ERRORE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().CODICE_RISPOSTA_ULTIMO_ERRORE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().ULTIMO_ERRORE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().LOCATION_ULTIMO_ERRORE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().CLUSTER_ID_ULTIMO_ERRORE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().FAULT_ULTIMO_ERRORE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().FORMATO_FAULT_ULTIMO_ERRORE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().DATA_PRIMO_PRELIEVO_IM, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().DATA_PRELIEVO_IM, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().NUMERO_PRELIEVI_IM, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().DATA_ELIMINAZIONE_IM, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().CLUSTER_ID_PRELIEVO_IM, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().CLUSTER_ID_ELIMINAZIONE_IM, false), "?");
        IKeyGeneratorObject keyGenerator = this.getTransazioneApplicativoServerFetch().getKeyGeneratorObject((IModel<?>)TransazioneApplicativoServer.model());
        long id = jdbcUtilities.insertAndReturnGeneratedKey(sqlQueryObjectInsert, keyGenerator, jdbcProperties.isShowSql(), new JDBCObject[]{new JDBCObject((Object)transazioneApplicativoServer.getIdTransazione(), TransazioneApplicativoServer.model().ID_TRANSAZIONE.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getServizioApplicativoErogatore(), TransazioneApplicativoServer.model().SERVIZIO_APPLICATIVO_EROGATORE.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getConnettoreNome(), TransazioneApplicativoServer.model().CONNETTORE_NOME.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getDataRegistrazione(), TransazioneApplicativoServer.model().DATA_REGISTRAZIONE.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getConsegnaTerminata(), TransazioneApplicativoServer.model().CONSEGNA_TERMINATA.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getDataMessaggioScaduto(), TransazioneApplicativoServer.model().DATA_MESSAGGIO_SCADUTO.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getDettaglioEsito(), TransazioneApplicativoServer.model().DETTAGLIO_ESITO.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getConsegnaTrasparente(), TransazioneApplicativoServer.model().CONSEGNA_TRASPARENTE.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getConsegnaIntegrationManager(), TransazioneApplicativoServer.model().CONSEGNA_INTEGRATION_MANAGER.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getIdentificativoMessaggio(), TransazioneApplicativoServer.model().IDENTIFICATIVO_MESSAGGIO.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getDataAccettazioneRichiesta(), TransazioneApplicativoServer.model().DATA_ACCETTAZIONE_RICHIESTA.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getDataUscitaRichiesta(), TransazioneApplicativoServer.model().DATA_USCITA_RICHIESTA.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getDataUscitaRichiestaStream(), TransazioneApplicativoServer.model().DATA_USCITA_RICHIESTA_STREAM.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getDataAccettazioneRisposta(), TransazioneApplicativoServer.model().DATA_ACCETTAZIONE_RISPOSTA.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getDataIngressoRisposta(), TransazioneApplicativoServer.model().DATA_INGRESSO_RISPOSTA.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getDataIngressoRispostaStream(), TransazioneApplicativoServer.model().DATA_INGRESSO_RISPOSTA_STREAM.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getRichiestaUscitaBytes(), TransazioneApplicativoServer.model().RICHIESTA_USCITA_BYTES.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getRispostaIngressoBytes(), TransazioneApplicativoServer.model().RISPOSTA_INGRESSO_BYTES.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getLocationConnettore(), TransazioneApplicativoServer.model().LOCATION_CONNETTORE.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getCodiceRisposta(), TransazioneApplicativoServer.model().CODICE_RISPOSTA.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getFault(), TransazioneApplicativoServer.model().FAULT.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getFormatoFault(), TransazioneApplicativoServer.model().FORMATO_FAULT.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getDataPrimoTentativo(), TransazioneApplicativoServer.model().DATA_PRIMO_TENTATIVO.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getNumeroTentativi(), TransazioneApplicativoServer.model().NUMERO_TENTATIVI.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getClusterIdPresaInCarico(), TransazioneApplicativoServer.model().CLUSTER_ID_PRESA_IN_CARICO.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getClusterIdConsegna(), TransazioneApplicativoServer.model().CLUSTER_ID_CONSEGNA.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getDataUltimoErrore(), TransazioneApplicativoServer.model().DATA_ULTIMO_ERRORE.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getDettaglioEsitoUltimoErrore(), TransazioneApplicativoServer.model().DETTAGLIO_ESITO_ULTIMO_ERRORE.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getCodiceRispostaUltimoErrore(), TransazioneApplicativoServer.model().CODICE_RISPOSTA_ULTIMO_ERRORE.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getUltimoErrore(), TransazioneApplicativoServer.model().ULTIMO_ERRORE.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getLocationUltimoErrore(), TransazioneApplicativoServer.model().LOCATION_ULTIMO_ERRORE.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getClusterIdUltimoErrore(), TransazioneApplicativoServer.model().CLUSTER_ID_ULTIMO_ERRORE.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getFaultUltimoErrore(), TransazioneApplicativoServer.model().FAULT_ULTIMO_ERRORE.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getFormatoFaultUltimoErrore(), TransazioneApplicativoServer.model().FORMATO_FAULT_ULTIMO_ERRORE.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getDataPrimoPrelievoIm(), TransazioneApplicativoServer.model().DATA_PRIMO_PRELIEVO_IM.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getDataPrelievoIm(), TransazioneApplicativoServer.model().DATA_PRELIEVO_IM.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getNumeroPrelieviIm(), TransazioneApplicativoServer.model().NUMERO_PRELIEVI_IM.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getDataEliminazioneIm(), TransazioneApplicativoServer.model().DATA_ELIMINAZIONE_IM.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getClusterIdPrelievoIm(), TransazioneApplicativoServer.model().CLUSTER_ID_PRELIEVO_IM.getFieldType()), new JDBCObject((Object)transazioneApplicativoServer.getClusterIdEliminazioneIm(), TransazioneApplicativoServer.model().CLUSTER_ID_ELIMINAZIONE_IM.getFieldType())});
        transazioneApplicativoServer.setId(id);
    }

    public void update(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdTransazioneApplicativoServer oldId, TransazioneApplicativoServer transazioneApplicativoServer, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        if (JDBCTransazioneApplicativoServerServiceImpl.isEfficiente()) {
            long tableId = -1L;
            if (oldId != null && oldId.getId() != null && oldId.getId() > 0L) {
                tableId = oldId.getId();
                oldId = null;
            }
            this._update(jdbcProperties, log, connection, sqlQueryObject, tableId, transazioneApplicativoServer, idMappingResolutionBehaviour, oldId);
        } else {
            ISQLQueryObject sqlQueryObjectUpdate = sqlQueryObject.newSQLQueryObject();
            Long longIdByLogicId = this.findIdTransazioneApplicativoServer(jdbcProperties, log, connection, sqlQueryObjectUpdate.newSQLQueryObject(), oldId, true);
            Long tableId = transazioneApplicativoServer.getId();
            if (tableId != null && tableId > 0L) {
                if (tableId.longValue() != longIdByLogicId.longValue()) {
                    throw new Exception("Ambiguous parameter: transazioneApplicativoServer.id [" + tableId + "] does not match logic id [" + longIdByLogicId + "]");
                }
            } else {
                tableId = longIdByLogicId;
                transazioneApplicativoServer.setId(tableId);
            }
            if (tableId == null || tableId <= 0L) {
                throw new Exception("Retrieve tableId failed");
            }
            this.update(jdbcProperties, log, connection, sqlQueryObject, (long)tableId, transazioneApplicativoServer, idMappingResolutionBehaviour);
        }
    }

    public void update(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, TransazioneApplicativoServer transazioneApplicativoServer, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        this._update(jdbcProperties, log, connection, sqlQueryObject, tableId, transazioneApplicativoServer, idMappingResolutionBehaviour, null);
    }

    private void _update(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, TransazioneApplicativoServer transazioneApplicativoServer, IDMappingBehaviour idMappingResolutionBehaviour, IdTransazioneApplicativoServer idLogico) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        if (NullByteTextColumnSanitizer.needsSanitization((TipiDatabase)jdbcProperties.getDatabase())) {
            JDBCTransazioneApplicativoServerServiceImpl.sanitizeTextColumns(jdbcProperties.getDatabase(), transazioneApplicativoServer);
        }
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        ISQLQueryObject sqlQueryObjectInsert = sqlQueryObject.newSQLQueryObject();
        ISQLQueryObject sqlQueryObjectDelete = sqlQueryObjectInsert.newSQLQueryObject();
        ISQLQueryObject sqlQueryObjectGet = sqlQueryObjectDelete.newSQLQueryObject();
        ISQLQueryObject sqlQueryObjectUpdate = sqlQueryObjectGet.newSQLQueryObject();
        sqlQueryObjectUpdate.setANDLogicOperator(true);
        sqlQueryObjectUpdate.addUpdateTable(this.getTransazioneApplicativoServerFieldConverter().toTable((IModel)TransazioneApplicativoServer.model()));
        boolean isUpdate_transazioneApplicativoServer = true;
        ArrayList<JDBCObject> lstObjects_transazioneApplicativoServer = new ArrayList<JDBCObject>();
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().ID_TRANSAZIONE, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getIdTransazione(), TransazioneApplicativoServer.model().ID_TRANSAZIONE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().SERVIZIO_APPLICATIVO_EROGATORE, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getServizioApplicativoErogatore(), TransazioneApplicativoServer.model().SERVIZIO_APPLICATIVO_EROGATORE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().CONNETTORE_NOME, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getConnettoreNome(), TransazioneApplicativoServer.model().CONNETTORE_NOME.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().DATA_REGISTRAZIONE, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getDataRegistrazione(), TransazioneApplicativoServer.model().DATA_REGISTRAZIONE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().CONSEGNA_TERMINATA, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getConsegnaTerminata(), TransazioneApplicativoServer.model().CONSEGNA_TERMINATA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().DATA_MESSAGGIO_SCADUTO, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getDataMessaggioScaduto(), TransazioneApplicativoServer.model().DATA_MESSAGGIO_SCADUTO.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().DETTAGLIO_ESITO, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getDettaglioEsito(), TransazioneApplicativoServer.model().DETTAGLIO_ESITO.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().CONSEGNA_TRASPARENTE, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getConsegnaTrasparente(), TransazioneApplicativoServer.model().CONSEGNA_TRASPARENTE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().CONSEGNA_INTEGRATION_MANAGER, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getConsegnaIntegrationManager(), TransazioneApplicativoServer.model().CONSEGNA_INTEGRATION_MANAGER.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().IDENTIFICATIVO_MESSAGGIO, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getIdentificativoMessaggio(), TransazioneApplicativoServer.model().IDENTIFICATIVO_MESSAGGIO.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().DATA_ACCETTAZIONE_RICHIESTA, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getDataAccettazioneRichiesta(), TransazioneApplicativoServer.model().DATA_ACCETTAZIONE_RICHIESTA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().DATA_USCITA_RICHIESTA, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getDataUscitaRichiesta(), TransazioneApplicativoServer.model().DATA_USCITA_RICHIESTA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().DATA_USCITA_RICHIESTA_STREAM, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getDataUscitaRichiestaStream(), TransazioneApplicativoServer.model().DATA_USCITA_RICHIESTA_STREAM.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().DATA_ACCETTAZIONE_RISPOSTA, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getDataAccettazioneRisposta(), TransazioneApplicativoServer.model().DATA_ACCETTAZIONE_RISPOSTA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().DATA_INGRESSO_RISPOSTA, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getDataIngressoRisposta(), TransazioneApplicativoServer.model().DATA_INGRESSO_RISPOSTA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().DATA_INGRESSO_RISPOSTA_STREAM, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getDataIngressoRispostaStream(), TransazioneApplicativoServer.model().DATA_INGRESSO_RISPOSTA_STREAM.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().RICHIESTA_USCITA_BYTES, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getRichiestaUscitaBytes(), TransazioneApplicativoServer.model().RICHIESTA_USCITA_BYTES.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().RISPOSTA_INGRESSO_BYTES, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getRispostaIngressoBytes(), TransazioneApplicativoServer.model().RISPOSTA_INGRESSO_BYTES.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().LOCATION_CONNETTORE, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getLocationConnettore(), TransazioneApplicativoServer.model().LOCATION_CONNETTORE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().CODICE_RISPOSTA, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getCodiceRisposta(), TransazioneApplicativoServer.model().CODICE_RISPOSTA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().FAULT, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getFault(), TransazioneApplicativoServer.model().FAULT.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().FORMATO_FAULT, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getFormatoFault(), TransazioneApplicativoServer.model().FORMATO_FAULT.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().DATA_PRIMO_TENTATIVO, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getDataPrimoTentativo(), TransazioneApplicativoServer.model().DATA_PRIMO_TENTATIVO.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().NUMERO_TENTATIVI, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getNumeroTentativi(), TransazioneApplicativoServer.model().NUMERO_TENTATIVI.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().CLUSTER_ID_PRESA_IN_CARICO, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getClusterIdPresaInCarico(), TransazioneApplicativoServer.model().CLUSTER_ID_PRESA_IN_CARICO.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().CLUSTER_ID_CONSEGNA, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getClusterIdConsegna(), TransazioneApplicativoServer.model().CLUSTER_ID_CONSEGNA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().DATA_ULTIMO_ERRORE, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getDataUltimoErrore(), TransazioneApplicativoServer.model().DATA_ULTIMO_ERRORE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().DETTAGLIO_ESITO_ULTIMO_ERRORE, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getDettaglioEsitoUltimoErrore(), TransazioneApplicativoServer.model().DETTAGLIO_ESITO_ULTIMO_ERRORE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().CODICE_RISPOSTA_ULTIMO_ERRORE, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getCodiceRispostaUltimoErrore(), TransazioneApplicativoServer.model().CODICE_RISPOSTA_ULTIMO_ERRORE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().ULTIMO_ERRORE, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getUltimoErrore(), TransazioneApplicativoServer.model().ULTIMO_ERRORE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().LOCATION_ULTIMO_ERRORE, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getLocationUltimoErrore(), TransazioneApplicativoServer.model().LOCATION_ULTIMO_ERRORE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().CLUSTER_ID_ULTIMO_ERRORE, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getClusterIdUltimoErrore(), TransazioneApplicativoServer.model().CLUSTER_ID_ULTIMO_ERRORE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().FAULT_ULTIMO_ERRORE, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getFaultUltimoErrore(), TransazioneApplicativoServer.model().FAULT_ULTIMO_ERRORE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().FORMATO_FAULT_ULTIMO_ERRORE, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getFormatoFaultUltimoErrore(), TransazioneApplicativoServer.model().FORMATO_FAULT_ULTIMO_ERRORE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().DATA_PRIMO_PRELIEVO_IM, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getDataPrimoPrelievoIm(), TransazioneApplicativoServer.model().DATA_PRIMO_PRELIEVO_IM.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().DATA_PRELIEVO_IM, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getDataPrelievoIm(), TransazioneApplicativoServer.model().DATA_PRELIEVO_IM.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().NUMERO_PRELIEVI_IM, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getNumeroPrelieviIm(), TransazioneApplicativoServer.model().NUMERO_PRELIEVI_IM.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().DATA_ELIMINAZIONE_IM, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getDataEliminazioneIm(), TransazioneApplicativoServer.model().DATA_ELIMINAZIONE_IM.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().CLUSTER_ID_PRELIEVO_IM, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getClusterIdPrelievoIm(), TransazioneApplicativoServer.model().CLUSTER_ID_PRELIEVO_IM.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().CLUSTER_ID_ELIMINAZIONE_IM, false), "?");
        lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)transazioneApplicativoServer.getClusterIdEliminazioneIm(), TransazioneApplicativoServer.model().CLUSTER_ID_ELIMINAZIONE_IM.getFieldType()));
        if (idLogico != null) {
            sqlQueryObjectUpdate.addWhereCondition(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().ID_TRANSAZIONE, false) + "=?");
            sqlQueryObjectUpdate.addWhereCondition(this.getTransazioneApplicativoServerFieldConverter().toColumn(TransazioneApplicativoServer.model().SERVIZIO_APPLICATIVO_EROGATORE, false) + "=?");
            sqlQueryObjectUpdate.setANDLogicOperator(true);
            lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)idLogico.getIdTransazione(), String.class));
            lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)idLogico.getServizioApplicativoErogatore(), String.class));
        } else {
            sqlQueryObjectUpdate.addWhereCondition("id=?");
            lstObjects_transazioneApplicativoServer.add(new JDBCObject((Object)tableId, Long.class));
        }
        if (isUpdate_transazioneApplicativoServer) {
            jdbcUtilities.executeUpdate(sqlQueryObjectUpdate.createSQLUpdate(), jdbcProperties.isShowSql(), lstObjects_transazioneApplicativoServer.toArray(new JDBCObject[0]));
        }
    }

    public void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdTransazioneApplicativoServer id, UpdateField ... updateFields) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        GenericJDBCUtilities.updateFields((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)this.getTransazioneApplicativoServerFieldConverter().toTable((IModel)TransazioneApplicativoServer.model()), this.getMapTableToPKColumnEngine(), this.getRootTablePrimaryKeyValuesEngine(jdbcProperties, log, connection, sqlQueryObject, id), (ISQLFieldConverter)this.getTransazioneApplicativoServerFieldConverter(), (IJDBCServiceSearchWithId)this, null, (UpdateField[])updateFields);
    }

    public void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdTransazioneApplicativoServer id, IExpression condition, UpdateField ... updateFields) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        GenericJDBCUtilities.updateFields((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)this.getTransazioneApplicativoServerFieldConverter().toTable((IModel)TransazioneApplicativoServer.model()), this.getMapTableToPKColumnEngine(), this.getRootTablePrimaryKeyValuesEngine(jdbcProperties, log, connection, sqlQueryObject, id), (ISQLFieldConverter)this.getTransazioneApplicativoServerFieldConverter(), (IJDBCServiceSearchWithId)this, (IExpression)condition, (UpdateField[])updateFields);
    }

    public void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdTransazioneApplicativoServer id, UpdateModel ... updateModels) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        GenericJDBCUtilities.updateFields((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)this.getTransazioneApplicativoServerFieldConverter().toTable((IModel)TransazioneApplicativoServer.model()), this.getMapTableToPKColumnEngine(), this.getRootTablePrimaryKeyValuesEngine(jdbcProperties, log, connection, sqlQueryObject, id), (ISQLFieldConverter)this.getTransazioneApplicativoServerFieldConverter(), (IJDBCServiceSearchWithId)this, (UpdateModel[])updateModels);
    }

    public void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, UpdateField ... updateFields) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(tableId);
        GenericJDBCUtilities.updateFields((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)this.getTransazioneApplicativoServerFieldConverter().toTable((IModel)TransazioneApplicativoServer.model()), this.getMapTableToPKColumnEngine(), ids, (ISQLFieldConverter)this.getTransazioneApplicativoServerFieldConverter(), (IJDBCServiceSearchWithId)this, null, (UpdateField[])updateFields);
    }

    public void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, IExpression condition, UpdateField ... updateFields) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(tableId);
        GenericJDBCUtilities.updateFields((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)this.getTransazioneApplicativoServerFieldConverter().toTable((IModel)TransazioneApplicativoServer.model()), this.getMapTableToPKColumnEngine(), ids, (ISQLFieldConverter)this.getTransazioneApplicativoServerFieldConverter(), (IJDBCServiceSearchWithId)this, (IExpression)condition, (UpdateField[])updateFields);
    }

    public void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, UpdateModel ... updateModels) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(tableId);
        GenericJDBCUtilities.updateFields((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)this.getTransazioneApplicativoServerFieldConverter().toTable((IModel)TransazioneApplicativoServer.model()), this.getMapTableToPKColumnEngine(), ids, (ISQLFieldConverter)this.getTransazioneApplicativoServerFieldConverter(), (IJDBCServiceSearchWithId)this, (UpdateModel[])updateModels);
    }

    public void updateOrCreate(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdTransazioneApplicativoServer oldId, TransazioneApplicativoServer transazioneApplicativoServer, IDMappingBehaviour idMappingResolutionBehaviour) throws NotImplementedException, ServiceException, Exception {
        if (this.exists(jdbcProperties, log, connection, sqlQueryObject, oldId)) {
            this.update(jdbcProperties, log, connection, sqlQueryObject, oldId, transazioneApplicativoServer, idMappingResolutionBehaviour);
        } else {
            this.create(jdbcProperties, log, connection, sqlQueryObject, transazioneApplicativoServer, idMappingResolutionBehaviour);
        }
    }

    public void updateOrCreate(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, TransazioneApplicativoServer transazioneApplicativoServer, IDMappingBehaviour idMappingResolutionBehaviour) throws NotImplementedException, ServiceException, Exception {
        if (this.exists(jdbcProperties, log, connection, sqlQueryObject, tableId)) {
            this.update(jdbcProperties, log, connection, sqlQueryObject, tableId, transazioneApplicativoServer, idMappingResolutionBehaviour);
        } else {
            this.create(jdbcProperties, log, connection, sqlQueryObject, transazioneApplicativoServer, idMappingResolutionBehaviour);
        }
    }

    public void delete(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, TransazioneApplicativoServer transazioneApplicativoServer) throws NotImplementedException, ServiceException, Exception {
        Long longId = null;
        if (transazioneApplicativoServer.getId() != null && transazioneApplicativoServer.getId() > 0L) {
            longId = transazioneApplicativoServer.getId();
        } else {
            IdTransazioneApplicativoServer idTransazioneApplicativoServer = this.convertToId(jdbcProperties, log, connection, sqlQueryObject, transazioneApplicativoServer);
            longId = this.findIdTransazioneApplicativoServer(jdbcProperties, log, connection, sqlQueryObject, idTransazioneApplicativoServer, false);
            if (longId == null) {
                return;
            }
        }
        this.deleteEngine(jdbcProperties, log, connection, sqlQueryObject, longId);
    }

    private void deleteEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Long id) throws NotImplementedException, ServiceException, Exception {
        if (id != null && id <= 0L) {
            throw new ServiceException("Id is less equals 0");
        }
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        ISQLQueryObject sqlQueryObjectDelete = sqlQueryObject.newSQLQueryObject();
        sqlQueryObjectDelete.setANDLogicOperator(true);
        sqlQueryObjectDelete.addDeleteTable(this.getTransazioneApplicativoServerFieldConverter().toTable((IModel)TransazioneApplicativoServer.model()));
        if (id != null) {
            sqlQueryObjectDelete.addWhereCondition("id=?");
        }
        jdbcUtilities.execute(sqlQueryObjectDelete.createSQLDelete(), jdbcProperties.isShowSql(), new JDBCObject[]{new JDBCObject((Object)id, Long.class)});
    }

    public void deleteById(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdTransazioneApplicativoServer idTransazioneApplicativoServer) throws NotImplementedException, ServiceException, Exception {
        Long id = null;
        try {
            id = this.findIdTransazioneApplicativoServer(jdbcProperties, log, connection, sqlQueryObject, idTransazioneApplicativoServer, true);
        }
        catch (NotFoundException notFound) {
            return;
        }
        this.deleteEngine(jdbcProperties, log, connection, sqlQueryObject, id);
    }

    public NonNegativeNumber deleteAll(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject) throws NotImplementedException, ServiceException, Exception {
        return this.deleteAll(jdbcProperties, log, connection, sqlQueryObject, new JDBCExpression((ISQLFieldConverter)this.getTransazioneApplicativoServerFieldConverter()));
    }

    public NonNegativeNumber deleteAll(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression) throws NotImplementedException, ServiceException, Exception {
        List<Long> lst = this.findAllTableIds(jdbcProperties, log, connection, sqlQueryObject, new JDBCPaginatedExpression(expression));
        for (Long id : lst) {
            this.deleteEngine(jdbcProperties, log, connection, sqlQueryObject, id);
        }
        return new NonNegativeNumber((long)lst.size());
    }

    public void deleteById(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId) throws ServiceException, NotImplementedException, Exception {
        this.deleteEngine(jdbcProperties, log, connection, sqlQueryObject, tableId);
    }

    public int nativeUpdate(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlObject, String sql, Object ... param) throws ServiceException, NotImplementedException, Exception {
        return GenericJDBCUtilities.nativeUpdate((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlObject, (String)sql, (Object[])param);
    }
}

