/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.transazioni.utils.credenziali;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.config.constants.TipoAutenticazione;
import org.openspcoop2.core.transazioni.CredenzialeMittente;
import org.openspcoop2.core.transazioni.dao.ICredenzialeMittenteService;
import org.openspcoop2.core.transazioni.utils.TipoCredenzialeMittente;
import org.openspcoop2.core.transazioni.utils.credenziali.AbstractSearchCredenziale;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeTrasporto;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.expression.LikeMode;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.CertificateUtils;
import org.openspcoop2.utils.certificate.PrincipalType;
import org.slf4j.Logger;

public class CredenzialeSearchTrasporto
extends AbstractSearchCredenziale {
    private String tipoAutenticazione;

    public CredenzialeSearchTrasporto(String tipoAutenticazione) {
        super(TipoCredenzialeMittente.TRASPORTO);
        this.tipoAutenticazione = tipoAutenticazione;
    }

    @Override
    public String getTipo() {
        return CredenzialeTrasporto.getTipoTrasporto(this.tipo, this.tipoAutenticazione);
    }

    public boolean isSsl() {
        return TipoAutenticazione.SSL.getValue().equalsIgnoreCase(this.tipoAutenticazione);
    }

    @Override
    protected String getExactValueDatabase(String credentialParam, boolean ricercaEsatta) throws UtilsException {
        throw new UtilsException("Not Implemented");
    }

    @Override
    public IPaginatedExpression createExpression(ICredenzialeMittenteService credenzialeMittentiService, String credential, boolean ricercaEsatta, boolean caseSensitive) throws UtilsException {
        try {
            IPaginatedExpression pagExpression = credenzialeMittentiService.newPaginatedExpression();
            pagExpression.and();
            pagExpression.equals(CredenzialeMittente.model().TIPO, (Object)CredenzialeTrasporto.getTipoTrasporto(this.tipo, this.tipoAutenticazione));
            if (CredenzialeTrasporto.isSsl(this.tipoAutenticazione) && ricercaEsatta) {
                this.setLikeConditionSslRicercaEsatta(pagExpression, caseSensitive, credential);
            } else if (ricercaEsatta) {
                if (caseSensitive) {
                    pagExpression.equals(CredenzialeMittente.model().CREDENZIALE, (Object)credential);
                } else {
                    pagExpression.ilike(CredenzialeMittente.model().CREDENZIALE, credential, LikeMode.EXACT);
                }
            } else if (!caseSensitive) {
                pagExpression.ilike(CredenzialeMittente.model().CREDENZIALE, credential, LikeMode.ANYWHERE);
            } else {
                pagExpression.like(CredenzialeMittente.model().CREDENZIALE, credential, LikeMode.ANYWHERE);
            }
            return pagExpression;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    private void setLikeConditionSslRicercaEsatta(IPaginatedExpression pagExpression, boolean caseSensitive, String credential) throws ExpressionNotImplementedException, ExpressionException, UtilsException {
        Map hashSubject = CertificateUtils.getPrincipalIntoMap((String)credential, (PrincipalType)PrincipalType.SUBJECT);
        for (Map.Entry entry : hashSubject.entrySet()) {
            String key = (String)entry.getKey();
            List listValues = (List)hashSubject.get(key);
            for (String value : listValues) {
                if (caseSensitive) {
                    pagExpression.like(CredenzialeMittente.model().CREDENZIALE, "/" + CertificateUtils.formatKeyPrincipal((String)key) + "=" + CertificateUtils.formatValuePrincipal((String)value) + "/", LikeMode.ANYWHERE);
                    continue;
                }
                pagExpression.ilike(CredenzialeMittente.model().CREDENZIALE, "/" + CertificateUtils.formatKeyPrincipal((String)key) + "=" + CertificateUtils.formatValuePrincipal((String)value) + "/", LikeMode.ANYWHERE);
            }
        }
    }

    public static List<CredenzialeMittente> filterList(List<CredenzialeMittente> originalList, String credenziale, Logger log) {
        ArrayList<CredenzialeMittente> filteredList = new ArrayList<CredenzialeMittente>();
        if (originalList != null) {
            for (CredenzialeMittente credenzialeMittentePotenziale : originalList) {
                String subjectPotenziale = credenzialeMittentePotenziale.getCredenziale();
                try {
                    boolean subjectValid = CertificateUtils.sslVerify((String)subjectPotenziale, (String)credenziale, (PrincipalType)PrincipalType.SUBJECT, (Logger)log);
                    if (!subjectValid) continue;
                    filteredList.add(credenzialeMittentePotenziale);
                }
                catch (Exception e) {
                    log.error("Analisi della credenziale '" + subjectPotenziale + "' non riuscita: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return filteredList;
    }
}

