-- Eliminata tabella inutilizzata
DROP TABLE plugin_info;
DROP TABLE plugins_filtro_comp;
DROP TABLE plugins_filtro_comp_init_seq;
DROP SEQUENCE seq_plugins_filtro_comp;

-- Supporto per la registrazione delle classi di plugins
ALTER TABLE plugins ADD COLUMN tipo_plugin VARCHAR(255) NOT NULL;
ALTER TABLE plugins DROP CONSTRAINT unique_plugins_1;
ALTER TABLE plugins DROP CONSTRAINT unique_plugins_2;
ALTER TABLE plugins DROP COLUMN tipo;
ALTER TABLE plugins ADD COLUMN tipo VARCHAR(255) NOT NULL;
ALTER TABLE plugins ADD COLUMN stato BOOLEAN;
ALTER TABLE plugins ALTER COLUMN stato SET DEFAULT true;
ALTER TABLE plugins ADD CONSTRAINT unique_plugins_1 UNIQUE (tipo_plugin,class_name);
ALTER TABLE plugins ADD CONSTRAINT unique_plugins_2 UNIQUE (tipo_plugin,tipo);
ALTER TABLE plugins ADD CONSTRAINT unique_plugins_3 UNIQUE (tipo_plugin,label);


CREATE SEQUENCE seq_plugins_props_comp AS BIGINT START WITH 1 INCREMENT BY 1 ; -- (Scommentare in hsql 2.x) NO CYCLE;

CREATE TABLE plugins_props_comp
(
	nome VARCHAR(255) NOT NULL,
	valore VARCHAR(255) NOT NULL,
	-- fk/pk columns
	id BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 1),
	id_plugin BIGINT NOT NULL,
	-- fk/pk keys constraints
	CONSTRAINT fk_plugins_props_comp_1 FOREIGN KEY (id_plugin) REFERENCES plugins(id) ON DELETE CASCADE,
	CONSTRAINT pk_plugins_props_comp PRIMARY KEY (id)
);

-- index
CREATE INDEX idx_plug_prop_com_1 ON plugins_props_comp (id_plugin);
CREATE TABLE plugins_props_comp_init_seq (id BIGINT);
INSERT INTO plugins_props_comp_init_seq VALUES (NEXT VALUE FOR seq_plugins_props_comp);

