
-- **** Controllo Traffico ****

CREATE SEQUENCE seq_ct_map AS BIGINT START WITH 1 INCREMENT BY 1 ; -- (Scommentare in hsql 2.x) CYCLE;

CREATE TABLE ct_map
(
	map_key VARCHAR(300) NOT NULL,
	map_update_time TIMESTAMP NOT NULL,
	map_value VARBINARY(16777215) NOT NULL,
	-- fk/pk columns
	id BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 1),
	-- unique constraints
	CONSTRAINT unique_ct_map_1 UNIQUE (map_key),
	-- fk/pk keys constraints
	CONSTRAINT pk_ct_map PRIMARY KEY (id)
);

-- index
CREATE UNIQUE INDEX index_ct_map_1 ON ct_map (map_key);
CREATE TABLE ct_map_init_seq (id BIGINT);
INSERT INTO ct_map_init_seq VALUES (NEXT VALUE FOR seq_ct_map);

