/*
 * ====================================================================
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 */
package org.apache.http.benchmark;

public class TemplateUtils {

    private static final String TEMPLATE_ID_SERIAL = "@ID_SERIAL@";
    private static final String TEMPLATE_ID_DATE = "@ID_DATE@";
    private static final String TEMPLATE_DATE = "@DATE@";

    private static final java.text.SimpleDateFormat datam = new java.text.SimpleDateFormat("yyyy-MM-dd_HH:mm");
    private static final java.text.SimpleDateFormat datas = new java.text.SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final String SERIAL_FORMAT = "%07d";


    /* **** Contatore che mantiene il numero incrementale all'interno del minuto ***** */

    private static int countID_withDate = 1;

    private static java.io.File timestamp_withDate = new java.io.File(".lastRun");

    static {
        java.io.FileReader fr = null;
        java.io.BufferedReader br = null;
        try {
            if(timestamp_withDate.exists()==false){
                countID_withDate = 1;
            }
            else{
                fr = new java.io.FileReader(timestamp_withDate);
                br = new java.io.BufferedReader(fr);
                final String last = br.readLine();
                br.close();
                final String[] date_id = last.split(":");
                final long x = Long.parseLong(date_id[0]);
                final long y = System.currentTimeMillis();
                if (y - x >= 60000)
                    countID_withDate = 1;
                else
                    countID_withDate = Integer.parseInt(date_id[1]);
            }
        } catch (final java.io.IOException e) {
            e.printStackTrace(System.out);
            // setto random la seconda cifra dell'ID egov (suppongo che non
            // possano essere passati piu'
            // centomila messaggi in un minuto)
            countID_withDate = (new java.util.Random().nextInt(8) + 1) * 100000;
        } finally {
            try {
                if (br != null)
                    br.close();
                if (fr != null)
                    fr.close();
            } catch (final java.io.IOException e) {
            }
        }

    }

    public static synchronized int getCountInMinute(){
        return countID_withDate++;
    }

    public static void stopCountInMinute() {
        synchronized (timestamp_withDate) {
            java.io.FileWriter fw = null;
            java.io.BufferedWriter bw = null;
            try {
                fw = new java.io.FileWriter(timestamp_withDate);
                bw = new java.io.BufferedWriter(fw);
                bw.write("" + System.currentTimeMillis() + ":" + countID_withDate);
            } catch (final java.io.IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            } finally {
                try {
                    if (bw != null)
                        bw.close();
                    if (fw != null)
                        fw.close();
                } catch (final java.io.IOException e) {
                }
            }
        }
    }



    /* **** Contatore che mantiene il numero incrementale all'interno del minuto ***** */

    private static int countID_absolute = 1;

    private static java.io.File timestamp_absolute = new java.io.File(".lastRunAbsolute");

    static {
        java.io.FileReader fr = null;
        java.io.BufferedReader br = null;
        try {
            if(timestamp_absolute.exists()==false){
                countID_absolute = 0;
            }
            else{
                fr = new java.io.FileReader(timestamp_absolute);
                br = new java.io.BufferedReader(fr);
                final String last = br.readLine();
                br.close();
                final String[] date_id = last.split(":");
                //            long x = Long.parseLong(date_id[0]);
                //            long y = System.currentTimeMillis();
                //            if (y - x >= 60000)
                //                countID_absolute = 1;
                //            else
                countID_absolute = Integer.parseInt(date_id[1]);
            }
        } catch (final java.io.IOException e) {
            e.printStackTrace(System.out);
            // setto random la seconda cifra dell'ID egov (suppongo che non
            // possano essere passati piu'
            // centomila messaggi in un minuto)
            countID_absolute = (new java.util.Random().nextInt(8) + 1) * 100000;
        } finally {
            try {
                if (br != null)
                    br.close();
                if (fr != null)
                    fr.close();
            } catch (final java.io.IOException e) {
            }
        }

    }

    public static synchronized int getCountAbsolute(){
        return countID_absolute++;
    }

    public static void stopCountAbsolute() {
        synchronized (timestamp_absolute) {
            java.io.FileWriter fw = null;
            java.io.BufferedWriter bw = null;
            try {
                fw = new java.io.FileWriter(timestamp_absolute);
                bw = new java.io.BufferedWriter(fw);
                bw.write("" + System.currentTimeMillis() + ":" + countID_absolute);
            } catch (final java.io.IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            } finally {
                try {
                    if (bw != null)
                        bw.close();
                    if (fw != null)
                        fw.close();
                } catch (final java.io.IOException e) {
                }
            }
        }
    }




    // **** metodi di instanza *****

    long templateReplacedValueLength = 0;
    long templateLength = 0;
    long actualCountCalcolato = -1;

    public void template(final StringBuffer xml, final java.io.OutputStream osParam, final long actualCount, final boolean idAbsolute) throws java.io.IOException{
        final java.util.HashMap<String, String> mappa = new java.util.HashMap<String, String>();
        final java.util.Date now = new java.util.Date();
        //mappa.put("@DATAS@", datas.format(now));
        //mappa.put("@DATAM@", datam.format(now));
        //mappa.put(TEMPLATE_ID_SERIAL, String.format("%07d", getCount()));
        // replace values in header string
        int i = xml.indexOf("@");

        //final java.io.ByteArrayOutputStream os = new java.io.ByteArrayOutputStream();
        final java.io.OutputStream os = osParam;

        int delimiter=0;
        while ( i > -1 ) {

            if(os!=null)
                os.write(xml.substring(delimiter, i).getBytes());
            final StringBuffer keyBuffer = new StringBuffer("@");
            i++;
            while( (i<xml.length()) && (xml.charAt(i) != '@') && (xml.charAt(i) != '<') && (xml.charAt(i) != '>') && (xml.charAt(i) != ' ')  )
                keyBuffer.append(xml.charAt(i++));
            if((xml.charAt(i) == '@') || (xml.charAt(i) == '<') || (xml.charAt(i) == '>') || (xml.charAt(i) == ' ')){
                keyBuffer.append(xml.charAt(i));
            }
            i++;
            delimiter = i;
            final StringBuffer format = new StringBuffer();
            if(i<xml.length() && xml.charAt(i)=='{'){
                i++;
                while( (i<xml.length()) && (xml.charAt(i) != '}')  )
                    format.append(xml.charAt(i++));
                i++;
                delimiter = i;
            }

            final String key = keyBuffer.toString();

            //System.out.println("KEY ["+key+"]");

            this.templateLength = this.templateLength + key.length();
            if(TEMPLATE_ID_SERIAL.equals(key)){
                String formatToUse = SERIAL_FORMAT;
                if(format.length()>0){
                    formatToUse = format.toString();
                    this.templateLength = this.templateLength + format.length() + 2;
                }
                //System.out.println("TROVATO ["+key+"] FORMAT["+formatToUse+"] actualCount["+actualCount+"] ...");
                if(actualCount<0){
                    // lo stesso id potrebbe essere usato più volte nel solito messaggio
                    if(this.actualCountCalcolato<0){
                        //System.out.println("Calcolo idAbsolute["+idAbsolute+"]");
                        if(idAbsolute){
                            this.actualCountCalcolato = getCountAbsolute();
                        }
                        else{
                            this.actualCountCalcolato = getCountInMinute();
                        }
                    }
                }
                else{
                    this.actualCountCalcolato = actualCount;
                }
                final String serial = String.format(formatToUse, this.actualCountCalcolato);
                //System.out.println("TROVATO ["+key+"] FORMAT["+formatToUse+"] actualCount["+actualCount+"] this.actualCountCalcolato["+this.actualCountCalcolato+"] serial["+serial+"]");
                this.templateReplacedValueLength = this.templateReplacedValueLength + serial.length();
                if(os!=null)
                    os.write(serial.getBytes());
            }
            else if(TEMPLATE_ID_DATE.equals(key)){
                java.text.SimpleDateFormat formatToUse = datam;
                if(format.length()>0){
                    final String f = format.toString();
                    formatToUse = new java.text.SimpleDateFormat(f);
                    this.templateLength = this.templateLength + format.length() + 2;
                }
                final String date = formatToUse.format(now);
                this.templateReplacedValueLength = this.templateReplacedValueLength + date.length();
                if(os!=null)
                    os.write(date.getBytes());
            }
            else if(TEMPLATE_DATE.equals(key)){
                java.text.SimpleDateFormat formatToUse = datas;
                if(format.length()>0){
                    final String f = format.toString();
                    formatToUse = new java.text.SimpleDateFormat(f);
                    this.templateLength = this.templateLength + format.length() + 2;
                }
                final String date = formatToUse.format(now);
                this.templateReplacedValueLength = this.templateReplacedValueLength + date.length();
                if(os!=null)
                    os.write(date.getBytes());
            }
            else{
                final String value = mappa.get(key);
                //System.out.println("ELSE ["+key+"] ["+value+"]");
                if( value != null ){
                    this.templateReplacedValueLength = this.templateReplacedValueLength + value.length();
                    if(os!=null)
                        os.write(value.getBytes());
                }
                else{
                    this.templateReplacedValueLength = this.templateReplacedValueLength + key.length();
                    if(os!=null)
                        os.write(key.getBytes());
                }
            }

            //header.indexOf("@", delimiter)
            while( (i<xml.length()) && (xml.charAt(i) != '@') ) {
                i++;
            }
            //System.out.println("FINE I=["+i+"] xml=["+xml.length()+"]");
            if (i >= xml.length())
                i = -1;
            //System.out.println("I=["+i+"]");

            //i = header.indexOf("@", delimiter);
        }
        if (delimiter<xml.length()){
            if(os!=null){
                os.write(xml.substring(delimiter, xml.length()).getBytes());
            }
        }
        if(os!=null){
            this.actualCountCalcolato=-1;
        }

        //os.flush();
        //os.close();
        //System.out.println("Template ["+os.toString()+"]");
        //osParam.write(os.toByteArray());
    }

}
