/*
 * ====================================================================
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 */

package org.apache.http.entity.mime;

import org.apache.http.entity.mime.content.ContentBody;


public class RelatedBodyPart {


    private static final String MIME_CONTENT_ID = "Content-ID";
    private final String name;
    private final org.apache.http.entity.mime.Header header;

    private final ContentBody body;

    //public FormBodyPart(final String name, final ContentBody body) {
    public RelatedBodyPart(final String name, final ContentBody body) {
        if (name == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        if (body == null) {
            throw new IllegalArgumentException("Body may not be null");
        }
        this.name = name;
        this.body = body;
        this.header = new org.apache.http.entity.mime.Header();


        generateContentType(body);
        generateContentID(body);
        generateTransferEncoding(body);
    }

    public String getName() {
        return this.name;
    }

    public ContentBody getBody() {
        return this.body;
    }

    public org.apache.http.entity.mime.Header getHeader() {
        return this.header;
    }

    public void addField(final String name, final String value) {
        if (name == null) {
            throw new IllegalArgumentException("Field name may not be null");
        }
        this.header.addField(new MinimalField(name, value));
    }

    private void setField(final String name, final String value) {
        this.header.setField(new MinimalField(name, value));
    }

    protected void generateContentID(final ContentBody desc) {

        final StringBuilder buffer = new StringBuilder();
        buffer.append('<');
        // TODO Scrivere qualcosa per generare l' ID
        buffer.append(this.name);
        buffer.append('>');

        setField(MIME_CONTENT_ID, buffer.toString());
    }


    protected void generateContentType(final ContentBody desc) {
        if (desc.getMimeType() != null) {
            final StringBuilder buffer = new StringBuilder();
            buffer.append(desc.getMimeType());
            if (desc.getCharset() != null) {
                buffer.append("; charset=");
                buffer.append(desc.getCharset());
            }
            addField(MIME.CONTENT_TYPE, buffer.toString());
        } else {
            addField(MIME.CONTENT_TYPE, "text/plain");
        }

    }

    protected void generateTransferEncoding(final ContentBody desc) {
        if (desc.getTransferEncoding() != null) {
            addField(MIME.CONTENT_TRANSFER_ENC, desc.getTransferEncoding());
        } else {
            addField(MIME.CONTENT_TRANSFER_ENC, "binary\n");
        }

    }

    public String getContentId() {
        final MinimalField f = (MinimalField) getHeader().getField(MIME_CONTENT_ID);
        return f.getBody();

    }
}
