/*
 * ====================================================================
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 */

package org.apache.http.entity.mime.content;

import java.io.IOException;
import java.io.OutputStream;

import org.apache.http.benchmark.BustaContentProducer;
import org.apache.http.benchmark.XmlTemplateContentProducer;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.ContentType;

public class FileBodyTemplate extends AbstractContentBody {

    private final ContentProducer contentproducer ;

    public FileBodyTemplate(final ContentProducer cp,final String mimetype) {
        super(ContentType.parse(mimetype));
        this.contentproducer = cp;
    }

    public void writeTo(final OutputStream out) throws IOException {
        this.contentproducer.writeTo(out);
    }


    public String getFilename() {
        return null;
    }


    public String getCharset() {
        return null;
    }


    public long getContentLength() {
        if(this.contentproducer instanceof BustaContentProducer)
            return ((BustaContentProducer)this.contentproducer).getContentLength();
        else if(this.contentproducer instanceof XmlTemplateContentProducer)
            return ((XmlTemplateContentProducer)this.contentproducer).getContentLength();
        else
            throw new RuntimeException("ContentProducerType ["+this.contentproducer.getClass().getName()+"] not supported");
    }


    public String getTransferEncoding() {
        return null;
    }

}
