/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.pdd.config.ConfigurazioneNodiRuntimeBYOKRemoteConfig;
import org.openspcoop2.pdd.config.ConfigurazioneNodiRuntimeProperties;
import org.openspcoop2.pdd.config.InvokerNodiRuntime;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.properties.PropertiesReader;
import org.openspcoop2.utils.transport.TransportUtils;
import org.slf4j.Logger;

public class ConfigurazioneNodiRuntime {
    public static final String RESOURCE_NAME = "govway.nodirun.properties";
    public static final String RESOURCE_TIPOLOGIA_ACCESSO_JMX = "jmx";
    public static final String RESOURCE_TIPOLOGIA_ACCESSO_OPENSPCOOP = "openspcoop";
    public static final String RESOURCE_TIPOLOGIA_ACCESSO_GOVWAY = "govway";
    public static final String ALIAS_DEFAULT = "pdd";
    private static Map<String, ConfigurazioneNodiRuntime> staticInstanceMap = new HashMap<String, ConfigurazioneNodiRuntime>();
    private static final String PREFIX_DEFAULT = "";
    private PropertiesReader reader;
    private PropertiesReader readerClasspath;
    private String prefix = "";
    private boolean clusterDinamico = false;
    private List<String> aliases;
    private Map<String, List<String>> gruppiAliases;
    private Map<String, String> descrizione;
    private Map<String, String> tipoAccesso;
    private Map<String, String> username;
    private Map<String, String> password;
    private Map<String, Boolean> https;
    private Map<String, Boolean> httpsVerificaHostName;
    private Map<String, Boolean> httpsAutenticazioneServer;
    private Map<String, String> httpsAutenticazioneServerTruststorePath;
    private Map<String, String> httpsAutenticazioneServerTruststoreType;
    private Map<String, String> httpsAutenticazioneServerTruststorePassword;
    private Map<String, String> connectionTimeout;
    private Map<String, String> readConnectionTimeout;
    private Map<String, String> readConnectionTimeoutSlowOperation;
    private Map<String, String> as;
    private Map<String, String> factory;
    private Map<String, String> resourceUrl;
    private Map<String, String> checkStatusUrl;
    private Map<String, String> dominio;

    public static void initialize(String path, ConfigurazioneNodiRuntimeProperties ... backwardCompatibilitiesProperties) throws UtilsException {
        ConfigurazioneNodiRuntime.initialize(path, true, backwardCompatibilitiesProperties);
    }

    public static void initialize(String path, boolean configFileRequired, ConfigurazioneNodiRuntimeProperties ... backwardCompatibilitiesProperties) throws UtilsException {
        ConfigurazioneNodiRuntimeProperties cpClasspath = null;
        try (InputStream is = ConfigurazioneNodiRuntime.class.getResourceAsStream("/govway.nodirun.properties");){
            if (is != null) {
                Properties p = new Properties();
                p.load(is);
                cpClasspath = new ConfigurazioneNodiRuntimeProperties(PREFIX_DEFAULT, p);
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
        ConfigurazioneNodiRuntimeProperties cpFile = null;
        if (path != null && StringUtils.isNotEmpty((CharSequence)path)) {
            File f = new File(path);
            boolean read = false;
            if (cpClasspath != null || backwardCompatibilitiesProperties != null && backwardCompatibilitiesProperties.length > 0) {
                if (f.exists() && f.canRead()) {
                    read = true;
                }
            } else if (!f.exists()) {
                if (configFileRequired) {
                    throw new UtilsException("Configuration file '" + f.getAbsolutePath() + "' not exists");
                }
            } else if (!f.canRead()) {
                if (configFileRequired) {
                    throw new UtilsException("Configuration file '" + f.getAbsolutePath() + "' cannot read");
                }
            } else {
                read = true;
            }
            if (read) {
                try (FileInputStream fin = new FileInputStream(f);){
                    Properties p = new Properties();
                    p.load(fin);
                    cpFile = new ConfigurazioneNodiRuntimeProperties(PREFIX_DEFAULT, p);
                }
                catch (Exception e) {
                    throw new UtilsException(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (cpClasspath != null || cpFile != null) {
            ConfigurazioneNodiRuntime newInstance = new ConfigurazioneNodiRuntime(cpFile, cpClasspath);
            staticInstanceMap.put(PREFIX_DEFAULT, newInstance);
        }
        if (backwardCompatibilitiesProperties != null && backwardCompatibilitiesProperties.length > 0) {
            for (ConfigurazioneNodiRuntimeProperties bc : backwardCompatibilitiesProperties) {
                ConfigurazioneNodiRuntime newInstance = new ConfigurazioneNodiRuntime(bc, null);
                staticInstanceMap.put(bc.getPrefix(), newInstance);
            }
        }
    }

    public static ConfigurazioneNodiRuntime getConfigurazioneNodiRuntime() {
        return ConfigurazioneNodiRuntime.getConfigurazioneNodiRuntime(PREFIX_DEFAULT);
    }

    public static ConfigurazioneNodiRuntime getConfigurazioneNodiRuntime(String prefix) {
        if (staticInstanceMap != null) {
            return staticInstanceMap.get(prefix);
        }
        return null;
    }

    public static List<String> getPrefixes() {
        ArrayList<String> l = null;
        if (staticInstanceMap != null && !staticInstanceMap.isEmpty()) {
            l = new ArrayList<String>();
            l.addAll(staticInstanceMap.keySet());
            return l;
        }
        return l;
    }

    private ConfigurazioneNodiRuntime(ConfigurazioneNodiRuntimeProperties config, ConfigurazioneNodiRuntimeProperties configClasspath) throws UtilsException {
        if (config != null) {
            this.reader = new PropertiesReader(config.getProperties(), false);
            this.prefix = config.getPrefix();
        }
        if (configClasspath != null) {
            this.readerClasspath = new PropertiesReader(configClasspath.getProperties(), false);
            this.prefix = configClasspath.getPrefix();
        }
        if (this.reader == null && this.readerClasspath == null) {
            throw new UtilsException("Nessuna configurazione fornita");
        }
        this.initAliases();
        this.initGruppiAliases();
        this.initConfigAliases();
    }

    public boolean containsNode(String alias) {
        return this.aliases.contains(alias);
    }

    public void initClusterDinamico() throws UtilsException {
        String tipo = this.readProperty(false, "clusterDinamico");
        if (tipo != null) {
            this.clusterDinamico = "true".equalsIgnoreCase(tipo);
        } else if (!PREFIX_DEFAULT.equals(this.prefix) && (tipo = this.readProperty(false, "cluster_dinamico.enabled")) != null) {
            this.clusterDinamico = "true".equalsIgnoreCase(tipo);
        }
    }

    public boolean isClusterDinamico() {
        return this.clusterDinamico;
    }

    public void initAliases() throws UtilsException {
        ArrayList<String> list = new ArrayList<String>();
        String tipo = this.readProperty(false, "aliases");
        if (tipo != null && !PREFIX_DEFAULT.equals(tipo)) {
            String[] tmp = tipo.split(",");
            for (int i = 0; i < tmp.length; ++i) {
                list.add(tmp[i].trim());
            }
        }
        if (PREFIX_DEFAULT.equals(this.prefix) && list.isEmpty()) {
            list.add(ALIAS_DEFAULT);
        }
        this.aliases = list;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    private void initGruppiAliases() throws UtilsException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        String nomeP = "aliases.";
        Properties p = null;
        if (this.readerClasspath != null) {
            p = this.readerClasspath.readProperties(nomeP);
        }
        if (this.reader != null) {
            if (p == null || p.isEmpty()) {
                p = this.reader.readProperties(nomeP);
            } else {
                Properties pConfig = this.reader.readProperties(nomeP);
                if (pConfig != null && !pConfig.isEmpty()) {
                    p.putAll((Map<?, ?>)pConfig);
                }
            }
        }
        if (p != null && !p.isEmpty()) {
            List<String> aliasesRegistrati = this.getAliases();
            Enumeration<Object> en = p.keys();
            while (en.hasMoreElements()) {
                String[] tmp;
                Object object = en.nextElement();
                if (!(object instanceof String)) continue;
                String gruppo = (String)object;
                if (map.containsKey(gruppo)) {
                    throw new UtilsException("Gruppo '" + gruppo + "' definito pi\u00f9 di una volta nella propriet\u00e0 '" + this.prefix + nomeP + "*'");
                }
                String aliasesGruppo = p.getProperty(gruppo);
                if (aliasesGruppo == null || PREFIX_DEFAULT.equals(aliasesGruppo) || (tmp = aliasesGruppo.split(",")) == null || tmp.length <= 0) continue;
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < tmp.length; ++i) {
                    String alias = tmp[i].trim();
                    if (!aliasesRegistrati.contains(alias)) {
                        throw new UtilsException("Alias '" + alias + "' indicato nella propriet\u00e0 '" + nomeP + gruppo + "' non \u00e8 uno degli alias censiti in '" + this.prefix + "aliases'");
                    }
                    list.add(alias);
                }
                if (list.isEmpty()) continue;
                map.put(gruppo, list);
            }
        }
        this.gruppiAliases = map;
    }

    public Map<String, List<String>> getGruppi_aliases() {
        return this.gruppiAliases;
    }

    public void initConfigAliases() throws UtilsException {
        this.descrizione = new HashMap<String, String>();
        this.tipoAccesso = new HashMap<String, String>();
        this.username = new HashMap<String, String>();
        this.password = new HashMap<String, String>();
        this.https = new HashMap<String, Boolean>();
        this.httpsVerificaHostName = new HashMap<String, Boolean>();
        this.httpsAutenticazioneServer = new HashMap<String, Boolean>();
        this.httpsAutenticazioneServerTruststorePath = new HashMap<String, String>();
        this.httpsAutenticazioneServerTruststoreType = new HashMap<String, String>();
        this.httpsAutenticazioneServerTruststorePassword = new HashMap<String, String>();
        this.connectionTimeout = new HashMap<String, String>();
        this.readConnectionTimeout = new HashMap<String, String>();
        this.readConnectionTimeoutSlowOperation = new HashMap<String, String>();
        this.as = new HashMap<String, String>();
        this.factory = new HashMap<String, String>();
        this.resourceUrl = new HashMap<String, String>();
        this.checkStatusUrl = new HashMap<String, String>();
        this.dominio = new HashMap<String, String>();
        if (this.aliases != null && !this.aliases.isEmpty()) {
            for (String alias : this.aliases) {
                String v;
                String pwd;
                boolean tipoAccessoRequired;
                String tipoAccessoCfg;
                String descr = this.readProperty(false, alias + ".descrizione");
                if (descr != null) {
                    this.descrizione.put(alias, descr);
                }
                if ((tipoAccessoCfg = this.getValueEngine(tipoAccessoRequired = !PREFIX_DEFAULT.equals(this.prefix), alias, "tipoAccesso")) == null) {
                    tipoAccessoCfg = RESOURCE_TIPOLOGIA_ACCESSO_JMX;
                }
                if (RESOURCE_TIPOLOGIA_ACCESSO_GOVWAY.equals(tipoAccessoCfg)) {
                    tipoAccessoCfg = RESOURCE_TIPOLOGIA_ACCESSO_OPENSPCOOP;
                } else if (!RESOURCE_TIPOLOGIA_ACCESSO_JMX.equals(tipoAccessoCfg) && !RESOURCE_TIPOLOGIA_ACCESSO_OPENSPCOOP.equals(tipoAccessoCfg)) {
                    throw new UtilsException("Tipo di accesso [" + tipoAccessoCfg + "] non supportato per la propriet\u00e0 '" + this.prefix + "tipoAccesso'");
                }
                this.tipoAccesso.put(alias, tipoAccessoCfg);
                String user = this.getValueEngine(false, alias, "remoteAccess.username");
                if (user != null) {
                    this.username.put(alias, user);
                }
                if ((pwd = this.getValueEngine(false, alias, "remoteAccess.password")) != null) {
                    this.password.put(alias, pwd);
                }
                boolean httpsEnabled = (v = this.getValueEngine(false, alias, "remoteAccess.https")) != null ? Boolean.valueOf(v.trim()) : false;
                this.https.put(alias, httpsEnabled);
                v = this.getValueEngine(false, alias, "remoteAccess.https.verificaHostName");
                boolean httpsVerificaHostNameEnabled = v != null ? Boolean.valueOf(v.trim()) : true;
                this.httpsVerificaHostName.put(alias, httpsVerificaHostNameEnabled);
                v = this.getValueEngine(false, alias, "remoteAccess.https.autenticazioneServer");
                boolean httpsAutenticazioneServerEnabled = v != null ? Boolean.valueOf(v.trim()) : true;
                this.httpsAutenticazioneServer.put(alias, httpsAutenticazioneServerEnabled);
                v = this.getValueEngine(false, alias, "remoteAccess.https.autenticazioneServer.truststorePath");
                if (v != null) {
                    this.httpsAutenticazioneServerTruststorePath.put(alias, v);
                }
                if ((v = this.getValueEngine(false, alias, "remoteAccess.https.autenticazioneServer.truststoreType")) != null) {
                    this.httpsAutenticazioneServerTruststoreType.put(alias, v);
                }
                if ((v = this.getValueEngine(false, alias, "remoteAccess.https.autenticazioneServer.truststorePassword")) != null) {
                    this.httpsAutenticazioneServerTruststorePassword.put(alias, v);
                }
                if ((v = this.getValueEngine(false, alias, "remoteAccess.connectionTimeout")) != null) {
                    this.connectionTimeout.put(alias, v);
                }
                if ((v = this.getValueEngine(false, alias, "remoteAccess.readConnectionTimeout")) != null) {
                    this.readConnectionTimeout.put(alias, v);
                }
                if ((v = this.getValueEngine(false, alias, "remoteAccess.readConnectionTimeout.slowOperation")) != null) {
                    this.readConnectionTimeoutSlowOperation.put(alias, v);
                }
                if ((v = this.getValueEngine(false, alias, "remoteAccess.as")) != null) {
                    this.as.put(alias, v);
                }
                if ((v = this.getValueEngine(false, alias, "remoteAccess.factory")) != null) {
                    this.factory.put(alias, v);
                }
                if ((v = this.getValueEngine(false, alias, "remoteAccess.url")) != null) {
                    this.resourceUrl.put(alias, v);
                }
                if ((v = this.getValueEngine(false, alias, "remoteAccess.checkStatus.url")) != null) {
                    this.checkStatusUrl.put(alias, v);
                }
                if ((v = this.getValueEngine(!PREFIX_DEFAULT.equals(this.prefix), alias, "dominio")) != null) {
                    this.dominio.put(alias, v);
                    continue;
                }
                this.dominio.put(alias, "org.openspcoop2.pdd");
            }
        }
    }

    public String getDescrizione(String alias) {
        return this.descrizione.get(alias);
    }

    public String getTipoAccesso(String alias) {
        return this.tipoAccesso.get(alias);
    }

    public String getUsername(String alias) {
        return this.username.get(alias);
    }

    public String getPassword(String alias) {
        return this.password.get(alias);
    }

    public boolean isHttps(String alias) {
        return this.https.get(alias);
    }

    public boolean isHttps_verificaHostName(String alias) {
        return this.httpsVerificaHostName.get(alias);
    }

    public boolean isHttps_autenticazioneServer(String alias) {
        return this.httpsAutenticazioneServer.get(alias);
    }

    public String getHttps_autenticazioneServer_truststorePath(String alias) {
        return this.httpsAutenticazioneServerTruststorePath.get(alias);
    }

    public String getHttps_autenticazioneServer_truststoreType(String alias) {
        return this.httpsAutenticazioneServerTruststoreType.get(alias);
    }

    public String getHttps_autenticazioneServer_truststorePassword(String alias) {
        return this.httpsAutenticazioneServerTruststorePassword.get(alias);
    }

    public String getConnectionTimeout(String alias) {
        return this.connectionTimeout.get(alias);
    }

    public String getReadConnectionTimeout(String alias) {
        return this.readConnectionTimeout.get(alias);
    }

    public String getReadConnectionTimeout_slowOperation(String alias) {
        return this.readConnectionTimeoutSlowOperation.get(alias);
    }

    public String getAs(String alias) {
        return this.as.get(alias);
    }

    public String getFactory(String alias) {
        return this.factory.get(alias);
    }

    public String getResourceUrl(String alias) {
        return this.resourceUrl.get(alias);
    }

    public String getCheckStatusUrl(String alias) {
        return this.checkStatusUrl.get(alias);
    }

    public String getDominio(String alias) {
        return this.dominio.get(alias);
    }

    private String getValueEngine(boolean required, String alias, String prop) throws UtilsException {
        String tmp = this.readProperty(false, alias + "." + prop);
        if (tmp == null || PREFIX_DEFAULT.equals(tmp)) {
            tmp = this.readProperty(required, prop);
        }
        return tmp;
    }

    private String readProperty(boolean required, String property) throws UtilsException {
        String tmp = null;
        if (this.reader != null) {
            tmp = this.reader.getValue_convertEnvProperties(property);
        }
        if (tmp == null && this.readerClasspath != null) {
            tmp = this.readerClasspath.getValue_convertEnvProperties(property);
        }
        if (tmp == null) {
            if (required) {
                throw new UtilsException("Property [" + this.prefix + property + "] not found");
            }
            return null;
        }
        return tmp.trim();
    }

    private BooleanNullable readBooleanProperty(boolean required, String property) throws UtilsException {
        String tmp = this.readProperty(required, property);
        if (tmp == null && !required) {
            return BooleanNullable.NULL();
        }
        if (!"true".equalsIgnoreCase(tmp) && !"false".equalsIgnoreCase(tmp)) {
            throw new UtilsException("Property [" + this.prefix + property + "] with uncorrect value [" + tmp + "] (true/value expected)");
        }
        return Boolean.parseBoolean(tmp) ? BooleanNullable.TRUE() : BooleanNullable.FALSE();
    }

    private Integer readIntegerProperty(boolean required, String property) throws UtilsException {
        String tmp = this.readProperty(required, property);
        if (tmp == null && !required) {
            return null;
        }
        try {
            return Integer.parseInt(tmp);
        }
        catch (Exception e) {
            throw new UtilsException("Property [" + this.prefix + property + "] with uncorrect value [" + tmp + "] (int value expected)");
        }
    }

    private Long readLongProperty(boolean required, String property) throws UtilsException {
        String tmp = this.readProperty(required, property);
        if (tmp == null && !required) {
            return null;
        }
        try {
            return Long.parseLong(tmp);
        }
        catch (Exception e) {
            throw new UtilsException("Property [" + this.prefix + property + "] with uncorrect value [" + tmp + "] (long value expected)");
        }
    }

    public void initBYOKDynamicMapRemoteGovWayNode(Logger log, Map<String, Object> dynamicMap, boolean wrap, boolean unwrap, ConfigurazioneNodiRuntimeBYOKRemoteConfig remoteConfig) {
        if (this.aliases != null && !this.aliases.isEmpty()) {
            for (String alias : this.aliases) {
                if (!this.isActiveNode(log, alias, remoteConfig) || this.getResourceUrl(alias) == null || PREFIX_DEFAULT.equals(this.getResourceUrl(alias)) || "locale".equals(this.getResourceUrl(alias))) continue;
                this.initBYOKDynamicMapRemoteGovWayNode(dynamicMap, wrap, unwrap, alias, remoteConfig);
                break;
            }
        }
    }

    public boolean isAtLeastOneActiveNode(Logger log, ConfigurazioneNodiRuntimeBYOKRemoteConfig remoteConfig) {
        if (this.aliases != null && !this.aliases.isEmpty()) {
            for (String alias : this.aliases) {
                if (!this.isActiveNode(log, alias, remoteConfig)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isActiveNode(Logger log, String alias, ConfigurazioneNodiRuntimeBYOKRemoteConfig remoteConfig) {
        try {
            InvokerNodiRuntime invoker = new InvokerNodiRuntime(null, this);
            String value = invoker.readJMXAttribute(alias, remoteConfig.getType(), remoteConfig.getResourceStatoServiziPdd(), remoteConfig.getAttributeComponentePD());
            return value != null && !PREFIX_DEFAULT.equals(value) && !value.startsWith("[httpCode ") && (CostantiConfigurazione.ABILITATO.getValue().equals(value) || CostantiConfigurazione.DISABILITATO.getValue().equals(value));
        }
        catch (Exception e) {
            log.debug("Nodo '" + alias + "' non non attivo?: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private void initBYOKDynamicMapRemoteGovWayNode(Map<String, Object> dynamicMap, boolean wrap, boolean unwrap, String alias, ConfigurazioneNodiRuntimeBYOKRemoteConfig remoteConfig) {
        String pwd;
        String user;
        String remoteUrl = this.getResourceUrl(alias);
        HashMap<String, String> govwayContext = new HashMap<String, String>();
        dynamicMap.put("govway-runtime", govwayContext);
        HashMap p = new HashMap();
        TransportUtils.setParameter(p, (String)"resourceName", (String)remoteConfig.getResourceConfigurazioneSistema());
        if (wrap) {
            TransportUtils.setParameter(p, (String)"methodName", (String)remoteConfig.getMethodWrap());
            String urlWrap = TransportUtils.buildUrlWithParameters(p, (String)remoteUrl);
            govwayContext.put("endpoint-wrap", urlWrap);
        }
        if (unwrap) {
            TransportUtils.setParameter(p, (String)"methodName", (String)remoteConfig.getMethodUnwrap());
            String urlUnwrap = TransportUtils.buildUrlWithParameters(p, (String)remoteUrl);
            govwayContext.put("endpoint-unwrap", urlUnwrap);
        }
        if ((user = this.getUsername(alias)) != null) {
            govwayContext.put("username", user);
        }
        if ((pwd = this.getPassword(alias)) != null) {
            govwayContext.put("password", pwd);
        }
    }
}

