/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.ConfigurazioneGenerale;
import org.openspcoop2.core.controllo_traffico.ConfigurazionePolicy;
import org.openspcoop2.core.controllo_traffico.ConfigurazioneRateLimitingProprieta;
import org.openspcoop2.core.controllo_traffico.ElencoIdPolicy;
import org.openspcoop2.core.controllo_traffico.ElencoIdPolicyAttive;
import org.openspcoop2.core.controllo_traffico.IdActivePolicy;
import org.openspcoop2.core.controllo_traffico.IdPolicy;
import org.openspcoop2.core.controllo_traffico.beans.UniqueIdentifierUtilities;
import org.openspcoop2.core.controllo_traffico.constants.RuoloPolicy;
import org.openspcoop2.core.controllo_traffico.constants.TipoRisorsaPolicyAttiva;
import org.openspcoop2.core.controllo_traffico.dao.IAttivazionePolicyServiceSearch;
import org.openspcoop2.core.controllo_traffico.dao.IConfigurazionePolicyServiceSearch;
import org.openspcoop2.core.controllo_traffico.dao.IServiceManager;
import org.openspcoop2.core.controllo_traffico.utils.ProjectInfo;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.pdd.config.AbstractConfigurazionePdDConnectionResourceManager;
import org.openspcoop2.pdd.config.ConfigurazionePdDConnectionResource;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.controllo_traffico.policy.config.PolicyConfiguration;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.slf4j.Logger;

public class ConfigurazionePdD_controlloTraffico
extends AbstractConfigurazionePdDConnectionResourceManager {
    private ServiceManagerProperties smp = new ServiceManagerProperties();
    private static ConfigurazioneGenerale configurazioneGenerale = null;
    private static PolicyConfiguration configurazionePolicyRateLimitingGlobali = null;

    public ConfigurazionePdD_controlloTraffico(OpenSPCoop2Properties openspcoopProperties, DriverConfigurazioneDB driver, boolean useConnectionPdD) {
        super(openspcoopProperties, driver, useConnectionPdD, OpenSPCoop2Logger.getLoggerOpenSPCoopControlloTrafficoSql(openspcoopProperties.isControlloTrafficoDebug()));
        this.smp.setShowSql(this.openspcoopProperties.isControlloTrafficoDebug());
        this.smp.setDatabaseType(this.driver.getTipoDB());
    }

    public ConfigurazioneGenerale getConfigurazioneControlloTraffico(Connection connectionPdD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (this.configurazioneDinamica || configurazioneGenerale == null) {
            ConfigurazionePdDConnectionResource cr = null;
            try {
                cr = this.getConnection(connectionPdD, "ControlloTraffico.getConfigurazioneGenerale");
                IServiceManager sm = (IServiceManager)DAOFactory.getInstance((Logger)this.log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), cr.connectionDB, this.smp, this.log);
                configurazioneGenerale = (ConfigurazioneGenerale)sm.getConfigurazioneGeneraleServiceSearch().get();
            }
            catch (NotFoundException e) {
                String errorMsg = "Configurazione del Controllo del Traffico non trovata: " + e.getMessage();
                this.log.debug(errorMsg, (Throwable)e);
                throw new DriverConfigurazioneNotFound(errorMsg, (Throwable)e);
            }
            catch (Exception e) {
                String errorMsg = "Errore durante la configurazione del Controllo del Traffico: " + e.getMessage();
                this.log.error(errorMsg, (Throwable)e);
                throw new DriverConfigurazioneException(errorMsg, (Throwable)e);
            }
            finally {
                this.releaseConnection(cr);
            }
        }
        return configurazioneGenerale;
    }

    public PolicyConfiguration getConfigurazionePolicyRateLimitingGlobali(Connection connectionPdD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (this.configurazioneDinamica || configurazionePolicyRateLimitingGlobali == null) {
            ConfigurazionePdDConnectionResource cr = null;
            try {
                cr = this.getConnection(connectionPdD, "ControlloTraffico.getConfigurazionePolicyRateLimitingGlobali");
                IServiceManager sm = (IServiceManager)DAOFactory.getInstance((Logger)this.log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), cr.connectionDB, this.smp, this.log);
                ArrayList<Proprieta> list = new ArrayList<Proprieta>();
                List l = sm.getConfigurazioneRateLimitingProprietaServiceSearch().findAll(sm.getConfigurazioneRateLimitingProprietaServiceSearch().newPaginatedExpression());
                if (l != null && !l.isEmpty()) {
                    for (ConfigurazioneRateLimitingProprieta configurazioneRateLimitingProprieta : l) {
                        Proprieta p = new Proprieta();
                        p.setNome(configurazioneRateLimitingProprieta.getNome());
                        p.setValore(configurazioneRateLimitingProprieta.getValore());
                        list.add(p);
                    }
                }
                configurazionePolicyRateLimitingGlobali = new PolicyConfiguration(list);
            }
            catch (NotFoundException e) {
                String errorMsg = "Configurazione delle policy globali di rate limiting non trovata: " + e.getMessage();
                this.log.debug(errorMsg, (Throwable)e);
                throw new DriverConfigurazioneNotFound(errorMsg, (Throwable)e);
            }
            catch (Exception e) {
                String errorMsg = "Errore durante la configurazione del Controllo del Traffico: " + e.getMessage();
                this.log.error(errorMsg, (Throwable)e);
                throw new DriverConfigurazioneException(errorMsg, (Throwable)e);
            }
            finally {
                this.releaseConnection(cr);
            }
        }
        return configurazionePolicyRateLimitingGlobali;
    }

    public Map<TipoRisorsaPolicyAttiva, ElencoIdPolicyAttive> getElencoIdPolicyAttiveAPI(Connection connectionPdD, TipoPdD tipoPdD, String nomePorta) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getElencoIdPolicyApiAttiveEngine(connectionPdD, tipoPdD, nomePorta, true, false, true);
    }

    public Map<TipoRisorsaPolicyAttiva, ElencoIdPolicyAttive> getElencoIdPolicyAttiveGlobali(Connection connectionPdD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getElencoIdPolicyApiAttiveEngine(connectionPdD, null, null, false, false, true);
    }

    public Map<TipoRisorsaPolicyAttiva, ElencoIdPolicyAttive> getElencoIdPolicyAttiveAPIDimensioneMessaggio(Connection connectionPdD, TipoPdD tipoPdD, String nomePorta) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getElencoIdPolicyApiAttiveEngine(connectionPdD, tipoPdD, nomePorta, true, true, false);
    }

    public Map<TipoRisorsaPolicyAttiva, ElencoIdPolicyAttive> getElencoIdPolicyAttiveGlobaliDimensioneMessaggio(Connection connectionPdD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getElencoIdPolicyApiAttiveEngine(connectionPdD, null, null, false, true, false);
    }

    private Map<TipoRisorsaPolicyAttiva, ElencoIdPolicyAttive> getElencoIdPolicyApiAttiveEngine(Connection connectionPdD, TipoPdD tipoPdD, String nomePorta, boolean api, boolean includiSoloPolicyDimensioneMessaggio, boolean escludiPolicyDimensioneMessaggio) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        String prefix = "";
        if (includiSoloPolicyDimensioneMessaggio) {
            prefix = " [DimensioneMessaggio]";
        }
        if (api) {
            if (tipoPdD == null) {
                throw new DriverConfigurazioneException("Tipo PdD non fornito; richiesto per una policy API" + prefix);
            }
            if (nomePorta == null) {
                throw new DriverConfigurazioneException("Nome Porta non fornito; richiesto per una policy API" + prefix);
            }
        }
        ConfigurazionePdDConnectionResource cr = null;
        try {
            String errorMsg;
            cr = this.getConnection(connectionPdD, "ControlloTraffico.getElencoIdPolicyAttive");
            IServiceManager sm = (IServiceManager)DAOFactory.getInstance((Logger)this.log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), cr.connectionDB, this.smp, this.log);
            IAttivazionePolicyServiceSearch search = sm.getAttivazionePolicyServiceSearch();
            IPaginatedExpression expression = search.newPaginatedExpression();
            if (api) {
                if (TipoPdD.DELEGATA.equals((Object)tipoPdD)) {
                    expression.equals(AttivazionePolicy.model().FILTRO.RUOLO_PORTA, (Object)RuoloPolicy.DELEGATA.getValue());
                } else {
                    expression.equals(AttivazionePolicy.model().FILTRO.RUOLO_PORTA, (Object)RuoloPolicy.APPLICATIVA.getValue());
                }
                expression.equals(AttivazionePolicy.model().FILTRO.NOME_PORTA, (Object)nomePorta);
            } else {
                expression.isNull(AttivazionePolicy.model().FILTRO.NOME_PORTA);
            }
            expression.limit(100000);
            expression.addOrder(AttivazionePolicy.model().POSIZIONE, SortOrder.ASC);
            List list = search.findAllIds(expression);
            if (list != null && list.size() > 0) {
                HashMap<TipoRisorsaPolicyAttiva, ElencoIdPolicyAttive> map = new HashMap<TipoRisorsaPolicyAttiva, ElencoIdPolicyAttive>();
                for (IdActivePolicy idActivePolicy : list) {
                    ConfigurazionePolicy confPolicy = null;
                    try {
                        confPolicy = this.getConfigurazionePolicy(cr, idActivePolicy.getIdPolicy());
                    }
                    catch (DriverConfigurazioneNotFound e) {
                        this.log.error("Configurazione Policy '" + idActivePolicy.getIdPolicy() + "' non esistente ? ", (Throwable)e);
                        throw new NotFoundException("Configurazione Policy '" + idActivePolicy.getIdPolicy() + "' non esistente", (Throwable)e);
                    }
                    if (confPolicy == null) {
                        throw new NotFoundException("Configurazione Policy '" + idActivePolicy.getIdPolicy() + "' non esistente");
                    }
                    ElencoIdPolicyAttive elencoIdPolicy = null;
                    TipoRisorsaPolicyAttiva tipoPolicyAttiva = TipoRisorsaPolicyAttiva.getTipo((String)confPolicy.getRisorsa(), (boolean)confPolicy.isSimultanee());
                    if (!escludiPolicyDimensioneMessaggio ? includiSoloPolicyDimensioneMessaggio && !TipoRisorsaPolicyAttiva.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)tipoPolicyAttiva) : TipoRisorsaPolicyAttiva.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)tipoPolicyAttiva)) continue;
                    if (map.containsKey(tipoPolicyAttiva)) {
                        elencoIdPolicy = (ElencoIdPolicyAttive)map.get(tipoPolicyAttiva);
                    } else {
                        elencoIdPolicy = new ElencoIdPolicyAttive();
                        map.put(tipoPolicyAttiva, elencoIdPolicy);
                    }
                    elencoIdPolicy.addIdActivePolicy(idActivePolicy);
                }
                if (map.isEmpty()) {
                    if (api) {
                        throw new NotFoundException("policy API non esistenti per la porta '" + nomePorta + "' (ruolo: " + tipoPdD.getTipo() + ")" + prefix);
                    }
                    throw new NotFoundException("policy globali non esistenti" + prefix);
                }
                HashMap<TipoRisorsaPolicyAttiva, ElencoIdPolicyAttive> hashMap = map;
                return hashMap;
            }
            try {
                if (api) {
                    throw new NotFoundException("policy API non esistenti per la porta '" + nomePorta + "' (ruolo: " + tipoPdD.getTipo() + ")" + prefix);
                }
                throw new NotFoundException("policy globali non esistenti" + prefix);
            }
            catch (NotFoundException e) {
                errorMsg = "ElencoIdPolicyAttive del Controllo del Traffico non trovata: " + e.getMessage();
                this.log.debug(errorMsg, (Throwable)e);
                throw new DriverConfigurazioneNotFound(errorMsg, (Throwable)e);
            }
            catch (Exception e) {
                errorMsg = "Errore durante la lettura dell'ElencoIdPolicyAttive del Controllo del Traffico: " + e.getMessage();
                this.log.error(errorMsg, (Throwable)e);
                throw new DriverConfigurazioneException(errorMsg, (Throwable)e);
            }
        }
        finally {
            this.releaseConnection(cr);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AttivazionePolicy getAttivazionePolicy(Connection connectionPdD, String id) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        AttivazionePolicy attivazionePolicy;
        ConfigurazionePdDConnectionResource cr = null;
        try {
            cr = this.getConnection(connectionPdD, "ControlloTraffico.getAttivazionePolicy_" + id);
            IServiceManager sm = (IServiceManager)DAOFactory.getInstance((Logger)this.log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), cr.connectionDB, this.smp, this.log);
            IAttivazionePolicyServiceSearch search = sm.getAttivazionePolicyServiceSearch();
            IdActivePolicy policyId = new IdActivePolicy();
            policyId.setNome(UniqueIdentifierUtilities.extractIdActivePolicy((String)id));
            attivazionePolicy = (AttivazionePolicy)search.get((Object)policyId);
        }
        catch (NotFoundException e) {
            try {
                String errorMsg = "AttivazionePolicy del Controllo del Traffico non trovata: " + e.getMessage();
                this.log.debug(errorMsg, (Throwable)e);
                throw new DriverConfigurazioneNotFound(errorMsg, (Throwable)e);
                catch (Exception e2) {
                    errorMsg = "Errore durante la lettura dell'AttivazionePolicy del Controllo del Traffico: " + e2.getMessage();
                    this.log.error(errorMsg, (Throwable)e2);
                    throw new DriverConfigurazioneException(errorMsg, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.releaseConnection(cr);
                throw throwable;
            }
        }
        this.releaseConnection(cr);
        return attivazionePolicy;
    }

    public ElencoIdPolicy getElencoIdPolicy(Connection connectionPdD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        ConfigurazionePdDConnectionResource cr = null;
        try {
            cr = this.getConnection(connectionPdD, "ControlloTraffico.getElencoIdPolicy");
            IServiceManager sm = (IServiceManager)DAOFactory.getInstance((Logger)this.log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), cr.connectionDB, this.smp, this.log);
            ElencoIdPolicy elencoIdPolicy = new ElencoIdPolicy();
            IConfigurazionePolicyServiceSearch search = sm.getConfigurazionePolicyServiceSearch();
            IPaginatedExpression expression = search.newPaginatedExpression();
            expression.limit(100000);
            List list = search.findAllIds(expression);
            if (list != null && !list.isEmpty()) {
                elencoIdPolicy.setIdPolicyList(list);
            }
            ElencoIdPolicy elencoIdPolicy2 = elencoIdPolicy;
            return elencoIdPolicy2;
        }
        catch (Exception e) {
            String errorMsg = "Errore durante la lettura dell'ElencoIdPolicy del Controllo del Traffico: " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            throw new DriverConfigurazioneException(errorMsg, (Throwable)e);
        }
        finally {
            this.releaseConnection(cr);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConfigurazionePolicy getConfigurazionePolicy(Connection connectionPdD, String id) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        ConfigurazionePolicy configurazionePolicy;
        ConfigurazionePdDConnectionResource cr = null;
        try {
            cr = this.getConnection(connectionPdD, "ControlloTraffico.getConfigurazionePolicy_" + id);
            configurazionePolicy = this.getConfigurazionePolicy(cr, id);
        }
        catch (DriverConfigurazioneNotFound e) {
            try {
                throw e;
                catch (DriverConfigurazioneException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    String errorMsg = "Errore durante la lettura della ConfigurazionePolicy del Controllo del Traffico: " + e3.getMessage();
                    this.log.error(errorMsg, (Throwable)e3);
                    throw new DriverConfigurazioneException(errorMsg, (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                this.releaseConnection(cr);
                throw throwable;
            }
        }
        this.releaseConnection(cr);
        return configurazionePolicy;
    }

    private ConfigurazionePolicy getConfigurazionePolicy(ConfigurazionePdDConnectionResource crParam, String id) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        try {
            IServiceManager sm = (IServiceManager)DAOFactory.getInstance((Logger)this.log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), crParam.connectionDB, this.smp, this.log);
            IConfigurazionePolicyServiceSearch search = sm.getConfigurazionePolicyServiceSearch();
            IdPolicy policyId = new IdPolicy();
            policyId.setNome(id);
            return (ConfigurazionePolicy)search.get((Object)policyId);
        }
        catch (NotFoundException e) {
            String errorMsg = "ConfigurazionePolicy del Controllo del Traffico non trovata: " + e.getMessage();
            this.log.debug(errorMsg, (Throwable)e);
            throw new DriverConfigurazioneNotFound(errorMsg, (Throwable)e);
        }
        catch (Exception e) {
            String errorMsg = "Errore durante la lettura della ConfigurazionePolicy del Controllo del Traffico: " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            throw new DriverConfigurazioneException(errorMsg, (Throwable)e);
        }
    }
}

