/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config;

import java.sql.Connection;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.IMonitoraggioRisorsa;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.DBManager;
import org.openspcoop2.pdd.config.DBTransazioniManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.Resource;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsAlreadyExistsException;
import org.openspcoop2.utils.datasource.DataSource;
import org.openspcoop2.utils.datasource.DataSourceFactory;
import org.openspcoop2.utils.datasource.DataSourceParams;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.resources.GestoreJNDI;
import org.slf4j.Logger;

public class DBConsegnePreseInCaricoManager
implements IMonitoraggioRisorsa {
    private static DBConsegnePreseInCaricoManager staticInstanceDBSmistatoreManager;
    private static DBConsegnePreseInCaricoManager staticInstanceDBRuntimeManager;
    private static DBConsegnePreseInCaricoManager staticInstanceDBTransazioniManager;
    private static ConcurrentHashMap<String, Resource> risorseInGestioneSmistatore;
    private static ConcurrentHashMap<String, Resource> risorseInGestioneRuntime;
    private static ConcurrentHashMap<String, Resource> risorseInGestioneTransazioni;
    private String tipoDatabase;
    private Logger log;
    private DBManager dbManagerRuntimePdD;
    private DBTransazioniManager dbManagerTransazioni;
    private javax.sql.DataSource datasourceDedicato;
    private String identita;

    public static synchronized void initSmistatore(DBManager dbManagerRuntimePdD, Logger alog, String tipoDatabase) throws Exception {
        if (staticInstanceDBSmistatoreManager == null) {
            staticInstanceDBSmistatoreManager = new DBConsegnePreseInCaricoManager(dbManagerRuntimePdD, alog, tipoDatabase, true);
        }
    }

    public static synchronized void initSmistatore(String nomeDataSource, Properties context, Logger alog, String tipoDatabase, boolean useOp2UtilsDatasource, boolean bindJMX) throws Exception {
        if (staticInstanceDBSmistatoreManager == null) {
            staticInstanceDBSmistatoreManager = new DBConsegnePreseInCaricoManager(nomeDataSource, context, alog, tipoDatabase, useOp2UtilsDatasource, bindJMX, true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DBConsegnePreseInCaricoManager getInstanceSmistatore() {
        if (staticInstanceDBSmistatoreManager != null) return staticInstanceDBSmistatoreManager;
        Class<DBConsegnePreseInCaricoManager> clazz = DBConsegnePreseInCaricoManager.class;
        synchronized (DBConsegnePreseInCaricoManager.class) {
            if (staticInstanceDBSmistatoreManager != null) return staticInstanceDBSmistatoreManager;
            // ** MonitorExit[var0] (shouldn't be in output)
            return null;
        }
    }

    public static synchronized void initRuntime(DBManager dbManagerRuntimePdD, Logger alog, String tipoDatabase) throws Exception {
        if (staticInstanceDBRuntimeManager == null) {
            staticInstanceDBRuntimeManager = new DBConsegnePreseInCaricoManager(dbManagerRuntimePdD, alog, tipoDatabase, false);
        }
    }

    public static synchronized void initRuntime(String nomeDataSource, Properties context, Logger alog, String tipoDatabase, boolean useOp2UtilsDatasource, boolean bindJMX) throws Exception {
        if (staticInstanceDBRuntimeManager == null) {
            staticInstanceDBRuntimeManager = new DBConsegnePreseInCaricoManager(nomeDataSource, context, alog, tipoDatabase, useOp2UtilsDatasource, bindJMX, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DBConsegnePreseInCaricoManager getInstanceRuntime() {
        if (staticInstanceDBRuntimeManager != null) return staticInstanceDBRuntimeManager;
        Class<DBConsegnePreseInCaricoManager> clazz = DBConsegnePreseInCaricoManager.class;
        synchronized (DBConsegnePreseInCaricoManager.class) {
            if (staticInstanceDBRuntimeManager != null) return staticInstanceDBRuntimeManager;
            // ** MonitorExit[var0] (shouldn't be in output)
            return null;
        }
    }

    public static synchronized void initTransazioni(DBTransazioniManager dbManagerTransazioni, Logger alog, String tipoDatabase) throws Exception {
        if (staticInstanceDBTransazioniManager == null) {
            staticInstanceDBTransazioniManager = new DBConsegnePreseInCaricoManager(dbManagerTransazioni, alog, tipoDatabase);
        }
    }

    public static synchronized void initTransazioni(String nomeDataSource, Properties context, Logger alog, String tipoDatabase, boolean useOp2UtilsDatasource, boolean bindJMX) throws Exception {
        if (staticInstanceDBTransazioniManager == null) {
            staticInstanceDBTransazioniManager = new DBConsegnePreseInCaricoManager(nomeDataSource, context, alog, tipoDatabase, useOp2UtilsDatasource, bindJMX, false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DBConsegnePreseInCaricoManager getInstanceTransazioni() {
        if (staticInstanceDBTransazioniManager != null) return staticInstanceDBTransazioniManager;
        Class<DBConsegnePreseInCaricoManager> clazz = DBConsegnePreseInCaricoManager.class;
        synchronized (DBConsegnePreseInCaricoManager.class) {
            if (staticInstanceDBTransazioniManager != null) return staticInstanceDBTransazioniManager;
            // ** MonitorExit[var0] (shouldn't be in output)
            return null;
        }
    }

    public static String[] getStatoRisorseSmistatore() throws Exception {
        return DBManager.getStatoRisorse(risorseInGestioneSmistatore);
    }

    public static String[] getStatoRisorseRuntime() throws Exception {
        return DBManager.getStatoRisorse(risorseInGestioneRuntime);
    }

    public static String[] getStatoRisorseTransazioni() throws Exception {
        return DBManager.getStatoRisorse(risorseInGestioneTransazioni);
    }

    public String getTipoDatabase() {
        return this.tipoDatabase;
    }

    public boolean useDefaultManager() {
        return this.dbManagerRuntimePdD != null || this.dbManagerTransazioni != null;
    }

    public boolean useRuntimePdD() {
        if (this.useDefaultManager()) {
            return this.dbManagerRuntimePdD != null || this.dbManagerTransazioni.useRuntimePdD();
        }
        return false;
    }

    private DBConsegnePreseInCaricoManager(DBManager dbManagerRuntimePdD, Logger alog, String tipoDatabase, boolean smistatore) throws Exception {
        this(alog, tipoDatabase, smistatore, false);
        this.dbManagerRuntimePdD = dbManagerRuntimePdD;
    }

    private DBConsegnePreseInCaricoManager(DBTransazioniManager dbManagerTransazioni, Logger alog, String tipoDatabase) throws Exception {
        this(alog, tipoDatabase, false, true);
        this.dbManagerTransazioni = dbManagerTransazioni;
    }

    private DBConsegnePreseInCaricoManager(String nomeDataSource, Properties context, Logger alog, String tipoDatabase, boolean useOp2UtilsDatasource, boolean bindJMX, boolean smistatore, boolean tracce) throws Exception {
        block6: {
            this(alog, tipoDatabase, smistatore, tracce);
            try {
                if (useOp2UtilsDatasource) {
                    DataSourceParams dsParams = Costanti.getDataSourceParamsPdD((boolean)bindJMX, (String)tipoDatabase);
                    try {
                        this.datasourceDedicato = DataSourceFactory.newInstance((String)nomeDataSource, (Properties)context, (DataSourceParams)dsParams);
                        break block6;
                    }
                    catch (UtilsAlreadyExistsException exists) {
                        this.datasourceDedicato = DataSourceFactory.getInstance((String)nomeDataSource);
                        if (this.datasourceDedicato == null) {
                            throw new Exception("Lookup datasource non riuscita (" + exists.getMessage() + ")", exists);
                        }
                        break block6;
                    }
                }
                GestoreJNDI gestoreJNDI = new GestoreJNDI(context);
                this.datasourceDedicato = (javax.sql.DataSource)gestoreJNDI.lookup(nomeDataSource);
            }
            catch (Exception ne) {
                this.log.error("Impossibile instanziare il manager: " + ne.getMessage(), (Throwable)ne);
                throw ne;
            }
        }
    }

    private DBConsegnePreseInCaricoManager(Logger alog, String tipoDatabase, boolean smistatore, boolean tracce) throws Exception {
        this.log = alog;
        this.tipoDatabase = tipoDatabase;
        this.identita = smistatore ? "DBConsegnePreseInCaricoSmistatoreManager" : (tracce ? "DBConsegnePreseInCaricoTransazioniManager" : "DBConsegnePreseInCaricoRuntimeManager");
    }

    private boolean isIamSmistatoreManager() {
        return "DBConsegnePreseInCaricoSmistatoreManager".equals(this.identita);
    }

    private boolean isIamRuntimeManager() {
        return "DBConsegnePreseInCaricoRuntimeManager".equals(this.identita);
    }

    private boolean isIamTransazioniManager() {
        return "DBConsegnePreseInCaricoTransazioniManager".equals(this.identita);
    }

    public Resource getResource(IDSoggetto idPDD, String modulo, String idTransazione) throws Exception {
        return this.getResource(idPDD, modulo, idTransazione, true);
    }

    public Resource getResource(IDSoggetto idPDD, String modulo, String idTransazione, boolean logError) throws Exception {
        if (this.dbManagerRuntimePdD != null) {
            return this.dbManagerRuntimePdD.getResource(idPDD, modulo, idTransazione, logError);
        }
        if (this.dbManagerTransazioni != null) {
            return this.dbManagerTransazioni.getResource(idPDD, modulo, idTransazione, logError);
        }
        try {
            StringBuilder bf = new StringBuilder();
            if (idPDD != null) {
                bf.append(idPDD.toString());
                if (modulo != null) {
                    bf.append(".");
                }
            }
            if (modulo != null) {
                bf.append(modulo);
            }
            if (bf.length() <= 0) {
                bf.append(this.identita);
            }
            Resource risorsa = DBManager.buildResource(this.identita, this.getConnectionFromDatasource(bf.toString(), idTransazione), idPDD, modulo, idTransazione);
            if (this.isIamSmistatoreManager()) {
                risorseInGestioneSmistatore.put(risorsa.getId(), risorsa);
            } else if (this.isIamRuntimeManager()) {
                risorseInGestioneRuntime.put(risorsa.getId(), risorsa);
            } else if (this.isIamTransazioniManager()) {
                risorseInGestioneTransazioni.put(risorsa.getId(), risorsa);
            }
            return risorsa;
        }
        catch (Exception e) {
            this.log.error("Errore durante l'ottenimento di una connessione: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private Connection getConnectionFromDatasource(String methodName, String idTransazione) throws Exception {
        if (this.datasourceDedicato instanceof DataSource) {
            return ((DataSource)this.datasourceDedicato).getWrappedConnection(idTransazione, (Object)(this.identita + "." + methodName));
        }
        return this.datasourceDedicato.getConnection();
    }

    public void releaseResource(IDSoggetto idPDD, String modulo, Resource resource) {
        this.releaseResource(idPDD, modulo, resource, true);
    }

    public void releaseResource(IDSoggetto idPDD, String modulo, Resource resource, boolean logError) {
        try {
            if (this.dbManagerRuntimePdD != null) {
                this.dbManagerRuntimePdD.releaseResource(idPDD, modulo, resource, logError);
            } else if (this.dbManagerTransazioni != null) {
                this.dbManagerTransazioni.releaseResource(idPDD, modulo, resource, logError);
            } else if (resource != null) {
                Connection connectionDB;
                if (resource.getResource() != null && (connectionDB = (Connection)resource.getResource()) != null && !connectionDB.isClosed()) {
                    Logger logR = OpenSPCoop2Logger.getLoggerOpenSPCoopResources() != null ? OpenSPCoop2Logger.getLoggerOpenSPCoopResources() : LoggerWrapperFactory.getLogger(DBConsegnePreseInCaricoManager.class);
                    boolean checkAutocommit = OpenSPCoop2Properties.getInstance() == null || OpenSPCoop2Properties.getInstance().isJdbcCloseConnectionCheckAutocommit();
                    boolean checkIsClosed = OpenSPCoop2Properties.getInstance() == null || OpenSPCoop2Properties.getInstance().isJdbcCloseConnectionCheckIsClosed();
                    JDBCUtilities.closeConnection((Logger)logR, (Connection)connectionDB, (boolean)checkAutocommit, (boolean)checkIsClosed);
                }
                if (this.isIamSmistatoreManager()) {
                    if (risorseInGestioneSmistatore.containsKey(resource.getId())) {
                        risorseInGestioneSmistatore.remove(resource.getId());
                    }
                } else if (this.isIamRuntimeManager()) {
                    if (risorseInGestioneRuntime.containsKey(resource.getId())) {
                        risorseInGestioneRuntime.remove(resource.getId());
                    }
                } else if (this.isIamTransazioniManager() && risorseInGestioneTransazioni.containsKey(resource.getId())) {
                    risorseInGestioneTransazioni.remove(resource.getId());
                }
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante il rilascio di una risorsa: " + e.getMessage(), (Throwable)e);
        }
    }

    public void isAlive() throws CoreException {
        if (this.dbManagerRuntimePdD != null) {
            this.dbManagerRuntimePdD.isAlive();
        } else if (this.dbManagerTransazioni != null) {
            this.dbManagerTransazioni.isAlive();
        } else {
            Resource resource = null;
            Statement stmtTest = null;
            IDSoggetto idSoggettAlive = new IDSoggetto();
            idSoggettAlive.setCodicePorta(this.identita);
            idSoggettAlive.setTipo(this.identita);
            idSoggettAlive.setNome(this.identita);
            try {
                resource = this.getResource(idSoggettAlive, "CheckIsAlive", null);
                if (resource == null) {
                    throw new Exception("Resource is null");
                }
                if (resource.getResource() == null) {
                    throw new Exception("Connessione is null");
                }
                Connection con = (Connection)resource.getResource();
                stmtTest = con.createStatement();
                stmtTest.execute("SELECT * from db_info");
            }
            catch (Exception e) {
                throw new CoreException("Connessione al database 'GovWay' (" + this.identita + ") non disponibile: " + e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (stmtTest != null) {
                        stmtTest.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    this.releaseResource(idSoggettAlive, "CheckIsAlive", resource);
                }
                catch (Exception exception) {}
            }
        }
    }

    static {
        risorseInGestioneSmistatore = new ConcurrentHashMap();
        risorseInGestioneRuntime = new ConcurrentHashMap();
        risorseInGestioneTransazioni = new ConcurrentHashMap();
    }
}

