/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.IMonitoraggioRisorsa;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.DBManager;
import org.openspcoop2.pdd.config.DBTransazioniManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.Resource;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsAlreadyExistsException;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.datasource.DataSource;
import org.openspcoop2.utils.datasource.DataSourceFactory;
import org.openspcoop2.utils.datasource.DataSourceParams;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.resources.GestoreJNDI;
import org.slf4j.Logger;

public class DBStatisticheManager
implements IMonitoraggioRisorsa {
    private static final String ID_MODULO = "DBStatisticheManager";
    private static DBStatisticheManager staticInstanceDBStatisticheManager;
    private static ConcurrentHashMap<String, Resource> risorseInGestione;
    private String tipoDatabase;
    private Logger log;
    private DBManager dbManagerRuntimePdD;
    private DBTransazioniManager dbManagerTransazioni;
    private javax.sql.DataSource datasourceStatistiche;

    public static synchronized void init(DBManager dbManagerRuntimePdD, Logger alog, String tipoDatabase) {
        if (staticInstanceDBStatisticheManager == null) {
            staticInstanceDBStatisticheManager = new DBStatisticheManager(dbManagerRuntimePdD, alog, tipoDatabase);
        }
    }

    public static synchronized void init(DBTransazioniManager dbManagerTransazioni, Logger alog, String tipoDatabase) {
        if (staticInstanceDBStatisticheManager == null) {
            staticInstanceDBStatisticheManager = new DBStatisticheManager(dbManagerTransazioni, alog, tipoDatabase);
        }
    }

    public static synchronized void init(String nomeDataSource, Properties context, Logger alog, String tipoDatabase, boolean useOp2UtilsDatasource, boolean bindJMX) throws UtilsException {
        if (staticInstanceDBStatisticheManager == null) {
            staticInstanceDBStatisticheManager = new DBStatisticheManager(nomeDataSource, context, alog, tipoDatabase, useOp2UtilsDatasource, bindJMX);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DBStatisticheManager getInstance() {
        if (staticInstanceDBStatisticheManager != null) return staticInstanceDBStatisticheManager;
        Class<DBStatisticheManager> clazz = DBStatisticheManager.class;
        synchronized (DBStatisticheManager.class) {
            if (staticInstanceDBStatisticheManager != null) return staticInstanceDBStatisticheManager;
            // ** MonitorExit[var0] (shouldn't be in output)
            return null;
        }
    }

    public static String[] getStatoRisorse() {
        return DBManager.getStatoRisorse(risorseInGestione);
    }

    public String getTipoDatabase() {
        return this.tipoDatabase;
    }

    public boolean useRuntimePdD() {
        return this.dbManagerRuntimePdD != null;
    }

    public boolean useTransazioni() {
        return this.dbManagerTransazioni != null;
    }

    private DBStatisticheManager(DBManager dbManagerRuntimePdD, Logger alog, String tipoDatabase) {
        this.dbManagerRuntimePdD = dbManagerRuntimePdD;
        this.log = alog;
        this.tipoDatabase = tipoDatabase;
    }

    private DBStatisticheManager(DBTransazioniManager dbManagerTransazioni, Logger alog, String tipoDatabase) {
        this.dbManagerTransazioni = dbManagerTransazioni;
        this.log = alog;
        this.tipoDatabase = tipoDatabase;
    }

    private DBStatisticheManager(String nomeDataSource, Properties context, Logger alog, String tipoDatabase, boolean useOp2UtilsDatasource, boolean bindJMX) throws UtilsException {
        try {
            this.log = alog;
            this.tipoDatabase = tipoDatabase;
            if (useOp2UtilsDatasource) {
                DataSourceParams dsParams = Costanti.getDataSourceParamsPdD((boolean)bindJMX, (String)tipoDatabase);
                this.initDatasource(nomeDataSource, context, dsParams);
            } else {
                GestoreJNDI gestoreJNDI = new GestoreJNDI(context);
                this.datasourceStatistiche = (javax.sql.DataSource)gestoreJNDI.lookup(nomeDataSource);
            }
        }
        catch (Exception ne) {
            String msg = "Impossibile instanziare il manager: " + ne.getMessage();
            this.doError(msg, ne);
        }
    }

    private void initDatasource(String nomeDataSource, Properties context, DataSourceParams dsParams) throws UtilsException {
        block2: {
            try {
                this.datasourceStatistiche = DataSourceFactory.newInstance((String)nomeDataSource, (Properties)context, (DataSourceParams)dsParams);
            }
            catch (UtilsAlreadyExistsException exists) {
                this.datasourceStatistiche = DataSourceFactory.getInstance((String)nomeDataSource);
                if (this.datasourceStatistiche != null) break block2;
                throw new UtilsException("Lookup datasource non riuscita (" + exists.getMessage() + ")", (Throwable)exists);
            }
        }
    }

    private void doError(String msg, Exception e) throws UtilsException {
        this.log.error(msg, (Throwable)e);
        throw new UtilsException(msg, (Throwable)e);
    }

    public Resource getResource(IDSoggetto idPDD, String modulo, String idTransazione) throws UtilsException {
        return this.getResource(idPDD, modulo, idTransazione, true);
    }

    public Resource getResource(IDSoggetto idPDD, String modulo, String idTransazione, boolean logError) throws UtilsException {
        if (this.dbManagerRuntimePdD != null) {
            return this.dbManagerRuntimePdD.getResource(idPDD, modulo, idTransazione, logError);
        }
        if (this.dbManagerTransazioni != null) {
            return this.dbManagerTransazioni.getResource(idPDD, modulo, idTransazione, logError);
        }
        try {
            StringBuilder bf = new StringBuilder();
            if (idPDD != null) {
                bf.append(idPDD.toString());
                if (modulo != null) {
                    bf.append(".");
                }
            }
            if (modulo != null) {
                bf.append(modulo);
            }
            if (bf.length() <= 0) {
                bf.append(ID_MODULO);
            }
            Resource risorsa = DBManager.buildResource("DBStatisticsManager", this.getConnectionFromDatasource(bf.toString(), idTransazione), idPDD, modulo, idTransazione);
            risorseInGestione.put(risorsa.getId(), risorsa);
            return risorsa;
        }
        catch (Exception e) {
            String msg = "Errore durante l'ottenimento di una connessione: " + e.getMessage();
            this.doError(msg, e);
            throw new UtilsException(msg, (Throwable)e);
        }
    }

    private Connection getConnectionFromDatasource(String methodName, String idTransazione) throws SQLException {
        if (this.datasourceStatistiche instanceof DataSource) {
            return ((DataSource)this.datasourceStatistiche).getWrappedConnection(idTransazione, (Object)("DBStatisticheManager." + methodName));
        }
        return this.datasourceStatistiche.getConnection();
    }

    public void releaseResource(IDSoggetto idPDD, String modulo, Resource resource) {
        this.releaseResource(idPDD, modulo, resource, true);
    }

    public void releaseResource(IDSoggetto idPDD, String modulo, Resource resource, boolean logError) {
        try {
            if (this.dbManagerRuntimePdD != null) {
                this.dbManagerRuntimePdD.releaseResource(idPDD, modulo, resource, logError);
            } else if (this.dbManagerTransazioni != null) {
                this.dbManagerTransazioni.releaseResource(idPDD, modulo, resource, logError);
            } else {
                this.releaseConnection(resource);
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante il rilascio di una risorsa: " + e.getMessage(), (Throwable)e);
        }
    }

    private void releaseConnection(Resource resource) throws SQLException {
        if (resource != null) {
            if (resource.getResource() != null) {
                Connection connectionDB = (Connection)resource.getResource();
                Logger logResource = OpenSPCoop2Logger.getLoggerOpenSPCoopResources() != null ? OpenSPCoop2Logger.getLoggerOpenSPCoopResources() : LoggerWrapperFactory.getLogger(DBStatisticheManager.class);
                boolean checkAutocommit = OpenSPCoop2Properties.getInstance() == null || OpenSPCoop2Properties.getInstance().isJdbcCloseConnectionCheckAutocommit();
                boolean checkIsClosed = OpenSPCoop2Properties.getInstance() == null || OpenSPCoop2Properties.getInstance().isJdbcCloseConnectionCheckIsClosed();
                JDBCUtilities.closeConnection((Logger)logResource, (Connection)connectionDB, (boolean)checkAutocommit, (boolean)checkIsClosed);
            }
            if (risorseInGestione.containsKey(resource.getId())) {
                risorseInGestione.remove(resource.getId());
            }
        }
    }

    public void isAlive() throws CoreException {
        if (this.dbManagerRuntimePdD != null) {
            this.dbManagerRuntimePdD.isAlive();
        } else if (this.dbManagerTransazioni != null) {
            this.dbManagerTransazioni.isAlive();
        } else {
            Resource resource = null;
            Statement stmtTest = null;
            IDSoggetto idSoggettAlive = new IDSoggetto();
            idSoggettAlive.setCodicePorta(ID_MODULO);
            idSoggettAlive.setTipo(ID_MODULO);
            idSoggettAlive.setNome(ID_MODULO);
            try {
                resource = this.getResource(idSoggettAlive);
                Connection con = (Connection)resource.getResource();
                stmtTest = con.createStatement();
                stmtTest.execute("SELECT * from db_info");
            }
            catch (Exception e) {
                throw new CoreException("Connessione al database 'GovWay - Statistiche' non disponibile: " + e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (stmtTest != null) {
                        stmtTest.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    this.releaseResource(idSoggettAlive, "CheckIsAlive", resource);
                }
                catch (Exception exception) {}
            }
        }
    }

    private Resource getResource(IDSoggetto idSoggettAlive) throws UtilsException {
        Resource resource = null;
        try {
            resource = this.getResource(idSoggettAlive, "CheckIsAlive", null);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
        if (resource == null) {
            throw new UtilsException("Resource is null");
        }
        if (resource.getResource() == null) {
            throw new UtilsException("Connessione is null");
        }
        return resource;
    }

    static {
        risorseInGestione = new ConcurrentHashMap();
    }
}

