/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.pdd.config.ConfigurazionePdDReader;
import org.openspcoop2.pdd.config.DigestServiceParams;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.digest.DigestType;
import org.openspcoop2.utils.id.serial.InfoStatistics;
import org.openspcoop2.utils.semaphore.Semaphore;
import org.openspcoop2.utils.semaphore.SemaphoreConfiguration;
import org.openspcoop2.utils.semaphore.SemaphoreMapping;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.sql.SQLQueryObjectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigestServiceParamsDriver {
    private static final String DB_LOCK_ID = "ServiziDigestParamsUpdate";
    private static final org.openspcoop2.utils.Semaphore THREAD_LOCK = new org.openspcoop2.utils.Semaphore("DigestServiceParamsDriver-threadLock");
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private DriverConfigurazioneDB driverConfigurazioneDB;
    private Semaphore semaphore;
    private SemaphoreLock lock;

    private String getKey(IDServizio idServizio, Long serialNumber) {
        return "DigestServiceParams" + idServizio.toString() + "-" + serialNumber;
    }

    private Long getIdServizio(Connection conn, String tipoDB, IDServizio idServizio) throws SQLQueryObjectException, SQLException {
        ResultSet rs;
        int index;
        ISQLQueryObject query = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
        query.addFromTable("soggetti");
        query.addSelectField("id");
        query.setANDLogicOperator(true);
        query.addWhereCondition("nome_soggetto= ?");
        query.addWhereCondition("tipo_soggetto= ?");
        Long idSoggetto = null;
        try (PreparedStatement stmt = conn.prepareStatement(query.createSQLQuery());){
            index = 1;
            stmt.setString(index++, idServizio.getSoggettoErogatore().getNome());
            stmt.setString(index++, idServizio.getSoggettoErogatore().getTipo());
            rs = stmt.executeQuery();
            try {
                if (rs.next()) {
                    idSoggetto = rs.getLong("id");
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        if (idSoggetto == null) {
            return null;
        }
        query = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
        query.addFromTable("servizi");
        query.addSelectField("id");
        query.setANDLogicOperator(true);
        query.addWhereCondition("nome_servizio= ?");
        query.addWhereCondition("tipo_servizio= ?");
        query.addWhereCondition("versione_servizio= ?");
        query.addWhereCondition("id_soggetto= ?");
        stmt = conn.prepareStatement(query.createSQLQuery());
        try {
            index = 1;
            stmt.setString(index++, idServizio.getNome());
            stmt.setString(index++, idServizio.getTipo());
            stmt.setInt(index++, idServizio.getVersione());
            stmt.setLong(index++, idSoggetto);
            rs = stmt.executeQuery();
            try {
                if (rs.next()) {
                    Long l = rs.getLong("id");
                    return l;
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        return null;
    }

    private DigestServiceParams paramsFromResultSet(IDServizio idServizio, ResultSet rs) throws SQLException {
        DigestServiceParams params = new DigestServiceParams();
        params.setIdServizio(idServizio);
        params.setSerialNumber(rs.getLong("serial_number"));
        params.setDataRegistrazione(rs.getTimestamp("data_registrazione").toInstant());
        params.setDurata(rs.getInt("lifetime"));
        params.setSeed(rs.getString("seed").getBytes());
        params.setDigestAlgorithm(DigestType.valueOf((String)rs.getString("algorithm")));
        return params;
    }

    public DigestServiceParamsDriver(DriverConfigurazioneDB driverConfigurazioneDB) {
        this.driverConfigurazioneDB = driverConfigurazioneDB;
    }

    public boolean removeEntries(IDServizio idServizio) throws DriverConfigurazioneException {
        Connection conn = null;
        String tipoDB = this.driverConfigurazioneDB.getTipoDB();
        try {
            conn = this.driverConfigurazioneDB.getConnection("removeEntries");
            Long idServizioRef = this.getIdServizio(conn, tipoDB, idServizio);
            if (idServizioRef == null) {
                boolean bl = false;
                return bl;
            }
            ISQLQueryObject query = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            query.addDeleteTable("servizi_digest_params");
            query.addWhereCondition("id_servizio= ?");
            try (PreparedStatement stmt = conn.prepareStatement(query.createSQLDelete());){
                stmt.setLong(1, idServizioRef);
                stmt.execute();
            }
        }
        catch (SQLException | SQLQueryObjectException e) {
            throw new DriverConfigurazioneException("Errore nella rimozione di un record di tipo DigestServiceParam", e);
        }
        finally {
            this.driverConfigurazioneDB.closeConnection(conn);
        }
        return true;
    }

    public boolean removeOldEntries(IDServizio idServizio, int n) throws DriverConfigurazioneException {
        Connection conn = null;
        String tipoDB = this.driverConfigurazioneDB.getTipoDB();
        try {
            conn = this.driverConfigurazioneDB.getConnection("removeEntries");
            Long idServizioRef = this.getIdServizio(conn, tipoDB, idServizio);
            if (idServizioRef == null) {
                boolean bl = false;
                return bl;
            }
            Timestamp lastQuery = null;
            ISQLQueryObject query = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            query.addFromTable("servizi_digest_params");
            query.addSelectField("data_registrazione");
            query.addWhereCondition("id_servizio= ?");
            query.addOrderBy("data_registrazione", false);
            query.setANDLogicOperator(true);
            query.setLimit(1);
            query.setOffset(n);
            try (PreparedStatement stmt = conn.prepareStatement(query.createSQLQuery());){
                stmt.setLong(1, idServizioRef);
                try (ResultSet rs = stmt.executeQuery();){
                    if (rs.next()) {
                        lastQuery = rs.getTimestamp("data_registrazione");
                    }
                }
            }
            if (lastQuery == null) {
                boolean stmt = true;
                return stmt;
            }
            query = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            query.addDeleteTable("servizi_digest_params");
            query.setANDLogicOperator(true);
            query.addWhereCondition("id_servizio= ?");
            query.addWhereCondition("data_registrazione<= ?");
            stmt = conn.prepareStatement(query.createSQLDelete());
            try {
                int index = 1;
                stmt.setLong(index++, idServizioRef);
                stmt.setTimestamp(index++, lastQuery);
                stmt.execute();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException | SQLQueryObjectException e) {
            throw new DriverConfigurazioneException("Errore nell'aggiunta di un record di tipo DigestServiceParam", e);
        }
        finally {
            this.driverConfigurazioneDB.closeConnection(conn);
        }
        return true;
    }

    public boolean addNewEntry(DigestServiceParams params) throws DriverConfigurazioneException {
        Connection conn = null;
        String tipoDB = this.driverConfigurazioneDB.getTipoDB();
        try {
            conn = this.driverConfigurazioneDB.getConnection("addEntry");
            Long idServizioRef = this.getIdServizio(conn, tipoDB, params.getIdServizio());
            if (idServizioRef == null) {
                boolean bl = false;
                return bl;
            }
            ISQLQueryObject query = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            query.addInsertTable("servizi_digest_params");
            if (params.getSerialNumber() != null) {
                query.addInsertField("serial_number", "?");
            }
            query.addInsertField("algorithm", "?");
            query.addInsertField("data_registrazione", "?");
            query.addInsertField("id_servizio", "?");
            query.addInsertField("lifetime", "?");
            query.addInsertField("seed", "?");
            try (PreparedStatement stmt = conn.prepareStatement(query.createSQLInsert());){
                int index = 1;
                if (params.getSerialNumber() != null) {
                    stmt.setLong(index++, params.getSerialNumber());
                }
                stmt.setString(index++, params.getDigestAlgorithm().toString());
                stmt.setTimestamp(index++, Timestamp.from(params.getDataRegistrazione()));
                stmt.setLong(index++, idServizioRef);
                stmt.setInt(index++, params.getDurata());
                stmt.setString(index++, new String(params.getSeed()));
                stmt.execute();
            }
        }
        catch (SQLException | SQLQueryObjectException e) {
            throw new DriverConfigurazioneException(e);
        }
        finally {
            this.driverConfigurazioneDB.closeConnection(conn);
        }
        try {
            ConfigurazionePdDReader.getCache().put(this.getKey(params.getIdServizio(), null), (Serializable)params);
        }
        catch (UtilsException e) {
            this.logger.warn("Errore nell'aggiunta di un valore in cache", (Throwable)e);
        }
        return true;
    }

    public boolean isValid(DigestServiceParams param) {
        if (param == null) {
            return false;
        }
        Instant now = Instant.now();
        Instant expiration = param.getDataRegistrazione().plus(Duration.ofDays(param.getDurata().intValue()));
        return now.isBefore(expiration);
    }

    public DigestServiceParams getValidEntry(IDServizio idServizio) throws DriverConfigurazioneException {
        DigestServiceParams param = this.getLastEntry(idServizio);
        if (this.isValid(param)) {
            return param;
        }
        return null;
    }

    public DigestServiceParams getLastEntry(IDServizio idServizio) throws DriverConfigurazioneException {
        return this.getEntry(idServizio, null);
    }

    public DigestServiceParams getEntry(IDServizio idServizio, Long serialNumber) throws DriverConfigurazioneException {
        DigestServiceParams param;
        String tipoDB;
        Connection conn;
        block24: {
            conn = null;
            tipoDB = this.driverConfigurazioneDB.getTipoDB();
            param = null;
            param = (DigestServiceParams)ConfigurazionePdDReader.getRawObjectCache(this.getKey(idServizio, serialNumber));
            if (param == null || serialNumber == null && !this.isValid(param)) break block24;
            DigestServiceParams digestServiceParams = param;
            this.driverConfigurazioneDB.closeConnection(conn);
            return digestServiceParams;
        }
        try {
            conn = this.driverConfigurazioneDB.getConnection("getEntry");
            Long idServizioRef = this.getIdServizio(conn, tipoDB, idServizio);
            if (idServizioRef == null) {
                throw new DriverConfigurazioneException("idServizio riferito non presente nella tabella servizio");
            }
            ISQLQueryObject query = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            query.addFromTable("servizi_digest_params");
            query.setANDLogicOperator(true);
            query.addWhereCondition("id_servizio= ?");
            if (serialNumber != null) {
                query.addWhereCondition("serial_number= ?");
            }
            query.addOrderBy("data_registrazione", false);
            query.setLimit(1);
            try (PreparedStatement stmt = conn.prepareStatement(query.createSQLQuery());){
                int index = 1;
                stmt.setLong(index++, idServizioRef);
                if (serialNumber != null) {
                    stmt.setLong(index++, serialNumber);
                }
                stmt.execute();
                try (ResultSet rs = stmt.executeQuery();){
                    if (rs.next()) {
                        param = this.paramsFromResultSet(idServizio, rs);
                    }
                }
            }
        }
        catch (SQLException | SQLQueryObjectException e) {
            try {
                throw new DriverConfigurazioneException("Errore nella get del DigestServiceParam", e);
            }
            catch (Throwable throwable) {
                this.driverConfigurazioneDB.closeConnection(conn);
                throw throwable;
            }
        }
        this.driverConfigurazioneDB.closeConnection(conn);
        try {
            if (param != null && (serialNumber != null || this.isValid(param))) {
                ConfigurazionePdDReader.getCache().put(this.getKey(idServizio, serialNumber), (Serializable)param);
            }
        }
        catch (UtilsException e) {
            this.logger.warn("Errore nell'aggiunta di un valore in cache", (Throwable)e);
        }
        return param;
    }

    private Semaphore getSemaphore() throws UtilsException {
        if (this.semaphore == null) {
            InfoStatistics semaphoreStatistics = new InfoStatistics();
            SemaphoreConfiguration config = GestoreMessaggi.newSemaphoreConfiguration(1000L, 1000L);
            this.semaphore = new Semaphore(semaphoreStatistics, SemaphoreMapping.newInstance((String)DB_LOCK_ID), config, TipiDatabase.toEnumConstant((String)this.driverConfigurazioneDB.getTipoDB()), DriverConfigurazioneDB.getCheckLogger());
        }
        return this.semaphore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireLock(String idTransazione) throws UtilsException, DriverConfigurazioneException {
        Connection con = null;
        try {
            con = this.driverConfigurazioneDB.getConnection("acquireLockDigestService");
            while (!this.getSemaphore().newLock(con, "acquireLockDigestService")) {
                Utilities.sleep((long)1L);
            }
            this.lock = THREAD_LOCK.acquire("acquireLock", idTransazione);
        }
        catch (DriverConfigurazioneException | UtilsException e) {
            this.releaseLock();
        }
        finally {
            this.driverConfigurazioneDB.releaseConnection(con);
        }
    }

    public void releaseLock() throws UtilsException, DriverConfigurazioneException {
        Connection con = null;
        try {
            THREAD_LOCK.release(this.lock, "acquireLock");
            con = this.driverConfigurazioneDB.getConnection("releaseLockDigestService");
            this.getSemaphore().releaseLock(con, "releaseLockDigestService");
        }
        catch (Throwable throwable) {
            this.driverConfigurazioneDB.releaseConnection(con);
            throw throwable;
        }
        this.driverConfigurazioneDB.releaseConnection(con);
    }
}

