/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.generic_project.exception.DeserializerException;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2MessageParseResult;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.context.MessageContext;
import org.openspcoop2.message.context.SerializedContext;
import org.openspcoop2.message.context.SerializedParameter;
import org.openspcoop2.message.context.utils.serializer.JaxbDeserializer;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.SavedMessageContext;
import org.openspcoop2.pdd.core.SavedMessagePSUtilities;
import org.openspcoop2.pdd.core.state.IOpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.RequestInfoConfigUtilities;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.beans.WriteToSerializerType;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;
import org.openspcoop2.utils.jdbc.IJDBCAdapter;
import org.openspcoop2.utils.serialization.JavaDeserializer;
import org.slf4j.Logger;

public class SavedMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient Logger internalLog = null;
    public static final String REST_CONTENT_TYPE_EMPTY = "____EMPTY____";
    private static final String MSG_BYTES = "_bytes.bin";
    private static final String MSG_CONTEXT = "_context.bin";
    private static final String MSG_RESPONSE_BYTES = "_response_bytes.bin";
    private static final String MSG_RESPONSE_CONTEXT = "_response_context.bin";
    private static final String MSG_TRANSACTION_CONTEXT = "_transaction_context.bin";
    protected String idMessaggio;
    protected String box;
    protected boolean saveOnFS;
    protected String keyMsgBytes;
    protected String keyMsgContext;
    protected String keyMsgResponseBytes;
    protected String keyMsgResponseContext;
    protected String keyMsgTransactionContext;
    private String workDir;
    protected transient IJDBCAdapter adapter;
    protected transient IOpenSPCoopState openspcoopstate;
    private transient OpenSPCoop2Properties openspcoopProperties = OpenSPCoop2Properties.getInstance();

    private synchronized void initLog() {
        if (this.internalLog == null) {
            this.internalLog = LoggerWrapperFactory.getLogger(SavedMessage.class);
        }
    }

    protected Logger getLog() {
        if (this.internalLog == null) {
            this.initLog();
        }
        return this.internalLog;
    }

    public SavedMessage(String idMsg, IOpenSPCoopState openspcoopstate, String box, String workDir, Logger alog) throws UtilsException {
        this(idMsg, openspcoopstate, box, workDir, null, alog);
    }

    public SavedMessage(String idMsg, IOpenSPCoopState openspcoopstate, String box, IJDBCAdapter adapterJDBC, Logger alog) throws UtilsException {
        this(idMsg, openspcoopstate, box, null, adapterJDBC, alog);
    }

    public SavedMessage(String idMsg, IOpenSPCoopState openspcoopstate, String box, String workDir, IJDBCAdapter adapterJDBC, Logger alog) throws UtilsException {
        this.idMessaggio = idMsg;
        this.box = box;
        this.openspcoopstate = openspcoopstate;
        this.internalLog = alog != null ? alog : LoggerWrapperFactory.getLogger(SavedMessage.class);
        try {
            String hashKey = this.hash(idMsg);
            if (hashKey == null) {
                throw new UtilsException("Codifica hash non riuscita: keyMsgBytes is null");
            }
            this.keyMsgBytes = hashKey + MSG_BYTES;
            this.keyMsgResponseBytes = hashKey + MSG_RESPONSE_BYTES;
            this.keyMsgContext = hashKey + MSG_CONTEXT;
            this.keyMsgResponseContext = hashKey + MSG_RESPONSE_CONTEXT;
            this.keyMsgTransactionContext = hashKey + MSG_TRANSACTION_CONTEXT;
        }
        catch (Exception e) {
            String errorMsg = "SOAP_MESSAGE, costructor error (CodificaHash): " + box + "/" + idMsg + ": " + e.getMessage();
            this.getLog().error(errorMsg);
            throw new UtilsException(errorMsg, (Throwable)e);
        }
        if (adapterJDBC == null) {
            this.saveOnFS = true;
            this.workDir = workDir;
        } else {
            this.saveOnFS = false;
            this.adapter = adapterJDBC;
        }
    }

    private String hash(String key) throws UtilsException {
        try {
            StringBuilder returnKey = new StringBuilder();
            for (int i = 0; i < key.length(); ++i) {
                if (key.charAt(i) == '_' || key.charAt(i) == '-' || key.charAt(i) == '.' || key.charAt(i) == ':') continue;
                returnKey.append(key.charAt(i));
            }
            return returnKey.toString();
        }
        catch (Exception e) {
            throw new UtilsException("Utilities.hash error " + e.getMessage(), (Throwable)e);
        }
    }

    public String getBaseDir() throws UtilsException {
        String prefix = "SOAP_MESSAGE, getBaseDir: " + this.box + "/" + this.idMessaggio;
        File dir = new File(this.workDir);
        if (!dir.exists()) {
            String errorMsg = prefix + ": directory di lavoro inesistente (" + this.workDir + ").";
            this.getLog().error(errorMsg);
            throw new UtilsException(errorMsg);
        }
        Object baseDir = this.workDir;
        if (!((String)baseDir).endsWith(File.separator)) {
            baseDir = (String)baseDir + File.separator;
        }
        if ("INBOX".equals(this.box)) {
            baseDir = (String)baseDir + "INBOX";
        } else if ("OUTBOX".equals(this.box)) {
            baseDir = (String)baseDir + "OUTBOX";
        } else {
            String errorMsg = prefix + ": box non valido? .";
            this.getLog().error(errorMsg);
            throw new UtilsException(errorMsg);
        }
        File dirINOUT = new File((String)baseDir);
        if (!dirINOUT.exists() && !dirINOUT.mkdir()) {
            String errorMsg = prefix + ": directory di lavoro (" + this.workDir + ") non permette la creazione di sottodirectory INBOX/OUTBOX.";
            this.getLog().error(errorMsg);
            throw new UtilsException(errorMsg);
        }
        return (String)baseDir + File.separator;
    }

    public String getIdMessaggio() {
        return this.idMessaggio;
    }

    public void updateState(IOpenSPCoopState openspcoopstate) {
        this.openspcoopstate = openspcoopstate;
    }

    protected void checkInizializzazioneWorkingDir(String saveDir) throws UtilsException {
        if (saveDir == null) {
            String errorMsg = "WorkDir non correttamente inizializzata";
            throw new UtilsException(errorMsg);
        }
    }

    protected void checkInizializzazioneAdapter() throws UtilsException {
        if (this.adapter == null) {
            throw new UtilsException("Adapter unavailable");
        }
    }

    protected void logError(String errorMsg, Exception e) {
        this.getLog().error(errorMsg, (Throwable)e);
    }

    public void save(OpenSPCoop2Message msg, boolean isRichiesta, boolean portaDiTipoStateless, boolean consumeMessage, Timestamp oraRegistrazione) throws UtilsException {
        SavedMessagePSUtilities.save(this, msg, isRichiesta, portaDiTipoStateless, consumeMessage, oraRegistrazione);
    }

    protected void saveMessageBytes(String path, OpenSPCoop2Message msg, boolean consumeMessage, boolean overwrite) throws UtilsException {
        FileOutputStream fos = null;
        try {
            File fileMsg = new File(path);
            if (fileMsg.exists()) {
                if (overwrite) {
                    this.deleteMessageFile(fileMsg);
                } else {
                    throw new UtilsException("L'identificativo del Messaggio risulta gi\u00e0 registrato: " + path);
                }
            }
            fos = new FileOutputStream(path);
            msg.writeTo((OutputStream)fos, consumeMessage);
            fos.close();
        }
        catch (Exception e) {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new UtilsException("Utilities.saveMessage error " + e.getMessage(), (Throwable)e);
        }
    }

    protected void saveMessageContext(String path, OpenSPCoop2Message msg, boolean overwrite) throws UtilsException {
        FileOutputStream fos = null;
        try {
            File fileMsg = new File(path);
            if (fileMsg.exists()) {
                if (overwrite) {
                    this.deleteMessageFile(fileMsg);
                } else {
                    throw new UtilsException("L'identificativo del Messaggio risulta gia' registrato: " + path);
                }
            }
            fos = new FileOutputStream(path);
            msg.serializeResourcesTo((OutputStream)fos);
            fos.close();
        }
        catch (Exception e) {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new UtilsException("Utilities.saveMessageContext error " + e.getMessage(), (Throwable)e);
        }
    }

    protected void saveTransactionContext(String path, SerializedContext sc, boolean overwrite) throws UtilsException {
        FileOutputStream fos = null;
        try {
            File fileMsg = new File(path);
            if (fileMsg.exists()) {
                if (overwrite) {
                    this.deleteMessageFile(fileMsg);
                } else {
                    throw new UtilsException("L'identificativo del Messaggio risulta gia' registrato: " + path);
                }
            }
            fos = new FileOutputStream(path);
            sc.writeTo((OutputStream)fos, WriteToSerializerType.XML_JAXB);
            fos.close();
        }
        catch (Exception e) {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new UtilsException("Utilities.saveTransactionContext error " + e.getMessage(), (Throwable)e);
        }
    }

    public void updateResponse(OpenSPCoop2Message msg, boolean consumeMessage) throws UtilsException {
        SavedMessagePSUtilities.updateResponse(this, msg, consumeMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTransactionContext(Context transactionContext) throws UtilsException {
        RequestInfo requestInfoBackup = null;
        Map dynamicContext = null;
        try {
            if (transactionContext != null) {
                requestInfoBackup = RequestInfoConfigUtilities.normalizeRequestInfoBeforeSerialization((Context)transactionContext);
                dynamicContext = Costanti.removeDynamicMap((org.openspcoop2.utils.Map)transactionContext);
            }
            SavedMessagePSUtilities.updateTransactionContext(this, transactionContext);
        }
        finally {
            if (requestInfoBackup != null) {
                RequestInfoConfigUtilities.restoreRequestInfoAfterSerialization((Context)transactionContext, (RequestInfo)requestInfoBackup);
            }
            if (dynamicContext != null) {
                transactionContext.put(Costanti.DYNAMIC_MAP_CONTEXT, (Object)dynamicContext);
            }
        }
    }

    private void deleteMessageFile(File fileMsg) throws UtilsException {
        try {
            Files.delete(fileMsg.toPath());
        }
        catch (Exception e) {
            throw new UtilsException("L'identificativo del Messaggio risulta gi\u00e0 registrato e non eliminabile (" + fileMsg.getAbsolutePath() + "): " + e.getMessage(), (Throwable)e);
        }
    }

    public OpenSPCoop2Message read(boolean isRichiesta, boolean portaDiTipoStateless, Date oraRegistrazione) throws UtilsException {
        return this.readEngine(isRichiesta, portaDiTipoStateless, oraRegistrazione, false, true, null);
    }

    public OpenSPCoop2Message readResponse(Date oraRegistrazione, boolean throwExceptionIfNotExists) throws UtilsException {
        return this.readEngine(false, false, oraRegistrazione, true, throwExceptionIfNotExists, null);
    }

    public Context readTransactionContext(Date oraRegistrazione) throws UtilsException {
        Context c = new Context();
        this.readEngine(false, false, oraRegistrazione, false, true, c);
        return c;
    }

    private OpenSPCoop2Message readEngine(boolean isRichiesta, boolean portaDiTipoStateless, Date oraRegistrazione, boolean readResponseField, boolean throwExceptionIfNotExists, Context readTransactionContext) throws UtilsException {
        if (!portaDiTipoStateless) {
            Connection connectionDB = isRichiesta ? ((StateMessage)this.openspcoopstate.getStatoRichiesta()).getConnectionDB() : ((StateMessage)this.openspcoopstate.getStatoRisposta()).getConnectionDB();
            return this.readMessage(oraRegistrazione, readResponseField, throwExceptionIfNotExists, readTransactionContext, connectionDB);
        }
        if (isRichiesta) {
            return ((OpenSPCoopStateless)this.openspcoopstate).getRichiestaMsg();
        }
        return ((OpenSPCoopStateless)this.openspcoopstate).getRispostaMsg();
    }

    private OpenSPCoop2Message readMessage(Date oraRegistrazione, boolean readResponseField, boolean throwExceptionIfNotExists, Context readTransactionContext, Connection connectionDB) throws UtilsException {
        if (readTransactionContext != null && this.saveOnFS) {
            this.fillTransactionContextFromFileSystem(readTransactionContext, true);
            return null;
        }
        OpenSPCoop2Message msg = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String sql = this.buildReadStatement(oraRegistrazione, readResponseField, readTransactionContext);
            pstmt = connectionDB.prepareStatement(sql);
            this.initPreparedStatement(oraRegistrazione, pstmt);
            rs = pstmt.executeQuery();
            msg = this.readMessage(rs, readResponseField, throwExceptionIfNotExists, readTransactionContext);
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errorMsg = "SOAP_MESSAGE, read: " + this.box + "/" + this.idMessaggio + ": " + e.getMessage();
            this.logError(errorMsg, e);
            throw new UtilsException(errorMsg, (Throwable)e);
        }
        return msg;
    }

    private void fillTransactionContextFromFileSystem(Context readTransactionContext, boolean throwExceptionIfNotExists) throws UtilsException {
        String saveDir = this.getBaseDir();
        this.checkInizializzazioneWorkingDir(saveDir);
        InputStream isContext = null;
        try {
            isContext = this.readTransactionContextBytes(saveDir, throwExceptionIfNotExists, null);
            if (isContext != null) {
                this.fillTransactionContext(readTransactionContext, isContext);
            }
        }
        catch (Exception e) {
            try {
                if (isContext != null) {
                    isContext.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    private String buildReadStatement(Date oraRegistrazione, boolean readResponseField, Context readTransactionContext) {
        StringBuilder query = new StringBuilder();
        if (readTransactionContext != null) {
            query.append("select TRANSACTION_CONTEXT ");
        } else {
            String columnMsgContext;
            String columnContentType = readResponseField ? "RESPONSE_CONTENT_TYPE" : "CONTENT_TYPE";
            String columnMsgBytes = readResponseField ? "RESPONSE_MSG_BYTES" : "MSG_BYTES";
            String string = columnMsgContext = readResponseField ? "RESPONSE_MSG_CONTEXT" : "MSG_CONTEXT";
            if (this.saveOnFS) {
                query.append("select " + columnContentType + " ");
            } else {
                query.append("select " + columnContentType + "," + columnMsgBytes + "," + columnMsgContext + " ");
            }
        }
        query.append("from ");
        query.append("DEFINIZIONE_MESSAGGI");
        query.append(" WHERE ");
        if (oraRegistrazione != null) {
            query.append("(ORA_REGISTRAZIONE BETWEEN ? AND ?) AND ");
        }
        query.append("ID_MESSAGGIO = ? AND TIPO = ?");
        return query.toString();
    }

    private void initPreparedStatement(Date oraRegistrazione, PreparedStatement pstmt) throws SQLException {
        int index = 1;
        Timestamp leftValue = null;
        Timestamp rightValue = null;
        if (oraRegistrazione != null) {
            leftValue = new Timestamp(oraRegistrazione.getTime() - 300000L);
            rightValue = new Timestamp(oraRegistrazione.getTime() + 300000L);
            pstmt.setTimestamp(index++, leftValue);
            pstmt.setTimestamp(index++, rightValue);
        }
        pstmt.setString(index++, this.idMessaggio);
        if ("INBOX".equals(this.box)) {
            pstmt.setString(index, "INBOX");
        } else {
            pstmt.setString(index, "OUTBOX");
        }
    }

    private InputStream readMessageBytes(String contentType, String saveDir, boolean readResponseField, ResultSet rs) throws UtilsException, FileNotFoundException, SQLException {
        if (contentType != null && !"".equals(contentType)) {
            if (this.saveOnFS) {
                String pathBytes = saveDir + (readResponseField ? this.keyMsgResponseBytes : this.keyMsgBytes);
                File fileCheckBytes = new File(pathBytes);
                if (!fileCheckBytes.exists()) {
                    String errorMsg = "Il messaggio non risulta gia' registrato (" + pathBytes + ").";
                    throw new UtilsException(errorMsg);
                }
                return new FileInputStream(pathBytes);
            }
            this.checkInizializzazioneAdapter();
            return new ByteArrayInputStream(this.adapter.getBinaryData(rs, 2));
        }
        return null;
    }

    private InputStream readBytesCheckNullable(String tipo, File fileCheckContext, boolean throwExceptionIfNotExists) throws UtilsException, FileNotFoundException {
        if (!fileCheckContext.exists()) {
            if (throwExceptionIfNotExists) {
                String errorMsg = "Il messaggio (" + tipo + ") non risulta gia' registrato (" + fileCheckContext.getAbsolutePath() + ").";
                throw new UtilsException(errorMsg);
            }
            return null;
        }
        return new FileInputStream(fileCheckContext);
    }

    private InputStream readBytesCheckNullable(String tipo, byte[] content, boolean throwExceptionIfNotExists) throws UtilsException {
        if (content == null) {
            if (throwExceptionIfNotExists) {
                String errorMsg = "Il messaggio (" + tipo + ") non risulta gia' registrato.";
                throw new UtilsException(errorMsg);
            }
            return null;
        }
        return new ByteArrayInputStream(content);
    }

    private InputStream readContextBytes(String saveDir, boolean readResponseField, boolean throwExceptionIfNotExists, ResultSet rs) throws UtilsException, FileNotFoundException, SQLException {
        if (this.saveOnFS) {
            String pathContext = saveDir + (readResponseField ? this.keyMsgResponseContext : this.keyMsgContext);
            File fileCheckContext = new File(pathContext);
            return this.readBytesCheckNullable("context", fileCheckContext, throwExceptionIfNotExists);
        }
        this.checkInizializzazioneAdapter();
        byte[] content = this.adapter.getBinaryData(rs, 3);
        return this.readBytesCheckNullable("context", content, throwExceptionIfNotExists);
    }

    private InputStream readTransactionContextBytes(String saveDir, boolean throwExceptionIfNotExists, ResultSet rs) throws UtilsException, FileNotFoundException, SQLException {
        if (this.saveOnFS) {
            String pathContext = saveDir + this.keyMsgTransactionContext;
            File fileCheckContext = new File(pathContext);
            return this.readBytesCheckNullable("transaction context", fileCheckContext, throwExceptionIfNotExists);
        }
        this.checkInizializzazioneAdapter();
        byte[] content = this.adapter.getBinaryData(rs, 1);
        return this.readBytesCheckNullable("transaction context", content, throwExceptionIfNotExists);
    }

    private OpenSPCoop2Message readMessage(ResultSet rs, boolean readResponseField, boolean throwExceptionIfNotExists, Context readTransactionContext) throws UtilsException, SQLException {
        if (rs == null) {
            String errorMsg = "ResultSet is null?";
            throw new UtilsException(errorMsg);
        }
        if (!rs.next()) {
            String errorMsg = "Messaggio non esistente";
            throw new UtilsException(errorMsg);
        }
        OpenSPCoop2Message msg = null;
        if (readTransactionContext != null) {
            this.fillTransactionContext(rs, readTransactionContext, true);
        } else {
            msg = this.readMessage(rs, readResponseField, throwExceptionIfNotExists);
        }
        return msg;
    }

    private void fillTransactionContext(ResultSet rs, Context readTransactionContext, boolean throwExceptionIfNotExists) throws UtilsException {
        InputStream isContext = null;
        try {
            isContext = this.readTransactionContextBytes(null, throwExceptionIfNotExists, rs);
            if (isContext != null) {
                this.fillTransactionContext(readTransactionContext, isContext);
            }
        }
        catch (Exception e) {
            try {
                if (isContext != null) {
                    isContext.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    private OpenSPCoop2Message readMessage(ResultSet rs, boolean readResponseField, boolean throwExceptionIfNotExists) throws UtilsException, SQLException {
        String saveDir = null;
        if (this.saveOnFS) {
            saveDir = this.getBaseDir();
            this.checkInizializzazioneWorkingDir(saveDir);
        }
        InputStream isBytes = null;
        InputStream isContext = null;
        try {
            isContext = this.readContextBytes(saveDir, readResponseField, throwExceptionIfNotExists, rs);
            if (isContext == null) {
                return null;
            }
            String columnContentType = readResponseField ? "RESPONSE_CONTENT_TYPE" : "CONTENT_TYPE";
            String contentType = rs.getString(columnContentType);
            SavedMessageContext smc = this.buildMessageContext(contentType, isContext);
            contentType = smc.contentTypeNormalized;
            isBytes = this.readMessageBytes(contentType, saveDir, readResponseField, rs);
            return this.buildMessage(smc, contentType, isBytes);
        }
        catch (Exception e) {
            try {
                if (isBytes != null) {
                    isBytes.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (isContext != null) {
                    isContext.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    private SavedMessageContext buildMessageContext(String contentType, InputStream isContext) throws UtilsException, DeserializerException {
        JaxbDeserializer jaxbDeserializer = new JaxbDeserializer();
        MessageContext msgContext = jaxbDeserializer.readMessageContext(isContext);
        if (msgContext.getMessageType() == null) {
            throw new UtilsException("Message Type undefined in context serialized");
        }
        MessageType mt = MessageType.valueOf((String)msgContext.getMessageType());
        if (mt == null) {
            throw new UtilsException("MessageType [" + msgContext.getMessageType() + "] unknown");
        }
        if (msgContext.getMessageRole() == null) {
            throw new UtilsException("Message Role undefined in context serialized");
        }
        MessageRole mr = MessageRole.valueOf((String)msgContext.getMessageRole());
        if (mr == null) {
            throw new UtilsException("MessageRole [" + msgContext.getMessageRole() + "] unknown");
        }
        if (MessageType.BINARY.equals((Object)mt) && REST_CONTENT_TYPE_EMPTY.equals(contentType)) {
            contentType = null;
        }
        SavedMessageContext smc = new SavedMessageContext();
        smc.msgContext = msgContext;
        smc.mt = mt;
        smc.mr = mr;
        smc.contentTypeNormalized = contentType;
        return smc;
    }

    private OpenSPCoop2Message buildMessage(SavedMessageContext smc, String contentType, InputStream isBytes) throws MessageException {
        OpenSPCoop2MessageFactory mf = OpenSPCoop2MessageFactory.getDefaultMessageFactory();
        NotifierInputStreamParams notifierInputStreamParams = null;
        OpenSPCoop2MessageParseResult pr = null;
        pr = mf.createMessage(smc.mt, smc.mr, contentType, isBytes, notifierInputStreamParams, this.openspcoopProperties.getAttachmentsProcessingMode());
        try {
            OpenSPCoop2Message msg = pr.getMessage_throwParseException();
            msg.readResourcesFrom(smc.msgContext);
            return msg;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), (Throwable)e);
        }
    }

    private void fillTransactionContext(Context context, InputStream is) throws UtilsException {
        SerializedContext serializedContext = null;
        try {
            JaxbDeserializer deserializer = new JaxbDeserializer();
            serializedContext = deserializer.readSerializedContext(is);
            if (serializedContext != null && serializedContext.sizePropertyList() > 0) {
                JavaDeserializer jDeserializer = new JavaDeserializer();
                for (SerializedParameter p : serializedContext.getPropertyList()) {
                    Object o = jDeserializer.readObject((InputStream)new ByteArrayInputStream(p.getBase()), Class.forName(p.getClasse()));
                    context.addObject(org.openspcoop2.utils.Map.newMapKey((String)p.getNome()), o);
                }
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    public void delete(boolean isRichiesta, boolean onewayVersione11, Timestamp data) throws UtilsException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful || onewayVersione11) {
            StateMessage stateMSG = isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            this.deleteStateful(connectionDB, data);
        } else if (!(this.openspcoopstate instanceof OpenSPCoopStateless)) {
            throw new UtilsException("Metodo invocato con IState non valido");
        }
    }

    private void deleteStateful(Connection connectionDB, Timestamp data) throws UtilsException {
        Statement pstmt = null;
        try {
            if (this.saveOnFS) {
                this.deleteFileSystem();
            }
            String sql = this.buildDeleteStatement(data);
            pstmt = connectionDB.prepareStatement(sql);
            pstmt.setString(1, this.idMessaggio);
            if ("INBOX".equals(this.box)) {
                pstmt.setString(2, "INBOX");
            } else {
                pstmt.setString(2, "OUTBOX");
            }
            if (data != null) {
                pstmt.setTimestamp(3, data);
            }
            pstmt.execute();
            pstmt.close();
        }
        catch (Exception e) {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errorMsg = "SOAP_MESSAGE, delete: " + this.box + "/" + this.idMessaggio + ": " + e.getMessage();
            this.logError(errorMsg, e);
            throw new UtilsException(errorMsg, (Throwable)e);
        }
    }

    private String buildDeleteStatement(Timestamp data) {
        StringBuilder query = new StringBuilder();
        query.append("DELETE from ");
        query.append("DEFINIZIONE_MESSAGGI");
        query.append(" WHERE ");
        query.append("ID_MESSAGGIO");
        query.append(" = ? AND ");
        query.append("TIPO");
        query.append(" = ?");
        if (data != null) {
            query.append(" AND ");
            query.append("ORA_REGISTRAZIONE");
            query.append("<=?");
        }
        return query.toString();
    }

    public void deleteMessageFromFileSystem() {
        try {
            if (this.saveOnFS) {
                this.deleteFileSystem();
            }
        }
        catch (Exception e) {
            String errorMsg = "SOAP_MESSAGE, deleteMessageFromFileSystem: " + this.box + "/" + this.idMessaggio + ": " + e.getMessage();
            this.getLog().error(errorMsg, (Throwable)e);
        }
    }

    private void deleteFileSystem() throws UtilsException {
        String pathTransactionContext;
        File fileDeleteTransactionContext;
        String pathResponseContext;
        File fileDeleteResponseContext;
        String pathResponseBytes;
        File fileDeleteResponseBytes;
        String pathContext;
        File fileDeleteContext;
        String saveDir = this.getBaseDir();
        this.checkInizializzazioneWorkingDir(saveDir);
        String pathBytes = saveDir + this.keyMsgBytes;
        File fileDeleteBytes = new File(pathBytes);
        if (fileDeleteBytes.exists()) {
            this.deleteFileIgnoreException(fileDeleteBytes);
        }
        if ((fileDeleteContext = new File(pathContext = saveDir + this.keyMsgContext)).exists()) {
            this.deleteFileIgnoreException(fileDeleteContext);
        }
        if ((fileDeleteResponseBytes = new File(pathResponseBytes = saveDir + this.keyMsgResponseBytes)).exists()) {
            this.deleteFileIgnoreException(fileDeleteResponseBytes);
        }
        if ((fileDeleteResponseContext = new File(pathResponseContext = saveDir + this.keyMsgResponseContext)).exists()) {
            this.deleteFileIgnoreException(fileDeleteResponseContext);
        }
        if ((fileDeleteTransactionContext = new File(pathTransactionContext = saveDir + this.keyMsgTransactionContext)).exists()) {
            this.deleteFileIgnoreException(fileDeleteTransactionContext);
        }
    }

    private void deleteFileIgnoreException(File file) {
        try {
            Files.delete(file.toPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

