/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.config.StatoServiziPdd;
import org.openspcoop2.core.config.StatoServiziPddIntegrationManager;
import org.openspcoop2.core.config.StatoServiziPddPortaApplicativa;
import org.openspcoop2.core.config.StatoServiziPddPortaDelegata;
import org.openspcoop2.core.config.TipoFiltroAbilitazioneServizi;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;

public class StatoServiziPdD {
    private static ConfigurazionePdDManager configPdDReader = ConfigurazionePdDManager.getInstance();
    private static final Semaphore lockActivePDService = new Semaphore("StatoServiziFruizioni");
    private static Boolean activePDService = null;
    private static List<TipoFiltroAbilitazioneServizi> listaAbilitazioniPDService = null;
    private static List<TipoFiltroAbilitazioneServizi> listaDisabilitazioniPDService = null;
    private static final Semaphore lockActivePAService = new Semaphore("StatoServiziErogazioni");
    private static Boolean activePAService = null;
    private static List<TipoFiltroAbilitazioneServizi> listaAbilitazioniPAService = null;
    private static List<TipoFiltroAbilitazioneServizi> listaDisabilitazioniPAService = null;
    private static final Semaphore lockActiveIMService = new Semaphore("StatoServiziIntegrationManager");
    private static Boolean activeIMService = null;

    public static void initialize() throws DriverConfigurazioneException {
        StatoServiziPdd statoServiziPdd = configPdDReader.getStatoServiziPdD();
        if (statoServiziPdd != null && statoServiziPdd.getPortaDelegata() != null) {
            activePDService = CostantiConfigurazione.DISABILITATO.equals((Object)statoServiziPdd.getPortaDelegata().getStato()) ? Boolean.valueOf(false) : Boolean.valueOf(true);
            listaAbilitazioniPDService = statoServiziPdd.getPortaDelegata().getFiltroAbilitazioneList();
            listaDisabilitazioniPDService = statoServiziPdd.getPortaDelegata().getFiltroDisabilitazioneList();
        }
        if (activePDService == null) {
            activePDService = true;
        }
        if (listaAbilitazioniPDService == null) {
            listaAbilitazioniPDService = new ArrayList<TipoFiltroAbilitazioneServizi>();
        }
        if (listaDisabilitazioniPDService == null) {
            listaDisabilitazioniPDService = new ArrayList<TipoFiltroAbilitazioneServizi>();
        }
        if (statoServiziPdd != null && statoServiziPdd.getPortaApplicativa() != null) {
            activePAService = CostantiConfigurazione.DISABILITATO.equals((Object)statoServiziPdd.getPortaApplicativa().getStato()) ? Boolean.valueOf(false) : Boolean.valueOf(true);
            listaAbilitazioniPAService = statoServiziPdd.getPortaApplicativa().getFiltroAbilitazioneList();
            listaDisabilitazioniPAService = statoServiziPdd.getPortaApplicativa().getFiltroDisabilitazioneList();
        }
        if (activePAService == null) {
            activePAService = true;
        }
        if (listaAbilitazioniPAService == null) {
            listaAbilitazioniPAService = new ArrayList<TipoFiltroAbilitazioneServizi>();
        }
        if (listaDisabilitazioniPAService == null) {
            listaDisabilitazioniPAService = new ArrayList<TipoFiltroAbilitazioneServizi>();
        }
        if (statoServiziPdd != null && statoServiziPdd.getIntegrationManager() != null) {
            activeIMService = CostantiConfigurazione.DISABILITATO.equals((Object)statoServiziPdd.getIntegrationManager().getStato()) ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        if (activeIMService == null) {
            activeIMService = true;
        }
    }

    public static boolean isPDServiceActive() {
        if (activePDService != null) {
            return activePDService;
        }
        return configPdDReader.isPDServiceActive();
    }

    public static List<TipoFiltroAbilitazioneServizi> getPDServiceFiltriAbilitazioneAttiviList() throws DriverConfigurazioneException {
        List list = null;
        if (listaAbilitazioniPDService != null) {
            list = listaAbilitazioniPDService;
        } else {
            StatoServiziPdd statoServiziPdd = configPdDReader.getStatoServiziPdD();
            if (statoServiziPdd != null && statoServiziPdd.getPortaDelegata() != null) {
                list = statoServiziPdd.getPortaDelegata().getFiltroAbilitazioneList();
            }
        }
        return list;
    }

    public static String getPDServiceFiltriAbilitazioneAttivi() throws DriverConfigurazioneException {
        List<TipoFiltroAbilitazioneServizi> list = StatoServiziPdD.getPDServiceFiltriAbilitazioneAttiviList();
        if (list == null || list.size() <= 0) {
            return "";
        }
        StringBuilder bf = new StringBuilder();
        for (TipoFiltroAbilitazioneServizi tipo : list) {
            bf.append(StatoServiziPdD.toString(tipo));
        }
        return bf.toString();
    }

    public static List<TipoFiltroAbilitazioneServizi> getPDServiceFiltriDisabilitazioneAttiviList() throws DriverConfigurazioneException {
        List list = null;
        if (listaDisabilitazioniPDService != null) {
            list = listaDisabilitazioniPDService;
        } else {
            StatoServiziPdd statoServiziPdd = configPdDReader.getStatoServiziPdD();
            if (statoServiziPdd != null && statoServiziPdd.getPortaDelegata() != null) {
                list = statoServiziPdd.getPortaDelegata().getFiltroDisabilitazioneList();
            }
        }
        return list;
    }

    public static String getPDServiceFiltriDisabilitazioneAttivi() throws DriverConfigurazioneException {
        List<TipoFiltroAbilitazioneServizi> list = StatoServiziPdD.getPDServiceFiltriDisabilitazioneAttiviList();
        if (list == null || list.size() <= 0) {
            return "";
        }
        StringBuilder bf = new StringBuilder();
        for (TipoFiltroAbilitazioneServizi tipo : list) {
            bf.append(StatoServiziPdD.toString(tipo));
        }
        return bf.toString();
    }

    public static void setPDServiceActive(boolean stato) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        SemaphoreLock lock = lockActivePDService.acquireThrowRuntime("setPDServiceActive");
        try {
            StatoServiziPdd statoServiziPdd = configPdDReader.getStatoServiziPdD();
            if (statoServiziPdd == null) {
                statoServiziPdd = new StatoServiziPdd();
            }
            if (statoServiziPdd.getPortaDelegata() == null) {
                statoServiziPdd.setPortaDelegata(new StatoServiziPddPortaDelegata());
            }
            if (stato) {
                statoServiziPdd.getPortaDelegata().setStato(CostantiConfigurazione.ABILITATO);
            } else {
                statoServiziPdd.getPortaDelegata().setStato(CostantiConfigurazione.DISABILITATO);
            }
            configPdDReader.updateStatoServiziPdD(statoServiziPdd);
            activePDService = stato;
        }
        finally {
            lockActivePDService.release(lock, "setPDServiceActive");
        }
    }

    public static void addFiltroAbilitazionePD(TipoFiltroAbilitazioneServizi tipo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        SemaphoreLock lock = lockActivePDService.acquireThrowRuntime("addFiltroAbilitazionePD");
        try {
            StatoServiziPdd statoServiziPdd = configPdDReader.getStatoServiziPdD();
            if (statoServiziPdd == null) {
                statoServiziPdd = new StatoServiziPdd();
            }
            if (statoServiziPdd.getPortaDelegata() == null) {
                statoServiziPdd.setPortaDelegata(new StatoServiziPddPortaDelegata());
            }
            statoServiziPdd.getPortaDelegata().addFiltroAbilitazione(tipo);
            configPdDReader.updateStatoServiziPdD(statoServiziPdd);
            listaAbilitazioniPDService = statoServiziPdd.getPortaDelegata().getFiltroAbilitazioneList();
        }
        finally {
            lockActivePDService.release(lock, "addFiltroAbilitazionePD");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFiltroAbilitazionePD(TipoFiltroAbilitazioneServizi tipo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        SemaphoreLock lock = lockActivePDService.acquireThrowRuntime("removeFiltroAbilitazionePD");
        try {
            StatoServiziPdd statoServiziPdd = configPdDReader.getStatoServiziPdD();
            if (statoServiziPdd == null) {
                statoServiziPdd = new StatoServiziPdd();
            }
            if (statoServiziPdd.getPortaDelegata() == null) {
                statoServiziPdd.setPortaDelegata(new StatoServiziPddPortaDelegata());
            }
            String daEliminare = StatoServiziPdD.toString(tipo);
            for (int i = 0; i < statoServiziPdd.getPortaDelegata().sizeFiltroAbilitazioneList(); ++i) {
                String tmp = StatoServiziPdD.toString(statoServiziPdd.getPortaDelegata().getFiltroAbilitazione(i));
                if (!tmp.equals(daEliminare)) continue;
                statoServiziPdd.getPortaDelegata().removeFiltroAbilitazione(i);
                break;
            }
            configPdDReader.updateStatoServiziPdD(statoServiziPdd);
            listaAbilitazioniPDService = statoServiziPdd.getPortaDelegata().getFiltroAbilitazioneList();
        }
        finally {
            lockActivePDService.release(lock, "removeFiltroAbilitazionePD");
        }
    }

    public static void addFiltroDisabilitazionePD(TipoFiltroAbilitazioneServizi tipo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        SemaphoreLock lock = lockActivePDService.acquireThrowRuntime("addFiltroDisabilitazionePD");
        try {
            StatoServiziPdd statoServiziPdd = configPdDReader.getStatoServiziPdD();
            if (statoServiziPdd == null) {
                statoServiziPdd = new StatoServiziPdd();
            }
            if (statoServiziPdd.getPortaDelegata() == null) {
                statoServiziPdd.setPortaDelegata(new StatoServiziPddPortaDelegata());
            }
            statoServiziPdd.getPortaDelegata().addFiltroDisabilitazione(tipo);
            configPdDReader.updateStatoServiziPdD(statoServiziPdd);
            listaDisabilitazioniPDService = statoServiziPdd.getPortaDelegata().getFiltroDisabilitazioneList();
        }
        finally {
            lockActivePDService.release(lock, "addFiltroDisabilitazionePD");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFiltroDisabilitazionePD(TipoFiltroAbilitazioneServizi tipo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        SemaphoreLock lock = lockActivePDService.acquireThrowRuntime("removeFiltroDisabilitazionePD");
        try {
            StatoServiziPdd statoServiziPdd = configPdDReader.getStatoServiziPdD();
            if (statoServiziPdd == null) {
                statoServiziPdd = new StatoServiziPdd();
            }
            if (statoServiziPdd.getPortaDelegata() == null) {
                statoServiziPdd.setPortaDelegata(new StatoServiziPddPortaDelegata());
            }
            String daEliminare = StatoServiziPdD.toString(tipo);
            for (int i = 0; i < statoServiziPdd.getPortaDelegata().sizeFiltroDisabilitazioneList(); ++i) {
                String tmp = StatoServiziPdD.toString(statoServiziPdd.getPortaDelegata().getFiltroDisabilitazione(i));
                if (!tmp.equals(daEliminare)) continue;
                statoServiziPdd.getPortaDelegata().removeFiltroDisabilitazione(i);
                break;
            }
            configPdDReader.updateStatoServiziPdD(statoServiziPdd);
            listaDisabilitazioniPDService = statoServiziPdd.getPortaDelegata().getFiltroDisabilitazioneList();
        }
        finally {
            lockActivePDService.release(lock, "removeFiltroDisabilitazionePD");
        }
    }

    public static boolean isPAServiceActive() {
        if (activePAService != null) {
            return activePAService;
        }
        return configPdDReader.isPAServiceActive();
    }

    public static List<TipoFiltroAbilitazioneServizi> getPAServiceFiltriAbilitazioneAttiviList() throws DriverConfigurazioneException {
        List list = null;
        if (listaAbilitazioniPAService != null) {
            list = listaAbilitazioniPAService;
        } else {
            StatoServiziPdd statoServiziPdd = configPdDReader.getStatoServiziPdD();
            if (statoServiziPdd != null && statoServiziPdd.getPortaApplicativa() != null) {
                list = statoServiziPdd.getPortaApplicativa().getFiltroAbilitazioneList();
            }
        }
        return list;
    }

    public static String getPAServiceFiltriAbilitazioneAttivi() throws DriverConfigurazioneException {
        List<TipoFiltroAbilitazioneServizi> list = StatoServiziPdD.getPAServiceFiltriAbilitazioneAttiviList();
        if (list == null || list.size() <= 0) {
            return "";
        }
        StringBuilder bf = new StringBuilder();
        for (TipoFiltroAbilitazioneServizi tipo : list) {
            bf.append(StatoServiziPdD.toString(tipo));
        }
        return bf.toString();
    }

    public static List<TipoFiltroAbilitazioneServizi> getPAServiceFiltriDisabilitazioneAttiviList() throws DriverConfigurazioneException {
        List list = null;
        if (listaDisabilitazioniPAService != null) {
            list = listaDisabilitazioniPAService;
        } else {
            StatoServiziPdd statoServiziPdd = configPdDReader.getStatoServiziPdD();
            if (statoServiziPdd != null && statoServiziPdd.getPortaApplicativa() != null) {
                list = statoServiziPdd.getPortaApplicativa().getFiltroDisabilitazioneList();
            }
        }
        return list;
    }

    public static String getPAServiceFiltriDisabilitazioneAttivi() throws DriverConfigurazioneException {
        List<TipoFiltroAbilitazioneServizi> list = StatoServiziPdD.getPAServiceFiltriDisabilitazioneAttiviList();
        if (list == null || list.size() <= 0) {
            return "";
        }
        StringBuilder bf = new StringBuilder();
        for (TipoFiltroAbilitazioneServizi tipo : list) {
            bf.append(StatoServiziPdD.toString(tipo));
        }
        return bf.toString();
    }

    public static void setPAServiceActive(boolean stato) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        SemaphoreLock lock = lockActivePAService.acquireThrowRuntime("setPAServiceActive");
        try {
            StatoServiziPdd statoServiziPdd = configPdDReader.getStatoServiziPdD();
            if (statoServiziPdd == null) {
                statoServiziPdd = new StatoServiziPdd();
            }
            if (statoServiziPdd.getPortaApplicativa() == null) {
                statoServiziPdd.setPortaApplicativa(new StatoServiziPddPortaApplicativa());
            }
            if (stato) {
                statoServiziPdd.getPortaApplicativa().setStato(CostantiConfigurazione.ABILITATO);
            } else {
                statoServiziPdd.getPortaApplicativa().setStato(CostantiConfigurazione.DISABILITATO);
            }
            configPdDReader.updateStatoServiziPdD(statoServiziPdd);
            activePAService = stato;
        }
        finally {
            lockActivePAService.release(lock, "setPAServiceActive");
        }
    }

    public static void addFiltroAbilitazionePA(TipoFiltroAbilitazioneServizi tipo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        SemaphoreLock lock = lockActivePAService.acquireThrowRuntime("addFiltroAbilitazionePA");
        try {
            StatoServiziPdd statoServiziPdd = configPdDReader.getStatoServiziPdD();
            if (statoServiziPdd == null) {
                statoServiziPdd = new StatoServiziPdd();
            }
            if (statoServiziPdd.getPortaApplicativa() == null) {
                statoServiziPdd.setPortaApplicativa(new StatoServiziPddPortaApplicativa());
            }
            statoServiziPdd.getPortaApplicativa().addFiltroAbilitazione(tipo);
            configPdDReader.updateStatoServiziPdD(statoServiziPdd);
            listaAbilitazioniPAService = statoServiziPdd.getPortaApplicativa().getFiltroAbilitazioneList();
        }
        finally {
            lockActivePAService.release(lock, "addFiltroAbilitazionePA");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFiltroAbilitazionePA(TipoFiltroAbilitazioneServizi tipo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        SemaphoreLock lock = lockActivePAService.acquireThrowRuntime("removeFiltroAbilitazionePA");
        try {
            StatoServiziPdd statoServiziPdd = configPdDReader.getStatoServiziPdD();
            if (statoServiziPdd == null) {
                statoServiziPdd = new StatoServiziPdd();
            }
            if (statoServiziPdd.getPortaApplicativa() == null) {
                statoServiziPdd.setPortaApplicativa(new StatoServiziPddPortaApplicativa());
            }
            String daEliminare = StatoServiziPdD.toString(tipo);
            for (int i = 0; i < statoServiziPdd.getPortaApplicativa().sizeFiltroAbilitazioneList(); ++i) {
                String tmp = StatoServiziPdD.toString(statoServiziPdd.getPortaApplicativa().getFiltroAbilitazione(i));
                if (!tmp.equals(daEliminare)) continue;
                statoServiziPdd.getPortaApplicativa().removeFiltroAbilitazione(i);
                break;
            }
            configPdDReader.updateStatoServiziPdD(statoServiziPdd);
            listaAbilitazioniPAService = statoServiziPdd.getPortaApplicativa().getFiltroAbilitazioneList();
        }
        finally {
            lockActivePAService.release(lock, "removeFiltroAbilitazionePA");
        }
    }

    public static void addFiltroDisabilitazionePA(TipoFiltroAbilitazioneServizi tipo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        SemaphoreLock lock = lockActivePAService.acquireThrowRuntime("addFiltroDisabilitazionePA");
        try {
            StatoServiziPdd statoServiziPdd = configPdDReader.getStatoServiziPdD();
            if (statoServiziPdd == null) {
                statoServiziPdd = new StatoServiziPdd();
            }
            if (statoServiziPdd.getPortaApplicativa() == null) {
                statoServiziPdd.setPortaApplicativa(new StatoServiziPddPortaApplicativa());
            }
            statoServiziPdd.getPortaApplicativa().addFiltroDisabilitazione(tipo);
            configPdDReader.updateStatoServiziPdD(statoServiziPdd);
            listaDisabilitazioniPAService = statoServiziPdd.getPortaApplicativa().getFiltroDisabilitazioneList();
        }
        finally {
            lockActivePAService.release(lock, "addFiltroDisabilitazionePA");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFiltroDisabilitazionePA(TipoFiltroAbilitazioneServizi tipo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        SemaphoreLock lock = lockActivePAService.acquireThrowRuntime("removeFiltroDisabilitazionePA");
        try {
            StatoServiziPdd statoServiziPdd = configPdDReader.getStatoServiziPdD();
            if (statoServiziPdd == null) {
                statoServiziPdd = new StatoServiziPdd();
            }
            if (statoServiziPdd.getPortaApplicativa() == null) {
                statoServiziPdd.setPortaApplicativa(new StatoServiziPddPortaApplicativa());
            }
            String daEliminare = StatoServiziPdD.toString(tipo);
            for (int i = 0; i < statoServiziPdd.getPortaApplicativa().sizeFiltroDisabilitazioneList(); ++i) {
                String tmp = StatoServiziPdD.toString(statoServiziPdd.getPortaApplicativa().getFiltroDisabilitazione(i));
                if (!tmp.equals(daEliminare)) continue;
                statoServiziPdd.getPortaApplicativa().removeFiltroDisabilitazione(i);
                break;
            }
            configPdDReader.updateStatoServiziPdD(statoServiziPdd);
            listaDisabilitazioniPAService = statoServiziPdd.getPortaApplicativa().getFiltroDisabilitazioneList();
        }
        finally {
            lockActivePAService.release(lock, "removeFiltroDisabilitazionePA");
        }
    }

    public static boolean isIMServiceActive() {
        if (activeIMService != null) {
            return activeIMService;
        }
        return configPdDReader.isIMServiceActive();
    }

    public static void setIMServiceActive(boolean stato) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        SemaphoreLock lock = lockActiveIMService.acquireThrowRuntime("setIMServiceActive");
        try {
            StatoServiziPdd statoServiziPdd = configPdDReader.getStatoServiziPdD();
            if (statoServiziPdd == null) {
                statoServiziPdd = new StatoServiziPdd();
            }
            if (statoServiziPdd.getIntegrationManager() == null) {
                statoServiziPdd.setIntegrationManager(new StatoServiziPddIntegrationManager());
            }
            if (stato) {
                statoServiziPdd.getIntegrationManager().setStato(CostantiConfigurazione.ABILITATO);
            } else {
                statoServiziPdd.getIntegrationManager().setStato(CostantiConfigurazione.DISABILITATO);
            }
            configPdDReader.updateStatoServiziPdD(statoServiziPdd);
            activeIMService = stato;
        }
        finally {
            lockActiveIMService.release(lock, "setIMServiceActive");
        }
    }

    private static String toString(TipoFiltroAbilitazioneServizi tipo) {
        StringBuilder bf = new StringBuilder();
        bf.append("(");
        if (tipo.getTipoSoggettoFruitore() != null) {
            bf.append(" TIPO_FRUITORE:");
            bf.append(tipo.getTipoSoggettoFruitore());
        }
        if (tipo.getSoggettoFruitore() != null) {
            bf.append(" FRUITORE:");
            bf.append(tipo.getSoggettoFruitore());
        }
        if (tipo.getIdentificativoPortaFruitore() != null) {
            bf.append(" PORTA_FRUITORE:");
            bf.append(tipo.getSoggettoFruitore());
        }
        if (tipo.getTipoSoggettoErogatore() != null) {
            bf.append(" TIPO_EROGATORE:");
            bf.append(tipo.getTipoSoggettoErogatore());
        }
        if (tipo.getSoggettoErogatore() != null) {
            bf.append(" EROGATORE:");
            bf.append(tipo.getSoggettoErogatore());
        }
        if (tipo.getIdentificativoPortaErogatore() != null) {
            bf.append(" PORTA_EROGATORE:");
            bf.append(tipo.getSoggettoErogatore());
        }
        if (tipo.getTipoServizio() != null) {
            bf.append(" TIPO_SERVIZIO:");
            bf.append(tipo.getTipoServizio());
        }
        if (tipo.getServizio() != null) {
            bf.append(" SERVIZIO:");
            bf.append(tipo.getServizio());
        }
        if (tipo.getVersioneServizio() != null) {
            bf.append(" VERSIONE_SERVIZIO:");
            bf.append(tipo.getVersioneServizio());
        }
        if (tipo.getAzione() != null) {
            bf.append(" AZIONE:");
            bf.append(tipo.getAzione());
        }
        bf.append(" )");
        return bf.toString();
    }

    public static boolean isEnabledPortaDelegata(IDSoggetto soggettoFruitore, IDServizio idServizio) throws DriverConfigurazioneException {
        return StatoServiziPdD._isEnabled(StatoServiziPdD.isPDServiceActive(), StatoServiziPdD.getPDServiceFiltriAbilitazioneAttiviList(), StatoServiziPdD.getPDServiceFiltriDisabilitazioneAttiviList(), soggettoFruitore, idServizio);
    }

    public static boolean isEnabledPortaApplicativa(IDSoggetto soggettoFruitore, IDServizio idServizio) throws DriverConfigurazioneException {
        return StatoServiziPdD._isEnabled(StatoServiziPdD.isPAServiceActive(), StatoServiziPdD.getPAServiceFiltriAbilitazioneAttiviList(), StatoServiziPdD.getPAServiceFiltriDisabilitazioneAttiviList(), soggettoFruitore, idServizio);
    }

    public static boolean isEnabledIntegrationManager() throws DriverConfigurazioneException {
        return StatoServiziPdD._isEnabled(StatoServiziPdD.isIMServiceActive(), null, null, null, null);
    }

    private static boolean _isEnabled(boolean statoServizioAbilitato, List<TipoFiltroAbilitazioneServizi> filtriAbilitazioni, List<TipoFiltroAbilitazioneServizi> filtriDisabilitazioni, IDSoggetto soggettoFruitore, IDServizio idServizio) {
        if (statoServizioAbilitato) {
            if (filtriDisabilitazioni != null) {
                for (TipoFiltroAbilitazioneServizi tipo : filtriDisabilitazioni) {
                    if (!StatoServiziPdD.isMatch(tipo, soggettoFruitore, idServizio)) continue;
                    return false;
                }
            }
            return true;
        }
        if (filtriAbilitazioni != null) {
            for (TipoFiltroAbilitazioneServizi tipo : filtriAbilitazioni) {
                if (!StatoServiziPdD.isMatch(tipo, soggettoFruitore, idServizio)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isMatch(TipoFiltroAbilitazioneServizi tipo, IDSoggetto soggettoFruitore, IDServizio idServizio) {
        if (soggettoFruitore == null) {
            return false;
        }
        if (tipo.getTipoSoggettoFruitore() != null && !tipo.getTipoSoggettoFruitore().equals(soggettoFruitore.getTipo())) {
            return false;
        }
        if (tipo.getSoggettoFruitore() != null && !tipo.getSoggettoFruitore().equals(soggettoFruitore.getNome())) {
            return false;
        }
        if (tipo.getIdentificativoPortaFruitore() != null && !tipo.getIdentificativoPortaFruitore().equals(soggettoFruitore.getCodicePorta())) {
            return false;
        }
        if (idServizio == null) {
            return false;
        }
        if (idServizio.getSoggettoErogatore() == null) {
            return false;
        }
        if (tipo.getTipoSoggettoErogatore() != null && !tipo.getTipoSoggettoErogatore().equals(idServizio.getSoggettoErogatore().getTipo())) {
            return false;
        }
        if (tipo.getSoggettoErogatore() != null && !tipo.getSoggettoErogatore().equals(idServizio.getSoggettoErogatore().getNome())) {
            return false;
        }
        if (tipo.getIdentificativoPortaErogatore() != null && !tipo.getIdentificativoPortaErogatore().equals(idServizio.getSoggettoErogatore().getCodicePorta())) {
            return false;
        }
        if (tipo.getTipoServizio() != null && !tipo.getTipoServizio().equals(idServizio.getTipo())) {
            return false;
        }
        if (tipo.getServizio() != null && !tipo.getServizio().equals(idServizio.getNome())) {
            return false;
        }
        if (tipo.getVersioneServizio() != null && tipo.getVersioneServizio().intValue() != idServizio.getVersione().intValue()) {
            return false;
        }
        return tipo.getAzione() == null || tipo.getAzione().equals(idServizio.getAzione());
    }
}

