/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autenticazione;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import org.openspcoop2.message.OpenSPCoop2Message;

public abstract class EsitoAutenticazione
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean clientAuthenticated = false;
    private String credential;
    private String fullCredential;
    private boolean enrichPrincipal = false;
    private boolean clientIdentified = false;
    private String details;
    private Exception eccezioneProcessamento;
    private boolean esitoPresenteInCache = false;
    private boolean noCache = false;
    private OpenSPCoop2Message errorMessage;
    private String wwwAuthenticateErrorHeader;

    public String getWwwAuthenticateErrorHeader() {
        return this.wwwAuthenticateErrorHeader;
    }

    public void setWwwAuthenticateErrorHeader(String wwwAuthenticateErrorHeader) {
        this.wwwAuthenticateErrorHeader = wwwAuthenticateErrorHeader;
    }

    public OpenSPCoop2Message getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(OpenSPCoop2Message errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getCredential() {
        return this.credential;
    }

    public void setCredential(String credential) {
        this.credential = credential;
    }

    public String getFullCredential() {
        return this.fullCredential;
    }

    public void setFullCredential(String fullCredential) {
        this.fullCredential = fullCredential;
    }

    public boolean isEnrichPrincipal() {
        return this.enrichPrincipal;
    }

    public void setEnrichPrincipal(boolean enrichPrincipal) {
        this.enrichPrincipal = enrichPrincipal;
    }

    public boolean isClientAuthenticated() {
        return this.clientAuthenticated;
    }

    public void setClientAuthenticated(boolean clientAuthenticated) {
        this.clientAuthenticated = clientAuthenticated;
    }

    public boolean isClientIdentified() {
        return this.clientIdentified;
    }

    public void setClientIdentified(boolean clientIdentified) {
        this.clientIdentified = clientIdentified;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public Exception getEccezioneProcessamento() {
        return this.eccezioneProcessamento;
    }

    public void setEccezioneProcessamento(Exception eccezioneProcessamento) {
        this.eccezioneProcessamento = eccezioneProcessamento;
        this.noCache = true;
    }

    protected String getHeader() {
        if (this.clientIdentified) {
            return "AUTENTICATO";
        }
        return "NON_AUTENTICATO";
    }

    public boolean isEsitoPresenteInCache() {
        return this.esitoPresenteInCache;
    }

    public void setEsitoPresenteInCache(boolean esitoPresenteInCache) {
        this.esitoPresenteInCache = esitoPresenteInCache;
    }

    public boolean isNoCache() {
        return this.noCache;
    }

    public void setNoCache(boolean noCache) {
        this.noCache = noCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder bf = new StringBuilder(this.getHeader());
        if (this.details != null) {
            bf.append(" ");
            bf.append("details[" + this.details + "]");
        }
        if (this.eccezioneProcessamento != null) {
            bf.append(" ");
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bout);
            try {
                this.eccezioneProcessamento.printStackTrace(ps);
            }
            finally {
                try {
                    ps.flush();
                    ps.close();
                    bout.flush();
                    bout.close();
                }
                catch (Exception exception) {}
            }
            bf.append("stackTraceEccezioneProcessamento: \n" + bout.toString());
        }
        return bf.toString();
    }
}

