/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autenticazione.pa;

import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.core.autenticazione.AutenticazioneException;
import org.openspcoop2.pdd.core.autenticazione.pa.AbstractAutenticazioneBase;
import org.openspcoop2.pdd.core.autenticazione.pa.DatiInvocazionePortaApplicativa;
import org.openspcoop2.pdd.core.autenticazione.pa.EsitoAutenticazionePortaApplicativa;
import org.openspcoop2.pdd.core.token.Costanti;
import org.openspcoop2.pdd.core.token.InformazioniToken;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;

public class AutenticazioneToken
extends AbstractAutenticazioneBase {
    private boolean logError = true;
    private String tokenPolicy = null;
    private String clientId = null;

    @Override
    public void setLogError(boolean logError) {
        this.logError = logError;
    }

    private void readDati(DatiInvocazionePortaApplicativa datiInvocazione) {
        if (this.clientId == null) {
            InformazioniToken informazioniTokenNormalizzate = null;
            if (this.getPddContext() != null && this.getPddContext().containsKey(Costanti.PDD_CONTEXT_TOKEN_INFORMAZIONI_NORMALIZZATE)) {
                informazioniTokenNormalizzate = (InformazioniToken)this.getPddContext().getObject(Costanti.PDD_CONTEXT_TOKEN_INFORMAZIONI_NORMALIZZATE);
            }
            if (informazioniTokenNormalizzate == null) {
                return;
            }
            this.clientId = informazioniTokenNormalizzate.getClientId();
            if (this.clientId == null || StringUtils.isEmpty((CharSequence)this.clientId)) {
                return;
            }
        }
        if (this.tokenPolicy == null) {
            if (datiInvocazione.getPa() != null) {
                if (datiInvocazione.getPa().getGestioneToken() != null) {
                    this.tokenPolicy = datiInvocazione.getPa().getGestioneToken().getPolicy();
                    if (this.tokenPolicy == null || StringUtils.isEmpty((CharSequence)this.tokenPolicy)) {
                        return;
                    }
                }
            } else if (datiInvocazione.getPd() != null && datiInvocazione.getPd().getGestioneToken() != null) {
                this.tokenPolicy = datiInvocazione.getPd().getGestioneToken().getPolicy();
                if (this.tokenPolicy == null || StringUtils.isEmpty((CharSequence)this.tokenPolicy)) {
                    return;
                }
            }
        }
    }

    public String toStringCredentials() {
        if (this.clientId == null || this.tokenPolicy == null) {
            return null;
        }
        return "TokenPolicy-" + this.tokenPolicy + ".clientId:" + this.clientId;
    }

    @Override
    public String getSuffixKeyAuthenticationResultInCache(DatiInvocazionePortaApplicativa datiInvocazione) {
        this.readDati(datiInvocazione);
        return this.toStringCredentials();
    }

    @Override
    public EsitoAutenticazionePortaApplicativa process(DatiInvocazionePortaApplicativa datiInvocazione) throws AutenticazioneException {
        EsitoAutenticazionePortaApplicativa esito = new EsitoAutenticazionePortaApplicativa();
        if (datiInvocazione == null) {
            throw new AutenticazioneException("Param datiInvocazione is null");
        }
        this.readDati(datiInvocazione);
        if (this.clientId == null || this.tokenPolicy == null) {
            esito.setClientAuthenticated(false);
            esito.setClientIdentified(false);
            esito.setNoCache(true);
            return esito;
        }
        esito.setClientAuthenticated(true);
        esito.setCredential(this.toStringCredentials());
        IDServizioApplicativo idServizioApplicativo = null;
        IDSoggetto idSoggetto = null;
        try {
            ConfigurazionePdDManager configurazionePdDManager = ConfigurazionePdDManager.getInstance(datiInvocazione.getState());
            idServizioApplicativo = configurazionePdDManager.getIdServizioApplicativoByCredenzialiToken(this.tokenPolicy, this.clientId);
            if (idServizioApplicativo != null) {
                idSoggetto = idServizioApplicativo.getIdSoggettoProprietario();
            }
        }
        catch (Exception e) {
            if (this.logError) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("AutenticazioneToken non riuscita", (Throwable)e);
            }
            esito.setErroreCooperazione(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreCooperazione());
            esito.setClientAuthenticated(false);
            esito.setClientIdentified(false);
            esito.setEccezioneProcessamento(e);
            return esito;
        }
        if (idServizioApplicativo == null) {
            esito.setClientIdentified(false);
            return esito;
        }
        esito.setClientIdentified(true);
        esito.setIdSoggetto(idSoggetto);
        esito.setIdServizioApplicativo(idServizioApplicativo);
        return esito;
    }
}

