/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autorizzazione;

import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.TipoAutenticazione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.Ruolo;
import org.openspcoop2.core.registry.constants.RuoloContesto;
import org.openspcoop2.core.registry.constants.RuoloTipologia;
import org.openspcoop2.core.registry.constants.TipiDocumentoSicurezza;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicercaRuoli;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.autorizzazione.AbstractDatiInvocazione;
import org.openspcoop2.pdd.core.autorizzazione.AutorizzazioneException;
import org.openspcoop2.pdd.core.autorizzazione.container.AutorizzazioneHttpServletRequest;
import org.openspcoop2.pdd.core.autorizzazione.pa.DatiInvocazionePortaApplicativa;
import org.openspcoop2.pdd.core.autorizzazione.pd.DatiInvocazionePortaDelegata;
import org.openspcoop2.pdd.core.token.Costanti;
import org.openspcoop2.pdd.core.token.EsitoGestioneToken;
import org.openspcoop2.pdd.core.token.InformazioniToken;
import org.openspcoop2.pdd.core.token.InformazioniTokenUserInfo;
import org.openspcoop2.pdd.core.token.TokenUtilities;
import org.openspcoop2.pdd.core.token.attribute_authority.InformazioniAttributi;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.URLProtocolContext;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.utils.xacml.MarshallUtilities;
import org.openspcoop2.utils.xacml.PolicyDecisionPoint;
import org.openspcoop2.utils.xacml.PolicyException;
import org.openspcoop2.utils.xacml.XacmlRequest;
import org.slf4j.Logger;

public class XACMLPolicyUtilities {
    private static PolicyDecisionPoint pdp;
    private static final String NOME_POLICY_FRUIZIONE = "fruizioneXacmlPolicy.xml";

    private static synchronized void initPdD(Logger log) throws PolicyException {
        if (pdp == null) {
            pdp = new PolicyDecisionPoint(log);
        }
    }

    public static PolicyDecisionPoint getPolicyDecisionPoint(Logger log) throws PolicyException {
        if (pdp == null) {
            XACMLPolicyUtilities.initPdD(log);
        }
        return pdp;
    }

    public static void loadPolicy(String xacmlPolicyPorta, IDServizio idServizio, String key, boolean portaDelegata, IDSoggetto fruitore, Logger log) throws PolicyException {
        byte[] policy = null;
        if (xacmlPolicyPorta != null) {
            policy = xacmlPolicyPorta.getBytes();
        } else {
            String nomePolicy = null;
            int numeroPolicy = 0;
            boolean numeroPolicyFruizione = false;
            try {
                AccordoServizioParteSpecifica asps = RegistroServiziManager.getInstance().getAccordoServizioParteSpecifica(idServizio, null, Boolean.valueOf(true), null);
                for (int i = 0; i < asps.sizeSpecificaSicurezzaList(); ++i) {
                    Documento d = asps.getSpecificaSicurezza(i);
                    if (!TipiDocumentoSicurezza.XACML_POLICY.getNome().equals(d.getTipo()) || policy != null && (!portaDelegata || !(fruitore.getNome() + "_fruizioneXacmlPolicy.xml").equals(d.getFile()))) continue;
                    if (NOME_POLICY_FRUIZIONE.equals(d.getFile())) {
                        numeroPolicyFruizione = true;
                    } else {
                        ++numeroPolicy;
                    }
                    if (d.getByteContenuto() != null) {
                        policy = d.getByteContenuto();
                        nomePolicy = d.getFile();
                        continue;
                    }
                    if (d.getFile() == null) continue;
                    if (d.getFile().startsWith("http://") || d.getFile().startsWith("file://")) {
                        URL url = new URI(d.getFile()).toURL();
                        policy = HttpUtilities.requestHTTPFile((String)url.toString());
                        continue;
                    }
                    File f = new File(d.getFile());
                    policy = FileSystemUtilities.readBytesFromFile((File)f);
                }
                if (numeroPolicy > 1) {
                    throw new PolicyException("Piu di una xacml policy trovata per il servizio " + idServizio.toString());
                }
            }
            catch (Exception e) {
                throw new PolicyException("Errore durante la ricerca delle policies xacml per il servizio " + idServizio.toString() + ": " + e.getMessage(), e);
            }
            if (policy == null) {
                throw new PolicyException("Nessuna xacml policy trovata trovata per il servizio " + idServizio.toString());
            }
        }
        try {
            XACMLPolicyUtilities.getPolicyDecisionPoint(log).addPolicy(MarshallUtilities.unmarshallPolicy((byte[])policy), key);
        }
        catch (Exception e) {
            throw new PolicyException("Errore durante il caricamento della xacml policy sul PdD (servizio " + idServizio.toString() + "): " + e.getMessage(), e);
        }
    }

    public static XacmlRequest newXacmlRequest(IProtocolFactory<?> protocolFactory, AbstractDatiInvocazione datiInvocazione, boolean checkRuoloRegistro, boolean checkRuoloEsterno, String policyKey) throws AutorizzazioneException {
        Object value;
        List values;
        Object value2;
        EsitoGestioneToken esito;
        Object oTmp;
        XacmlRequest xacmlRequest = new XacmlRequest();
        URLProtocolContext urlProtocolContext = null;
        if (datiInvocazione.getInfoConnettoreIngresso() == null || datiInvocazione.getInfoConnettoreIngresso().getUrlProtocolContext() == null) {
            throw new AutorizzazioneException("UrlProtocolContext non disponibile; risorsa richiesta dall'autorizzazione");
        }
        urlProtocolContext = datiInvocazione.getInfoConnettoreIngresso().getUrlProtocolContext();
        if (datiInvocazione.getIdServizio() == null || datiInvocazione.getIdServizio().getSoggettoErogatore() == null || datiInvocazione.getIdServizio().getSoggettoErogatore().getTipo() == null || datiInvocazione.getIdServizio().getSoggettoErogatore().getNome() == null || datiInvocazione.getIdServizio().getTipo() == null || datiInvocazione.getIdServizio().getNome() == null) {
            throw new AutorizzazioneException("DatiServizio non disponibile; risorsa richiesta dall'autorizzazione");
        }
        String tipoSoggettoErogatore = datiInvocazione.getIdServizio().getSoggettoErogatore().getTipo();
        String nomeSoggettoErogatore = datiInvocazione.getIdServizio().getSoggettoErogatore().getNome();
        String tipoServizio = datiInvocazione.getIdServizio().getTipo();
        String nomeServizio = datiInvocazione.getIdServizio().getNome();
        String azione = datiInvocazione.getIdServizio().getAzione() != null ? datiInvocazione.getIdServizio().getAzione() : "";
        DatiInvocazionePortaDelegata datiPD = null;
        if (datiInvocazione instanceof DatiInvocazionePortaDelegata) {
            datiPD = (DatiInvocazionePortaDelegata)datiInvocazione;
        }
        DatiInvocazionePortaApplicativa datiPA = null;
        if (datiInvocazione instanceof DatiInvocazionePortaApplicativa) {
            datiPA = (DatiInvocazionePortaApplicativa)datiInvocazione;
        }
        PdDContext pddContext = datiInvocazione.getPddContext();
        InformazioniToken informazioniTokenNormalizzate = null;
        InformazioniTokenUserInfo informazioniTokenUserInfoNormalizzate = null;
        Map<String, Serializable> jwtClaims = null;
        Map<String, Serializable> introspectionClaims = null;
        Map<String, Serializable> userInfoClaims = null;
        Object oInformazioniTokenNormalizzate = pddContext.getObject(Costanti.PDD_CONTEXT_TOKEN_INFORMAZIONI_NORMALIZZATE);
        if (oInformazioniTokenNormalizzate != null) {
            informazioniTokenNormalizzate = (InformazioniToken)oInformazioniTokenNormalizzate;
            informazioniTokenUserInfoNormalizzate = informazioniTokenNormalizzate.getUserInfo();
        }
        if ((oTmp = pddContext.getObject(Costanti.PDD_CONTEXT_TOKEN_ESITO_VALIDAZIONE)) != null && (esito = (EsitoGestioneToken)oTmp).getInformazioniToken() != null && esito.getInformazioniToken().getClaims() != null && esito.getInformazioniToken().getClaims().size() > 0) {
            jwtClaims = esito.getInformazioniToken().getClaims();
        }
        if ((oTmp = pddContext.getObject(Costanti.PDD_CONTEXT_TOKEN_ESITO_INTROSPECTION)) != null && (esito = (EsitoGestioneToken)oTmp).getInformazioniToken() != null && esito.getInformazioniToken().getClaims() != null && esito.getInformazioniToken().getClaims().size() > 0) {
            introspectionClaims = esito.getInformazioniToken().getClaims();
        }
        if ((oTmp = pddContext.getObject(Costanti.PDD_CONTEXT_TOKEN_ESITO_USER_INFO)) != null && (esito = (EsitoGestioneToken)oTmp).getInformazioniToken() != null && esito.getInformazioniToken().getClaims() != null && esito.getInformazioniToken().getClaims().size() > 0) {
            userInfoClaims = esito.getInformazioniToken().getClaims();
        }
        List<String> tokenRoles = null;
        if (informazioniTokenNormalizzate != null) {
            tokenRoles = informazioniTokenNormalizzate.getRoles();
        }
        List<String> attributeNames = null;
        Map<String, Serializable> attributes = null;
        boolean multipleAA = false;
        InformazioniAttributi informazioniAttributiNormalizzati = null;
        Object oInformazioniAttributiNormalizzati = pddContext.getObject(Costanti.PDD_CONTEXT_ATTRIBUTI_INFORMAZIONI_NORMALIZZATE);
        if (oInformazioniAttributiNormalizzati != null) {
            informazioniAttributiNormalizzati = (InformazioniAttributi)oInformazioniAttributiNormalizzati;
        }
        if (informazioniAttributiNormalizzati != null) {
            attributeNames = informazioniAttributiNormalizzati.getAttributesNames();
            attributes = informazioniAttributiNormalizzati.getAttributes();
            multipleAA = informazioniAttributiNormalizzati.isMultipleAttributeAuthorities() != null && informazioniAttributiNormalizzati.isMultipleAttributeAuthorities().getValue() != null && informazioniAttributiNormalizzati.isMultipleAttributeAuthorities().getValue() != false;
        }
        Map<String, String> apiImplConfig = XACMLPolicyUtilities.readConfig(pddContext, (MapKey<String>)org.openspcoop2.core.constants.Costanti.PROPRIETA_CONFIGURAZIONE);
        Map<String, String> applicativoConfig = XACMLPolicyUtilities.readConfig(pddContext, (MapKey<String>)org.openspcoop2.core.constants.Costanti.PROPRIETA_APPLICATIVO);
        Map<String, String> soggettoFruitoreConfig = XACMLPolicyUtilities.readConfig(pddContext, (MapKey<String>)org.openspcoop2.core.constants.Costanti.PROPRIETA_SOGGETTO_FRUITORE);
        Map<String, String> soggettoErogatoreConfig = XACMLPolicyUtilities.readConfig(pddContext, (MapKey<String>)org.openspcoop2.core.constants.Costanti.PROPRIETA_SOGGETTO_EROGATORE);
        HttpServletRequest httpServletRequest = null;
        if (checkRuoloEsterno) {
            if (datiInvocazione.getInfoConnettoreIngresso().getUrlProtocolContext().getHttpServletRequest() == null && tokenRoles == null) {
                throw new AutorizzazioneException("HttpServletRequest non disponibile; risorsa richiesta dall'autorizzazione");
            }
            httpServletRequest = datiInvocazione.getInfoConnettoreIngresso().getUrlProtocolContext().getHttpServletRequest();
        }
        String azioneId = urlProtocolContext.getRequestURI();
        xacmlRequest.addAction(azioneId);
        xacmlRequest.addActionAttribute("org:govway:action:provider", tipoSoggettoErogatore + "/" + nomeSoggettoErogatore);
        if (soggettoErogatoreConfig != null && !soggettoErogatoreConfig.isEmpty()) {
            for (String key : soggettoErogatoreConfig.keySet()) {
                value2 = soggettoErogatoreConfig.get(key);
                xacmlRequest.addActionAttribute("org:govway:action:provider:config:" + key, (String)value2);
            }
        }
        xacmlRequest.addActionAttribute("org:govway:action:service", tipoServizio + "/" + nomeServizio);
        if (apiImplConfig != null && !apiImplConfig.isEmpty()) {
            for (String key : apiImplConfig.keySet()) {
                value2 = apiImplConfig.get(key);
                xacmlRequest.addActionAttribute("org:govway:action:service:config:" + key, (String)value2);
            }
        }
        if (azione != null) {
            xacmlRequest.addActionAttribute("org:govway:action:action", azione);
        }
        xacmlRequest.addActionAttribute("org:govway:action:url", urlProtocolContext.getRequestURI());
        if (urlProtocolContext.getParameters() != null && urlProtocolContext.getParameters().size() > 0) {
            for (String key : urlProtocolContext.getParameters().keySet()) {
                values = urlProtocolContext.getParameterValues(key);
                if (key == null || key.contains(" ") || values == null || values.isEmpty()) continue;
                if (values.size() == 1) {
                    xacmlRequest.addActionAttribute("org:govway:action:url:parameter:" + key, (String)values.get(0));
                    continue;
                }
                xacmlRequest.addActionAttribute("org:govway:action:url:parameter:" + key, values);
            }
        }
        if (urlProtocolContext.getHeaders() != null && urlProtocolContext.getHeaders().size() > 0) {
            for (String key : urlProtocolContext.getHeaders().keySet()) {
                values = urlProtocolContext.getHeaderValues(key);
                if (key == null || key.contains(" ") || values == null || values.isEmpty()) continue;
                if (values.size() == 1) {
                    xacmlRequest.addActionAttribute("org:govway:action:transport:header:" + key, (String)values.get(0));
                    continue;
                }
                xacmlRequest.addActionAttribute("org:govway:action:transport:header:" + key, values);
            }
        }
        if (urlProtocolContext.getFunction() != null) {
            xacmlRequest.addActionAttribute("org:govway:action:gwService", urlProtocolContext.getFunction());
        }
        if (datiInvocazione.getInfoConnettoreIngresso().getSoapAction() != null) {
            xacmlRequest.addActionAttribute("org:govway:action:soapAction", datiInvocazione.getInfoConnettoreIngresso().getSoapAction());
        }
        if (protocolFactory != null) {
            xacmlRequest.addActionAttribute("org:govway:action:protocol", protocolFactory.getProtocol());
        }
        if (informazioniTokenNormalizzate != null) {
            if (informazioniTokenNormalizzate.getAud() != null) {
                xacmlRequest.addActionAttribute("org:govway:action:token:audience", informazioniTokenNormalizzate.getAud());
            }
            if (informazioniTokenNormalizzate.getScopes() != null && informazioniTokenNormalizzate.getScopes().size() > 0) {
                xacmlRequest.addActionAttribute("org:govway:action:token:scope", informazioniTokenNormalizzate.getScopes());
            }
        }
        if (jwtClaims != null && jwtClaims.size() > 0) {
            for (String key : jwtClaims.keySet()) {
                value2 = jwtClaims.get(key);
                key = XACMLPolicyUtilities.normalizeKeyClaim(key);
                XACMLPolicyUtilities.setActionAttribute(xacmlRequest, value2, "org:govway:action:token:jwt:claim:" + key);
            }
        }
        if (introspectionClaims != null && introspectionClaims.size() > 0) {
            for (String key : introspectionClaims.keySet()) {
                value2 = introspectionClaims.get(key);
                key = XACMLPolicyUtilities.normalizeKeyClaim(key);
                XACMLPolicyUtilities.setActionAttribute(xacmlRequest, value2, "org:govway:action:token:introspection:claim:" + key);
            }
        }
        String nomeServizioApplicativo = null;
        IDSoggetto soggettoFruitore = null;
        if (datiPD != null) {
            if (datiPD.getIdServizioApplicativo() != null) {
                nomeServizioApplicativo = datiPD.getIdServizioApplicativo().getNome();
                soggettoFruitore = datiPD.getIdServizioApplicativo().getIdSoggettoProprietario();
            } else if (datiPD.getIdPD() != null && datiPD.getIdPD().getIdentificativiFruizione() != null && datiPD.getIdPD().getIdentificativiFruizione().getSoggettoFruitore() != null) {
                soggettoFruitore = datiPD.getIdPD().getIdentificativiFruizione().getSoggettoFruitore();
            }
        } else if (datiPA != null) {
            if (datiPA.getIdSoggettoFruitore() != null) {
                soggettoFruitore = datiPA.getIdSoggettoFruitore();
            }
            if (datiPA.getIdentitaServizioApplicativoFruitore() != null) {
                nomeServizioApplicativo = datiPA.getIdentitaServizioApplicativoFruitore().getNome();
                if (soggettoFruitore == null) {
                    soggettoFruitore = datiPA.getIdentitaServizioApplicativoFruitore().getIdSoggettoProprietario();
                }
            }
        }
        String credential = null;
        TipoAutenticazione autenticazione = null;
        if (datiPD != null) {
            if (datiPD.getPd() != null) {
                autenticazione = TipoAutenticazione.toEnumConstant((String)datiPD.getPd().getAutenticazione());
            }
        } else if (datiPA != null && datiPA.getPa() != null) {
            autenticazione = TipoAutenticazione.toEnumConstant((String)datiPA.getPa().getAutenticazione());
        }
        if (datiInvocazione.getInfoConnettoreIngresso().getCredenziali() != null) {
            if (autenticazione != null) {
                if (TipoAutenticazione.BASIC.equals((Object)autenticazione)) {
                    if (datiInvocazione.getInfoConnettoreIngresso().getCredenziali().getUsername() != null) {
                        credential = datiInvocazione.getInfoConnettoreIngresso().getCredenziali().getUsername();
                    }
                } else if (TipoAutenticazione.SSL.equals((Object)autenticazione)) {
                    if (datiInvocazione.getInfoConnettoreIngresso().getCredenziali().getSubject() != null) {
                        credential = datiInvocazione.getInfoConnettoreIngresso().getCredenziali().getSubject();
                    }
                } else if (TipoAutenticazione.PRINCIPAL.equals((Object)autenticazione) && datiInvocazione.getInfoConnettoreIngresso().getCredenziali().getPrincipal() != null) {
                    credential = datiInvocazione.getInfoConnettoreIngresso().getCredenziali().getPrincipal();
                }
            }
            if (credential == null) {
                if (datiInvocazione.getInfoConnettoreIngresso().getCredenziali().getPrincipal() != null) {
                    credential = datiInvocazione.getInfoConnettoreIngresso().getCredenziali().getPrincipal();
                } else if (datiInvocazione.getInfoConnettoreIngresso().getCredenziali().getSubject() != null) {
                    credential = datiInvocazione.getInfoConnettoreIngresso().getCredenziali().getSubject();
                } else if (datiInvocazione.getInfoConnettoreIngresso().getCredenziali().getUsername() != null) {
                    credential = datiInvocazione.getInfoConnettoreIngresso().getCredenziali().getUsername();
                }
            }
        }
        ArrayList<String> roles = new ArrayList<String>();
        if (checkRuoloRegistro) {
            if (datiPD != null) {
                if (datiPD.getServizioApplicativo() == null && !checkRuoloEsterno && informazioniTokenNormalizzate == null) {
                    throw new AutorizzazioneException("Identit\u00e0 servizio applicativo non disponibile; tale informazione \u00e8 richiesta dall'autorizzazione");
                }
                if (datiPD.getServizioApplicativo() != null && datiPD.getServizioApplicativo().getInvocazionePorta() != null && datiPD.getServizioApplicativo().getInvocazionePorta().getRuoli() != null && datiPD.getServizioApplicativo().getInvocazionePorta().getRuoli().sizeRuoloList() > 0) {
                    for (i = 0; i < datiPD.getServizioApplicativo().getInvocazionePorta().getRuoli().sizeRuoloList(); ++i) {
                        roles.add(datiPD.getServizioApplicativo().getInvocazionePorta().getRuoli().getRuolo(i).getNome());
                    }
                }
            } else if (datiPA != null) {
                if (datiPA.getSoggettoFruitore() == null && !checkRuoloEsterno && informazioniTokenNormalizzate == null) {
                    throw new AutorizzazioneException("Identit\u00e0 soggetto fruitore non disponibile; tale informazione \u00e8 richiesta dall'autorizzazione");
                }
                if (datiPA.getSoggettoFruitore() != null && datiPA.getSoggettoFruitore().getRuoli() != null && datiPA.getSoggettoFruitore().getRuoli().sizeRuoloList() > 0) {
                    for (i = 0; i < datiPA.getSoggettoFruitore().getRuoli().sizeRuoloList(); ++i) {
                        roles.add(datiPA.getSoggettoFruitore().getRuoli().getRuolo(i).getNome());
                    }
                }
            }
        }
        if (checkRuoloEsterno) {
            try {
                FiltroRicercaRuoli filtroRicerca = new FiltroRicercaRuoli();
                if (datiPD != null) {
                    filtroRicerca.setContesto(RuoloContesto.PORTA_DELEGATA);
                } else if (datiPA != null) {
                    filtroRicerca.setContesto(RuoloContesto.PORTA_APPLICATIVA);
                }
                filtroRicerca.setTipologia(RuoloTipologia.ESTERNO);
                RegistroServiziManager registroServiziManager = RegistroServiziManager.getInstance((IState)datiInvocazione.getState());
                List list = registroServiziManager.getAllIdRuoli(filtroRicerca, null);
                if (list == null || list.size() <= 0) {
                    throw new DriverRegistroServiziNotFound();
                }
                for (IDRuolo idRuolo : list) {
                    String nomeRuoloDaVerificare = idRuolo.getNome();
                    try {
                        Ruolo ruoloRegistro = registroServiziManager.getRuolo(idRuolo.getNome(), null, datiInvocazione.getRequestInfo());
                        if (ruoloRegistro.getNomeEsterno() != null && !"".equals(ruoloRegistro.getNomeEsterno())) {
                            nomeRuoloDaVerificare = ruoloRegistro.getNomeEsterno();
                        }
                    }
                    catch (Exception e) {
                        throw new Exception("Recupero del ruolo '" + idRuolo.getNome() + "' fallito: " + e.getMessage(), e);
                    }
                    if (!httpServletRequest.isUserInRole(nomeRuoloDaVerificare)) continue;
                    roles.add(idRuolo.getNome());
                }
                if (tokenRoles != null && tokenRoles.size() > 0) {
                    roles.addAll(tokenRoles);
                }
            }
            catch (DriverRegistroServiziNotFound notFound) {
                if (!checkRuoloRegistro) {
                    throw new AutorizzazioneException("Non sono stati registrati ruoli utilizzabili con un'autorizzazione esterna");
                }
            }
            catch (Exception e) {
                throw new AutorizzazioneException("E' avvenuto un errore durante la ricerca dei ruoli: " + e.getMessage(), e);
            }
        }
        oTmp = pddContext.getObject(org.openspcoop2.core.constants.Costanti.ID_APPLICATIVO_TOKEN);
        IDServizioApplicativo idApplicativoToken = null;
        Map<String, String> applicativoTokenConfig = null;
        Map<String, String> soggettoProprietarioApplicativoTokenConfig = null;
        ArrayList<String> applicativoTokenRoles = new ArrayList<String>();
        if (oTmp != null && oTmp instanceof IDServizioApplicativo) {
            idApplicativoToken = (IDServizioApplicativo)oTmp;
            applicativoTokenConfig = XACMLPolicyUtilities.readConfig(pddContext, (MapKey<String>)org.openspcoop2.core.constants.Costanti.PROPRIETA_APPLICATIVO_TOKEN);
            soggettoProprietarioApplicativoTokenConfig = XACMLPolicyUtilities.readConfig(pddContext, (MapKey<String>)org.openspcoop2.core.constants.Costanti.PROPRIETA_SOGGETTO_PROPRIETARIO_APPLICATIVO_TOKEN);
            ServizioApplicativo saToken = null;
            if (checkRuoloRegistro || checkRuoloEsterno) {
                try {
                    saToken = ConfigurazionePdDManager.getInstance().getServizioApplicativo(idApplicativoToken, datiInvocazione.getRequestInfo());
                }
                catch (DriverConfigurazioneNotFound nomeRuoloDaVerificare) {
                }
                catch (Exception e) {
                    throw new AutorizzazioneException("E' avvenuto un errore durante la ricerca dell'applicativo token '" + String.valueOf(idApplicativoToken) + "': " + e.getMessage(), e);
                }
            }
            if (checkRuoloRegistro && saToken != null && saToken.getInvocazionePorta() != null && saToken.getInvocazionePorta().getRuoli() != null && saToken.getInvocazionePorta().getRuoli().sizeRuoloList() > 0) {
                for (int i = 0; i < saToken.getInvocazionePorta().getRuoli().sizeRuoloList(); ++i) {
                    applicativoTokenRoles.add(saToken.getInvocazionePorta().getRuoli().getRuolo(i).getNome());
                }
            }
        }
        if (checkRuoloEsterno && informazioniTokenNormalizzate != null && tokenRoles != null && !tokenRoles.isEmpty()) {
            try {
                FiltroRicercaRuoli filtroRicerca = new FiltroRicercaRuoli();
                if (datiPD != null) {
                    filtroRicerca.setContesto(RuoloContesto.PORTA_DELEGATA);
                } else if (datiPA != null) {
                    filtroRicerca.setContesto(RuoloContesto.PORTA_APPLICATIVA);
                }
                filtroRicerca.setTipologia(RuoloTipologia.ESTERNO);
                RegistroServiziManager registroServiziManager = RegistroServiziManager.getInstance((IState)datiInvocazione.getState());
                List list = registroServiziManager.getAllIdRuoli(filtroRicerca, null);
                if (list == null || list.size() <= 0) {
                    throw new DriverRegistroServiziNotFound();
                }
                for (IDRuolo idRuolo : list) {
                    String nomeRuoloDaVerificare = idRuolo.getNome();
                    try {
                        Ruolo ruoloRegistro = registroServiziManager.getRuolo(idRuolo.getNome(), null, datiInvocazione.getRequestInfo());
                        if (ruoloRegistro.getNomeEsterno() != null && !"".equals(ruoloRegistro.getNomeEsterno())) {
                            nomeRuoloDaVerificare = ruoloRegistro.getNomeEsterno();
                        }
                    }
                    catch (Exception e) {
                        throw new Exception("Recupero del ruolo '" + idRuolo.getNome() + "' fallito: " + e.getMessage(), e);
                    }
                    if (!informazioniTokenNormalizzate.getRoles().contains(nomeRuoloDaVerificare)) continue;
                    applicativoTokenRoles.add(idRuolo.getNome());
                }
                for (String role : tokenRoles) {
                    if (applicativoTokenRoles.contains(role)) continue;
                    applicativoTokenRoles.addAll(tokenRoles);
                }
            }
            catch (DriverRegistroServiziNotFound notFound) {
                if (!checkRuoloRegistro) {
                    throw new AutorizzazioneException("Non sono stati registrati ruoli utilizzabili con un'autorizzazione esterna");
                }
            }
            catch (Exception e) {
                throw new AutorizzazioneException("E' avvenuto un errore durante la ricerca dei ruoli: " + e.getMessage(), e);
            }
        }
        if (soggettoFruitore != null) {
            subjectId = soggettoFruitore.toString();
            if (nomeServizioApplicativo != null) {
                subjectId = nomeServizioApplicativo + "." + (String)subjectId;
            }
            xacmlRequest.addSubject((String)subjectId);
        } else if (credential != null) {
            subjectId = credential;
            xacmlRequest.addSubject((String)subjectId);
        }
        if (soggettoFruitore != null) {
            xacmlRequest.addSubjectAttribute("org:govway:subject:organization", soggettoFruitore.toString());
        }
        if (soggettoFruitoreConfig != null && !soggettoFruitoreConfig.isEmpty()) {
            for (String key : soggettoFruitoreConfig.keySet()) {
                value = soggettoFruitoreConfig.get(key);
                xacmlRequest.addSubjectAttribute("org:govway:subject:organization:config:" + key, (String)value);
            }
        }
        if (nomeServizioApplicativo != null) {
            xacmlRequest.addSubjectAttribute("org:govway:subject:client", nomeServizioApplicativo);
        }
        if (applicativoConfig != null && !applicativoConfig.isEmpty()) {
            for (String key : applicativoConfig.keySet()) {
                value = applicativoConfig.get(key);
                xacmlRequest.addSubjectAttribute("org:govway:subject:client:config:" + key, (String)value);
            }
        }
        if (credential != null) {
            xacmlRequest.addSubjectAttribute("org:govway:subject:credential", credential);
        }
        if (roles != null && roles.size() > 0) {
            xacmlRequest.addSubjectAttribute("org:govway:subject:role", roles);
        }
        if (informazioniTokenUserInfoNormalizzate != null) {
            if (informazioniTokenUserInfoNormalizzate.getFullName() != null) {
                xacmlRequest.addSubjectAttribute("org:govway:subject:token:userInfo:fullName", informazioniTokenUserInfoNormalizzate.getFullName());
            }
            if (informazioniTokenUserInfoNormalizzate.getFirstName() != null) {
                xacmlRequest.addSubjectAttribute("org:govway:subject:token:userInfo:firstName", informazioniTokenUserInfoNormalizzate.getFirstName());
            }
            if (informazioniTokenUserInfoNormalizzate.getMiddleName() != null) {
                xacmlRequest.addSubjectAttribute("org:govway:subject:token:userInfo:middleName", informazioniTokenUserInfoNormalizzate.getMiddleName());
            }
            if (informazioniTokenUserInfoNormalizzate.getFamilyName() != null) {
                xacmlRequest.addSubjectAttribute("org:govway:subject:token:userInfo:familyName", informazioniTokenUserInfoNormalizzate.getFamilyName());
            }
            if (informazioniTokenUserInfoNormalizzate.getEMail() != null) {
                xacmlRequest.addSubjectAttribute("org:govway:subject:token:userInfo:eMail", informazioniTokenUserInfoNormalizzate.getEMail());
            }
        }
        if (informazioniTokenNormalizzate != null) {
            if (informazioniTokenNormalizzate.getIss() != null) {
                xacmlRequest.addSubjectAttribute("org:govway:subject:token:issuer", informazioniTokenNormalizzate.getIss());
            }
            if (informazioniTokenNormalizzate.getSub() != null) {
                xacmlRequest.addSubjectAttribute("org:govway:subject:token:subject", informazioniTokenNormalizzate.getSub());
            }
            if (informazioniTokenNormalizzate.getUsername() != null) {
                xacmlRequest.addSubjectAttribute("org:govway:subject:token:username", informazioniTokenNormalizzate.getUsername());
            }
            if (informazioniTokenNormalizzate.getClientId() != null) {
                xacmlRequest.addSubjectAttribute("org:govway:subject:token:clientId", informazioniTokenNormalizzate.getClientId());
            }
        }
        if (userInfoClaims != null && userInfoClaims.size() > 0) {
            for (String key : userInfoClaims.keySet()) {
                value = userInfoClaims.get(key);
                key = XACMLPolicyUtilities.normalizeKeyClaim(key);
                XACMLPolicyUtilities.setSubjectAttribute(xacmlRequest, value, "org:govway:subject:token:userInfo:claim:" + key);
            }
        }
        if (attributeNames != null && !attributeNames.isEmpty()) {
            XACMLPolicyUtilities.setSubjectAttribute(xacmlRequest, attributeNames, "org:govway:subject:attributes");
        }
        if (attributes != null && attributes.size() > 0) {
            XACMLPolicyUtilities.addAttributes(xacmlRequest, attributes, multipleAA);
        }
        if (idApplicativoToken != null) {
            if (idApplicativoToken.getNome() != null) {
                xacmlRequest.addSubjectAttribute("org:govway:subject:token:client", idApplicativoToken.getNome());
            }
            if (applicativoTokenConfig != null && !applicativoTokenConfig.isEmpty()) {
                for (String key : applicativoTokenConfig.keySet()) {
                    value = applicativoTokenConfig.get(key);
                    xacmlRequest.addSubjectAttribute("org:govway:subject:token:client:config:" + key, (String)value);
                }
            }
            if (idApplicativoToken.getIdSoggettoProprietario() != null) {
                xacmlRequest.addSubjectAttribute("org:govway:subject:token:client:organization", idApplicativoToken.getIdSoggettoProprietario().toString());
            }
            if (soggettoProprietarioApplicativoTokenConfig != null && !soggettoProprietarioApplicativoTokenConfig.isEmpty()) {
                for (String key : soggettoProprietarioApplicativoTokenConfig.keySet()) {
                    value = soggettoProprietarioApplicativoTokenConfig.get(key);
                    xacmlRequest.addSubjectAttribute("org:govway:subject:token:client:organization:config:" + key, (String)value);
                }
            }
        }
        if (applicativoTokenRoles != null && applicativoTokenRoles.size() > 0) {
            xacmlRequest.addSubjectAttribute("org:govway:subject:token:client:role", applicativoTokenRoles);
        }
        xacmlRequest.createEnvironment();
        xacmlRequest.addResourceAttribute("___resource-id___", policyKey);
        if (httpServletRequest != null && httpServletRequest instanceof AutorizzazioneHttpServletRequest) {
            AutorizzazioneHttpServletRequest authHttpServletRequest = (AutorizzazioneHttpServletRequest)httpServletRequest;
            authHttpServletRequest.fillXacmlRequest(xacmlRequest);
        }
        return xacmlRequest;
    }

    private static Map<String, String> readConfig(PdDContext pddContext, MapKey<String> pName) {
        Object o = pddContext.getObject(pName);
        if (o != null && o instanceof Map) {
            return (Map)o;
        }
        return null;
    }

    private static void addAttributes(XacmlRequest xacmlRequest, Map<String, Serializable> attributesParam, boolean multipleAA) {
        block10: {
            if (attributesParam == null || attributesParam.isEmpty()) break block10;
            Object logAA = "";
            if (multipleAA) {
                for (String attrAuthName : attributesParam.keySet()) {
                    Serializable o = attributesParam.get(attrAuthName);
                    if (!(o instanceof Map)) continue;
                    try {
                        ArrayList<String> attributesNames = new ArrayList<String>();
                        Map attributes = (Map)((Object)o);
                        if (attributes != null && !attributes.isEmpty()) {
                            for (String attrName : attributes.keySet()) {
                                if (attributesNames.contains(attrName)) continue;
                                attributesNames.add(attrName);
                            }
                        }
                        Collections.sort(attributesNames);
                        String xacmlIdPrefix = "org:govway:subject:aa:" + attrAuthName + ":attribute:";
                        JSONUtils jsonUtils = JSONUtils.getInstance();
                        logAA = " (A.A. " + attrAuthName + ")";
                        for (String attributeName : attributesNames) {
                            XACMLPolicyUtilities.addAttribute(xacmlRequest, xacmlIdPrefix, attributes, attributeName, jsonUtils, (String)logAA);
                        }
                    }
                    catch (Throwable t) {
                        OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("addAttributes failed (A.A. " + attrAuthName + "): " + t.getMessage(), t);
                    }
                }
            } else {
                ArrayList<String> attributesNames = new ArrayList<String>();
                for (String attrName : attributesParam.keySet()) {
                    attributesNames.add(attrName);
                }
                Collections.sort(attributesNames);
                String xacmlIdPrefix = "org:govway:subject:attribute:";
                JSONUtils jsonUtils = JSONUtils.getInstance();
                for (String attributeName : attributesNames) {
                    XACMLPolicyUtilities.addAttribute(xacmlRequest, xacmlIdPrefix, attributesParam, attributeName, jsonUtils, (String)logAA);
                }
            }
        }
    }

    private static void addAttribute(XacmlRequest xacmlRequest, String xacmlIdPrefix, Map<String, Serializable> attributes, String attributeName, JSONUtils jsonUtils, String logAA) {
        Serializable oValue = attributes.get(attributeName);
        if (oValue != null) {
            try {
                String key = XACMLPolicyUtilities.normalizeKeyClaim(attributeName);
                XACMLPolicyUtilities.setSubjectAttribute(xacmlRequest, oValue, xacmlIdPrefix + key);
            }
            catch (Throwable t) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("addAttribute '" + attributeName + "' failed" + logAA + ": " + t.getMessage(), t);
            }
        }
    }

    private static String normalizeKeyClaim(String keyParam) {
        String key = keyParam;
        while (key.contains(".")) {
            key = key.replace(".", ":");
        }
        return key;
    }

    private static void setActionAttribute(XacmlRequest xacmlRequest, Object value, String claim) {
        XACMLPolicyUtilities.setAttribute(xacmlRequest, value, claim, true);
    }

    private static void setSubjectAttribute(XacmlRequest xacmlRequest, Object value, String claim) {
        XACMLPolicyUtilities.setAttribute(xacmlRequest, value, claim, false);
    }

    private static void setAttribute(XacmlRequest xacmlRequest, Object value, String claim, boolean action) {
        List<String> l;
        if (value != null && (l = TokenUtilities.getClaimValues(value)) != null && !l.isEmpty()) {
            if (l.size() > 1) {
                if (action) {
                    xacmlRequest.addActionAttribute(claim, l);
                } else {
                    xacmlRequest.addSubjectAttribute(claim, l);
                }
            } else if (action) {
                xacmlRequest.addActionAttribute(claim, l.get(0));
            } else {
                xacmlRequest.addSubjectAttribute(claim, l.get(0));
            }
        }
    }
}

