/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.behaviour.built_in.load_balance;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.TipoBehaviour;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.behaviour.BehaviourEmitDiagnosticException;
import org.openspcoop2.pdd.core.behaviour.BehaviourException;
import org.openspcoop2.pdd.core.behaviour.built_in.load_balance.LoadBalancer;
import org.openspcoop2.pdd.core.behaviour.built_in.load_balance.LoadBalancerInstance;
import org.openspcoop2.pdd.core.behaviour.built_in.load_balance.LoadBalancerPool;
import org.openspcoop2.pdd.core.behaviour.built_in.load_balance.LoadBalancerType;
import org.openspcoop2.pdd.core.behaviour.built_in.load_balance.health_check.HealthCheckUtils;
import org.openspcoop2.pdd.core.behaviour.built_in.load_balance.sticky.StickyConnector;
import org.openspcoop2.pdd.core.behaviour.built_in.load_balance.sticky.StickyResult;
import org.openspcoop2.pdd.core.behaviour.built_in.load_balance.sticky.StickyUtils;
import org.openspcoop2.pdd.core.behaviour.conditional.ConditionalFilterResult;
import org.openspcoop2.pdd.core.behaviour.conditional.ConditionalUtils;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.utils.PorteNamingUtils;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.cache.Cache;
import org.openspcoop2.utils.cache.CacheAlgorithm;
import org.openspcoop2.utils.cache.CacheResponse;
import org.openspcoop2.utils.cache.CacheType;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.slf4j.Logger;

public class GestoreLoadBalancerCaching {
    private static final String LOAD_BALANCER_CACHE_NAME = "consegnaApplicativi";
    private static Cache cache = null;
    private static final Semaphore lock = new Semaphore("GestoreLoadBalancerCaching");
    private static GestoreLoadBalancerCaching staticInstance = null;
    private Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();

    public static boolean isCacheAbilitata() {
        return cache != null;
    }

    public static void resetCache() throws Exception {
        try {
            if (cache != null) {
                cache.clear();
            }
        }
        catch (Exception e) {
            throw new Exception("Reset della cache per i dati contenenti i dati di bilanciamento del carico non riuscita: " + e.getMessage(), e);
        }
    }

    public static String printStatsCache(String separator) throws Exception {
        try {
            if (cache != null) {
                try {
                    return cache.printStats(separator);
                }
                catch (Exception e) {
                    throw new Exception(e.getMessage(), e);
                }
            }
            throw new Exception("Cache non abilitata");
        }
        catch (Exception e) {
            throw new Exception("Visualizzazione Statistiche riguardante la cache per i dati contenenti i dati di bilanciamento del carico non riuscita: " + e.getMessage(), e);
        }
    }

    public static void abilitaCache() throws Exception {
        try {
            if (cache != null) {
                throw new Exception("Cache gia' abilitata");
            }
            GestoreLoadBalancerCaching._abilitaCache();
        }
        catch (Exception e) {
            throw new Exception("Abilitazione cache per i dati contenenti i dati di bilanciamento del carico non riuscita: " + e.getMessage(), e);
        }
    }

    private static synchronized void _abilitaCache() throws Exception {
        try {
            if (cache == null) {
                cache = new Cache(CacheType.JCS, LOAD_BALANCER_CACHE_NAME);
                cache.build();
            }
        }
        catch (Exception e) {
            throw new Exception("Abilitazione cache per i dati contenenti i dati di bilanciamento del carico non riuscita: " + e.getMessage(), e);
        }
    }

    public static void abilitaCache(Long dimensioneCache, Boolean algoritmoCacheLRU, Long itemIdleTime, Long itemLifeSecond, Logger log) throws Exception {
        try {
            if (cache != null) {
                throw new Exception("Cache gia' abilitata");
            }
            int dimensione = -1;
            if (dimensioneCache != null) {
                dimensione = dimensioneCache.intValue();
            }
            GestoreLoadBalancerCaching.initCache(CacheType.JCS, (Integer)dimensione, algoritmoCacheLRU, itemIdleTime, itemLifeSecond, log);
        }
        catch (Exception e) {
            throw new Exception("Abilitazione cache per i dati contenenti i dati di bilanciamento del carico non riuscita: " + e.getMessage(), e);
        }
    }

    public static void disabilitaCache() throws Exception {
        try {
            if (cache == null) {
                throw new Exception("Cache gia' disabilitata");
            }
            GestoreLoadBalancerCaching._disabilitaCache();
        }
        catch (Exception e) {
            throw new Exception("Disabilitazione cache per i dati contenenti i dati di bilanciamento del carico non riuscita: " + e.getMessage(), e);
        }
    }

    private static synchronized void _disabilitaCache() throws Exception {
        try {
            if (cache != null) {
                cache.clear();
                cache = null;
            }
        }
        catch (Exception e) {
            throw new Exception("Disabilitazione cache per i dati contenenti i dati di bilanciamento del carico non riuscita: " + e.getMessage(), e);
        }
    }

    public static String listKeysCache(String separator) throws Exception {
        try {
            if (cache != null) {
                try {
                    return cache.printKeys(separator);
                }
                catch (Exception e) {
                    throw new Exception(e.getMessage(), e);
                }
            }
            throw new Exception("Cache non abilitata");
        }
        catch (Exception e) {
            throw new Exception("Visualizzazione chiavi presenti nella cache per i dati contenenti i dati di bilanciamento del carico non riuscita: " + e.getMessage(), e);
        }
    }

    public static List<String> keysCache() throws Exception {
        if (cache != null) {
            try {
                return cache.keys();
            }
            catch (Exception e) {
                throw new Exception(e.getMessage(), e);
            }
        }
        throw new Exception("Cache non abilitata");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getObjectCache(String key) throws Exception {
        if (cache == null) throw new Exception("Cache non abilitata");
        try {
            Object o = cache.get(key);
            if (o == null) return "oggetto con chiave [" + key + "] non presente";
            return o.toString();
        }
        catch (Exception e) {
            try {
                throw new Exception(e.getMessage(), e);
            }
            catch (Exception e2) {
                throw new Exception("Visualizzazione oggetto presente nella cache per i dati contenenti i dati di bilanciamento del carico non riuscita: " + e2.getMessage(), e2);
            }
        }
    }

    public static void removeObjectCache(String key) throws Exception {
        block5: {
            try {
                if (cache != null) {
                    try {
                        cache.remove(key);
                        break block5;
                    }
                    catch (Exception e) {
                        throw new Exception(e.getMessage(), e);
                    }
                }
                throw new Exception("Cache non abilitata");
            }
            catch (Exception e) {
                throw new Exception("Rimozione oggetto presente nella cache per i dati contenenti i dati di bilanciamento del carico non riuscita: " + e.getMessage(), e);
            }
        }
    }

    public static void removePortaApplicativa(IDPortaApplicativa idPA) throws Exception {
        if (cache != null) {
            IProtocolFactory protocolFactory = null;
            PorteNamingUtils namingUtils = null;
            try {
                ProtocolFactoryManager protocolFactoryManager = ProtocolFactoryManager.getInstance();
                String protocol = protocolFactoryManager.getProtocolByOrganizationType(idPA.getIdentificativiErogazione().getIdServizio().getSoggettoErogatore().getTipo());
                protocolFactory = protocolFactoryManager.getProtocolFactoryByName(protocol);
                namingUtils = new PorteNamingUtils(protocolFactory);
            }
            catch (Throwable t) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("Errore durante la comprensione del protocol factory della PA [" + String.valueOf(idPA) + "]");
            }
            String nomePorta = idPA.getNome();
            String nomePorta_normalized = null;
            if (namingUtils != null) {
                nomePorta_normalized = namingUtils.normalizePA(nomePorta);
            }
            String porta = GestoreLoadBalancerCaching._toKey_getKeyCacheNomePorta(nomePorta);
            String porta_normalized = null;
            if (nomePorta_normalized != null) {
                porta_normalized = GestoreLoadBalancerCaching._toKey_getKeyCacheNomePorta(nomePorta_normalized);
            }
            ArrayList<String> keyForClean = new ArrayList<String>();
            List<String> keys = GestoreLoadBalancerCaching.keysCache();
            if (keys != null && !keys.isEmpty()) {
                for (String key : keys) {
                    if (key == null) continue;
                    if (key.contains(porta)) {
                        keyForClean.add(key);
                        continue;
                    }
                    if (porta_normalized == null || !key.contains(porta_normalized)) continue;
                    keyForClean.add(key);
                }
            }
            if (keyForClean != null && !keyForClean.isEmpty()) {
                for (String key : keyForClean) {
                    GestoreLoadBalancerCaching.removeObjectCache(key);
                }
            }
        }
    }

    public static void initialize(Logger log) throws Exception {
        GestoreLoadBalancerCaching.initialize(null, false, -1, null, -1L, -1L, log);
    }

    public static void initialize(CacheType cacheType, int dimensioneCache, String algoritmoCache, long idleTime, long itemLifeSecond, Logger log) throws Exception {
        GestoreLoadBalancerCaching.initialize(cacheType, true, dimensioneCache, algoritmoCache, idleTime, itemLifeSecond, log);
    }

    private static void initialize(CacheType cacheType, boolean cacheAbilitata, int dimensioneCache, String algoritmoCache, long idleTime, long itemLifeSecond, Logger log) throws Exception {
        if (cacheAbilitata) {
            GestoreLoadBalancerCaching.initCache(cacheType, (Integer)dimensioneCache, algoritmoCache, (Long)idleTime, (Long)itemLifeSecond, log);
        }
    }

    private static void initCache(CacheType cacheType, Integer dimensioneCache, String algoritmoCache, Long itemIdleTime, Long itemLifeSecond, Logger alog) throws Exception {
        GestoreLoadBalancerCaching.initCache(cacheType, dimensioneCache, CostantiConfigurazione.CACHE_LRU.toString().equalsIgnoreCase(algoritmoCache), itemIdleTime, itemLifeSecond, alog);
    }

    private static void initCache(CacheType cacheType, Integer dimensioneCache, boolean algoritmoCacheLRU, Long itemIdleTime, Long itemLifeSecond, Logger alog) throws Exception {
        Object msg;
        cache = new Cache(cacheType, LOAD_BALANCER_CACHE_NAME);
        if (dimensioneCache != null && dimensioneCache > 0) {
            try {
                msg = "Dimensione della cache (ResponseCaching) impostata al valore: " + dimensioneCache;
                alog.info((String)msg);
                cache.setCacheSize(dimensioneCache.intValue());
            }
            catch (Exception error) {
                String msg2 = "Parametro errato per la dimensione della cache (ResponseCaching): " + error.getMessage();
                alog.error(msg2);
                throw new Exception(msg2, error);
            }
        }
        msg = "Algoritmo di cache (ResponseCaching) impostato al valore: LRU";
        if (!algoritmoCacheLRU) {
            msg = "Algoritmo di cache (ResponseCaching) impostato al valore: MRU";
        }
        alog.info((String)msg);
        if (!algoritmoCacheLRU) {
            cache.setCacheAlgoritm(CacheAlgorithm.MRU);
        } else {
            cache.setCacheAlgoritm(CacheAlgorithm.LRU);
        }
        if (itemIdleTime != null && itemIdleTime > 0L) {
            try {
                msg = "Attributo 'IdleTime' (ResponseCaching) impostato al valore: " + itemIdleTime;
                alog.info((String)msg);
                cache.setItemIdleTime(itemIdleTime.longValue());
            }
            catch (Exception error) {
                msg = "Parametro errato per l'attributo 'IdleTime' (ResponseCaching): " + error.getMessage();
                alog.error((String)msg);
                throw new Exception((String)msg, error);
            }
        }
        long longItemLife = -1L;
        if (itemLifeSecond != null && itemLifeSecond > 0L) {
            longItemLife = itemLifeSecond;
        }
        try {
            msg = "Attributo 'MaxLifeSecond' (ResponseCaching) impostato al valore: " + longItemLife;
            alog.info((String)msg);
            cache.setItemLifeTime(longItemLife);
        }
        catch (Exception error) {
            msg = "Parametro errato per l'attributo 'MaxLifeSecond' (ResponseCaching): " + error.getMessage();
            alog.error((String)msg);
            throw new Exception((String)msg, error);
        }
        cache.build();
    }

    @Deprecated
    public static void disableSyncronizedGet() throws UtilsException {
        if (cache == null) {
            throw new UtilsException("Cache disabled");
        }
        cache.disableSyncronizedGet();
    }

    @Deprecated
    public static boolean isDisableSyncronizedGet() throws UtilsException {
        if (cache == null) {
            throw new UtilsException("Cache disabled");
        }
        return cache.isDisableSyncronizedGet();
    }

    public static synchronized void initialize() {
        if (staticInstance == null) {
            staticInstance = new GestoreLoadBalancerCaching();
        }
    }

    public static GestoreLoadBalancerCaching getInstance() throws CoreException {
        if (staticInstance == null) {
            Class<GestoreLoadBalancerCaching> clazz = GestoreLoadBalancerCaching.class;
            synchronized (GestoreLoadBalancerCaching.class) {
                throw new CoreException("GestoreKeystore non inizializzato");
            }
        }
        return staticInstance;
    }

    private GestoreLoadBalancerCaching() {
    }

    public static LoadBalancerInstance getLoadBalancerInstance(PortaApplicativa pa, OpenSPCoop2Message message, Busta busta, RequestInfo requestInfo, PdDContext pddContext, MsgDiagnostico msgDiag, Logger log, LoadBalancerType loadBalancerType, IState state) throws BehaviourException, BehaviourEmitDiagnosticException {
        LoadBalancerInstance instance = new LoadBalancerInstance();
        ConditionalFilterResult filterResult = ConditionalUtils.filter(pa, message, busta, requestInfo, pddContext, msgDiag, log, TipoBehaviour.CONSEGNA_LOAD_BALANCE, state);
        String keyCache = GestoreLoadBalancerCaching.getKeyCache(pa, message, busta, requestInfo, pddContext, msgDiag, log, filterResult);
        String keyCacheLoadBalancerPool = "[POOL] " + keyCache;
        instance.setLoadBalancerPool(GestoreLoadBalancerCaching.getLoadBalancerPool(pa, message, busta, requestInfo, pddContext, msgDiag, log, keyCacheLoadBalancerPool, filterResult));
        StickyResult stickyResult = null;
        if (LoadBalancerType.IP_HASH.equals(loadBalancerType)) {
            String clientIp = LoadBalancer.getIpSourceFromContet(pddContext);
            stickyResult = new StickyResult();
            stickyResult.setCondition(clientIp);
            stickyResult.setFound(true);
        } else {
            stickyResult = GestoreLoadBalancerCaching.getStickyInfo(pa, message, busta, requestInfo, pddContext, msgDiag, log, state);
        }
        if (stickyResult != null && stickyResult.isFound()) {
            String keyCacheSticky = "[STICKY '" + stickyResult.getCondition() + "'] " + keyCache;
            instance.setConnectorSelected(GestoreLoadBalancerCaching.getNomeConnettore(pa, message, busta, requestInfo, pddContext, msgDiag, log, keyCacheSticky, instance.getLoadBalancerPool(), loadBalancerType, stickyResult));
        }
        if (instance.getConnectorSelected() == null) {
            instance.setConnectorSelected(GestoreLoadBalancerCaching.selectConnector(loadBalancerType, instance.getLoadBalancerPool(), pddContext));
        }
        return instance;
    }

    private static StickyResult getStickyInfo(PortaApplicativa pa, OpenSPCoop2Message message, Busta busta, RequestInfo requestInfo, PdDContext pddContext, MsgDiagnostico msgDiag, Logger log, IState state) throws BehaviourException, BehaviourEmitDiagnosticException {
        if (StickyUtils.isConfigurazioneSticky(pa, log)) {
            return StickyUtils.getStickyResult(pa, message, busta, requestInfo, pddContext, msgDiag, log, state);
        }
        return null;
    }

    protected static String _toKey_getKeyCacheNomePorta(String nomePorta) {
        return " pa:" + nomePorta + " ";
    }

    private static String getKeyCache(PortaApplicativa pa, OpenSPCoop2Message message, Busta busta, RequestInfo requestInfo, PdDContext pddContext, MsgDiagnostico msgDiag, Logger log, ConditionalFilterResult filterResult) throws BehaviourException, BehaviourEmitDiagnosticException {
        String keyCache = "[" + pa.getBehaviour().getNome() + "] " + pa.getTipoSoggettoProprietario() + "/" + pa.getNomeSoggettoProprietario() + GestoreLoadBalancerCaching._toKey_getKeyCacheNomePorta(pa.getNome());
        if (filterResult != null) {
            keyCache = filterResult.isByFilter() ? keyCache + " [Conditional-By-Filter] " : keyCache + " [Conditional-By-Name] ";
            if (filterResult.getRegola() != null) {
                keyCache = keyCache + "[Regola " + filterResult.getRegola() + "] ";
            }
            if (filterResult.getCondition() != null) {
                keyCache = keyCache + " " + filterResult.getCondition();
            }
        }
        return keyCache;
    }

    private static LoadBalancerPool getLoadBalancerPool(PortaApplicativa pa, OpenSPCoop2Message message, Busta busta, RequestInfo requestInfo, PdDContext pddContext, MsgDiagnostico msgDiag, Logger log, String keyCache, ConditionalFilterResult filterResult) throws BehaviourException, BehaviourEmitDiagnosticException {
        if (cache == null) {
            throw new BehaviourException("La funzionalit\u00e0 di Load Balancer richiede che sia abilitata la cache dedicata alla funzionalit\u00e0");
        }
        CacheResponse response = (CacheResponse)cache.get(keyCache);
        if (response != null) {
            if (response.getObject() != null) {
                log.debug("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (method:getLoadBalancerPool) in cache.");
                return (LoadBalancerPool)response.getObject();
            }
            if (response.getException() != null) {
                log.debug("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (method:getLoadBalancerPool) in cache.");
                throw new BehaviourException((Exception)response.getException());
            }
            log.error("In cache non e' presente ne un oggetto ne un'eccezione.");
        }
        String idTransazione = pddContext != null && pddContext.containsKey(Costanti.ID_TRANSAZIONE) ? PdDContext.getValue((MapKey<String>)Costanti.ID_TRANSAZIONE, pddContext) : null;
        SemaphoreLock lock = GestoreLoadBalancerCaching.lock.acquireThrowRuntime("getLoadBalancerPool", idTransazione);
        try {
            response = (CacheResponse)cache.get(keyCache);
            if (response != null) {
                if (response.getObject() != null) {
                    log.debug("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (method:getLoadBalancerPool) in cache.");
                    LoadBalancerPool loadBalancerPool = (LoadBalancerPool)response.getObject();
                    return loadBalancerPool;
                }
                if (response.getException() != null) {
                    log.debug("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (method:getLoadBalancerPool) in cache.");
                    throw new BehaviourException((Exception)response.getException());
                }
                log.error("In cache non e' presente ne un oggetto ne un'eccezione.");
            }
            log.debug("oggetto con chiave [" + keyCache + "] (method:getLoadBalancerPool) ricerco nella configurazione...");
            LoadBalancerPool lbPool = GestoreLoadBalancerCaching.readLoadBalancerPool(log, pa, filterResult);
            if (lbPool != null) {
                log.info("Aggiungo oggetto [" + keyCache + "] in cache");
                try {
                    CacheResponse responseCache = new CacheResponse();
                    responseCache.setObject((Serializable)lbPool);
                    cache.put(keyCache, responseCache);
                }
                catch (UtilsException e) {
                    log.error("Errore durante l'inserimento in cache [" + keyCache + "]: " + e.getMessage());
                }
                LoadBalancerPool loadBalancerPool = lbPool;
                return loadBalancerPool;
            }
            throw new BehaviourException("Metodo (getLoadBalancerPool) non \u00e8 riuscito a costruire un pool");
        }
        finally {
            GestoreLoadBalancerCaching.lock.release(lock, "getLoadBalancerPool", idTransazione);
        }
    }

    private static LoadBalancerPool readLoadBalancerPool(Logger log, PortaApplicativa pa, ConditionalFilterResult filterResult) throws BehaviourException {
        List<PortaApplicativaServizioApplicativo> listSA = null;
        listSA = filterResult == null ? pa.getServizioApplicativoList() : filterResult.getListServiziApplicativi();
        LoadBalancerPool pool = new LoadBalancerPool(HealthCheckUtils.read(pa, log));
        if (!listSA.isEmpty()) {
            for (PortaApplicativaServizioApplicativo servizioApplicativo : listSA) {
                if (servizioApplicativo.getDatiConnettore() != null && servizioApplicativo.getDatiConnettore().getStato() != null && !StatoFunzionalita.ABILITATO.equals((Object)servizioApplicativo.getDatiConnettore().getStato())) continue;
                int weight = -1;
                if (servizioApplicativo.getDatiConnettore() != null && servizioApplicativo.getDatiConnettore().sizeProprietaList() > 0) {
                    String weightDefined = null;
                    for (Proprieta p : servizioApplicativo.getDatiConnettore().getProprietaList()) {
                        if (!"weight".equals(p.getNome())) continue;
                        weightDefined = p.getValore();
                    }
                    if (weightDefined != null) {
                        try {
                            weight = Integer.valueOf(weightDefined);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                String nomeConnettore = null;
                if (servizioApplicativo.getDatiConnettore() != null) {
                    nomeConnettore = servizioApplicativo.getDatiConnettore().getNome();
                }
                if (nomeConnettore == null) {
                    nomeConnettore = "Default";
                }
                if (weight > 0) {
                    pool.addConnector(nomeConnettore, weight);
                    continue;
                }
                pool.addConnector(nomeConnettore);
            }
        }
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getNomeConnettore(PortaApplicativa pa, OpenSPCoop2Message message, Busta busta, RequestInfo requestInfo, PdDContext pddContext, MsgDiagnostico msgDiag, Logger log, String keyCache, LoadBalancerPool loadBalancerPool, LoadBalancerType loadBalancerType, StickyResult stickyResult) throws BehaviourException, BehaviourEmitDiagnosticException {
        if (cache == null) {
            throw new BehaviourException("La funzionalit\u00e0 di Load Balancer richiede che sia abilitata la cache dedicata alla funzionalit\u00e0");
        }
        CacheResponse response = (CacheResponse)cache.get(keyCache);
        if (response != null) {
            if (response.getObject() != null) {
                log.debug("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (method:getLoadBalancerPool) in cache.");
                StickyConnector stickyConnector = (StickyConnector)response.getObject();
                if (stickyConnector.getExpirationDate() != null) {
                    Date now = DateManager.getDate();
                    if (stickyConnector.getExpirationDate().after(now)) {
                        String c = stickyConnector.getConnector();
                        if (loadBalancerPool.getConnectorNames(true).contains(c)) {
                            return c;
                        }
                    }
                } else {
                    String c = stickyConnector.getConnector();
                    if (loadBalancerPool.getConnectorNames(true).contains(c)) {
                        return c;
                    }
                }
            } else {
                if (response.getException() != null) {
                    log.debug("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (method:getLoadBalancerPool) in cache.");
                    throw new BehaviourException((Exception)response.getException());
                }
                log.error("In cache non e' presente ne un oggetto ne un'eccezione.");
            }
        }
        String idTransazione = pddContext != null && pddContext.containsKey(Costanti.ID_TRANSAZIONE) ? PdDContext.getValue((MapKey<String>)Costanti.ID_TRANSAZIONE, pddContext) : null;
        SemaphoreLock lock = GestoreLoadBalancerCaching.lock.acquireThrowRuntime("getNomeConnettore", idTransazione);
        try {
            response = (CacheResponse)cache.get(keyCache);
            if (response != null) {
                if (response.getObject() != null) {
                    log.debug("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (method:getLoadBalancerPool) in cache.");
                    StickyConnector stickyConnector = (StickyConnector)response.getObject();
                    if (stickyConnector.getExpirationDate() != null) {
                        Date now = DateManager.getDate();
                        if (stickyConnector.getExpirationDate().after(now)) {
                            String c = stickyConnector.getConnector();
                            if (loadBalancerPool.getConnectorNames(true).contains(c)) {
                                String string = c;
                                return string;
                            }
                            String msg = "Connettore '" + stickyConnector.getConnector() + "' per sticky '" + stickyResult.getCondition() + "' non risulta pi\u00f9 valido dopo il passive health check";
                            log.debug(msg);
                            try {
                                cache.remove(keyCache);
                            }
                            catch (Exception e) {
                                throw new BehaviourException(msg + ". Rimozione dalla cache non riuscita: " + e.getMessage(), e);
                            }
                        } else {
                            msg = "Connettore '" + stickyConnector.getConnector() + "' scaduto per sticky '" + stickyResult.getCondition() + "' in data " + DateUtils.getSimpleDateFormatMs().format(stickyConnector.getExpirationDate());
                            log.debug(msg);
                            try {
                                cache.remove(keyCache);
                            }
                            catch (Exception e) {
                                throw new BehaviourException((String)msg + ". Rimozione dalla cache non riuscita: " + e.getMessage(), e);
                            }
                        }
                    } else {
                        String c = stickyConnector.getConnector();
                        if (loadBalancerPool.getConnectorNames(true).contains(c)) {
                            String msg = c;
                            return msg;
                        }
                        msg = "Connettore '" + stickyConnector.getConnector() + "' per sticky '" + stickyResult.getCondition() + "' non risulta pi\u00f9 valido dopo il passive health check";
                        log.debug(msg);
                        try {
                            cache.remove(keyCache);
                        }
                        catch (Exception e) {
                            throw new BehaviourException(msg + ". Rimozione dalla cache non riuscita: " + e.getMessage(), e);
                        }
                    }
                } else {
                    if (response.getException() != null) {
                        log.debug("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (method:getLoadBalancerPool) in cache.");
                        throw new BehaviourException((Exception)response.getException());
                    }
                    log.error("In cache non e' presente ne un oggetto ne un'eccezione.");
                }
            }
            log.debug("oggetto con chiave [" + keyCache + "] (method:getNomeConnettore) ricerco nella configurazione...");
            String selectedConnector = GestoreLoadBalancerCaching.selectConnector(loadBalancerType, loadBalancerPool, pddContext);
            if (selectedConnector == null) {
                throw new BehaviourException("Metodo (getNomeConnettore) non \u00e8 riuscito a selezionare un connettore");
            }
            StickyConnector stickyConnector = new StickyConnector();
            stickyConnector.setConnector(selectedConnector);
            if (stickyResult.getMaxAgeSeconds() != null && stickyResult.getMaxAgeSeconds() > 0) {
                Date expire = new Date(DateManager.getTimeMillis() + (long)(1000 * stickyResult.getMaxAgeSeconds()));
                stickyConnector.setExpirationDate(expire);
            }
            log.info("Aggiungo oggetto [" + keyCache + "] in cache");
            try {
                CacheResponse responseCache = new CacheResponse();
                responseCache.setObject((Serializable)stickyConnector);
                cache.put(keyCache, responseCache);
            }
            catch (UtilsException e) {
                log.error("Errore durante l'inserimento in cache [" + keyCache + "]: " + e.getMessage());
            }
            String string = stickyConnector.getConnector();
            return string;
        }
        finally {
            GestoreLoadBalancerCaching.lock.release(lock, "getNomeConnettore", idTransazione);
        }
    }

    private static String selectConnector(LoadBalancerType loadBalancerType, LoadBalancerPool pool, PdDContext pddContext) throws BehaviourException {
        LoadBalancer lb = new LoadBalancer(loadBalancerType, pool, pddContext);
        String nomeConnettore = lb.selectConnector();
        if (nomeConnettore == null) {
            throw new BehaviourException("Nessun connettore selezionato");
        }
        return nomeConnettore;
    }
}

