/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.behaviour.built_in.load_balance;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.behaviour.BehaviourException;
import org.openspcoop2.pdd.core.behaviour.built_in.load_balance.health_check.HealthCheckConfigurazione;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;

public class LoadBalancerPool
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static int DEFAULT_WEIGHT = 1;
    private HealthCheckConfigurazione healthCheck = null;
    private boolean debug = false;
    private transient Semaphore _lock = null;
    protected Map<String, Integer> connectorMap = new HashMap<String, Integer>();
    protected Map<String, Integer> connectorMap_activeConnections = new HashMap<String, Integer>();
    protected Map<String, Date> connectorMap_errorDate = new HashMap<String, Date>();
    private int totalWeight = 0;
    private int position = -1;
    private transient Semaphore _lockLeastConnectionsIndex = null;
    private int leastConnectionsIndex = 0;

    public LoadBalancerPool(HealthCheckConfigurazione healthCheck) {
        this.healthCheck = healthCheck;
        this.debug = OpenSPCoop2Properties.getInstance().isLoadBalancerDebug();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        SemaphoreLock lock = this.getLock().acquireThrowRuntime("toString");
        try {
            StringBuilder bf = new StringBuilder();
            bf.append("Connectors: ").append(this.connectorMap.size());
            bf.append("\nTotal Weight: ").append(this.totalWeight);
            bf.append("\nPosition: ").append(this.position);
            if (this.healthCheck != null) {
                bf.append("\nPassiveHealtCheck: ").append(this.healthCheck.isPassiveCheckEnabled());
                if (this.healthCheck.isPassiveCheckEnabled()) {
                    bf.append("\n  Exclude for seconds: ").append(this.healthCheck.getPassiveHealthCheck_excludeForSeconds());
                }
            }
            for (String name : this.connectorMap.keySet()) {
                bf.append("\n");
                bf.append("- ").append(name).append(" : ").append(" ( weight:").append(this.connectorMap.get(name));
                if (this.connectorMap_activeConnections.containsKey(name)) {
                    bf.append(" activeConnections:").append(this.connectorMap_activeConnections.get(name));
                }
                if (this.connectorMap_errorDate.containsKey(name)) {
                    bf.append(" connectionError:").append(DateUtils.getSimpleDateFormatMs().format(this.connectorMap_errorDate.get(name)));
                }
                bf.append(" )");
            }
            String string = bf.toString();
            return string;
        }
        finally {
            this.getLock().release(lock, "toString");
        }
    }

    private synchronized void initLock() {
        if (this._lock == null) {
            this._lock = new Semaphore("LoadBalancerPool");
        }
    }

    public Semaphore getLock() {
        if (this._lock == null) {
            this.initLock();
        }
        return this._lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextPosition(boolean checkByWeight) throws BehaviourException {
        if (!this.isPassiveHealthCheck()) {
            SemaphoreLock lock = this.getLock().acquireThrowRuntime("getNextPosition(active)");
            try {
                int n = this._getNextPosition(checkByWeight);
                return n;
            }
            finally {
                this.getLock().release(lock, "getNextPosition(active)");
            }
        }
        SemaphoreLock lock = this.getLock().acquireThrowRuntime("getNextPosition(passive)");
        try {
            int pos = this._getNextPosition(checkByWeight);
            Set<String> setOriginal = this.connectorMap.keySet();
            ArrayList<String> serverList = new ArrayList<String>();
            if (checkByWeight) {
                serverList.addAll(this.getWeightList(false));
            } else {
                serverList.addAll(setOriginal);
            }
            Set<String> setAfterPassiveHealthCheck = this.passiveHealthCheck(setOriginal, false);
            String selectedConnector = (String)serverList.get(pos);
            if (setAfterPassiveHealthCheck.contains(selectedConnector)) {
                int n = pos;
                return n;
            }
            int nextPos = this._getNextPosition(checkByWeight);
            while (nextPos != pos) {
                selectedConnector = (String)serverList.get(nextPos);
                if (setAfterPassiveHealthCheck.contains(selectedConnector)) {
                    int n = nextPos;
                    return n;
                }
                nextPos = this._getNextPosition(checkByWeight);
            }
            throw new BehaviourException("Nessun connettore selezionabile (passive health check)");
        }
        finally {
            this.getLock().release(lock, "getNextPosition(passive)");
        }
    }

    private int _getNextPosition(boolean checkByWeight) {
        ++this.position;
        if (checkByWeight) {
            if (this.position == this.totalWeight) {
                this.position = 0;
            }
        } else if (this.position == this.connectorMap.size()) {
            this.position = 0;
        }
        return this.position;
    }

    public List<String> getWeightList(boolean passiveHealthCheck) throws BehaviourException {
        Set<String> servers = this.getConnectorNames(passiveHealthCheck);
        if (servers.isEmpty()) {
            throw new BehaviourException("Nessun connettore selezionabile (passive health check)");
        }
        ArrayList<String> serverList = new ArrayList<String>();
        for (String server : servers) {
            Integer weight = this.getWeight(server);
            if (weight == null || weight <= 0) {
                weight = DEFAULT_WEIGHT;
            }
            for (int i = 0; i < weight; ++i) {
                serverList.add(server);
            }
        }
        this.debug("weightList (passiveHealthCheck:" + passiveHealthCheck + "): " + String.valueOf(serverList));
        return serverList;
    }

    private synchronized void initLockLeastConnectionsIndex() {
        if (this._lockLeastConnectionsIndex == null) {
            this._lockLeastConnectionsIndex = new Semaphore("LoadBalancerPoolLeastConnections");
        }
    }

    public Semaphore getLockLeastConnectionsIndex() {
        if (this._lockLeastConnectionsIndex == null) {
            this.initLockLeastConnectionsIndex();
        }
        return this._lockLeastConnectionsIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNextLeastConnectionsConnector(int min, List<String> listMin) {
        if (listMin == null || listMin.isEmpty()) {
            return null;
        }
        SemaphoreLock lock = this.getLockLeastConnectionsIndex().acquireThrowRuntime("getNextLeastConnectionsIndex");
        try {
            int c = 0;
            if (this.leastConnectionsIndex < listMin.size()) {
                c = this.leastConnectionsIndex;
            }
            ++this.leastConnectionsIndex;
            this.debug("getNextConnectorLeastConnections minActiveConnections[" + min + "] (ConnettoreSelezionato:" + c + "): " + String.valueOf(listMin));
            String string = listMin.get(c);
            return string;
        }
        finally {
            this.getLockLeastConnectionsIndex().release(lock, "getNextLeastConnectionsIndex");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNextConnectorLeastConnections() {
        SemaphoreLock lock = this.getLock().acquireThrowRuntime("getNextConnectorLeastConnections");
        try {
            this.debug("getNextConnectorLeastConnections situazione iniziale (" + String.valueOf(this.connectorMap_activeConnections) + ")");
            Set<String> setKeys = this.passiveHealthCheck(this.connectorMap.keySet(), false);
            ArrayList<String> listMin = new ArrayList<String>();
            int min = 0;
            if (!this.connectorMap_activeConnections.isEmpty()) {
                min = Integer.MAX_VALUE;
                for (String name : setKeys) {
                    if (!this.connectorMap_activeConnections.containsKey(name)) {
                        if (min != 0) {
                            min = 0;
                            listMin.clear();
                        }
                        listMin.add(name);
                        continue;
                    }
                    int active = this.connectorMap_activeConnections.get(name);
                    if (active < min) {
                        min = active;
                        listMin.clear();
                        listMin.add(name);
                        continue;
                    }
                    if (active != min) continue;
                    listMin.add(name);
                }
            }
            if (listMin.isEmpty()) {
                listMin.addAll(setKeys);
                this.debug("getNextConnectorLeastConnections: list is empty");
            }
            String string = this.getNextLeastConnectionsConnector(min, listMin);
            return string;
        }
        finally {
            this.getLock().release(lock, "getNextConnectorLeastConnections");
        }
    }

    public boolean isEmpty() {
        return this.connectorMap.isEmpty();
    }

    public Set<String> getConnectorNames(boolean passiveHealthCheck) {
        if (passiveHealthCheck) {
            return this.passiveHealthCheck(this.connectorMap.keySet(), true);
        }
        return this.connectorMap.keySet();
    }

    public int getWeight(String name) {
        return this.connectorMap.get(name);
    }

    public void addConnector(String name) throws BehaviourException {
        this.addConnector(name, DEFAULT_WEIGHT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnector(String name, int weight) throws BehaviourException {
        SemaphoreLock lock = this.getLock().acquireThrowRuntime("addConnector");
        try {
            if (this.connectorMap.containsKey(name)) {
                throw new BehaviourException("Already exists connector '" + name + "'");
            }
            this.connectorMap.put(name, weight);
            this.totalWeight += weight;
        }
        finally {
            this.getLock().release(lock, "addConnector");
        }
    }

    public void registerConnectionError(String name) throws BehaviourException {
        SemaphoreLock lock = this.getLock().acquireThrowRuntime("registerConnectionError");
        try {
            if (!this.connectorMap_errorDate.containsKey(name)) {
                this.debug("Registrazione errore di connessione per connettore [" + name + "]");
                this.connectorMap_errorDate.put(name, DateManager.getDate());
            } else {
                this.debug("Registrazione non effettuata dell'errore di connessione per connettore [" + name + "]: gia' presente una entry");
            }
        }
        finally {
            this.getLock().release(lock, "registerConnectionError");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActiveConnection(String name) throws BehaviourException {
        SemaphoreLock lock = this.getLock().acquireThrowRuntime("addActiveConnection");
        try {
            int activeConnections = 0;
            if (this.connectorMap_activeConnections.containsKey(name)) {
                activeConnections = this.connectorMap_activeConnections.remove(name);
            }
            this.connectorMap_activeConnections.put(name, ++activeConnections);
            this.debug("Registrazione connessione attiva per connettore [" + name + "] (active:" + activeConnections + ")");
        }
        finally {
            this.getLock().release(lock, "addActiveConnection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActiveConnection(String name) throws BehaviourException {
        SemaphoreLock lock = this.getLock().acquireThrowRuntime("removeActiveConnection");
        try {
            int activeConnections = 0;
            if (this.connectorMap_activeConnections.containsKey(name)) {
                activeConnections = this.connectorMap_activeConnections.remove(name);
            }
            if (--activeConnections > 0) {
                this.connectorMap_activeConnections.put(name, activeConnections);
            }
            this.debug("Rimozione connessione attiva per connettore [" + name + "] (active:" + activeConnections + ")");
        }
        finally {
            this.getLock().release(lock, "removeActiveConnection");
        }
    }

    protected boolean isPassiveHealthCheck() {
        return this.healthCheck != null && this.healthCheck.isPassiveCheckEnabled() && this.healthCheck.getPassiveHealthCheck_excludeForSeconds() != null && this.healthCheck.getPassiveHealthCheck_excludeForSeconds() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<String> passiveHealthCheck(Set<String> set, boolean syncErase) {
        if (!this.isPassiveHealthCheck()) return set;
        if (this.connectorMap_errorDate.isEmpty()) {
            return set;
        }
        Date now = DateManager.getDate();
        this.debug("Passive Health Check della lista: " + String.valueOf(set));
        HashSet<String> newSet = new HashSet<String>();
        ArrayList<String> listRimuoviDate = new ArrayList<String>();
        for (String name : set) {
            block15: {
                if (this.connectorMap_errorDate.containsKey(name)) {
                    Date registrationDate = this.connectorMap_errorDate.get(name);
                    long registrationDateLong = registrationDate.getTime();
                    long registrationDateExpired = registrationDateLong + (long)(this.healthCheck.getPassiveHealthCheck_excludeForSeconds() * 1000);
                    if (registrationDateExpired < now.getTime()) {
                        this.debug("(PassiveHealthCheck) Rilevato errore di connessione scaduto per connettore [" + name + "]");
                        listRimuoviDate.add(name);
                        break block15;
                    } else {
                        this.debug("(PassiveHealthCheck) Rilevato errore di connessione non ancora scaduto per connettore [" + name + "]");
                        continue;
                    }
                }
                this.debug("(PassiveHealthCheck) Non \u00e8 presente alcun errore di connessione per il connettore [" + name + "]");
            }
            newSet.add(name);
        }
        if (listRimuoviDate != null && !listRimuoviDate.isEmpty()) {
            this.debug("(PassiveHealthCheck) lista di errori di connessione scaduti: " + String.valueOf(listRimuoviDate));
            if (syncErase) {
                SemaphoreLock lock = this.getLock().acquireThrowRuntime("passiveHealthCheck(date)");
                try {
                    this.cleanErrorDate(listRimuoviDate, now);
                }
                finally {
                    this.getLock().release(lock, "passiveHealthCheck(date)");
                }
            } else {
                this.cleanErrorDate(listRimuoviDate, now);
            }
        }
        if (!newSet.isEmpty()) {
            this.debug("(PassiveHealthCheck) lista di connettori validi: " + String.valueOf(newSet));
            return newSet;
        }
        this.debug("(PassiveHealthCheck) !!FULL!! tutti i connettori del pool risultano sospesi per errori di connessione: " + String.valueOf(this.connectorMap_errorDate.keySet()));
        Date dateCleaner = DateManager.getDate();
        SemaphoreLock lock = this.getLock().acquireThrowRuntime("passiveHealthCheck(cleanAllErrorDate)");
        try {
            this.cleanAllErrorDate(dateCleaner);
            return set;
        }
        finally {
            this.getLock().release(lock, "passiveHealthCheck(cleanAllErrorDate)");
        }
    }

    private void cleanErrorDate(List<String> listRimuoviDate, Date now) {
        ArrayList<String> listDaRimuovere = new ArrayList<String>();
        for (String name : listRimuoviDate) {
            if (!this.connectorMap_errorDate.containsKey(name)) continue;
            Date registrationDate = this.connectorMap_errorDate.get(name);
            long registrationDateLong = registrationDate.getTime();
            long registrationDateExpired = registrationDateLong + (long)(this.healthCheck.getPassiveHealthCheck_excludeForSeconds() * 1000);
            if (registrationDateExpired < now.getTime()) {
                this.debug("Registro da eliminare l'informazione sull'errore di connessione per il connettore [" + name + "]");
                listDaRimuovere.add(name);
                continue;
            }
            this.debug("Non registro da eliminare l'informazione sull'errore di connessione per il connettore [" + name + "]: la data di registrazione e' stata aggiornata");
        }
        if (!listDaRimuovere.isEmpty()) {
            for (String name : listDaRimuovere) {
                this.debug("Elimino l'informazione sull'errore di connessione per il connettore [" + name + "]");
                this.connectorMap_errorDate.remove(name);
            }
        }
    }

    private void cleanAllErrorDate(Date now) {
        this.debug("(HealthCheck) lista di errori di connessione prima della pulizia totale: " + String.valueOf(this.connectorMap_errorDate.keySet()));
        ArrayList<String> listDaRimuovere = new ArrayList<String>();
        for (String name : this.connectorMap_errorDate.keySet()) {
            Date registrationDate = this.connectorMap_errorDate.get(name);
            if (registrationDate.before(now)) {
                this.debug("(HealthCheck) Registro da eliminare l'informazione sull'errore di connessione per il connettore [" + name + "]");
                listDaRimuovere.add(name);
                continue;
            }
            this.debug("(HealthCheck) Non registro da eliminare l'informazione sull'errore di connessione per il connettore [" + name + "]: la data di registrazione e' stata aggiornata");
        }
        if (!listDaRimuovere.isEmpty()) {
            for (String name : listDaRimuovere) {
                this.debug("(HealthCheck) Elimino l'informazione sull'errore di connessione per il connettore [" + name + "]");
                this.connectorMap_errorDate.remove(name);
            }
        }
        this.debug("(HealthCheck) lista di errori di connessione terminata la pulizia totale: " + String.valueOf(this.connectorMap_errorDate.keySet()));
    }

    private void debug(String msg) {
        if (this.debug) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopConnettori().debug(msg);
        }
    }
}

