/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.behaviour.built_in.load_balance.sticky;

import org.apache.cxf.common.util.StringUtils;
import org.openspcoop2.pdd.core.behaviour.BehaviourException;

public class StickyCookieConfig {
    private String name;
    private String domain;
    private String path;

    public StickyCookieConfig(String cookie) throws BehaviourException {
        String formato = "name[[;domain=<domainValue>][;path=<pathValue>]]";
        if (cookie.contains(";")) {
            String[] split = cookie.split(";");
            if (split == null || split.length <= 0) {
                throw new BehaviourException("Formato cookie fornito non valido (cookie:'" + cookie + "' errCode:1); il formato atteso \u00e8 '" + formato + "'");
            }
            if (split.length > 3) {
                throw new BehaviourException("Formato cookie fornito non valido (cookie:'" + cookie + "' error:'troppe parti (" + split.length + ")'); il formato atteso \u00e8 '" + formato + "'");
            }
            for (int i = 0; i < split.length; ++i) {
                String v = split[i].trim();
                if (StringUtils.isEmpty((String)v)) {
                    throw new BehaviourException("Formato cookie fornito non valido (cookie:'" + cookie + "' part:'" + v + "' error:'empty'); il formato atteso \u00e8 '" + formato + "'");
                }
                if (i == 0) {
                    if (v.contains(";")) {
                        throw new BehaviourException("Formato cookie fornito non valido (cookie:'" + cookie + "' part:'" + v + "' error:'; non atteso'); il formato atteso \u00e8 '" + formato + "'");
                    }
                    this.name = v;
                    continue;
                }
                if (!v.contains("=")) {
                    throw new BehaviourException("Formato cookie fornito non valido (cookie:'" + cookie + "' part:'" + v + "' error:'= non trovato'); il formato atteso \u00e8 '" + formato + "'");
                }
                String[] internalSplit = v.split("=");
                if (internalSplit == null) {
                    throw new BehaviourException("Formato cookie fornito non valido (cookie:'" + cookie + "' part:'" + v + "' error:'struttura non valida (split null)'); il formato atteso \u00e8 '" + formato + "'");
                }
                if (internalSplit.length != 2) {
                    throw new BehaviourException("Formato cookie fornito non valido (cookie:'" + cookie + "' part:'" + v + "' error:'struttura non valida (split:" + internalSplit.length + ")'); il formato atteso \u00e8 '" + formato + "'");
                }
                if ("domain".equals(internalSplit[0].trim())) {
                    this.domain = internalSplit[1];
                    if (this.domain != null) {
                        this.domain = this.domain.trim();
                    }
                    if (!StringUtils.isEmpty((String)this.domain)) continue;
                    this.domain = null;
                    continue;
                }
                if ("path".equals(internalSplit[0].trim())) {
                    this.path = internalSplit[1];
                    if (this.path != null) {
                        this.path = this.path.trim();
                    }
                    if (!StringUtils.isEmpty((String)this.path)) continue;
                    this.path = null;
                    continue;
                }
                throw new BehaviourException("Formato cookie fornito non valido (cookie:'" + cookie + "' part:'" + v + "' error:'elemento " + internalSplit[0] + " sconosciuto'); il formato atteso \u00e8 '" + formato + "'");
            }
        } else {
            this.name = cookie;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

