/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import jakarta.xml.soap.SOAPBody;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.config.ResponseCachingConfigurazione;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.soap.TunnelSoapUtils;
import org.openspcoop2.pdd.core.connettori.ConnettoreBaseWithResponse;
import org.openspcoop2.pdd.core.connettori.ConnettoreException;
import org.openspcoop2.pdd.core.connettori.ConnettoreFile_outputConfig;
import org.openspcoop2.pdd.core.connettori.ConnettoreLogger;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.core.dynamic.DynamicInfo;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsMultiException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.transport.TransportUtils;

public class ConnettoreFILE
extends ConnettoreBaseWithResponse {
    public ByteArrayOutputStream outByte = new ByteArrayOutputStream();
    private ConnettoreFile_outputConfig outputFile = null;
    private ConnettoreFile_outputConfig outputFileHeaders = null;
    private boolean outputFileAutoCreateParentDirectory = false;
    private boolean outputFileOverwriteIfExists = false;
    private boolean generateResponse = false;
    private File inputFile = null;
    private File inputFileHeaders = null;
    private boolean inputFileDeleteAfterRead = false;
    private Integer inputFileWaitTimeIfNotExists;
    private ByteArrayOutputStream boutFileOutputHeaders;
    private static final String REQUEST = "Request";
    private static final String REQUEST_HEADERS = "Request-Headers";
    private static final String RESPONSE = "Response";
    private static final String RESPONSE_HEADERS = "Response-Headers";
    public static final String PERMESSI_FORMATO = "[o/a]+/-rwx";

    @Override
    public String getProtocollo() {
        return "FILE";
    }

    public String buildLocation(ConnettoreMsg request) throws ConnettoreException {
        this.properties = request.getConnectorProperties();
        Map<String, Object> dynamicMap = this.buildDynamicMap(request);
        String tmp = this.getDynamicProperty(request.getTipoConnettore(), true, "outputFile", dynamicMap);
        File f = new File(tmp);
        Object l = f.getAbsolutePath();
        tmp = this.getDynamicProperty(request.getTipoConnettore(), false, "outputFileHeaders", dynamicMap);
        if (tmp != null) {
            l = (String)l + " [headers: " + new File(tmp).getAbsolutePath() + "]";
        }
        return l;
    }

    @Override
    protected boolean initializePreSend(ResponseCachingConfigurazione responseCachingConfig, ConnettoreMsg request) {
        return this.initialize(request, true, responseCachingConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean send(ConnettoreMsg request) {
        try {
            this.checkContentType = true;
            if (this.idModulo != null) {
                this.checkContentType = "ConsegnaContenutiApplicativi".equals(this.idModulo) ? this.openspcoopProperties.isControlloContentTypeAbilitatoRicezioneBuste() : this.openspcoopProperties.isControlloContentTypeAbilitatoRicezioneContenutiApplicativi();
            }
            HashMap<String, Object> dynamicMap = new HashMap<String, Object>();
            DynamicInfo dInfo = new DynamicInfo(request, this.getPddContext());
            DynamicUtils.fillDynamicMap(this.logger.getLogger(), dynamicMap, dInfo);
            this.idModulo = request.getIdModulo();
            this.outRequestContext = request.getOutRequestContext();
            this.msgDiagnostico = request.getMsgDiagnostico();
            this.outputFile = this.readOutputConfig(request.getTipoConnettore(), true, "outputFile", "outputFilePermissions");
            if (this.outputFile == null || this.outputFile.getOutputFile() == null) {
                return false;
            }
            this.outputFileHeaders = this.readOutputConfig(request.getTipoConnettore(), false, "outputFileHeaders", "outputFileHeadersPermissions");
            this.location = this.outputFile.getOutputFile().getAbsolutePath();
            if (this.outputFileHeaders != null) {
                this.location = this.location + " [headers: " + this.outputFileHeaders.getOutputFile().getAbsolutePath() + "]";
            }
            this.outputFileAutoCreateParentDirectory = this.isBooleanProperty(request.getTipoConnettore(), false, "outputFileAutoCreateParentDirectory");
            this.outputFileOverwriteIfExists = this.isBooleanProperty(request.getTipoConnettore(), false, "outputFileOverwriteIfExists");
            this.generateResponse = this.isBooleanProperty(request.getTipoConnettore(), false, "response");
            if (this.generateResponse) {
                String tmp = this.getDynamicProperty(request.getTipoConnettore(), true, "inputFile", dynamicMap);
                if (tmp == null) {
                    return false;
                }
                this.inputFile = new File(tmp);
                tmp = this.getDynamicProperty(request.getTipoConnettore(), false, "inputFileHeaders", dynamicMap);
                if (tmp != null) {
                    this.inputFileHeaders = new File(tmp);
                }
                this.inputFileDeleteAfterRead = this.isBooleanProperty(request.getTipoConnettore(), false, "inputFileDeleteAfterRead");
                this.inputFileWaitTimeIfNotExists = this.getIntegerProperty(request.getTipoConnettore(), false, "inputFileWaitTimeIfNotExists");
            }
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            this.errore = "Errore avvenuto durante la consegna su FileSystem: " + this.readExceptionMessageFromException(e);
            this.logger.error("Errore avvenuto durante la consegna su FileSystem: " + this.readExceptionMessageFromException(e), e);
            return false;
        }
        int readConnectionTimeout = -1;
        boolean readConnectionTimeoutConfigurazioneGlobale = true;
        try {
            Object bout;
            this.checkOutputFile(this.outputFile, REQUEST);
            if (this.outputFileHeaders != null) {
                this.checkOutputFile(this.outputFileHeaders, REQUEST_HEADERS);
            }
            MessageType requestMessageType = this.requestMsg.getMessageType();
            OpenSPCoop2SoapMessage soapMessageRequest = null;
            if (this.debug) {
                this.logger.debug("Tipologia Servizio: " + String.valueOf(this.requestMsg.getServiceBinding()));
            }
            if (this.isSoap) {
                soapMessageRequest = this.requestMsg.castAsSoap();
            }
            this.requestMsg.updateContentType();
            this.boutFileOutputHeaders = new ByteArrayOutputStream();
            HashMap<String, List<String>> propertiesTrasportoDebug = null;
            if (this.isDumpBinarioRichiesta()) {
                propertiesTrasportoDebug = new HashMap<String, List<String>>();
            }
            String contentTypeRichiesta = null;
            if (this.debug) {
                this.logger.debug("Impostazione content type...");
            }
            if (this.isSoap) {
                contentTypeRichiesta = this.sbustamentoSoap && soapMessageRequest.countAttachments() > 0 && TunnelSoapUtils.isTunnelOpenSPCoopSoap((OpenSPCoop2SoapMessage)soapMessageRequest) ? TunnelSoapUtils.getContentTypeTunnelOpenSPCoopSoap((SOAPBody)soapMessageRequest.getSOAPBody()) : this.requestMsg.getContentType();
                if (contentTypeRichiesta == null) {
                    throw new Exception("Content-Type del messaggio da spedire non definito");
                }
            } else {
                contentTypeRichiesta = this.requestMsg.getContentType();
            }
            if (this.debug) {
                this.logger.info("Impostazione Content-Type [" + contentTypeRichiesta + "]", false);
            }
            if (contentTypeRichiesta != null) {
                this.setRequestHeader("Content-Type", contentTypeRichiesta, this.logger, propertiesTrasportoDebug);
            }
            if (this.debug) {
                this.logger.debug("Impostazione timeout...");
            }
            if (this.properties.get("readConnectionTimeout") != null) {
                try {
                    readConnectionTimeout = Integer.parseInt((String)this.properties.get("readConnectionTimeout"));
                    readConnectionTimeoutConfigurazioneGlobale = this.properties.containsKey("readConnectionTimeoutGlobale");
                }
                catch (Exception e) {
                    this.logger.error("Parametro readConnectionTimeout errato", e);
                }
            }
            if (readConnectionTimeout == -1) {
                readConnectionTimeout = 120000;
            }
            if (this.debug) {
                this.logger.info("Impostazione read timeout [" + readConnectionTimeout + "]", false);
            }
            if (this.debug) {
                this.logger.debug("Impostazione header di trasporto...");
            }
            this.forwardHttpRequestHeader();
            if (this.propertiesTrasporto != null) {
                for (String key : this.propertiesTrasporto.keySet()) {
                    List values = (List)this.propertiesTrasporto.get(key);
                    if (this.debug && values != null && !values.isEmpty()) {
                        for (String value : values) {
                            this.logger.info("Set Transport Header [" + key + "]=[" + value + "]", false);
                        }
                    }
                    this.setRequestHeader(key, values, this.logger, propertiesTrasportoDebug);
                }
            }
            if (this.isSoap && !this.sbustamentoSoap) {
                if (this.debug) {
                    this.logger.debug("Impostazione soap action...");
                }
                boolean existsTransportProperties = false;
                if (TransportUtils.containsKey((Map)this.propertiesTrasporto, (String)"SOAPAction")) {
                    this.soapAction = TransportUtils.getFirstValue((Map)this.propertiesTrasporto, (String)"SOAPAction");
                    boolean bl = existsTransportProperties = this.soapAction != null;
                }
                if (!existsTransportProperties) {
                    this.soapAction = soapMessageRequest.getSoapAction();
                }
                if (this.soapAction == null) {
                    this.soapAction = "\"OpenSPCoop\"";
                }
                if (MessageType.SOAP_11.equals((Object)this.requestMsg.getMessageType()) && !existsTransportProperties) {
                    this.setRequestHeader("SOAPAction", this.soapAction, this.logger, propertiesTrasportoDebug);
                }
                if (this.debug) {
                    this.logger.info("SOAP Action inviata [" + this.soapAction + "]", false);
                }
            }
            boolean consumeRequestMessage = true;
            if (this.debug) {
                this.logger.debug("Serializzazione [" + this.outputFile.getOutputFile().getAbsolutePath() + "] (consume-request-message:" + consumeRequestMessage + ")...");
            }
            FileOutputStream out = new FileOutputStream(this.outputFile.getOutputFile());
            if (this.isDumpBinarioRichiesta()) {
                bout = new DumpByteArrayOutputStream(this.dumpBinarioSoglia, this.dumpBinarioRepositoryFile, this.idTransazione, TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO.getValue());
                try {
                    this.emitDiagnosticStartDumpBinarioRichiestaUscita();
                    if (this.isSoap && this.sbustamentoSoap) {
                        this.logger.debug("Sbustamento...");
                        TunnelSoapUtils.sbustamentoMessaggio((OpenSPCoop2Message)soapMessageRequest, (OutputStream)bout);
                    } else {
                        this.requestMsg.writeTo((OutputStream)bout, consumeRequestMessage);
                    }
                    bout.flush();
                    bout.close();
                    if (bout.isSerializedOnFileSystem()) {
                        try (FileInputStream fin = new FileInputStream(bout.getSerializedFile());){
                            Utilities.copy((InputStream)fin, (OutputStream)out);
                        }
                    } else {
                        ((OutputStream)out).write(bout.toByteArray());
                    }
                    out.flush();
                    ((OutputStream)out).close();
                    this.dataRichiestaInoltrata = DateManager.getDate();
                    this.dumpBinarioRichiestaUscita((DumpByteArrayOutputStream)bout, requestMessageType, contentTypeRichiesta, this.location, propertiesTrasportoDebug);
                }
                finally {
                    try {
                        bout.clearResources();
                    }
                    catch (Throwable t) {
                        this.logger.error("Release resources failed: " + t.getMessage(), t);
                    }
                }
            }
            if (this.isSoap && this.sbustamentoSoap) {
                if (this.debug) {
                    this.logger.debug("Sbustamento...");
                }
                TunnelSoapUtils.sbustamentoMessaggio((OpenSPCoop2Message)soapMessageRequest, (OutputStream)out);
            } else {
                this.requestMsg.writeTo((OutputStream)out, consumeRequestMessage);
            }
            out.flush();
            ((OutputStream)out).close();
            this.dataRichiestaInoltrata = DateManager.getDate();
            if (this.debug) {
                this.logger.debug("Serializzazione [" + this.outputFile.getOutputFile().getAbsolutePath() + "] effettuata");
            }
            if (this.outputFile.isPermission()) {
                if (this.debug) {
                    this.logger.debug("Modifica diritti del file [" + this.outputFile.getOutputFile().getAbsolutePath() + "] (" + this.outputFile.getPermissionAsString() + ") ...");
                }
                this.setPermission(this.outputFile);
                if (this.debug) {
                    this.logger.debug("Modifica diritti del file [" + this.outputFile.getOutputFile().getAbsolutePath() + "] (" + this.outputFile.getPermissionAsString() + ") effettuata");
                }
            }
            this.boutFileOutputHeaders.flush();
            this.boutFileOutputHeaders.close();
            if (this.outputFileHeaders != null) {
                if (this.debug) {
                    this.logger.debug("Serializzazione File Output Headers [" + this.outputFileHeaders.getOutputFile().getAbsolutePath() + "]...");
                }
                out = new FileOutputStream(this.outputFileHeaders.getOutputFile());
                if (this.debug) {
                    bout = new ByteArrayOutputStream();
                    ((OutputStream)bout).write(this.boutFileOutputHeaders.toByteArray());
                    ((OutputStream)bout).flush();
                    ((ByteArrayOutputStream)bout).close();
                    ((OutputStream)out).write(((ByteArrayOutputStream)bout).toByteArray());
                    this.logger.info("File Header Serializzato:\n" + ((ByteArrayOutputStream)bout).toString(), false);
                } else {
                    ((OutputStream)out).write(this.boutFileOutputHeaders.toByteArray());
                }
                out.flush();
                ((OutputStream)out).close();
                if (this.debug) {
                    this.logger.debug("Serializzazione File Output Headers [" + this.outputFileHeaders.getOutputFile().getAbsolutePath() + "] effettuata");
                }
                if (this.outputFileHeaders.isPermission()) {
                    if (this.debug) {
                        this.logger.debug("Modifica diritti del file [" + this.outputFileHeaders.getOutputFile().getAbsolutePath() + "] (" + this.outputFileHeaders.getPermissionAsString() + ") ...");
                    }
                    this.setPermission(this.outputFileHeaders);
                    if (this.debug) {
                        this.logger.debug("Modifica diritti del file [" + this.outputFileHeaders.getOutputFile().getAbsolutePath() + "] (" + this.outputFileHeaders.getPermissionAsString() + ") effettuata");
                    }
                }
            }
            this.postOutRequest();
            this.codice = 200;
            if (this.generateResponse) {
                this.preInResponse();
                this.notifierInputStreamParams = null;
                if (this.preInResponseContext != null) {
                    this.notifierInputStreamParams = this.preInResponseContext.getNotifierInputStreamParams();
                }
                this.checkInputFile(this.inputFile, RESPONSE);
                if (this.inputFileHeaders != null) {
                    this.checkInputFile(this.inputFileHeaders, RESPONSE_HEADERS);
                    this.propertiesTrasportoRisposta = new HashMap();
                    FileInputStream fin = new FileInputStream(this.inputFileHeaders);
                    try {
                        Properties pTmp = new Properties();
                        pTmp.load(fin);
                        if (pTmp.size() > 0) {
                            Enumeration<Object> en = pTmp.keys();
                            while (en.hasMoreElements()) {
                                Object oKey = en.nextElement();
                                if (!(oKey instanceof String)) continue;
                                String key = (String)oKey;
                                String value = pTmp.getProperty(key);
                                TransportUtils.addHeader((Map)this.propertiesTrasportoRisposta, (String)key, (String)value);
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new Exception("Input File (Response-Headers) [" + this.inputFileHeaders.getAbsolutePath() + "] with wrong format: " + e.getMessage(), e);
                    }
                    finally {
                        try {
                            if (fin != null) {
                                fin.close();
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
                if (this.debug) {
                    this.logger.debug("Analisi risposta...");
                }
                if (this.propertiesTrasportoRisposta != null && this.propertiesTrasportoRisposta.size() > 0) {
                    this.tipoRisposta = TransportUtils.getFirstValue((Map)this.propertiesTrasportoRisposta, (String)"Content-Type");
                }
                if (this.tipoRisposta == null || "".equals(this.tipoRisposta)) {
                    this.tipoRisposta = contentTypeRichiesta;
                    if (this.propertiesTrasportoRisposta == null) {
                        this.propertiesTrasportoRisposta = new HashMap();
                    }
                    TransportUtils.setHeader((Map)this.propertiesTrasportoRisposta, (String)"Content-Type", (String)this.tipoRisposta);
                }
                if (this.isSoap) {
                    this.imbustamentoConAttachment = false;
                    if (this.propertiesTrasportoRisposta != null && this.propertiesTrasportoRisposta.size() > 0) {
                        if ("true".equals(TransportUtils.getObjectAsString((Map)this.propertiesTrasportoRisposta, (String)this.openspcoopProperties.getTunnelSOAPKeyWord_headerTrasporto()))) {
                            this.imbustamentoConAttachment = true;
                        }
                        this.mimeTypeAttachment = TransportUtils.getFirstValue((Map)this.propertiesTrasportoRisposta, (String)this.openspcoopProperties.getTunnelSOAPKeyWordMimeType_headerTrasporto());
                        if (this.mimeTypeAttachment == null) {
                            this.mimeTypeAttachment = "application/openspcoop2";
                        }
                    }
                }
                this.isResponse = new FileInputStream(this.inputFile);
                this.normalizeInputStreamResponse(readConnectionTimeout, readConnectionTimeoutConfigurazioneGlobale);
                this.initCheckContentTypeConfiguration();
                if (this.isDumpBinarioRisposta()) {
                    this.dumpResponse(this.propertiesTrasportoRisposta);
                }
                if (this.isRest ? !this.doRestResponse() : !this.doSoapResponse()) {
                    return false;
                }
            }
            if (this.debug) {
                this.logger.info("Gestione consegna su file effettuata con successo", false);
            }
            return true;
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            String msgErrore = this.readExceptionMessageFromException(e);
            this.errore = this.generateErrorWithConnectorPrefix ? "Errore avvenuto durante la consegna su FileSystem: " + msgErrore : msgErrore;
            this.logger.error("Errore avvenuto durante la consegna su FileSystem: " + msgErrore, e);
            this.processReadTimeoutException(readConnectionTimeout, readConnectionTimeoutConfigurazioneGlobale, e, msgErrore);
            return false;
        }
    }

    @Override
    public void disconnect() throws ConnettoreException {
        ArrayList<Throwable> listExceptionChiusura = new ArrayList<Throwable>();
        try {
            if (this.isResponse != null) {
                if (this.debug && this.logger != null) {
                    this.logger.debug("Chiusura inputStream [" + this.inputFile.getAbsolutePath() + "] ...");
                }
                try {
                    this.isResponse.close();
                    if (this.debug && this.logger != null) {
                        this.logger.debug("Chiusura inputStream [" + this.inputFile.getAbsolutePath() + "] effettuata con successo");
                    }
                }
                catch (Throwable e) {
                    if (this.logger != null) {
                        this.logger.error("Chiusura inputStream [" + this.inputFile.getAbsolutePath() + "] non riuscita");
                    }
                    listExceptionChiusura.add(e);
                }
            }
            if (this.inputFile != null && this.inputFileDeleteAfterRead && this.inputFile.exists()) {
                if (this.debug && this.logger != null) {
                    this.logger.debug("Eliminazione File [" + this.inputFile.getAbsolutePath() + "] ...");
                }
                if (this.inputFile.delete()) {
                    if (this.debug && this.logger != null) {
                        this.logger.debug("Eliminazione File [" + this.inputFile.getAbsolutePath() + "] effettuata con successo");
                    }
                } else if (this.logger != null) {
                    this.logger.error("Eliminazione File [" + this.inputFile.getAbsolutePath() + "] non riuscita");
                }
            }
            if (this.inputFileHeaders != null && this.inputFileDeleteAfterRead && this.inputFileHeaders.exists()) {
                if (this.debug && this.logger != null) {
                    this.logger.debug("Eliminazione File [" + this.inputFileHeaders.getAbsolutePath() + "] ...");
                }
                if (this.inputFileHeaders.delete()) {
                    if (this.debug && this.logger != null) {
                        this.logger.debug("Eliminazione File [" + this.inputFileHeaders.getAbsolutePath() + "] effettuata con successo");
                    }
                } else if (this.logger != null) {
                    this.logger.error("Eliminazione File [" + this.inputFileHeaders.getAbsolutePath() + "] non riuscita");
                }
            }
            try {
                super.disconnect();
            }
            catch (Throwable t) {
                this.logger.debug("Chiusura risorse fallita: " + t.getMessage(), t);
                listExceptionChiusura.add(t);
            }
        }
        catch (Exception e) {
            throw new ConnettoreException("Chiusura non riuscita: " + e.getMessage(), e);
        }
        if (listExceptionChiusura != null && !listExceptionChiusura.isEmpty()) {
            UtilsMultiException multiException = new UtilsMultiException(listExceptionChiusura.toArray(new Throwable[1]));
            throw new ConnettoreException("Chiusura connessione non riuscita: " + multiException.getMessage(), multiException);
        }
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    private void setRequestHeader(String key, String value, ConnettoreLogger logger, Map<String, List<String>> propertiesTrasportoDebug) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add(value);
        this.setRequestHeader(key, list, logger, propertiesTrasportoDebug);
    }

    private void setRequestHeader(String key, List<String> values, ConnettoreLogger logger, Map<String, List<String>> propertiesTrasportoDebug) throws Exception {
        if (this.debug && values != null && !values.isEmpty()) {
            for (String value : values) {
                this.logger.info("Set propriet\u00e0 trasporto [" + key + "]=[" + value + "]", false);
            }
        }
        this.setRequestHeader(key, values, propertiesTrasportoDebug);
    }

    @Override
    protected void setRequestHeader(String key, List<String> values) throws ConnettoreException {
        if (values != null && !values.isEmpty()) {
            for (String value : values) {
                try {
                    this.boutFileOutputHeaders.write((key + "=" + value + "\n").getBytes());
                }
                catch (Exception e) {
                    throw new ConnettoreException(e.getMessage(), e);
                }
            }
        }
    }

    private void checkOutputFile(ConnettoreFile_outputConfig fileConfig, String tipo) throws Exception {
        File file = fileConfig.getOutputFile();
        if (this.debug) {
            this.logger.debug("Check file output (" + tipo + ") [" + file.getAbsolutePath() + "]...");
        }
        if (file.exists()) {
            if (this.debug) {
                this.logger.debug("File output (" + tipo + ") [" + file.getAbsolutePath() + "] exists canRead[" + file.canRead() + "] canWrite[" + file.canWrite() + "] canExcute[" + file.canExecute() + "] isDirectory[" + file.isDirectory() + "] isFile[" + file.isFile() + "] isHidden[" + file.isHidden() + "]");
            }
            if (!this.outputFileOverwriteIfExists) {
                throw new Exception("Output File (" + tipo + ") [" + file.getAbsolutePath() + "] already exists (overwrite not permitted)");
            }
            if (!file.isFile()) {
                throw new Exception("Output File (" + tipo + ") [" + file.getAbsolutePath() + "] already exists with uncorrect type (is Directory?)");
            }
            if (!file.canWrite()) {
                throw new Exception("Output File (" + tipo + ") [" + file.getAbsolutePath() + "] already exists (cannot rewrite)");
            }
        }
        if (this.debug) {
            this.logger.debug("(" + tipo + ") Check parent directory ...");
        }
        if (file.getParentFile() != null) {
            if (this.debug) {
                this.logger.debug("(" + tipo + ") Check parent directory [" + file.getParentFile().getAbsolutePath() + "] ...");
            }
            if (!file.getParentFile().exists()) {
                if (!this.outputFileAutoCreateParentDirectory) {
                    throw new Exception("Parent Directory Output File (" + tipo + ") [" + file.getParentFile().getAbsolutePath() + "] not exists (auto create not permitted)");
                }
                FileSystemUtilities.mkdirParentDirectory((File)file, (Boolean)fileConfig.getReadable(), (Boolean)fileConfig.getReadable_ownerOnly(), (Boolean)fileConfig.getWritable(), (Boolean)fileConfig.getWritable_ownerOnly(), (Boolean)fileConfig.getExecutable(), (Boolean)fileConfig.getExecutable_ownerOnly());
            } else {
                if (this.debug) {
                    this.logger.debug("Parent Directory Output File (" + tipo + ") [" + file.getParentFile().getAbsolutePath() + "] exists canRead[" + file.getParentFile().canRead() + "] canWrite[" + file.getParentFile().canWrite() + "] canExcute[" + file.getParentFile().canExecute() + "] isDirectory[" + file.getParentFile().isDirectory() + "] isFile[" + file.getParentFile().isFile() + "] isHidden[" + file.getParentFile().isHidden() + "]");
                }
                if (!file.getParentFile().isDirectory()) {
                    throw new Exception("Parent Directory Output File (" + tipo + ") [" + file.getParentFile().getAbsolutePath() + "] already exists with uncorrect type (is File?)");
                }
                if (!file.getParentFile().canWrite()) {
                    throw new Exception("Parent Directory Output File (" + tipo + ") [" + file.getParentFile().getAbsolutePath() + "] already exists (cannot rewrite)");
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkInputFile(File file, String tipo) throws Exception {
        if (this.debug) {
            this.logger.debug("Check file input (" + tipo + ") [" + file.getAbsolutePath() + "]...");
        }
        if (file.exists()) {
            this._checkInputFile(file, tipo);
            return;
        } else {
            int tempoSingoloSleepMs;
            if (this.inputFileWaitTimeIfNotExists == null || this.inputFileWaitTimeIfNotExists <= 0) throw new Exception("Input File (" + tipo + ") [" + file.getAbsolutePath() + "] not exists");
            int millisecond = this.inputFileWaitTimeIfNotExists;
            if (millisecond > (tempoSingoloSleepMs = 250)) {
                int count = millisecond / tempoSingoloSleepMs;
                int resto = millisecond % tempoSingoloSleepMs;
                this.logger.info("Wait " + millisecond + "ms ...", false);
                for (int i = 0; i < count; ++i) {
                    Utilities.sleep((long)tempoSingoloSleepMs);
                    if (file.exists()) break;
                }
                if (!file.exists()) {
                    Utilities.sleep((long)resto);
                }
                this.logger.info("Wait " + millisecond + "ms terminated", false);
            } else {
                this.logger.info("Wait " + millisecond + "ms ...", false);
                Utilities.sleep((long)tempoSingoloSleepMs);
                this.logger.info("Wait " + millisecond + "ms terminated", false);
            }
            if (!file.exists()) throw new Exception("Input File (" + tipo + ") [" + file.getAbsolutePath() + "] not exists (wait " + millisecond + "ms)");
            this._checkInputFile(file, tipo);
        }
    }

    private void _checkInputFile(File file, String tipo) throws Exception {
        if (this.debug) {
            this.logger.debug("File input (" + tipo + ") [" + file.getAbsolutePath() + "] exists canRead[" + file.canRead() + "] canWrite[" + file.canWrite() + "] canExcute[" + file.canExecute() + "] isDirectory[" + file.isDirectory() + "] isFile[" + file.isFile() + "] isHidden[" + file.isHidden() + "] lenght[" + file.length() + "]");
        }
        if (!file.isFile()) {
            throw new Exception("Input File (" + tipo + ") [" + file.getAbsolutePath() + "] with uncorrect type (is Directory?)");
        }
        if (!file.canRead()) {
            throw new Exception("Input File (" + tipo + ") [" + file.getAbsolutePath() + "] cannot read");
        }
        if (file.length() <= 0L) {
            throw new Exception("Input File (" + tipo + ") [" + file.getAbsolutePath() + "] empty");
        }
        if (this.inputFileDeleteAfterRead && !file.canWrite()) {
            throw new Exception("Input File (" + tipo + ") [" + file.getAbsolutePath() + "] cannot write (delete after read required)");
        }
    }

    private ConnettoreFile_outputConfig readOutputConfig(String tipoConnettore, boolean required, String file, String permission) throws ConnettoreException {
        String tmp = this.getDynamicProperty(tipoConnettore, required, file, this.dynamicMap);
        if (tmp == null) {
            return null;
        }
        ConnettoreFile_outputConfig c = new ConnettoreFile_outputConfig();
        c.setOutputFile(new File(tmp));
        String p = this.getDynamicProperty(tipoConnettore, false, permission, this.dynamicMap);
        if (p != null) {
            ConnettoreFILE.validatePermission(p, c);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validatePermission(String p, ConnettoreFile_outputConfig c) throws ConnettoreException {
        try (Scanner scanner = new Scanner(p);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line == null || line.trim().equals("") || line.trim().startsWith("#")) continue;
                ConnettoreFILE._validateSinglePermission(line, c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNumPermission(String p) throws ConnettoreException {
        int num = 0;
        try (Scanner scanner = new Scanner(p);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line == null || line.trim().equals("") || line.trim().startsWith("#")) continue;
                ++num;
            }
            int n = num;
            return n;
        }
    }

    private static void _validateSinglePermission(String p, ConnettoreFile_outputConfig config) throws ConnettoreException {
        String errorMsg = "Wrong permission format (" + p + "); expected [o/a]+/-rwx";
        if (p == null || StringUtils.isEmpty((CharSequence)p) || !p.contains("+") && !p.contains("-") || p.length() <= 1) {
            throw new ConnettoreException(errorMsg);
        }
        String permission = null;
        boolean add = false;
        Boolean owner = null;
        if (p.startsWith("+")) {
            permission = p.substring(1);
            add = true;
        } else if (p.startsWith("-")) {
            permission = p.substring(1);
            add = false;
        } else if (p.contains("+")) {
            add = true;
            indexOf = p.indexOf("+");
            ownerS = p.substring(0, indexOf);
            if (!"o".equals(ownerS) && !"a".equals(ownerS)) {
                throw new ConnettoreException(errorMsg);
            }
            if ("o".equals(ownerS)) {
                owner = true;
            } else if ("a".equals(ownerS)) {
                owner = false;
            }
            if (indexOf == p.length() - 1) {
                throw new ConnettoreException(errorMsg);
            }
            permission = p.substring(indexOf + 1, p.length());
        } else if (p.contains("-")) {
            add = false;
            indexOf = p.indexOf("-");
            ownerS = p.substring(0, indexOf);
            if (!"o".equals(ownerS) && !"a".equals(ownerS)) {
                throw new ConnettoreException(errorMsg);
            }
            if ("o".equals(ownerS)) {
                owner = true;
            } else if ("a".equals(ownerS)) {
                owner = false;
            }
            if (indexOf == p.length() - 1) {
                throw new ConnettoreException(errorMsg);
            }
            permission = p.substring(indexOf + 1, p.length());
        }
        if (permission != null) {
            for (int i = 0; i < permission.length(); ++i) {
                char c = permission.charAt(i);
                if (c == 'r' || c == 'R') {
                    config.setReadable(add);
                    if (owner == null) continue;
                    config.setReadable_ownerOnly(owner);
                    continue;
                }
                if (c == 'w' || c == 'W') {
                    config.setWritable(add);
                    if (owner == null) continue;
                    config.setWritable_ownerOnly(owner);
                    continue;
                }
                if (c == 'x' || c == 'X') {
                    config.setExecutable(add);
                    if (owner == null) continue;
                    config.setExecutable_ownerOnly(owner);
                    continue;
                }
                throw new ConnettoreException(errorMsg);
            }
        }
    }

    private void setPermission(ConnettoreFile_outputConfig config) throws ConnettoreException {
        if (config.getReadable() == null || (config.getReadable_ownerOnly() != null ? !config.getOutputFile().setReadable(config.getReadable(), config.getReadable_ownerOnly()) : !config.getOutputFile().setReadable(config.getReadable()))) {
            // empty if block
        }
        if (config.getWritable() == null || (config.getWritable_ownerOnly() != null ? !config.getOutputFile().setWritable(config.getWritable(), config.getWritable_ownerOnly()) : !config.getOutputFile().setWritable(config.getWritable()))) {
            // empty if block
        }
        if (config.getExecutable() == null || (config.getExecutable_ownerOnly() != null ? !config.getOutputFile().setExecutable(config.getExecutable(), config.getExecutable_ownerOnly()) : !config.getOutputFile().setExecutable(config.getExecutable()))) {
            // empty if block
        }
    }
}

