/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.config.DumpConfigurazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.transazioni.TransazioneApplicativoServer;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.connettori.ConnettoreLogger;
import org.openspcoop2.pdd.core.connettori.InfoConnettoreUscita;
import org.openspcoop2.pdd.logger.Dump;
import org.openspcoop2.pdd.services.connector.ConnectorException;
import org.openspcoop2.protocol.sdk.dump.DumpException;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;

public class DumpRaw {
    private ConnettoreLogger logger;
    private boolean pd;
    private Dump dump;
    private boolean dumpBinario;
    private boolean dumpBinario_registrazioneDatabase = false;
    private DumpConfigurazione dumpDatabaseConfigurazione;
    private boolean dumpDatabaseRichiestaUscitaHeaders;
    private boolean dumpDatabaseRichiestaUscitaPayload;
    private boolean dumpDatabaseRispostaIngressoHeaders;
    private boolean dumpDatabaseRispostaIngressoPayload;
    private boolean onlyLogFileTraceRichiestaUscitaHeaders = false;
    private boolean onlyLogFileTraceRichiestaUscitaPayload = false;
    private boolean onlyLogFileTraceRispostaIngressoHeaders = false;
    private boolean onlyLogFileTraceRispostaIngressoPayload = false;
    private IDSoggetto dominio;
    private String modulo;
    private TipoPdD tipoPdD;

    public DumpRaw(ConnettoreLogger log, IDSoggetto dominio, String modulo, TipoPdD tipoPdD, boolean dumpBinario, DumpConfigurazione dumpConfigurazione, boolean fileTraceHeaders, boolean fileTracePayload) throws ConnectorException {
        this.logger = log;
        switch (tipoPdD) {
            case DELEGATA: {
                this.pd = true;
                break;
            }
            default: {
                this.pd = false;
            }
        }
        this.dumpBinario = dumpBinario;
        if (this.dumpBinario) {
            this.dumpBinario_registrazioneDatabase = OpenSPCoop2Properties.getInstance().isDumpBinarioRegistrazioneDatabase();
        }
        if (dumpConfigurazione != null) {
            boolean payloadParsing;
            if (dumpConfigurazione.getRichiestaUscita() != null) {
                boolean bl = payloadParsing = StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRichiestaUscita().getPayload()) && StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRichiestaUscita().getPayloadParsing());
                if (!payloadParsing) {
                    if (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRichiestaUscita().getHeaders())) {
                        this.dumpDatabaseRichiestaUscitaHeaders = true;
                    }
                    if (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRichiestaUscita().getPayload())) {
                        this.dumpDatabaseRichiestaUscitaPayload = true;
                    }
                }
            }
            if (dumpConfigurazione.getRispostaIngresso() != null) {
                boolean bl = payloadParsing = StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRispostaIngresso().getPayload()) && StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRispostaIngresso().getPayloadParsing());
                if (!payloadParsing) {
                    if (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRispostaIngresso().getHeaders())) {
                        this.dumpDatabaseRispostaIngressoHeaders = true;
                    }
                    if (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRispostaIngresso().getPayload())) {
                        this.dumpDatabaseRispostaIngressoPayload = true;
                    }
                }
            }
            this.dumpDatabaseConfigurazione = dumpConfigurazione;
        }
        if (!(this.dumpDatabaseRichiestaUscitaHeaders || dumpBinario && this.dumpBinario_registrazioneDatabase)) {
            this.onlyLogFileTraceRichiestaUscitaHeaders = fileTraceHeaders;
        }
        if (!(this.dumpDatabaseRichiestaUscitaPayload || dumpBinario && this.dumpBinario_registrazioneDatabase)) {
            this.onlyLogFileTraceRichiestaUscitaPayload = fileTracePayload;
        }
        if (!(this.dumpDatabaseRispostaIngressoHeaders || dumpBinario && this.dumpBinario_registrazioneDatabase)) {
            this.onlyLogFileTraceRispostaIngressoHeaders = fileTraceHeaders;
        }
        if (!(this.dumpDatabaseRispostaIngressoPayload || dumpBinario && this.dumpBinario_registrazioneDatabase)) {
            this.onlyLogFileTraceRispostaIngressoPayload = fileTracePayload;
        }
        this.dominio = dominio;
        this.modulo = modulo;
        this.tipoPdD = tipoPdD;
    }

    public boolean isActiveDumpDatabase() {
        return this.isDumpBinarioRegistrazioneDatabase() || this.isRegistrazioneDatabase() || this.onlyLogFileTrace();
    }

    public boolean isActiveDumpDatabaseRichiesta() {
        return this.dumpBinario || this.isRegistrazioneDatabaseRichiesta() || this.onlyLogFileTraceRichiesta();
    }

    public boolean isActiveDumpDatabaseRisposta() {
        return this.dumpBinario || this.isRegistrazioneDatabaseRisposta() || this.onlyLogFileTraceRisposta();
    }

    private boolean isRegistrazioneDatabase() {
        return this.isRegistrazioneDatabaseRichiesta() || this.isRegistrazioneDatabaseRisposta();
    }

    private boolean isRegistrazioneDatabaseRichiesta() {
        return this.dumpDatabaseRichiestaUscitaHeaders || this.dumpDatabaseRichiestaUscitaPayload;
    }

    private boolean isRegistrazioneDatabaseRisposta() {
        return this.dumpDatabaseRispostaIngressoHeaders || this.dumpDatabaseRispostaIngressoPayload;
    }

    private boolean onlyLogFileTrace() {
        return this.onlyLogFileTraceRichiesta() || this.onlyLogFileTraceRisposta();
    }

    private boolean onlyLogFileTraceRichiesta() {
        return this.onlyLogFileTraceRichiestaUscitaHeaders || this.onlyLogFileTraceRichiestaUscitaPayload || this.onlyLogFileTraceRispostaIngressoHeaders || this.onlyLogFileTraceRispostaIngressoPayload;
    }

    private boolean onlyLogFileTraceRisposta() {
        return this.onlyLogFileTraceRichiestaUscitaHeaders || this.onlyLogFileTraceRichiestaUscitaPayload || this.onlyLogFileTraceRispostaIngressoHeaders || this.onlyLogFileTraceRispostaIngressoPayload;
    }

    private boolean isDumpBinarioRegistrazioneDatabase() {
        return this.dumpBinario && this.dumpBinario_registrazioneDatabase;
    }

    public void initDump(String interfaceName, PdDContext pddContext) throws DumpException {
        this.initDump(interfaceName, pddContext, null, null, null);
    }

    public void initDump(String interfaceName, PdDContext pddContext, TransazioneApplicativoServer transazioneApplicativoServer, IDPortaApplicativa idPA, Date dataConsegnaTransazioneApplicativoServer) throws DumpException {
        if (!this.isActiveDumpDatabase()) {
            return;
        }
        if (this.isRegistrazioneDatabase() || this.isDumpBinarioRegistrazioneDatabase() || this.onlyLogFileTrace()) {
            this.dump = new Dump(this.dominio, this.modulo, this.tipoPdD, interfaceName, pddContext, this.dumpDatabaseConfigurazione);
            if (transazioneApplicativoServer != null) {
                this.dump.setTransazioneApplicativoServer(transazioneApplicativoServer, idPA, dataConsegnaTransazioneApplicativoServer);
            }
        }
    }

    public void emitDiagnosticStartDumpBinarioRichiestaUscita() {
        if (!this.isActiveDumpDatabaseRichiesta()) {
            return;
        }
        if (this.dump != null) {
            boolean onlyFileTrace = !this.isRegistrazioneDatabaseRichiesta();
            this.dump.emitDiagnosticStartDumpBinarioRichiestaUscita(onlyFileTrace);
        }
    }

    public void dumpRequest(DumpByteArrayOutputStream content, MessageType messageType, InfoConnettoreUscita infoConnettoreUscita) throws DumpException {
        if (!this.isActiveDumpDatabaseRichiesta()) {
            return;
        }
        if (this.dump != null) {
            this.dump.dumpBinarioRichiestaUscita(this.isDumpBinarioRegistrazioneDatabase(), this.onlyLogFileTraceRichiestaUscitaHeaders, this.onlyLogFileTraceRichiestaUscitaPayload, content, messageType, infoConnettoreUscita);
        }
    }

    public void emitDiagnosticStartDumpBinarioRispostaIngresso() {
        if (!this.isActiveDumpDatabaseRisposta()) {
            return;
        }
        if (this.dump != null) {
            boolean onlyFileTrace = !this.isRegistrazioneDatabaseRisposta();
            this.dump.emitDiagnosticStartDumpBinarioRispostaIngresso(onlyFileTrace);
        }
    }

    public void dumpResponse(DumpByteArrayOutputStream content, MessageType messageType, InfoConnettoreUscita infoConnettoreUscita, Map<String, List<String>> trasportoRisposta) throws DumpException {
        if (!this.isActiveDumpDatabaseRisposta()) {
            return;
        }
        if (this.dump != null) {
            this.dump.dumpBinarioRispostaIngresso(this.isDumpBinarioRegistrazioneDatabase(), this.onlyLogFileTraceRispostaIngressoHeaders, this.onlyLogFileTraceRispostaIngressoPayload, content, messageType, infoConnettoreUscita, trasportoRisposta);
        }
    }
}

